# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CreateResourceSupportedProperties(_serialization.Model):
    """Datadog resource can be created or not properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The ARM id of the subscription.
    :vartype name: str
    :ivar creation_supported: Indicates if selected subscription supports Datadog resource
     creation, if not it is already being monitored for the selected organization via multi
     subscription feature.
    :vartype creation_supported: bool
    """

    _validation = {
        "name": {"readonly": True},
        "creation_supported": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "creation_supported": {"key": "creationSupported", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.creation_supported = None


class CreateResourceSupportedResponse(_serialization.Model):
    """Datadog resource can be created or not.

    :ivar properties: Represents the properties of the resource.
    :vartype properties: ~azure.mgmt.datadog.models.CreateResourceSupportedProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "CreateResourceSupportedProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.CreateResourceSupportedProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Represents the properties of the resource.
        :paramtype properties: ~azure.mgmt.datadog.models.CreateResourceSupportedProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class CreateResourceSupportedResponseList(_serialization.Model):
    """CreateResourceSupportedResponseList.

    :ivar value:
    :vartype value: list[~azure.mgmt.datadog.models.CreateResourceSupportedResponse]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CreateResourceSupportedResponse]"},
    }

    def __init__(
        self, *, value: Optional[List["_models.CreateResourceSupportedResponse"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.datadog.models.CreateResourceSupportedResponse]
        """
        super().__init__(**kwargs)
        self.value = value


class DatadogAgreementProperties(_serialization.Model):
    """Terms properties.

    :ivar publisher: Publisher identifier string.
    :vartype publisher: str
    :ivar product: Product identifier string.
    :vartype product: str
    :ivar plan: Plan identifier string.
    :vartype plan: str
    :ivar license_text_link: Link to HTML with Microsoft and Publisher terms.
    :vartype license_text_link: str
    :ivar privacy_policy_link: Link to the privacy policy of the publisher.
    :vartype privacy_policy_link: str
    :ivar retrieve_datetime: Date and time in UTC of when the terms were accepted. This is empty if
     Accepted is false.
    :vartype retrieve_datetime: ~datetime.datetime
    :ivar signature: Terms signature.
    :vartype signature: str
    :ivar accepted: If any version of the terms have been accepted, otherwise false.
    :vartype accepted: bool
    """

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "plan": {"key": "plan", "type": "str"},
        "license_text_link": {"key": "licenseTextLink", "type": "str"},
        "privacy_policy_link": {"key": "privacyPolicyLink", "type": "str"},
        "retrieve_datetime": {"key": "retrieveDatetime", "type": "iso-8601"},
        "signature": {"key": "signature", "type": "str"},
        "accepted": {"key": "accepted", "type": "bool"},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        plan: Optional[str] = None,
        license_text_link: Optional[str] = None,
        privacy_policy_link: Optional[str] = None,
        retrieve_datetime: Optional[datetime.datetime] = None,
        signature: Optional[str] = None,
        accepted: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher: Publisher identifier string.
        :paramtype publisher: str
        :keyword product: Product identifier string.
        :paramtype product: str
        :keyword plan: Plan identifier string.
        :paramtype plan: str
        :keyword license_text_link: Link to HTML with Microsoft and Publisher terms.
        :paramtype license_text_link: str
        :keyword privacy_policy_link: Link to the privacy policy of the publisher.
        :paramtype privacy_policy_link: str
        :keyword retrieve_datetime: Date and time in UTC of when the terms were accepted. This is empty
         if Accepted is false.
        :paramtype retrieve_datetime: ~datetime.datetime
        :keyword signature: Terms signature.
        :paramtype signature: str
        :keyword accepted: If any version of the terms have been accepted, otherwise false.
        :paramtype accepted: bool
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.product = product
        self.plan = plan
        self.license_text_link = license_text_link
        self.privacy_policy_link = privacy_policy_link
        self.retrieve_datetime = retrieve_datetime
        self.signature = signature
        self.accepted = accepted


class DatadogAgreementResource(_serialization.Model):
    """DatadogAgreementResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ARM id of the resource.
    :vartype id: str
    :ivar name: Name of the agreement.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar properties: Represents the properties of the resource.
    :vartype properties: ~azure.mgmt.datadog.models.DatadogAgreementProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.datadog.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "DatadogAgreementProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, *, properties: Optional["_models.DatadogAgreementProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Represents the properties of the resource.
        :paramtype properties: ~azure.mgmt.datadog.models.DatadogAgreementProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties
        self.system_data = None


class DatadogAgreementResourceListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.datadog.models.DatadogAgreementResource]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DatadogAgreementResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.DatadogAgreementResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.datadog.models.DatadogAgreementResource]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DatadogApiKey(_serialization.Model):
    """DatadogApiKey.

    All required parameters must be populated in order to send to Azure.

    :ivar created_by: The user that created the API key.
    :vartype created_by: str
    :ivar name: The name of the API key.
    :vartype name: str
    :ivar key: The value of the API key. Required.
    :vartype key: str
    :ivar created: The time of creation of the API key.
    :vartype created: str
    """

    _validation = {
        "key": {"required": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "created": {"key": "created", "type": "str"},
    }

    def __init__(
        self,
        *,
        key: str,
        created_by: Optional[str] = None,
        name: Optional[str] = None,
        created: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The user that created the API key.
        :paramtype created_by: str
        :keyword name: The name of the API key.
        :paramtype name: str
        :keyword key: The value of the API key. Required.
        :paramtype key: str
        :keyword created: The time of creation of the API key.
        :paramtype created: str
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.name = name
        self.key = key
        self.created = created


class DatadogApiKeyListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.datadog.models.DatadogApiKey]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DatadogApiKey]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.DatadogApiKey"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.datadog.models.DatadogApiKey]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DatadogHost(_serialization.Model):
    """DatadogHost.

    :ivar name: The name of the host.
    :vartype name: str
    :ivar aliases: The aliases for the host installed via the Datadog agent.
    :vartype aliases: list[str]
    :ivar apps: The Datadog integrations reporting metrics for the host.
    :vartype apps: list[str]
    :ivar meta:
    :vartype meta: ~azure.mgmt.datadog.models.DatadogHostMetadata
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "aliases": {"key": "aliases", "type": "[str]"},
        "apps": {"key": "apps", "type": "[str]"},
        "meta": {"key": "meta", "type": "DatadogHostMetadata"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        aliases: Optional[List[str]] = None,
        apps: Optional[List[str]] = None,
        meta: Optional["_models.DatadogHostMetadata"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the host.
        :paramtype name: str
        :keyword aliases: The aliases for the host installed via the Datadog agent.
        :paramtype aliases: list[str]
        :keyword apps: The Datadog integrations reporting metrics for the host.
        :paramtype apps: list[str]
        :keyword meta:
        :paramtype meta: ~azure.mgmt.datadog.models.DatadogHostMetadata
        """
        super().__init__(**kwargs)
        self.name = name
        self.aliases = aliases
        self.apps = apps
        self.meta = meta


class DatadogHostListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.datadog.models.DatadogHost]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DatadogHost]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.DatadogHost"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.datadog.models.DatadogHost]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DatadogHostMetadata(_serialization.Model):
    """DatadogHostMetadata.

    :ivar agent_version: The agent version.
    :vartype agent_version: str
    :ivar install_method:
    :vartype install_method: ~azure.mgmt.datadog.models.DatadogInstallMethod
    :ivar logs_agent:
    :vartype logs_agent: ~azure.mgmt.datadog.models.DatadogLogsAgent
    """

    _attribute_map = {
        "agent_version": {"key": "agentVersion", "type": "str"},
        "install_method": {"key": "installMethod", "type": "DatadogInstallMethod"},
        "logs_agent": {"key": "logsAgent", "type": "DatadogLogsAgent"},
    }

    def __init__(
        self,
        *,
        agent_version: Optional[str] = None,
        install_method: Optional["_models.DatadogInstallMethod"] = None,
        logs_agent: Optional["_models.DatadogLogsAgent"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword agent_version: The agent version.
        :paramtype agent_version: str
        :keyword install_method:
        :paramtype install_method: ~azure.mgmt.datadog.models.DatadogInstallMethod
        :keyword logs_agent:
        :paramtype logs_agent: ~azure.mgmt.datadog.models.DatadogLogsAgent
        """
        super().__init__(**kwargs)
        self.agent_version = agent_version
        self.install_method = install_method
        self.logs_agent = logs_agent


class DatadogInstallMethod(_serialization.Model):
    """DatadogInstallMethod.

    :ivar tool: The tool.
    :vartype tool: str
    :ivar tool_version: The tool version.
    :vartype tool_version: str
    :ivar installer_version: The installer version.
    :vartype installer_version: str
    """

    _attribute_map = {
        "tool": {"key": "tool", "type": "str"},
        "tool_version": {"key": "toolVersion", "type": "str"},
        "installer_version": {"key": "installerVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        tool: Optional[str] = None,
        tool_version: Optional[str] = None,
        installer_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tool: The tool.
        :paramtype tool: str
        :keyword tool_version: The tool version.
        :paramtype tool_version: str
        :keyword installer_version: The installer version.
        :paramtype installer_version: str
        """
        super().__init__(**kwargs)
        self.tool = tool
        self.tool_version = tool_version
        self.installer_version = installer_version


class DatadogLogsAgent(_serialization.Model):
    """DatadogLogsAgent.

    :ivar transport: The transport.
    :vartype transport: str
    """

    _attribute_map = {
        "transport": {"key": "transport", "type": "str"},
    }

    def __init__(self, *, transport: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword transport: The transport.
        :paramtype transport: str
        """
        super().__init__(**kwargs)
        self.transport = transport


class DatadogMonitorResource(_serialization.Model):
    """DatadogMonitorResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: ARM id of the monitor resource.
    :vartype id: str
    :ivar name: Name of the monitor resource.
    :vartype name: str
    :ivar type: The type of the monitor resource.
    :vartype type: str
    :ivar sku:
    :vartype sku: ~azure.mgmt.datadog.models.ResourceSku
    :ivar properties: Properties specific to the monitor resource.
    :vartype properties: ~azure.mgmt.datadog.models.MonitorProperties
    :ivar identity:
    :vartype identity: ~azure.mgmt.datadog.models.IdentityProperties
    :ivar tags: Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar location: Required.
    :vartype location: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.datadog.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku": {"key": "sku", "type": "ResourceSku"},
        "properties": {"key": "properties", "type": "MonitorProperties"},
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: Optional["_models.ResourceSku"] = None,
        properties: Optional["_models.MonitorProperties"] = None,
        identity: Optional["_models.IdentityProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku:
        :paramtype sku: ~azure.mgmt.datadog.models.ResourceSku
        :keyword properties: Properties specific to the monitor resource.
        :paramtype properties: ~azure.mgmt.datadog.models.MonitorProperties
        :keyword identity:
        :paramtype identity: ~azure.mgmt.datadog.models.IdentityProperties
        :keyword tags: Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword location: Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.sku = sku
        self.properties = properties
        self.identity = identity
        self.tags = tags
        self.location = location
        self.system_data = None


class DatadogMonitorResourceListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.datadog.models.DatadogMonitorResource]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DatadogMonitorResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.DatadogMonitorResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.datadog.models.DatadogMonitorResource]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DatadogMonitorResourceUpdateParameters(_serialization.Model):
    """The parameters for a PATCH request to a monitor resource.

    :ivar properties: The set of properties that can be update in a PATCH request to a monitor
     resource.
    :vartype properties: ~azure.mgmt.datadog.models.MonitorUpdateProperties
    :ivar tags: The new tags of the monitor resource.
    :vartype tags: dict[str, str]
    :ivar sku:
    :vartype sku: ~azure.mgmt.datadog.models.ResourceSku
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "MonitorUpdateProperties"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "ResourceSku"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.MonitorUpdateProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.ResourceSku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: The set of properties that can be update in a PATCH request to a monitor
         resource.
        :paramtype properties: ~azure.mgmt.datadog.models.MonitorUpdateProperties
        :keyword tags: The new tags of the monitor resource.
        :paramtype tags: dict[str, str]
        :keyword sku:
        :paramtype sku: ~azure.mgmt.datadog.models.ResourceSku
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.tags = tags
        self.sku = sku


class DatadogOrganizationProperties(_serialization.Model):
    """Specify the Datadog organization name. In the case of linking to existing organizations, Id,
    ApiKey, and Applicationkey is required as well.

    :ivar name: Name of the Datadog organization.
    :vartype name: str
    :ivar id: Id of the Datadog organization.
    :vartype id: str
    :ivar linking_auth_code: The auth code used to linking to an existing Datadog organization.
    :vartype linking_auth_code: str
    :ivar linking_client_id: The client_id from an existing in exchange for an auth token to link
     organization.
    :vartype linking_client_id: str
    :ivar redirect_uri: The redirect URI for linking.
    :vartype redirect_uri: str
    :ivar api_key: Api key associated to the Datadog organization.
    :vartype api_key: str
    :ivar application_key: Application key associated to the Datadog organization.
    :vartype application_key: str
    :ivar enterprise_app_id: The Id of the Enterprise App used for Single sign on.
    :vartype enterprise_app_id: str
    :ivar cspm: The configuration which describes the state of cloud security posture management.
     This collects configuration information for all resources in a subscription and track
     conformance to industry benchmarks.
    :vartype cspm: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "linking_auth_code": {"key": "linkingAuthCode", "type": "str"},
        "linking_client_id": {"key": "linkingClientId", "type": "str"},
        "redirect_uri": {"key": "redirectUri", "type": "str"},
        "api_key": {"key": "apiKey", "type": "str"},
        "application_key": {"key": "applicationKey", "type": "str"},
        "enterprise_app_id": {"key": "enterpriseAppId", "type": "str"},
        "cspm": {"key": "cspm", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        linking_auth_code: Optional[str] = None,
        linking_client_id: Optional[str] = None,
        redirect_uri: Optional[str] = None,
        api_key: Optional[str] = None,
        application_key: Optional[str] = None,
        enterprise_app_id: Optional[str] = None,
        cspm: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the Datadog organization.
        :paramtype name: str
        :keyword id: Id of the Datadog organization.
        :paramtype id: str
        :keyword linking_auth_code: The auth code used to linking to an existing Datadog organization.
        :paramtype linking_auth_code: str
        :keyword linking_client_id: The client_id from an existing in exchange for an auth token to
         link organization.
        :paramtype linking_client_id: str
        :keyword redirect_uri: The redirect URI for linking.
        :paramtype redirect_uri: str
        :keyword api_key: Api key associated to the Datadog organization.
        :paramtype api_key: str
        :keyword application_key: Application key associated to the Datadog organization.
        :paramtype application_key: str
        :keyword enterprise_app_id: The Id of the Enterprise App used for Single sign on.
        :paramtype enterprise_app_id: str
        :keyword cspm: The configuration which describes the state of cloud security posture
         management. This collects configuration information for all resources in a subscription and
         track conformance to industry benchmarks.
        :paramtype cspm: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.linking_auth_code = linking_auth_code
        self.linking_client_id = linking_client_id
        self.redirect_uri = redirect_uri
        self.api_key = api_key
        self.application_key = application_key
        self.enterprise_app_id = enterprise_app_id
        self.cspm = cspm


class DatadogSetPasswordLink(_serialization.Model):
    """DatadogSetPasswordLink.

    :ivar set_password_link:
    :vartype set_password_link: str
    """

    _attribute_map = {
        "set_password_link": {"key": "setPasswordLink", "type": "str"},
    }

    def __init__(self, *, set_password_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword set_password_link:
        :paramtype set_password_link: str
        """
        super().__init__(**kwargs)
        self.set_password_link = set_password_link


class DatadogSingleSignOnProperties(_serialization.Model):
    """DatadogSingleSignOnProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Known values are: "Accepted", "Creating", "Updating", "Deleting",
     "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.datadog.models.ProvisioningState
    :ivar single_sign_on_state: Various states of the SSO resource. Known values are: "Initial",
     "Enable", "Disable", and "Existing".
    :vartype single_sign_on_state: str or ~azure.mgmt.datadog.models.SingleSignOnStates
    :ivar enterprise_app_id: The Id of the Enterprise App used for Single sign-on.
    :vartype enterprise_app_id: str
    :ivar single_sign_on_url: The login URL specific to this Datadog Organization.
    :vartype single_sign_on_url: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "single_sign_on_url": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "single_sign_on_state": {"key": "singleSignOnState", "type": "str"},
        "enterprise_app_id": {"key": "enterpriseAppId", "type": "str"},
        "single_sign_on_url": {"key": "singleSignOnUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        single_sign_on_state: Optional[Union[str, "_models.SingleSignOnStates"]] = None,
        enterprise_app_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword single_sign_on_state: Various states of the SSO resource. Known values are: "Initial",
         "Enable", "Disable", and "Existing".
        :paramtype single_sign_on_state: str or ~azure.mgmt.datadog.models.SingleSignOnStates
        :keyword enterprise_app_id: The Id of the Enterprise App used for Single sign-on.
        :paramtype enterprise_app_id: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.single_sign_on_state = single_sign_on_state
        self.enterprise_app_id = enterprise_app_id
        self.single_sign_on_url = None


class DatadogSingleSignOnResource(_serialization.Model):
    """DatadogSingleSignOnResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ARM id of the resource.
    :vartype id: str
    :ivar name: Name of the configuration.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar properties:
    :vartype properties: ~azure.mgmt.datadog.models.DatadogSingleSignOnProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.datadog.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "DatadogSingleSignOnProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, *, properties: Optional["_models.DatadogSingleSignOnProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties:
        :paramtype properties: ~azure.mgmt.datadog.models.DatadogSingleSignOnProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties
        self.system_data = None


class DatadogSingleSignOnResourceListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.datadog.models.DatadogSingleSignOnResource]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DatadogSingleSignOnResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.DatadogSingleSignOnResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.datadog.models.DatadogSingleSignOnResource]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.datadog.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.datadog.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.datadog.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.datadog.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class FilteringTag(_serialization.Model):
    """The definition of a filtering tag. Filtering tags are used for capturing resources and
    include/exclude them from being monitored.

    :ivar name: The name (also known as the key) of the tag.
    :vartype name: str
    :ivar value: The value of the tag.
    :vartype value: str
    :ivar action: Valid actions for a filtering tag. Exclusion takes priority over inclusion. Known
     values are: "Include" and "Exclude".
    :vartype action: str or ~azure.mgmt.datadog.models.TagAction
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        action: Optional[Union[str, "_models.TagAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name (also known as the key) of the tag.
        :paramtype name: str
        :keyword value: The value of the tag.
        :paramtype value: str
        :keyword action: Valid actions for a filtering tag. Exclusion takes priority over inclusion.
         Known values are: "Include" and "Exclude".
        :paramtype action: str or ~azure.mgmt.datadog.models.TagAction
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.action = action


class IdentityProperties(_serialization.Model):
    """IdentityProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The identity ID.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: Specifies the identity type of the Datadog Monitor. At this time the only allowed
     value is 'SystemAssigned'. Known values are: "SystemAssigned" and "UserAssigned".
    :vartype type: str or ~azure.mgmt.datadog.models.ManagedIdentityTypes
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.ManagedIdentityTypes"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: Specifies the identity type of the Datadog Monitor. At this time the only
         allowed value is 'SystemAssigned'. Known values are: "SystemAssigned" and "UserAssigned".
        :paramtype type: str or ~azure.mgmt.datadog.models.ManagedIdentityTypes
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class LinkedResource(_serialization.Model):
    """The definition of a linked resource.

    :ivar id: The ARM id of the linked resource.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The ARM id of the linked resource.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class LinkedResourceListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.datadog.models.LinkedResource]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[LinkedResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.LinkedResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.datadog.models.LinkedResource]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LogRules(_serialization.Model):
    """Set of rules for sending logs for the Monitor resource.

    :ivar send_aad_logs: Flag specifying if AAD logs should be sent for the Monitor resource.
    :vartype send_aad_logs: bool
    :ivar send_subscription_logs: Flag specifying if Azure subscription logs should be sent for the
     Monitor resource.
    :vartype send_subscription_logs: bool
    :ivar send_resource_logs: Flag specifying if Azure resource logs should be sent for the Monitor
     resource.
    :vartype send_resource_logs: bool
    :ivar filtering_tags: List of filtering tags to be used for capturing logs. This only takes
     effect if SendResourceLogs flag is enabled. If empty, all resources will be captured. If only
     Exclude action is specified, the rules will apply to the list of all available resources. If
     Include actions are specified, the rules will only include resources with the associated tags.
    :vartype filtering_tags: list[~azure.mgmt.datadog.models.FilteringTag]
    """

    _attribute_map = {
        "send_aad_logs": {"key": "sendAadLogs", "type": "bool"},
        "send_subscription_logs": {"key": "sendSubscriptionLogs", "type": "bool"},
        "send_resource_logs": {"key": "sendResourceLogs", "type": "bool"},
        "filtering_tags": {"key": "filteringTags", "type": "[FilteringTag]"},
    }

    def __init__(
        self,
        *,
        send_aad_logs: Optional[bool] = None,
        send_subscription_logs: Optional[bool] = None,
        send_resource_logs: Optional[bool] = None,
        filtering_tags: Optional[List["_models.FilteringTag"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword send_aad_logs: Flag specifying if AAD logs should be sent for the Monitor resource.
        :paramtype send_aad_logs: bool
        :keyword send_subscription_logs: Flag specifying if Azure subscription logs should be sent for
         the Monitor resource.
        :paramtype send_subscription_logs: bool
        :keyword send_resource_logs: Flag specifying if Azure resource logs should be sent for the
         Monitor resource.
        :paramtype send_resource_logs: bool
        :keyword filtering_tags: List of filtering tags to be used for capturing logs. This only takes
         effect if SendResourceLogs flag is enabled. If empty, all resources will be captured. If only
         Exclude action is specified, the rules will apply to the list of all available resources. If
         Include actions are specified, the rules will only include resources with the associated tags.
        :paramtype filtering_tags: list[~azure.mgmt.datadog.models.FilteringTag]
        """
        super().__init__(**kwargs)
        self.send_aad_logs = send_aad_logs
        self.send_subscription_logs = send_subscription_logs
        self.send_resource_logs = send_resource_logs
        self.filtering_tags = filtering_tags


class MetricRules(_serialization.Model):
    """Set of rules for sending metrics for the Monitor resource.

    :ivar filtering_tags: List of filtering tags to be used for capturing metrics. If empty, all
     resources will be captured. If only Exclude action is specified, the rules will apply to the
     list of all available resources. If Include actions are specified, the rules will only include
     resources with the associated tags.
    :vartype filtering_tags: list[~azure.mgmt.datadog.models.FilteringTag]
    """

    _attribute_map = {
        "filtering_tags": {"key": "filteringTags", "type": "[FilteringTag]"},
    }

    def __init__(self, *, filtering_tags: Optional[List["_models.FilteringTag"]] = None, **kwargs: Any) -> None:
        """
        :keyword filtering_tags: List of filtering tags to be used for capturing metrics. If empty, all
         resources will be captured. If only Exclude action is specified, the rules will apply to the
         list of all available resources. If Include actions are specified, the rules will only include
         resources with the associated tags.
        :paramtype filtering_tags: list[~azure.mgmt.datadog.models.FilteringTag]
        """
        super().__init__(**kwargs)
        self.filtering_tags = filtering_tags


class MonitoredResource(_serialization.Model):
    """The properties of a resource currently being monitored by the Datadog monitor resource.

    :ivar id: The ARM id of the resource.
    :vartype id: str
    :ivar sending_metrics: Flag indicating if resource is sending metrics to Datadog.
    :vartype sending_metrics: bool
    :ivar reason_for_metrics_status: Reason for why the resource is sending metrics (or why it is
     not sending).
    :vartype reason_for_metrics_status: str
    :ivar sending_logs: Flag indicating if resource is sending logs to Datadog.
    :vartype sending_logs: bool
    :ivar reason_for_logs_status: Reason for why the resource is sending logs (or why it is not
     sending).
    :vartype reason_for_logs_status: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "sending_metrics": {"key": "sendingMetrics", "type": "bool"},
        "reason_for_metrics_status": {"key": "reasonForMetricsStatus", "type": "str"},
        "sending_logs": {"key": "sendingLogs", "type": "bool"},
        "reason_for_logs_status": {"key": "reasonForLogsStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        sending_metrics: Optional[bool] = None,
        reason_for_metrics_status: Optional[str] = None,
        sending_logs: Optional[bool] = None,
        reason_for_logs_status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ARM id of the resource.
        :paramtype id: str
        :keyword sending_metrics: Flag indicating if resource is sending metrics to Datadog.
        :paramtype sending_metrics: bool
        :keyword reason_for_metrics_status: Reason for why the resource is sending metrics (or why it
         is not sending).
        :paramtype reason_for_metrics_status: str
        :keyword sending_logs: Flag indicating if resource is sending logs to Datadog.
        :paramtype sending_logs: bool
        :keyword reason_for_logs_status: Reason for why the resource is sending logs (or why it is not
         sending).
        :paramtype reason_for_logs_status: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.sending_metrics = sending_metrics
        self.reason_for_metrics_status = reason_for_metrics_status
        self.sending_logs = sending_logs
        self.reason_for_logs_status = reason_for_logs_status


class MonitoredResourceListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.datadog.models.MonitoredResource]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MonitoredResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.MonitoredResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.datadog.models.MonitoredResource]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MonitoredSubscription(_serialization.Model):
    """The list of subscriptions and it's monitoring status by current Datadog monitor.

    :ivar subscription_id: The subscriptionId to be monitored.
    :vartype subscription_id: str
    :ivar status: The state of monitoring. Known values are: "InProgress", "Active", "Failed", and
     "Deleting".
    :vartype status: str or ~azure.mgmt.datadog.models.Status
    :ivar error: The reason of not monitoring the subscription.
    :vartype error: str
    :ivar tag_rules: Definition of the properties for a TagRules resource.
    :vartype tag_rules: ~azure.mgmt.datadog.models.MonitoringTagRulesProperties
    """

    _attribute_map = {
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "str"},
        "tag_rules": {"key": "tagRules", "type": "MonitoringTagRulesProperties"},
    }

    def __init__(
        self,
        *,
        subscription_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        error: Optional[str] = None,
        tag_rules: Optional["_models.MonitoringTagRulesProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subscription_id: The subscriptionId to be monitored.
        :paramtype subscription_id: str
        :keyword status: The state of monitoring. Known values are: "InProgress", "Active", "Failed",
         and "Deleting".
        :paramtype status: str or ~azure.mgmt.datadog.models.Status
        :keyword error: The reason of not monitoring the subscription.
        :paramtype error: str
        :keyword tag_rules: Definition of the properties for a TagRules resource.
        :paramtype tag_rules: ~azure.mgmt.datadog.models.MonitoringTagRulesProperties
        """
        super().__init__(**kwargs)
        self.subscription_id = subscription_id
        self.status = status
        self.error = error
        self.tag_rules = tag_rules


class MonitoredSubscriptionProperties(_serialization.Model):
    """The request to update subscriptions needed to be monitored by the Datadog monitor resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the monitored subscription resource.
    :vartype name: str
    :ivar id: The id of the monitored subscription resource.
    :vartype id: str
    :ivar type: The type of the monitored subscription resource.
    :vartype type: str
    :ivar properties: The request to update subscriptions needed to be monitored by the Datadog
     monitor resource.
    :vartype properties: ~azure.mgmt.datadog.models.SubscriptionList
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "SubscriptionList"},
    }

    def __init__(self, *, properties: Optional["_models.SubscriptionList"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The request to update subscriptions needed to be monitored by the Datadog
         monitor resource.
        :paramtype properties: ~azure.mgmt.datadog.models.SubscriptionList
        """
        super().__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.properties = properties


class MonitoredSubscriptionPropertiesList(_serialization.Model):
    """MonitoredSubscriptionPropertiesList.

    :ivar value:
    :vartype value: list[~azure.mgmt.datadog.models.MonitoredSubscriptionProperties]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MonitoredSubscriptionProperties]"},
    }

    def __init__(
        self, *, value: Optional[List["_models.MonitoredSubscriptionProperties"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.datadog.models.MonitoredSubscriptionProperties]
        """
        super().__init__(**kwargs)
        self.value = value


class MonitoringTagRules(_serialization.Model):
    """Capture logs and metrics of Azure resources based on ARM tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the rule set.
    :vartype name: str
    :ivar id: The id of the rule set.
    :vartype id: str
    :ivar type: The type of the rule set.
    :vartype type: str
    :ivar properties: Definition of the properties for a TagRules resource.
    :vartype properties: ~azure.mgmt.datadog.models.MonitoringTagRulesProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.datadog.models.SystemData
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "MonitoringTagRulesProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, *, properties: Optional["_models.MonitoringTagRulesProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Definition of the properties for a TagRules resource.
        :paramtype properties: ~azure.mgmt.datadog.models.MonitoringTagRulesProperties
        """
        super().__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.properties = properties
        self.system_data = None


class MonitoringTagRulesListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.datadog.models.MonitoringTagRules]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MonitoringTagRules]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.MonitoringTagRules"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.datadog.models.MonitoringTagRules]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MonitoringTagRulesProperties(_serialization.Model):
    """Definition of the properties for a TagRules resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Known values are: "Accepted", "Creating", "Updating", "Deleting",
     "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.datadog.models.ProvisioningState
    :ivar log_rules: Set of rules for sending logs for the Monitor resource.
    :vartype log_rules: ~azure.mgmt.datadog.models.LogRules
    :ivar metric_rules: Set of rules for sending metrics for the Monitor resource.
    :vartype metric_rules: ~azure.mgmt.datadog.models.MetricRules
    :ivar automuting: Configuration to enable/disable auto-muting flag.
    :vartype automuting: bool
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "log_rules": {"key": "logRules", "type": "LogRules"},
        "metric_rules": {"key": "metricRules", "type": "MetricRules"},
        "automuting": {"key": "automuting", "type": "bool"},
    }

    def __init__(
        self,
        *,
        log_rules: Optional["_models.LogRules"] = None,
        metric_rules: Optional["_models.MetricRules"] = None,
        automuting: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_rules: Set of rules for sending logs for the Monitor resource.
        :paramtype log_rules: ~azure.mgmt.datadog.models.LogRules
        :keyword metric_rules: Set of rules for sending metrics for the Monitor resource.
        :paramtype metric_rules: ~azure.mgmt.datadog.models.MetricRules
        :keyword automuting: Configuration to enable/disable auto-muting flag.
        :paramtype automuting: bool
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.log_rules = log_rules
        self.metric_rules = metric_rules
        self.automuting = automuting


class MonitorProperties(_serialization.Model):
    """Properties specific to the monitor resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Known values are: "Accepted", "Creating", "Updating", "Deleting",
     "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.datadog.models.ProvisioningState
    :ivar monitoring_status: Flag specifying if the resource monitoring is enabled or disabled.
     Known values are: "Enabled" and "Disabled".
    :vartype monitoring_status: str or ~azure.mgmt.datadog.models.MonitoringStatus
    :ivar marketplace_subscription_status: Flag specifying the Marketplace Subscription Status of
     the resource. If payment is not made in time, the resource will go in Suspended state. Known
     values are: "Provisioning", "Active", "Suspended", and "Unsubscribed".
    :vartype marketplace_subscription_status: str or
     ~azure.mgmt.datadog.models.MarketplaceSubscriptionStatus
    :ivar datadog_organization_properties: Specify the Datadog organization name. In the case of
     linking to existing organizations, Id, ApiKey, and Applicationkey is required as well.
    :vartype datadog_organization_properties:
     ~azure.mgmt.datadog.models.DatadogOrganizationProperties
    :ivar user_info: Includes name, email and optionally, phone number. User Information can't be
     null.
    :vartype user_info: ~azure.mgmt.datadog.models.UserInfo
    :ivar liftr_resource_category: Known values are: "Unknown" and "MonitorLogs".
    :vartype liftr_resource_category: str or ~azure.mgmt.datadog.models.LiftrResourceCategories
    :ivar liftr_resource_preference: The priority of the resource.
    :vartype liftr_resource_preference: int
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "marketplace_subscription_status": {"readonly": True},
        "liftr_resource_category": {"readonly": True},
        "liftr_resource_preference": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "monitoring_status": {"key": "monitoringStatus", "type": "str"},
        "marketplace_subscription_status": {"key": "marketplaceSubscriptionStatus", "type": "str"},
        "datadog_organization_properties": {
            "key": "datadogOrganizationProperties",
            "type": "DatadogOrganizationProperties",
        },
        "user_info": {"key": "userInfo", "type": "UserInfo"},
        "liftr_resource_category": {"key": "liftrResourceCategory", "type": "str"},
        "liftr_resource_preference": {"key": "liftrResourcePreference", "type": "int"},
    }

    def __init__(
        self,
        *,
        monitoring_status: Union[str, "_models.MonitoringStatus"] = "Enabled",
        datadog_organization_properties: Optional["_models.DatadogOrganizationProperties"] = None,
        user_info: Optional["_models.UserInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword monitoring_status: Flag specifying if the resource monitoring is enabled or disabled.
         Known values are: "Enabled" and "Disabled".
        :paramtype monitoring_status: str or ~azure.mgmt.datadog.models.MonitoringStatus
        :keyword datadog_organization_properties: Specify the Datadog organization name. In the case of
         linking to existing organizations, Id, ApiKey, and Applicationkey is required as well.
        :paramtype datadog_organization_properties:
         ~azure.mgmt.datadog.models.DatadogOrganizationProperties
        :keyword user_info: Includes name, email and optionally, phone number. User Information can't
         be null.
        :paramtype user_info: ~azure.mgmt.datadog.models.UserInfo
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.monitoring_status = monitoring_status
        self.marketplace_subscription_status = None
        self.datadog_organization_properties = datadog_organization_properties
        self.user_info = user_info
        self.liftr_resource_category = None
        self.liftr_resource_preference = None


class MonitorUpdateProperties(_serialization.Model):
    """The set of properties that can be update in a PATCH request to a monitor resource.

    :ivar monitoring_status: Flag specifying if the resource monitoring is enabled or disabled.
     Known values are: "Enabled" and "Disabled".
    :vartype monitoring_status: str or ~azure.mgmt.datadog.models.MonitoringStatus
    :ivar cspm: The new cloud security posture management value of the monitor resource. This
     collects configuration information for all resources in a subscription and track conformance to
     industry benchmarks.
    :vartype cspm: bool
    """

    _attribute_map = {
        "monitoring_status": {"key": "monitoringStatus", "type": "str"},
        "cspm": {"key": "cspm", "type": "bool"},
    }

    def __init__(
        self,
        *,
        monitoring_status: Union[str, "_models.MonitoringStatus"] = "Enabled",
        cspm: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword monitoring_status: Flag specifying if the resource monitoring is enabled or disabled.
         Known values are: "Enabled" and "Disabled".
        :paramtype monitoring_status: str or ~azure.mgmt.datadog.models.MonitoringStatus
        :keyword cspm: The new cloud security posture management value of the monitor resource. This
         collects configuration information for all resources in a subscription and track conformance to
         industry benchmarks.
        :paramtype cspm: bool
        """
        super().__init__(**kwargs)
        self.monitoring_status = monitoring_status
        self.cspm = cspm


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider, i.e., Microsoft.Datadog.
    :vartype provider: str
    :ivar resource: Type on which the operation is performed, e.g., 'monitors'.
    :vartype resource: str
    :ivar operation: Operation type, e.g., read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation, e.g., 'Write monitors'.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider, i.e., Microsoft.Datadog.
        :paramtype provider: str
        :keyword resource: Type on which the operation is performed, e.g., 'monitors'.
        :paramtype resource: str
        :keyword operation: Operation type, e.g., read, write, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation, e.g., 'Write monitors'.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of GET request to list the Microsoft.Datadog operations.

    :ivar value: List of operations supported by the Microsoft.Datadog provider.
    :vartype value: list[~azure.mgmt.datadog.models.OperationResult]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.OperationResult"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of operations supported by the Microsoft.Datadog provider.
        :paramtype value: list[~azure.mgmt.datadog.models.OperationResult]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationResult(_serialization.Model):
    """A Microsoft.Datadog REST API operation.

    :ivar name: Operation name, i.e., {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.datadog.models.OperationDisplay
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        is_data_action: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name, i.e., {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.datadog.models.OperationDisplay
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.is_data_action = is_data_action


class ResourceSku(_serialization.Model):
    """ResourceSku.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the SKU in {PlanId} format. For Terraform, the only allowed value is
     'linking'. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: Name of the SKU in {PlanId} format. For Terraform, the only allowed value is
         'linking'. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class SubscriptionList(_serialization.Model):
    """The request to update subscriptions needed to be monitored by the Datadog monitor resource.

    :ivar operation: The operation for the patch on the resource. Known values are: "AddBegin",
     "AddComplete", "DeleteBegin", "DeleteComplete", and "Active".
    :vartype operation: str or ~azure.mgmt.datadog.models.Operation
    :ivar monitored_subscription_list: List of subscriptions and the state of the monitoring.
    :vartype monitored_subscription_list: list[~azure.mgmt.datadog.models.MonitoredSubscription]
    """

    _attribute_map = {
        "operation": {"key": "operation", "type": "str"},
        "monitored_subscription_list": {"key": "monitoredSubscriptionList", "type": "[MonitoredSubscription]"},
    }

    def __init__(
        self,
        *,
        operation: Optional[Union[str, "_models.Operation"]] = None,
        monitored_subscription_list: Optional[List["_models.MonitoredSubscription"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation: The operation for the patch on the resource. Known values are: "AddBegin",
         "AddComplete", "DeleteBegin", "DeleteComplete", and "Active".
        :paramtype operation: str or ~azure.mgmt.datadog.models.Operation
        :keyword monitored_subscription_list: List of subscriptions and the state of the monitoring.
        :paramtype monitored_subscription_list: list[~azure.mgmt.datadog.models.MonitoredSubscription]
        """
        super().__init__(**kwargs)
        self.operation = operation
        self.monitored_subscription_list = monitored_subscription_list


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.datadog.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.datadog.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.datadog.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.datadog.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserInfo(_serialization.Model):
    """Includes name, email and optionally, phone number. User Information can't be null.

    :ivar name: Name of the user.
    :vartype name: str
    :ivar email_address: Email of the user used by Datadog for contacting them if needed.
    :vartype email_address: str
    :ivar phone_number: Phone number of the user used by Datadog for contacting them if needed.
    :vartype phone_number: str
    """

    _validation = {
        "name": {"max_length": 50},
        "email_address": {"pattern": r"^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$"},
        "phone_number": {"max_length": 40},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "email_address": {"key": "emailAddress", "type": "str"},
        "phone_number": {"key": "phoneNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        email_address: Optional[str] = None,
        phone_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the user.
        :paramtype name: str
        :keyword email_address: Email of the user used by Datadog for contacting them if needed.
        :paramtype email_address: str
        :keyword phone_number: Phone number of the user used by Datadog for contacting them if needed.
        :paramtype phone_number: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.email_address = email_address
        self.phone_number = phone_number
