# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterGovernanceRulesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_governance_rules_list(self, resource_group):
        response = self.client.governance_rules.list(
            scope="str",
            api_version="2022-01-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_governance_rules_get(self, resource_group):
        response = self.client.governance_rules.get(
            scope="str",
            rule_id="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_governance_rules_create_or_update(self, resource_group):
        response = self.client.governance_rules.create_or_update(
            scope="str",
            rule_id="str",
            governance_rule={
                "conditionSets": [{}],
                "description": "str",
                "displayName": "str",
                "excludedScopes": ["str"],
                "governanceEmailNotification": {
                    "disableManagerEmailNotification": bool,
                    "disableOwnerEmailNotification": bool,
                },
                "id": "str",
                "includeMemberScopes": bool,
                "isDisabled": bool,
                "isGracePeriod": bool,
                "metadata": {
                    "createdBy": "str",
                    "createdOn": "2020-02-20 00:00:00",
                    "updatedBy": "str",
                    "updatedOn": "2020-02-20 00:00:00",
                },
                "name": "str",
                "ownerSource": {"type": "str", "value": "str"},
                "remediationTimeframe": "str",
                "rulePriority": 0,
                "ruleType": "str",
                "sourceResourceType": "str",
                "tenantId": "str",
                "type": "str",
            },
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_governance_rules_begin_delete(self, resource_group):
        response = self.client.governance_rules.begin_delete(
            scope="str",
            rule_id="str",
            api_version="2022-01-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_governance_rules_begin_execute(self, resource_group):
        response = self.client.governance_rules.begin_execute(
            scope="str",
            rule_id="str",
            api_version="2022-01-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_governance_rules_operation_results(self, resource_group):
        response = self.client.governance_rules.operation_results(
            scope="str",
            rule_id="str",
            operation_id="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...
