/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMLocator;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.DOMExceptionImpl;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.xpath.XPathException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class AbstractNode
implements Node,
NodeInfo,
SourceLocator,
DOMLocator {
    public static final char[] NODE_LETTER = new char[]{'x', 'e', 'a', 't', 'x', 'x', 'x', 'p', 'c', 'r', 'x', 'x', 'x', 'n'};

    public abstract boolean isSameNode(NodeInfo var1);

    public abstract String generateId();

    public abstract String getSystemId();

    public abstract String getBaseURI();

    public Node getOriginatingNode() {
        return this;
    }

    public abstract int compareOrder(NodeInfo var1);

    public abstract int getNameCode();

    public abstract int getFingerprint();

    public String getNodeName() {
        switch (this.getNodeKind()) {
            case 9: {
                return "#document";
            }
            case 1: {
                return this.getDisplayName();
            }
            case 2: {
                return this.getDisplayName();
            }
            case 3: {
                return "#text";
            }
            case 8: {
                return "#comment";
            }
            case 7: {
                return this.getLocalPart();
            }
            case 13: {
                return this.getLocalPart();
            }
        }
        return "#unknown";
    }

    public String getLocalName() {
        switch (this.getNodeKind()) {
            case 1: 
            case 2: {
                return this.getLocalPart();
            }
        }
        return null;
    }

    public abstract String getURI();

    public String getDisplayName() {
        String string = this.getLocalPart();
        if (string == null || "".equals(string)) {
            return "";
        }
        String string2 = this.getPrefix();
        if ("".equals(string2)) {
            return string;
        }
        return string2 + ":" + string;
    }

    public abstract String getLocalPart();

    public abstract String getStringValue();

    public int getTypeAnnotation() {
        return -1;
    }

    public abstract boolean hasChildNodes();

    public abstract boolean hasAttributes();

    public abstract String getAttributeValue(int var1);

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public abstract AxisIterator iterateAxis(byte var1, NodeTest var2);

    public abstract NodeInfo getParent();

    public NodeInfo getRoot() {
        NodeInfo nodeInfo = this;
        NodeInfo nodeInfo2 = this.getParent();
        while (nodeInfo2 != null) {
            nodeInfo = nodeInfo2;
            nodeInfo2 = nodeInfo2.getParent();
        }
        return nodeInfo;
    }

    public DocumentInfo getDocumentRoot() {
        NodeInfo nodeInfo = this.getRoot();
        if (nodeInfo instanceof DocumentInfo) {
            return (DocumentInfo)nodeInfo;
        }
        return null;
    }

    public int getDocumentNumber() {
        return this.getRoot().getDocumentNumber();
    }

    public short getNodeType() {
        return (short)this.getNodeKind();
    }

    public Node getParentNode() {
        return (Node)((Object)this.getParent());
    }

    public Node getPreviousSibling() {
        return (Node)((Object)this.iterateAxis((byte)11).next());
    }

    public Node getNextSibling() {
        return (Node)((Object)this.iterateAxis((byte)7).next());
    }

    public Node getFirstChild() {
        return (Node)((Object)this.iterateAxis((byte)3).next());
    }

    public Node getLastChild() {
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo = null;
        NodeInfo nodeInfo2;
        while ((nodeInfo2 = (NodeInfo)axisIterator.next()) != null) {
            nodeInfo = nodeInfo2;
        }
        return (Node)((Object)nodeInfo);
    }

    public Element getDocumentElement() {
        DocumentInfo documentInfo = this.getDocumentRoot();
        if (documentInfo == null) {
            return null;
        }
        AxisIterator axisIterator = documentInfo.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        return (Element)((Object)axisIterator.next());
    }

    public SequenceIterator getTypedValue() throws XPathException {
        int n = this.getTypeAnnotation();
        if (n == -1) {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(this.getStringValue()));
        }
        SchemaType schemaType = this.getNamePool().getSchemaType(n);
        if (schemaType == null) {
            throw new IllegalStateException("Unknown type annotation " + n + " in data model");
        }
        return schemaType.getTypedValue(this);
    }

    public void outputNamespaceNodes(Receiver receiver, boolean bl) throws TransformerException {
    }

    public String getNodeValue() {
        switch (this.getNodeKind()) {
            case 1: 
            case 9: {
                return null;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 13: {
                return this.getStringValue();
            }
        }
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
        AbstractNode.disallowUpdate();
    }

    public NodeList getChildNodes() {
        try {
            return new DOMNodeList(new SequenceExtent(this.iterateAxis((byte)3)));
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    public NamedNodeMap getAttributes() {
        if (this.getNodeKind() == 1) {
            return new AttributeMap(this);
        }
        return null;
    }

    public Document getOwnerDocument() {
        return (Document)((Object)this.getDocumentRoot());
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public Node removeChild(Node node) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public Node appendChild(Node node) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public Node cloneNode(boolean bl) {
        return null;
    }

    public void normalize() {
    }

    public boolean isSupported(String string, String string2) {
        return string.equalsIgnoreCase("xml");
    }

    public boolean supports(String string, String string2) {
        return this.isSupported(string, string2);
    }

    public String getNamespaceURI() {
        String string = this.getURI();
        return string.equals("") ? null : string;
    }

    public void setPrefix(String string) throws DOMException {
        AbstractNode.disallowUpdate();
    }

    protected static void disallowUpdate() throws DOMException {
        throw new UnsupportedOperationException("The Saxon DOM cannot be updated");
    }

    public DocumentType getDoctype() {
        return null;
    }

    public DOMImplementation getImplementation() {
        return new DOMImplementationImpl();
    }

    public Element createElement(String string) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public DocumentFragment createDocumentFragment() {
        return null;
    }

    public Text createTextNode(String string) {
        return null;
    }

    public Comment createComment(String string) {
        return null;
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public Attr createAttribute(String string) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public NodeList getElementsByTagName(String string) {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.iterateAxis((byte)4);
        ArrayList<NodeInfo> arrayList = new ArrayList<NodeInfo>();
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo.getNodeKind() != 1 || !string.equals("*") && !string.equals(nodeInfo.getDisplayName())) continue;
            arrayList.add(nodeInfo);
        }
        return new DOMNodeList(new SequenceExtent(arrayList));
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.iterateAxis((byte)4);
        ArrayList<NodeInfo> arrayList = new ArrayList<NodeInfo>();
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (nodeInfo.getNodeKind() != 1 || !string.equals("*") && !string.equals(nodeInfo.getURI()) || !string2.equals("*") && !string2.equals(nodeInfo.getLocalPart())) continue;
            arrayList.add(nodeInfo);
        }
        return new DOMNodeList(new SequenceExtent(arrayList));
    }

    public Element getElementById(String string) {
        DocumentInfo documentInfo = this.getDocumentRoot();
        if (documentInfo == null) {
            return null;
        }
        return (Element)((Object)documentInfo.selectID(string));
    }

    public String getTagName() {
        return this.getDisplayName();
    }

    public String getAttribute(String string) {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.iterateAxis((byte)2);
        do {
            if ((nodeInfo = (NodeInfo)axisIterator.next()) != null) continue;
            return "";
        } while (!nodeInfo.getDisplayName().equals(string));
        String string2 = nodeInfo.getStringValue();
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public Attr getAttributeNode(String string) {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.iterateAxis((byte)2);
        do {
            if ((nodeInfo = (NodeInfo)axisIterator.next()) != null) continue;
            return null;
        } while (!nodeInfo.getDisplayName().equals(string));
        return (Attr)((Object)nodeInfo);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public void removeAttribute(String string) throws DOMException {
        AbstractNode.disallowUpdate();
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public String getAttributeNS(String string, String string2) {
        String string3 = Navigator.getAttributeValue(this, string, string2);
        if (string3 == null) {
            return "";
        }
        return string3;
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        AbstractNode.disallowUpdate();
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        AbstractNode.disallowUpdate();
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        DocumentInfo documentInfo = this.getDocumentRoot();
        if (documentInfo == null) {
            throw new UnsupportedOperationException("getAttributeNodeNS is not supported on a tree with no document node");
        }
        int n = documentInfo.getNamePool().getFingerprint(string, string2);
        if (n == -1) {
            return null;
        }
        NameTest nameTest = new NameTest(2, n);
        AxisIterator axisIterator = this.iterateAxis((byte)2, nameTest);
        return (Attr)((Object)axisIterator.next());
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public boolean hasAttribute(String string) {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.iterateAxis((byte)2);
        do {
            if ((nodeInfo = (NodeInfo)axisIterator.next()) != null) continue;
            return false;
        } while (!nodeInfo.getDisplayName().equals(string));
        return true;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return Navigator.getAttributeValue(this, string, string2) != null;
    }

    public String getData() {
        return this.getStringValue();
    }

    public void setData(String string) throws DOMException {
        AbstractNode.disallowUpdate();
    }

    public int getLength() {
        return this.getStringValue().length();
    }

    public String substringData(int n, int n2) throws DOMException {
        try {
            return this.getStringValue().substring(n, n + n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, "substringData: index out of bounds");
        }
    }

    public void appendData(String string) throws DOMException {
        AbstractNode.disallowUpdate();
    }

    public void insertData(int n, String string) throws DOMException {
        AbstractNode.disallowUpdate();
    }

    public void deleteData(int n, int n2) throws DOMException {
        AbstractNode.disallowUpdate();
    }

    public void replaceData(int n, int n2, String string) throws DOMException {
        AbstractNode.disallowUpdate();
    }

    public Text splitText(int n) throws DOMException {
        AbstractNode.disallowUpdate();
        return null;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getValue() {
        return this.getStringValue();
    }

    public boolean getSpecified() {
        return true;
    }

    public void setValue(String string) throws DOMException {
        AbstractNode.disallowUpdate();
    }

    public Element getOwnerElement() {
        if (this.getNodeKind() != 2) {
            throw new UnsupportedOperationException("This method is defined only on attribute nodes");
        }
        return (Element)((Object)this.getParent());
    }

    private static class AttributeMap
    implements NamedNodeMap {
        private AbstractNode parent;

        public AttributeMap(AbstractNode abstractNode) {
            this.parent = abstractNode;
        }

        public Node getNamedItem(String string) {
            NodeInfo nodeInfo;
            AxisIterator axisIterator = this.parent.iterateAxis((byte)2);
            do {
                if ((nodeInfo = (NodeInfo)axisIterator.next()) != null) continue;
                return null;
            } while (!string.equals(nodeInfo.getDisplayName()));
            return (Node)((Object)nodeInfo);
        }

        public Node item(int n) {
            if (n < 0) {
                return null;
            }
            int n2 = 0;
            AxisIterator axisIterator = this.parent.iterateAxis((byte)2);
            NodeInfo nodeInfo;
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (n2 == n) {
                    return (Node)((Object)nodeInfo);
                }
                ++n2;
            }
            return null;
        }

        public int getLength() {
            int n = 0;
            AxisIterator axisIterator = this.parent.iterateAxis((byte)2);
            while (axisIterator.next() != null) {
                ++n;
            }
            return n;
        }

        public Node getNamedItemNS(String string, String string2) {
            NodeInfo nodeInfo;
            if (string == null) {
                string = "";
            }
            AxisIterator axisIterator = this.parent.iterateAxis((byte)2);
            do {
                if ((nodeInfo = (NodeInfo)axisIterator.next()) != null) continue;
                return null;
            } while (!string.equals(nodeInfo.getURI()) || !string2.equals(nodeInfo.getLocalPart()));
            return (Node)((Object)nodeInfo);
        }

        public Node setNamedItem(Node node) throws DOMException {
            AbstractNode.disallowUpdate();
            return null;
        }

        public Node removeNamedItem(String string) throws DOMException {
            AbstractNode.disallowUpdate();
            return null;
        }

        public Node setNamedItemNS(Node node) throws DOMException {
            AbstractNode.disallowUpdate();
            return null;
        }

        public Node removeNamedItemNS(String string, String string2) throws DOMException {
            AbstractNode.disallowUpdate();
            return null;
        }
    }

    private static class DOMImplementationImpl
    implements DOMImplementation {
        private DOMImplementationImpl() {
        }

        public boolean hasFeature(String string, String string2) {
            return false;
        }

        public DocumentType createDocumentType(String string, String string2, String string3) throws DOMException {
            AbstractNode.disallowUpdate();
            return null;
        }

        public Document createDocument(String string, String string2, DocumentType documentType) throws DOMException {
            AbstractNode.disallowUpdate();
            return null;
        }
    }
}

