/* following related to some defines in f2c.h that are still
** employed after removing other f2c dependancies */
#ifndef FM_INCLUDE
#define FM_INCLUDE
/* what's used from f2c.h */

#ifndef F2C_INCLUDE

#define abs(x) ((x) >= 0 ? (x) : -(x))
#define min(a,b) ((a) <= (b) ? (a) : (b))
#define max(a,b) ((a) >= (b) ? (a) : (b))

#endif

/*  Revision of original to ease modification of parameter
**  settings for global recompilation.
**
**  The size of all arrays is controlled by defining two parameters:
**  MXNDIG is the maximum value the user can set NDIG,
**  NBITS  is the number of bits per long word.
*/

#ifndef MXNDIG
#define	MXNDIG	256
#endif
#define	NBITS	32

/* Define the array sizes: */
#define	LPACK	((MXNDIG+1)/2 + 1)
#define	LUNPCK	((6*MXNDIG)/5 + 20)
/* Common Block Declarations */
struct {
	long ndig, jbase, jform1, jform2, krad, kw, ntrace, lvltrc, kflag, 
	kwarn, kround;
} fmuser_1;
struct {
	long mwa[2*LUNPCK], ncall, mxexp, mxexp2, kargsw, kexpun, kexpov, kunkno, 
		iunkno;
	float runkno;
	long mxbase, mxndg2, kstack[19], maxint;
	float spmax;
	double dpmax;
} fm_1;

/* following elements only used internal to the fm package
** so do not need to clutter up external usage of fm.h */
#ifdef FM_SYSTEM
struct {
	long ndigpi, njbpi, ndige, njbe, ndiglb, njblb, ndigli, njbli,
	mpisav[LUNPCK], mesav[LUNPCK], mlbsav[LUNPCK], mln1[LUNPCK],
	mln2[LUNPCK], mln3[LUNPCK], mln4[LUNPCK];
} fmsave_1;
#define	LJSUMS	(8*LUNPCK)
struct {
	long mjsums[LJSUMS];
} fmsums_1;
struct {
	long m01[LUNPCK], m02[LUNPCK], m03[LUNPCK], m04[LUNPCK],
	m05[LUNPCK], m06[LUNPCK];
} fm1_1;
struct {
	long mx[LUNPCK], my[LUNPCK];
} fmpck_1;
int fmadd2_(long *, long *, long *);
int fmaddn_(long *, long *, long *, long *);
int fmaddp_(long *, long *, long *);
int fmargs(long, long, long *, long *);
void fmcos2(long *, long *);
int fmdiv2_(long *, long *, long *);
int fmdm_(double *, long *);
int fmentr_(long *, long *, long *, long *, long *, long *, long *, long *, long *, long *);
int fmexit_(long *, long *, long *, long *, long *, long *);
int fmexp2_(long *, long *);
void fmim(long, long *);
int fminp2_(long *, char *, long *, long *, long *, char *, long *);
int fmlni2(long, long, long *);
int fmmd_(long *, double *);
int fmmi_(long *, long *);
int fmmove_(long *);
int fmmpy2_(long *, long *, long *);
int fmmpy3_(long *, long *, long *, long *);
int fmpi2_(long *);
int fmrdc_(long *, long *, long *, long *, long *);
int fmrnd_(long *, long *, long *);
void fmrslt_(long *, long *, long *, long);
int fmtrap_(long *);
char *fmname(void);
void fminpt(char *, long *, long *);
void fmntr(long, long *, long *, long);
void fmntri(long, long, long);
void fmntrj(long *, long);
void fmntrr(long, double, long);
void fmpack(long *, long *);
void fmsin2(long *, long *);
void fmunpk(long *, long *);
void fmwarn(void);
#endif

#ifdef __STDC__
/* following application procedures */

/* unpacked usage */

void fmabs(long *, long *);
void fmacos(long *, long *);
void fmadd(long *, long *, long *);
void fmasin(long *, long *);
void fmatan(long *, long *);
void fmatn2(long *, long *, long *);
void fmbig(long *);
int fmcomp(long *, char *, long *);
void fmcos(long *, long *);
void fmcosh(long *, long *);
long fmdig(long *);
void fmdim(long *, long *, long *);
void fmdiv(long *, long *, long *);
void fmdivi(long *, long, long *);
void fmdp2m(double, long *);
void fmequ(long *, long *, long, long);
void fmexp(long *, long *);
void fmi2m(long, long *);
void fminp(char *, long *, long, long);
void fmint(long *, long *);
void fmipwr(long *, long, long *);
void fmlg10(long *, long *);
void fmln(long *, long *);
void fmlni(long, long *);
double fmm2dp(long *);
long fmm2i(long *);
float fmm2sp(long *);
void fmmax(long *, long *, long *);
void fmmin(long *, long *, long *);
void fmmod(long *, long *, long *);
void fmmpy(long *, long *, long *);
void fmmpyi(long *, long, long *);
void fmneg(long *, long *);
void fmnint(long *, long *);
void fmout(long *, char *, long);
void fmpi(long *);
void fmprnt(long *);
void fmpwr(long *, long *, long *);
void fmset(long);
void fmsign(long *, long *, long *);
void fmsin(long *, long *);
void fmsinh(long *, long *);
void fmsp2m(float, long *);
void fmsqrt(long *, long *);
void fmsub(long *, long *, long *);
void fmtan(long *, long *);
void fmtanh(long *, long *);
void fmulp(long *, long *);
int fmzero(long *);
long *fmarray(void);
void fmfree(long *);
char *fmstring(long *);

/* packed usage */

void fpabs(long *, long *);
void fpacos(long *, long *);
void fpadd(long *, long *, long *);
void fpasin(long *, long *);
void fpatan(long *, long *);
void fpatn2(long *, long *, long *);
void fpbig(long *);
int fpcomp(long *, char *, long *);
void fpcos(long *, long *);
void fpcosh(long *, long *);
long fpdig(long *);
void fpdim(long *, long *, long *);
void fpdiv(long *, long *, long *);
void fpdivi(long *, long, long *);
void fpdp2m(double, long *);
void fpequ(long *, long *, long, long);
void fpexp(long *, long *);
void fpi2m(long, long *);
void fpinp(char *, long *, long, long);
void fpint(long *, long *);
void fpipwr(long *, long, long *);
void fplg10(long *, long *);
void fpln(long *, long *);
void fplni(long, long *);
double fpm2dp(long *);
long fpm2i(long *);
float fpm2sp(long *);
void fpmax(long *, long *, long *);
void fpmin(long *, long *, long *);
void fpmod(long *, long *, long *);
void fpmpy(long *, long *, long *);
void fpmpyi(long *, long, long *);
void fpneg(long *, long *);
void fpnint(long *, long *);
void fpout(long *, char *, long);
void fppi(long *);
void fpprnt(long *);
void fppwr(long *, long *, long *);
void fpset(long);
void fpsign(long *, long *, long *);
void fpsin(long *, long *);
void fpsinh(long *, long *);
void fpsp2m(float, long *);
void fpsqrt(long *, long *);
void fpsub(long *, long *, long *);
void fptan(long *, long *);
void fptanh(long *, long *);
void fpulp(long *, long *);
int fpzero(long *);
long *fparray(void);
void fpfree(long *);
char *fpstring(long *);
#else
/* K&R form */
void fmabs(), fmacos(), fmadd(), fmasin(), fmatan(), fmatn2(), fmbig(),
	fmcos(), fmcosh(), fmdim(), fmdiv(), fmdivi(), fmdp2m(), fmequ(),
	fmexp(), fmi2m(), fminp(), fmint(), fmipwr(), fmlg10(), fmln(),
	fmlni(), fmmax(), fmmin(), fmmod(), fmmpy(), fmmpyi(), fmnint(),
	fmout(), fmpi(), fmprnt(), fmpwr(), fmset(), fmsign(), fmsin(),
	fmsinh(), fmsp2m(), fmsqrt(), fmsub(), fmtan(), fmtanh(), fmulp(),
	fmfree(), fmneg();
void fpabs(), fpacos(), fpadd(), fpasin(), fpatan(), fpatn2(), fpbig(),
	fpcos(), fpcosh(), fpdim(), fpdiv(), fpdivi(), fpdp2m(), fpequ(),
	fpexp(), fpi2m(), fpinp(), fpint(), fpipwr(), fplg10(), fpln(),
	fplni(), fpmax(), fpmin(), fpmod(), fpmpy(), fpmpyi(), fpnint(),
	fpout(), fppi(), fpprnt(), fppwr(), fpset(), fpsign(), fpsin(),
	fpsinh(), fpsp2m(), fpsqrt(), fpsub(), fptan(), fptanh(), fpulp(),
	fpfree(), fpneg();
long fpm2i(), fpdig(), *fmarray(), fmm2i(), fmdig(), *fparray();
int fpcomp(), fmcomp(), fmzero(), fpzero();
double fmm2dp(), fpm2dp();
float fmm2sp(), fpm2sp();
char *fmstring(), *fpstring*();
#endif

#endif
