#ifndef  _QV_MATERIAL_
#define  _QV_MATERIAL_

#include "QvMFColor.h"
#include "QvMFFloat.h"
#include "QvSubNode.h"

#include <ge3d/mtl.h>

class QvMaterial : public QvNode {

    QV_NODE_HEADER(QvMaterial);

  public:
    // Fields
    QvMFColor		ambientColor;	// Ambient color
    QvMFColor		diffuseColor;	// Diffuse color
    QvMFColor		specularColor;	// Specular color
    QvMFColor		emissiveColor;	// Emissive color
    QvMFFloat		shininess;	// Shininess
    QvMFFloat		transparency;	// Transparency

    // first ("base") material definition; mpichler, 19950503
    float matdef_ [23];  // maximal: 4*5 (ambient..emissive RGBA) + 2 (shininess) + 1 (end)

    // mpichler, 19950629
    materialsGE3D materials_;  // arrays of material components
};

#endif /* _QV_MATERIAL_ */
