/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/admin/RCS/createcertif.c,v $
 *
 *
 *  MODULE NAME:    createcertif.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */

/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */

#include <stdio.h>
#include "cdc.h"
#include "cdc_db.h"
#include "SPHINX-types.h"

extern int ps_len_strategy ;
extern int optind, opterr;
extern char *optarg;
char *progname, *rindex();

#define YEAR   365

main(argc, argv)
int argc;
char *argv[];
{
  int taflag = 0, c, vers = 1, errflg = 0, serial = 1, a = 0;
  int expire = 2*YEAR, xflag = 0, wflag = 0;
  char *domainName = NULL, *cp;
  char issuer[40], subject[40], passwordBuf[40];

  ps_len_strategy = PS_LEN_LONG;

  opterr = 0;
  while ((c=getopt(argc, argv, "xaViItv:d:s:e:w:")) != EOF)
    switch(c) {
      case 'w' :
        strcpy(passwordBuf,optarg);
	wflag = 1;
        break;
      case 'x' :
	/*
	 *  create a cross certificate
	 */
	xflag = 1;
	break;
      case 'I' :
      case 'i' :
	/*
	 * indefinite length encoding for certificate
	 */
        ps_len_strategy = PS_LEN_INDF;
        break;
      case 't' :
	/*
	 * create a trusted authority certificate
	 */
        taflag = 1;
        break;
      case 'v' :
	/*
	 * certificate version (either v1988 or v1992)
	 */
	switch (atoi(optarg)) {
          case 1988 :
	    vers = 0;
	    break;
	  case 1992 :
	    vers = 1;
	    break;
	  default :
	    printf("illegal certificate version, using v1992\n");
	  }
	break;
      case 'e' :
	/*
	 * certificate expiration (days from now)
	 */
	expire = atoi(optarg);
	break;
      case 's' :
	/*
	 * certificate serial number
	 */
	serial = atoi(optarg);
	break;
      case 'd' :
	/*
	 * default certificate domain name
	 */
	domainName = optarg;
	break;
      case 'a' :
	/*
	 * authority certificate (identity certificate)
	 */
	a = 1;
	break;
      case '?' :
      default:
	errflg++;
    }
  if (xflag && taflag)  errflg++;
  if (a) {if (taflag) errflg++; else taflag=2;}
  if (a && xflag) errflg++;
  if (argv[optind] == NULL)  errflg++;
  else strcpy(issuer, argv[optind++]);
  if (a == 0) {
    if (argv[optind] == NULL)  errflg++;
    else strcpy(subject, argv[optind++]);
  } else strcpy(subject, issuer);
  if (optind != argc)  errflg++;

  if (errflg) {
    progname = (cp = rindex(argv[0], '/')) ? cp + 1 : argv[0];
    printf("Usage: %s [-tx] [-v year] [-e days] [-s num] [-d prefix] issuer subj\n",progname);
    printf("\t-v       certificate version (default 1992)\n");
    printf("\t-e       certificate expiration (default 730 days or 2 years)\n");
    printf("\t-s       certificate serial number (default 1)\n");
    printf("\t-d       domain prefix (default prefix from /etc/cdc.conf)\n");
    printf("\t-t       trusted authority certificate\n");
    printf("\t-x       cross certificate\n");
    printf("\t-a       authority certificate (identity certificate)\n");
    exit(-1);
  }
  if ((vers == 0) && ((taflag==1) || xflag))
    printf("Warning: Sphinx recommends that TA and cross certificates be version 1992.\n");
  create_certif_aux(issuer, subject, vers, serial, expire, domainName, taflag, xflag, (wflag ? passwordBuf : NULL));
  if (wflag)  bzero(passwordBuf, sizeof(passwordBuf));
  exit(0);
}
