/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/admin/RCS/displaycertif.c,v $
 *
 *
 *  MODULE NAME:    displaycertif.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */

 
/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */



#include <stdio.h>

extern int optind, opterr;
extern char *optarg;
char *progname, *rindex();

main(argc, argv)
int argc;
char *argv[];
{
  int  c;
  char issuer[80], subject[80], *cp;
  int verify=0, errflg=0, digest=0, getkey=0;

  opterr = 0;
  while ((c=getopt(argc, argv, "kVvdD")) != EOF)
    switch(c) {
      case 'k' :
        getkey = 1;
        break;
      case 'v' :
      case 'V' :
        verify = 1;
        break;
      case 'd' :
      case 'D' :
        digest = 1;
        break;
      case '?' :
	errflg++;
    }

  if (argv[optind] == NULL)  errflg++;
  else strcpy(issuer, argv[optind++]);
/*
 * if no subject name given, then use the previous argument as certif
 * file name
 *
 */
  if (argv[optind] == NULL) {
    bzero(subject, sizeof(subject));
    getkey = 0;
    verify = 0;
  }
  else strcpy(subject, argv[optind++]);

  if (optind != argc)  errflg++;
  if (errflg) {
    progname = (cp = rindex(argv[0], '/')) ? cp + 1 : argv[0];
    printf("Usage: %s [-v] issuer [subject]\n",progname);
    printf("\t-v       verify certificate (issuer's public key read locally)\n");
    exit(2);
  }

  parse_certif(issuer, subject, verify, digest, getkey);

}
