/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/admin/RCS/dump_privkey.c,v $
 *
 *
 *  MODULE NAME:    dump_privkey.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */

 
/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>

#include "BigNum.h"
#include "BigZ.h"
#include "BigRSA.h"

#include "cdc.h"
#include "random.h"
#include "bigkeygen.h"
#include "bigrsacode.h"

extern int optind, opterr;
extern char *optarg;
char *progname, *rindex();

main(argc,argv)
int     argc;
char    **argv;
{
    static RSAKeyStorage keys ;
    char usernameBuf [50], uidBuf [50], x500NameBuf[50], hashkey[50], *cp;
    int c, i, uid_len, kflag=0, errflg=0;
    unsigned char  *privatekey;
    int            privatekey_len;
    FILE  *priv;
    char filename[80];

    opterr = 0;
    while ((c=getopt(argc, argv, "k")) != EOF)
      switch (c) {
        case 'k':
	  kflag = 1;
	  break;
	case '?':
	  errflg++;
	  break;
	default:
	  break;
	}

    if (argc == 1)  errflg++;

    if (errflg)
    {
      progname = (cp = rindex(argv[0], '/')) ? cp + 1 : argv[0];
      printf("Usage: %s name \n", progname);
      exit(1);
    }

    strcpy(usernameBuf, argv[argc-1]);

    memset(&keys,0,sizeof(keys));
    
    if (read_privkey_verbose (usernameBuf, x500NameBuf, uidBuf, &uid_len, hashkey, &keys,NULL)) {
        printf("\nName: %s\n", x500NameBuf);
        printf("\nHash:"); dumphex(hashkey,8);
        printf("\nUID:");dumphex(uidBuf,uid_len);
        printf("\nPrivate Key:");PrintPrivKey(&keys);
    }        

    if (kflag) {
      strcpy(filename, usernameBuf);
      strcat(filename, "_privkey_clr");
      printf("saving privatekey in %s ... \n", filename);

      if ((priv = fopen(filename, "w")) == NULL) {
	printf("could not open/create private key file - %s", filename);
	exit(-1);
      }
      privatekey = (unsigned char *) EncodePrivate(&keys);
      privatekey_len = DecodeTotalLength(privatekey);
      fdumphex(privatekey, privatekey_len, priv);
      fclose(priv);
    }

BnnClose();
exit(0);
}

