
/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#ifndef GSSAPI_DEFS
#define GSSAPI_DEFS


/*
 * Data Types
 */

#ifdef __STDC__
#define gss_pointer void *
#else
#define gss_pointer char *
#endif

typedef size_t      OM_uint32;
typedef u_short     OM_uint16;

typedef struct gss_buffer_desc_struct {
                size_t        length;
                gss_pointer   value;
		} gss_buffer_desc,  *gss_buffer_t;

#define GSS_EMPTY_BUFFER ((gss_buffer_desc){0, NULL})

typedef  void      *gss_cred_id_t;
typedef  void      *gss_ctx_id_t;

typedef  void      *gss_name_t;

typedef struct gss_OID_desc_struct {
                OM_uint32     length;
                void          *elements;
		}  gss_OID_desc, *gss_OID;

typedef struct gss_OID_set_desc {
                int           count;
		gss_OID_desc  *elements;
		} gss_OID_set_d, *gss_OID_set;

typedef struct gss_channel_bindings_struct {
                OM_uint32        initiator_addrtype;
	        gss_buffer_desc  initiator_address;
	        OM_uint32        acceptor_addrtype;
	        gss_buffer_desc  acceptor_address;
	        gss_buffer_desc  application_data;
	        } gss_channel_bindings_desc, *gss_channel_bindings;

/*
 * Authentication mechanism oids
 *
 *  SPX_MECHTYPE_OID_ASCII     "1.3.12.2.1011.7.5"
 *
 */
#define SPX_MECHTYPE_SZ       9

static char SPX_MECHTYPE_VALUE[9] = {
	0x06, 0x07, 0x2b, 0x0c, 0x02, 0x87, 0x73, 0x07, 0x05 };

static gss_OID_desc SPX_MECHTYPE_OID = { 9, (void *) SPX_MECHTYPE_VALUE };

/*
 * Channel Binding Address types
 *
 */

#define GSS_C_AF_UNSPEC       0            /* unspecified */
#define GSS_C_AF_UNIX         1            /* local to host (pipes, portals) */
#define GSS_C_AF_INET         2            /* internetwork: UDP, TCP, etc. */
#define GSS_C_AF_IMPLINK      3            /* arpanet imp addresses */
#define GSS_C_AF_PUP          4            /* pup protocols: e.g. BSP */
#define GSS_C_AF_CHAOS        5            /* mit CHAOS protocols */
#define GSS_C_AF_NS           6            /* XEROX NS protocols */
#define GSS_C_AF_NBS          7            /* nbs protocols  */
#define GSS_C_AF_ECMA         8            /* european computer manufacturers */
#define GSS_C_AF_DATAKIT      9            /* datakit protocols */
#define GSS_C_AF_CCITT        10           /* CCITT protocols, X.25 etc */
#define GSS_C_AF_SNA          11           /* IBM SNA */
#define GSS_C_AF_DECnet       12           /* DECnet */
#define GSS_C_AF_DLI          13           /* Direct data link interface */
#define GSS_C_AF_LAT          14           /* LAT */
#define GSS_C_AF_HYLINK       15           /* NSC Hyperchannel */
#define GSS_C_AF_APPLETALK    16           /* Apple talk */
#define GSS_C_AF_BSC          17           /* BISYNC 2780/3780 */
#define GSS_C_AF_DSS          18           /* Distributed system services */
#define GSS_C_AF_OSI          19           /* OSI TP4 */
#define GSS_C_AF_NULLADDR     256

/*
 * GSS API constants
 */

#define GSS_C_MAX_TOKEN          1024
#define GSS_C_MAX_RESP_TOKEN 8
#define GSS_C_MAX_CRED_HNDL      4
#define GSS_C_MAX_USER_DATA 2048
#define GSS_C_MAX_STATUS_STRING  256
#define GSS_C_MAX_PRINTABLE_NAME 256
#define GSS_C_MAX_PASSWORD 128
#define GSS_C_MAX_OID 256
#define GSS_C_MAX_OID_SET 1024
#define GSS_C_MAX_CHAN_BINDINGS  256

/*
 * GSS API null variables
 */
extern gss_cred_id_t  gss_default_credentials;

#define GSS_C_NULL_OID ((gss_OID) 0)
#define GSS_C_NULL_OID_SET ((gss_OID_set) 0)
#define GSS_C_NO_BUFFER ((gss_buffer_t) 0)
#define GSS_C_NO_CONTEXT ((gss_ctx_id_t) 0)
#define GSS_C_NO_CREDENTIAL ((gss_cred_id_t) 0)

/*

#define GSS_C_DEFAULT_CREDENTIAL (gss_default_credentials)

*/

/*
 * Five independent flags each of which indicates that a context
 * supports a specific service option.
 */
#define GSS_C_DELEG_FLAG     0x0001
#define GSS_C_MUTUAL_FLAG    0x0002 
#define GSS_C_REPLAY_FLAG    0x0004
#define GSS_C_SEQUENCE_FLAG  0x0008 
#define GSS_C_CONF_FLAG      0x0010
#define GSS_C_INTEG_FLAG     0x0020

/*
 * Credential usage options
 */
#define GSS_C_BOTH           0
#define GSS_C_INITIATE       1
#define GSS_C_ACCEPT         2

/*
 * Access modes
 */
#define GSS_C_READ           (1 << 0)
#define GSS_C_WRITE          (1 << 1)
#define GSS_C_EXECUTE        (1 << 2)

/*
 * Display status type codes
 */
#define GSS_C_GSS_CODE       1
#define GSS_C_MECH_CODE      2

/*
 * GSS API status codes
 *
 *    ____________________________________________________________
 *    |               |               |                          |
 *    | Calling Error | Routine Error |    Supplementary Info    |
 *    |               |               |                          |
 *    ------------------------------------------------------------
 *    31            24 23           16 15                        0
 *
 */

/*
 * Calling errors
 */
#define GSS_S_CALL_INACCESSIBLE_READ	0x01000000
#define GSS_S_CALL_INACCESSIBLE_WRITE	0x02000000
#define GSS_S_CALL_BAD_STRUCTURE	0x03000000

/*
 * Routine Errors
 */
#define GSS_S_BAD_MECH			0x00010000
#define GSS_S_BAD_NAME			0x00020000
#define GSS_S_BAD_NAMETYPE		0x00030000
#define GSS_S_BAD_BINDINGS              0x00040000
#define GSS_S_BAD_STATUS                0x00050000
#define GSS_S_BAD_SIG                   0x00060000
#define GSS_S_NO_CRED                   0x00070000
#define GSS_S_NO_CONTEXT                0x00080000
#define GSS_S_DEFECTIVE_TOKEN           0x00090000
#define GSS_S_DEFECTIVE_CREDENTIAL      0x000a0000
#define GSS_S_CREDENTIALS_EXPIRED       0x000b0000
#define GSS_S_CONTEXT_EXPIRED           0x000c0000
#define GSS_S_FAILURE                   0x000d0000

/*
 * Supplementary Status Bits
 */
#define GSS_S_CONTINUE_NEEDED	(1 << 0)
#define GSS_S_DUPLICATE_TOKEN	(1 << 1)
#define GSS_S_OLD_TOKEN		(1 << 2)
#define GSS_S_UNSEQ_TOKEN	(1 << 3)

#define GSS_S_COMPLETE		0

#endif  /*  GSSAPI_DEFS  */
