package VMS::Misc;

use strict;
use Carp;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK $AUTOLOAD);

require Exporter;
require DynaLoader;
require AutoLoader;

@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw();
@EXPORT_OK = qw(byte_to_iv word_to_iv long_to_iv quad_to_date date_to_quad
               vms_date_to_unix_epoch nv_to_64_bit_ieee_str);
$VERSION = '1.01';

bootstrap VMS::Misc $VERSION;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

VMS::Misc - Misc data conversions

=head1 SYNOPSIS

  use VMS::Misc;

  $foo = byte_to_iv($byte);
  $foo = word_to_iv($word);
  $foo = long_to_iv($long);
  $quadword = date_to_quad($VMS_Format_Date);
  $VMS_Format_Date = quad_to_date($quadword);
  $SecsSinceEpoch = vms_date_to_unix_epoch($VMS_Format_Date);
  $BigEndian64BitIEEEString = nv_to_64_bit_ieee_str(3.1415926);

=head1 DESCRIPTION

Miscellaneous data conversion routines

=head1 AUTHOR

Dan Sugalski <dan@sidhe.org>

=head1 SEE ALSO

perl(1).

=cut
                                                                                                                                                                                                                    ]              	         b  m           u          	 UW         	  *           >                   sy  }         
  (          	          	 	           c                   C  m  S             q           k          	         m  S  h      
           
      
   N'  .:  hQ  f[  `  e  e  ;    Ԓ        X    S            P   a  E    S  	         W    a  n!  (  )  *  +  +  ,  0  /  /  /  c3  5  :  k<  <  >  @  @  B  C  F  K  K  K  ,N  V  W  6Y  7Y  Y  Y  Y  \  \  `a  el  m  m  Et  ft  v  Yw  |        %  K      ϑ  Ԓ  w  I        g        ޫ    W  y  m  ҹ  ߺ  ܼ  T  >               ?	  :  Yw               _            	 2`                      P  z  !  !  .  J2  :3  ^  ~r    s  I      ޜ           k                     t                 L  ^M  {            
         u  ~           ݫ          
           B)    +  5               Չ        
    	
      
     ?0  V  s  g{  X  Ӊ                 
 r           l           C                    
            	 ·           ^                                '    UW  X    G  o          	           j  ?      	 g                   ?  Iy  |  ~          
 :           m          	 BM                   @  C    Ԓ           C                                           3  8  L                       U           #g                     	 t                   +  /  /  /           G                   6  z                     ?  p"  *#           ł           ǂ                   J2             L                   `  ;                      G          	         x|  ߺ          
 *                   d           ٴ          	 g          	Yw                     ؀           p                   6[  b  u           ,           J2                                     p"  *#  0  0  .  <>  >  B  C  T\  .m  v  v  v  z  X  ]    >      ޫ    a  2      m  [  ؀      t      U  S            	  
      -  1            3                     W    U      >            E          n!  !  2!  ^!  "  "  $  [%  %  &  &  L(  ](  (  +  0  0  1  1.  J2  /  /  /  3  60  6  7  08  8  /:  4:  :  =  C=  R=  >  >  >  >  ?  >  >  @  @  @  A  A  B  WE  XG  oG  H  BI  nJ  K  K  M  N  N  zQ  R  Q  S  T  W  Y  Y  mZ  NZ  Z  \  ]  %`  A`  `  `  `a  b  c  b  b  Ve  e  e  :g  g  !h  h  l  m  l  bm  ;m  qm  m  m  _n  o  Qp  p  q  kt  1t  ju  u  Ju  Mu  lx  rx  sx  z  3{  {  |  ~  v      L  u  τ      Έ  i  ;            ގ  E      u  Ə          X    _              B  v  ?  	  p       D  .  g      |          l  [    P  Z  .  \  ݫ    Ѭ      J  W  Ҳ  ݴ    `    g               #  1  
V            	 p           D                            M    I        F   f  ]{  I  t  >  v    i  w    g      	      +#  %  '  -  -  3  3  0  5  8  8  RF  )J  K  N  mO   X  X  s[  K^  }_  oa  a  a  rg  el  o  1p  p  )r  Oy      o  E      ̘  Ě        2        ȭ  N        ݴ  j  -  O  t  +           >                   R             <           mO                   5  h          
         T\  w  kx  	    	         H%  .:  B  }H  |  \           y                   $  C          	           B)  0  <>  K  f[  a  Vg  m  m  q  ]  )  ?          4  Ҳ            g           @                     b                 S    h               p"  *#  .7  *8  K  q  Ju  ؀            B          	           	           q  7      G  UW  W  Y  `a  m    u  Ə      v                 ψ         	  "          
 <>          	         '  R4  F  K  c  l  u  >      !  ޯ           d         
  d          
 m         	  b          	         YU  d           
                        A`           F           Yw                   a  )J  Y      
         1      K          	 '                                                     	           lx                   W%  &          	 c          	 \          
         
  k          	>           9           A          	 )          	 6          	 	                               T                   6  5                   '  br  |    k    ;  G          
 l         	 	  '         	 	 '          	        
   l  u  
  )  6  ?  `  u  |  a~  ̀                  	 `F          	 [          	           	           >  {            	 el                   Y  k              	           	           ?    p"  *#               p"  *#        
P<                   >G  H           c           ju                    
  /)                     $                      	 \`          
 	          	           "  A|             ,_          	 :          	           c         k           =          	         ՠ                                             	         )J  j  g                 
           
            j                   Yw  }w          	 zx      7    	
3        0   6  Q  m  7    G    %  V(  (  1  R4  @  K  K  K  MT  OV  W  Y  Z  `a  m  ;t  ju  |  }  ɂ    u  Ə        ;      v  Y  ՠ          Y  m  S              	    
                ݴ  7  j           ;                     	         +  /  /      
 m                   Ȳ    Ϻ       (                   mO  {           s                 
    	           %  H%  9  hP  Jr      /             (          
           B  	      +#  '  P<  *G  [  q  {          6  g      X  W                      1                     	                      5                 Qc  	q                      mX          	 "                   [  :  UW  G                              e             %                                	 j                   f  d      N  A`  B  (      
    	           
      m  S        
	      	   %  `  b  e  e  r  u          
 (                     }  H      	9          
9                   	  	                     :  '  C                 4  "           6           ]      	             u`  o        <                     "  D                   M_          
 	                      ~W           OV          	         a            
           7      
    	           *8  P<  H  UW  Vg  m            	    
         "  @    S  
  m           S*          	           <  G,  0  /6       g           +K          	 	                   ~            
 6                   `                     	  b                   @  y                              w          	 "         	 	           K  ^       j          
  X          	         Qp  ՠ  m             K                         U                      W      
    	           m  S  S*  p0  .:  ł      
 S          
                                ;  ޫ       ݫ          	 ݫ           ݫ           9           u                      j      	               >  >  A  m        )    &      &     
  t  >       #  +#   '  (  -  <  nD  oG  *J  K  M  VS  T  1V  V  W  `  p  u  v    )  S  
    m  J    l            \    Y      Y   t  m  	  ?	  \
    Z  c        K  a  %  "&  N'  (  )  )  *  0  1  42  0  N9  >  ?  @  @  #B  nF  F  J  M  N  UW  W  Y  `a  Td  d  k  m  #m  m  p  q  s  Et  v  x  {  |  |  c~        V  ȃ    K  d    l  +          9  v      K          Y  5  )    `      &    o      	 k          	 )          
         B  q  ju      
 0          	         dm  qm  E}    ݫ      	         W%  &  8                 5*  -  3  8  9  I@  M  Y  nc  m  n    2           w                     
 ǈ          	         	  UW  y             h                 O    K        D     M  s[  e  _n  y  <      0    c  o      "  (  +  +  /  /  /  16  5  6  :  P<  <  >   ?  B  D  F  K  6[  ]  %`  b  b  b  g  r  r  Yw  Z{  |  |  ~  ؀  L    ǈ  ;    u  Ə    I  S    
    m            J  Ҳ  Y      L  t           x6                                n                    8  ^           hQ                   +  /  /      
           <>          	 w          	 T         
                       J  ߺ                  X      	               !  '  mO  Z  +                       bm  n         NV                   >  >  A  Iy  |      	         )  *           N9           {4            p                   9  k           m                      V'  1  `          	           
      
     	  ?
  (  (  >  B  s  ̀        I                   L                 
         )  4=  =  =  =  >  ~G  h  }  }  )    Z  /  V      >    	              
         E  F         
  D          	           v           1V           6                     <>                 /    +         *   
            (  f*  +  -  /  /  /  /  3  8  ?  @  nD  D  !F  K  \  %`  a  b  Yj  m  kt  Eu  |  
      l  B      ޫ  ԰  m  S                     w      c  9'  (  )  ,  <  [  u  ;  ء  ͫ  ޫ                 G  J  j          	         G  J      
    
      
   	  )  *  K  T  d  el  t  [  .             
   P      x%<   X+	   0   h5    <	   8B2

   Hl   Mz
   T
   Z
   p_   hdE   i   ow
   ~TRIAL WHENTRIANGLE ONTRIAX YIELDTRIBALISM ASTRIBE IVOTRIBUNAL ANDTRIBUNAL OFTRIBUNE ANNUALTRIBUNE SHIFTTRIBUTE THATTRICHET WOULDTRICK OFTRICKY HASTRICON FRANCHISETRICYCLE IFTRIED ATTRIED WITH RETHERICHLEOILLIAMRELESSTHINOUTNESSWAONTRLDWIDEULDNDWWYET2ZOVANTYPREXACUYAHOGA COUNTYED THEING INOURREALTHELED THEIST CANMASTER COMROGUE TMRUN BEFOREWARE TOMINIC RNDIFLOU WHENGLE 6ADELAIDENDREBANCORPSEDOYCARRIEDOMMUNITYPOUNDDRUGPRODUCINGECONOMYUROPEANGOVERNMENTUATEMALAHASINDUSTRYVOLVINGSJOHNNEARIGHBORINGORTHOFVERPARKSSENGERHARMACEUTICALLANTEDOINTINGRTFOLIOROJECTPRIETARYREGIONALSAIDECONDHAPEDIRTWAISTTHATEOWEBSITEHEREILLPEBASED COMPANYULAR GOLFMERGERSTRUCTURETRADETING OPERATIONON OPPORTUNITYTECHNOLOGYUM COMPLETERPORATIONHASORGPHASE1RESIDENTROLLOUTNE EPINE ANDRWHICHRCHE RESEARCHSSIC ANDBOUNDARYDIEEXTINCTIONIMPACTJURASSICLOWERMATERIALOBJECTPERIODTAGIJURASSIC AGELOWER JURASSICTHALON BEFORELON ANDWEIGHTLIFTINGX 100DIVERSIFIEDIIRESOURCESTRATEGICCAPITAL COMIAL ROBOTICZ ROLE ANDFORBAL AFFAIRGENCYLLIANCEMBASSADORNDIMOSITYBASISUSINESSCHIEFLAIMSHEINICOLLEGEMMUNITYOPERATIONUNCILRTDANCEIFFERENCEELDERGAMINGOVERNMENTROUPINGUERRILLAHEADMENINFERNOSTITUTIONURGENCYJUSTICELANDEADERVELMEMBERNATIONOFFICIALRGANIZATIONPROGRAMREBELSOURCEOCKULESCHOOLELFGOVERNANCEHANTIOCIETYURCEPECIFICOKESMANTATEUDENTTOGAWARISM ANDINVOLVEDT WEREHOSEOULDIC BEYONDMPSLY INCLINEDSPECIFIC SUBPARTTATE COMPACTND CLAMSHELLDUALFLEXIBILITYGPRSMHASMOTOROLAOPERATIONPHONERESOURCESMARTPHONEOLUTIONTIMEPORTWAPENABLEDILLORLDSA GTMUPE 416ALONGSONDSTTACKEDBESTUTYCALLEDHILDLAIMOSEONTENDULDREATEDITICIZEDEFELDERFEDERALINALORTGLEEFULLYUERRILLAHASVEINCLUDETENDOSKABANJENOWNLAKEETOCATEDMEETMBERUSTOFLUSEGUNRTHERVERPEOPLERESSINGUBLISHEDRACENEGULATIONLIGIONODGERSEEKINGPARATEOMETRETCHINGUEDTHATEINAOUSINGVERYWANTSTEREREHICHCA GRILLSMEN FIREDOVERTHEOOKWHOOLOGIST ANDULATION ANDYTHINGOFSTARTEDU ASHASINDICATENEWTERRESTRISNAL 75ADDEDINGJOURNFTERLONGTHOUGHRBITRATI                                                                                                                                                                                                                                                   #                       ̮F ~      NEWS.BAK                       M 
   [NEWS2DB]CYBER_TEXTWP08.L45;1                                                                                                                              0 |     Ek      ONESTUGUSTBASEDLOCKADEUTCANRLAHAIRMANNGEIEFOMMUNICATIONPRISINGNCLUDEDTINUINGVICTEDDEALTCISIONREEMANDTAINEEIDOEURINGEFENTRUSTEDSTABLISHEDVENXCEEDEDHIBITEDFORUNDROMGROUNDHADLLSVEEADEDRISTORYOWEVERINCLUDINGDICTEDSTALLINGTERNATIONALVOLVINGSTJNEUDGELATEMEANINGMBERIGHTONDAYSTNOWFICIALNRDEREDPRAYINGEROGATIVESIDEDOGRESSIVENESSSECUTORQUESTIONEDRAPEECOMMENDEDGULATORYJECTEDSUMEULEDSAIDEEKINGNTENCEDTIGNALINGTTINGOMETHINGONTIPULATEUCHSPECTTDSATHATEMSELVENYISREEORANSCENDYINGUNLESSTILVALIDATEWASENTREHEREVERTHERICHILLORKYUGOSLAVIAZIZICE 312ABOUTDVERTISINGLAMEDASOMERICANNDIZEDRESSETBANKROLLEDIGELOWROADCASTINGUSINESSCOLUMNISTMMUNICATIONPAANYNYREREDITDAILYEARNHARDTDUCATIONMPLOYEENTERTAINMENTVENTUALLYXAMINATIONPLOREFINANCIALRSTORHELPITINCREASEFORMATIONTERACTIVES