/* This file is DPMISTART.C
**
** Copyright (c) Rainer Schnitker 92,93,94
*/

#include <stdio.h>
#include <stdlib.h>
#include "DPMI.H"
#include "DPMIDOS.H"
#include "EXCEP16.H"
#include "START16.H"
#include "ADOSX16.H"

WORD cs16real,ds16real;             /* 16-bit segments for extender */
WORD code16sel,data16sel;           /* 16-bit cs,ds for extender */
WORD stack16sel;                    /* 16-bit stack */
WORD stackp16;                      /* 16-bit stack */
WORD sel_incr;			/* increment to next selector */
WORD dosmem_sel;		/* selector for the first MB */
char dpmi10 = 0;

static char rm_stack[512];
unsigned real_mode_stack = (unsigned) (rm_stack + 510);

/* private vars */
static WORD DPMIdata_para_needed = 0;
static WORD DPMIdata_segm_address = 0;

extern WORD _psp;		/* new psp after switch to protmode */

/*
** CPU switching for DPMI 0.9
*/
void protected_to_real(WORD errorlevel)
{
    clean_up();
    dos_exit(errorlevel);
    /* program ends here */
}

int real_to_protected(WORD mode)
{
    WORD stackp;
    WORD DPMIflags, DPMIversion;
    BYTE processor;
    DWORD PM_jump;		/* switch to protmode jump */

    cs16real = GetCS();		/* save real mode segments */
    ds16real = GetDS();		/* for real mode calls */

    if (GetDpmiEntryPoint(&PM_jump, &DPMIdata_para_needed,
			  &DPMIflags, &DPMIversion, &processor)) {
	puts("No DPMI-host found!");
	return -1;
    }
    if (mode != 0) {
	puts("this lib is only for 16 bit");
	return -1;
    }
    if (DPMIdata_para_needed) {	/* get DPMI ring 0 stack */
	DPMIdata_segm_address = GetDpmiHostParagraph(DPMIdata_para_needed);
	if (!DPMIdata_segm_address) {
	    puts("Can't alloc memory for the DPMI-host-stack");
	    return -1;
	}
    }
    if (DpmiEnterProtectedMode(PM_jump, mode, DPMIdata_segm_address)) {
	puts("can't switch to Protected Mode");
	return -1;
    }
    /* Now we are in Protected Mode */

    code16sel = GetCS();
    data16sel = stack16sel = GetDS();
    _psp = GetES();
    stackp16 = (WORD) & stackp;

    sel_incr = SelInc();
    /* build selector for first megabyte */
    AllocLDT(1, &dosmem_sel);
    SetBaseAddress(dosmem_sel, 0L);
    SetAccess(dosmem_sel, APP_DATA_SEL, 0);
    SetLimit(dosmem_sel, 1024L * 1024L - 1L);

    return 0;
}

static POINTER16_16 int21v;	/* old int21h handler address */
static POINTER16_16 excep0v, excep1v, excep2v, excep3v, excep4v, excep5v, excep6v,
 excep7v, excep8v, excep9v, excep10v, excep11v, excep12v, excep13v, excep14v,
 excep15v, excep16v, excep17v;

int hangin_extender(void)
{
    WORD alias_cs;              /* alias sel for codesel */
    WORD far *write_cs_word;    /* writing in code */

    /* store ds-sel in code for some interrupt handler */
    if (CreatAlias(code16sel,&alias_cs))          /* get alias for cs */
        return -1;

    /* store 16bit data selector in load_ds function */
    write_cs_word = MK_FP(alias_cs, (WORD) load_ds + 2);
    *write_cs_word = data16sel;

    /* hang in int 0x21 */
    if (GetProtModeVector(0x21, &int21v.sel, &int21v.off) == -1) {
	puts("error:can't get int21");
	return -1;
    }
    if (SetProtModeVector(0x21, code16sel, (WORD) doscall) == -1) {
	puts("error:can't SET int21");
	return -1;
    }

    /* if we want to chain to default int 0x21 */
    write_cs_word=MK_FP(alias_cs,(WORD)int21v.sel);
    *write_cs_word=int21v.sel;
    write_cs_word=MK_FP(alias_cs,(WORD)int21v.off);
    *write_cs_word=int21v.off;

    FreeLDT(alias_cs);

    /* get all exception vectors */
    GetExceptionVector(0, &excep0v.sel, &excep0v.off);
    GetExceptionVector(1, &excep1v.sel, &excep1v.off);
    GetExceptionVector(2, &excep2v.sel, &excep2v.off);
    GetExceptionVector(3, &excep3v.sel, &excep3v.off);
    GetExceptionVector(4, &excep4v.sel, &excep4v.off);
    GetExceptionVector(5, &excep5v.sel, &excep5v.off);
    GetExceptionVector(6, &excep6v.sel, &excep6v.off);
    GetExceptionVector(7, &excep7v.sel, &excep7v.off);
    GetExceptionVector(8, &excep8v.sel, &excep8v.off);
    GetExceptionVector(9, &excep9v.sel, &excep9v.off);
    GetExceptionVector(10, &excep10v.sel, &excep10v.off);
    GetExceptionVector(11, &excep11v.sel, &excep11v.off);
    GetExceptionVector(12, &excep12v.sel, &excep12v.off);
    GetExceptionVector(13, &excep13v.sel, &excep13v.off);
    GetExceptionVector(14, &excep14v.sel, &excep14v.off);
    GetExceptionVector(15, &excep15v.sel, &excep15v.off);
    GetExceptionVector(16, &excep16v.sel, &excep16v.off);
    GetExceptionVector(17, &excep17v.sel, &excep17v.off);

    /* set all excepti vectors */
    SetExceptionVector(0, code16sel, (WORD) FP_LO(excep0_286));
    SetExceptionVector(1, code16sel, (WORD) FP_LO(excep1_286));
    SetExceptionVector(2, code16sel, (WORD) FP_LO(excep2_286));
    SetExceptionVector(3, code16sel, (WORD) FP_LO(excep3_286));
    SetExceptionVector(4, code16sel, (WORD) FP_LO(excep4_286));
    SetExceptionVector(5, code16sel, (WORD) FP_LO(excep5_286));
    SetExceptionVector(6, code16sel, (WORD) FP_LO(excep6_286));
    SetExceptionVector(7, code16sel, (WORD) FP_LO(excep7_286));
    SetExceptionVector(8, code16sel, (WORD) FP_LO(excep8_286));
    SetExceptionVector(9, code16sel, (WORD) FP_LO(excep9_286));
    SetExceptionVector(10, code16sel, (WORD) FP_LO(excep10_286));
    SetExceptionVector(11, code16sel, (WORD) FP_LO(excep11_286));
    SetExceptionVector(12, code16sel, (WORD) FP_LO(excep12_286));
    SetExceptionVector(13, code16sel, (WORD) FP_LO(excep13_286));
    SetExceptionVector(14, code16sel, (WORD) FP_LO(excep14_286));
    SetExceptionVector(15, code16sel, (WORD) FP_LO(excep15_286));
    SetExceptionVector(16, code16sel, (WORD) FP_LO(excep16_286));
    SetExceptionVector(17, code16sel, (WORD) FP_LO(excep17_286));

    return 0;
}

void clean_up(void)
{
    fflush(stdin);
    fflush(stdout);
    fflush(stderr);

    SetProtModeVector(0x21,int21v.sel,int21v.off);

    SetExceptionVector(0, excep0v.sel, excep0v.off);
    SetExceptionVector(1, excep1v.sel, excep1v.off);
    SetExceptionVector(2, excep2v.sel, excep2v.off);
    SetExceptionVector(3, excep3v.sel, excep3v.off);
    SetExceptionVector(4, excep4v.sel, excep4v.off);
    SetExceptionVector(5, excep5v.sel, excep5v.off);
    SetExceptionVector(6, excep6v.sel, excep6v.off);
    SetExceptionVector(7, excep7v.sel, excep7v.off);
    SetExceptionVector(8, excep8v.sel, excep8v.off);
    SetExceptionVector(9, excep9v.sel, excep9v.off);
    SetExceptionVector(10, excep10v.sel, excep10v.off);
    SetExceptionVector(11, excep11v.sel, excep11v.off);
    SetExceptionVector(12, excep12v.sel, excep12v.off);
    SetExceptionVector(13, excep13v.sel, excep13v.off);
    SetExceptionVector(14, excep14v.sel, excep14v.off);
    SetExceptionVector(15, excep15v.sel, excep15v.off);
    SetExceptionVector(16, excep16v.sel, excep16v.off);
    SetExceptionVector(17, excep17v.sel, excep17v.off);
}

REG286 reg;
WORD faultno;

void myexcep13(void)
{
    printf("Protection fault no %d : selector=%X b2=%X b1=%X b0=%X\n",
        faultno,reg.err&(65535-7),(reg.err&4)>>2,(reg.err&2)>>1,reg.err&1 );
    printf("cs:ip=%04X:%04X eflags=%04X\n"
        "AX=%04X BX=%04X CX=%04X DX=%04X BP=%04X SP=%04X\n"
        "SI=%04X DI=%04X CS=%04X DS=%04X ES=%04X SS=%04X\n",
        reg.cs,reg.ip,reg.flags,
        reg.ax,reg.bx,reg.cx,reg.dx,reg.bp,reg.sp,
        reg.si,reg.di,reg.cs,reg.ds,reg.es,reg.ss);
    protected_to_real(1);
}
