;
; [1] '
;
; [2] '
;
; [3] ' ####################  Max Reason
;
; [4] ' #####  PROLOG  #####  copyright 1988-2000
;
; [5] ' ####################  XBasic mathematics function library
;
; [6] '
;
; [7] ' Xma is the XBasic mathematics function library.
;
; [8] ' ---
;
; [9] ' subject to LGPL license - see COPYING_LIB
;
; [10] ' maxreason@maxreason.com
;
; [11] ' for Windows XBasic/XBLite
;
; [12] ' ---
;
; [13] ' Note that this version of Xma is a separate
;
; [14] ' function library, xma.dll. The names of the
;
; [15] ' functions have all been changed to indicate
;
; [16] ' that they are no longer built-in functions;
;
; [17] ' e.g., Sin, Cos, Tan, Log, Log10, Sqrt...
;
; [18] '
;
; [19] ' Version 0.0021  05 Jan 2006 DTS
;
; [20] ' added Fmod and Fround functions
;
; [21] '
;
; [22] PROGRAM	"xma"
;
; [23] VERSION	"0.0021"
;
; [24] '
;
; [25] '
;
; [26] EXPORT
;
; [27] '
;
; [28] ' ###########################
;
; [29] ' #####  xma functions  #####
;
; [30] ' ###########################
;
; [31] '
;
; [32] ' Angles are always in RADIANS
;
; [33] '
;
; [34] DECLARE  FUNCTION  Xma             ()
;
; [35] DECLARE  FUNCTION  XmaVersion$     ()
;
; [37] DECLARE  FUNCTION  DOUBLE  Acos    (DOUBLE x)
;
; [38] DECLARE  FUNCTION  DOUBLE  Acosh   (DOUBLE x)
;
; [39] DECLARE  FUNCTION  DOUBLE  Acot    (DOUBLE x)
;
; [40] DECLARE  FUNCTION  DOUBLE  Acoth   (DOUBLE x)
;
; [41] DECLARE  FUNCTION  DOUBLE  Acsc    (DOUBLE x)
;
; [42] DECLARE  FUNCTION  DOUBLE  Acsch   (DOUBLE x)
;
; [43] DECLARE  FUNCTION  DOUBLE  Asec    (DOUBLE x)
;
; [44] DECLARE  FUNCTION  DOUBLE  Asech   (DOUBLE x)
;
; [45] DECLARE  FUNCTION  DOUBLE  Asin    (DOUBLE x)
;
; [46] DECLARE  FUNCTION  DOUBLE  Asinh   (DOUBLE x)
;
; [47] DECLARE  FUNCTION  DOUBLE  Atanh   (DOUBLE x)
;
; [48] DECLARE  FUNCTION  DOUBLE  Cosh    (DOUBLE x)
;
; [49] DECLARE  FUNCTION  DOUBLE  Cot     (DOUBLE x)
;
; [50] DECLARE  FUNCTION  DOUBLE  Coth    (DOUBLE x)
;
; [51] DECLARE  FUNCTION  DOUBLE  Csc     (DOUBLE x)
;
; [52] DECLARE  FUNCTION  DOUBLE  Csch    (DOUBLE x)
;
; [53] DECLARE  FUNCTION  DOUBLE  Log     (DOUBLE x)
;
; [54] DECLARE  FUNCTION  DOUBLE  Log10   (DOUBLE x)
;
; [55] DECLARE  FUNCTION  DOUBLE  Sec     (DOUBLE x)
;
; [56] DECLARE  FUNCTION  DOUBLE  Sech    (DOUBLE x)
;
; [57] DECLARE  FUNCTION  DOUBLE  Sinh    (DOUBLE x)
;
; [58] DECLARE  FUNCTION  DOUBLE  Tanh    (DOUBLE x)
;
; [60] EXTERNAL FUNCTION  DOUBLE  Atan    (DOUBLE x)
;
; [61] EXTERNAL FUNCTION  DOUBLE  Cos     (DOUBLE x)
;
; [62] EXTERNAL FUNCTION  DOUBLE  Exp     (DOUBLE x)
;
; [63] EXTERNAL FUNCTION  DOUBLE  Exp2    (DOUBLE x)
;
; [64] EXTERNAL FUNCTION  DOUBLE  Exp10   (DOUBLE x)
;
; [65] EXTERNAL FUNCTION  DOUBLE  Power   (DOUBLE x, DOUBLE y)
;
; [66] EXTERNAL FUNCTION  DOUBLE  Sin     (DOUBLE x)
;
; [67] EXTERNAL FUNCTION  DOUBLE  Sqrt    (DOUBLE x)
;
; [68] EXTERNAL FUNCTION  DOUBLE  Tan     (DOUBLE x)
;
; [70] DECLARE  FUNCTION  DOUBLE  Fmod    (DOUBLE num1, DOUBLE num2)
;
; [71] DECLARE  FUNCTION  DOUBLE  Fround  (DOUBLE number, power)
;
; [73] '
;
; [74] END EXPORT
;
; [75] '
;
; [76] INTERNAL FUNCTION  DOUBLE  Asin0   (DOUBLE x)
;
; [77] INTERNAL FUNCTION  DOUBLE  Expmo   (DOUBLE x)
;
; [78] INTERNAL FUNCTION  DOUBLE  Log0    (DOUBLE x)
;
; [79] '
;
; [80] ' for xma:
;
; [81] '
;
; [82] EXTERNAL FUNCTION  XxxFSTCW ()
;
; [83] EXTERNAL FUNCTION  XxxFSTSW ()
;
; [84] '
;
; [85] EXTERNAL FUNCTION  DOUBLE  XxxF2XM1   (x#)
;
; [86] EXTERNAL FUNCTION  DOUBLE  XxxFABS    (x#)
;
; [87] EXTERNAL FUNCTION  DOUBLE  XxxFCHS    (x#)
;
; [88] EXTERNAL FUNCTION  DOUBLE  XxxFCOS    (x#)
;
; [89] EXTERNAL FUNCTION  DOUBLE  XxxFLDZ    ()
;
; [90] EXTERNAL FUNCTION  DOUBLE  XxxFLD1    ()
;
; [91] EXTERNAL FUNCTION  DOUBLE  XxxFLDPI   ()
;
; [92] EXTERNAL FUNCTION  DOUBLE  XxxFLDL2E  ()
;
; [93] EXTERNAL FUNCTION  DOUBLE  XxxFLDL2T  ()
;
; [94] EXTERNAL FUNCTION  DOUBLE  XxxFLDLG2  ()
;
; [95] EXTERNAL FUNCTION  DOUBLE  XxxFLDLN2  ()
;
; [96] EXTERNAL FUNCTION  DOUBLE  XxxFPATAN  (x#, @y#)
;
; [97] EXTERNAL FUNCTION  DOUBLE  XxxFPREM   (x#, @y#)
;
; [98] EXTERNAL FUNCTION  DOUBLE  XxxFPREM1  (x#, @y#)
;
; [99] EXTERNAL FUNCTION  DOUBLE  XxxFPTAN   (x#, @y#)
;
; [100] EXTERNAL FUNCTION  DOUBLE  XxxFRNDINT (x#)
;
; [101] EXTERNAL FUNCTION  DOUBLE  XxxFSCALE  (x#, y#)
;
; [102] EXTERNAL FUNCTION  DOUBLE  XxxFSIN    (x#)
;
; [103] EXTERNAL FUNCTION  DOUBLE  XxxFSINCOS (x#, @y#)
;
; [104] EXTERNAL FUNCTION  DOUBLE  XxxFSQRT   (x#)
;
; [105] EXTERNAL FUNCTION  DOUBLE  XxxFXTRACT (x#, @y#)
;
; [106] EXTERNAL FUNCTION  DOUBLE  XxxFYL2X   (x#, @y#)
;
; [107] EXTERNAL FUNCTION  DOUBLE  XxxFYL2XP1 (x#, @y#)
;
; [108] '
;
; [109] EXPORT
;
; [110] '
;
; [111] ' ###########################
;
; [112] ' #####  xma constants  #####
;
; [113] ' ###########################
;
; [114] '
;
; [115] $$NNAN			=	0dFFFFFFFFFFFFFFFF
;
; [116] $$PNAN			= 0d7FFFFFFFFFFFFFFF
;
; [117] $$NINF			= 0dFFF0000000000000
;
; [118] $$PINF			= 0d7FF0000000000000
;
; [119] $$RADIANS		= 1
;
; [120] $$DEGREES		= 2
;
; [121] $$DEGTORAD	= 0d3F91DF46A2529D39
;
; [122] $$RADTODEG	= 0d404CA5DC1A63C1F8
;
; [123] $$PI				= 0d400921FB54442D18
;
; [124] $$TWOPI			= 0d401921FB54442D18
;
; [125] $$PI3DIV2		= 0d4012D97C7F3321D2
;
; [126] $$PIDIV2		= 0d3FF921FB54442D18
;
; [127] $$PIDIV4		= 0d3FE921FB54442D18
;
; [128] $$INVPI			= 0d3FD45F306DC9C883
;
; [129] $$SQRT2			= 0d3FF6A09E667F3BCD
;
; [130] $$SQRT2DIV2	= 0d3FE6A09E667F3BCD
;
; [131] $$INVSQRT2	= 0d3FE6A09E667F3BCD
;
; [132] $$E					= 0d4005BF0A8B145769
;
; [133] $$LOG2E			= 0d3FF71547652B82FE
;
; [134] $$LOG210		= 0d400A934F0979A371
;
; [135] $$LOGE2			= 0d3FE62E42FEFA39EF
;
; [136] $$LOGE10 		= 0d40026BB1BBB55516
;
; [137] $$LOGESQRT2	= 0d3FD62E42FEFA39EF
;
; [138] $$LOG102		= 0d3FD34413509F79FF
;
; [139] $$LOG10E		= 0d3FDBCB7B1526E50E
;
; [140] $$PIDIV8		= 0d3FD921FB54442D18
;
; [141] $$PI3DIV8		= 0d3FF2D97C7F3321D2
;
; [142] END EXPORT
;
; [144] $$XmaErrorNatureInvalidArgument     = 57
;
; [145] '
;
; [146] '
;
; [147] ' ####################
;
; [148] ' #####  Xma ()  #####
;
; [149] ' ####################
;
; [150] '
;
; [151] FUNCTION  Xma ()
.code
	jmp	%_StartLibrary_xma			;;; i156
PrologCode.xma:
	ret				;;; i158 ;;; end prolog code
%_StartLibrary_xma:
	call	func1.xma			;;; i162c
	ret	0			;;; i162d
align 16
_Xma@0:
;  *****
;  *****  FUNCTION  Xma ()  *****
;  *****
func1.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
	call	%%%%initOnce.xma
	sub	esp,236			;;; i114a
;
funcBody1.xma:
;
; [153] IF LIBRARY(0) THEN RETURN
	sub	esp,64			;;; i487
	mov	eax,0			;;; i659
	xor	eax,eax
	not	eax
	add	esp,64			;;; i600
	test	eax,eax			;;; i220
	jz	>> else.0001.xma			;;; i221
	xor	eax,eax			;;; i862
	jmp	end.func1.xma			;;; i258
else.0001.xma:
end.if.0001.xma:
;
; [154] '
;
; [155] '	a$ = "Max Reason"
;
; [156] '	a$ = "copyright 1988-2000"
;
; [157] '	a$ = "XBasic mathematics function library"
;
; [158] '	a$ = "maxreason@maxreason.com"
;
; [159] '	a$ = ""
;
; [160] '
;
; [161] '
;
; [162] ' the following doesn't work unless the answer is less than 2
;
; [163] ' because the stupid f2xm1 opcode only works if -1 <= x <= +1.
;
; [164] '
;
; [165] '	FOR x# = .01# TO 2# STEP .125#
;
; [166] '		asw = XxxFSTSW ()
;
; [167] '		acw = XxxFSTCW ()
;
; [168] '		a# = EXP (x#)
;
; [169] '		i# = XxxFETOX (x#)
;
; [170] '		zsw = XxxFSTSW ()
;
; [171] '		PRINT FORMAT$("###.###########",x#);;; FORMAT$("###.###########",a#);; FORMAT$("###.###########",i#);; HEX$(asw>>11,1);; HEX$(zsw>>11,1);; HEX$(acw,4)
;
; [172] '	NEXT x#
;
; [173] '	PRINT
;
; [174] '
;
; [175] ' the following doesn't work unless the answer is less than 2
;
; [176] ' because the stupid f2xm1 opcode only works if -1 <= x <= +1.
;
; [177] '
;
; [178] '
;
; [179] '	FOR x# = .01# TO 2# STEP .125#
;
; [180] '		asw = XxxFSTSW ()
;
; [181] '		b# = 10# ** x#
;
; [182] '		j# = XxxFTENTOX (x#)
;
; [183] '		zsw = XxxFSTSW ()
;
; [184] '		PRINT FORMAT$("###.###########",x#);;; FORMAT$("###.###########",b#);; FORMAT$("###.###########",j#);; HEX$(asw>>11,1);; HEX$(zsw>>11,1)
;
; [185] '	NEXT x#
;
; [186] '	PRINT
;
; [187] '
;
; [188] ' the following doesn't work unless the answer is less than 2
;
; [189] ' because the stupid f2xm1 opcode only works if -1 <= x <= +1.
;
; [190] '
;
; [191] '
;
; [192] '	FOR x# = .1# TO 2.0001# STEP .02978#
;
; [193] '		asw = XxxFSTSW ()
;
; [194] '		c# = x# ** x#
;
; [195] '		k# = XxxFYTOX (x#, x#)
;
; [196] '		c$$ = GIANTAT (&c#)
;
; [197] '		x$$ = GIANTAT (&x#)
;
; [198] '		k$$ = GIANTAT (&k#)
;
; [199] '		zsw = XxxFSTSW ()
;
; [200] '		PRINT FORMAT$("###.###########",x#);;; FORMAT$("###.###########",c#);; FORMAT$("###.###########",k#);; HEX$(x$$,16);; HEX$(c$$,16);; HEX$(k$$,16);;; HEX$(asw>>11,1);; HEX$(zsw>>11,1)
;
; [201] '	NEXT x#
;
; [202] '	PRINT
;
; [203] '	RETURN
;
; [204] '
;
; [205] '
;
; [206] ' test math library against pentium instructions
;
; [207] '
;
; [208] ' test constants
;
; [209] '
;
; [210] '	GOSUB TestFLDZ
;
; [211] '	GOSUB TestFLD1
;
; [212] '	GOSUB TestFLDPI
;
; [213] '	GOSUB TestFLDL2E
;
; [214] '	GOSUB TestFLDL2T
;
; [215] '	GOSUB TestFLDLG2
;
; [216] '	GOSUB TestFLDLN2
;
; [217] '
;
; [218] ' test functions
;
; [219] '
;
; [220] '	GOSUB TestF2XM1
;
; [221] '	GOSUB TestFABS
;
; [222] '	GOSUB TestFCHS
;
; [223] '	GOSUB TestFCOS
;
; [224] '	GOSUB TestFPATAN
;
; [225] '	GOSUB TestFPREM
;
; [226] '	GOSUB TestFPREM1
;
; [227] '	GOSUB TestFPTAN
;
; [228] '	GOSUB TestFRNDINT
;
; [229] '	GOSUB TestFSCALE
;
; [230] '	GOSUB TestFSIN
;
; [231] '	GOSUB TestFSINCOS
;
; [232] '	GOSUB TestFSQRT
;
; [233] '	GOSUB TestFXTRACT
;
; [234] '	GOSUB TestFYL2X
;
; [235] '	GOSUB TestFYL2XP1
;
; [236] '
;
; [237] '
;
; [238] '
;
; [239] RETURN
	xor	eax,eax			;;; i862
	jmp	end.func1.xma			;;; i258
;
; [240] '
;
; [241] '
;
; [242] '
;
; [243] ' *****  test subroutines  *****
;
; [244] '
;
; [245] ' 0# vs XxxFLDZ
;
; [246] '
;
; [247] 'SUB TestFLDZ
;
; [248] '	a# = 0#
;
; [249] '	b# = XxxFLDZ ()
;
; [250] '	a$$ = GIANTAT(&a#)
;
; [251] '	b$$ = GIANTAT(&b#)
;
; [252] '	PRINT HEX$(a$$,16);; HEX$(b$$,16)
;
; [253] 'END SUB
;
; [254] '
;
; [255] ' 1# vs XxxFLD1
;
; [256] '
;
; [257] 'SUB TestFLD1
;
; [258] '	a# = 1#
;
; [259] '	b# = XxxFLD1 ()
;
; [260] '	a$$ = GIANTAT(&a#)
;
; [261] '	b$$ = GIANTAT(&b#)
;
; [262] '	PRINT HEX$(a$$,16);; HEX$(b$$,16)
;
; [263] 'END SUB
;
; [264] '
;
; [265] ' $$PI vs XxxFLDPI
;
; [266] '
;
; [267] 'SUB TestFLDPI
;
; [268] '	a# = $$PI
;
; [269] '	b# = XxxFLDPI ()
;
; [270] '	a$$ = GIANTAT(&a#)
;
; [271] '	b$$ = GIANTAT(&b#)
;
; [272] '	PRINT HEX$(a$$,16);; HEX$(b$$,16)
;
; [273] 'END SUB
;
; [274] '
;
; [275] ' $$LOG2E vs XxxFLDL2E
;
; [276] '
;
; [277] 'SUB TestFLDL2E
;
; [278] '	a# = $$LOG2E
;
; [279] '	b# = XxxFLDL2E ()
;
; [280] '	a$$ = GIANTAT(&a#)
;
; [281] '	b$$ = GIANTAT(&b#)
;
; [282] '	PRINT HEX$(a$$,16);; HEX$(b$$,16)
;
; [283] 'END SUB
;
; [284] '
;
; [285] ' $$LOG210 vs XxxFLDL2T
;
; [286] '
;
; [287] 'SUB TestFLDL2T
;
; [288] '	a# = $$LOG210
;
; [289] '	b# = XxxFLDL2T ()
;
; [290] '	a$$ = GIANTAT(&a#)
;
; [291] '	b$$ = GIANTAT(&b#)
;
; [292] '	PRINT HEX$(a$$,16);; HEX$(b$$,16)
;
; [293] 'END SUB
;
; [294] '
;
; [295] ' $$LOG102 vs XxxFLDLG2
;
; [296] '
;
; [297] 'SUB TestFLDLG2
;
; [298] '	a# = $$LOG102
;
; [299] '	b# = XxxFLDLG2 ()
;
; [300] '	a$$ = GIANTAT(&a#)
;
; [301] '	b$$ = GIANTAT(&b#)
;
; [302] '	PRINT HEX$(a$$,16);; HEX$(b$$,16)
;
; [303] 'END SUB
;
; [304] '
;
; [305] ' $$LOGE2 vs XxxFLDLN2
;
; [306] '
;
; [307] 'SUB TestFLDLN2
;
; [308] '	a# = $$LOGE2
;
; [309] '	b# = XxxFLDLN2 ()
;
; [310] '	a$$ = GIANTAT(&a#)
;
; [311] '	b$$ = GIANTAT(&b#)
;
; [312] '	PRINT HEX$(a$$,16);; HEX$(b$$,16)
;
; [313] 'END SUB
;
; [314] '
;
; [315] ' (2# ** x# - 1#) vs XxxF2XM1
;
; [316] '
;
; [317] 'SUB TestF2XM1
;
; [318] '	FOR i# = -1# TO +1# STEP 1# / 64#
;
; [319] '		x# = 2# ** i# - 1#
;
; [320] '		y# = XxxF2XM1 (i#)
;
; [321] '		i$$ = GIANTAT (&i#)
;
; [322] '		x$$ = GIANTAT (&x#)
;
; [323] '		y$$ = GIANTAT (&y#)
;
; [324] '		PRINT FORMAT$ ("##.####", i#);; HEX$(i$$,16);; HEX$(x$$,16);; HEX$(y$$,16);; HEX$(y$$-x$$,16);; FORMAT$ ("##.##################", x#);; FORMAT$ ("##.##################", y#)
;
; [325] '	NEXT i#
;
; [326] 'END SUB
;
; [327] '
;
; [328] ' ABS() vs XxxFABS
;
; [329] '
;
; [330] 'SUB TestFABS
;
; [331] '	FOR i# = -$$TWOPI TO $$TWOPI STEP $$TWOPI / 64#
;
; [332] '		x# = ABS (i#)
;
; [333] '		y# = XxxFABS (i#)
;
; [334] '		i$$ = GIANTAT (&i#)
;
; [335] '		x$$ = GIANTAT (&x#)
;
; [336] '		y$$ = GIANTAT (&y#)
;
; [337] '		PRINT FORMAT$ ("##.####", i#/$$PIDIV2);; HEX$(i$$,16);; HEX$(x$$,16);; HEX$(y$$,16);; HEX$(y$$-x$$,16);; FORMAT$ ("##.##################", x#);; FORMAT$ ("##.##################", y#)
;
; [338] '	NEXT i#
;
; [339] 'END SUB
;
; [340] '
;
; [341] ' - vs XxxFCHS
;
; [342] '
;
; [343] 'SUB TestFCHS
;
; [344] '	FOR i# = -$$TWOPI TO $$TWOPI STEP $$TWOPI / 64#
;
; [345] '		x# = -i#
;
; [346] '		y# = XxxFCHS (i#)
;
; [347] '		i$$ = GIANTAT (&i#)
;
; [348] '		x$$ = GIANTAT (&x#)
;
; [349] '		y$$ = GIANTAT (&y#)
;
; [350] '		PRINT FORMAT$ ("##.####", i#/$$PIDIV2);; HEX$(i$$,16);; HEX$(x$$,16);; HEX$(y$$,16);; HEX$(y$$-x$$,16);; FORMAT$ ("##.##################", x#);; FORMAT$ ("##.##################", y#)
;
; [351] '	NEXT i#
;
; [352] 'END SUB
;
; [353] '
;
; [354] ' COS() vs XxxFCOS
;
; [355] '
;
; [356] 'SUB TestFCOS
;
; [357] '	FOR i# = 0 TO $$TWOPI * 2# STEP $$TWOPI / 64#
;
; [358] '		x# = COS (i#)
;
; [359] '		y# = XxxFCOS (i#)
;
; [360] '		i$$ = GIANTAT (&i#)
;
; [361] '		x$$ = GIANTAT (&x#)
;
; [362] '		y$$ = GIANTAT (&y#)
;
; [363] '		PRINT FORMAT$ ("##.####", i#/$$PIDIV2);; HEX$(i$$,16);; HEX$(x$$,16);; HEX$(y$$,16);; HEX$(y$$-x$$,16);; FORMAT$ ("##.##################", x#);; FORMAT$ ("##.##################", y#)
;
; [364] '	NEXT i#
;
; [365] 'END SUB
;
; [366] '
;
; [367] ' ATAN() vs XxxFPATAN
;
; [368] '
;
; [369] 'SUB TestFPATAN
;
; [370] '	FOR i# = 0# TO $$TWOPI * 2# STEP $$TWOPI / 64#
;
; [371] '		x# = ATAN (i#)
;
; [372] '		y# = XxxFPATAN (i#, 1#)
;
; [373] '		i$$ = GIANTAT (&i#)
;
; [374] '		x$$ = GIANTAT (&x#)
;
; [375] '		y$$ = GIANTAT (&y#)
;
; [376] '		PRINT FORMAT$ ("##.####", i#/$$PIDIV2);; HEX$(i$$,16);; HEX$(x$$,16);; HEX$(y$$,16);; HEX$(y$$-x$$,16);; FORMAT$ ("##.##################", x#);; FORMAT$ ("##.##################", y#)
;
; [377] '	NEXT i#
;
; [378] 'END SUB
;
; [379] '
;
; [380] ' XxxFPREM
;
; [381] '
;
; [382] 'SUB TestFPREM
;
; [383] '	FOR i# = 10# TO 14# STEP .5#
;
; [384] '		FOR j# = -2# TO 2# STEP .35#
;
; [385] '			x# = XxxFPREM (i#, j#)
;
; [386] '			y# = XxxFPREM1 (i#, j#)
;
; [387] '			PRINT FORMAT$ ("##.####", i#);; FORMAT$ ("##.####", j#);; FORMAT$ ("##.####", x#);; FORMAT$ ("##.####", y#)
;
; [388] '		NEXT j#
;
; [389] '	NEXT i#
;
; [390] 'END SUB
;
; [391] '
;
; [392] ' XxxFPREM1
;
; [393] '
;
; [394] 'SUB TestFPREM1
;
; [395] '	FOR i# = 10# TO 14# STEP .5#
;
; [396] '		FOR j# = -2# TO 2# STEP .35#
;
; [397] '			x# = XxxFPREM1 (i#, j#)
;
; [398] '			y# = XxxFPREM (i#, j#)
;
; [399] '			PRINT FORMAT$ ("##.####", i#);; FORMAT$ ("##.####", j#);; FORMAT$ ("##.####", x#);; FORMAT$ ("##.####", y#)
;
; [400] '		NEXT j#
;
; [401] '	NEXT i#
;
; [402] 'END SUB
;
; [403] '
;
; [404] ' TAN() vs XxxFPTAN
;
; [405] '
;
; [406] 'SUB TestFPTAN
;
; [407] '	FOR i# = 0 TO $$TWOPI * 2# STEP $$TWOPI / 64#
;
; [408] '		x# = TAN (i#)
;
; [409] '		k# = XxxFPTAN (i#, @j#)
;
; [410] '		y# = k# / j#
;
; [411] '		i$$ = GIANTAT (&i#)
;
; [412] '		x$$ = GIANTAT (&x#)
;
; [413] '		y$$ = GIANTAT (&y#)
;
; [414] '		PRINT FORMAT$ ("##.####", i#/$$PIDIV2);; HEX$(i$$,16);; HEX$(x$$,16);; HEX$(y$$,16);; HEX$(y$$-x$$,16);; FORMAT$ ("##.##################", x#);; FORMAT$ ("##.##################", y#)
;
; [415] '	NEXT i#
;
; [416] 'END SUB
;
; [417] '
;
; [418] ' INT() and FIX() vs XxxFRNDINT
;
; [419] '
;
; [420] 'SUB TestFRNDINT
;
; [421] '	FOR i# = -2# TO +2# STEP .25#
;
; [422] '		x# = INT (i#)
;
; [423] '		y# = FIX (i#)
;
; [424] '		z# = XxxFRNDINT (i#)
;
; [425] '		i$$ = GIANTAT (&i#)
;
; [426] '		x$$ = GIANTAT (&x#)
;
; [427] '		y$$ = GIANTAT (&y#)
;
; [428] '		z$$ = GIANTAT (&z#)
;
; [429] '		PRINT FORMAT$ ("##.####", i#);; HEX$(i$$,16);; HEX$(x$$,16);; HEX$(y$$,16);; HEX$(z$$,16);; HEX$(z$$-y$$,16);; FORMAT$ ("##.##################", x#);; FORMAT$ ("##.##################", y#);; FORMAT$ ("##.##################", z#)
;
; [430] '		PRINT FORMAT$ ("##.####", i#);; FORMAT$ ("##.##################", x#);; FORMAT$ ("##.##################", y#);; FORMAT$ ("##.##################", z#)
;
; [431] '	NEXT i#
;
; [432] 'END SUB
;
; [433] '
;
; [434] ' (2# ** i * j#) vs XxxFSCALE
;
; [435] '
;
; [436] 'SUB TestFSCALE
;
; [437] '	FOR i# = -2# TO 2# STEP .25#
;
; [438] '		FOR j# = -2# TO 2# STEP .25#
;
; [439] '			x# = 2# ** DOUBLE(FIX(i#)) * j#
;
; [440] '			y# = XxxFSCALE (i#, j#)
;
; [441] '			i$$ = GIANTAT (&i#)
;
; [442] '			x$$ = GIANTAT (&x#)
;
; [443] '			y$$ = GIANTAT (&y#)
;
; [444] '			PRINT FORMAT$ ("##.####", i#);; FORMAT$ ("##.####", j#);; HEX$(i$$,16);; HEX$(x$$,16);; HEX$(y$$,16);; HEX$(y$$-x$$,16);; FORMAT$ ("##.##################", x#);; FORMAT$ ("##.##################", y#)
;
; [445] '		NEXT j#
;
; [446] '	NEXT i#
;
; [447] 'END SUB
;
; [448] '
;
; [449] ' SIN() vs XxxFSIN
;
; [450] '
;
; [451] 'SUB TestFSIN
;
; [452] '	FOR i# = 0 TO $$TWOPI * 2# STEP $$TWOPI / 64#
;
; [453] '		x# = SIN (i#)
;
; [454] '		y# = XxxFSIN (i#)
;
; [455] '		i$$ = GIANTAT (&i#)
;
; [456] '		x$$ = GIANTAT (&x#)
;
; [457] '		y$$ = GIANTAT (&y#)
;
; [458] '		PRINT FORMAT$ ("##.####", i#/$$PIDIV2);; HEX$(i$$,16);; HEX$(x$$,16);; HEX$(y$$,16);; HEX$(y$$-x$$,16);; FORMAT$ ("##.##################", x#);; FORMAT$ ("##.##################", y#)
;
; [459] '	NEXT i#
;
; [460] 'END SUB
;
; [461] '
;
; [462] ' SIN() and COS() vs XxxFSINCOS
;
; [463] '
;
; [464] 'SUB TestFSINCOS
;
; [465] '	FOR i# = 0 TO $$TWOPI * 2# STEP $$TWOPI / 64#
;
; [466] '		x# = SIN (i#)
;
; [467] '		xx# = COS (i#)
;
; [468] '		y# = XxxFSINCOS (i#, @z#)
;
; [469] '		i$$ = GIANTAT (&i#)
;
; [470] '		x$$ = GIANTAT (&x#)
;
; [471] '		xx$$ = GIANTAT (&xx#)
;
; [472] '		y$$ = GIANTAT (&y#)
;
; [473] '		z$$ = GIANTAT (&z#)
;
; [474] '		PRINT FORMAT$ ("##.####", i#/$$PIDIV2);; HEX$(i$$,16);; HEX$(x$$,16);; HEX$(xx$$,16);; HEX$(y$$,16);; HEX$(z$$,16);; HEX$(y$$-x$$,16);; HEX$(z$$-xx$$,16);; FORMAT$ ("##.##################", x#);; FORMAT$ ("##.##################", y#)
;
; [475] '	NEXT i#
;
; [476] 'END SUB
;
; [477] '
;
; [478] ' SQRT() vs XxxFSQRT
;
; [479] '
;
; [480] 'SUB TestFSQRT
;
; [481] '	FOR i# = 0 TO $$TWOPI * 2# STEP $$TWOPI / 64#
;
; [482] '		x# = SQRT (i#)
;
; [483] '		y# = XxxFSQRT (i#)
;
; [484] '		i$$ = GIANTAT (&i#)
;
; [485] '		x$$ = GIANTAT (&x#)
;
; [486] '		y$$ = GIANTAT (&y#)
;
; [487] '		PRINT FORMAT$ ("##.####", i#);; HEX$(i$$,16);; HEX$(x$$,16);; HEX$(y$$,16);; HEX$(y$$-x$$,16);; FORMAT$ ("##.##################", x#);; FORMAT$ ("##.##################", y#)
;
; [488] '	NEXT i#
;
; [489] 'END SUB
;
; [490] '
;
; [491] ' XxxFXTRACT
;
; [492] '
;
; [493] 'SUB TestFXTRACT
;
; [494] '	FOR i# = .25# TO 2# STEP 1# / 64#
;
; [495] '		y# = XxxFXTRACT (i#, @j#)
;
; [496] '		i$$ = GIANTAT (&i#)
;
; [497] '		j$$ = GIANTAT (&j#)
;
; [498] '		y$$ = GIANTAT (&y#)
;
; [499] '		PRINT FORMAT$ ("##.####", i#);; HEX$(i$$,16);; HEX$(j$$,16);; HEX$(y$$,16);; FORMAT$ ("##.##################", y#);; FORMAT$ ("##.##################", j#)
;
; [500] '	NEXT i#
;
; [501] 'END SUB
;
; [502] '
;
; [503] ' XxxFYL2X
;
; [504] '
;
; [505] 'SUB TestFYL2X
;
; [506] '	FOR i# = 1# TO 2# STEP .25#
;
; [507] '		FOR j# = 1# TO 2# STEP .25#
;
; [508] '			y# = XxxFYL2X (i#, j#)
;
; [509] '			i$$ = GIANTAT (&i#)
;
; [510] '			j$$ = GIANTAT (&j#)
;
; [511] '			y$$ = GIANTAT (&y#)
;
; [512] '			z$$ = GIANTAT (&z#)
;
; [513] '			PRINT FORMAT$ ("##.####", i#);; FORMAT$ ("##.####", j#);; HEX$(i$$,16);; HEX$(y$$,16);; HEX$(y$$-x$$,16);; FORMAT$ ("##.##################", y#)
;
; [514] '		NEXT j#
;
; [515] '	NEXT i#
;
; [516] 'END SUB
;
; [517] '
;
; [518] ' XxxFYL2XP1
;
; [519] '
;
; [520] 'SUB TestFYL2XP1
;
; [521] '	FOR i# = 1# TO 2# STEP .25#
;
; [522] '		FOR j# = 1# TO 2# STEP .25#
;
; [523] '			y# = XxxFYL2XP1 (i#, j#)
;
; [524] '			i$$ = GIANTAT (&i#)
;
; [525] '			j$$ = GIANTAT (&j#)
;
; [526] '			y$$ = GIANTAT (&y#)
;
; [527] '			z$$ = GIANTAT (&z#)
;
; [528] '			PRINT FORMAT$ ("##.####", i#);; FORMAT$ ("##.####", j#);; HEX$(i$$,16);; HEX$(y$$,16);; HEX$(y$$-x$$,16);; FORMAT$ ("##.##################", y#)
;
; [529] '		NEXT j#
;
; [530] '	NEXT i#
;
; [531] 'END SUB
;
; [532] 'END FUNCTION
;
; [533] END FUNCTION
	xor	eax,eax			;;; i862
align 8
end.Xma.xma:  ;;; Function end label for Assembly Programmers.
end.func1.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret						;;; i111d
;-peep
;  *****
;  *****  END FUNCTION  Xma ()  *****
;  *****
%%%%initOnce.xma:
	cmp d[%%%entered.xma],-1		;;; i117
	jne > A.3	;;; i117a
	ret			;;; i117b
A.3:
	call	PrologCode.xma			;;; i118a
	mov esi,addr %_begin_external_data_xma
	mov edi,addr %_end_external_data_xma
	call %_ZeroMemory
	call	InitSharedComposites.xma			;;; i119
	mov	d[%%%entered.xma],-1
	ret				;;; i120
data section 'xma$internals'
align 4
%%%entered.xma:
db 4 dup ?
.code
;
; [534] '
;
; [535] '
;
; [536] '  ############################
;
; [537] '  #####  XmaVersion$ ()  #####
;
; [538] '  ############################
;
; [539] '
;
; [540] FUNCTION  XmaVersion$ ()
.code
align 16
_XmaVersion$@0:
;  *****
;  *****  FUNCTION  XmaVersion$ ()  *****
;  *****
func2.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	push	0			;;; .
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,232			;;; i114a
;
funcBody2.xma:
;
; [541] version$ = VERSION$ (0)
;
#ifdef XmaVersion$.version$
#undef XmaVersion$.version$
#endif
#define XmaVersion$.version$ ebp-24	; exposes local variable 'version$'
;
	sub	esp,64			;;; i487
	mov	d[esp],0
	mov	eax,addr @_string.002A.xma			;;; i663
	call	%_clone.a0
	add	esp,64			;;; i600
	lea	ebx,[ebp-24]			;;; i5
	mov	esi,d[ebx]			;;; i6a
	mov	d[ebx],eax			;;; i6b
	call	%____free			;;; i6c
;
; [542] RETURN (version$)
	mov	eax,[ebp-24]			;;; i665
	call	%_clone.a0			;;; i870
	jmp	end.func2.xma			;;; i258
;
; [543] END FUNCTION
	xor	eax,eax			;;; i862
align 8
end.XmaVersion$.xma:  ;;; Function end label for Assembly Programmers.
end.func2.xma:
	mov	esi,[ebp-24]			;;; i665
	call	%____free			;;; i423
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret						;;; i111d
;-peep
;  *****
;  *****  END FUNCTION  XmaVersion$ ()  *****
;  *****
;
; [544] '
;
; [545] '
;
; [546] ' #####################
;
; [547] ' #####  Acos ()  #####
;
; [548] ' #####################
;
; [549] '
;
; [550] FUNCTION DOUBLE Acos (DOUBLE v) DOUBLE
.code
;
#ifdef Acos.v
#undef Acos.v
#endif
#define Acos.v ebp+8	; exposes function argument 'v'
;
align 16
_Acos@8:
;  *****
;  *****  FUNCTION  Acos ()  *****
;  *****
func3.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	push	0			;;; .
	push	0			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,228			;;; i114a
;
funcBody3.xma:
;
; [551] '
;
; [552] SELECT CASE TRUE
;
; [553] CASE (v < -1#)			: errLast = ERROR($$XmaErrorNatureInvalidArgument) : RETURN ($$PNAN)
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fchs				;;; i922
	fld	q[ebp+8]			;;; i643a
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	jae	>> case.0002.0001.xma			;;; i219
;
#ifdef Acos.errLast
#undef Acos.errLast
#endif
#define Acos.errLast ebp-28	; exposes local variable 'errLast'
;
	sub	esp,64			;;; i487
	mov	eax,57			;;; i659
	call	%_error
	add	esp,64			;;; i600
	mov	d[ebp-8],eax			;;; i17
	fild	d[ebp-8]			;;; i18
	fstp	q[ebp-28]			;;; i669
	push	2147483647			;;; i650
	push	-1			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func3.xma			;;; i258
;
; [554] CASE (v > 1#)				: errLast = ERROR($$XmaErrorNatureInvalidArgument) : RETURN ($$PNAN)
	jmp	end.select.0002.xma			;;; i69
case.0002.0001.xma:
	fld	q[ebp+8]			;;; i664
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jae	>> case.0002.0002.xma			;;; i219
	sub	esp,64			;;; i487
	mov	eax,57			;;; i659
	call	%_error
	add	esp,64			;;; i600
	mov	d[ebp-8],eax			;;; i17
	fild	d[ebp-8]			;;; i18
	fstp	q[ebp-28]			;;; i669
	push	2147483647			;;; i650
	push	-1			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func3.xma			;;; i258
;
; [555] CASE (v = -1#)			: RETURN ($$PI)
	jmp	end.select.0002.xma			;;; i69
case.0002.0002.xma:
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fchs				;;; i922
	fld	q[ebp+8]			;;; i643a
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	jne	>> case.0002.0003.xma			;;; i219
	push	1074340347			;;; i650
	push	1413754136			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func3.xma			;;; i258
;
; [556] CASE (v =  0#)			: RETURN ($$PIDIV2)
	jmp	end.select.0002.xma			;;; i69
case.0002.0003.xma:
	fld	q[ebp+8]			;;; i664
	push	0			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jne	>> case.0002.0004.xma			;;; i219
	push	1073291771			;;; i650
	push	1413754136			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func3.xma			;;; i258
;
; [557] CASE (v =  1#)			: RETURN (0#)
	jmp	end.select.0002.xma			;;; i69
case.0002.0004.xma:
	fld	q[ebp+8]			;;; i664
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jne	>> case.0002.0005.xma			;;; i219
	push	0			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func3.xma			;;; i258
;
; [558] CASE ELSE						: RETURN ($$PIDIV2 - Asin(v))
	jmp	end.select.0002.xma			;;; i69
case.0002.0005.xma:
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	funcB.xma			;;; i619
	push	1073291771			;;; i650
	push	1413754136			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsubr				;;; i841
	jmp	end.func3.xma			;;; i258
;
; [559] END SELECT
end.select.0002.xma:
;
; [560] END FUNCTION
	fldz				;;; i861
align 8
end.Acos.xma:  ;;; Function end label for Assembly Programmers.
end.func3.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Acos ()  *****
;  *****
;
; [561] '
;
; [562] '
;
; [563] ' ######################
;
; [564] ' #####  Acosh ()  #####
;
; [565] ' ######################
;
; [566] '
;
; [567] FUNCTION DOUBLE Acosh (DOUBLE v) DOUBLE
.code
;
#ifdef Acosh.v
#undef Acosh.v
#endif
#define Acosh.v ebp+8	; exposes function argument 'v'
;
align 16
_Acosh@8:
;  *****
;  *****  FUNCTION  Acosh ()  *****
;  *****
func4.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	push	0			;;; .
	push	0			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,228			;;; i114a
;
funcBody4.xma:
;
; [568] '
;
; [569] SELECT CASE TRUE
;
; [570] CASE (v < 1#)			: errLast = ERROR($$XmaErrorNatureInvalidArgument) : RETURN ($$PNAN)
	fld	q[ebp+8]			;;; i664
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jbe	>> case.0003.0001.xma			;;; i219
;
#ifdef Acosh.errLast
#undef Acosh.errLast
#endif
#define Acosh.errLast ebp-28	; exposes local variable 'errLast'
;
	sub	esp,64			;;; i487
	mov	eax,57			;;; i659
	call	%_error
	add	esp,64			;;; i600
	mov	d[ebp-8],eax			;;; i17
	fild	d[ebp-8]			;;; i18
	fstp	q[ebp-28]			;;; i669
	push	2147483647			;;; i650
	push	-1			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func4.xma			;;; i258
;
; [571] CASE (v > 1d20)		: RETURN (Log(2#*v))
	jmp	end.select.0003.xma			;;; i69
case.0003.0001.xma:
	fld	q[ebp+8]			;;; i664
	push	1142271773			;;; i650
	push	2025163840			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jae	>> case.0003.0002.xma			;;; i219
	push	1073741824			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	func13.xma			;;; i619
	jmp	end.func4.xma			;;; i258
;
; [572] CASE ELSE					: RETURN (Log(v + Sqrt(v*v - 1#)))
	jmp	end.select.0003.xma			;;; i69
case.0003.0002.xma:
	fld	q[ebp+8]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsub				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	_Sqrt@8			;;; i619
	fld	q[ebp+8]			;;; i643a
	fadd				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	func13.xma			;;; i619
	jmp	end.func4.xma			;;; i258
;
; [573] END SELECT
end.select.0003.xma:
;
; [574] END FUNCTION
	fldz				;;; i861
align 8
end.Acosh.xma:  ;;; Function end label for Assembly Programmers.
end.func4.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Acosh ()  *****
;  *****
;
; [575] '
;
; [576] '
;
; [577] ' #####################
;
; [578] ' #####  Acot ()  #####
;
; [579] ' #####################
;
; [580] '
;
; [581] FUNCTION DOUBLE Acot (DOUBLE v) DOUBLE
.code
;
#ifdef Acot.v
#undef Acot.v
#endif
#define Acot.v ebp+8	; exposes function argument 'v'
;
align 16
_Acot@8:
;  *****
;  *****  FUNCTION  Acot ()  *****
;  *****
func5.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
	sub	esp,236			;;; i114a
;
funcBody5.xma:
;
; [582] IF (v > 1#) THEN RETURN (Atan(1#/v))
	fld	q[ebp+8]			;;; i664
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jae	>> else.0004.xma			;;; i219
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp+8]			;;; i643a
	fdiv				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	_Atan@8			;;; i619
	jmp	end.func5.xma			;;; i258
else.0004.xma:
end.if.0004.xma:
;
; [583] RETURN ($$PIDIV2 - Atan(v))
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	_Atan@8			;;; i619
	push	1073291771			;;; i650
	push	1413754136			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsubr				;;; i841
	jmp	end.func5.xma			;;; i258
;
; [584] END FUNCTION
	fldz				;;; i861
align 8
end.Acot.xma:  ;;; Function end label for Assembly Programmers.
end.func5.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Acot ()  *****
;  *****
;
; [585] '
;
; [586] '
;
; [587] ' ######################
;
; [588] ' #####  Acoth ()  #####
;
; [589] ' ######################
;
; [590] '
;
; [591] FUNCTION DOUBLE Acoth (DOUBLE v) DOUBLE
.code
;
#ifdef Acoth.v
#undef Acoth.v
#endif
#define Acoth.v ebp+8	; exposes function argument 'v'
;
align 16
_Acoth@8:
;  *****
;  *****  FUNCTION  Acoth ()  *****
;  *****
func6.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	push	0			;;; .
	push	0			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,228			;;; i114a
;
funcBody6.xma:
;
; [592] '
;
; [593] SELECT CASE TRUE
;
; [594] CASE (ABS(v) > 1#)	: RETURN (Atanh(1#/v))
	sub	esp,64			;;; i487
	mov	eax,d[ebp+8]			;;; i665
	mov	edx,d[ebp+12]
	mov	d[esp],eax			;;; i885
	mov	d[esp+4],edx			;;; i886
	call	%_abs.double			;;; i494
	add	esp,64			;;; i600
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	jae	>> case.0005.0001.xma			;;; i219
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp+8]			;;; i643a
	fdiv				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	funcD.xma			;;; i619
	jmp	end.func6.xma			;;; i258
;
; [595] CASE ELSE						: errLast = ERROR($$XmaErrorNatureInvalidArgument) : RETURN ($$PNAN)
	jmp	end.select.0005.xma			;;; i69
case.0005.0001.xma:
;
#ifdef Acoth.errLast
#undef Acoth.errLast
#endif
#define Acoth.errLast ebp-28	; exposes local variable 'errLast'
;
	sub	esp,64			;;; i487
	mov	eax,57			;;; i659
	call	%_error
	add	esp,64			;;; i600
	mov	d[ebp-8],eax			;;; i17
	fild	d[ebp-8]			;;; i18
	fstp	q[ebp-28]			;;; i669
	push	2147483647			;;; i650
	push	-1			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func6.xma			;;; i258
;
; [596] END SELECT
end.select.0005.xma:
;
; [597] END FUNCTION
	fldz				;;; i861
align 8
end.Acoth.xma:  ;;; Function end label for Assembly Programmers.
end.func6.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Acoth ()  *****
;  *****
;
; [598] '
;
; [599] '
;
; [600] ' #####################
;
; [601] ' #####  Acsc ()  #####
;
; [602] ' #####################
;
; [603] '
;
; [604] FUNCTION DOUBLE Acsc (DOUBLE v) DOUBLE
.code
;
#ifdef Acsc.v
#undef Acsc.v
#endif
#define Acsc.v ebp+8	; exposes function argument 'v'
;
align 16
_Acsc@8:
;  *****
;  *****  FUNCTION  Acsc ()  *****
;  *****
func7.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	push	0			;;; .
	push	0			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,228			;;; i114a
;
funcBody7.xma:
;
; [605] '
;
; [606] SELECT CASE TRUE
;
; [607] CASE (ABS(v) < 1#)	: errLast = ERROR($$XmaErrorNatureInvalidArgument) : RETURN ($$PNAN)
	sub	esp,64			;;; i487
	mov	eax,d[ebp+8]			;;; i665
	mov	edx,d[ebp+12]
	mov	d[esp],eax			;;; i885
	mov	d[esp+4],edx			;;; i886
	call	%_abs.double			;;; i494
	add	esp,64			;;; i600
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	jbe	>> case.0006.0001.xma			;;; i219
;
#ifdef Acsc.errLast
#undef Acsc.errLast
#endif
#define Acsc.errLast ebp-28	; exposes local variable 'errLast'
;
	sub	esp,64			;;; i487
	mov	eax,57			;;; i659
	call	%_error
	add	esp,64			;;; i600
	mov	d[ebp-8],eax			;;; i17
	fild	d[ebp-8]			;;; i18
	fstp	q[ebp-28]			;;; i669
	push	2147483647			;;; i650
	push	-1			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func7.xma			;;; i258
;
; [608] CASE ELSE:					: RETURN (Asin(1#/v))
	jmp	end.select.0006.xma			;;; i69
case.0006.0001.xma:
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp+8]			;;; i643a
	fdiv				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	funcB.xma			;;; i619
	jmp	end.func7.xma			;;; i258
;
; [609] END SELECT
end.select.0006.xma:
;
; [610] END FUNCTION
	fldz				;;; i861
align 8
end.Acsc.xma:  ;;; Function end label for Assembly Programmers.
end.func7.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Acsc ()  *****
;  *****
;
; [611] '
;
; [612] '
;
; [613] ' ######################
;
; [614] ' #####  Acsch ()  #####
;
; [615] ' ######################
;
; [616] '
;
; [617] FUNCTION DOUBLE Acsch (DOUBLE v) DOUBLE
.code
;
#ifdef Acsch.v
#undef Acsch.v
#endif
#define Acsch.v ebp+8	; exposes function argument 'v'
;
align 16
_Acsch@8:
;  *****
;  *****  FUNCTION  Acsch ()  *****
;  *****
func8.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	push	0			;;; .
	push	0			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,228			;;; i114a
;
funcBody8.xma:
;
; [618] '
;
; [619] SELECT CASE TRUE
;
; [620] CASE (v = 0#)	: errLast = ERROR($$XmaErrorNatureInvalidArgument) : RETURN ($$PNAN)
	fld	q[ebp+8]			;;; i664
	push	0			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jne	>> case.0007.0001.xma			;;; i219
;
#ifdef Acsch.errLast
#undef Acsch.errLast
#endif
#define Acsch.errLast ebp-28	; exposes local variable 'errLast'
;
	sub	esp,64			;;; i487
	mov	eax,57			;;; i659
	call	%_error
	add	esp,64			;;; i600
	mov	d[ebp-8],eax			;;; i17
	fild	d[ebp-8]			;;; i18
	fstp	q[ebp-28]			;;; i669
	push	2147483647			;;; i650
	push	-1			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func8.xma			;;; i258
;
; [621] CASE ELSE			: RETURN (Asinh(1#/v))
	jmp	end.select.0007.xma			;;; i69
case.0007.0001.xma:
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp+8]			;;; i643a
	fdiv				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	funcC.xma			;;; i619
	jmp	end.func8.xma			;;; i258
;
; [622] END SELECT
end.select.0007.xma:
;
; [623] END FUNCTION
	fldz				;;; i861
align 8
end.Acsch.xma:  ;;; Function end label for Assembly Programmers.
end.func8.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Acsch ()  *****
;  *****
;
; [624] '
;
; [625] '
;
; [626] ' #####################
;
; [627] ' #####  Asec ()  #####
;
; [628] ' #####################
;
; [629] '
;
; [630] FUNCTION DOUBLE Asec (DOUBLE v) DOUBLE
.code
;
#ifdef Asec.v
#undef Asec.v
#endif
#define Asec.v ebp+8	; exposes function argument 'v'
;
align 16
_Asec@8:
;  *****
;  *****  FUNCTION  Asec ()  *****
;  *****
func9.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	push	0			;;; .
	push	0			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,228			;;; i114a
;
funcBody9.xma:
;
; [631] '
;
; [632] IF (ABS(v) < 1#) THEN errLast = ERROR($$XmaErrorNatureInvalidArgument) : RETURN ($$PNAN)
	sub	esp,64			;;; i487
	mov	eax,d[ebp+8]			;;; i665
	mov	edx,d[ebp+12]
	mov	d[esp],eax			;;; i885
	mov	d[esp+4],edx			;;; i886
	call	%_abs.double			;;; i494
	add	esp,64			;;; i600
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	jbe	>> else.0008.xma			;;; i219
;
#ifdef Asec.errLast
#undef Asec.errLast
#endif
#define Asec.errLast ebp-28	; exposes local variable 'errLast'
;
	sub	esp,64			;;; i487
	mov	eax,57			;;; i659
	call	%_error
	add	esp,64			;;; i600
	mov	d[ebp-8],eax			;;; i17
	fild	d[ebp-8]			;;; i18
	fstp	q[ebp-28]			;;; i669
	push	2147483647			;;; i650
	push	-1			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func9.xma			;;; i258
else.0008.xma:
end.if.0008.xma:
;
; [633] RETURN ($$PIDIV2 - Asin(1#/v))
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp+8]			;;; i643a
	fdiv				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	funcB.xma			;;; i619
	push	1073291771			;;; i650
	push	1413754136			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsubr				;;; i841
	jmp	end.func9.xma			;;; i258
;
; [634] END FUNCTION
	fldz				;;; i861
align 8
end.Asec.xma:  ;;; Function end label for Assembly Programmers.
end.func9.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Asec ()  *****
;  *****
;
; [635] '
;
; [636] '
;
; [637] ' ######################
;
; [638] ' #####  Asech ()  #####
;
; [639] ' ######################
;
; [640] '
;
; [641] FUNCTION DOUBLE Asech (DOUBLE v) DOUBLE
.code
;
#ifdef Asech.v
#undef Asech.v
#endif
#define Asech.v ebp+8	; exposes function argument 'v'
;
align 16
_Asech@8:
;  *****
;  *****  FUNCTION  Asech ()  *****
;  *****
funcA.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	push	0			;;; .
	push	0			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,228			;;; i114a
;
funcBodyA.xma:
;
; [642] '
;
; [643] SELECT CASE TRUE
;
; [644] CASE (v <= 0#)		: errLast = ERROR($$XmaErrorNatureInvalidArgument) : RETURN ($$PNAN)
	fld	q[ebp+8]			;;; i664
	push	0			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jb	>> case.0009.0001.xma			;;; i219
;
#ifdef Asech.errLast
#undef Asech.errLast
#endif
#define Asech.errLast ebp-28	; exposes local variable 'errLast'
;
	sub	esp,64			;;; i487
	mov	eax,57			;;; i659
	call	%_error
	add	esp,64			;;; i600
	mov	d[ebp-8],eax			;;; i17
	fild	d[ebp-8]			;;; i18
	fstp	q[ebp-28]			;;; i669
	push	2147483647			;;; i650
	push	-1			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.funcA.xma			;;; i258
;
; [645] CASE (v > 1#)			: errLast = ERROR($$XmaErrorNatureInvalidArgument) : RETURN ($$PNAN)
	jmp	end.select.0009.xma			;;; i69
case.0009.0001.xma:
	fld	q[ebp+8]			;;; i664
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jae	>> case.0009.0002.xma			;;; i219
	sub	esp,64			;;; i487
	mov	eax,57			;;; i659
	call	%_error
	add	esp,64			;;; i600
	mov	d[ebp-8],eax			;;; i17
	fild	d[ebp-8]			;;; i18
	fstp	q[ebp-28]			;;; i669
	push	2147483647			;;; i650
	push	-1			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.funcA.xma			;;; i258
;
; [646] CASE ELSE					: RETURN (Acosh(1#/v))
	jmp	end.select.0009.xma			;;; i69
case.0009.0002.xma:
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp+8]			;;; i643a
	fdiv				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	func4.xma			;;; i619
	jmp	end.funcA.xma			;;; i258
;
; [647] END SELECT
end.select.0009.xma:
;
; [648] END FUNCTION
	fldz				;;; i861
align 8
end.Asech.xma:  ;;; Function end label for Assembly Programmers.
end.funcA.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Asech ()  *****
;  *****
;
; [649] '
;
; [650] '
;
; [651] ' #####################
;
; [652] ' #####  Asin ()  #####  Returns values between -PI/2 and +PI/2 inclusive
;
; [653] ' #####################
;
; [654] '
;
; [655] FUNCTION DOUBLE Asin (DOUBLE a) DOUBLE
.code
;
#ifdef Asin.a
#undef Asin.a
#endif
#define Asin.a ebp+8	; exposes function argument 'a'
;
align 16
_Asin@8:
;  *****
;  *****  FUNCTION  Asin ()  *****
;  *****
funcB.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	mov	ecx,2				;;; ..
	xor	eax,eax			;;; ...
A.32:
	push	eax, eax, eax, eax
	dec	ecx					;;; ....
	jnz	< A.32			;;; .....
	push	eax				;;; ......
	push	eax				;;; ......
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,196			;;; i114a
;
funcBodyB.xma:
;
; [656] '
;
; [657] SELECT CASE TRUE
;
; [658] CASE (ABS(a) > 1#)			: errLast = ERROR($$XmaErrorNatureInvalidArgument) : RETURN ($$PNAN)
	sub	esp,64			;;; i487
	mov	eax,d[ebp+8]			;;; i665
	mov	edx,d[ebp+12]
	mov	d[esp],eax			;;; i885
	mov	d[esp+4],edx			;;; i886
	call	%_abs.double			;;; i494
	add	esp,64			;;; i600
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	jae	>> case.000A.0001.xma			;;; i219
;
#ifdef Asin.errLast
#undef Asin.errLast
#endif
#define Asin.errLast ebp-28	; exposes local variable 'errLast'
;
	sub	esp,64			;;; i487
	mov	eax,57			;;; i659
	call	%_error
	add	esp,64			;;; i600
	mov	d[ebp-8],eax			;;; i17
	fild	d[ebp-8]			;;; i18
	fstp	q[ebp-28]			;;; i669
	push	2147483647			;;; i650
	push	-1			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.funcB.xma			;;; i258
;
; [659] CASE (ABS(a) < 1d-5)		: RETURN (a*(1#+a*a/6#))
	jmp	end.select.000A.xma			;;; i69
case.000A.0001.xma:
	sub	esp,64			;;; i487
	mov	eax,d[ebp+8]			;;; i665
	mov	edx,d[ebp+12]
	mov	d[esp],eax			;;; i885
	mov	d[esp+4],edx			;;; i886
	call	%_abs.double			;;; i494
	add	esp,64			;;; i600
	push	1055193269			;;; i650
	push	-1998362383			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	jbe	>> case.000A.0002.xma			;;; i219
	fld	q[ebp+8]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1075314688			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fdiv				;;; i841
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	jmp	end.funcB.xma			;;; i258
;
; [660] CASE (a > 0#)		: theSign = +1#
	jmp	end.select.000A.xma			;;; i69
case.000A.0002.xma:
	fld	q[ebp+8]			;;; i664
	push	0			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jae	>> case.000A.0003.xma			;;; i219
;
#ifdef Asin.theSign
#undef Asin.theSign
#endif
#define Asin.theSign ebp-36	; exposes local variable 'theSign'
;
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fstp	q[ebp-36]			;;; i669
;
; [661] CASE ELSE				: theSign = -1# : a = -a
	jmp	end.select.000A.xma			;;; i69
case.000A.0003.xma:
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fchs				;;; i922
	fstp	q[ebp-36]			;;; i669
	fld	q[ebp+8]			;;; i664
	fchs				;;; i922
	fstp	q[ebp+8]			;;; i669
;
; [662] END SELECT
end.select.000A.xma:
;
; [663] '
;
; [664] IF (a <= $$INVSQRT2) THEN' a <= sin(45)
	fld	q[ebp+8]			;;; i664
	push	1072079006			;;; i650
	push	1719614413			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jb	>> else.000B.xma			;;; i219
;
; [665] aa = a * a
;
#ifdef Asin.aa
#undef Asin.aa
#endif
#define Asin.aa ebp-44	; exposes local variable 'aa'
;
	fld	q[ebp+8]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	fstp	q[ebp-44]			;;; i669
;
; [666] x = a * Asin0 (aa)
;
#ifdef Asin.x
#undef Asin.x
#endif
#define Asin.x ebp-52	; exposes local variable 'x'
;
	fld	q[ebp-44]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	func24.xma			;;; i619
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	fstp	q[ebp-52]			;;; i669
;
; [667] ELSE
	jmp	end.if.000B.xma			;;; i107
else.000B.xma:
;
; [668] aa = (.5# - (a * .5#))' aa = COS(ASIN(a/2))**2
	fld	q[ebp+8]			;;; i664
	push	1071644672			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fmul				;;; i841
	push	1071644672			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsubr				;;; i841
	fstp	q[ebp-44]			;;; i669
;
; [669] a = Sqrt (aa)
	fld	q[ebp-44]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	_Sqrt@8			;;; i619
	fstp	q[ebp+8]			;;; i669
;
; [670] x = $$PIDIV2 - (2# * a * Asin0 (aa))' x = 90 - 2 arcsin(a)
	push	1073741824			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
;
; .xstkB.0000 = ebp-60	; internal variable
	fld	q[ebp-44]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	func24.xma			;;; i619
	fmul				;;; i841
	push	1073291771			;;; i650
	push	1413754136			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsubr				;;; i841
	fstp	q[ebp-52]			;;; i669
;
; [671] END IF
end.if.000B.xma:
;
; [672] RETURN (x * theSign)
	fld	q[ebp-52]			;;; i643a
	fld	q[ebp-36]			;;; i643a
	fmul				;;; i841
	jmp	end.funcB.xma			;;; i258
;
; [673] END FUNCTION
	fldz				;;; i861
align 8
end.Asin.xma:  ;;; Function end label for Assembly Programmers.
end.funcB.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Asin ()  *****
;  *****
;
; [674] '
;
; [675] '
;
; [676] ' ######################
;
; [677] ' #####  Asinh ()  #####
;
; [678] ' ######################
;
; [679] '
;
; [680] FUNCTION DOUBLE Asinh (DOUBLE v) DOUBLE
.code
;
#ifdef Asinh.v
#undef Asinh.v
#endif
#define Asinh.v ebp+8	; exposes function argument 'v'
;
align 16
_Asinh@8:
;  *****
;  *****  FUNCTION  Asinh ()  *****
;  *****
funcC.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	push	0			;;; .
	push	0			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,228			;;; i114a
;
funcBodyC.xma:
;
; [681] '
;
; [682] SELECT CASE TRUE
;
; [683] CASE (v < -1d8)				: RETURN (-Log(-2#*v-0.5#/v))
	push	1287568416			;;; i654
	fld	d[esp]			;;; i655
	add	esp,4			;;; i656
	fchs				;;; i921
	fld	q[ebp+8]			;;; i643a
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	jae	>> case.000C.0001.xma			;;; i219
	push	1073741824			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fchs				;;; i922
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
;
; .xstkC.0000 = ebp-28	; internal variable
	push	1071644672			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp+8]			;;; i643a
	fdiv				;;; i841
	fsub				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	func13.xma			;;; i619
	fchs				;;; i922
	jmp	end.funcC.xma			;;; i258
;
; [684] CASE (ABS(v) < 1d-4)  : RETURN (v*(1#-v*v/6#))
	jmp	end.select.000C.xma			;;; i69
case.000C.0001.xma:
	sub	esp,64			;;; i487
	mov	eax,d[ebp+8]			;;; i665
	mov	edx,d[ebp+12]
	mov	d[esp],eax			;;; i885
	mov	d[esp+4],edx			;;; i886
	call	%_abs.double			;;; i494
	add	esp,64			;;; i600
	push	1058682594			;;; i650
	push	-350469331			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	jbe	>> case.000C.0002.xma			;;; i219
	fld	q[ebp+8]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1075314688			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fdiv				;;; i841
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsubr				;;; i841
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	jmp	end.funcC.xma			;;; i258
;
; [685] CASE (v > 1d8)        : RETURN (Log(2*v+0.5#/v))
	jmp	end.select.000C.xma			;;; i69
case.000C.0002.xma:
	fld	q[ebp+8]			;;; i664
	push	1287568416			;;; i654
	fld	d[esp]			;;; i655
	add	esp,4			;;; i656
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jae	>> case.000C.0003.xma			;;; i219
	push	1073741824			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1071644672			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp+8]			;;; i643a
	fdiv				;;; i841
	fadd				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	func13.xma			;;; i619
	jmp	end.funcC.xma			;;; i258
;
; [686] CASE ELSE             :	RETURN (Log(v + Sqrt(v*v + 1#)))
	jmp	end.select.000C.xma			;;; i69
case.000C.0003.xma:
	fld	q[ebp+8]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	_Sqrt@8			;;; i619
	fld	q[ebp+8]			;;; i643a
	fadd				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	func13.xma			;;; i619
	jmp	end.funcC.xma			;;; i258
;
; [687] END SELECT
end.select.000C.xma:
;
; [688] END FUNCTION
	fldz				;;; i861
align 8
end.Asinh.xma:  ;;; Function end label for Assembly Programmers.
end.funcC.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Asinh ()  *****
;  *****
;
; [689] '
;
; [690] ' ######################
;
; [691] ' #####  Atanh ()  #####
;
; [692] ' ######################
;
; [693] '
;
; [694] FUNCTION DOUBLE Atanh (DOUBLE v) DOUBLE
.code
;
#ifdef Atanh.v
#undef Atanh.v
#endif
#define Atanh.v ebp+8	; exposes function argument 'v'
;
align 16
_Atanh@8:
;  *****
;  *****  FUNCTION  Atanh ()  *****
;  *****
funcD.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	xor	eax,eax		;;; .
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,220			;;; i114a
;
funcBodyD.xma:
;
; [695] '
;
; [696] SELECT CASE TRUE
;
; [697] CASE (ABS(v) < 1d-5)		: RETURN (v*(1#+v*v/3#))
	sub	esp,64			;;; i487
	mov	eax,d[ebp+8]			;;; i665
	mov	edx,d[ebp+12]
	mov	d[esp],eax			;;; i885
	mov	d[esp+4],edx			;;; i886
	call	%_abs.double			;;; i494
	add	esp,64			;;; i600
	push	1055193269			;;; i650
	push	-1998362383			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	jbe	>> case.000D.0001.xma			;;; i219
	fld	q[ebp+8]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1074266112			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fdiv				;;; i841
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	jmp	end.funcD.xma			;;; i258
;
; [698] CASE (ABS(v) < 1#)      : RETURN (Log((1# + v) / (1# - v)) * 0.5#)
	jmp	end.select.000D.xma			;;; i69
case.000D.0001.xma:
	sub	esp,64			;;; i487
	mov	eax,d[ebp+8]			;;; i665
	mov	edx,d[ebp+12]
	mov	d[esp],eax			;;; i885
	mov	d[esp+4],edx			;;; i886
	call	%_abs.double			;;; i494
	add	esp,64			;;; i600
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	jbe	>> case.000D.0002.xma			;;; i219
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp+8]			;;; i643a
	fadd				;;; i841
;
; .xstkD.0000 = ebp-28	; internal variable
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp+8]			;;; i643a
	fsub				;;; i841
	fdiv				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	func13.xma			;;; i619
	push	1071644672			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fmul				;;; i841
	jmp	end.funcD.xma			;;; i258
;
; [699] CASE ELSE								: errLast = ERROR($$XmaErrorNatureInvalidArgument) : RETURN ($$PNAN)
	jmp	end.select.000D.xma			;;; i69
case.000D.0002.xma:
;
#ifdef Atanh.errLast
#undef Atanh.errLast
#endif
#define Atanh.errLast ebp-36	; exposes local variable 'errLast'
;
	sub	esp,64			;;; i487
	mov	eax,57			;;; i659
	call	%_error
	add	esp,64			;;; i600
	mov	d[ebp-8],eax			;;; i17
	fild	d[ebp-8]			;;; i18
	fstp	q[ebp-36]			;;; i669
	push	2147483647			;;; i650
	push	-1			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.funcD.xma			;;; i258
;
; [700] END SELECT
end.select.000D.xma:
;
; [701] END FUNCTION
	fldz				;;; i861
align 8
end.Atanh.xma:  ;;; Function end label for Assembly Programmers.
end.funcD.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Atanh ()  *****
;  *****
;
; [702] '
;
; [703] ' #####################
;
; [704] ' #####  Cosh ()  #####
;
; [705] ' #####################
;
; [706] '
;
; [707] FUNCTION DOUBLE Cosh (DOUBLE v) DOUBLE
.code
;
#ifdef Cosh.v
#undef Cosh.v
#endif
#define Cosh.v ebp+8	; exposes function argument 'v'
;
align 16
_Cosh@8:
;  *****
;  *****  FUNCTION  Cosh ()  *****
;  *****
funcE.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	push	0			;;; .
	push	0			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,228			;;; i114a
;
funcBodyE.xma:
;
; [708] '
;
; [709] SELECT CASE TRUE
;
; [710] CASE (v = 0#)			: RETURN (1#)
	fld	q[ebp+8]			;;; i664
	push	0			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jne	>> case.000E.0001.xma			;;; i219
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.funcE.xma			;;; i258
;
; [711] CASE (v >= 19#)		: RETURN (Exp(v) * 0.5#)
	jmp	end.select.000E.xma			;;; i69
case.000E.0001.xma:
	fld	q[ebp+8]			;;; i664
	push	1077084160			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	ja	>> case.000E.0002.xma			;;; i219
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	_Exp@8			;;; i619
	push	1071644672			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fmul				;;; i841
	jmp	end.funcE.xma			;;; i258
;
; [712] CASE (v <= -19#)	: RETURN (Exp(-v) * 0.5#)
	jmp	end.select.000E.xma			;;; i69
case.000E.0002.xma:
	push	1077084160			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fchs				;;; i922
	fld	q[ebp+8]			;;; i643a
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	ja	>> case.000E.0003.xma			;;; i219
	fld	q[ebp+8]			;;; i664
	fchs				;;; i922
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	_Exp@8			;;; i619
	push	1071644672			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fmul				;;; i841
	jmp	end.funcE.xma			;;; i258
;
; [713] CASE ELSE					: RETURN ((Exp(v) + Exp(-v)) * 0.5#)
	jmp	end.select.000E.xma			;;; i69
case.000E.0003.xma:
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	_Exp@8			;;; i619
;
; .xstkE.0000 = ebp-28	; internal variable
	fld	q[ebp+8]			;;; i664
	fchs				;;; i922
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	_Exp@8			;;; i619
	fadd				;;; i841
	push	1071644672			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fmul				;;; i841
	jmp	end.funcE.xma			;;; i258
;
; [714] END SELECT
end.select.000E.xma:
;
; [715] END FUNCTION
	fldz				;;; i861
align 8
end.Cosh.xma:  ;;; Function end label for Assembly Programmers.
end.funcE.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Cosh ()  *****
;  *****
;
; [716] '
;
; [717] '
;
; [718] ' ####################
;
; [719] ' #####  Cot ()  #####
;
; [720] ' ####################
;
; [721] '
;
; [722] FUNCTION DOUBLE Cot (DOUBLE a) DOUBLE
.code
;
#ifdef Cot.a
#undef Cot.a
#endif
#define Cot.a ebp+8	; exposes function argument 'a'
;
align 16
_Cot@8:
;  *****
;  *****  FUNCTION  Cot ()  *****
;  *****
funcF.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	xor	eax,eax		;;; .
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,220			;;; i114a
;
funcBodyF.xma:
;
; [723] '
;
; [724] ' FPU routine
;
; [725] '
;
; [726] k# = XxxFPTAN (a, @j#)
;
#ifdef Cot.k
#undef Cot.k
#endif
#define Cot.k ebp-28	; exposes local variable 'k#'
;
;
#ifdef Cot.j
#undef Cot.j
#endif
#define Cot.j ebp-36	; exposes local variable 'j#'
;
	fld	q[ebp-36]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	_XxxFPTAN@16			;;; i619
	fld	q[esp-8]			;;; i873
	fstp	q[ebp-36]			;;; i669
	fstp	q[ebp-28]			;;; i669
;
; [727] RETURN (j# / k#)
	fld	q[ebp-36]			;;; i643a
	fld	q[ebp-28]			;;; i643a
	fdiv				;;; i841
	jmp	end.funcF.xma			;;; i258
;
; [729] END FUNCTION
	fldz				;;; i861
align 8
end.Cot.xma:  ;;; Function end label for Assembly Programmers.
end.funcF.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Cot ()  *****
;  *****
;
; [730] '
;
; [731] '
;
; [732] ' #####################
;
; [733] ' #####  Coth ()  #####
;
; [734] ' #####################
;
; [735] '
;
; [736] FUNCTION DOUBLE Coth (DOUBLE v) DOUBLE
.code
;
#ifdef Coth.v
#undef Coth.v
#endif
#define Coth.v ebp+8	; exposes function argument 'v'
;
align 16
_Coth@8:
;  *****
;  *****  FUNCTION  Coth ()  *****
;  *****
func10.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	xor	eax,eax		;;; .
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,212			;;; i114a
;
funcBody10.xma:
;
; [737] '
;
; [738] SELECT CASE TRUE
;
; [739] CASE (v = 0#)					: errLast = ERROR($$XmaErrorNatureInvalidArgument) : RETURN ($$PNAN)
	fld	q[ebp+8]			;;; i664
	push	0			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jne	>> case.000F.0001.xma			;;; i219
;
#ifdef Coth.errLast
#undef Coth.errLast
#endif
#define Coth.errLast ebp-28	; exposes local variable 'errLast'
;
	sub	esp,64			;;; i487
	mov	eax,57			;;; i659
	call	%_error
	add	esp,64			;;; i600
	mov	d[ebp-8],eax			;;; i17
	fild	d[ebp-8]			;;; i18
	fstp	q[ebp-28]			;;; i669
	push	2147483647			;;; i650
	push	-1			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func10.xma			;;; i258
;
; [740] CASE (ABS(v) < 1d-4)	: RETURN (1#/v+v/3#)
	jmp	end.select.000F.xma			;;; i69
case.000F.0001.xma:
	sub	esp,64			;;; i487
	mov	eax,d[ebp+8]			;;; i665
	mov	edx,d[ebp+12]
	mov	d[esp],eax			;;; i885
	mov	d[esp+4],edx			;;; i886
	call	%_abs.double			;;; i494
	add	esp,64			;;; i600
	push	1058682594			;;; i650
	push	-350469331			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	jbe	>> case.000F.0002.xma			;;; i219
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp+8]			;;; i643a
	fdiv				;;; i841
	fld	q[ebp+8]			;;; i664
	push	1074266112			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fdiv				;;; i841
	fadd				;;; i841
	jmp	end.func10.xma			;;; i258
;
; [741] CASE (v >= 19#)				: RETURN (1#)
	jmp	end.select.000F.xma			;;; i69
case.000F.0002.xma:
	fld	q[ebp+8]			;;; i664
	push	1077084160			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	ja	>> case.000F.0003.xma			;;; i219
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func10.xma			;;; i258
;
; [742] CASE (v <= -19#)			: RETURN (-1#)
	jmp	end.select.000F.xma			;;; i69
case.000F.0003.xma:
	push	1077084160			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fchs				;;; i922
	fld	q[ebp+8]			;;; i643a
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	ja	>> case.000F.0004.xma			;;; i219
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fchs				;;; i922
	jmp	end.func10.xma			;;; i258
;
; [743] CASE ELSE							: RETURN ((Exp(v)+Exp(-v))/(Exp(v)-Exp(-v)))
	jmp	end.select.000F.xma			;;; i69
case.000F.0004.xma:
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	_Exp@8			;;; i619
;
; .xstk10.0000 = ebp-36	; internal variable
	fld	q[ebp+8]			;;; i664
	fchs				;;; i922
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	_Exp@8			;;; i619
	fadd				;;; i841
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	_Exp@8			;;; i619
;
; .xstk10.0001 = ebp-44	; internal variable
	fld	q[ebp+8]			;;; i664
	fchs				;;; i922
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	_Exp@8			;;; i619
	fsub				;;; i841
	fdiv				;;; i841
	jmp	end.func10.xma			;;; i258
;
; [744] END SELECT
end.select.000F.xma:
;
; [745] END FUNCTION
	fldz				;;; i861
align 8
end.Coth.xma:  ;;; Function end label for Assembly Programmers.
end.func10.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Coth ()  *****
;  *****
;
; [746] '
;
; [747] '
;
; [748] ' ####################
;
; [749] ' #####  Csc ()  #####  1 / SIN()
;
; [750] ' ####################
;
; [751] '
;
; [752] FUNCTION DOUBLE Csc (DOUBLE a)
.code
;
#ifdef Csc.a
#undef Csc.a
#endif
#define Csc.a ebp+8	; exposes function argument 'a'
;
align 16
_Csc@8:
;  *****
;  *****  FUNCTION  Csc ()  *****
;  *****
func11.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	push	0			;;; .
	push	0			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,228			;;; i114a
;
funcBody11.xma:
;
; [753] '
;
; [754] x# = Sin(a)
;
#ifdef Csc.x
#undef Csc.x
#endif
#define Csc.x ebp-28	; exposes local variable 'x#'
;
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	_Sin@8			;;; i619
	fstp	q[ebp-28]			;;; i669
;
; [755] IFZ x# THEN
	fld	q[ebp-28]			;;; i664
	fldz	
	fcompp				;;; i173
	fstsw	ax			;;; i174
	sahf				;;; i175
	jnz	>> else.0010.xma			;;; i176
;
; [756] RETURN ($$PINF)
	push	2146435072			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func11.xma			;;; i258
;
; [757] ELSE
	jmp	end.if.0010.xma			;;; i107
else.0010.xma:
;
; [758] RETURN (1# / x#)
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp-28]			;;; i643a
	fdiv				;;; i841
	jmp	end.func11.xma			;;; i258
;
; [759] END IF
end.if.0010.xma:
;
; [760] END FUNCTION
	fldz				;;; i861
align 8
end.Csc.xma:  ;;; Function end label for Assembly Programmers.
end.func11.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Csc ()  *****
;  *****
;
; [761] '
;
; [762] '
;
; [763] ' #####################
;
; [764] ' #####  Csch ()  #####
;
; [765] ' #####################
;
; [766] '
;
; [767] FUNCTION DOUBLE Csch (DOUBLE v) DOUBLE
.code
;
#ifdef Csch.v
#undef Csch.v
#endif
#define Csch.v ebp+8	; exposes function argument 'v'
;
align 16
_Csch@8:
;  *****
;  *****  FUNCTION  Csch ()  *****
;  *****
func12.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	push	0			;;; .
	push	0			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,228			;;; i114a
;
funcBody12.xma:
;
; [768] '
;
; [769] IFZ v THEN  : errLast = ERROR($$XmaErrorNatureInvalidArgument) : RETURN ($$PNAN)
	fld	q[ebp+8]			;;; i664
	fldz	
	fcompp				;;; i173
	fstsw	ax			;;; i174
	sahf				;;; i175
	jnz	>> else.0011.xma			;;; i176
;
#ifdef Csch.errLast
#undef Csch.errLast
#endif
#define Csch.errLast ebp-28	; exposes local variable 'errLast'
;
	sub	esp,64			;;; i487
	mov	eax,57			;;; i659
	call	%_error
	add	esp,64			;;; i600
	mov	d[ebp-8],eax			;;; i17
	fild	d[ebp-8]			;;; i18
	fstp	q[ebp-28]			;;; i669
	push	2147483647			;;; i650
	push	-1			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func12.xma			;;; i258
else.0011.xma:
end.if.0011.xma:
;
; [770] RETURN (1# / Sinh(v))
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	func17.xma			;;; i619
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fdivr				;;; i841
	jmp	end.func12.xma			;;; i258
;
; [771] END FUNCTION
	fldz				;;; i861
align 8
end.Csch.xma:  ;;; Function end label for Assembly Programmers.
end.func12.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Csch ()  *****
;  *****
;
; [772] '
;
; [773] ' ####################
;
; [774] ' #####  Log ()  #####
;
; [775] ' ####################
;
; [776] '
;
; [777] FUNCTION DOUBLE Log (DOUBLE v) DOUBLE
.code
;
#ifdef Log.v
#undef Log.v
#endif
#define Log.v ebp+8	; exposes function argument 'v'
;
align 16
_Log@8:
;  *****
;  *****  FUNCTION  Log ()  *****
;  *****
func13.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	mov	ecx,2				;;; ..
	xor	eax,eax			;;; ...
A.56:
	push	eax, eax, eax, eax
	push	eax, eax, eax, eax
	dec	ecx					;;; ....
	jnz	< A.56			;;; .....
	push	eax				;;; ......
	push	eax				;;; ......
	push	eax				;;; ......
	push	eax				;;; ......
	push	eax				;;; ......
	push	eax				;;; ......
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,148			;;; i114a
;
funcBody13.xma:
;
; [778] SLONG  upper,  lower,  exp,  exp0,  exp1,  exp2
;
#ifdef Log.upper
#undef Log.upper
#endif
#define Log.upper ebp-24	; exposes local variable 'upper'
;
;
#ifdef Log.lower
#undef Log.lower
#endif
#define Log.lower ebp-28	; exposes local variable 'lower'
;
;
#ifdef Log.exp
#undef Log.exp
#endif
#define Log.exp ebp-32	; exposes local variable 'exp'
;
;
#ifdef Log.exp0
#undef Log.exp0
#endif
#define Log.exp0 ebp-36	; exposes local variable 'exp0'
;
;
#ifdef Log.exp1
#undef Log.exp1
#endif
#define Log.exp1 ebp-40	; exposes local variable 'exp1'
;
;
#ifdef Log.exp2
#undef Log.exp2
#endif
#define Log.exp2 ebp-44	; exposes local variable 'exp2'
;
;
; [779] '
;
; [780] K1 = DMAKE (0xBF2BD010, 0x5C610CA9)
;
#ifdef Log.K1
#undef Log.K1
#endif
#define Log.K1 ebp-52	; exposes local variable 'K1'
;
	sub	esp,64			;;; i487
	mov	eax,-1087647728			;;; i657
	mov	ebx,1549864105			;;; i657
	mov	d[ebp-8],ebx			;;; i505
	mov	d[ebp-4],eax			;;; i506
	fld	q[ebp-8]			;;; i507
	add	esp,64			;;; i600
	fstp	q[ebp-52]			;;; i669
;
; [781] K2 = SMAKE (0x3F318000)
;
#ifdef Log.K2
#undef Log.K2
#endif
#define Log.K2 ebp-60	; exposes local variable 'K2'
;
	sub	esp,64			;;; i487
	mov	eax,1060208640			;;; i657
	mov	d[ebp-8],eax
	fld	d[ebp-8]
	add	esp,64			;;; i600
	fstp	q[ebp-60]			;;; i669
;
; [782] '
;
; [783] SELECT CASE TRUE
;
; [784] CASE (v < 0#)	: errLast = ERROR($$XmaErrorNatureInvalidArgument) : RETURN ($$PNAN)
	fld	q[ebp+8]			;;; i664
	push	0			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jbe	>> case.0012.0001.xma			;;; i219
;
#ifdef Log.errLast
#undef Log.errLast
#endif
#define Log.errLast ebp-68	; exposes local variable 'errLast'
;
	sub	esp,64			;;; i487
	mov	eax,57			;;; i659
	call	%_error
	add	esp,64			;;; i600
	mov	d[ebp-8],eax			;;; i17
	fild	d[ebp-8]			;;; i18
	fstp	q[ebp-68]			;;; i669
	push	2147483647			;;; i650
	push	-1			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func13.xma			;;; i258
;
; [785] CASE (v = 0#)	: RETURN ($$NINF)
	jmp	end.select.0012.xma			;;; i69
case.0012.0001.xma:
	fld	q[ebp+8]			;;; i664
	push	0			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jne	>> case.0012.0002.xma			;;; i219
	push	-1048576			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func13.xma			;;; i258
;
; [786] CASE (v = 1#)	: RETURN (0#)
	jmp	end.select.0012.xma			;;; i69
case.0012.0002.xma:
	fld	q[ebp+8]			;;; i664
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jne	>> case.0012.0003.xma			;;; i219
	push	0			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func13.xma			;;; i258
;
; [787] END SELECT
case.0012.0003.xma:
end.select.0012.xma:
;
; [788] '
;
; [789] upper	= DHIGH (v)
	sub	esp,64			;;; i487
	mov	eax,d[ebp+8]			;;; i665
	mov	edx,d[ebp+12]
	mov	eax,edx
	add	esp,64			;;; i600
	mov	d[ebp-24],eax			;;; i670
;
; [790] lower	= DLOW (v)
	sub	esp,64			;;; i487
	mov	eax,d[ebp+8]			;;; i665
	mov	edx,d[ebp+12]
	add	esp,64			;;; i600
	mov	d[ebp-28],eax			;;; i670
;
; [791] exp		= upper {11, 20}
	mov	eax,11			;;; i659
	mov	ebx,20			;;; i659
	mov	esi,d[ebp-24]			;;; i665
	mov	ecx,ebx			;;; i479
	shr	esi,cl			;;; i480
	mov	edi,-1			;;; i481
	mov	ecx,eax			;;; i482
	shl	edi,cl			;;; i483
	not	edi			;;; i484
	and	esi,edi			;;; i485
	mov	eax,esi			;;; i486
	mov	d[ebp-32],eax			;;; i670
;
; [792] exp0	= upper AND 0x800FFFFF
	mov	eax,d[ebp-24]			;;; i665
	and	eax,-2146435073			;;; i769
	mov	d[ebp-36],eax			;;; i670
;
; [793] exp1	= exp0 OR 0x3FE00000
	mov	eax,d[ebp-36]			;;; i665
	or	eax,1071644672			;;; i763
	mov	d[ebp-40],eax			;;; i670
;
; [794] exp2	= exp - 1022
	mov	eax,d[ebp-32]			;;; i665
	sub	eax,1022			;;; i784
	into				;;; i785
	mov	d[ebp-44],eax			;;; i670
;
; [795] frac	= DMAKE (exp1, lower)' frac is between 1/2 and 1
;
#ifdef Log.frac
#undef Log.frac
#endif
#define Log.frac ebp-76	; exposes local variable 'frac'
;
	sub	esp,64			;;; i487
	mov	eax,d[ebp-40]			;;; i665
	mov	ebx,d[ebp-28]			;;; i665
	mov	d[ebp-8],ebx			;;; i505
	mov	d[ebp-4],eax			;;; i506
	fld	q[ebp-8]			;;; i507
	add	esp,64			;;; i600
	fstp	q[ebp-76]			;;; i669
;
; [796] IF (frac >= $$INVSQRT2) THEN' frac must be between 1/sqrt2 and sqrt2
	fld	q[ebp-76]			;;; i664
	push	1072079006			;;; i650
	push	1719614413			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	ja	>> else.0013.xma			;;; i219
;
; [797] z = (frac - 1#) / (frac + 1#)' it is!
;
#ifdef Log.z
#undef Log.z
#endif
#define Log.z ebp-84	; exposes local variable 'z'
;
	fld	q[ebp-76]			;;; i664
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsub				;;; i841
	fld	q[ebp-76]			;;; i664
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fdiv				;;; i841
	fstp	q[ebp-84]			;;; i669
;
; [798] ELSE
	jmp	end.if.0013.xma			;;; i107
else.0013.xma:
;
; [799] DEC exp2' nope: dec the exponent, transfer to frac
	dec	d[ebp-44]			;;; i74
	into				;;; i75
;
; [800] z = (frac - .5#) / (frac + .5#)' mult frac by 2 (clever...)
	fld	q[ebp-76]			;;; i664
	push	1071644672			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsub				;;; i841
	fld	q[ebp-76]			;;; i664
	push	1071644672			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fdiv				;;; i841
	fstp	q[ebp-84]			;;; i669
;
; [801] END IF
end.if.0013.xma:
;
; [802] zp = z * Log0 (z)
;
#ifdef Log.zp
#undef Log.zp
#endif
#define Log.zp ebp-92	; exposes local variable 'zp'
;
	fld	q[ebp-84]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	func26.xma			;;; i619
	fld	q[ebp-84]			;;; i643a
	fmul				;;; i841
	fstp	q[ebp-92]			;;; i669
;
; [803] j = ((exp2 * K1) + zp) + (exp2 * K2)
;
#ifdef Log.j
#undef Log.j
#endif
#define Log.j ebp-100	; exposes local variable 'j'
;
	fild	d[ebp-44]			;;; i643a
	fld	q[ebp-52]			;;; i643a
	fmul				;;; i841
	fld	q[ebp-92]			;;; i643a
	fadd				;;; i841
;
; .xstk13.0000 = ebp-108	; internal variable
	fild	d[ebp-44]			;;; i643a
	fld	q[ebp-60]			;;; i643a
	fmul				;;; i841
	fadd				;;; i841
	fstp	q[ebp-100]			;;; i669
;
; [804] '	j = exp2 * $$LOGE2 + zp
;
; [805] RETURN (j)
	fld	q[ebp-100]			;;; i664
	jmp	end.func13.xma			;;; i258
;
; [806] END FUNCTION
	fldz				;;; i861
align 8
end.Log.xma:  ;;; Function end label for Assembly Programmers.
end.func13.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Log ()  *****
;  *****
;
; [807] '
;
; [808] '
;
; [809] ' ######################
;
; [810] ' #####  Log10 ()  #####
;
; [811] ' ######################
;
; [812] '
;
; [813] FUNCTION DOUBLE Log10 (DOUBLE v) DOUBLE
.code
;
#ifdef Log10.v
#undef Log10.v
#endif
#define Log10.v ebp+8	; exposes function argument 'v'
;
align 16
_Log10@8:
;  *****
;  *****  FUNCTION  Log10 ()  *****
;  *****
func14.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
	sub	esp,236			;;; i114a
;
funcBody14.xma:
;
; [814] RETURN (Log (v) * $$LOG10E)
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	func13.xma			;;; i619
	push	1071369083			;;; i650
	push	354870542			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fmul				;;; i841
	jmp	end.func14.xma			;;; i258
;
; [815] END FUNCTION
	fldz				;;; i861
align 8
end.Log10.xma:  ;;; Function end label for Assembly Programmers.
end.func14.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Log10 ()  *****
;  *****
;
; [816] '
;
; [817] ' ####################
;
; [818] ' #####  Sec ()  #####  1 / COS()
;
; [819] ' ####################
;
; [820] '
;
; [821] FUNCTION DOUBLE Sec (DOUBLE a) DOUBLE
.code
;
#ifdef Sec.a
#undef Sec.a
#endif
#define Sec.a ebp+8	; exposes function argument 'a'
;
align 16
_Sec@8:
;  *****
;  *****  FUNCTION  Sec ()  *****
;  *****
func15.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	push	0			;;; .
	push	0			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,228			;;; i114a
;
funcBody15.xma:
;
; [822] '
;
; [823] x = Cos(a)
;
#ifdef Sec.x
#undef Sec.x
#endif
#define Sec.x ebp-28	; exposes local variable 'x'
;
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	_Cos@8			;;; i619
	fstp	q[ebp-28]			;;; i669
;
; [824] IFZ x THEN
	fld	q[ebp-28]			;;; i664
	fldz	
	fcompp				;;; i173
	fstsw	ax			;;; i174
	sahf				;;; i175
	jnz	>> else.0014.xma			;;; i176
;
; [825] RETURN ($$PINF)
	push	2146435072			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func15.xma			;;; i258
;
; [826] ELSE
	jmp	end.if.0014.xma			;;; i107
else.0014.xma:
;
; [827] RETURN (1# / x)
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp-28]			;;; i643a
	fdiv				;;; i841
	jmp	end.func15.xma			;;; i258
;
; [828] END IF
end.if.0014.xma:
;
; [829] END FUNCTION
	fldz				;;; i861
align 8
end.Sec.xma:  ;;; Function end label for Assembly Programmers.
end.func15.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Sec ()  *****
;  *****
;
; [830] '
;
; [831] '
;
; [832] ' #####################
;
; [833] ' #####  Sech ()  #####
;
; [834] ' #####################
;
; [835] '
;
; [836] FUNCTION DOUBLE Sech (DOUBLE v) DOUBLE
.code
;
#ifdef Sech.v
#undef Sech.v
#endif
#define Sech.v ebp+8	; exposes function argument 'v'
;
align 16
_Sech@8:
;  *****
;  *****  FUNCTION  Sech ()  *****
;  *****
func16.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
	sub	esp,236			;;; i114a
;
funcBody16.xma:
;
; [837] RETURN (1# / Cosh(v))
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	funcE.xma			;;; i619
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fdivr				;;; i841
	jmp	end.func16.xma			;;; i258
;
; [838] END FUNCTION
	fldz				;;; i861
align 8
end.Sech.xma:  ;;; Function end label for Assembly Programmers.
end.func16.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Sech ()  *****
;  *****
;
; [839] '
;
; [840] ' #####################
;
; [841] ' #####  Sinh ()  #####  >>>  may need add'l stuff for exp(v) ~= exp(-v)
;
; [842] ' #####################
;
; [843] '
;
; [844] FUNCTION DOUBLE Sinh (DOUBLE v) DOUBLE
.code
;
#ifdef Sinh.v
#undef Sinh.v
#endif
#define Sinh.v ebp+8	; exposes function argument 'v'
;
align 16
_Sinh@8:
;  *****
;  *****  FUNCTION  Sinh ()  *****
;  *****
func17.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	xor	eax,eax		;;; .
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,220			;;; i114a
;
funcBody17.xma:
;
; [845] SELECT CASE TRUE
;
; [846] CASE (v = 0#)			: RETURN (0#)
	fld	q[ebp+8]			;;; i664
	push	0			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jne	>> case.0015.0001.xma			;;; i219
	push	0			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func17.xma			;;; i258
;
; [847] CASE (v >= 19#)   : RETURN (Exp(v) * 0.5#)
	jmp	end.select.0015.xma			;;; i69
case.0015.0001.xma:
	fld	q[ebp+8]			;;; i664
	push	1077084160			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	ja	>> case.0015.0002.xma			;;; i219
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	_Exp@8			;;; i619
	push	1071644672			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fmul				;;; i841
	jmp	end.func17.xma			;;; i258
;
; [848] CASE (v <= -19#)	: RETURN (Exp(-v) * -0.5#)
	jmp	end.select.0015.xma			;;; i69
case.0015.0002.xma:
	push	1077084160			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fchs				;;; i922
	fld	q[ebp+8]			;;; i643a
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	ja	>> case.0015.0003.xma			;;; i219
	fld	q[ebp+8]			;;; i664
	fchs				;;; i922
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	_Exp@8			;;; i619
	push	1071644672			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fchs				;;; i922
	fmul				;;; i841
	jmp	end.func17.xma			;;; i258
;
; [849] CASE (v > .3#)		: RETURN ((Exp(v) - Exp(-v)) * 0.5#)
	jmp	end.select.0015.xma			;;; i69
case.0015.0003.xma:
	fld	q[ebp+8]			;;; i664
	push	1070805811			;;; i650
	push	858993460			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jae	>> case.0015.0004.xma			;;; i219
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	_Exp@8			;;; i619
;
; .xstk17.0000 = ebp-28	; internal variable
	fld	q[ebp+8]			;;; i664
	fchs				;;; i922
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	_Exp@8			;;; i619
	fsub				;;; i841
	push	1071644672			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fmul				;;; i841
	jmp	end.func17.xma			;;; i258
;
; [850] CASE (v < -.3#)		: RETURN ((Exp(v) - Exp(-v)) * 0.5#)
	jmp	end.select.0015.xma			;;; i69
case.0015.0004.xma:
	push	1070805811			;;; i650
	push	858993460			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fchs				;;; i922
	fld	q[ebp+8]			;;; i643a
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	jae	>> case.0015.0005.xma			;;; i219
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	_Exp@8			;;; i619
	fld	q[ebp+8]			;;; i664
	fchs				;;; i922
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	_Exp@8			;;; i619
	fsub				;;; i841
	push	1071644672			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fmul				;;; i841
	jmp	end.func17.xma			;;; i258
;
; [851] CASE ELSE					: dx = Expmo(v)
	jmp	end.select.0015.xma			;;; i69
case.0015.0005.xma:
;
#ifdef Sinh.dx
#undef Sinh.dx
#endif
#define Sinh.dx ebp-36	; exposes local variable 'dx'
;
	fld	q[ebp+8]			;;; i674
	sub	esp,8			;;; i675a
	fstp	q[esp]			;;; i675b
	call	func25.xma			;;; i619
	fstp	q[ebp-36]			;;; i669
;
; [852] RETURN (0.5# * dx*(1# + 1# / (dx + 1)))
	push	1071644672			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp-36]			;;; i643a
	fmul				;;; i841
	fld	q[ebp-36]			;;; i664
	mov	ebx,1			;;; i659
	mov	d[ebp-8],ebx			;;; i397
	fild	d[ebp-8]			;;; i398
	fadd				;;; i841
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fdivr				;;; i841
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fmul				;;; i841
	jmp	end.func17.xma			;;; i258
;
; [853] END SELECT
end.select.0015.xma:
;
; [854] END FUNCTION
	fldz				;;; i861
align 8
end.Sinh.xma:  ;;; Function end label for Assembly Programmers.
end.func17.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Sinh ()  *****
;  *****
;
; [855] '
;
; [856] ' #####################
;
; [857] ' #####  Tanh ()  #####	 >>>  may have problems similar to XmaSinh ???  <<<
;
; [858] ' #####################
;
; [859] '
;
; [860] FUNCTION DOUBLE Tanh (DOUBLE v) DOUBLE
.code
;
#ifdef Tanh.v
#undef Tanh.v
#endif
#define Tanh.v ebp+8	; exposes function argument 'v'
;
align 16
_Tanh@8:
;  *****
;  *****  FUNCTION  Tanh ()  *****
;  *****
func18.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	xor	eax,eax		;;; .
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,220			;;; i114a
;
funcBody18.xma:
;
; [861] SELECT CASE TRUE
;
; [862] CASE (v = 0#)				:										RETURN (0#)
	fld	q[ebp+8]			;;; i664
	push	0			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	jne	>> case.0016.0001.xma			;;; i219
	push	0			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func18.xma			;;; i258
;
; [863] CASE (v >= 19#)			:										RETURN (1#)
	jmp	end.select.0016.xma			;;; i69
case.0016.0001.xma:
	fld	q[ebp+8]			;;; i664
	push	1077084160			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	ja	>> case.0016.0002.xma			;;; i219
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	jmp	end.func18.xma			;;; i258
;
; [864] CASE (v <= -19#)		:										RETURN (-1#)
	jmp	end.select.0016.xma			;;; i69
case.0016.0002.xma:
	push	1077084160			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fchs				;;; i922
	fld	q[ebp+8]			;;; i643a
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	ja	>> case.0016.0003.xma			;;; i219
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fchs				;;; i922
	jmp	end.func18.xma			;;; i258
;
; [865] CASE (ABS(v) > .1#)	: ev = Exp(v+v)		: RETURN ((ev - 1#) / (ev + 1#))
	jmp	end.select.0016.xma			;;; i69
case.0016.0003.xma:
	sub	esp,64			;;; i487
	mov	eax,d[ebp+8]			;;; i665
	mov	edx,d[ebp+12]
	mov	d[esp],eax			;;; i885
	mov	d[esp+4],edx			;;; i886
	call	%_abs.double			;;; i494
	add	esp,64			;;; i600
	push	1069128089			;;; i650
	push	-1717986918			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fcompp				;;; i686b
	push	eax			;;; i686c
	fstsw	ax			;;; i686d
	sahf				;;; i686e
	pop	eax			;;; i686f
	jae	>> case.0016.0004.xma			;;; i219
;
#ifdef Tanh.ev
#undef Tanh.ev
#endif
#define Tanh.ev ebp-28	; exposes local variable 'ev'
;
	fld	q[ebp+8]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fadd				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	_Exp@8			;;; i619
	fstp	q[ebp-28]			;;; i669
	fld	q[ebp-28]			;;; i664
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsub				;;; i841
	fld	q[ebp-28]			;;; i664
	push	1072693248			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fdiv				;;; i841
	jmp	end.func18.xma			;;; i258
;
; [866] CASE ELSE						: xv = Expmo(v+v)	: RETURN (xv / (2# + xv))
	jmp	end.select.0016.xma			;;; i69
case.0016.0004.xma:
;
#ifdef Tanh.xv
#undef Tanh.xv
#endif
#define Tanh.xv ebp-36	; exposes local variable 'xv'
;
	fld	q[ebp+8]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fadd				;;; i841
	sub	esp,8			;;; i666a
	fstp	q[esp]			;;; i666b
	call	func25.xma			;;; i619
	fstp	q[ebp-36]			;;; i669
	push	1073741824			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp-36]			;;; i643a
	fadd				;;; i841
	fld	q[ebp-36]			;;; i643a
	fdivr				;;; i841
	jmp	end.func18.xma			;;; i258
;
; [867] END SELECT
end.select.0016.xma:
;
; [868] END FUNCTION
	fldz				;;; i861
align 8
end.Tanh.xma:  ;;; Function end label for Assembly Programmers.
end.func18.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Tanh ()  *****
;  *****
;
; [869] '
;
; [870] '
;
; [871] ' ######################
;
; [872] ' #####  Asin0 ()  #####  Hart #4731  :  INTERNAL FUNCTION  :  returns RADIANS
;
; [873] ' ######################
;
; [874] '
;
; [875] FUNCTION DOUBLE Asin0 (DOUBLE aa) DOUBLE
.code
;
#ifdef Asin0.aa
#undef Asin0.aa
#endif
#define Asin0.aa ebp+8	; exposes function argument 'aa'
;
align 16
Asin0@8.xma:
;  *****
;  *****  FUNCTION  Asin0 ()  *****
;  *****
func24.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	xor	eax,eax		;;; .
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,220			;;; i114a
;
funcBody24.xma:
;
; [876] '
;
; [877] x = aa * .28887940520319958009# - .1532823762188072258146d2#
;
#ifdef Asin0.x
#undef Asin0.x
#endif
#define Asin0.x ebp-28	; exposes local variable 'x'
;
	fld	q[ebp+8]			;;; i664
	push	1070759168			;;; i650
	push	192248753			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fmul				;;; i841
	push	1076799502			;;; i650
	push	-1024026933			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsub				;;; i841
	fstp	q[ebp-28]			;;; i669
;
; [878] x = x * aa + .15627431676469845164879d3#
	fld	q[ebp-28]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1080264903			;;; i650
	push	871605243			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fstp	q[ebp-28]			;;; i669
;
; [879] x = x * aa - .61608581811333824880753d3#
	fld	q[ebp-28]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1082343599			;;; i650
	push	-1050136182			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsub				;;; i841
	fstp	q[ebp-28]			;;; i669
;
; [880] x = x * aa + .1131354445141400374754542d4#
	fld	q[ebp-28]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1083288938			;;; i650
	push	-206910934			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fstp	q[ebp-28]			;;; i669
;
; [881] x = x * aa - .975678343527571443444814d3#
	fld	q[ebp-28]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1083080045			;;; i650
	push	1063195388			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsub				;;; i841
	fstp	q[ebp-28]			;;; i669
;
; [882] x = x * aa + .31952141659008684896086d3#
	fld	q[ebp-28]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1081342039			;;; i650
	push	-1192484803			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fstp	q[ebp-28]			;;; i669
;
; [883] y = aa - .282183566472129245114d2#
;
#ifdef Asin0.y
#undef Asin0.y
#endif
#define Asin0.y ebp-36	; exposes local variable 'y'
;
	fld	q[ebp+8]			;;; i664
	push	1077688294			;;; i650
	push	950183115			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsub				;;; i841
	fstp	q[ebp-36]			;;; i669
;
; [884] y = y * aa + .22430629957413222990564d3#
	fld	q[ebp-36]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1080822221			;;; i650
	push	885241256			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fstp	q[ebp-36]			;;; i669
;
; [885] y = y * aa - .76632677210477257595839d3#
	fld	q[ebp-36]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1082651293			;;; i650
	push	984709619			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsub				;;; i841
	fstp	q[ebp-36]			;;; i669
;
; [886] y = y * aa + .1278878991056988003191528d4#
	fld	q[ebp-36]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1083440004			;;; i650
	push	372985078			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fstp	q[ebp-36]			;;; i669
;
; [887] y = y * aa - .1028931912959252211748113d4#
	fld	q[ebp-36]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1083184058			;;; i650
	push	1197738708			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsub				;;; i841
	fstp	q[ebp-36]			;;; i669
;
; [888] y = y * aa + .319521416590086848208615d3#
	fld	q[ebp-36]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	push	1081342039			;;; i650
	push	-1192484803			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fstp	q[ebp-36]			;;; i669
;
; [889] RETURN (x / y)
	fld	q[ebp-28]			;;; i643a
	fld	q[ebp-36]			;;; i643a
	fdiv				;;; i841
	jmp	end.func24.xma			;;; i258
;
; [890] END FUNCTION
	fldz				;;; i861
align 8
end.Asin0.xma:  ;;; Function end label for Assembly Programmers.
end.func24.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Asin0 ()  *****
;  *****
;
; [891] '
;
; [892] ' ######################
;
; [893] ' #####  Expmo ()  #####  Hart #1802
;
; [894] ' ######################
;
; [895] '
;
; [896] ' EXP(v) - 1, for small v (presumably)
;
; [897] '
;
; [898] FUNCTION DOUBLE Expmo (DOUBLE v) DOUBLE
.code
;
#ifdef Expmo.v
#undef Expmo.v
#endif
#define Expmo.v ebp+8	; exposes function argument 'v'
;
align 16
Expmo@8.xma:
;  *****
;  *****  FUNCTION  Expmo ()  *****
;  *****
func25.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	mov	ecx,2				;;; ..
	xor	eax,eax			;;; ...
A.75:
	push	eax, eax, eax, eax
	dec	ecx					;;; ....
	jnz	< A.75			;;; .....
	push	eax				;;; ......
	push	eax				;;; ......
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,196			;;; i114a
;
funcBody25.xma:
;
; [899] vv = v * v
;
#ifdef Expmo.vv
#undef Expmo.vv
#endif
#define Expmo.vv ebp-28	; exposes local variable 'vv'
;
	fld	q[ebp+8]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	fstp	q[ebp-28]			;;; i669
;
; [900] x = vv * .3333206802628149222225154d-1 + .1400022777377555304975874306d2
;
#ifdef Expmo.x
#undef Expmo.x
#endif
#define Expmo.x ebp-36	; exposes local variable 'x'
;
	fld	q[ebp-28]			;;; i664
	push	1067520230			;;; i650
	push	-1675006164			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fmul				;;; i841
	push	1076625437			;;; i650
	push	-623782541			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fstp	q[ebp-36]			;;; i669
;
; [901] x = x * vv + .5040127554054843027460596926d3
	fld	q[ebp-36]			;;; i643a
	fld	q[ebp-28]			;;; i643a
	fmul				;;; i841
	push	1082097716			;;; i650
	push	1057166960			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fstp	q[ebp-36]			;;; i669
;
; [902] y = vv + .1120025814484651564577585494d3
;
#ifdef Expmo.y
#undef Expmo.y
#endif
#define Expmo.y ebp-44	; exposes local variable 'y'
;
	fld	q[ebp-28]			;;; i664
	push	1079771178			;;; i650
	push	1264660221			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fstp	q[ebp-44]			;;; i669
;
; [903] y = y * vv + .1008025510810968605492139581d4
	fld	q[ebp-44]			;;; i643a
	fld	q[ebp-28]			;;; i643a
	fmul				;;; i841
	push	1083146292			;;; i650
	push	1057166960			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fstp	q[ebp-44]			;;; i669
;
; [904] z = (2# * v * x) / (y - (v * x))
;
#ifdef Expmo.z
#undef Expmo.z
#endif
#define Expmo.z ebp-52	; exposes local variable 'z'
;
	push	1073741824			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	fld	q[ebp-36]			;;; i643a
	fmul				;;; i841
;
; .xstk25.0000 = ebp-60	; internal variable
	fld	q[ebp+8]			;;; i643a
	fld	q[ebp-36]			;;; i643a
	fmul				;;; i841
	fld	q[ebp-44]			;;; i643a
	fsubr				;;; i841
	fdiv				;;; i841
	fstp	q[ebp-52]			;;; i669
;
; [905] RETURN (z)
	fld	q[ebp-52]			;;; i664
	jmp	end.func25.xma			;;; i258
;
; [906] END FUNCTION
	fldz				;;; i861
align 8
end.Expmo.xma:  ;;; Function end label for Assembly Programmers.
end.func25.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Expmo ()  *****
;  *****
;
; [907] '
;
; [908] '
;
; [909] ' #####################
;
; [910] ' #####  Log0 ()  #####  Hart #2705
;
; [911] ' #####################
;
; [912] '
;
; [913] FUNCTION DOUBLE Log0 (DOUBLE v) DOUBLE
.code
;
#ifdef Log0.v
#undef Log0.v
#endif
#define Log0.v ebp+8	; exposes function argument 'v'
;
align 16
Log0@8.xma:
;  *****
;  *****  FUNCTION  Log0 ()  *****
;  *****
func26.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	xor	eax,eax		;;; .
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
	push	eax			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,204			;;; i114a
;
funcBody26.xma:
;
; [914] vv = v * v
;
#ifdef Log0.vv
#undef Log0.vv
#endif
#define Log0.vv ebp-28	; exposes local variable 'vv'
;
	fld	q[ebp+8]			;;; i643a
	fld	q[ebp+8]			;;; i643a
	fmul				;;; i841
	fstp	q[ebp-28]			;;; i669
;
; [915] x = vv * .4210873712179797145# - .96376909336868659324d1
;
#ifdef Log0.x
#undef Log0.x
#endif
#define Log0.x ebp-36	; exposes local variable 'x'
;
	fld	q[ebp-28]			;;; i664
	push	1071313688			;;; i650
	push	1913189133			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fmul				;;; i841
	push	1076053631			;;; i650
	push	1829914646			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsub				;;; i841
	fstp	q[ebp-36]			;;; i669
;
; [916] x = x * vv + .30957292821537650062264d2
	fld	q[ebp-36]			;;; i643a
	fld	q[ebp-28]			;;; i643a
	fmul				;;; i841
	push	1077867793			;;; i650
	push	611398437			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fstp	q[ebp-36]			;;; i669
;
; [917] x = x * vv - .240139179559210509868484d2
	fld	q[ebp-36]			;;; i643a
	fld	q[ebp-28]			;;; i643a
	fmul				;;; i841
	push	1077412752			;;; i650
	push	546144786			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsub				;;; i841
	fstp	q[ebp-36]			;;; i669
;
; [918] y = vv - .89111090279378312337d1
;
#ifdef Log0.y
#undef Log0.y
#endif
#define Log0.y ebp-44	; exposes local variable 'y'
;
	fld	q[ebp-28]			;;; i664
	push	1075958396			;;; i650
	push	-504616277			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsub				;;; i841
	fstp	q[ebp-44]			;;; i669
;
; [919] y = y * vv + .19480966070088973051623d2
	fld	q[ebp-44]			;;; i643a
	fld	q[ebp-28]			;;; i643a
	fmul				;;; i841
	push	1077115680			;;; i650
	push	-1750760306			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fadd				;;; i841
	fstp	q[ebp-44]			;;; i669
;
; [920] y = y * vv - .120069589779605254717525d2
	fld	q[ebp-44]			;;; i643a
	fld	q[ebp-28]			;;; i643a
	fmul				;;; i841
	push	1076364176			;;; i650
	push	546144786			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fsub				;;; i841
	fstp	q[ebp-44]			;;; i669
;
; [921] z = x / y
;
#ifdef Log0.z
#undef Log0.z
#endif
#define Log0.z ebp-52	; exposes local variable 'z'
;
	fld	q[ebp-36]			;;; i643a
	fld	q[ebp-44]			;;; i643a
	fdiv				;;; i841
	fstp	q[ebp-52]			;;; i669
;
; [922] RETURN (z)
	fld	q[ebp-52]			;;; i664
	jmp	end.func26.xma			;;; i258
;
; [924] END FUNCTION
	fldz				;;; i861
align 8
end.Log0.xma:  ;;; Function end label for Assembly Programmers.
end.func26.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	8			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Log0 ()  *****
;  *****
;
; [925] '
;
; [926] '
;
; [927] ' #####################
;
; [928] ' #####  Fmod ()  #####
;
; [929] ' #####################
;
; [930] '
;
; [931] ' Floating point modulus function.
;
; [932] '
;
; [933] FUNCTION DOUBLE Fmod (DOUBLE num1, DOUBLE num2)
.code
;
#ifdef Fmod.num1
#undef Fmod.num1
#endif
#define Fmod.num1 ebp+8	; exposes function argument 'num1'
;
;
#ifdef Fmod.num2
#undef Fmod.num2
#endif
#define Fmod.num2 ebp+16	; exposes function argument 'num2'
;
align 16
_Fmod@16:
;  *****
;  *****  FUNCTION  Fmod ()  *****
;  *****
func22.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
	sub	esp,236			;;; i114a
;
funcBody22.xma:
finit
fld     q[ebp+16]  					; st0 = num2
fld     q[ebp+8]  					; st1 = num2, st0 = num1
fmod:
fprem												; partial remainder
fstsw 	ax 									; store status word in ax
fwait
sahf  											; copy the condition bits in the CPU's flag register
jp 			fmod
fstp 		st1
jmp			end.Fmod.xma			  ; return with modulus in st(0)
;
; [948] END FUNCTION
	fldz				;;; i861
align 8
end.Fmod.xma:  ;;; Function end label for Assembly Programmers.
end.func22.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	16			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Fmod ()  *****
;  *****
;
; [949] '
;
; [950] '
;
; [951] ' #######################
;
; [952] ' #####  Fround ()  #####
;
; [953] ' #######################
;
; [954] '
;
; [955] ' Floating point rounding function.
;
; [956] '
;
; [957] FUNCTION  DOUBLE Fround (DOUBLE number, power)
.code
;
#ifdef Fround.number
#undef Fround.number
#endif
#define Fround.number ebp+8	; exposes function argument 'number'
;
;
#ifdef Fround.power
#undef Fround.power
#endif
#define Fround.power ebp+16	; exposes function argument 'power'
;
align 16
_Fround@12:
;  *****
;  *****  FUNCTION  Fround ()  *****
;  *****
func23.xma:
	push	ebp			;;; i112
	mov	ebp,esp		;;; i113
	sub	esp,8			;;; i114
	push	esi			;;; save esi
	push	edi			;;; save edi
	push	ebx			;;; save ebx
;
;	#### Begin Local Initialization Code ####
	push	0			;;; .
	push	0			;;; ..
;	#### End Local Initialization Code ####
;
;	################################################################################
;	### *** IMPORTANT *** - If hand-optimizing by eliminating the initialization ###
;	### code above, the first 'sub esp,____' line below must be uncommented      ###
;	### and the second must be either deleted or commented out.                  ###
;	### !!! Failure to do so will cause the resultant program to crash !!!       ###
;	################################################################################
;
;	sub esp,236
	sub	esp,228			;;; i114a
;
funcBody23.xma:
;
; [958] pTen# = 10# ** power
;
#ifdef Fround.pTen
#undef Fround.pTen
#endif
#define Fround.pTen ebp-28	; exposes local variable 'pTen#'
;
	push	1076101120			;;; i650
	push	0			;;; i651
	fld	q[esp]			;;; i652
	add	esp,8			;;; i653
	fild	d[ebp+16]			;;; i643a
	call	%_power.double			;;; i834
	fstp	q[ebp-28]			;;; i669
;
; [959] RETURN ROUND(number / pTen#) * pTen#
	sub	esp,64			;;; i487
	fld	q[ebp+8]			;;; i643a
	fld	q[ebp-28]			;;; i643a
	fdiv				;;; i841
	fstp	q[esp]
	call	%_round.double			;;; i541
	add	esp,64			;;; i600
	fld	q[ebp-28]			;;; i643a
	fmul				;;; i841
	jmp	end.func23.xma			;;; i258
;
; [960] END FUNCTION
	fldz				;;; i861
align 8
end.Fround.xma:  ;;; Function end label for Assembly Programmers.
end.func23.xma:
	lea	esp,[ebp-20]				;;; i110
	pop	ebx				;;; restore ebx
	pop	edi				;;; restore edi
	pop	esi				;;; restore esi
	leave					;;; replaces 'mov esp,ebp' 'pop ebp'
	ret	12			;;; i111a
;-peep
;  *****
;  *****  END FUNCTION  Fround ()  *****
;  *****
;
; [961] END PROGRAM
end_program.xma:
	push	ebp			;;; i128
	mov	ebp,esp			;;; i129
	sub	esp,128			;;; i130
	mov	esp,ebp			;;; i132
	pop	ebp			;;; i133
	ret				;;; i134
;
InitSharedComposites.xma:
	ret				;;; i143
;;;  *****  DEFINE '.bss' SECTION LIMITS  *****
;
align 8
data section 'xma$aaaaa'
%_begin_external_data_xma dd ?
;
align 8
data section 'xma$zzzzz'
%_end_external_data_xma dd ?
;
;
;;;  *****  DEFINE LITERAL STRINGS  *****
.const
align 8
;
dd 24, 0, 3, 0x80130001
@_string.0029.xma:
db	"xma"
db	5 dup 0
;
dd 24, 0, 6, 0x80130001
@_string.002A.xma:
db	"0.0021"
db	2 dup 0
;
dd 32, 0, 15, 0x80130001
@_string.StartLibrary.xma:
db	"%_StartLibrary_"
db	1 dup 0
