/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class ArrayLocatorResultSet
extends OracleResultSetImpl {
    static int COUNT_UNLIMITED = -1;
    Map map;
    long beginIndex;
    int count;
    long currentIndex;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_18:54:31_PDT_2005";

    public ArrayLocatorResultSet(OracleConnection oracleConnection, ArrayDescriptor arrayDescriptor, byte[] byArray, Map map) throws SQLException {
        this(oracleConnection, arrayDescriptor, byArray, 0L, COUNT_UNLIMITED, map);
    }

    public ArrayLocatorResultSet(OracleConnection oracleConnection, ArrayDescriptor arrayDescriptor, byte[] byArray, long l, int n, Map map) throws SQLException {
        super((PhysicalConnection)oracleConnection, null);
        if (arrayDescriptor == null || oracleConnection == null) {
            DatabaseError.throwSqlException(1, "Invalid arguments");
        }
        this.close_statement_on_close = true;
        this.count = n;
        this.currentIndex = 0L;
        this.beginIndex = l;
        this.map = map;
        OraclePreparedStatement oraclePreparedStatement = null;
        ARRAY aRRAY = new ARRAY(arrayDescriptor, oracleConnection, (Object)null);
        aRRAY.setLocator(byArray);
        oraclePreparedStatement = arrayDescriptor.getBaseType() == 2002 || arrayDescriptor.getBaseType() == 2008 ? (OraclePreparedStatement)oracleConnection.prepareStatement("SELECT ROWNUM, SYS_NC_ROWINFO$ FROM TABLE( CAST(:1 AS " + arrayDescriptor.getName() + ") )") : (OraclePreparedStatement)oracleConnection.prepareStatement("SELECT ROWNUM, COLUMN_VALUE FROM TABLE( CAST(:1 AS " + arrayDescriptor.getName() + ") )");
        oraclePreparedStatement.setArray(1, aRRAY);
        oraclePreparedStatement.executeQuery();
        this.statement = oraclePreparedStatement;
    }

    public synchronized boolean next() throws SQLException {
        if (this.currentIndex < this.beginIndex) {
            while (this.currentIndex < this.beginIndex) {
                ++this.currentIndex;
                if (super.next()) continue;
                return false;
            }
            return true;
        }
        if (this.count == COUNT_UNLIMITED) {
            return super.next();
        }
        if (this.currentIndex < this.beginIndex + (long)this.count - 1L) {
            ++this.currentIndex;
            return super.next();
        }
        return false;
    }

    public synchronized Object getObject(int n) throws SQLException {
        return this.getObject(n, this.map);
    }

    public synchronized int findColumn(String string) throws SQLException {
        if (string.equalsIgnoreCase("index")) {
            return 1;
        }
        if (string.equalsIgnoreCase("value")) {
            return 2;
        }
        DatabaseError.throwSqlException(6, "get_column_index");
        return 0;
    }
}

