/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import java.util.ArrayList;
import unity.annotation.AttributeValueSource;
import unity.functions.Expression;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class Modulus
extends Expression {
    public Modulus(Expression leftExpr, Expression rightExpr) throws SQLException {
        this.children = new ArrayList(2);
        this.children.add(leftExpr);
        this.children.add(rightExpr);
        int leftType = leftExpr.getReturnType();
        int rightType = rightExpr.getReturnType();
        if (leftType != Attribute.TYPE_INT || rightType != Attribute.TYPE_INT) {
            throw new SQLException("Modulus (%) operator defined only for integer division.  Error around: " + leftExpr.toString() + " and " + rightExpr.toString());
        }
        this.returnType = Attribute.TYPE_INT;
    }

    public Object evaluate(Tuple t) {
        Expression leftExpr = (Expression)this.children.get(0);
        Expression rightExpr = (Expression)this.children.get(1);
        Object val1 = leftExpr.evaluate(t);
        if (val1 == null) {
            return null;
        }
        Object val2 = rightExpr.evaluate(t);
        if (val2 == null) {
            return null;
        }
        Object v1 = val1;
        Object v2 = val2;
        int sourceRef = 0;
        if (val1 instanceof AttributeValueSource) {
            v1 = ((AttributeValueSource)val1).getValue();
            sourceRef = 1;
        }
        if (val2 instanceof AttributeValueSource) {
            v2 = ((AttributeValueSource)val2).getValue();
            sourceRef = 2;
        }
        Integer returnVal = null;
        if (this.returnType == Attribute.TYPE_INT) {
            int i1 = (Integer)v1;
            int i2 = (Integer)v2;
            returnVal = new Integer(i1 % i2);
        } else {
            returnVal = null;
        }
        if (sourceRef == 0) {
            return returnVal;
        }
        if (sourceRef == 1) {
            return new AttributeValueSource(returnVal, ((AttributeValueSource)val1).getSource());
        }
        return new AttributeValueSource(returnVal, ((AttributeValueSource)val2).getSource());
    }

    public String toString(Relation relation) {
        return String.valueOf(((Expression)this.children.get(0)).toString(relation)) + " % " + ((Expression)this.children.get(1)).toString(relation);
    }
}

