/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import unity.io.FileManager;
import unity.io.Page;
import unity.operators.ChainedHashTable;
import unity.operators.Operator;
import unity.operators.PageHashTable;
import unity.predicates.EquiJoinPredicate;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class DynamicHashJoin
extends Operator {
    private int numBuckets;
    private EquiJoinPredicate pred;
    private Relation inner;
    private Relation outer;
    private boolean isLeftOuterJoin;
    private boolean isRightOuterJoin;
    private Tuple nullLeftTuple;
    private Tuple nullRightTuple;
    private PageHashTable innerHashTable;
    private int frozen;
    private PageHashTable outerHashTable;
    private int keyType;
    private int[] keyIdxInner;
    private int[] keyIdxOuter;
    private int numAttrs;
    private boolean processingFrozen;
    private int bucketNum;
    private boolean processingProbe;
    private ArrayList matches;
    private int curLoc;
    private Tuple probeTuple;
    private Page probePage;
    private boolean clearedHashTable;
    private BufferedInputStream probeFile;
    private boolean leftBuild;
    private ChainedHashTable hashTable;
    private int insertsAvoided;

    public DynamicHashJoin(Operator[] in, EquiJoinPredicate p, int bsize, int bfr, int numb) {
        this(in, p, bsize, bfr, numb, false, false);
    }

    public DynamicHashJoin(Operator[] in, EquiJoinPredicate p, int bsize, int bfr, int numb, boolean leftJoin, boolean rightJoin) {
        super(in, bfr, bsize);
        Object[] vals;
        this.numBuckets = numb;
        this.pred = p;
        this.inner = this.input[0].getOutputRelation();
        this.outer = this.input[1].getOutputRelation();
        Relation out = new Relation(this.inner);
        out.mergeRelation(this.outer);
        this.setOutputRelation(out);
        this.isLeftOuterJoin = leftJoin;
        this.isRightOuterJoin = rightJoin;
        if (this.isLeftOuterJoin) {
            vals = new Object[this.outer.getNumAttributes()];
            Arrays.fill(vals, null);
            this.nullRightTuple = new Tuple(vals, this.outer);
        }
        if (this.isRightOuterJoin) {
            vals = new Object[this.inner.getNumAttributes()];
            Arrays.fill(vals, null);
            this.nullLeftTuple = new Tuple(vals, this.inner);
        }
    }

    public void init() throws IOException {
        this.input[0].init();
        this.numAttrs = this.pred.getNumAttr();
        this.keyIdxInner = this.pred.getRelation1Locs();
        this.keyIdxOuter = this.pred.getRelation2Locs();
        if (this.numAttrs > 1) {
            this.keyType = 3;
        } else if (this.inner.getAttributeType(this.keyIdxInner[0]) == Attribute.TYPE_INT) {
            this.keyType = 1;
        } else if (this.inner.getAttributeType(this.keyIdxInner[0]) == Attribute.TYPE_STRING) {
            this.keyType = 2;
        }
        this.innerHashTable = new PageHashTable(this.numBuckets, this.BLOCKING_FACTOR, this.BUFFER_SIZE, this.input[0].getOutputRelation());
        this.frozen = 0;
        this.partitionInner(this.input[0]);
        this.input[1].init();
        this.outerHashTable = new PageHashTable(this.numBuckets, this.BLOCKING_FACTOR, this.BUFFER_SIZE, this.input[1].getOutputRelation());
        int i = 0;
        while (i < this.frozen) {
            this.outerHashTable.initBucket(i, PageHashTable.IS_FROZEN);
            ++i;
        }
        this.processingFrozen = false;
        this.leftBuild = true;
        this.probeTuple = new Tuple(this.outer);
        this.probePage = new Page(this.BLOCKING_FACTOR, this.outer);
        this.insertsAvoided = 0;
        this.clearedHashTable = false;
    }

    public void close() throws IOException {
        this.cleanup();
    }

    /*
     * Unable to fully structure code
     */
    public Tuple next() throws IOException {
        block0: while (true) {
            if (this.processingProbe) {
                if (this.curLoc == this.matches.size()) {
                    this.processingProbe = false;
                    this.matches.clear();
                    continue;
                }
                ++this.curLoc;
                if (this.leftBuild) {
                    return this.outputJoinTuple((Tuple)this.matches.get(this.curLoc - 1), this.probeTuple);
                }
                return this.outputJoinTuple(this.probeTuple, (Tuple)this.matches.get(this.curLoc - 1));
            }
            if (!this.processingFrozen) ** GOTO lbl119
            if (this.probePage.hasNext()) {
                this.probeTuple = this.probePage.next();
                currentIdx = this.leftBuild == false ? this.keyIdxInner : this.keyIdxOuter;
                if (this.keyType == 1) {
                    if (!this.probeTuple.isNull(currentIdx[0])) {
                        this.matches = this.hashTable.find(this.probeTuple.getInt(currentIdx[0]));
                    } else if (this.keyType == 2) {
                        this.matches = this.hashTable.find(this.probeTuple.getString(currentIdx[0]));
                    } else {
                        vals = new Object[this.numAttrs];
                        k = 0;
                        while (k < this.numAttrs) {
                            vals[k] = this.probeTuple.getObject(currentIdx[k]);
                            ++k;
                        }
                        this.matches = this.hashTable.find(vals);
                        if (this.isLeftOuterJoin && !this.leftBuild) {
                            if (this.matches.size() == 0) {
                                this.matches.add(this.nullRightTuple);
                            }
                        } else if (this.isRightOuterJoin && this.leftBuild && this.matches.size() == 0) {
                            this.matches.add(this.nullLeftTuple);
                        }
                    }
                }
                this.curLoc = 0;
                this.processingProbe = true;
                continue;
            }
            if (this.probePage.read(this.probeFile) > 0) {
                this.probePage.initIterator();
                this.incrementPageIOs();
                this.incrementTupleIOs(this.probePage.getTupleCount());
                continue;
            }
            FileManager.closeFile(this.probeFile);
            if (this.isLeftOuterJoin && this.leftBuild) {
                this.matches = this.hashTable.getNonMatched();
                this.processingProbe = true;
                this.probeTuple = this.nullRightTuple;
            } else if (this.isRightOuterJoin && !this.leftBuild) {
                this.matches = this.hashTable.getNonMatched();
                this.processingProbe = true;
                this.probeTuple = this.nullLeftTuple;
            }
            if (this.bucketNum == this.frozen) {
                this.cleanup();
                return null;
            }
            ++this.bucketNum;
            if (!this.setupBucket(this.bucketNum)) {
                this.cleanup();
                return null;
            }
            this.processingProbe = false;
            continue;
lbl-1000:
            // 1 sources

            {
                this.incrementTuplesRead();
                if (this.keyType == 1) {
                    bucket = this.probeTuple.isNull(this.keyIdxOuter[0]) ? 0 : this.outerHashTable.getHashLocation(this.probeTuple.getInt(this.keyIdxOuter[0]));
                } else if (this.keyType == 2) {
                    bucket = this.outerHashTable.getHashLocation(this.probeTuple.getString(this.keyIdxOuter[0]));
                } else {
                    vals = new Object[this.numAttrs];
                    k = 0;
                    while (k < this.numAttrs) {
                        vals[k] = this.probeTuple.getObject(this.keyIdxOuter[k]);
                        ++k;
                    }
                    bucket = this.outerHashTable.getHashLocation(vals);
                }
                if (bucket < this.frozen) {
                    if (this.keyType == 1) {
                        if (!this.probeTuple.isNull(this.keyIdxOuter[0]) || this.isRightOuterJoin) {
                            this.outerHashTable.insert(this.probeTuple.getInt(this.keyIdxOuter[0]), this.probeTuple);
                        } else if (this.keyType == 2) {
                            this.outerHashTable.insert(this.probeTuple.getString(this.keyIdxOuter[0]), this.probeTuple);
                        } else {
                            vals = new Object[this.numAttrs];
                            k = 0;
                            while (k < this.numAttrs) {
                                vals[k] = this.probeTuple.getObject(this.keyIdxOuter[k]);
                                ++k;
                            }
                            this.outerHashTable.insert(vals, this.probeTuple);
                        }
                    }
                    this.incrementTupleIOs(this.outerHashTable.getTupleIOs());
                    this.incrementPageIOs(this.outerHashTable.getPageIOs());
                    continue;
                }
                ++this.insertsAvoided;
                if (this.keyType == 1) {
                    this.matches = this.innerHashTable.probeHashTable(bucket, this.probeTuple.getInt(this.keyIdxOuter[0]));
                } else if (this.keyType == 2) {
                    this.matches = this.innerHashTable.probeHashTable(bucket, this.probeTuple.getString(this.keyIdxOuter[0]));
                } else {
                    vals = new Object[this.numAttrs];
                    k = 0;
                    while (k < this.numAttrs) {
                        vals[k] = this.probeTuple.getObject(this.keyIdxOuter[k]);
                        ++k;
                    }
                    this.matches = this.innerHashTable.probeHashTable(bucket, vals);
                }
                if (this.isRightOuterJoin && this.matches.size() == 0) {
                    this.matches.add(this.nullLeftTuple);
                }
                this.curLoc = 0;
                this.processingProbe = true;
                continue block0;
lbl119:
                // 2 sources

                ** while ((this.probeTuple = this.input[1].next()) != null)
            }
lbl120:
            // 1 sources

            if (this.isLeftOuterJoin && !this.clearedHashTable) {
                i = this.frozen;
                while (i < this.numBuckets) {
                    ht = this.innerHashTable.getHashTable(i);
                    tmp = ht.getNonMatched();
                    this.matches.addAll(tmp);
                    ++i;
                }
                this.processingProbe = true;
                this.probeTuple = this.nullRightTuple;
                this.clearedHashTable = true;
                this.curLoc = 0;
                continue;
            }
            this.input[1].close();
            this.outerHashTable.close(PageHashTable.IS_FROZEN);
            this.incrementTupleIOs(this.outerHashTable.getTupleIOs());
            this.incrementPageIOs(this.outerHashTable.getPageIOs());
            this.processingFrozen = true;
            this.bucketNum = 0;
            if (!this.setupBucket(this.bucketNum)) break;
        }
        return null;
    }

    private void partitionInner(Operator in) throws IOException {
        Tuple t = new Tuple(this.inner);
        int result = 0;
        while ((t = in.next()) != null) {
            this.incrementTuplesRead();
            if (this.keyType == 1) {
                if (!t.isNull(this.keyIdxInner[0]) || this.isLeftOuterJoin) {
                    result = this.innerHashTable.insert(t.getInt(this.keyIdxInner[0]), t);
                }
            } else if (this.keyType == 2) {
                if (!t.isNull(this.keyIdxInner[0]) || this.isLeftOuterJoin) {
                    result = this.innerHashTable.insert(t.getString(this.keyIdxInner[0]), t);
                }
            } else {
                Object[] vals = new Object[this.numAttrs];
                int k = 0;
                while (k < this.numAttrs) {
                    vals[k] = t.getObject(this.keyIdxInner[k]);
                    ++k;
                }
                result = this.innerHashTable.insert(vals, t);
            }
            this.incrementTupleIOs(this.innerHashTable.getTupleIOs());
            this.incrementPageIOs(this.innerHashTable.getPageIOs());
            if (result < 0) continue;
            this.purge();
            this.incrementTupleIOs(this.innerHashTable.getTupleIOs());
            this.incrementPageIOs(this.innerHashTable.getPageIOs());
        }
        in.close();
        this.innerHashTable.close(PageHashTable.IS_FROZEN);
        this.incrementTupleIOs(this.innerHashTable.getTupleIOs());
        this.incrementPageIOs(this.innerHashTable.getPageIOs());
        int i = this.frozen;
        while (i < this.numBuckets) {
            this.innerHashTable.buildHashTable(i, this.keyType, this.keyIdxInner, this.numAttrs);
            ++i;
        }
    }

    private boolean setupBucket(int bucket) throws IOException {
        Tuple t;
        Page p;
        int numTuples;
        BufferedInputStream buildFile;
        int numRight;
        int numLeft;
        while (true) {
            if (bucket >= this.frozen) {
                return false;
            }
            numLeft = this.innerHashTable.getTuples(bucket);
            numRight = this.outerHashTable.getTuples(bucket);
            if (numLeft > 0 && numRight > 0) break;
            ++bucket;
        }
        if (numRight < numLeft) {
            buildFile = FileManager.openInputFile(this.outerHashTable.getFileName(bucket));
            this.probeFile = FileManager.openInputFile(this.innerHashTable.getFileName(bucket));
            numTuples = numRight;
            this.leftBuild = false;
            this.probePage = new Page(this.BLOCKING_FACTOR, this.inner);
        } else {
            this.probeFile = FileManager.openInputFile(this.outerHashTable.getFileName(bucket));
            buildFile = FileManager.openInputFile(this.innerHashTable.getFileName(bucket));
            numTuples = numLeft;
            this.leftBuild = true;
            this.probePage = new Page(this.BLOCKING_FACTOR, this.outer);
        }
        this.hashTable = new ChainedHashTable(numTuples);
        if (this.leftBuild) {
            p = new Page(this.BLOCKING_FACTOR, this.inner);
            t = new Tuple(this.inner);
        } else {
            p = new Page(this.BLOCKING_FACTOR, this.outer);
            t = new Tuple(this.outer);
        }
        while (p.read(buildFile) > 0) {
            p.initIterator();
            while (p.hasNext()) {
                int k;
                Object[] vals;
                t = p.next();
                if (this.leftBuild) {
                    if (this.keyType == 1) {
                        if (t.isNull(this.keyIdxInner[0])) {
                            this.hashTable.insert(0, (Object)t);
                            continue;
                        }
                        this.hashTable.insert(t.getInt(this.keyIdxInner[0]), (Object)t);
                        continue;
                    }
                    if (this.keyType == 2) {
                        this.hashTable.insert(t.getString(this.keyIdxInner[0]), (Object)t);
                        continue;
                    }
                    vals = new Object[this.numAttrs];
                    k = 0;
                    while (k < this.numAttrs) {
                        vals[k] = t.getObject(this.keyIdxInner[k]);
                        ++k;
                    }
                    this.hashTable.insert(vals, (Object)t);
                    continue;
                }
                if (this.keyType == 1) {
                    if (t.isNull(this.keyIdxInner[0])) {
                        this.hashTable.insert(0, (Object)t);
                        continue;
                    }
                    this.hashTable.insert(t.getInt(this.keyIdxInner[0]), (Object)t);
                    continue;
                }
                if (this.keyType == 2) {
                    this.hashTable.insert(t.getString(this.keyIdxOuter[0]), (Object)t);
                    continue;
                }
                vals = new Object[this.numAttrs];
                k = 0;
                while (k < this.numAttrs) {
                    vals[k] = t.getObject(this.keyIdxOuter[k]);
                    ++k;
                }
                this.hashTable.insert(vals, (Object)t);
            }
        }
        FileManager.closeFile(buildFile);
        this.incrementTupleIOs(numTuples);
        this.incrementPageIOs((int)Math.ceil((double)numTuples / (double)this.BLOCKING_FACTOR));
        this.probePage.read(this.probeFile);
        this.probePage.initIterator();
        this.incrementTupleIOs(this.probePage.getTupleCount());
        this.incrementPageIOs();
        return true;
    }

    private void cleanup() throws IOException {
        this.innerHashTable.clear();
        this.outerHashTable.clear();
    }

    private void purge() throws IOException {
        int purgeBucketNum = this.frozen++;
        this.innerHashTable.purge(purgeBucketNum);
    }

    private Tuple outputJoinTuple(Tuple left, Tuple right) {
        Tuple t = new Tuple(left, right, this.getOutputRelation());
        this.incrementTuplesOutput();
        return t;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(250);
        sb.append("DYNAMIC HASH JOIN: ");
        sb.append(this.pred.toString(this.inner, this.outer));
        sb.append("   (BufferSizeInTuples=" + this.BUFFER_SIZE * this.BLOCKING_FACTOR + " ; IsLeftOuter=" + this.isLeftOuterJoin + " ; IsRightOuter=" + this.isRightOuterJoin + ")");
        return sb.toString();
    }
}

