(*-------------------------------------------------------------------------*)
(*              CDNorm  -- Cumulative normal distribution probability      *)
(*-------------------------------------------------------------------------*)

FUNCTION CDNorm( X : REAL ) : REAL;

(*-------------------------------------------------------------------------*)
(*                                                                         *)
(*       Function:  CDNorm                                                 *)
(*                                                                         *)
(*       Purpose:   Evaluates cumulative normal distribution probability   *)
(*                                                                         *)
(*       Calling Sequence:                                                 *)
(*                                                                         *)
(*            P     := CDNorm( X );                                        *)
(*                                                                         *)
(*                 X      --- ordinate of normal distribution              *)
(*                                                                         *)
(*                 P      --- Resultant cumulative probability             *)
(*                                                                         *)
(*       Calls:                                                            *)
(*                                                                         *)
(*            Erf                                                          *)
(*                                                                         *)
(*       Method:                                                           *)
(*                                                                         *)
(*            The simple relationship between the error function and the   *)
(*            normal distribution is used.                                 *)
(*                                                                         *)
(*-------------------------------------------------------------------------*)

BEGIN (* CDNorm *)

   IF X >= 0.0 THEN
      CDNorm := ( 1.0 + Erf(  X / Sqrt2 ) ) / 2.0
   ELSE
      CDNorm := ( 1.0 - Erf( -X / Sqrt2 ) ) / 2.0;

END   (* CDNorm *);