/****	common.h	- Common definitions for all programs	****/

/*	Copyright (C) 1989 Massachusetts Institute of Technology
 *		Right to copy granted under the terms described
 *		in the file Copyright accompanying this distribution.
 */



#ifdef EDIT_HISTORY

Nbr Date	Author		Description
--- ----	------		-----------
 3  20-Feb-89	M. A. Patton	First release version.
 3A 15-Jul-89	M. A. Patton	Cosmetics.

#endif

#include <stdio.h>


/* Random "obvious" defines */
#define FOREVER	for (;;)
#ifndef TRUE
#define TRUE    (1)
#endif
#ifndef FALSE
#define FALSE   (0)
#endif



/* Unix(tm) just doesn't have this one? */
#define streq(a,b) (strcmp(a,b)==0)



/* This is a macro to go thru a list of items.  Its name is derived
 * from the Lisp construct that does this.
 */
#define MAPCAR(var,init) for (var=(init); (var)!=NULL; var=(var->next))


/* Generally useful constructs  */

/*  The number of elements in an array */
#define array_sizeof(nam)   (sizeof(nam)/sizeof(nam[0]))

/* Upper case letters, uses upcase.c table */
extern char _upcase[];
#define upcase(ch) (_upcase[ch])


/* Generalized subroutines anyone might call */
extern char *GetLine();
extern char *new_string();
extern FILE *find_file();



/* These are macros for writing command line argument parsing. */
#define S_ARG(opt,var)	if (streq(Argv[i],opt))			\
			{   if (++i>=Argc) return (FALSE);	\
			    var = Argv[i];			\
			    continue;				\
			}
#define I_ARG(opt,var)	if (streq(Argv[i],opt))			\
			{   if (++i>=Argc) return (FALSE);	\
			    var = atoi(Argv[i]);		\
			    continue;				\
			}
#define B_ARG(opt,var)	if (streq(Argv[i],opt))			\
			{   var = !var;				\
			    continue;				\
			}
