@device[postscript]
@make[report]
@DefineFont(HeadingFont,
      P=<RawFont "NewCenturySchlbkBoldItalic">,
      B=<RawFont "NewCenturySchlbkBold">,
      I=<RawFont "NewCenturySchlbkBoldItalic">,
      R=<RawFont "NewCenturySchlbkRoman">)
@Counter(MajorPart,TitleEnv HD0,ContentsEnv tc0,Numbered [@I],
          IncrementedBy Use,Announced)
@Counter(Chapter,TitleEnv HD1,ContentsEnv tc1,Numbered [@1. ],
          IncrementedBy Use,Referenced [@1],Announced)
@Counter(Appendix,TitleEnv HD1,ContentsEnv tc1,Numbered [@A. ],
          IncrementedBy,Referenced [@A],Announced,Alias Chapter)
@Counter(UnNumbered,TitleEnv HD1,ContentsEnv tc1,Announced,Alias 
           Chapter)
@Counter(Section,Within Chapter,TitleEnv HD2,ContentsEnv tc2,
          Numbered [@#@:.@1 ],Referenced [@#@:.@1],IncrementedBy
          Use,Announced)
@Counter(AppendixSection,Within Appendix,TitleEnv HD2,
          ContentsEnv tc2,
          Numbered [@#@:.@1 ],Referenced [@#@:.@1],IncrementedBy 
          Use,Announced)
@Counter(SubSection,Within Section,TitleEnv HD3,ContentsEnv tc3,
          Numbered [@#@:.@1 ],IncrementedBy Use,
          Referenced [@#@:.@1 ])
@Counter(AppendixSubSection,Within AppendixSection,TitleEnv HD3,
          ContentsEnv tc3,
          Numbered [@#@:.@1 ],IncrementedBy Use,
          Referenced [@#@:.@1 ])
@Counter(Paragraph,Within SubSection,TitleEnv HD4,ContentsEnv tc4,
          Numbered [@#@:.@1 ],Referenced [@#@:.@1],
          IncrementedBy Use)
@modify(CopyrightNotice, Fixed -1 inch, Flushright)
@Modify(Titlebox, Fixed 3.0 inches)
@Modify(hd1, below .2 inch, facecode B, size 16, spaces kept, pagebreak off)
@Modify(hd2, below .2 inch, facecode B, size 14, spaces kept)
@Modify(hd3, below .2 inch, facecode B, size 12, spaces kept)
@Modify(Description, Leftmargin +20, Indent -20,below 1 line, above 1 line)
@Modify(Tc1, Above .5,  Facecode B)
@Modify(Tc2, Above .25, Below .25, Facecode R)
@Modify(Tc3,Facecode R)
@Modify(Tc4,Facecode R)
@Modify(Itemize,Above 1line,Below 1line)
@Modify(Insert,LeftMargin +2, RightMargin +2)
@libraryfile[stable]
@Style(Font NewCenturySchoolBook, size 11)
@Style(Spacing 1.1, indent 0)
@Style(leftmargin 1.0inch)
@Style(justification no)
@Style(BottomMargin 1.5inch)
@Style(ChangeBarLocation Right)
@Style(ChangeBars=off)
@pageheading[immediate]
@pagefooting[immediate, left = "MIT Project Athena", center = "@value(page)",
right = "January 24, 1989"]
@set[page = 1]
@blankspace[.5 inches]
@begin[group, size 20]
@begin(center)
@b[Kerberos Installation Notes]
@b[DRAFT]
@end[center]
@end(group)
@blankspace[.5 inches]
@begin[group, size 16]
@begin(center)
Bill Bryant
Jennifer Steiner
@blankspace[1 line]
Project Athena, MIT
@blankspace[.5 inches]
@b[Initial Release, January 24, 1989]
@end[center]
@end(group)
@begin[group, size 10]
@end[group]
@blankspace[.75 inches]


The release consists of four parts.
You may not receive all the parts due to
certain software license requirements as explained
below.

The first part consists of the core Kerberos system, which was developed
at MIT and does not require additional licenses for us to distribute.
Included in this part are the Kerberos authentication server, the
Kerberos library, the
@i[ndbm]
database interface library, user programs, administration programs,
manual pages, some applications which use Kerberos for authentication,
and some utilities.

The second part is the Data Encryption Standard (DES) library, which we
are distributing only within the United States.

The third part requires a Berkeley Unix license to distribute, and
consists of applications such as
@i[rlogin]
which have been modified to use Kerberos.

The fourth part contains Kerberos modifications to Sun's NFS, and
requires a Sun source license for distribution.

@chapter[Organization of the Source Directory]

The Kerberos building and installation process,
as described in this document,
builds the binaries and executables from the files contained in the Kerberos
source tree, and deposits them in a separate object tree.
We suggest that you copy the Kerberos sources into a
@i[/mit/kerberos/src] directory,
and create as well a @i[/mit/kerberos/obj] directory in which
to hold the executables.
In the rest of this document, we'll refer to the Kerberos
source and object directories as [SOURCE_DIR]
and [OBJ_DIR], respectively.

Below is a brief overview of the organization of the complete
source directory.
More detailed descriptions follow.
Notes of the form ``(BSD only)'' refer to license restrictions.

@begin[description]

@b[admin]@\utilities for the Kerberos administrator

@b[appl]@\applications that use Kerberos

@b[appl/bsd]@\Berkeley's rsh/rlogin suite, using Kerberos (BSD only)

@b[appl/erlogin]@\similar to rlogin, but propagates the environment

@b[appl/knetd]@\

@b[appl/sample]@\sample application server and client

@b[appl/tftp]@\Trivial File Transfer Protocol, using Kerberos

@b[include]@\include files

@b[kadmin]@\interface to the Kerberos master database

@b[kuser]@\user programs

@b[lib]@\libraries for use with/by Kerberos

@b[lib/acl]@\

@b[lib/des]@\Data Encryption Standard library (US only)

@b[lib/kdb]@\library interface to @i[ndbm]

@b[lib/knet]@\

@b[lib/krb]@\

@b[man]@\manual pages

@b[prototypes]@\sample configuration files

@b[server]@\the authentication server

@b[slave]@\Kerberos slave database propagation software

@b[tools]@\shell scripts

@b[util]@\utilities

@end[description]

@section[The @p(admin) Directory]

This directory contains source for
the Kerberos master database administration tools.
@begin[description]
@b[kdb_init]@\This program creates and initializes the
Kerberos master database.
It prompts for a Kerberos realmname, and the Kerberos master password.

@b[kstash]@\This program ``stashes'' the master password in a secret
place so that the master server machine can restart the Kerberos
server automatically after an automatic reboot.
The hidden password is also available to administrative programs
that have been set to run automatically.

@b[kdb_edit]@\This program is a low level tool for editing
the master database.

@b[kdb_destroy]@\This program deletes the master database.

@b[kdb_util]@\This program can be used to dump the master database
into an ascii file, and can also be used to load the ascii file
into the master database.

@b[ext_srvtab]@\This program extracts information from the master
database and creates a host-dependent @i[srvtab] file.
This file contains the Kerberos keys for the host's
``Kerberized'' services.
These services look up their keys in the @i[srvtab] file
for use in the authentication process.
@end[description]

@section[The @p(kuser) Directory]

This directory contains the source code for several user-oriented
programs.
@begin[description]
@b[kinit]@\This program prompts users for their usernames and
Kerberos passwords, then furnishes them with Kerberos ticket-granting
tickets.

@b[kdestroy]@\This program destroys any active tickets.
Users should use @i[kdestroy] before they log off their workstations.

@b[klist]@\This program lists a user's active tickets.

@b[ksrvtgt]@\This retrieves a ticket-granting ticket with a life time
of five minutes.  It is primarily for use in shell scripts and other
batch facilities.

@b[ksu]@\Substitute user id, using Kerberos.
@end[description]

@section[The @p(appl) Directory]

If your site has the appropriate BSD license,
your Kerberos release provides certain Unix utilities
that have been modified to accept Kerberos authentication.
You'll find these utilities in the @i[appl/bsd] directory.
They include @i[login], @i[rlogin], @i[rsh], and @i[rcp].
The @i[login] program obtains ticket-granting tickets for users
upon login; the other utilities provide authenticated
Unix network services.

If your site has the appropriate SUN NFS license
your release provides Kerberos modifications to NFS
in the @i[appl/nfs] directory.

The @i[appl] directory also contains a sample Kerberos application
client and server program, an authenticated @i[tftp] program,
@i[knetd], an authenticated inet daemon, and @i[erlogin], an
authenticated rlogin that propagates the environment.  You do not need
special licenses to receive these programs.

@section[The @p(server) Directory]

The @i[server] directory contains the Kerberos
servers.
This release furnishes only the authentication server,
called @i[kerberos].
This program manages read-only requests made to the
master database,
distributing tickets and encryption keys to clients requesting
authentication service.

@section[The @p(kadmin) Directory]

This server accepts network requests from the
user program @i[kpasswd] and the
Kerberos administration program
@i(kadmin).
The administration server can make modifications to the master database.

@section[The @p(include) Directory]

This directory contains the @i[include] files needed to
build the Kerberos system.

@section[The @p(lib) Directory]

The @i[lib] directory has five subdirectories:
@i[acl], @i[des], @i[kdb], @i[knet], and @i[krb].
The @i[des] directory contains source for the DES encryption library.
The @i[kdb] directory contains source for the Kerberos database
routine library.
The @i[krb] directory contains source for the @i[libkrb.a]
library.
This library contains routines that are used by the Kerberos server program,
and by applications programs that require authentication service.

@section[The @p(man) Directory]

This directory contains manual pages for Kerberos programs and
library routines.

@section[The @p(prototypes) Directory]

This directory contains prototype
@i[/etc/services] and @i[/etc/krb.conf] files.
New entries must be added to the @i[/etc/services] file for
the Kerberos server, and possibly for Kerberized applications.
The @i[/etc/krb.conf] file defines the local Kerberos realm
for its host and lists Kerberos servers for given realms.

@section[The @p(tools) Directory]

This directory contains
a Makefile to set up a directory tree
for building the software in, and
a shell script to format code in the
style we use.


@section[The @p(util) Directory]

This directory contains several programs which aren't used in
this release, but will be soon.
Included are Larry Wall's @i[patch] program, a @i[make] pre-processor
program called
@i[imake], and a program for generating Makefile dependencies,
@i[makedepend].

@chapter[Preparing for Installation]

This document assumes that you will build the system
on the machine on which you plan to install
the Kerberos master server and its database.
You'll need about 10 megabytes for source and executables.

By default, there must be
a @i[/kerberos] directory on the master server machine
in which to store the Kerberos
database files.
If the master server machine does not have room on its root partition
for these files,
create a @i[/kerberos] symbolic link to another file system.

@chapter[Preparing for the Build]

Before you build the system,
you have to choose a @b[realm name],
the name that specifies the system's administrative domain.
Project Athena uses the internet domain name ATHENA.MIT.EDU
to specify its Kerberos realm name.
We recommend using a name of this form.

Edit the [SOURCE_DIR]/@i[include/krb.h] file and look for the following
lines of code:
@begin[example]
/*
 * Kerberos specific definitions
 *
 * KRBLOG is the log file for the kerberos master server.
 * KRB_CONF is the configuration file where different host
 * machines running master and slave servers can be found.
 * KRB_MASTER is the name of the machine with the master
 * database.  The admin_server runs on this machine, and all
 * changes to the db (as opposed to read-only requests, which
 * can go to slaves) must go to it.
 * KRB_HOST is the default machine when looking for a kerberos
 * slave server.  Other possibilities are in the KRB_CONF file.
 * KRB_REALM is the name of the realm.
 */

#ifdef notdef
this is server-only, does not belong here;
#define       KRBLOG          "/kerberos/kerberos.log"
are these used anyplace '?';
#define               VX_KRB_HSTFILE  "/etc/krbhst"
#define               PC_KRB_HSTFILE  "\\kerberos\\krbhst"
#endif

#define               KRB_CONF        "/etc/krb.conf"
#define               KRB_RLM_TRANS   "/etc/krb.realms"
#define               KRB_MASTER      "kerberos"
#define               KRB_HOST         KRB_MASTER
#define               KRB_REALM       "ATHENA.MIT.EDU"
@end[example]
Edit the last three lines as follows:
@begin[enumerate]
The KRB_MASTER definition specifies
name of the machine on which the server will run.
We recommend you name this master machine ``kerberos''.
However, if you wish to use some other name,
change ``kerberos'' to that other name.

Change the KRB_REALM definition so that it specifies the realm name
you have chosen for your Kerberos system.
@end[enumerate]

@section[The @p(/etc/krb.conf) File]

Create a @i[/etc/krb.conf] file using the following format:
@begin[example]
@p[realm_name]
@p[realm_name]  @p[master_server_name]
@end[example]
where @i[realm_name] specifies the system's realm name,
and @i[master_server_name] specifies the machine name on
which you will run the master server.

For example,
if your realm name is @i[tim.edu] and your master server's name is
@i[kerberos.tim.edu], the file should have these contents:
@begin[example]
tim.edu
tim.edu  kerberos.tim.edu
@end[example]

See the [SOURCE_DIR]/@i[prototypes/etc.krb.conf] file for an
example @i[/etc/krb.conf] file.

@chapter[Building the Software]

Before you build the software
read the @b[README] file in [SOURCE_DIR].
What follows is a more detailed description of the instructions
listed in README.
(Note to any ULTRIX users:  the ULTRIX
equivalent of @i[cc -M] is @i[cc -Em].
You'll have to patch your Makefiles accordingly.)
@begin[enumerate]
Create an [OBJ_DIR] directory to hold the tree of Kerberos object files you
are about to build, for example,
@i[/mit/kerberos/obj].

Change directory to [OBJ_DIR].
The following command creates directories under [OBJ_DIR]
and installs Makefiles for the final build.
@begin[example, rightmargin -7]
host# @b(make  -f  [SOURCE_DIR]/tools/makeconfig  SRCDIR=[SOURCE_DIR] 
        DESTDIR=[OBJ_DIR])
@end[example]



Cd to util/imake.includes.  Read through config.Imakefile, turning on
appropriate flags for your installation.  Change SRCTOP so that it is
set to the top level of your source directory.

Check that your machine type has a definition in include/osconf.h &
related files in the source tree (if it doesn't, then you may need to
create your own; if you get successful results, please post to
kerberos@athena.mit.edu)

Change directory to [OBJ_DIR].  The next command first adds dependency
information to the Makefiles that you previously installed and then 
builds the system:
@begin[example, rightmargin -7]
host# @b(make  world  SRCDIR=[SOURCE_DIR])
@end[example]
This command takes a while to complete.
@end(enumerate)

@section[Testing the DES Library]

Use the @i[verify] command to test the DES library
implementation:
@begin[example]
host# @b([OBJ_DIR]/lib/des/verify)
@end[example]
The command should display the following:
@begin[example, rightmargin -10]
Examples per FIPS publication 81, keys ivs and cipher
in hex.  These are the correct answers, see below for
the actual answers.

Examples per Davies and Price.

EXAMPLE ECB     key = 08192a3b4c5d6e7f
        clear = 0
        cipher = 25 dd ac 3e 96 17 64 67
ACTUAL ECB
        clear ""
        cipher  = (low to high bytes)
                25 dd ac 3e 96 17 64 67 

EXAMPLE ECB     key = 0123456789abcdef
        clear = "Now is the time for all "
        cipher = 3f a4 0e 8a 98 4d 48 15 ...
ACTUAL ECB
        clear "Now is the time for all "
        cipher  = (low to high bytes)
                3f a4 0e 8a 98 4d 48 15 

EXAMPLE CBC     key = 0123456789abcdef  iv = 1234567890abcdef
        clear = "Now is the time for all "
        cipher =        e5 c7 cd de 87 2b f2 7c
                        43 e9 34 00 8c 38 9c 0f
                        68 37 88 49 9a 7c 05 f6
ACTUAL CBC
        clear "Now is the time for all "
        ciphertext = (low to high bytes)
                e5 c7 cd de 87 2b f2 7c 
                43 e9 34 00 8c 38 9c 0f 
                68 37 88 49 9a 7c 05 f6 
                00 00 00 00 00 00 00 00 
                00 00 00 00 00 00 00 00 
                00 00 00 00 00 00 00 00 
                00 00 00 00 00 00 00 00 
                00 00 00 00 00 00 00 00 
        decrypted clear_text = "Now is the time for all "
EXAMPLE CBC checksum    key =  0123456789abcdef iv =  1234567890abcdef
        clear =         "7654321 Now is the time for "
        checksum        58 d2 e7 7e 86 06 27 33  or some part thereof
ACTUAL CBC checksum
                encrypted cksum = (low to high bytes)
                58 d2 e7 7e 86 06 27 33
@end[example]

If the @i[verify] command fails to display this information as specified
above, the implementation of DES for your hardware needs to
be adjusted.
Your Kerberos system cannot work properly if your DES library
fails this test.

When you have finished building the software,
you will find the executables in the object tree as follows:
@begin[description]
@b([OBJ_DIR]/admin)@\@i[ext_srvtab], @i[kdb_destroy],
@i[kdb_edit], @i[kdb_init], @i[kdb_util], and @i[kstash].

@b([OBJ_DIR]/kuser)@\@i[kdestroy], @i[kinit], and @i[klist].

@b([OBJ_DIR]/server)@\@i[kerberos].
@end[description]

The contents of [OBJ_DIR]/appl depend upon whether or not
you have licenses for the BSD and NFS utilities.

@chapter[Installing the Software]

To install the software, issue the @i[make install] command from
the [OBJ_DIR].
Programs can either be installed in default directories, or under
a given root directory, as described below.

@section[The ``Standard'' Places]

If you use the @i[make] command as follows:
@begin[example]
host# @b(make  install  SRCDIR=[SOURCE_DIR])
@end[example]
the installation process will try to install the various parts of the
system in ``standard'' directories.
This process creates the ``standard'' directories as needed.

The standard installation process copies things as follows:
@begin[itemize]
The Kerberos server @i[kerberos] gets copied to the @i[/usr/athena]
directory.

The @i[include] files @i[krb.h], and @i[des.h] get copied to the
@i[/usr/include] directory.

The Kerberos libraries @i[libdes.a] and @i[libkrb.a] get copied
to the @i[/usr/athena/lib] directory.

The Kerberos master database utilities @i[kdb_init], @i[kdb_destroy],
@i[kdb_edit], @i[kdb_util], @i[kstash], and @i[ext_srvtab]
get copied to the @i[/usr/etc] directory.

The Kerberos user utilities @i[kinit], @i[kdestroy], and @i[klist] get
copied to the @i[/usr/athena] directory.

The Kerberos manual pages get installed in the appropriate
@i[/usr/man] directories.  Don't forget to run @i[makewhatis]
after installing the manual pages.

@end[itemize]

@section[``Non-Standard'' Installation]

If you'd rather install the software in a different location,
you can use the @i[make] command as follows,
where [DEST_DIR] specifies an alternate destination directory
which will root the installed sources.
@begin[example]
host# @b(make  install  SRCDIR=[SRC_DIR]  DESTDIR=[DEST_DIR])
@end[example]

@chapter[Conclusion]

Now that you have built and installed your Kerberos system,
use the accompanying @u[Kerberos Operation Notes]
to create a Kerberos Master database, install authenticated services,
and start the Kerberos server.

@chapter [Acknowledgements]

We'd like to thank Henry Mensch and Jon Rochlis for helping us debug
this document.
