;;; gnuplot-eldoc.el -- Eldoc documentation strings for gnuplot-mode -*- lexical-binding: t -*-
;;; Automatically generated by doc2texi.el on Sun, 01 June 2025

;;;; This file is generated automatically from the Gnuplot
;;;; documentation by `doc2texi.el', part of the Gnuplot distribution.
;;;; It is not intended to be edited manually.  See docs/gnuplot.doc
;;;; in the gnuplot source tree (available from
;;;; gnuplot.sourcefourge.net) for the original.

;; This file is covered by the Gnuplot licensing terms:

;; Copyright 1986 - 1993, 1998, 2004   Thomas Williams, Colin Kelley
;;
;; Permission to use, copy, and distribute this software and its
;; documentation for any purpose with or without fee is hereby granted,
;; provided that the above copyright notice appear in all copies and
;; that both that copyright notice and this permission notice appear
;; in supporting documentation.
;;
;; Permission to modify the software is granted, but not the right to
;; distribute the complete modified source code.  Modifications are to
;; be distributed as patches to the released version.  Permission to
;; distribute binaries produced by compiling modified sources is granted,
;; provided you
;;   1. distribute the corresponding source modifications from the
;;    released version in the form of a patch file along with the binaries,
;;   2. add special version identification to distinguish your version
;;    in addition to the base release version number,
;;   3. provide your name and address as the primary contact for the
;;    support of your modified version, and
;;   4. retain our contact information in regard to use of the base
;;    software.
;; Permission to distribute the released version of the source code along
;; with corresponding source modifications in the form of a patch file is
;; granted with same provisions 2 through 4 for binary distributions.
;;
;; This software is provided "as is" without express or implied warranty
;; to the extent permitted by applicable law.

(eval-when-compile (defvar gnuplot-eldoc-hash nil))
(setq gnuplot-eldoc-hash (let ((tbl (make-hash-table :test 'equal)) (alist '(("x11" "set terminal x11 {<n> | window \"<string>\"} [more ...]" "set terminal x11 {<n> | window \"<string>\"}
                 {title \"<string>\"}
                 {{no}enhanced} {font <fontspec>}
                 {linewidth LW}
                 {{no}persist} {{no}raise} {{no}ctrlq}
                 {{no}replotonresize}
                 {close}
                 {size XX,YY} {position XX,YY}
set terminal x11 {reset}") ("wxt" "set term wxt {<n>} [more ...]" "set term wxt {<n>}
             {size <width>,<height>} {position <x>,<y>}
             {background <rgb_color> | nobackground}
             {{no}enhanced}
             {font <font>} {fontscale <scale>}
             {title \"title\"}
             {linewidth <lw>} {butt|rounded|square}
             {dashlength <dl>}
             {{no}persist}
             {{no}raise}
             {{no}ctrl}
             {close}") ("windows" "set terminal windows {<n>} [more ...]" "set terminal windows {<n>}
                     {color | monochrome}
                     {solid | dashed}
                     {rounded | butt}
                     {enhanced | noenhanced}
                     {font <fontspec>}
                     {fontscale <scale>}
                     {linewidth <scale>}
                     {pointscale <scale>}
                     {background <rgb color>}
                     {title \"Plot Window Title\"}
                     {{size | wsize} <width>,<height>}
                     {position <x>,<y>}
                     {docked {layout <rows>,<cols>} | standalone}
                     {close}") ("tpic" "set terminal tpic <pointsize> <linewidth> <interval>") ("tkcanvas" "set terminal tkcanvas {tcl | perl | perltkx | python | ruby | rexx} [more ...]" "set terminal tkcanvas {tcl | perl | perltkx | python | ruby | rexx}
                      {standalone | input}
                      {interactive}
                      {rounded | butt}
                      {nobackground | background <rgb color>}
                      {{no}rottext}
                      {size <width>,<height>}
                      {{no}enhanced}
                      {externalimages | pixels}") ("tgif" "set terminal tgif {portrait | landscape | default} {<[x,y]>} [more ...]" "set terminal tgif {portrait | landscape | default} {<[x,y]>}
                  {monochrome | color}
                  {{linewidth | lw} <LW>}
                  {solid | dashed}
                  {font \"<fontname>{,<fontsize>}\"}") ("tek40" "set terminal sixeltek {<fontsize>} {mono|color|colors <n>} {size <x>,<y>} [more ...]" "set terminal sixeltek {<fontsize>} {mono|color|colors <n>} {size <x>,<y>}
                      {animate}") ("svg" "set terminal svg {size <x>,<y> {|fixed|dynamic}} [more ...]" "set terminal svg {size <x>,<y> {|fixed|dynamic}}
                 {mouse} {standalone | jsdir <dirname>}
                 {name <plotname>}
                 {font \"<fontname>{,<fontsize>}\"} {{no}enhanced}
                 {fontscale <multiplier>}
                 {rounded|butt|square} {solid|dashed} {linewidth <lw>}
                 {background <rgb_color>}") ("regis" "set terminal regis {4 | 16}\"") ("pstricks" "set terminal pstricks [more ...]" "set terminal pstricks
               {unit | size <XX>{unit},<YY>{unit}}
               {standalone | input}
               {blacktext | colortext | colourtext}
               {linewidth <lw>} {rounded | butt}
               {pointscale <ps>}
               {psarrows | gparrows}
               {background <rgbcolor>}
               {pstricks | pdftricks2}") ("pdf" "set terminal pdf {monochrome|color|colour} [more ...]" "set terminal pdf {monochrome|color|colour}
                 {{no}enhanced}
                 {fname \"<font>\"} {fsize <fontsize>}
                 {font \"<fontname>{,<fontsize>}\"} {fontscale <scale>}
                 {linewidth <lw>} {rounded|butt}
                 {dl <dashlength>}}
                 {size <XX>{unit},<YY>{unit}}") ("dospc" "set terminal dospc [more ...]" "set terminal dospc
    {{no}{enhanced}}
    {fontscale <scale>} {pointsize <scale>} {linewidth <scale}
    {background <rgbcolor>}") ("pbm" "set terminal pbm {<fontsize>} {<mode>} {size <x>,<y>}") ("mif" "set terminal mif {color | colour | monochrome} {polyline | vectors} [more ...]" "set terminal mif {color | colour | monochrome} {polyline | vectors}
                 {help | ?}") ("mp" "set term mp {color | colour | monochrome} [more ...]" "set term mp {color | colour | monochrome}
            {solid | dashed}
            {notex | tex | latex}
            {magnification <magsize>}
            {psnfss | psnfss-version7 | nopsnfss}
            {prologues <value>}
            {a4paper}
            {amstex}
            {\"<fontname> {,<fontsize>}\"} ") ("lua" "set terminal lua <target name> | \"<file name>\" [more ...]" "set terminal lua <target name> | \"<file name>\"
                    {<script_args> ...}
                    {help}") ("latex" "set terminal {latex | emtex} {default | {courier|roman} {<fontsize>}} [more ...]" "set terminal {latex | emtex} {default | {courier|roman} {<fontsize>}}
             {size <XX>{unit}, <YY>{unit}} {rotate | norotate}
             {color | monochrome}") ("imagen" "set terminal imagen {<fontsize>} {portrait | landscape} [more ...]" "set terminal imagen {<fontsize>} {portrait | landscape}
                    {[<horiz>,<vert>]}") ("hppj" "set terminal hppj {FNT5X9 | FNT9X17 | FNT13X25}") ("hpljii" "set terminal hpljii | hpdj {<res>}") ("hpgl" "set terminal hpgl {<number_of_pens>} {eject} {fontscale <scale>}") ("hp500c" "set terminal hp500c {<res>} {<comp>}") ("gpic" "set terminal gpic {<x> <y>}") ("ggi" "set terminal ggi [acceleration <integer>] [[mode] {mode}]") ("png_" "set terminal png  [more ...]" "set terminal png 
       {{no}enhanced}
       {{no}transparent} {{no}interlace}
       {{no}truecolor} {rounded|butt}
       {linewidth <lw>} {dashlength <dl>}
       {tiny | small | medium | large | giant}
       {font \"<face> {,<pointsize>}\"} {fontscale <scale>}
       {size <x>,<y>} {{no}crop}
       {background <rgb_color>}") ("fig" "set terminal fig {monochrome | color} [more ...]" "set terminal fig {monochrome | color}
                 {small | big | size <xsize>{in|cm},<ysize>{in|cm}}
                 {landscape | portrait}
                 {pointsmax <max_points>}
                 {font \"<fontname>{,<fontsize>}\"} {fontsize <size>}
                 {textnormal | {textspecial texthidden textrigid}}
                 {{linewidth|lw} <multiplier>}") ("epson_180dpi" "set terminal dpu414 {small | medium | large} {normal | draft}") ("epson_180dpi" "set terminal nec_cp6 {monochrome | colour | draft}") ("emf" "set terminal emf {color | monochrome} [more ...]" "set terminal emf {color | monochrome}
                 {enhanced {noproportional}}
                 {rounded | butt}
                 {linewidth <LW>} {dashlength <DL>}
                 {size XX,YY} {background <rgb_color>}
                 {font \"<fontname>{,<fontsize>}\"}
                 {fontscale <scale>}") ("eepic" "set terminal eepic {default} {color|monochrome|dashed} [more ...]" "set terminal eepic {default} {color|monochrome|dashed}
                   {rotate} {size XX,YY}
                   {small|tiny|<fontsize>}") ("dumb" "set terminal dumb {size <xchars>,<ychars>} {[no]feed} [more ...]" "set terminal dumb {size <xchars>,<ychars>} {[no]feed}
                  {aspect <htic>{,<vtic>}}
                  {[no]enhanced}
                  {fillchar {solid|\"<char>\"}}
                  {[no]attributes}
                  {mono|ansi|ansi256|ansirgb}") ("svga" "set terminal svga {font \"<fontname>\"} [more ...]" "set terminal svga {font \"<fontname>\"}
                  {{no}enhanced}
                  {background <rgb color>}
                  {linewidth|lw <lw>}
                  {pointscale|ps <scale>}
                  {fontscale|fs <scale>}") ("corel" "set terminal corel {monochrome | color} {\"<font>\" {<fontsize>}} [more ...]" "set terminal corel {monochrome | color} {\"<font>\" {<fontsize>}}
                   {<xsize> <ysize> {<linewidth> }}") ("context" "set term context {default} [more ...]" "set term context {default}
        {defaultsize | size <scale> | size <xsize>{in|cm}, <ysize>{in|cm}}
        {input | standalone}
        {timestamp | notimestamp}
        {noheader | header \"<header>\"}
        {color | colour | monochrome}
        {rounded | mitered | beveled} {round | butt | squared}
        {dashed | solid} {dashlength | dl <dl>}
        {linewidth | lw <lw>}
        {fontscale <fontscale>}
        {mppoints | texpoints}
        {inlineimages | externalimages}
        {defaultfont | font \"{<fontname>}{,<fontsize>}\"}") ("cgm" "set terminal cgm {color | monochrome} {solid | dashed} {{no}rotate} [more ...]" "set terminal cgm {color | monochrome} {solid | dashed} {{no}rotate}
                 {<mode>} {width <plot_width>} {linewidth <line_width>}
                 {font \"<fontname>,<fontsize>\"}
                 {background <rgb_color>}") ("canvas" "set terminal canvas {size <xsize>, <ysize>} {background <rgb_color>} [more ...]" "set terminal canvas {size <xsize>, <ysize>} {background <rgb_color>}
                    {font {<fontname>}{,<fontsize>}} | {fsize <fontsize>}
                    {{no}enhanced} {linewidth <lw>}
                    {rounded | butt | square}
                    {dashlength <dl>}
                    {standalone {mousing} | name '<funcname>'}
                    {jsdir 'URL/for/javascripts'}
                    {title '<some string>'}") ("be" "set terminal be {reset} {<n>}") ("aqua" "set terminal aqua {<n>} {title \"<wintitle>\"} {size <x> <y>} [more ...]" "set terminal aqua {<n>} {title \"<wintitle>\"} {size <x> <y>}
                  {font \"<fontname>{,<fontsize>}\"}
                  {linewidth <lw>}\"}
                  {{no}enhanced} {solid|dashed} {dl <dashlength>}}") ("aifm" "set terminal aifm {color|monochrome} {\"<fontname>\"} {<fontsize>}") ("While" "while (<expr>) { [more ...]" "while (<expr>) {
    <commands>
}") ("warn" "warn \"message\"") ("vfill" "vfill  FILE using x:y:z:radius:(<expression>) [more ...]" "vfill  FILE using x:y:z:radius:(<expression>)
vgfill FILE using x:y:z:radius:(<expression>)") ("vclear" "vclear {$gridname}") ("linetype_" "unset linetype N") ("toggle" "toggle {<plotno> | \"plottitle\" | all}") ("test" "test {terminal | palette}") ("system_" "system \"command string\" [more ...]" "system \"command string\"
! command string
output = system(\"command string\")
show variable GPVAL_SYSTEM") ("stats_(Statistical_Summary)" "stats {<ranges>} 'filename' {matrix | using N{:M}} {name 'prefix'} {{no}output} [more ...]" "stats {<ranges>} 'filename' {matrix | using N{:M}} {name 'prefix'} {{no}output}
stats $voxelgridname {name 'prefix'}") ("voxel-grid" "splot $voxelgridname with {dots|points} {above <threshold>} ... [more ...]" "splot $voxelgridname with {dots|points} {above <threshold>} ...
splot $voxelgridname with isosurface {level <threshold>} ...") ("matrix" "plot 'file' matrix every {<column_incr>} [more ...]" "plot 'file' matrix every {<column_incr>}
                         {:{<row_incr>}
                           {:{<start_column>}
                             {:{<start_row>}
                               {:{<end_column>}
                                 {:<end_row>}}}}}") ("matrix" "sparse matrix=(cols,rows) origin=(x0,y0) dx=<delx> dy=<dely>") ("data-file" "splot '<file_name>' {binary <binary list>} [more ...]" "splot '<file_name>' {binary <binary list>}
                    {{nonuniform|sparse} matrix}
                    {index <index list>}
                    {every <every list>}
                    {using <using list>}") ("splot" "splot {<ranges>} [more ...]" "splot {<ranges>}
      {<iteration>}
      <function> | {{<file name> | <datablock name>} {datafile-modifiers}}
                 | <voxelgridname>
                 | keyentry
      {<title-spec>} {with <style>}
      {, {definitions{,}} <function> ...}") ("show_variables" "show variables      # show variables that do not begin with GPVAL_ [more ...]" "show variables      # show variables that do not begin with GPVAL_
show variables all  # show all variables including those beginning GPVAL_
show variables NAME # show only variables beginning with NAME") ("show_palette" "show palette [more ...]" "show palette
show palette palette {<ncolors>} {{float | int | hex}}
show palette gradient
show palette rgbformulae
test palette") ("show_functions" "show functions") ("zeroaxis" "set {x|x2|y|y2|z}zeroaxis { {linestyle | ls <line_style>} [more ...]" "set {x|x2|y|y2|z}zeroaxis { {linestyle | ls <line_style>}
                           | {linetype | lt <line_type>}
                             {linewidth | lw <line_width>}
                             {linecolor | lc <colorspec>}
                             {dashtype | dt <dashtype>} }
unset {x|x2|y|y2|z}zeroaxis
show {x|y|z}zeroaxis") ("zero" "set zero <expression> [more ...]" "set zero <expression>
show zero") ("xyplane" "set xyplane at <zvalue> [more ...]" "set xyplane at <zvalue>
set xyplane relative <frac>
set ticslevel <frac>        # equivalent to set xyplane relative
show xyplane") ("xtics_list" "set xtics {add} (\"label1\" <pos1> <level1>, \"label2\" <pos2> <level2>, ...)") ("xtics_series" "set xtics <incr> [more ...]" "set xtics <incr>
set xtics <start>, <incr>, <end>") ("xtics" "set xtics {axis | border} {{no}mirror} [more ...]" "set xtics {axis | border} {{no}mirror}
          {in | out} {scale {default | <major> {,<minor>}}}
          {{no}rotate {by <ang>}} {offset <offset> | nooffset}
          {left | right | center | autojustify}
          {add}
          {  autofreq
           | <incr>
           | <start>, <incr> {,<end>}
           | ({\"<label>\"} <pos> {<level>} {,{\"<label>\"}...) }
          {format \"formatstring\"} {font \"name{,<size>}\"} {{no}enhanced}
          { numeric | timedate | geographic }
          {{no}logscale}
          { rangelimited }
          { textcolor <colorspec> }
unset xtics
show xtics") ("xrange" "set xrange [{{<min>}:{<max>}}] {{no}reverse} {{no}writeback} {{no}extend} [more ...]" "set xrange [{{<min>}:{<max>}}] {{no}reverse} {{no}writeback} {{no}extend}
           | restore
show xrange") ("xmtics" "set xmtics [more ...]" "set xmtics
unset xmtics
show xmtics") ("xlabel" "set xlabel {\"<label>\"} {offset <offset>} {font \"<font>{,<size>}\"} [more ...]" "set xlabel {\"<label>\"} {offset <offset>} {font \"<font>{,<size>}\"}
           {textcolor <colorspec>} {{no}enhanced}
           {rotate by <degrees> | rotate parallel | norotate}
show xlabel") ("xdtics" "set xdtics [more ...]" "set xdtics
unset xdtics
show xdtics") ("xdata" "set xdata {time} [more ...]" "set xdata {time}
show xdata") ("walls" "set walls [more ...]" "set walls
set wall {x0|y0|z0|x1|y1} {<fillstyle>} {fc <fillcolor>}") ("vxrange" "Establishes the range of x coordinates spanned by the active voxel grid. [more ...]" "Establishes the range of x coordinates spanned by the active voxel grid.
Analogous commands `set vyrange` and `set vzrange` exist for the other two
dimensions of the voxel grid.  If no explicit ranges have been set prior to
the first `vclear`, `vfill`, or `voxel(x,y,z) = ` command, vmin and vmax
will be copied from the current values of `xrange`.") ("vrange" "The range of the parametric variables u and v is useful in two contexts. [more ...]" "The range of the parametric variables u and v is useful in two contexts.
1) `splot` in parametric mode. See `set parametric`, `set isosamples`.
2) generating 2-dimension sampled data for either `plot` or `splot` using the
pseudofile \"++\". See `sampling 2D`.") ("projection" "set view projection {xy|xz|yz}") ("view" "set view <rot_x>{,{<rot_z>}{,{<scale>}{,<scale_z>}}} [more ...]" "set view <rot_x>{,{<rot_z>}{,{<scale>}{,<scale_z>}}}
set view map {scale <scale>}
set view projection {xy|xz|yz}
set view {no}equal {xy|xyz}
set view azimuth <angle>
show view") ("vgrid" "set vgrid $gridname {size N} [more ...]" "set vgrid $gridname {size N}
unset vgrid $gridname
show vgrid") ("version" "show version {long}") ("urange" "The range of the parametric variables u and v is useful in two contexts. [more ...]" "The range of the parametric variables u and v is useful in two contexts.
1) `splot` in parametric mode. See `set parametric`, `set isosamples`.
2) generating 2-dimension sampled data for either `plot` or `splot` using the
pseudofile \"++\". See `sampling 2D`.") ("trange" "The range of the parametric variable t is useful in three contexts.") ("title_" "set title {\"<title-text>\"} {offset <offset>} {font \"<font>{,<size>}\"} [more ...]" "set title {\"<title-text>\"} {offset <offset>} {font \"<font>{,<size>}\"}
          {{textcolor | tc} {<colorspec> | default}} {{no}enhanced}
show title") ("timefmt" "set timefmt \"<format string>\" [more ...]" "set timefmt \"<format string>\"
show timefmt") ("timestamp" "set timestamp {\"<format>\"} {top|bottom} {{no}rotate} [more ...]" "set timestamp {\"<format>\"} {top|bottom} {{no}rotate}
              {offset <xoff>{,<yoff>}} {font \"<fontspec>\"}
              {textcolor <colorspec>}
unset timestamp
show timestamp") ("tics" "set tics {axis | border} {{no}mirror} [more ...]" "set tics {axis | border} {{no}mirror}
         {in | out} {front | back}
         {{no}rotate {by <ang>}} {offset <offset> | nooffset}
         {left | right | center | autojustify}
         {format \"formatstring\"} {font \"name{,<size>}\"} {{no}enhanced}
         { textcolor <colorspec> }
set tics scale {default | <major> {,<minor>}}
unset tics
show tics") ("terminal" "set terminal {<terminal-type> | push | pop} [more ...]" "set terminal {<terminal-type> | push | pop}
show terminal") ("table" "set table {\"outfile\" | $datablock} {append} [more ...]" "set table {\"outfile\" | $datablock} {append}
          {separator {whitespace|tab|comma|\"<char>\"}}
plot <whatever>
unset table") ("surface_" "set surface {implicit|explicit} [more ...]" "set surface {implicit|explicit}
unset surface
show surface") ("set_style_watchpoint" "set style watchpoint nolabels [more ...]" "set style watchpoint nolabels
set style watchpoint labels {label-options}") ("set_style_textbox" "set style textbox {<boxstyle-index>} [more ...]" "set style textbox {<boxstyle-index>}
          {opaque|transparent} {fillcolor <color>}
          {{no}border {linecolor <colorspec>}}{linewidth <lw>}
          {margins <xmargin>,<ymargin>}") ("set_style_spiderplot" "set style spiderplot [more ...]" "set style spiderplot
          {fillstyle <fillstyle-properties>}
          {<line-properties> | <point-properties>}") ("set_style_parallelaxis" "set style parallelaxis {front|back} {line-properties}") ("set_style_ellipse" "set style ellipse {units xx|xy|yy} [more ...]" "set style ellipse {units xx|xy|yy}
                  {size {graph|screen} <a>, {{graph|screen} <b>}}
                  {angle <angle>}
                  {clip|noclip}") ("set_style_rectangle" "set style rectangle {front|back} {lw|linewidth <lw>} [more ...]" "set style rectangle {front|back} {lw|linewidth <lw>}
                    {fillcolor <colorspec>} {fs <fillstyle>}") ("set_style_circle" "set style circle {radius {graph|screen} <R>} [more ...]" "set style circle {radius {graph|screen} <R>}
                 {{no}wedge}
                 {clip|noclip}") ("set_style_line" "set style line <index> default [more ...]" "set style line <index> default
set style line <index> {{linetype  | lt} <line_type> | <colorspec>}
                       {{linecolor | lc} <colorspec>}
                       {{linewidth | lw} <line_width>}
                       {{pointtype | pt} <point_type>}
                       {{pointsize | ps} <point_size>}
                       {{pointinterval | pi} <interval>}
                       {{pointnumber | pn} <max_symbols>}
                       {{dashtype | dt} <dashtype>}
                       {palette}
unset style line
show style line") ("set_style_function" "set style function <plotting-style> [more ...]" "set style function <plotting-style>
show style function") ("set_style_fill" "set style fill {empty [more ...]" "set style fill {empty
                | {transparent} solid {<density>}
                | {transparent} pattern {<n>}}
               {border {lt} {lc <colorspec>} | noborder}") ("set_style_data" "set style data <plotting-style> [more ...]" "set style data <plotting-style>
show style data") ("boxplot_" "set style boxplot {range <r> | fraction <f>} [more ...]" "set style boxplot {range <r> | fraction <f>}
                  {{no}outliers} {pointtype <p>}
                  {candlesticks | financebars}
                  {medianlinewidth <width>}
                  {separation <x>}
                  {labels off | auto | x | x2}
                  {sorted | unsorted}") ("set_style_arrow" "set style arrow <index> default [more ...]" "set style arrow <index> default
set style arrow <index> {nohead | head | backhead | heads}
                        {size <length>,<angle>{,<backangle>} {fixed}}
                        {filled | empty | nofilled | noborder}
                        {front | back}
                        { {linestyle | ls <line_style>}
                          | {linetype | lt <line_type>}
                            {linewidth | lw <line_width}
                            {linecolor | lc <colorspec>}
                            {dashtype | dt <dashtype>} }
unset style arrow
show style arrow") ("style" "set style arrow <n> <arrowstyle> [more ...]" "set style arrow <n> <arrowstyle>
set style boxplot <boxplot style options>
set style circle radius <size> {clip|noclip}
set style ellipse size <size> units {xy|xx|yy} {clip|noclip}
set style fill <fillstyle>
set style histogram <histogram style options>
set style line <n> <linestyle>
set style rectangle <object options> <linestyle> <fillstyle>
set style textbox {<n>} {opaque|transparent} {{no}border} {fillcolor}
set style watchpoint labels <label options>") ("style" "set style function <style> [more ...]" "set style function <style>
set style data <style>
show style function
show style data") ("size" "set size {{no}square | ratio <r> | noratio} {<xscale>,<yscale>} [more ...]" "set size {{no}square | ratio <r> | noratio} {<xscale>,<yscale>}
show size") ("samples" "set samples <samples_1> {,<samples_2>} [more ...]" "set samples <samples_1> {,<samples_2>}
show samples") ("rgbmax" "set rgbmax {1.0 | 255} [more ...]" "set rgbmax {1.0 | 255}
unset rgbmax") ("print_" "set print [more ...]" "set print
set print \"-\"
set print \"<filename>\" [append]
set print \"|<shell_command>\"
set print $datablock [append]") ("polar_grid" "set polar grid {<theta_segments>, <radial_segments>} [more ...]" "set polar grid {<theta_segments>, <radial_segments>}
               { qnorm {<power>} | gauss | cauchy | exp | box | hann }
               { kdensity } { scale <scale> }
               {theta [min:max]} {r [min:max]}") ("polar" "set polar [more ...]" "set polar
set polar grid <grid options>
unset polar
show polar") ("pointsize" "set pointsize <multiplier> [more ...]" "set pointsize <multiplier>
show pointsize") ("clipping" "set pm3d {clip | clip1in | clip4in} [more ...]" "set pm3d {clip | clip1in | clip4in}
set pm3d {no}clipcb") ("lighting" "set pm3d lighting {primary <frac>} {specular <frac>} {spec2 <frac>} [more ...]" "set pm3d lighting {primary <frac>} {specular <frac>} {spec2 <frac>}
set pm3d spotlight {rgb <color>} {rot_x <angle>} {rot_z <angle>}
                   {Phong <value>} {default}") ("pixmap_from_colormap" "set pixmap <index> colormap <name>") ("pixmap" "set pixmap <index> {\"filename\" | colormap <name>} [more ...]" "set pixmap <index> {\"filename\" | colormap <name>}
           at <position>
           {width <w> | height <h> | size <w>,<h>}
           {front|back|behind} {center}
show pixmaps
unset pixmaps
unset pixmap <index>") ("paxis" "set paxis <axisno> {range <range-options> | tics <tic-options>} [more ...]" "set paxis <axisno> {range <range-options> | tics <tic-options>}
set paxis <axisno> label <label-options> { offset <radial-offset> }
show paxis <axisno> {range | tics}") ("parametric_" "set parametric [more ...]" "set parametric
unset parametric
show parametric") ("defined" "set palette  defined { ( <gray1> <color1> {, <grayN> <colorN>}... ) }") ("palette__" "set palette [more ...]" "set palette
set palette {
           { gray | color }
           { gamma <gamma> }
           {   rgbformulae <r>,<g>,<b>
             | defined { ( <gray1> <color1> {, <grayN> <colorN>}... ) }
             | file '<filename>' {datafile-modifiers}
             | colormap <colormap-name> 
             | functions <R>,<G>,<B>
           }
           { cubehelix {start <val>} {cycles <val>} {saturation <val>} }
           { viridis }
           { model { RGB | CMY | HSV {start <radians>} } }
           { positive | negative }
           { nops_allcF | ps_allcF }
           { maxcolors <maxcolors> }
         }") ("overflow" "set overflow {float | NaN | undefined} [more ...]" "set overflow {float | NaN | undefined}
unset overflow") ("output" "set output {\"<filename>\"} [more ...]" "set output {\"<filename>\"}
unset output
show output") ("origin" "set origin <x-origin>,<y-origin>") ("offsets" "set offsets <left>, <right>, <top>, <bottom> [more ...]" "set offsets <left>, <right>, <top>, <bottom>
unset offsets
show offsets") ("polygon" "set object <index> polygon [more ...]" "set object <index> polygon
    from <position> to <position> ... {to <position>}") ("circle" "set object <index> circle {at|center} <position> size <radius> [more ...]" "set object <index> circle {at|center} <position> size <radius>
    {arc [<begin>:<end>]} {no{wedge}}
    {<other-object-properties>}") ("ellipse" "set object <index> ellipse {at|center} <position> size <w>,<h> [more ...]" "set object <index> ellipse {at|center} <position> size <w>,<h>
    {angle <orientation>} {units xy|xx|yy}
    {<other-object-properties>}") ("rectangle" "set object <index> rectangle [more ...]" "set object <index> rectangle
    {from <position> {to|rto} <position> |
     center <position> size <w>,<h> |
     at <position> size <w>,<h>}") ("object" "set object <index> [more ...]" "set object <index>
    <object-type> <object-properties>
    {front|back|behind|depthorder}
    {clip|noclip}
    {fc|fillcolor <colorspec>} {fs <fillstyle>}
    {default} {lw|linewidth <width>} {dt|dashtype <dashtype>}
unset object <index>") ("nonlinear" "set nonlinear <axis> via f(axis) inverse g(axis) [more ...]" "set nonlinear <axis> via f(axis) inverse g(axis)
unset nonlinear <axis>") ("mxtics_time" "set mxtics time <N> {seconds|minutes|hours|days|weeks|months|years}") ("mxtics" "set mxtics <freq> [more ...]" "set mxtics <freq>
set mxtics default
set mxtics time <N> <units>
unset mxtics
show mxtics") ("multiplot" "set multiplot [more ...]" "set multiplot
    { title <page title> {font <fontspec>} {enhanced|noenhanced} }
    { layout <rows>,<cols>
      {rowsfirst|columnsfirst} {downwards|upwards}
      {scale <xscale>{,<yscale>}} {offset <xoff>{,<yoff>}}
      {margins <left>,<right>,<bottom>,<top>}
      {spacing <xspacing>{,<yspacing>}}
    }
set multiplot {next|previous}
unset multiplot") ("mouseformat" "set mouse mouseformat i [more ...]" "set mouse mouseformat i
set mouse mouseformat \"custom format\"
set mouse mouseformat function string_valued_function(x, y)") ("mouse" "set mouse {doubleclick <ms>} {nodoubleclick} [more ...]" "set mouse {doubleclick <ms>} {nodoubleclick}
          {{no}zoomcoordinates}
          {zoomfactors <xmultiplier>, <ymultiplier>}
          {noruler | ruler {at x,y}}
          {polardistance{deg|tan} | nopolardistance}
          {format <string>}
          {mouseformat <int> | <string> | function <f(x,y)>}
          {{no}labels {\"labeloptions\"}}
          {{no}zoomjump} {{no}verbose}
unset mouse") ("monochrome" "set monochrome {linetype N <linetype properties>}") ("margin" "set lmargin {{at screen} <margin>} [more ...]" "set lmargin {{at screen} <margin>}
set rmargin {{at screen} <margin>}
set tmargin {{at screen} <margin>}
set bmargin {{at screen} <margin>}
set margins <left>, <right>, <bottom>, <top>
show margin") ("mapping" "set mapping {cartesian | spherical | cylindrical}") ("logscale" "set logscale <axes> {<base>} [more ...]" "set logscale <axes> {<base>}
unset logscale <axes>
show logscale") ("locale" "set locale {\"<locale>\"}") ("loadpath" "set loadpath {\"pathlist1\" {\"pathlist2\"...}} [more ...]" "set loadpath {\"pathlist1\" {\"pathlist2\"...}}
show loadpath") ("link" "set link {x2 | y2} {via <expression1> inverse <expression2>} [more ...]" "set link {x2 | y2} {via <expression1> inverse <expression2>}
unset link") ("label" "set label {<tag>} {\"<label text>\"} {at <position>} [more ...]" "set label {<tag>} {\"<label text>\"} {at <position>}
          {left | center | right}
          {norotate | rotate {by <degrees>}}
          {font \"<name>{,<size>}\"}
          {noenhanced}
          {front | back}
          {textcolor <colorspec>}
          {point <pointstyle> | nopoint}
          {offset <offset>}
          {nobox} {boxed {bs <boxstyle>}}
          {hypertext}
unset label {<tag>}
show label") ("jitter" "set jitter {overlap <yposition>} {spread <factor>} {wrap <limit>} [more ...]" "set jitter {overlap <yposition>} {spread <factor>} {wrap <limit>}
           {swarm|square|vertical}") ("isotropic" "set isotropic [more ...]" "set isotropic
unset isotropic") ("isosurface_" "set isosurface {mixed|triangles} [more ...]" "set isosurface {mixed|triangles}
set isosurface {no}insidecolor <n>") ("isosamples" "set isosamples <iso_1> {,<iso_2>} [more ...]" "set isosamples <iso_1> {,<iso_2>}
show isosamples") ("history_" "set history {size <N>} {quiet|numbers} {full|trim} {default}") ("hidden3d" "set hidden3d {defaults} | [more ...]" "set hidden3d {defaults} |
             { {front|back}
               {{offset <offset>} | {nooffset}}
               {trianglepattern <bitpattern>}
               {{undefined <level>} | {noundefined}}
               {{no}altdiagonal}
               {{no}bentover} }
unset hidden3d
show hidden3d") ("grid" "set grid {{no}{m}xtics} {{no}{m}ytics} {{no}{m}ztics} [more ...]" "set grid {{no}{m}xtics} {{no}{m}ytics} {{no}{m}ztics}
         {{no}{m}x2tics} {{no}{m}y2tics} {{no}{m}rtics}
         {{no}{m}cbtics}
         {polar {<angle>}}
         {layerdefault | front | back}
         {{no}vertical}
         {<line-properties-major> {, <line-properties-minor>}}
unset grid
show grid") ("format__" "set format {<axes>} {\"<format-string>\"} {numeric|timedate|geographic} [more ...]" "set format {<axes>} {\"<format-string>\"} {numeric|timedate|geographic}
show format") ("fontpath" "set fontpath \"/directory/where/my/fonts/live\" [more ...]" "set fontpath \"/directory/where/my/fonts/live\"
set term postscript fontfile <filename>") ("fit_" "set fit {nolog | logfile {\"<filename>\"|default}} [more ...]" "set fit {nolog | logfile {\"<filename>\"|default}}
        {{no}quiet|results|brief|verbose}
        {{no}errorvariables}
        {{no}covariancevariables}
        {{no}errorscaling}
        {{no}prescale}
        {maxiter <value>|default}
        {limit <epsilon>|default}
        {limit_abs <epsilon_abs>}
        {start-lambda <value>|default}
        {lambda-factor <value>|default}
        {script {\"<command>\"|default}}
        {v4 | v5}
unset fit
show fit") ("errorbars" "set errorbars {small | large | fullwidth | <size>} {front | back} [more ...]" "set errorbars {small | large | fullwidth | <size>} {front | back}
              {line-properties}
unset errorbars
show errorbars") ("encoding" "set encoding {<value>} [more ...]" "set encoding {<value>}
set encoding locale
show encoding") ("dummy" "set dummy {<dummy-var>} {,<dummy-var>} [more ...]" "set dummy {<dummy-var>} {,<dummy-var>}
show dummy") ("dgrid3d" "set dgrid3d {<rows>} {,{<cols>}} splines [more ...]" "set dgrid3d {<rows>} {,{<cols>}} splines
set dgrid3d {<rows>} {,{<cols>}} qnorm {<norm>}
set dgrid3d {<rows>} {,{<cols>}} {gauss | cauchy | exp | box | hann}
                {kdensity} {<dx>} {,<dy>}
unset dgrid3d
show dgrid3d") ("decimalsign" "set decimalsign {<value> | locale {\"<locale>\"}} [more ...]" "set decimalsign {<value> | locale {\"<locale>\"}}
unset decimalsign
show decimalsign") ("set_datafile_binary" "set datafile binary <binary list> [more ...]" "set datafile binary <binary list>
show datafile binary
show datafile
unset datafile") ("set_datafile_commentschars" "set datafile commentschars {\"<string>\"} [more ...]" "set datafile commentschars {\"<string>\"}
show datafile commentschars
unset commentschars") ("set_datafile_separator" "set datafile separator {whitespace | tab | comma | \"<chars>\"}") ("set_datafile_missing" "set datafile missing \"<string>\" [more ...]" "set datafile missing \"<string>\"
set datafile missing NaN
show datafile missing
unset datafile") ("contourfill_" "set contourfill auto N          # split zrange evenly into N slices [more ...]" "set contourfill auto N          # split zrange evenly into N slices
set contourfill ztics           # slice at each z axis major tick
set contourfill cbtics          # slice at each cb axis major tick
set contourfill {palette | firstlinetype N}") ("contour" "set contour {base | surface | both} [more ...]" "set contour {base | surface | both}
unset contour
show contour") ("cntrparam" "set cntrparam { { linear [more ...]" "set cntrparam { { linear
                | cubicspline
                | bspline
                | points <n>
                | order <n>
                | levels { <n>
                           | auto {<n>}
                           | discrete <z1> {,<z2>{,<z3>...}}
                           | incremental <start>, <incr> {,<end>}
                         }
                  {{un}sorted}
                  {firstlinetype N}
                }
              }
show contour") ("cntrlabel" "set cntrlabel {format \"format\"} {font \"font\"} [more ...]" "set cntrlabel {format \"format\"} {font \"font\"}
set cntrlabel {start <int>} {interval <int>}
set cntrlabel onecolor") ("clip" "set clip {points|one|two|radial} [more ...]" "set clip {points|one|two|radial}
unset clip {points|one|two|radial}
show clip") ("colorsequence" "set colorsequence {default|classic|podo}") ("colormap" "set colormap new <colormap-name> [more ...]" "set colormap new <colormap-name>
set colormap <colormap-name> range [<min>:<max>]
show colormaps") ("boxwidth" "set boxwidth {<width>} {absolute|relative} [more ...]" "set boxwidth {<width>} {absolute|relative}
show boxwidth") ("border" "set border {<integer>} [more ...]" "set border {<integer>}
           {front | back | behind}
           {linestyle | ls <line_style>}
           {linetype | lt <line_type>} {linewidth | lw <line_width>}
           {linecolor | lc <colorspec>} {dashtype | dt <dashtype>}
           {polar}
unset border
show border") ("autoscale" "set autoscale {<axis>{|min|max|fixmin|fixmax|fix} | fix | keepfix} [more ...]" "set autoscale {<axis>{|min|max|fixmin|fixmax|fix} | fix | keepfix}
set autoscale noextend
unset autoscale {<axis>}
show autoscale") ("arrow" "set arrow {<tag>} from <position> to <position> [more ...]" "set arrow {<tag>} from <position> to <position>
set arrow {<tag>} from <position> rto <position>
set arrow {<tag>} from <position> length <coord> angle <ang>
set arrow <tag> arrowstyle | as <arrow_style>
set arrow <tag> {nohead | head | backhead | heads}
                {size <headlength>,<headangle>{,<backangle>}} {fixed}
                {filled | empty | nofilled | noborder}
                {front | back}
                {linestyle | ls <line_style>}
                {linetype | lt <line_type>}
                {linewidth | lw <line_width>}
                {linecolor | lc <colorspec>}
                {dashtype | dt <dashtype>}") ("angles" "set angles {degrees | radians} [more ...]" "set angles {degrees | radians}
show angles") ("save" "save  {functions | variables | terminal | set | fit | datablocks} [more ...]" "save  {functions | variables | terminal | set | fit | datablocks}
      '<filename>' {append}") ("return" "return <expression>") ("raise" "raise {plot_window_id} [more ...]" "raise {plot_window_id}
lower {plot_window_id}") ("print" "print <expression> {, <expression>, ...}") ("with" "with <style> { {linestyle | ls <line_style>} [more ...]" "with <style> { {linestyle | ls <line_style>}
               | {{linetype  | lt <line_type>}
                  {linewidth | lw <line_width>}
                  {linecolor | lc <colorspec>}
                  {pointtype | pt <point_type>}
                  {pointsize | ps <point_size>}
                  {arrowstyle | as <arrowstyle_index>}
                  {fill | fs <fillstyle>} {fillcolor | fc <colorspec>}
                  {nohidden3d} {nocontours} {nosurface}
                  {palette}}
             }") ("title" "title <text> | notitle [<ignored text>] [more ...]" "title <text> | notitle [<ignored text>]
title columnheader | title columnheader(N)
      {at {beginning|end}} {{no}enhanced}") ("for_loops_in_plot_command" "plot for [<variable> = <start> : <end> {:<increment>}] [more ...]" "plot for [<variable> = <start> : <end> {:<increment>}]
plot for [<variable> in \"string of words\"]") ("ranges" "[{<dummy-var>=}{{<min>}:{<max>}}] [more ...]" "[{<dummy-var>=}{{<min>}:{<max>}}]
[{{<min>}:{<max>}}]") ("using" "plot 'file' using <entry> {:<entry> {:<entry> ...}} {'format'}") ("smooth" "smooth {unique | frequency | fnormal | cumulative | cnormal [more ...]" "smooth {unique | frequency | fnormal | cumulative | cnormal
       | csplines | acsplines | mcsplines  bezier | sbezier
       | path
       | kdensity {bandwidth} {period}
       | unwrap}") ("index" "plot 'file' index { <m>{:<n>{:<p>}} | \"<name>\" }") ("filters" "plot 'DATA' using <XCOL> {:<YCOL>} bins{=<NBINS>} [more ...]" "plot 'DATA' using <XCOL> {:<YCOL>} bins{=<NBINS>}
     {binrange [<LOW>:<HIGH>]} {binwidth=<width>}
     {binvalue={sum|avg}}") ("every" "plot 'file' every {<point_incr>} [more ...]" "plot 'file' every {<point_incr>}
                    {:{<block_incr>}
                      {:{<start_point>}
                        {:{<start_block>}
                          {:{<end_point>}
                            {:<end_block>}}}}}") ("csv_files" "set datafile separator {whitespace | tab | comma | \"chars\"}") ("data" "plot '<file_name>' {binary <binary list>} [more ...]" "plot '<file_name>' {binary <binary list>}
                   {{nonuniform|sparse} matrix}
                   {index <index list> | index \"<name>\"}
                   {every <every list>}
                   {skip <number-of-lines>}
                   {using <using list>}
                   {convexhull} {concavehull}
                   {smooth <option>}
                   {bins <options>}
                   {mask}
                   {volatile} {zsort} {noautoscale}") ("general" "plot '<file_name>' {binary <binary list>} ... [more ...]" "plot '<file_name>' {binary <binary list>} ...
splot '<file_name>' {binary <binary list>} ...") ("plot" "plot {<ranges>} <plot-element> {, <plot-element>, <plot-element>}") ("pause" "pause <time> {\"<string>\"} [more ...]" "pause <time> {\"<string>\"}
pause mouse {<endcondition>}{, <endcondition>} {\"<string>\"}
pause mouse close") ("local" "local foo = <expression> [more ...]" "local foo = <expression>
local array foo[size]") ("load" "load \"<input-file>\" [more ...]" "load \"<input-file>\"
load $datablock") ("import" "import func(x[,y,z,...]) from \"sharedobj[:symbol]\"") ("if" "if (<condition>) { <commands>; [more ...]" "if (<condition>) { <commands>;
       <commands>
       <commands>
} else if (<condition>) {
       <commands>
} else {
       <commands>
}") ("fit" "fit {<ranges>} <expression> [more ...]" "fit {<ranges>} <expression>
    '<datafile>' {datafile-modifiers}
    {{unitweights} | {y|xy|z}error | errors <var1>{,<var2>,...}}
    via '<parameter file>' | <var1>{,<var2>,...}") ("Do" "do for <iteration-spec> { [more ...]" "do for <iteration-spec> {
     <commands>
     <commands>
}") ("cd" "cd '<directory-name>'") ("Zerrorfill" "splot DATA using 1:2:3:4[:5] with zerrorfill {fc|fillcolor <colorspec>} [more ...]" "splot DATA using 1:2:3:4[:5] with zerrorfill {fc|fillcolor <colorspec>}
           {lt|linetype <n>} {<line properties>}") ("sectors" "plot DATA {using specifier} {units xy | units xx | units yy}") ("parallelaxes" "set style data parallelaxes [more ...]" "set style data parallelaxes
plot $DATA using col1{:varcol1} {at <xpos>} {<line properties}, \\
     $DATA using col2, ...") ("hsteps" "plot <data> with hsteps [more ...]" "plot <data> with hsteps
                    {forward|backward}
                    {baseline|pillars|link|nolink}
                    {{above|below} y=<baseline>}
                    {offset <y-offset>}") ("newhistogram" "newhistogram {\"<title>\" {font \"name,size\"} {tc <colorspec>}} [more ...]" "newhistogram {\"<title>\" {font \"name,size\"} {tc <colorspec>}}
             {lt <linetype>} {fs <fillstyle>} {at <x-coord>}") ("ellipses" "plot <data> with ellipses {units [xx|xy|yy]}") ("contourfill" "splot f(x,y) with contourfill {at base} {fillstyle <style>}") ("Watchpoints_" "plot FOO watch {x|y|z|F(x,y)} = <value> [more ...]" "plot FOO watch {x|y|z|F(x,y)} = <value>
plot FOO watch mouse") ("bind" "bind {allwindows} [<key-sequence>] [\"<gnuplot commands>\"] [more ...]" "bind {allwindows} [<key-sequence>] [\"<gnuplot commands>\"]
bind <key-sequence> \"\"
reset bind") ("dashtype" "dashtype N          # predefined dashtype invoked by number [more ...]" "dashtype N          # predefined dashtype invoked by number
dashtype \"pattern\"  # string containing a combination of the characters
                    # dot (.) hyphen (-) underscore(_) and space.
dashtype (s1,e1,s2,e2,s3,e3,s4,e4)  # dash pattern specified by 1 to 4
                    # numerical pairs <solid length>, <emptyspace length>") ("colorspec" "... {linecolor | lc} {\"colorname\" | <colorspec> | <n>} [more ...]" "... {linecolor | lc} {\"colorname\" | <colorspec> | <n>}
... {textcolor | tc} {<colorspec> | {linetype | lt} <n>}
... {fillcolor | fc} {<colorspec> | linetype <n> | linestyle <n>}") ("Time_functions" "time = weekdate_cdc( year, week [, day] )") ("Time_functions" "time = weekdate_iso( year, week [, day] )")))) (while alist (puthash (caar alist) (cdar alist) tbl) (setq alist (cdr alist))) tbl))
(provide 'gnuplot-eldoc)
;;; gnuplot-eldoc.el ends here
