#!/usr/bin/env python
#
# This allows running the matplotlib tests from the command line: e.g.
#
#   $ python tests.py -v -d
#
# The arguments are identical to the arguments accepted by pytest.
#
# See http://doc.pytest.org/ for a detailed description of these options.

import sys
import argparse


if __name__ == '__main__':
    try:
        from matplotlib import test
    except ImportError:
        print('matplotlib.test could not be imported.\n\n'
              'Try a virtual env and `pip install -e .`')
        sys.exit(-1)

    parser = argparse.ArgumentParser(add_help=False)
    parser.add_argument('--recursionlimit', type=int, default=None,
                        help='Specify recursionlimit for test run')
    args, extra_args = parser.parse_known_args()

    print('Python byte-compilation optimization level:', sys.flags.optimize)

    if args.recursionlimit is not None:  # Will trigger deprecation.
        retcode = test(argv=extra_args, recursionlimit=args.recursionlimit)
    else:
        retcode = test(argv=extra_args)
    sys.exit(retcode)
