# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.settings import settings
from azure.mgmt.core import AsyncARMPipelineClient
from azure.mgmt.core.policies import AsyncARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from .. import models as _models
from .._utils.serialization import Deserializer, Serializer
from ._configuration import ComputeManagementClientConfiguration
from .operations import (
    AvailabilitySetsOperations,
    CapacityReservationGroupsOperations,
    CapacityReservationsOperations,
    CloudServiceOperatingSystemsOperations,
    CloudServiceRoleInstancesOperations,
    CloudServiceRolesOperations,
    CloudServicesOperations,
    CloudServicesUpdateDomainOperations,
    CommunityGalleriesOperations,
    CommunityGalleryImageVersionsOperations,
    CommunityGalleryImagesOperations,
    DedicatedHostGroupsOperations,
    DedicatedHostsOperations,
    DiskAccessesOperations,
    DiskEncryptionSetsOperations,
    DiskRestorePointOperations,
    DisksOperations,
    GalleriesOperations,
    GalleryApplicationVersionsOperations,
    GalleryApplicationsOperations,
    GalleryImageVersionsOperations,
    GalleryImagesOperations,
    GalleryInVMAccessControlProfileVersionsOperations,
    GalleryInVMAccessControlProfilesOperations,
    GalleryScriptVersionsOperations,
    GalleryScriptsOperations,
    GallerySharingProfileOperations,
    ImagesOperations,
    LogAnalyticsOperations,
    Operations,
    ProximityPlacementGroupsOperations,
    ResourceSkusOperations,
    RestorePointCollectionsOperations,
    RestorePointsOperations,
    SharedGalleriesOperations,
    SharedGalleryImageVersionsOperations,
    SharedGalleryImagesOperations,
    SnapshotsOperations,
    SoftDeletedResourceOperations,
    SshPublicKeysOperations,
    UsageOperations,
    VirtualMachineExtensionImagesOperations,
    VirtualMachineExtensionsOperations,
    VirtualMachineImagesEdgeZoneOperations,
    VirtualMachineImagesOperations,
    VirtualMachineRunCommandsOperations,
    VirtualMachineScaleSetExtensionsOperations,
    VirtualMachineScaleSetRollingUpgradesOperations,
    VirtualMachineScaleSetVMExtensionsOperations,
    VirtualMachineScaleSetVMRunCommandsOperations,
    VirtualMachineScaleSetVMsOperations,
    VirtualMachineScaleSetsOperations,
    VirtualMachineSizesOperations,
    VirtualMachinesOperations,
)

if TYPE_CHECKING:
    from azure.core import AzureClouds
    from azure.core.credentials_async import AsyncTokenCredential


class ComputeManagementClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Compute Client.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.compute.aio.operations.Operations
    :ivar availability_sets: AvailabilitySetsOperations operations
    :vartype availability_sets: azure.mgmt.compute.aio.operations.AvailabilitySetsOperations
    :ivar capacity_reservation_groups: CapacityReservationGroupsOperations operations
    :vartype capacity_reservation_groups:
     azure.mgmt.compute.aio.operations.CapacityReservationGroupsOperations
    :ivar dedicated_host_groups: DedicatedHostGroupsOperations operations
    :vartype dedicated_host_groups: azure.mgmt.compute.aio.operations.DedicatedHostGroupsOperations
    :ivar images: ImagesOperations operations
    :vartype images: azure.mgmt.compute.aio.operations.ImagesOperations
    :ivar virtual_machine_images_edge_zone: VirtualMachineImagesEdgeZoneOperations operations
    :vartype virtual_machine_images_edge_zone:
     azure.mgmt.compute.aio.operations.VirtualMachineImagesEdgeZoneOperations
    :ivar virtual_machine_images: VirtualMachineImagesOperations operations
    :vartype virtual_machine_images:
     azure.mgmt.compute.aio.operations.VirtualMachineImagesOperations
    :ivar log_analytics: LogAnalyticsOperations operations
    :vartype log_analytics: azure.mgmt.compute.aio.operations.LogAnalyticsOperations
    :ivar virtual_machine_extension_images: VirtualMachineExtensionImagesOperations operations
    :vartype virtual_machine_extension_images:
     azure.mgmt.compute.aio.operations.VirtualMachineExtensionImagesOperations
    :ivar virtual_machine_run_commands: VirtualMachineRunCommandsOperations operations
    :vartype virtual_machine_run_commands:
     azure.mgmt.compute.aio.operations.VirtualMachineRunCommandsOperations
    :ivar usage: UsageOperations operations
    :vartype usage: azure.mgmt.compute.aio.operations.UsageOperations
    :ivar virtual_machine_scale_sets: VirtualMachineScaleSetsOperations operations
    :vartype virtual_machine_scale_sets:
     azure.mgmt.compute.aio.operations.VirtualMachineScaleSetsOperations
    :ivar virtual_machines: VirtualMachinesOperations operations
    :vartype virtual_machines: azure.mgmt.compute.aio.operations.VirtualMachinesOperations
    :ivar virtual_machine_sizes: VirtualMachineSizesOperations operations
    :vartype virtual_machine_sizes: azure.mgmt.compute.aio.operations.VirtualMachineSizesOperations
    :ivar proximity_placement_groups: ProximityPlacementGroupsOperations operations
    :vartype proximity_placement_groups:
     azure.mgmt.compute.aio.operations.ProximityPlacementGroupsOperations
    :ivar restore_point_collections: RestorePointCollectionsOperations operations
    :vartype restore_point_collections:
     azure.mgmt.compute.aio.operations.RestorePointCollectionsOperations
    :ivar ssh_public_keys: SshPublicKeysOperations operations
    :vartype ssh_public_keys: azure.mgmt.compute.aio.operations.SshPublicKeysOperations
    :ivar capacity_reservations: CapacityReservationsOperations operations
    :vartype capacity_reservations:
     azure.mgmt.compute.aio.operations.CapacityReservationsOperations
    :ivar dedicated_hosts: DedicatedHostsOperations operations
    :vartype dedicated_hosts: azure.mgmt.compute.aio.operations.DedicatedHostsOperations
    :ivar restore_points: RestorePointsOperations operations
    :vartype restore_points: azure.mgmt.compute.aio.operations.RestorePointsOperations
    :ivar virtual_machine_scale_set_rolling_upgrades:
     VirtualMachineScaleSetRollingUpgradesOperations operations
    :vartype virtual_machine_scale_set_rolling_upgrades:
     azure.mgmt.compute.aio.operations.VirtualMachineScaleSetRollingUpgradesOperations
    :ivar virtual_machine_scale_set_extensions: VirtualMachineScaleSetExtensionsOperations
     operations
    :vartype virtual_machine_scale_set_extensions:
     azure.mgmt.compute.aio.operations.VirtualMachineScaleSetExtensionsOperations
    :ivar virtual_machine_scale_set_vms: VirtualMachineScaleSetVMsOperations operations
    :vartype virtual_machine_scale_set_vms:
     azure.mgmt.compute.aio.operations.VirtualMachineScaleSetVMsOperations
    :ivar virtual_machine_scale_set_vm_extensions: VirtualMachineScaleSetVMExtensionsOperations
     operations
    :vartype virtual_machine_scale_set_vm_extensions:
     azure.mgmt.compute.aio.operations.VirtualMachineScaleSetVMExtensionsOperations
    :ivar virtual_machine_scale_set_vm_run_commands: VirtualMachineScaleSetVMRunCommandsOperations
     operations
    :vartype virtual_machine_scale_set_vm_run_commands:
     azure.mgmt.compute.aio.operations.VirtualMachineScaleSetVMRunCommandsOperations
    :ivar virtual_machine_extensions: VirtualMachineExtensionsOperations operations
    :vartype virtual_machine_extensions:
     azure.mgmt.compute.aio.operations.VirtualMachineExtensionsOperations
    :ivar disk_accesses: DiskAccessesOperations operations
    :vartype disk_accesses: azure.mgmt.compute.aio.operations.DiskAccessesOperations
    :ivar disk_encryption_sets: DiskEncryptionSetsOperations operations
    :vartype disk_encryption_sets: azure.mgmt.compute.aio.operations.DiskEncryptionSetsOperations
    :ivar disks: DisksOperations operations
    :vartype disks: azure.mgmt.compute.aio.operations.DisksOperations
    :ivar snapshots: SnapshotsOperations operations
    :vartype snapshots: azure.mgmt.compute.aio.operations.SnapshotsOperations
    :ivar disk_restore_point: DiskRestorePointOperations operations
    :vartype disk_restore_point: azure.mgmt.compute.aio.operations.DiskRestorePointOperations
    :ivar resource_skus: ResourceSkusOperations operations
    :vartype resource_skus: azure.mgmt.compute.aio.operations.ResourceSkusOperations
    :ivar galleries: GalleriesOperations operations
    :vartype galleries: azure.mgmt.compute.aio.operations.GalleriesOperations
    :ivar community_galleries: CommunityGalleriesOperations operations
    :vartype community_galleries: azure.mgmt.compute.aio.operations.CommunityGalleriesOperations
    :ivar community_gallery_images: CommunityGalleryImagesOperations operations
    :vartype community_gallery_images:
     azure.mgmt.compute.aio.operations.CommunityGalleryImagesOperations
    :ivar community_gallery_image_versions: CommunityGalleryImageVersionsOperations operations
    :vartype community_gallery_image_versions:
     azure.mgmt.compute.aio.operations.CommunityGalleryImageVersionsOperations
    :ivar shared_galleries: SharedGalleriesOperations operations
    :vartype shared_galleries: azure.mgmt.compute.aio.operations.SharedGalleriesOperations
    :ivar shared_gallery_images: SharedGalleryImagesOperations operations
    :vartype shared_gallery_images: azure.mgmt.compute.aio.operations.SharedGalleryImagesOperations
    :ivar shared_gallery_image_versions: SharedGalleryImageVersionsOperations operations
    :vartype shared_gallery_image_versions:
     azure.mgmt.compute.aio.operations.SharedGalleryImageVersionsOperations
    :ivar gallery_applications: GalleryApplicationsOperations operations
    :vartype gallery_applications: azure.mgmt.compute.aio.operations.GalleryApplicationsOperations
    :ivar gallery_application_versions: GalleryApplicationVersionsOperations operations
    :vartype gallery_application_versions:
     azure.mgmt.compute.aio.operations.GalleryApplicationVersionsOperations
    :ivar gallery_images: GalleryImagesOperations operations
    :vartype gallery_images: azure.mgmt.compute.aio.operations.GalleryImagesOperations
    :ivar gallery_image_versions: GalleryImageVersionsOperations operations
    :vartype gallery_image_versions:
     azure.mgmt.compute.aio.operations.GalleryImageVersionsOperations
    :ivar gallery_in_vm_access_control_profiles: GalleryInVMAccessControlProfilesOperations
     operations
    :vartype gallery_in_vm_access_control_profiles:
     azure.mgmt.compute.aio.operations.GalleryInVMAccessControlProfilesOperations
    :ivar gallery_in_vm_access_control_profile_versions:
     GalleryInVMAccessControlProfileVersionsOperations operations
    :vartype gallery_in_vm_access_control_profile_versions:
     azure.mgmt.compute.aio.operations.GalleryInVMAccessControlProfileVersionsOperations
    :ivar gallery_scripts: GalleryScriptsOperations operations
    :vartype gallery_scripts: azure.mgmt.compute.aio.operations.GalleryScriptsOperations
    :ivar gallery_script_versions: GalleryScriptVersionsOperations operations
    :vartype gallery_script_versions:
     azure.mgmt.compute.aio.operations.GalleryScriptVersionsOperations
    :ivar gallery_sharing_profile: GallerySharingProfileOperations operations
    :vartype gallery_sharing_profile:
     azure.mgmt.compute.aio.operations.GallerySharingProfileOperations
    :ivar soft_deleted_resource: SoftDeletedResourceOperations operations
    :vartype soft_deleted_resource: azure.mgmt.compute.aio.operations.SoftDeletedResourceOperations
    :ivar cloud_service_role_instances: CloudServiceRoleInstancesOperations operations
    :vartype cloud_service_role_instances:
     azure.mgmt.compute.aio.operations.CloudServiceRoleInstancesOperations
    :ivar cloud_service_roles: CloudServiceRolesOperations operations
    :vartype cloud_service_roles: azure.mgmt.compute.aio.operations.CloudServiceRolesOperations
    :ivar cloud_services: CloudServicesOperations operations
    :vartype cloud_services: azure.mgmt.compute.aio.operations.CloudServicesOperations
    :ivar cloud_services_update_domain: CloudServicesUpdateDomainOperations operations
    :vartype cloud_services_update_domain:
     azure.mgmt.compute.aio.operations.CloudServicesUpdateDomainOperations
    :ivar cloud_service_operating_systems: CloudServiceOperatingSystemsOperations operations
    :vartype cloud_service_operating_systems:
     azure.mgmt.compute.aio.operations.CloudServiceOperatingSystemsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is None.
    :type base_url: str
    :keyword cloud_setting: The cloud setting for which to get the ARM endpoint. Default value is
     None.
    :paramtype cloud_setting: ~azure.core.AzureClouds
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        *,
        cloud_setting: Optional["AzureClouds"] = None,
        **kwargs: Any
    ) -> None:
        _cloud = cloud_setting or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = ComputeManagementClientConfiguration(
            credential=credential,
            subscription_id=subscription_id,
            cloud_setting=cloud_setting,
            credential_scopes=credential_scopes,
            **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                AsyncARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(
            base_url=cast(str, base_url), policies=_policies, **kwargs
        )

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.availability_sets = AvailabilitySetsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.capacity_reservation_groups = CapacityReservationGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.dedicated_host_groups = DedicatedHostGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.images = ImagesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machine_images_edge_zone = VirtualMachineImagesEdgeZoneOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_machine_images = VirtualMachineImagesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.log_analytics = LogAnalyticsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machine_extension_images = VirtualMachineExtensionImagesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_machine_run_commands = VirtualMachineRunCommandsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.usage = UsageOperations(self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machine_scale_sets = VirtualMachineScaleSetsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_machines = VirtualMachinesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_machine_sizes = VirtualMachineSizesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.proximity_placement_groups = ProximityPlacementGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.restore_point_collections = RestorePointCollectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.ssh_public_keys = SshPublicKeysOperations(self._client, self._config, self._serialize, self._deserialize)
        self.capacity_reservations = CapacityReservationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.dedicated_hosts = DedicatedHostsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.restore_points = RestorePointsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machine_scale_set_rolling_upgrades = VirtualMachineScaleSetRollingUpgradesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_machine_scale_set_extensions = VirtualMachineScaleSetExtensionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_machine_scale_set_vms = VirtualMachineScaleSetVMsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_machine_scale_set_vm_extensions = VirtualMachineScaleSetVMExtensionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_machine_scale_set_vm_run_commands = VirtualMachineScaleSetVMRunCommandsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_machine_extensions = VirtualMachineExtensionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.disk_accesses = DiskAccessesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.disk_encryption_sets = DiskEncryptionSetsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.disks = DisksOperations(self._client, self._config, self._serialize, self._deserialize)
        self.snapshots = SnapshotsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.disk_restore_point = DiskRestorePointOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.resource_skus = ResourceSkusOperations(self._client, self._config, self._serialize, self._deserialize)
        self.galleries = GalleriesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.community_galleries = CommunityGalleriesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.community_gallery_images = CommunityGalleryImagesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.community_gallery_image_versions = CommunityGalleryImageVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.shared_galleries = SharedGalleriesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.shared_gallery_images = SharedGalleryImagesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.shared_gallery_image_versions = SharedGalleryImageVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.gallery_applications = GalleryApplicationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.gallery_application_versions = GalleryApplicationVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.gallery_images = GalleryImagesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.gallery_image_versions = GalleryImageVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.gallery_in_vm_access_control_profiles = GalleryInVMAccessControlProfilesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.gallery_in_vm_access_control_profile_versions = GalleryInVMAccessControlProfileVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.gallery_scripts = GalleryScriptsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.gallery_script_versions = GalleryScriptVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.gallery_sharing_profile = GallerySharingProfileOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.soft_deleted_resource = SoftDeletedResourceOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.cloud_service_role_instances = CloudServiceRoleInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.cloud_service_roles = CloudServiceRolesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.cloud_services = CloudServicesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.cloud_services_update_domain = CloudServicesUpdateDomainOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.cloud_service_operating_systems = CloudServiceOperatingSystemsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(
        self, request: HttpRequest, *, stream: bool = False, **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> Self:
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
