/*
This software module was originally developed by
Toshiyuki Nomura (NEC Corporation)
and edited by

in the course of development of the
MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.
This software module is an implementation of a part of one or more
MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio
standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards
free license to this software module or modifications thereof for use in
hardware or software products claiming conformance to the MPEG-2 NBC/
MPEG-4 Audio  standards. Those intending to use this software module in
hardware or software products are advised that this use may infringe
existing patents. The original developer of this software module and
his/her company, the subsequent editors and their companies, and ISO/IEC
have no liability for use of this software module or modifications
thereof in an implementation. Copyright is not released for non
MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer
retains full right to use the code for his/her  own purpose, assign or
donate the code to a third party and to inhibit third party from using
the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.
This copyright notice must be included in all copies or derivative works.
Copyright (c)1996.
*/
/*
 *	MPEG-4 Audio Verification Model (LPC-ABS Core)
 *	
 *	Excitation Other Subroutines
 *
 *	Ver1.0	96.12.16	T.Nomura(NEC)
 */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "nec_exc_proto.h"
#include "nec_abs_const.h"

static void nec_poly_phase( float FIL[], long D, long I );

void nec_lpc2par( float a[], float rc[], long m )
{
   int		j, mr, k;
   float	*tmp_fa, *b, d;

   if((tmp_fa = (float *)calloc (m, sizeof(float)))==NULL) {
      printf("\n Memory allocation error in nec_lpc2par \n");
      exit(1);
   }
   if((b = (float *)calloc (m, sizeof(float)))==NULL) {
      printf("\n Memory allocation error in nec_lpc2par \n");
      exit(1);
   }

   for (j = 0; j < m; j++) tmp_fa[j] = a[j];

   for (mr = m - 1; mr >= 0; mr--) {
      d = 1.0 - tmp_fa[mr] * tmp_fa[mr];
      rc[mr] = tmp_fa[mr];
      for (k = 0; k <= mr; k++)
	 b[k] = tmp_fa[k];
      for (k = 0; k < mr; k++)
	 tmp_fa[k] = (b[k] - b[mr] * b[mr - k - 1]) / d;
   }

   free( tmp_fa );
   free( b );
}

void nec_zero_filt(
		   float	x[], 		/* input */
		   float	y[], 		/* output */
		   float	alpha[],	/* input */
		   float	g_den[],	/* input */
		   float	g_num[],	/* input */
		   long		order,		/* configuration input */
		   long		len )		/* configuration input */
{
   long		i;
   float	*syn, *zero1, *zero2;

   if((syn = (float *)calloc (len, sizeof(float)))==NULL) {
      printf("\n Memory allocation error in zero_filt \n");
      exit(1);
   }
   if((zero1 = (float *)calloc (order, sizeof(float)))==NULL) {
      printf("\n Memory allocation error in zero_filt \n");
      exit(1);
   }
   if((zero2 = (float *)calloc (order, sizeof(float)))==NULL) {
      printf("\n Memory allocation error in zero_filt \n");
      exit(1);
   }

   for ( i = 0; i < order; i++ ) zero1[i] = 0.0;
   nec_syn_filt(x, alpha, zero1, syn, order, len);
   for ( i = 0; i < order; i++ ) zero1[i] = zero2[i] = 0.0;
   nec_pw_filt(y, syn, order, g_den, g_num, zero1, zero2, len);

   free( syn );
   free( zero1 );
   free( zero2 );
}

void nec_pw_imprs(
		  float	y[],		/* output */
		  float	a[],		/* input */
		  long	m,		/* configuration input */
		  float	g_den[],	/* input */
		  float	g_num[],	/* input */
		  long n )		/* configuration input */
{
   long		i;
   float	*in;

   if((in = (float *)calloc (n, sizeof(float)))==NULL) {
      printf("\n Memory allocation error in imprs2 \n");
      exit(1);
   }

   for ( i = 0; i < n; i++ ) in[i] = 0.0;
   in[0] = 1.0;
   nec_zero_filt( in, y, a, g_den, g_num, m, n );
   free( in );
}

void nec_comb_filt(
		   float	exc[],		/* input */
		   float	comb_exc[],	/* output */
		   long		len_sf,		/* configuration input */
		   long		I_part,		/* input */
		   long		flag )		/* input */
{
   long		k, sample, kk;
   float	dum_dbl;
   static float	comb_ga[4] = { 0.0, 0.0, 0.6, 0.8 };

   if ( I_part == 0 ) {
      for (sample = 0; sample < len_sf; sample++) {
	 comb_exc[sample] = exc[sample];
      }
   }
   else {
      for (sample = 0; sample < len_sf; sample++) {
	 if ( sample - I_part >= 0 ) dum_dbl = comb_exc[sample - I_part];
	 else			     dum_dbl = 0.0;
	 dum_dbl = exc[sample] + comb_ga[flag] * dum_dbl;
	 comb_exc[sample] = dum_dbl;
      }
   }
}

void nec_syn_filt(
		  float	di[],	/* input */
		  float	a[],	/* input */
		  float	pm[],	/* input/output */
		  float	xr[],	/* output */
		  long	np,	/* configuration input */
		  long	n )	/* configuration input */
{
   long		i,j;
   float	s;

   for (j=0; j < n; j++) {
      s = (float)0.0;
      for (i=0; i < np; i++)
	 s = s - a[i] * pm[i];
      xr[j] = di[j] + s;
      for (i=2; i < np+1; i++)
	 pm[np-i+1] = pm[np-i];
      pm[0] = xr[j];
   }
}

void nec_pw_filt(
		 float		y[],	/* output */
		 float		x[],	/* input */
		 long		m,	/* configuration input */
		 float		gd[],	/* input */
		 float		gn[],	/* input */
		 float		pmem1[],/* input/output */
		 float		pmem2[],/* input/output */
		 long		n )	/* configuration input */
{
   long		i, j;
   float	s, s2;

   for (j = 0; j < n; j++) {
      s = x[j];
      /* calculation of numerator */
      for (i = 0; i < m; i++) {
         s = s + gn[i] * pmem1[i];
      }
      s2 = s;
      /* calculation of denominator */
      for (i = 0; i < m; i++) {
         s2 = s2 - gd[i] * pmem2[i];
      }
      y[j] = s2;
      for (i = 2; i < m+1; i++) {
	 pmem1[m-i+1] = pmem1[m-i];
	 pmem2[m-i+1] = pmem2[m-i];
      }
      pmem1[0] = x[j];
      pmem2[0] = y[j];
   }
}

long nec_acb_generation(long idx, long len_sf, float mem_ac[],
			       float exci[], float exco[],
			       float ga, long type )
{
   long		i, k, kk, sample;
   long		F_part, I_part, F_part0, I_part0;
   float	dum_dbl;
   static long	flag_cl = 0;
   static long	idx2lag_int[1<<NEC_ACB_BIT], idx2lag_frac[1<<NEC_ACB_BIT];
   static float	P_FILm[NEC_PITCH_RSLTN*(NEC_PITCH_IFTAP+1)+1];

   /*--- INITIALIZATION ---*/
   if (flag_cl == 0) {
      flag_cl = 1;
      for (i = 0; i <= 161; i++) {
	 idx2lag_int[i] = 17 + 2 * i / NEC_PITCH_RSLTN;
	 idx2lag_frac[i] = (2 * i) % NEC_PITCH_RSLTN;
      }
      for (i = 162; i <= 199; i++) {
	 idx2lag_int[i] = 71 + 3 * (i - 162) / NEC_PITCH_RSLTN;
	 idx2lag_frac[i] = (3 * (i - 162)) % NEC_PITCH_RSLTN;
      }
      for (i = 200; i <= 254; i++) {
	 idx2lag_int[i] = 90 + (i - 200);
	 idx2lag_frac[i] = 0;
      }
      idx2lag_int[255] = 0;
      idx2lag_frac[255] = 0;

      nec_poly_phase(P_FILm, NEC_PITCH_RSLTN, NEC_PITCH_IFTAP);
   }

   /*--- EXCITATION GENERATION ---*/
   I_part = idx2lag_int[idx];
   F_part = idx2lag_frac[idx];
   if ( idx == 255 ) {
      for (i = 0; i < len_sf; i++) exco[i] = exci[i];
      return I_part;
   }

   F_part0 = 0;
   if ( type == 0 ) {
      for (sample = 0; sample < len_sf; ) {
	 F_part0 += F_part;
	 I_part0 = I_part + (F_part0/NEC_PITCH_RSLTN);
	 F_part0 = F_part0 % NEC_PITCH_RSLTN;
	 for ( i = 0; i < I_part0 && sample < len_sf; i++, sample++ ) {
	    dum_dbl = 0.0;
	    for (k = -NEC_PITCH_IFTAP; k <= NEC_PITCH_IFTAP; k++) {
	       kk = (k+1) * NEC_PITCH_RSLTN - F_part0;
	       dum_dbl += P_FILm[abs(kk)]*mem_ac[NEC_PITCH_MAX+NEC_PITCH_IFTAP+1-(I_part0-i+k+1)];
	    }
	    dum_dbl = exci[sample] + ga * dum_dbl;
	    exco[sample] = dum_dbl;
	    mem_ac[NEC_PITCH_MAX+NEC_PITCH_IFTAP+1+sample] = dum_dbl;
	 }
      }
   } else {
      for (sample = 0; sample < len_sf; sample++) {
	 dum_dbl = 0.0;
	 for (k = -NEC_PITCH_IFTAP; k <= NEC_PITCH_IFTAP; k++) {
	    kk = (k+1) * NEC_PITCH_RSLTN - F_part;
	    dum_dbl += P_FILm[abs(kk)]*mem_ac[NEC_PITCH_MAX+NEC_PITCH_IFTAP+1-(I_part+k+1)+sample];
	 }
	 dum_dbl = exci[sample] + ga * dum_dbl;
	 exco[sample] = dum_dbl;
	 mem_ac[NEC_PITCH_MAX+NEC_PITCH_IFTAP+1+sample] = dum_dbl;
      }
   }
   return I_part;

}

static void nec_poly_phase(
float          FIL[],
long             D,
long             I )
{
   int	k;

   FIL[0] = (float) 1.0;
   for (k = 1; k <= (I + 1) * D; k++) {
      FIL[k] = sin(NEC_PI * k / D) / (NEC_PI * k / D)
	 * (0.54 + 0.46 * cos(2 * NEC_PI * k / (2 * (I + 1) * D)));
   }
}

