/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Naoki Iwakami (NTT)                                                     */
/* and edited by                                                             */
/*   Mikko Suonio (Nokia) on 1997-11-05,                                     */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1997.                                                        */
/*****************************************************************************/

#define  ntt_nok_LT_PRED_MAIN
#include "ntt_conf.h"
#include "all.h"
#include "nok_lt_prediction.h"
#include "ntt_nok_lt_predict_dec.h"

void ntt_nok_lt_pred_dec_init(Info *ntt_info)
{

  int ich, ii;

  /*--- Initialization of Nokia LTP ---*/
  for (ich=0; ich<ntt_N_SUP; ich++){
    ntt_nok_lt_status[ich] =
      (NOK_LT_PRED_STATUS *)malloc(sizeof(*ntt_nok_lt_status[0]));
    nok_init_lt_pred(ntt_nok_lt_status[ich]);
  }
  ntt_info->nsbk = 1;
  ntt_info->bins_per_bk = ntt_N_FR;
  ntt_info->bins_per_sbk[0] = ntt_N_FR;
  ntt_info->sfb_per_bk = ntt_N_CRB;
  ntt_info->sfb_per_sbk[0] = ntt_N_CRB;
  ntt_info->sbk_sfb_top[0] = (short *)malloc(ntt_N_CRB*sizeof(short));
  for (ii=0; ii<ntt_N_CRB; ii++){
    ntt_info->sbk_sfb_top[0][ii] = (short)ntt_crb_tbl[ii];
  }

}
