      SUBROUTINE THERMO (NSP,NHCP,HCP,NEN,ENTH,NCO,IPTD,TEMP,GAS,KFLAG)  
C*********************************************************************** 
C                                                                      * 
C DATE OF LATEST CHANGE: JANUARY 3, '86                                * 
C                                                                      * 
C*********************************************************************** 
C  THERMO COMPUTES THE TEMPERATURE DEPENDENT ENTHALPIES AND HEAT       * 
C  CAPACITIES. FOR KFLAG.GT.0 TEMPERATURE DERIVATIVES OF HEAT          * 
C  CAPACITIES ARE ALSO COMPUTED.                                       * 
C  THE NASA-FITS OF THE THERMODYNAMICAL POLYNOMIALS, WHICH ARE READ    * 
C  AND PREPROCESSED IN SUBBLOCK 'COMPIL', ARE USED.                    * 
C*********************************************************************** 
C                                                                      * 
C  FOR DESCRIPTION OF PARAMETERS SEE SUBROUTINE 'METAS1'.              * 
C                                                                      * 
C*********************************************************************** 
C                                                                        
CI4       INTEGER IPTD(NCO)                                              
      INTEGER*2 IPTD(NCO)                                                
      DOUBLE PRECISION HCP(NHCP),ENTH(NEN)                               
CSP       REAL HCP(NHCP),ENTH(NEN)                                       
      DOUBLE PRECISION A,B,C,GAS,GASD,TEN3,TEMP,TWO,ZERO                 
CSP       REAL A,B,C,GAS,GASD,TEN3,TEMP,TWO,ZERO                         
      INTEGER I,IPO,J,JFLAG,N1,N2,NSP2                                   
C                                                                        
      COMMON / COUNT  / NSTEP,NFCN,NANFA,NTFAC,NFAC,NSOL,NTHERM,NKIP
      SAVE /COUNT/
C                                                                        
      DATA ZERO/0.D0/ , TEN3/1.D3/ , TWO/2.D0/                           
CSP       DATA ZERO/0.E0/ , TEN3/1.E3/ , TWO/2.E0/                       
C                                                                        
      JFLAG=KFLAG                                                        
      KFLAG=0                                                            
      IF(TEMP.LT.ZERO) GOTO 99                                           
      GASD=GAS*TWO                                                       
      NTHERM=NTHERM+1                                                    
      NSP2=NSP+NSP                                                       
C                                                                        
      IF(JFLAG.GT.0) GOTO 10                                             
      DO 3 I=1,NCO                                                       
      IPO=IPTD(I)                                                        
      N1=12*I                                                            
      IF(TEMP.GT.TEN3) N1=N1 - 6                                         
      A=ENTH(N1)                                                         
      B=A                                                                
      DO 2 J=1,4                                                         
      N2=N1-J                                                            
      A=ENTH(N2) + TEMP*A                                                
      IF(N2.GT.N1-5) B=A + TEMP*B                                        
2     CONTINUE                                                           
C  ENTHALPIES                                                            
      HCP(IPO)=(ENTH(N1-5) + TEMP*A) * GAS                               
C  HEAT CAPACITIES                                                       
      HCP(NSP+IPO)=B*GAS                                                 
3     CONTINUE                                                           
      GOTO 20                                                            
C                                                                        
10    DO 13 I=1,NCO                                                      
      IPO=IPTD(I)                                                        
      N1=12*I                                                            
      IF(TEMP.GT.TEN3) N1=N1 - 6                                         
      A=ENTH(N1)                                                         
      B=A                                                                
      C=A                                                                
      DO 12 J=1,4                                                        
      N2=N1-J                                                            
      A=ENTH(N2) + TEMP*A                                                
      IF(N2.GT.N1-5) B=A + TEMP*B                                        
      IF(N2.GT.N1-4) C=B + TEMP*C                                        
12    CONTINUE                                                           
C  ENTHALPIES                                                            
      HCP(IPO)=(ENTH(N1-5) + TEMP*A) * GAS                               
C  HEAT CAPACITIES                                                       
      HCP(NSP+IPO)=B*GAS                                                 
C  TEMP-DERIVATIVES OF HEAT CAPACITIES                                   
      HCP(NSP2+IPO)=C*GASD                                               
13    CONTINUE                                                           
C                                                                        
C  NORMAL RETURN , NO ERROR                                              
C  ------------------------                                              
20    RETURN                                                             
C                                                                        
C  ERROR RETURN (TEMPERATURE NEGATIVE)                                   
C  -----------------------------------                                   
99    KFLAG=-1                                                           
      RETURN                                                             
C                                                                        
C----------------------------------------------------------------------- 
C                END OF SUBROUTINE THERMO                                
C----------------------------------------------------------------------- 
      END  
