/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/


#include "math.h"

#include "kask.h"
#include "kaskcmd.h"
#include "kasktri.h"
#include "kaskass.h"
#include "kasksol.h"

extern void Direct(), MeanValue(), Extrapol(), Iterate(), Refine();


#define NO_OF_F_VALS  4
#define NO_OF_CAU_VALS 2
#define NO_OF_DIR_VALS 1
#define NO_OF_SOL_VALS 3

static REAL	fVals[NO_OF_F_VALS],cauVals[NO_OF_CAU_VALS],
		dirVals[NO_OF_DIR_VALS], solVals[NO_OF_SOL_VALS]; 	

static REAL	*peak=nil;
static char	*peakNames[] = {"peakX","peakY","peakSize"};

 


/*		functions for test problem 1a			*/

static int Tom1aF(x, y,class,fVals)
	REAL x, y;
	int class;
	REAL fVals[];
  {
	REAL a_para, b_para;
   	REAL xm1,xm1x,ym1,ym1y,xma,ymb;
  	REAL sum,divisor;

	fVals[0] =  1.0;		/*	pX	*/
	fVals[1] =  1.0;		/*	pY	*/
	fVals[2] =  0.0;		/*	q	*/

  	a_para = peak[0];
   	b_para = peak[1];
    	xm1  = x-1.0;
    	xm1x = x*xm1;
   	ym1  = y-1.0;
   	ym1y = y*ym1;
   	xma  = x-a_para;
   	ymb  = y-b_para;

   	divisor = exp(peak[2]*(xma*xma + ymb*ymb));
  	sum = 2.0*(xm1x+ym1y);
   	sum = sum - 4.0*peak[2]*(xm1x*ym1y + xm1*xma*ym1y + x*xma*ym1y);
   	sum = sum + 4.0*peak[2]*peak[2]*(xm1x*xma*xma*ym1y + xm1x*ym1y*ymb*ymb);
   	sum = sum - 4.0*peak[2]*(xm1x*ym1*ymb + xm1*x*y*ymb);
	fVals[3] = -sum/divisor;	/*	g	*/

    return true;
  }
 
  
static int Tom1aCauchyF(x, y,class,cauVals)
	REAL x, y;
	int class;
	REAL cauVals[];
  {
	cauVals[0] = 0.0;		/*	Sigma	*/
	cauVals[1] = 0.0;		/*	Xi	*/
     return true;   
  }


static int Tom1aDirichF(x, y,class,dirVals)
	REAL x, y;
	int class;
	REAL dirVals[];
  {
	dirVals[0] = 0.0;
    return true;
  }

static int Tom1aSol(x, y, class, solVals)
	REAL x, y, solVals[];
	int class;
  {
	REAL a_para, b_para;
	REAL xma, ymb, efac;

	a_para = peak[0];
	b_para = peak[1];
	xma  = x-a_para;
	ymb  = y-b_para;

    efac = exp(-peak[2]*(xma*xma + ymb*ymb));
	solVals[0] =  x*(x-1.0)*y*(y-1.0)*efac;  
	solVals[1] = ( (x-1.0)*(y-1.0)*y + x*y*(y-1.0) -
					2.0*peak[2]*(x-1.0)*x*xma*y*(y-1.0) ) * efac;  
	solVals[2] =  ( (x-1.0)*(y-1.0)*x + x*y*(x-1.0) -
					2.0*peak[2]*(x-1.0)*x*ymb*y*(y-1.0) ) * efac; 
    return true;  
  }

/*		functions for test problem 1b			*/

static int Tom1bF(x, y,class,fVals)
	REAL x, y;
	int class;
	REAL fVals[];
  {
 	REAL xm1,xm1x,ym1,ym1y,xp1,yp1,xmxp,ymyp,xp1x,yp1y;
    REAL sum,divisor;

	fVals[0] =  1.0;				/*	pX	*/
	fVals[1] =  1.0;				/*	pY	*/
	fVals[2] =  0.0;				/*	q	*/

    xm1  = x-1.0;
    xp1  = x+1.0;
    xm1x = x*xm1;
    xp1x = x*xp1;
    ym1  = y-1.0;  
    yp1  = y+1.0;
    ym1y = y*ym1;
    yp1y = y*yp1;
    xmxp  = xm1*xp1;
    ymyp  = ym1*yp1;

    divisor = exp(100.0*(x*x + y*y));
    sum = 2.0*(xmxp+ymyp);
    sum = sum - 400.0*(xmxp*ym1y+xm1x*ymyp+xmxp*ymyp+xp1x*ymyp+xmxp*yp1y);
    sum = sum + 40000.0*(xmxp*x*x*ymyp + xmxp*ymyp*y*y);

    fVals[3] = -sum/divisor; 		/*	g	*/

    return true;
  }
 
  
static int Tom1bCauchyF(x, y,class,cauVals)
	REAL x, y;
	int class;
	REAL cauVals[];
  {
	cauVals[0] = 0.0;		/*	Sigma	*/
	cauVals[1] = 0.0;		/*	Xi	*/
     return true;   
  }


static int Tom1bDirichF(x, y,class,dirVals)
	REAL x, y;
	int class;
	REAL dirVals[];
  {
	dirVals[0] = (x+1.0)*(x-1.0)*(y+1.0)*(y-1.0)*exp(-100.0*(x*x + y*y));
    return true;
  }

static int Tom1bSol(x, y, class, solVals)
	REAL x, y, solVals[];
	int class;
  {
	REAL efac;

	efac = exp(-100.0*(x*x + y*y));
	solVals[0] =  (x+1.0)*(x-1.0)*(y+1.0)*(y-1.0)*efac;  
	solVals[1] =  ( (x-1.0)*(y-1.0)*(y+1.0) + (x+1.0)*(y+1.0)*(y-1.0) -
					200.0*(x-1.0)*x*(x+1.0)*(y-1.0)*(y+1.0) )*efac;  
	solVals[2] =  ( (x-1.0)*(x+1.0)*(y-1.0) + (x+1.0)*(x-1.0)*(y+1.0) -
					200.0*(x-1.0)*y*(x+1.0)*(y-1.0)*(y+1.0) )*efac;  
    return true;  
  }

/*		functions for test problem 2			*/

static int Tom2F(x, y,class,fVals)
	REAL x, y;
	int class;
	REAL fVals[];
  {
	fVals[0] =  1.0;		/*	pX	*/
	fVals[1] =  1.0;		/*	pY	*/
	fVals[2] =  100.0;		/*	q	*/
	fVals[3] =  0.0;		/*	g	*/

    return true;
  }
 
  
static int Tom2CauchyF(x, y,class,cauVals)
	REAL x, y;
	int class;
	REAL cauVals[];
  {
	cauVals[0] = 0.0;		/*	Sigma	*/
	cauVals[1] = 0.0;		/*	Xi	*/
     return true;   
  }


static int Tom2DirichF(x, y,class,dirVals)
	REAL x, y;
	int class;
	REAL dirVals[];
  {
	dirVals[0] =  ( cosh(10.0*x) + cosh(10.0*y) ) / ( 2.0*cosh(10.0) );
    return true;
  }

static REAL Tom2Sol(x, y, class, solVals)
	REAL x, y, solVals[];
	int class;
  { 
	solVals[0] = ( cosh(10.0*x) + cosh(10.0*y) ) / ( 2.0*cosh(10.0) );    
	solVals[1] = ( 5.0*sinh(10.0*x) ) / ( cosh(10.0) );    
	solVals[2] = ( 5.0*sinh(10.0*y) ) / ( cosh(10.0) );    
    return true;    
  }
/*		functions for test problem 4			*/

static int Tom4F(x, y,class,fVals)
	REAL x, y;
	int class;
	REAL fVals[];
  {
	REAL phiX, phiY;
	REAL phiXxx, phiYyy;
	REAL coeff;

	fVals[0] =  1.0;		/*	pX	*/
	fVals[1] =  1.0;		/*	pY	*/
	fVals[2] =  0.0;		/*	q	*/

	coeff = 1.0;

	if (x <= 0.4)
		{	phiX   = 1.0;
			phiXxx = 0.0;
		}
	else
		{	if (x>=0.6)
				{	phiX   = 0.0 ; 
					phiXxx = 0.0 ;
				}
			else 
				{	phiX = 513.0 + x*(-5400.0 + x*(22500.0 + x*(-46250 
							  + x*(46875 -18750*x))));
					phiXxx= ((-20.0*18750.0*x + 12*46875)*x - 6*46250)*x + 45000.0;
				}
		}

	if (y <= 0.4)
		{	phiY   = 1.0 ;
			phiYyy = 0.0;
		}
	else
		{	if (y>=0.6)
				{	phiY   = 0.0 ; 
					phiYyy = 0.0;
				}
			else 
				{	phiY = 513.0 + y*(-5400.0 + y*(22500.0 + y*(-46250 
							  + y*(46875 -18750*y))));
					phiYyy= ((-20.0*18750.0*y + 12*46875)*y - 6*46250)*y + 45000.0;
				}
		}

	fVals[3] = - coeff*(phiXxx*phiY + phiX*phiYyy);		/*	g	*/

    return true;
  }
 
  
static int Tom4CauchyF(x, y,class,cauVals)
	REAL x, y;
	int class;
	REAL cauVals[];
  {
	cauVals[0] = 0.0;		/*	Sigma	*/
	cauVals[1] = 0.0;		/*	Xi	*/
     return true;   
  }


static int Tom4DirichF(x, y,class,dirVals)
	REAL x, y;
	int class;
	REAL dirVals[];
  {
	REAL phiX, phiY, coeff, offset;

	coeff  = 1.0;
	offset = 0.0e6;

	if (x <= 0.4)
		 phiX = 1.0 ;
	else
		{	if (x>=0.6) phiX = 0.0; 
			else phiX = 513.0 + x*(-5400.0 + x*(22500.0 + x*(-46250 
							  + x*(46875 -18750*x))));
		}

	if (y <= 0.4)
		 phiY = 1.0;
	else
		{	if (y>=0.6) phiY = 0.0; 
			else phiY = 513.0 + y*(-5400.0 + y*(22500.0 + y*(-46250 
							  + y*(46875 -18750*y))));
		}

	dirVals[0] =  coeff * phiX * phiY + offset;
    return true;
  }

static REAL Tom4Sol(x, y, class, solVals)
	REAL x, y, solVals[];
	int class;
  { 
	REAL phiX, phiY, phiXx, phiYy;


	if (x <= 0.4)
		 { phiX = 1.0, phiXx = 0.0; }
	else
		{	if (x>=0.6) { phiX = 0.0; phiXx = 0.0; }
			else 
				{ phiX = 513.0 + x*(-5400.0 + x*(22500.0 + x*(-46250 
							  + x*(46875 -18750*x))));
				  phiXx =  -5400.0 + x*(45000.0 + x*(-138750 
							  + x*(187500 -93750*x)));
				}
		}

	if (y <= 0.4)
		 { phiY = 1.0; phiYy = 0.0; }
	else
		{	if (y>=0.6) { phiY = 0.0; phiYy = 0.0; }
			else 
				{ phiY = 513.0 + y*(-5400.0 + y*(22500.0 + y*(-46250 
							  + y*(46875 -18750*y))));
				  phiYy =  -5400.0 + y*(45000.0 + y*(-138750 
							  + y*(187500 -93750*y)));
				}
		}

	solVals[0] = phiX * phiY ;    
	solVals[1] = phiXx * phiY ;    
	solVals[2] = phiX * phiYy ; 
   
    return true;    
  }


/*		functions for test problem 5			*/

static int Tom5F(x, y,class,fVals)
	REAL x, y;
	int class;
	REAL fVals[];
  {
	fVals[0] =  1.0;		/*	pX	*/
	fVals[1] =  1.0;		/*	pY	*/
	fVals[2] =  0.0;		/*	q	*/
	fVals[3] =  0.0;		/*	g	*/

    return true;
  }

static int Tom5DirichF(x, y,class,dirVals)
	REAL x, y;
	int class;
	REAL dirVals[];
  {
	REAL x2,x4,y2,y4, p,q;
	x2 = x*x;
	x4 = x2*x2;
	y2 = y*y;
	y4 = y2*y2;
	p  = x4 - 6.0*x2*y2 + y4;
	q  = x4*x4 - 28.0*x4*x2*y2 + 70.0*x4*y4 - 28.0*x2*y2*y4 + y4*y4;

	dirVals[0] =  1.1786 - 0.1801*p + 0.006*q;
    return true;
  }

static REAL Tom5Sol(x, y, class, solVals)
	REAL x, y, solVals[];
	int class;
  { 
	REAL x2,x3,x4,y2,y3,y4, p,q;
	x2 = x*x;
	x3 = x2*x;
	x4 = x2*x2;
	y2 = y*y;
	y3 = y2*y;
	y4 = y2*y2;
	p  = x4 - 6.0*x2*y2 + y4;
	q  = x4*x4 - 28.0*x4*x2*y2 + 70.0*x4*y4 - 28.0*x2*y2*y4 + y4*y4;
	solVals[0] = 1.1786 - 0.1801*p + 0.006*q;    
	solVals[1] =  - 0.1801*(4.*x3 - 12.*x*y2) + 0.006*(8.*x4*x3-168.*x3*x2*y2 
													+ 280.*x3*y4-56.*x*y4*y2);    
	solVals[2] =  - 0.1801*(-12.*x2*y + 4.*y3) + 0.006*(-56.*x3*x3*y-168.*x2*y3*y2 
													+ 280.*x4*y3+8.*y4*y3);    
    return true;    
  }
static int Tom5CauchyF(x, y,class,cauVals)
	REAL x, y;
	int class;
	REAL cauVals[];
  {
	cauVals[0] = 0.0;		/*	Sigma	*/
	cauVals[1] = 0.0;		/*	Xi	*/
     return true;   
  }

/*		functions for test problem 6a			*/

static int Tom6aF(x, y,class,fVals)
	REAL x, y;
	int class;
	REAL fVals[];
  {
	fVals[0]	=  1.0;		/*	pX	*/
	fVals[1]	=  1.0;		/*	pY	*/
	fVals[2]	=  0.0;		/*	q	*/
	fVals[3]	=  0.0;		/*	g	*/
    return true;
  }

static REAL arccos(x)
  REAL x;
  {
	REAL y=(fabs(x)<SMALL)?REALPI2:atan(sqrt(ONE-x*x)/x);
	if (x<=-SMALL) y = REALPI+y;
	return y;
  }

static int Tom6aCauchyF(x, y,class,cauVals)
	REAL x, y;
	int class;
	REAL cauVals[];
  {
	cauVals[0] = 0.0;		/*	Sigma	*/
	cauVals[1] = 0.0;		/*	Xi	*/
     return true;   
  }
 
static int Tom6aDirichF(x, y,class,dirVals)
	REAL x, y;
	int class;
	REAL dirVals[];
  {  
   	REAL r = sqrt(x*x+y*y), phi;
		phi = (r>0)?arccos(x/r):ZERO;
		if (y<ZERO) phi = TWO*REALPI-phi;
		r =pow(r,2.0/3.0);
		dirVals[0]= r*sin(2.0/3.0*phi);

    return true ;
  }

static int Tom6aSol(x, y, class, solVals)
	REAL x, y, solVals[];
	int class;
  {
   	REAL r = sqrt(x*x+y*y), phi;
	REAL dr, dphi, drx, dry, dphix, dphiy, rp1, rp2, r2;

	phi = (r>0)?arccos(x/r):ZERO;
	if (y<ZERO) phi = TWO*REALPI-phi;
	rp1 =pow(r,2.0/3.0);
	rp2 =pow(r,1.0/3.0);
	solVals[0]= rp1*sin(2.0/3.0*phi);

	r2		= r*r;
	dr 		= 2.0/(3.0*rp2)*sin(2.0/3.0*phi);
	dphi	= 2.0/3.0*rp1*cos(2.0/3.0*phi);
	drx		= x/r;
	dry		= y/r;
	dphix	= -y/r2;
	dphiy	= x/r2;
	solVals[1]= dr*drx + dphi*dphix;
	solVals[2]= dr*dry + dphi*dphiy;

    return true;    
  }



/*		functions for test problem 6b			*/

static int Tom6bF(x, y,class,fVals)
	REAL x, y;
	int class;
	REAL fVals[];
  {
	fVals[0]	=  1.0;		/*	pX	*/
	fVals[1]	=  1.0;		/*	pY	*/
	fVals[2]	=  0.0;		/*	q	*/
	fVals[3]	=  0.0;		/*	g	*/
    return true;
  }

static int Tom6bCauchyF(x, y,class,cauVals)
	REAL x, y;
	int class;
	REAL cauVals[];
  {
	cauVals[0] = 0.0;		/*	Sigma	*/
	cauVals[1] = 0.0;		/*	Xi	*/
     return true;   
  }
 
static int Tom6bDirichF(x, y,class,dirVals)
	REAL x, y;
	int class;
	REAL dirVals[];
  {  
   	REAL r = sqrt(x*x+y*y), phi;
	if (class==1 || (class==2))
	 	dirVals[0]=sqrt(sqrt(r));
	else
	   	{
		phi = (r>0)?arccos(x/r):ZERO;
		if (y<ZERO) phi = TWO*REALPI-phi;
		r =sqrt(sqrt(r));
		dirVals[0]= r*sin(QUARTER*phi);
		}

    return true ;
  }

static int Tom6bSol(x, y, class, solVals)
	REAL x, y, solVals[];
	int class;
  {
   	REAL r = sqrt(x*x+y*y), phi;
	REAL dr, dphi, drx, dry, dphix, dphiy, rp1, rp2, r2;

	drx	= x/r;
	dry	= y/r;
	rp1 =pow(r,1.0/4.0);
	rp2 =pow(r,3.0/4.0);

	if ((class==2) || (class==1))
		{
	 	solVals[0]=rp1;

		dr 	= 1.0/(4.0*rp2);
	 	solVals[1]=dr*drx;
	 	solVals[2]=dr*dry;
		}
	else
	   	{
		phi = (r>0)?arccos(x/r):ZERO;
		if (y<ZERO) phi = TWO*REALPI-phi;

		solVals[0]= rp1*sin(QUARTER*phi);

		r2		= r*r;
		dr 		= 1.0/(4.0*rp2)*sin(QUARTER*phi);
		dphi	= QUARTER*rp1*cos(QUARTER*phi);
		dphix	= -y/r2;
		dphiy	= x/r2;
		solVals[1]= dr*drx + dphi*dphix;
		solVals[2]= dr*dry + dphi*dphiy;
		}

    return true;    
  }

/*		functions for test problem 6c			*/

static int Tom6cF(x, y,class,fVals)
	REAL x, y;
	int class;
	REAL fVals[];
  {
	fVals[0]	=  1.0;		/*	pX	*/
	fVals[1]	=  1.0;		/*	pY	*/
	fVals[2]	=  0.0;		/*	q	*/
	fVals[3]	=  0.0;		/*	g	*/
    return true;
  }

static int Tom6cCauchyF(x, y,class,cauVals)
	REAL x, y;
	int class;
	REAL cauVals[];
  {
	cauVals[0] = 0.0;		/*	Sigma	*/
	cauVals[1] = 0.0;		/*	Xi	*/
     return true;   
  }
 
static int Tom6cDirichF(x, y,class,dirVals)
	REAL x, y;
	int class;
	REAL dirVals[];
  {  
   	REAL r = sqrt(x*x+y*y), phi;
	if (class==1)
	 	dirVals[0]=sqrt(sqrt(r));
	else
	   	{
		phi = (r>0)?arccos(x/r):ZERO;
		if (y<ZERO) phi = TWO*REALPI-phi;
		r =sqrt(sqrt(r));
		dirVals[0]= r*sin(QUARTER*phi);
		}

    return true ;
  }

static int Tom6cSol(x, y, class, solVals)
	REAL x, y, solVals[];
	int class;
{
   	REAL r = sqrt(x*x+y*y), phi;
	REAL dr, dphi, drx, dry, dphix, dphiy, rp1, rp2, r2;

	drx	= x/r;
	dry	= y/r;
	rp1 =pow(r,1.0/4.0);
	rp2 =pow(r,3.0/4.0);

	if ((class==2) || (class==1))
		{
	 	solVals[0]=rp1;

		dr 	= 1.0/(4.0*rp2);
	 	solVals[1]=dr*drx;
	 	solVals[2]=dr*dry;
		}
	else
	   	{
		phi = (r>0)?arccos(x/r):ZERO;
		if (y<ZERO) phi = TWO*REALPI-phi;

		solVals[0]= rp1*sin(QUARTER*phi);

		r2		= r*r;
		dr 		= 1.0/(4.0*rp2)*sin(QUARTER*phi);
		dphi	= QUARTER*rp1*cos(QUARTER*phi);
		dphix	= -y/r2;
		dphiy	= x/r2;
		solVals[1]= dr*drx + dphi*dphix;
		solVals[2]= dr*dry + dphi*dphiy;
		}

    return true;    
  }



/*		functions for test problem 7			*/

static int Tom7F(x, y,class,fVals)
	REAL x, y;
	int class;
	REAL fVals[];
  {
	fVals[0] =  1.0;		/*	pX	*/
	fVals[1] =  1.0;		/*	pY	*/
	fVals[2] =  0.0;		/*	q	*/
	fVals[3] =  0.0;		/*	g	*/

    return true;
  }
 
  
static int Tom7CauchyF(x, y,class,cauVals)
	REAL x, y;
	int class;
	REAL cauVals[];
  {
	cauVals[0] = 0.0;		/*	Sigma	*/
	cauVals[1] = 0.0;		/*	Xi	*/
     return true;   
  }


static int Tom7DirichF(x, y,class,dirVals)
	REAL x, y;
	int class;
	REAL dirVals[];
  {
	dirVals[0] =  atan(y/x);
    return true;
  }

static REAL Tom7Sol(x, y, class, solVals)
	REAL x, y, solVals[];
	int class;
  { 
	REAL d;
	d = x*x + y*y;
	solVals[0] =  atan(y/x);    
	solVals[1] =  -y/d;    
	solVals[2] =   x/d;    
    return true;    
  }

/*		functions for test problem 8			*/

static int Tom8F(x, y,class,fVals)
	REAL x, y;
	int class;
	REAL fVals[];
  {
	if (class == 1)
		{	fVals[0] =  1.0;		/*	pX	*/
			fVals[1] =  1.0;		/*	pY	*/
		}
	else
		{	fVals[0] =  100.0;		/*	pX	*/
			fVals[1] =  100.0;		/*	pY	*/
		}

	fVals[2] =  0.0;		/*	q	*/
	fVals[3] =  0.0;		/*	g	*/

    return true;
  }
 
  
static int Tom8CauchyF(x, y,class,cauVals)
	REAL x, y;
	int class;
	REAL cauVals[];
  {
	cauVals[0] = 0.0;		/*	Sigma	*/
	cauVals[1] = 0.0;		/*	Xi	*/
     return true;   
  }


static int Tom8DirichF(x, y,class,dirVals)
	REAL x, y;
	int class;
	REAL dirVals[];
  {
	if (class == 1) 
		dirVals[0] =  y*(3.0*x*x - y*y);    
	else
		dirVals[0] =  y*(3.0*x*x - y*y)/100.0;

    return true;
  }

static REAL Tom8Sol(x, y, class, solVals)
	REAL x, y, solVals[];
	int class;
  { 
	REAL x2=x*x, y2=y*y;

	if (class == 1) 
		{	solVals[0] =  y*(3.0*x2 - y2);    
			solVals[1] =  6.0*x*y;    
			solVals[2] =  3.0*(x2 - y2) ;  
		}  
	else
		{	solVals[0] =  y*(3.0*x2 - y2)/100.0;
			solVals[1] =  6.0*x*y/100.0;
			solVals[2] =  3.0*(x2 - y2)/100.0;
		}
    return true;    
  }

/********************************************************/
/*	Problem-Command: Select a special example	*/
/********************************************************/

int Toms(cmd)
  COMMAND *cmd;
  {
    int index = 0;
	char *tp;

	if (ParsCheck(cmd,0,1)) return false;

	if ((cmd->noOfPars)==1)
	  {
	    tp = (cmd->pars)[1];
		index = CheckName(&tp, cmd->names, nameClass);
	  }
	if (index==-1)
	  {
	    sprintf(globBuf,"Parameter %s of %s not allowed\n",
				(cmd->pars)[1], (cmd->pars)[0]);
	    ZIBStdOut(globBuf);
		return false;
	  }

/*		 Presets for Solve		*/
	if (!CheckPreSets()) return false;
	actSolve->Direct = Direct;
	actSolve->Estimate = MeanValue;
	actSolve->Refine = Refine;
	actSolve->Iterate = Iterate;
	
/*	select a special problem		*/
	switch (index)
	  {
		case 0:				/*	test problem 1a	*/
		  if (peak == nil)
		    {
			peak = (REAL*) NewParamList("tompeak",3,sizeof(REAL),1,peakNames,nil,nil);
			peak[0] = 0.5;
			peak[1] = 0.117;
			peak[2] = 100.0;
		    }
		  actProblem->F			= (PROC)Tom1aF;
		  actProblem->fVals		= fVals;
		  actProblem->noFVals	= NO_OF_F_VALS;
		  actProblem->CauchyF	= (PROC)Tom1aCauchyF;
		  actProblem->cauVals	= cauVals;
		  actProblem->noCauVals	= NO_OF_CAU_VALS;
		  actProblem->DirichF	= (PROC)Tom1aDirichF;	
		  actProblem->dirVals	= dirVals;
		  actProblem->noDirVals	= NO_OF_DIR_VALS;
		  actProblem->Sol		= (PROC)Tom1aSol;	
		  actProblem->solVals	= dirVals;
		  actProblem->noSolVals	= NO_OF_SOL_VALS;
		  actProblem->NumAss	= NumAss;
		  actProblem->class		= ZERO;
		  actProblem->symP 		= SYMMETRIC;
		  break;

		case 1:				/*	test problem 1b	*/
		  actProblem->F			= (PROC)Tom1bF;
		  actProblem->fVals		= fVals;
		  actProblem->noFVals	= NO_OF_F_VALS;
		  actProblem->CauchyF	= (PROC)Tom1bCauchyF;
		  actProblem->cauVals	= cauVals;
		  actProblem->noCauVals	= NO_OF_CAU_VALS;
		  actProblem->DirichF	= (PROC)Tom1bDirichF;	
		  actProblem->dirVals	= dirVals;
		  actProblem->noDirVals	= NO_OF_DIR_VALS;
		  actProblem->Sol		= (PROC)Tom1bSol;	
		  actProblem->solVals	= solVals;
		  actProblem->noSolVals	= NO_OF_SOL_VALS;
		  actProblem->NumAss	= NumAss;
		  actProblem->class		= ZERO;
		  actProblem->symP 		= SYMMETRIC;
		  break;

		case 2:				/*	test problem 2	*/
	  	  actProblem->F			= (PROC)Tom2F;
		  actProblem->fVals		= fVals;
		  actProblem->noFVals	= NO_OF_F_VALS;
		  actProblem->CauchyF	= (PROC)Tom2CauchyF;
		  actProblem->cauVals	= cauVals;
		  actProblem->noCauVals	= NO_OF_CAU_VALS;
		  actProblem->DirichF	= (PROC)Tom2DirichF;
		  actProblem->dirVals	= dirVals;
		  actProblem->noDirVals	= NO_OF_DIR_VALS;	
		  actProblem->Sol		= (PROC)Tom2Sol;	
		  actProblem->solVals	= solVals;
		  actProblem->noSolVals	= NO_OF_SOL_VALS;
		  actProblem->NumAss	= NumAss;
		  actProblem->class		= ZERO;
		  actProblem->symP		= SYMMETRIC;
		  break;

		case 4:				/*	test problem 4	*/
	  	  actProblem->F			= (PROC)Tom4F;
		  actProblem->fVals		= fVals;
		  actProblem->noFVals	= NO_OF_F_VALS;
		  actProblem->CauchyF	= (PROC)Tom4CauchyF;
		  actProblem->cauVals	= cauVals;
		  actProblem->noCauVals	= NO_OF_CAU_VALS;
		  actProblem->DirichF	= (PROC)Tom4DirichF;
		  actProblem->dirVals	= dirVals;
		  actProblem->noDirVals	= NO_OF_DIR_VALS;	
		  actProblem->Sol		= (PROC)Tom4Sol;	
		  actProblem->solVals	= solVals;
		  actProblem->noSolVals	= NO_OF_SOL_VALS;
		  actProblem->NumAss	= NumAss;
		  actProblem->class		= ZERO;
		  actProblem->symP		= SYMMETRIC;
		  break;

		case 5:				/*	test problem 5	*/
	  	  actProblem->F			= (PROC)Tom5F;
		  actProblem->fVals		= fVals;
		  actProblem->noFVals	= NO_OF_F_VALS;
		  actProblem->CauchyF	= (PROC)Tom5CauchyF;
		  actProblem->cauVals	= cauVals;
		  actProblem->noCauVals	= NO_OF_CAU_VALS;
		  actProblem->DirichF	= (PROC)Tom5DirichF;
		  actProblem->dirVals	= dirVals;
		  actProblem->noDirVals	= NO_OF_DIR_VALS;	
		  actProblem->Sol		= (PROC)Tom5Sol;	
		  actProblem->solVals	= solVals;
		  actProblem->noSolVals	= NO_OF_SOL_VALS;
		  actProblem->NumAss	= NumAss;
		  actProblem->class		= ZERO;
		  actProblem->symP		= SYMMETRIC;
		  break;

		case 6:				/*	test problem 6a	*/
	  	  actProblem->F			= (PROC)Tom6aF;
		  actProblem->fVals		= fVals;
		  actProblem->noFVals	= NO_OF_F_VALS;
		  actProblem->CauchyF	= (PROC)Tom6aCauchyF;
		  actProblem->cauVals	= cauVals;
		  actProblem->noCauVals	= NO_OF_CAU_VALS;
		  actProblem->DirichF	= (PROC)Tom6aDirichF;
		  actProblem->dirVals	= dirVals;
		  actProblem->noDirVals	= NO_OF_DIR_VALS;	
		  actProblem->Sol		= (PROC)Tom6aSol;	
		  actProblem->solVals	= solVals;
		  actProblem->noSolVals	= NO_OF_SOL_VALS;
		  actProblem->NumAss	= NumAss;
		  actProblem->class		= ZERO;
		  actProblem->symP		= SYMMETRIC;
		  break;


		case 7:				/*	test problem 6b	*/
	  	  actProblem->F			= (PROC)Tom6bF;
		  actProblem->fVals		= fVals;
		  actProblem->noFVals	= NO_OF_F_VALS;
		  actProblem->CauchyF	= (PROC)Tom6bCauchyF;
		  actProblem->cauVals	= cauVals;
		  actProblem->noCauVals	= NO_OF_CAU_VALS;
		  actProblem->DirichF	= (PROC)Tom6bDirichF;
		  actProblem->dirVals	= dirVals;
		  actProblem->noDirVals	= NO_OF_DIR_VALS;	
		  actProblem->Sol		= (PROC)Tom6bSol;	
		  actProblem->solVals	= solVals;
		  actProblem->noSolVals	= NO_OF_SOL_VALS;
		  actProblem->NumAss	= NumAss;
		  actProblem->class		= ZERO;
		  actProblem->symP		= SYMMETRIC;
		  break;

		case 8:				/*	test problem 7	*/
	  	  actProblem->F			= (PROC)Tom7F;
		  actProblem->fVals		= fVals;
		  actProblem->noFVals	= NO_OF_F_VALS;
		  actProblem->CauchyF	= (PROC)Tom7CauchyF;
		  actProblem->cauVals	= cauVals;
		  actProblem->noCauVals	= NO_OF_CAU_VALS;
		  actProblem->DirichF	= (PROC)Tom7DirichF;
		  actProblem->dirVals	= dirVals;
		  actProblem->noDirVals	= NO_OF_DIR_VALS;	
		  actProblem->Sol		= (PROC)Tom7Sol;	
		  actProblem->solVals	= solVals;
		  actProblem->noSolVals	= NO_OF_SOL_VALS;
		  actProblem->NumAss	= NumAss;
		  actProblem->class		= ZERO;
		  actProblem->symP		= SYMMETRIC;
		  break;

		case 9:				/*	test problem 8	*/
	  	  actProblem->F			= (PROC)Tom8F;
		  actProblem->fVals		= fVals;
		  actProblem->noFVals	= NO_OF_F_VALS;
		  actProblem->CauchyF	= (PROC)Tom8CauchyF;
		  actProblem->cauVals	= cauVals;
		  actProblem->noCauVals	= NO_OF_CAU_VALS;
		  actProblem->DirichF	= (PROC)Tom8DirichF;
		  actProblem->dirVals	= dirVals;
		  actProblem->noDirVals	= NO_OF_DIR_VALS;	
		  actProblem->Sol		= (PROC)Tom8Sol;	
		  actProblem->solVals	= solVals;
		  actProblem->noSolVals	= NO_OF_SOL_VALS;
		  actProblem->NumAss	= NumAss;
		  actProblem->class		= ZERO;
		  actProblem->symP		= SYMMETRIC;
		  break;
		case 10:				/*	test problem 6c	*/
	  	  actProblem->F			= (PROC)Tom6cF;
		  actProblem->fVals		= fVals;
		  actProblem->noFVals	= NO_OF_F_VALS;
		  actProblem->CauchyF	= (PROC)Tom6cCauchyF;
		  actProblem->cauVals	= cauVals;
		  actProblem->noCauVals	= NO_OF_CAU_VALS;
		  actProblem->DirichF	= (PROC)Tom6cDirichF;
		  actProblem->dirVals	= dirVals;
		  actProblem->noDirVals	= NO_OF_DIR_VALS;	
		  actProblem->Sol		= (PROC)Tom6cSol;	
		  actProblem->solVals	= solVals;
		  actProblem->noSolVals	= NO_OF_SOL_VALS;
		  actProblem->NumAss	= NumAss;
		  actProblem->class		= ZERO;
		  actProblem->symP		= SYMMETRIC;
		  break;

	  }

	SetBound(R_SOL);
	InitNumAss(N_STD);

	if ((cmd->noOfPars)==1) actProblem->name = (cmd->names)[index];
	return true;
  }
