/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/


#include <ctype.h>

#include "kask.h"
#include "kasktri.h"
#include "kaskcmd.h"

static int countP, countE, countT;

int TriInf(cmd)
  COMMAND *cmd;
  {
    int i = 0;
	TRIANGULATION *tri = firstTriang;

	if (ParsCheck(cmd,0,0)) return false;
	if (actTriang==nil)
	  {
	    sprintf(globBuf, "Tri: no triangulation (%s)\n",(cmd->pars)[0]);
		ZIBStdOut(globBuf);
		return false;
	  }

	sprintf(globBuf, "Tri: current triangulation '%s' from '%s'\n", actTriang->name, actTriang->fileName);
	ZIBStdOut(globBuf);
	sprintf(globBuf, "       %-20.20s: % 4d\n", "noOfPoints", actTriang->noOfPoints);
	ZIBStdOut(globBuf);
	sprintf(globBuf, "       %-20.20s: % 4d\n", "noOfEdges", actTriang->noOfEdges);
	ZIBStdOut(globBuf);
	sprintf(globBuf, "       %-20.20s: % 4d\n", "noOfTriangles", actTriang->noOfTriangles);
	ZIBStdOut(globBuf);
	sprintf(globBuf, "       %-20.20s: % 4d\n", "noOfInitPoints", actTriang->noOfInitPoints);
	ZIBStdOut(globBuf);
	sprintf(globBuf, "       %-20.20s: % 4d\n", "noOfInitEdges", actTriang->noOfInitEdges);
	ZIBStdOut(globBuf);
	sprintf(globBuf, "       %-20.20s: % 4d\n", "noOfInitTriangles", actTriang->noOfInitTriangles);
	ZIBStdOut(globBuf);
	sprintf(globBuf, "       %-20.20s: % 4d\n", "refLevel", actTriang->refLevel);
	ZIBStdOut(globBuf);
	sprintf(globBuf, "       %-20.20s: % 4d\n", "maxDepth", actTriang->maxDepth);
	ZIBStdOut(globBuf);

	if ((firstTriang==actTriang)&&((actTriang->next)==nil))
	  return true;
	ZIBStdOut("Tri: other triangulation\n");
	while (tri!=nil)
	  {
		if (i==0) ZIBStdOut("       ");
		else { if ((i%3)==0) { ZIBNL(); ZIBStdOut("       "); } }
		sprintf(globBuf, "	   %-20.20s\n", tri->name);
		ZIBStdOut(globBuf);
		tri = tri->next;
		i++;
	  }
	ZIBNL();

	return true;
  }

static int compString(s1, s2)
  char *s1, *s2;
  {
    char c1 = *s1, c2 = *s2;

	while (c1==c2)
	{
	  if ((c1==NUL)&&(c2==NUL)) return true;
	  s1++;     s2++;
	  c1 = *s1; c2 = *s2;
	  if (isupper(c1)) c1 = tolower(c1);
	  if (isupper(c2)) c2 = tolower(c2);
	}
	return false;
  }

int TriSel(cmd)
  COMMAND *cmd;
  {
	TRIANGULATION *tri = firstTriang;

	if (ParsCheck(cmd,1,1)) return false;
	if (tri==nil)
	  {
	    sprintf(globBuf, "Tri: no triangulation (%s)\n",(cmd->pars)[0]);
		ZIBStdOut(globBuf);
		return false;
	  }

	while (tri!=nil)
	{
	  if (compString(tri->name,(cmd->pars)[1]))
	    {
		  SelTri(tri);
		  sprintf(globBuf, "Tri: current triangulation set to '%s'\n", actTriang->name);
		  ZIBStdOut(globBuf);
		  return true;
		}
	  tri = tri->next;
	}

	sprintf(globBuf, "Tri: can`t find triangulation '%s'\n", (cmd->pars)[1]);
	ZIBStdOut(globBuf);
	return false;
  }

int TriDel(cmd)
  COMMAND *cmd;
  {
	TRIANGULATION *tri = firstTriang;
	char *name;

	if (ParsCheck(cmd,0,1)) return false;
	if (tri==nil)
	  {
	    sprintf(globBuf, "Tri: no triangulation (%s)\n",(cmd->pars)[0]);
		ZIBStdOut(globBuf);
		return false;
	  }

	if ((cmd->noOfPars)==0) tri = actTriang;
	else
	  while (tri!=nil)
		{
		  if (compString(tri->name,(cmd->pars)[1])) break;
		  tri = tri->next;
		}
	if (tri==nil)
	  {
	    sprintf(globBuf, "Tri: can`t find triangulation '%s'\n", (cmd->pars)[1]);
		ZIBStdOut(globBuf);
		return false;
	  }
	name = tri->name;
	CloseTri(&tri);
	sprintf(globBuf, "Tri: triangulation '%s' deleted\n", name);
	ZIBStdOut(globBuf);
	if (actTriang!=nil)
	  {
	    sprintf(globBuf, "Tri: current triangulation set to '%s'\n", actTriang->name);
		ZIBStdOut(globBuf);
	  }
	return true;
  }

void PrintTr(s, t)
  char *s;
  TR *t;
  {
    int k;
    EDG **eds = &(t->e1);
    if (t==nil)
	  { sprintf(globBuf,"%s: nil\n", s); ZIBStdOut(globBuf); return; }
    sprintf(globBuf,"%s: (%d,%d,%d) (", s, (t->p1)->indexP,
			(t->p2)->indexP, (t->p3)->indexP);
    ZIBStdOut(globBuf);
	for (k = 0; k<3; k++)
      {
	    sprintf(globBuf,"(%d)-(%d)", (eds[k]->p1)->indexP,
				(eds[k]->p2)->indexP);
		ZIBStdOut(globBuf);
	  }
    ZIBStdOut(")");
    if ((t->father)==nil) ZIBStdOut(" init");

    switch(t->type)
        {
          case T_RED:   ZIBStdOut(" red"); break;
          case T_BLUE:  ZIBStdOut(" blue"); break;
		  case T_GREEN: ZIBStdOut(" green"); break;
		  case T_WHITE: ZIBStdOut(" white"); break;
        }
    ZIBStdOut("\n");
    return;
  }

int PrTr(t)
  TR *t;
  {
    PrintTr("", t);
    return true;
  }
 
void PrintEdg(s, ed)
  char *s;
  EDG *ed;
  {
    if (ed==nil)
	  { sprintf(globBuf,"%s: nil\n", s); ZIBStdOut(globBuf); return; }
    sprintf(globBuf,"%s: (%d-%d)", s, (ed->p1)->indexP,
			(ed->p2)->indexP);
    ZIBStdOut(globBuf);
	switch(ed->type)
        {
          case T_RED:   ZIBStdOut(" red"); break;
          case T_BLUE:  ZIBStdOut(" blue"); break;
		  case T_GREEN: ZIBStdOut(" green"); break;
		  case T_WHITE: ZIBStdOut(" white"); break;
		  case T_NOTHING: ZIBStdOut(" nothing"); break;
        }
    ZIBStdOut("\n");
    return;
  }

int PrEdg(ed)
  EDG *ed;
  {
    PrintEdg("", ed);;
    return true;
  }

void PrintPt(s, p)
  char *s;
  PT *p;
  {
    sprintf(globBuf,"%s",s);
	ZIBStdOut(globBuf);
    PrPt(p);
    return;
  }

int PrPt(p)
  PT *p;
  {
    if (p==nil) ZIBStdOut(": nil\n");
    else
	  {
	    sprintf(globBuf, ": %d, (%e,%e), sol=%e\n",
				p->indexP, p->x, p->y, RA(p,R_SOL));
		ZIBStdOut(globBuf);
	  }
    return true;
  }

static int CntP(p)
  PT *p;
  {
	countP++;
	if ((p->vec)==nil)
	  {
	    sprintf(globBuf, "Check: missing associated array at point %d\n",
		        p->indexP);
		ZIBStdOut(globBuf);
	  }
	return true;
  }

static int CntE(ed)
  EDG *ed;
  {
    int k = 0;
	if ((ed->t1)!=nil) k++;
	if ((ed->t2)!=nil) k++;
	if ((k==0)||
	    ((k==1)&&((ed->boundP)==INTERIOR)&&((ed->firstSon)==nil)))
	  {
	    sprintf(globBuf, "Check: reference to triangle in edge messing (%d,%d)\n",
				(ed->p1)->indexP, (ed->p2)->indexP);
		ZIBStdOut(globBuf);
	  }
	countE++;
	if (((ed->firstSon)==nil)&&((ed->vec)==nil))
	  {
	    sprintf(globBuf, "Check: missing associated array at edge (%d,%d)\n",
		        (ed->p1)->indexP, (ed->p2)->indexP);
		ZIBStdOut(globBuf);
	  }
	return true;
  } 

static REAL Jacobi(p1,p2,p3)
  PT *p1, *p2, *p3;
  {
    return ((p2->x)-(p1->x))*((p3->y)-(p1->y))-
           ((p3->x)-(p1->x))*((p2->y)-(p1->y));
  }

static int CheckOrien(t)
  TR *t;
  {
    REAL J = Jacobi(t->p1,t->p2,t->p3);
    EDG **eds = &(t->e1);
    PT **ps = &(t->p1), *pe1, *pe2;
    int i, k, z1, z2;
    int notOrien = false, notThreeP = false, notOpposit = false;
 
    if ((t->type)==T_GREEN) return true;
    if (J<=ZERO) notOrien = true;
    for (k=0; k<3; k++)
      {
        pe1 = eds[k]->p1; pe2 = eds[k]->p2;
        z1 = 0; z2 = 0;
        for (i=0; i<3; i++)
          {
            if (pe1==ps[i]) z1++;
            if (pe2==ps[i]) z2++;
          }
        if ((z1!=1)||(z2!=1)) notThreeP = true;
        if ((pe1==ps[k])||(pe2==ps[k])) notOpposit = true;
      }
    if (notOrien)
      {
        PrintTr("Not oriented",t);
      }
    if (notThreeP)
      {
        PrintTr("Edges contain more than 3 Points",t);
      }
    if (notOpposit)
      {
        PrintTr("Points not opposit to edge",t);
      }
 
    return true;
  }

static int CntT(t)
  TR *t;
  {
    CheckOrien(t);
	countT++;
	return true;
  }

void CountLevel(no)
  int no;
  {
    countP =0; countE = 0; countT = 0;
	if (no<(actTriang->refLevel))
	  {
		ApplyPLevel(CntP, no);
		ApplyELevel(CntE, no);
		ApplyTLevel(CntT, no);
	  }
	else
	  {
		ApplyP(CntP, all);
		ApplyE(CntE, nodal);
		ApplyT(CntT, all);
	  }
	sprintf(globBuf, "Tri: level %2d - %4d points, %4d edges, %4d triangles counted\n",
			no, countP, countE, countT);
	ZIBStdOut(globBuf);
	return;
  }

int TriChk(cmd)
  COMMAND *cmd;
  {
    int k;

	if (ParsCheck(cmd,0,0)) return false;
	if (actTriang==nil)
	  { ZIBStdOut("Tri: no triangulation (TriChk)\n"); return false; }

	sprintf(globBuf, "Tri: counting on %d level(s)\n",
			(actTriang->refLevel)+1);
	ZIBStdOut(globBuf);
	for (k = 0; k<=(actTriang->refLevel); k++)
	  CountLevel(k);
	return true;
  }

	
