C
C  EXAMPLE FOR THE CALL OF SUBROUTINE LIMEX
C  INTEGRATOR FOR DIFFERENTIAL-ALGEBRAIC SYSTEMS
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION Y(3),RW(150)
      INTEGER IW(30),IJOB(13)
      EXTERNAL FCN,LSC,JAC,JDUM
      N=3
      NZC=1
      NZV=1
      T=0.D0
      Y(1)=-1.D0
      Y(2)=5.D0
      Y(3)=4.D0*Y(1)/(3.D0*Y(1)-8.D0)
      TEND=0.1108D0
      RTOL=1.D-3
      YMAX0=1.D0
      HMAX=TEND-T
      H=1.D-3
      NRW=150
      NIW=30
      IJOB(1)=0
      IJOB(2)=0
      IJOB(3)=0
      IJOB(4)=0
      IJOB(5)=0
      IJOB(6)=2
      IJOB(7)=1
      CALL LIMEX(N,NZC,NZV,LSC,FCN,JAC,T,Y,TEND,RTOL,YMAX0,HMAX,H,IJOB,
     1           NRW,RW,NIW,IW)
      STOP
      END
C
      SUBROUTINE FCN (N,NZV,T,Y,DY,BV,IRV,ICV)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION Y(N),DY(N),BV(1),IRV(1),ICV(1)
      DY(1)=-0.8D0*Y(1)+1.D1*Y(2)-0.6D0*Y(1)*Y(3)
      DY(2)=-1.D1+1.6D0*Y(3)/Y(2)
      DY(3)=0.8D0*Y(1)+1.6D0*Y(3)-0.6D0*Y(1)*Y(3)
      BV(1)=1.D0/Y(2)
      IRV(1)=2
      ICV(1)=2
      RETURN
      END
C
      SUBROUTINE LSC (NZC,BC,IRC,ICC)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION BC(NZC)
      DIMENSION IRC(NZC),ICC(NZC)
      BC(1)=1.D0
      IRC(1)=1
      ICC(1)=1
      RETURN
      END
C
      SUBROUTINE JAC (N,MB,T,Y,YP,A)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION Y(N),YP(N),A(MB,N)
      A(1,1)=-0.8D0-0.6D0*Y(3)
      A(1,2)=1.D1
      A(1,3)=-0.6D0*Y(1)
      A(2,1)=0.D0
      A(2,2)=(YP(2)-1.6D0*Y(3))/Y(2)**2
      A(2,3)=1.6D0/Y(2)
      A(3,1)=0.8D0-0.6D0*Y(3)
      A(3,2)=0.D0
      A(3,3)=1.6D0-0.6D0*Y(1)
      RETURN
      END
      SUBROUTINE JDUM (N,MB,T,Y,YP,A)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      RETURN
      END
      SUBROUTINE LIMEX (N,NZC,NZV,LSC,FCN,JAC,T,Y,TEND,RTOL,YMAX0,
     1                  HMAX,H,IJOB,NRW,RW,NIW,IW)
C*    Begin Prologue
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C                                                                      *
C    EXTRAPOLATION INTEGRATOR FOR THE SOLUTION OF                      *
C    LINEARLY IMPLICIT DIFFERENTIAL-ALGEBRAIC SYSTEMS OF THE FORM      *
C                                                                      *
C                                                                      *
C      (*)   B (T,Y) * Y' (T) = F (T,Y)                                *
C                                                                      *
C            B :(N,N)-MATRIX,  1.LE.RANK(B).LE.N                       *
C                                                                      *
C***********************************************************************
C
C=======================================================================
C                                                                      =
C     REVISION 3.2 JULY 30, '87                                        =
C                                                                      =
C  -------------------------------------------------------------------
C  ------  new revision will be available spring 1991  ---------------
C  ------  the new revision will include a new user    ---------------
C  ------  interface and some algorithmic improvements ---------------
C  -------------------------------------------------------------------
C
C*  Title
C
C    Numerical solution of Linearly IMplicit differential-algebraic
C    systems with EXtrapolation techniques
C
C*  Written by        U. Nowak, J. Zugck   
C*  Purpose           Solution of linearly implicit differential-
C                     algebraic systems up to index 1.
C*  Method            Extrapolation integrator with order and stepsize
C                     control. 
C                     (see references below)
C*  Category          i1a2b: Stiff and mixed implicit differential- 
C                     algebraic systems up to index 1.
C*  Keywords          Differential equations, differential-algebraic 
C                     systems, extrapolation integrator
C*  Version           3.2
C*  Revision          July 1987    
C*  Latest Change     January 1991 
C*  Library           CodeLib
C*  Code              Fortran, Double Precision
C*  Environment       Fortran environment on PC's, workstations and
C                     hosts.
C*  Copyright     (c) Konrad Zuse Zentrum fuer
C                     Informationstechnik Berlin
C                     Heilbronner Str. 10, D-1000 Berlin 31
C                     phone 0049+30+89604-0, 
C                     telefax 0049+30+89604-125
C*  Contact           U. Nowak     
C                     ZIB
C                     Numerical Software Development 
C                     phone: 0049+30+89604-175 ;
C                     e-mail: 
C                     RFC822 notation: nowak@sc.zib-berlin.de
C                     X.400: C=de;A=dbp;P=zib-berlin;OU=sc;S=Nowak  
C
C
C  -------------------------------------------------------------------
C
C* licence   
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C* warranty
C    This code has been tested up to a certain level. Defects and
C    weaknesses, which may be included in the code, do not establish
C    any warranties by ZIB. ZIB does not take over any liabilities
C    which may follow from aquisition or application of this code.
C
C* software status 
C    This code is under partial care of ZIB and belongs to ZIB software
C    class II.
C
C  -------------------------------------------------------------------
C
C  
C=======================================================================
C
C REFERENCES:
C============
C
C /1/ P. DEUFLHARD, U. NOWAK:
C     EXTRAPOLATION INTEGRATORS FOR QUASILINEAR IMPLICIT ODE'S
C     UNIVERSITY OF HEIDELBERG, SFB 123, TECH. REP. 332 (1985)
C     IN:
C     P. DEUFLHARD, B. ENQUIST (EDS):
C     LARGE SCALE SCIENTIFIC COMPUTING
C     BIRKAEUSER, PROG.SCI.COMP. 7, (1987)
C
C /2/ P. DEUFLHARD, E. HAIRER, J. ZUGCK:
C     ONE STEP AND EXTRAPOLATION METHODS FOR DIFFERENTIAL-ALGEBRAIC
C     SYSTEMS
C     NUM. MATH. 51, 501-516 (1987)
C
C /3/ P.DEUFLHARD:
C     RECENT PROGRESS IN EXTRAPOLATION METHODS FOR ODE'S.
C     SIAM REVIEW 27, 505-535  (1985)
C
C=======================================================================
C
C  EQUATION (*) REPRESENTS AN ODE, IF B IS NONSINGULAR, AND
C  A DIFFERENTIAL-ALGEBRAIC EQUATION (DAE), IF B IS SINGULAR.
C  LIMEX USES AN ITERATIVE REALIZATION OF THE SEMI-IMPLICIT EULER-
C  METHOD (EULSIM) FOR THE DISCRETIZATION OF (*).
C
C
C  EXTERNAL SUBROUTINES (TO BE SUPPLIED BY THE USER):
C  --------------------------------------------------
C
C    FCN (N,NZV,T,Y,RHS,  RIGHT-HAND-SIDE F(T,Y) OF THE SYSTEM, INCLU-
C         BV,IRV,ICV)     DING VARIABLE PART BV OF LEFT-HAND-SIDE MATRIX
C                         B(T,Y)
C                         (SPECIFY BV(1),IRV(1),ICV(1) IF NO VARIABLE
C                          ENTRIES IN THE LEFT-HAND-SIDE MATRIX B(T,Y)
C                          OCCUR)
C    LSC (NZC,BC,IRC,ICC) CONSTANT PART BC OF LEFT-HAND-SIDE MATRIX
C                         B(T,Y) (NON-ZERO ENTRIES ONLY)
C                         (PASS A DUMMY-NAME, IF THERE ARE NO CONSTANT
C                          ENTRIES IN THE LEFT-HAND-SIDE MATRIX B(T,Y) )
C    JAC (N,M,T,Y,YP,A)   ANALYTIC JACOBIAN OF THE RESIDUAL R(T,Y)
C                         R(T,Y):= F(T,Y)-B(T,Y)*Y'
C                         (PASS A DUMMY-NAME, IF NUMERICAL DIFFERENCE
C                          APPROXIMATION OF THE JACOBIAN IS WANTED)
C      T                  ACTUAL POSITION
C      Y(N)               VALUES OF Y AT T
C      YP(N)              VALUES OF Y' AT T
C      RHS(N)             VALUES OF THE RIGHT-HAND-SIDE FUNCTIONS F(T,Y)
C      N                  DIMENSION OF THE SYSTEM
C      BV(NZV)            ENTRIES OF VARIABLE PART BV OF LEFT-HAND-SIDE
C                         MATRIX B(T,Y) (SPARSE MODE STORAGE SCHEME, SEE
C                         NOTE 1 BELOW)
C      IRV(NZV)           INTEGER ARRAY CONTAINING ROW-INDICES OF BV
C      ICV(NZV)           INTEGER ARRAY CONTAINING COLUMN-INDICES OF BV
C      NZV                NUMBER OF ENTRIES OF BV
C      BC(NZC)            ENTRIES OF CONSTANT PART BC OF LEFT-HAND-SIDE
C                         MATRIX B(T,Y) (SPARSE MODE STORAGE SCHEME, SEE
C                         NOTE 1 BELOW)
C      IRC(NZC)           INTEGER ARRAY CONTAINING ROW-INDICES OF BC
C      ICC(NZC)           INTEGER ARRAY CONTAINING COLUMN-INDICES OF BC
C      NZC                NUMBER OF ENTRIES OF BC
C      A(M,N)             ENTRIES OF THE JACOBIAN A AT T,Y
C      M                  NUMBER OF ROWS OF A
C                         (M = N, IN THE DENSE MATRIX CASE, M < N IN
C                          THE BAND MATRIX CASE, SEE NOTE 2 BELOW )
C
C  INPUT PARAMETERS (* MARKS TRANSIENT PARAMETERS):
C  ------------------------------------------------
C
C  * T                  STARTING POINT OF INTEGRATION
C  * Y(N)               INITIAL VALUES Y(1),...,Y(N)
C    TEND               PRESCRIBED FINAL POINT OF INTEGRATION
C    RTOL               PRESCRIBED RELATIVE PRECISION (.GT.0)
C    YMAX0              THRESHOLD FOR RELATIVE ERROR CONTROL
C                       ERROR IS RELATIVE (COMPONENTWISE) WITH RESPECT
C                       TO:       MAX(YMAX(I),YMAX0)
C                          WHERE: YMAX(I):= MAXIMUM OF ABS(Y) FOR
C                                 COMPONENT NO.I COMPUTED SO FAR
C    HMAX               MAXIMUM PERMITTED STEPSIZE
C                       (HMAX=TEND-T IS RECOMMENDED)
C  * H                  INITIAL STEPSIZE GUESS
C                       (FOR H=0 AN INITIAL STEPSIZE GUESS IS INTERNALLY
C                        GENERATED)
C    IJOB(13)           INTEGER VECTOR, CONTROLLING THE EXECUTION OF
C                       THE JOB, LENGTH:=13
C   * IJOB(1)           =0: B IS KNOWN TO BE OR MIGHT BE SINGULAR
C                       =1: B IS KNOWN TO BE NONSINGULAR
C     IJOB(2)           =0: NUMERICAL DIFFERENCE-APPROXIMATION OF THE
C                           JACOBIAN OF THE RIGHT-HAND-SIDE F(T,Y)
C                           INTERNALLY GENERATED
C                       =1: ANALYTIC JACOBIAN SUPPLIED BY THE USER
C     IJOB(3)           =0: B-H*A IS A DENSE MATRIX ( A: JACOBIAN
C                                                     H: STEPSIZE )
C                       =1: B-H*A IS A BAND MATRIX
C     IJOB(4)           = LOWER BANDWIDTH OF B-H*A (EXCLUDING THE DIAGO-
C                         NAL ); SET IJOB(4)=0, IF IJOB(3)=0
C     IJOB(5)           = UPPER BANDWIDTH OF B-H*A (EXCLUDING THE DIAGO-
C                         NAL ); SET IJOB(5)=0, IF IJOB(3)=0
C   * IJOB(6)           PERFORMANCE STATISTICS
C                       =0: NO OUTPUT
C                       =1: STANDARD OUTPUT
C                       =2: ADDITIONALLY INTEGRATION MONITOR
C                       =3: ADDITIONALLY ENHANCED INFORMATION
C                       =4: ADDITIONALLY ITERATION MONITOR ( OF ITERA-
C                           TIVE REALIZATION OF DISCRETIZATION )
C     IJOB(7)           SOLUTION OUTPUT
C                       =0: NO OUTPUT
C                       =1: INITIAL VALUES AND SOLUTION VALUES
C                       =2: ADDITIONALLY SOLUTION VALUES AT INTERMEDIATE
C                           POINTS CHOSEN BY LIMEX
C    NRW                DIMENSION OF REAL WORK-SPACE,
C                       TO BE CHOSEN .GE. :
C
C                       (MBH+MB+JM+9)*N+2*NZV+NZC+2*JM*JM+JM
C
C                         MBH = N                  , IF B-H*A IS DENSE,
C                             = 2*IJOB(4)+IJOB(5)+1, IF B-H*A IS BANDED,
C                         MB  = N                  , IF B-H*A IS DENSE
C                             =   IJOB(4)+IJOB(5)+1, IF B-H*A IS BANDED,
C                         JM  = 5                  , IF IJOB(1).EQ.0
C                             = 7                  , IF IJOB(1).EQ.1
C
C    RW                 REAL WORK-SPACE
C    NIW                DIMENSION OF INTEGER WORK-SPACE,
C                       TO BE CHOSEN .GE. :
C
C                       N+2*(NZV+NZC+JM)+KM
C
C                         KM  = JM-1
C
C    IW                 INTEGER WORK-SPACE
C
C ==================================================================
C ===  NOTE 1 : EXAMPLE FOR SPARSE MODE STORAGE SCHEME IN LIMEX  ===
C ==================================================================
C
C                   CONSIDER THE FOLLOWING CASE:
C
C                               |0     0    0  |
C                    B(T,Y)=    |1     1    0  |
C                               |T+1  -T   Y(2)|
C
C    WITH NZV=3 AND NZC=2 STORAGE OF BV AND BC IS DONE BY THE FOLLOWING
C    LINES:
C
C                   BV (1) = T+1.D0
C                   IRV(1) = 3
C                   ICV(1) = 1
C                   BV (2) = Y(2)
C                   IRV(2) = 3
C                   ICV(2) = 3
C                   BV (3) = -T
C                   IRV(3) = 3
C                   ICV(3) = 2
C            C
C                   BC (1) = 1.D0
C                   IRC(1) = 2
C                   ICC(1) = 1
C                   BC (2) = 1.D0
C                   IRC(2) = 2
C                   ICC(2) = 2
C
C        (THE ORDER OF THE ENTRIES IN BV AND BC IS ARBITRARY)
C
C ===========================================================
C ===  NOTE 2 : STORAGE OF USER SUPPLIED BANDED JACOBIAN  ===
C ===========================================================
C
C  IN THE BAND MATRIX CASE, THE FOLLOWING LINES MAY BUILD UP THE
C  ANALYTIC JACOBIAN A;
C  HERE AFL DENOTES THE QUADRATIC MATRIX A IN DENSE FORM, AND ABD THE
C  RECTANGULAR MATRIX A IN BANDED FORM :
C
C                   ML = IJOB(4)
C                   MU = IJOB(5)
C                   MH = MU+1
C                   DO 20 J = 1,N
C                   I1 = MAX0(1,J-MU)
C                   I2 = MIN0(N,J+ML)
C                   DO 10 I = I1,I2
C                   K = I-J+MH
C                   ABD(K,J) = AFL(I,J)
C           10      CONTINUE
C           20      CONTINUE
C
C           THE TOTAL NUMBER OF ROWS NEEDED IN  ABD  IS  ML+MU+1 .
C           THE  MU BY MU  UPPER LEFT TRIANGLE AND THE
C           ML BY ML  LOWER RIGHT TRIANGLE ARE NOT REFERENCED.
C
C ===========================================================
C
C
C  OUTPUT PARAMETERS:
C  ------------------
C
C    T                  ACTUAL FINAL POINT OF INTEGRATION
C    Y(N)               FINAL VALUES AT T
C    H                  STEPSIZE PROPOSAL FOR NEXT INTEGRATION STEP
C                       (H.EQ.0. ,IF LIMEX FAILS TO PROCEED)
C    IJOB(6)    .GE. 0: SUCCESSFUL INTEGRATION
C                       (IJOB(6) NOT ALTERED INTERNALLY)
C               .LT. 0: ERROR CODE AFTER A FAIL RUN OF LIMEX
C                  =-1: MORE THAN JRMAX STEPSIZE REDUCTIONS
C                       OCCURRED PER BASIC INTEGRATION STEP
C                  =-2: MORE THAN NSTMAX BASIC INTEGRATION STEPS PER
C                       INTERVAL HAVE BEEN PERFORMED
C                  =-3: STEPSIZE PROPOSAL FOR NEXT BASIC INTEGRATION
C                       STEP WAS TOO SMALL
C                  =-4: MATRIX PENCIL B-H*A IS SINGULAR:
C                       NO OR INFINITELY MANY SOLUTIONS EXIST
C                  =-5: ITERATIVE REALIZATION OF DISCRETIZATION FAILED
C                       TO SUCCEED
C                  =-6: NILPOTENCY OF THE SYSTEM IS GREATER THAN
C                       ONE
C                  =-7: INITIAL VALUES ARE INCONSISTENT OR NILPOTENCY
C                       OF THE SYSTEM IS GREATER THAN ONE
C                  =-8: REAL OR INTEGER WORK-SPACE IS EXHAUSTED
C                  =-9: THE GIVEN PROBLEM IS AN ALGEBRAIC EQUATION
C                       (LIMEX IS NOT SUITABLE IN THIS CASE)
C
C  OUTPUT AFTER A SUCCESSFULLY COMPLETED TASK ONLY:
C  ------------------------------------------------
C
C   IJOB(13)  =   NUMBER OF PERFORMED INTEGRATION STEPS
C   IJOB( 9)  =   NUMBER OF FUNCTION-EVALUATIONS (FOR INTEGRATION)
C   IJOB(12)  =   NUMBER OF FUNCTION-EVALUATIONS (FOR JACOBIAN APPROX.)
C   IJOB(10)  =   NUMBER OF GAUSSIAN DECOMPOSITIONS
C   IJOB(11)  =   NUMBER OF FORWARD-BACKWARD-SUBSTITUTIONS
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
C  THE NUMERICAL SOLUTION OF THE ARISING LINEAR EQUATIONS IS DONE BY
C  MEANS OF THE SUBROUTINES LINGL AND SUBST ( GAUSS-ALGORITHM WITH CO-
C  LUMN-PIVOTING AND ROW-INTERCHANGE ) IN THE DENSE MATRIX CASE, OR BY
C  THE LINPACK ROUTINES DGBFA AND DGBSL IN THE BAND MATRIX CASE.
C  FOR SPECIAL PURPOSES THESE ROUTINES MAY BE SUBSTITUTED.
C
C-----------------------------------------------------------------------
C         THIS IS A DRIVER ROUTINE FOR THE CORE-INTEGRATOR LIMEX1
C-----------------------------------------------------------------------
C
      DOUBLE PRECISION Y(N),RW(NRW)
      INTEGER IW(NIW),IJOB(13)
C
      EXTERNAL LSC,FCN,JAC
C
      COMMON/LIMX1/LOUT
      COMMON/LIMX2/EPMACH,SMALL
      COMMON/LIMX3/NSTMAX,JRMAX,ISMAX
C
C*    End Prologue
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C              INITIAL PREPARATIONS
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
C  OUTPUT UNIT FOR INTEGRATION MONITOR
C  -----------------------------------
C
      LOUT=6
C
C  RELATIVE MACHINE PRECISION
C  --------------------------
C
      EPMACH=1.D-16
C
C  SQUARE-ROOT OF SMALLEST POSITIVE MACHINE NUMBER
C  -----------------------------------------------
C
      SMALL=1.D-35
C
C  PRESCRIBED MAXIMUM ROW NUMBER OF EXTRAPOLATION-TABLEAU
C  -----------------------------------------------------
C
      JM=7
      IF(IJOB(1).EQ.1) GOTO 10
      JM=5
C
C  PRESCRIBED MAXIMUM COLUMN NUMBER OF EXTRAPOLATION-TABLEAU
C  --------------------------------------------------------
10    KM=JM-1
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  INTERNAL PARAMETERS
C  (STANDARD VALUES FIXED BELOW;
C   TO BE ALTERED, IF NECESSARY, BY THE SKILLFULL USER)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
C  MAXIMUM PERMITTED NUMBER OF BASIC INTEGRATION STEPS PER INTERVAL
C  ----------------------------------------------------------------
C
      NSTMAX=900
C
C  MAXIMUM PERMITTED NUMBER OF STEPSIZE REDUCTIONS PER BASIC STEP
C  --------------------------------------------------------------
C  (DUE TO EXTRAPOLATION-TABLEAU)
C
      JRMAX=20
C
C  MAXIMUM PERMITTED NUMBER OF STEPSIZE REDUCTIONS PER BASIC STEP
C  --------------------------------------------------------------
C  (DUE TO ZERO PIVOT IN GAUSSIAN DECOMPOSITION)
C
      ISMAX=5
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  CHECK FOR SUFFICIENT  WORK-SPACE AND TYPE OF LEFT-HAND-SIDE
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      IJOB(8)=0
      IF(NZV.GT.0.AND.NZC.GT.0) GOTO 30
      IF(NZV+NZC.EQ.0) GOTO 60
      IF(NZC.NE.0) GOTO 20
      NZC=1
      IJOB(8)=2
      GOTO 30
20    NZV=1
      IJOB(8)=1
30    ML=IJOB(4)
      MU=IJOB(5)
      MB=N
      MBH=N
      IF(IJOB(3).EQ.0) GOTO 40
      MBH=2*ML+MU+1
      MB=ML+MU+1
40    MINRW=(MBH+MB+JM+9)*N+2*NZV+NZC+2*JM*JM+JM+JM*N+N
      MINIW=N+2*(NZV+NZC)+2*JM+KM
      IF(IJOB(6).GT.0) WRITE(LOUT,70) MINRW,MINIW
      IF(MINRW.GT.NRW .OR. MINIW.GT.NIW) GOTO 50
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  BUILD-UP OF WORK-SPACE
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      NN=MB*N
      NNH=MBH*N
      NJM=N*JM
      JMJM=JM*JM
C
      I2=N+1
      I3=I2+JM
      I4=I3+JM
      I5=I4+KM
      I6=I5+NZC
      I7=I6+NZC
      I8=I7+NZV
C
      N2=NNH+1
      N3=N2+NN
      N4=N3+NZC
      N5=N4+NZV
      N6=N5+NZV
      N7=N6+NJM
      N8=N7+JMJM
      N9=N8+JMJM
      N10=N9+N
      N11=N10+N
      N12=N11+N
      N13=N12+N
      N14=N13+N
      N15=N14+N
      N16=N15+N
      N17=N16+N
      N18=N17+JM
      N19=N18+NJM
C
      IPRINT=1
      IF(IJOB(6).EQ.0) IPRINT=0
C
C     CALL OF CORE INTEGRATOR LIMEX1
C     ----------------------------------
C
      CALL LIMEX1(N,MB,MBH,NZC,NZV,JM,KM,LSC,FCN,JAC,T,Y,TEND,RTOL,YMAX0
     1           ,HMAX,H,IJOB,IW(1),IW(I2),IW(I3),IW(I4),IW(I5),IW(I6),
     2            IW(I7),IW(I8),RW(1),RW(N2),RW(N3),RW(N4),RW(N5),
     3            RW(N6),RW(N7),RW(N8),RW(N9),RW(N10),RW(N11),RW(N12),
     4            RW(N13),RW(N14),RW(N15),RW(N16),RW(N17),RW(N18),
     5            RW(N19))
C
      IF(IJOB(8).EQ.2) NZC=0
      IF(IJOB(8).EQ.1) NZV=0
      IF(IJOB(6).GT.0) WRITE(LOUT,100) IJOB(13),IJOB(9),IJOB(12),
     1                               IJOB(10),IJOB(11)
      IF(IJOB(6).LT.0.AND.IPRINT.EQ.0) WRITE(LOUT,110) IJOB(6)
      RETURN
C
C  FAIL EXIT  (WORK-SPACE EXHAUSTED)
C  ---------------------------------
50    CONTINUE
      ICODE=-8
      IF(IJOB(6).EQ.0) WRITE(LOUT,110) ICODE
      IF(IJOB(6).GT.0.AND.MINRW.GT.NRW) WRITE(LOUT,80)
      IF(IJOB(6).GT.0.AND.MINIW.GT.NIW) WRITE(LOUT,90)
      IJOB(6)=ICODE
      RETURN
60    ICODE=-9
      IF(IJOB(6).EQ.0) WRITE(LOUT,110) ICODE
      IF(IJOB(6).GT.0) WRITE(LOUT,120)
      IJOB(6)=ICODE
      RETURN
C
C ----------------------------------------------------------------------
C                  FORMAT-STATEMENTS
C ----------------------------------------------------------------------
C
70    FORMAT(/1X,' ********************************',/,
     1        1X,' * MINIMAL REQUIRED WORK-SPACE: *',/,
     2        1X,' *   REAL ARRAY     RW(',I6,')  *',/,
     3        1X,' *   INTEGER ARRAY  IW(',I6,')  *',/,
     4        1X,' ********************************',/ )
80    FORMAT(1X,' *** ERROR *** :  REAL WORK-SPACE EXHAUSTED',/)
90    FORMAT(1X,' *** ERROR *** :  INTEGER WORK-SPACE EXHAUSTED',/)
100   FORMAT(/1X,' **********  STATISTICS  **********',/,
     1        1X,' ****    STEPS     :',I6,'     ****',/,
     2        1X,' ****    F.-EV     :',I6,'     ****',/,
     3        1X,' ****    F.-EV(J)  :',I6,'     ****',/,
     4        1X,' ****    DECOMP.   :',I6,'     ****',/,
     5        1X,' ****    SUBST.    :',I6,'     ****',/,
     6        1X,' **********************************',/)
110   FORMAT(/1X,' ### ERROR CODE FROM LIMEX :',I3,' ###',/)
120   FORMAT(/1X,'THE GIVEN PROBLEM IS AN ALGEBRAIC EQUATION, LIMEX IS N
     1OT SUITABLE',/)
C
C ----------------------------------------------------------------------
C  END OF DRIVER ROUTINE LIMEX
C ----------------------------------------------------------------------
C
      END
      SUBROUTINE LIMEX1(N,MB,MBH,NZC,NZV,JM,KM,LSC,FCN,JAC,T,Y,TEND,
     1                  RTOL,YMAX0,HMAX,H,IJOB,IPIVOT,NJ,INCR,NRED,IRC,
     2                  ICC,IRV,ICV,B,A,BC,BV0,BVK,DT,D,AL,YM,DEL,
     3                  DZ,SM,ETA,W1,W2,W3,AJ,DTP,YP)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      DIMENSION Y(N),B(MBH,N),A(MB,N),BC(NZC),BV0(NZV),BVK(NZV),
     1          DT(N,JM),D(JM,JM),AL(JM,JM),YM(N),
     2          DEL(N),DZ(N),SM(N),ETA(N),W1(N),W2(N),W3(N),AJ(JM),
     3          DTP(N,JM),YP(N)
C
      INTEGER IPIVOT(N),NJ(JM),INCR(JM),NRED(KM),IJOB(13)
      INTEGER IRC(NZC),ICC(NZC),IRV(NZV),ICV(NZV)
C
      LOGICAL LFULL,LBAND,LDIR
C
      EXTERNAL LSC,FCN,JAC
C
      COMMON/LIMX4/NSOL
      COMMON/LIMX1/LOUT
      COMMON/LIMX2/EPMACH,SMALL
      COMMON/LIMX3/NSTMAX,JRMAX,ISMAX
C
      DATA EPMIN/1.D-10/,ETADIF/1.D-6/,EX1/0.6D0/,EX2/1.5D0/,FMIN/1.D-2/
     1     ,FOUR/4.D0/,ONE/1.D0/,ONE1/1.01D0/,QUART/0.25D0/,RMIN/0.9D0/,
     2     RO/0.25D0/,SAFE/0.5D0/,SAFEIN/2.D-2/,TEN/1.D1/,
     3     THRESH/1.D-1/,ZERO/0.D0/,HALF/.5D0/,TWO/2.D0/,SAFEDM/.8D0/
C
C ----------------------------------------------------------------------
C                        INITIAL PREPARATIONS
C ----------------------------------------------------------------------
C
      LDIR=.FALSE.
      LFULL=IJOB(3).EQ.0
      LBAND=IJOB(3).EQ.1
      ML=IJOB(4)
      MU=IJOB(5)
      ML1=ML+1
C
C
      JOB=0
      EPMACH=EPMACH*TEN
      EPDIFF=DSQRT(EPMACH)
      HMAX=DABS(HMAX)
      HMAXU=HMAX
      NSTEP=0
      NFCN=0
      NFCNJ=0
      NDEC=0
      NSOL=0
      H1=TEND-T
      INIT=0
      IF(IJOB(8).EQ.2) GOTO 1000
      CALL LSC (NZC,BC,IRC,ICC)
C
C ----------------------------------------------------------------------
C                          INITIAL SCALING
C  (FOR REAL LIFE APPLICATIONS TO BE ALTERED BY THE SKILLFUL USER)
C ----------------------------------------------------------------------
C
1000  DO 1010 I=1,N
      U=DABS(Y(I))
      IF(U.LT.YMAX0) U=YMAX0
      SM(I)=U
1010  ETA(I)=ETADIF
C
C ----------------------------------------------------------------------
C           SET PARAMETERS FOR EXTRAPOLATION AND ORDER-CONTROL
C ----------------------------------------------------------------------
C
C  STEPSIZE SEQUENCE FOR EULSIM
C  ----------------------------
C
      DO 1020 J=1,JM
1020  NJ(J)=J
C
      DO 1030 I=1,N
      YP(I)=EPMACH
      DO 1030 J=1,JM
      DT(I,J)=0.D0
      DTP(I,J)=0.D0
1030  CONTINUE
C
      FN=DFLOAT(N)
      FMB=DFLOAT(MB)
      FJ1=DFLOAT(NJ(1))
      EPH=RO*RTOL
      AJ(1)=FJ1
      DO 1060 J=2,JM
      J1=J-1
      INCR(J1)=0
      NRED(J1)=0
      FJ=DFLOAT(NJ(J))
      V=AJ(J1)+FJ-ONE
      AJ(J)=V
      DO 1040 K=1,J1
      W=FJ/DFLOAT(NJ(K))
1040  D(J,K)=W
      IF(J.EQ.2) GOTO 1060
      W=V-FJ1
      DO 1050 K1=2,J1
      K=K1-1
      U=(AJ(K1)-V)/(W*DFLOAT(K1))
      U=EPH**U
1050  AL(J1,K)=U
1060  CONTINUE
C
C  EVALUATION OF COST COEFFICIENTS
C  -------------------------------
      COSTF=ONE
      COSTJ=FN*COSTF
      IF(LBAND) COSTJ=FMB*COSTF
      COSTS=ZERO
      COSTLR=ZERO
C
      COSTQ=ONE/QUART
      COSTQ=3
      IF(COSTLR.GT.ZERO .AND. COSTS.GT.ZERO) COSTQ=COSTLR/COSTS
C
      IF((COSTS+COSTLR+COSTJ).EQ.ZERO) GOTO 1080
      AJ(1)=COSTJ+COSTLR+(COSTF+COSTS)*FJ1
      DO 1070 J=2,JM
      J1=J-1
1070  AJ(J)=AJ(J1)+(COSTF+COSTS)*(DFLOAT(NJ(J))-ONE)+COSTS+COSTLR
1080  KOH=1
      JOH=2
1090  CONTINUE
      IF(JOH.GE.JM) GOTO 1100
      IF(AJ(JOH+1)*ONE1.GT.AJ(JOH)*AL(JOH,KOH)) GOTO 1100
      KOH=JOH
      JOH=JOH+1
      GOTO 1090
1100  K=0
      KM=KOH
      JMH=JOH
      INCR(JMH)=-1
      OMJO=ZERO
      IF(IJOB(6).GT.0) WRITE(LOUT,9010) RTOL,YMAX0,KM
      IF(IJOB(7).GE.1) WRITE(LOUT,9160) (Y(I),I=1,N)
      IF(IJOB(6).GE.3) WRITE(LOUT,9020)
      IF(IJOB(6).EQ.2) WRITE(LOUT,9030)
C
C ----------------------------------------------------------------------
C                        BASIC INTEGRATION STEP
C ----------------------------------------------------------------------
C
2000  CONTINUE
      IF(DABS(H1).LE.DABS(T)*EPMACH*TEN) GOTO 4600
      IF(DABS(H1).LE.EPMACH*DABS(H)) GO TO 4600
      IF(IJOB(6).EQ.2) WRITE(LOUT,9110) NSTEP,T
      IF(IJOB(6).GE.3) WRITE(LOUT,9100) NSTEP,NFCN,T,H,K,KOH
      IF(IJOB(7).EQ.2.AND.NSTEP.GT.0) WRITE(LOUT,9000) (Y(I),I=1,N)
      IF(DABS(H1).GE.ONE1*DABS(H)) GO TO 2010
      HR=H
      H=H1
2010  JRED=0
      NSTC=0
      ISING=0
      IT=0
      DMH=SAFEDM
      DO 2020 K=1,KM
2020  INCR(K)=INCR(K)+1
      HMAX=DABS(H1)
      IF(HMAXU.LT.HMAX) HMAX=HMAXU
      CALL RESLIM (N,NZV,T,Y,DZ,YM,BV0,IRV,ICV,YP,FCN,IJOB)
      NFCN=NFCN+1
C
C
C ----------------------------------------------------------------------
C  NUMERICAL DIFFERENCE APPROXIMATION OF JACOBIAN  A=-DR/DY (SCALED)
C  (FEED-BACK CONTROL OF DISCRETIZATION AND ROUNDING ERRORS)
C ----------------------------------------------------------------------
C
      IF(IJOB(2).EQ.1) GOTO 2140
      IF(LBAND) GOTO 2070
C
C   DENSE JACOBIAN
C   --------------
C
      DO 2060 K=1,N
      IS=0
2040  W=Y(K)
      U=SM(K)*ETA(K)
      IF(YM(K).GT.ZERO) U=-U
      Y(K)=W+U
      CALL RESLIM (N,NZV,T,Y,W3,DEL,BVK,IRV,ICV,YP,FCN,IJOB)
      NFCNJ=NFCNJ+1
      Y(K)=W
      U=SM(K)/U
      SUMD=ZERO
      DO 2050 I=1,N
      WZ=YM(I)
      WY=DEL(I)
      W=DABS(WY)
      WY=WZ-WY
      WZ=DABS(WZ)
      IF(W.LT.WZ) W=WZ
      IF(W.EQ.ZERO) GOTO 2050
      W=WY/W
      SUMD=SUMD+W*W
2050  A(I,K)=WY*U/SM(I)
      SUMD=DSQRT(SUMD/FN)
      IF(SUMD.EQ.ZERO .OR. IS.GT.0) GOTO 2060
      ETAD=DSQRT(EPDIFF/SUMD)*ETA(K)
      IF(ETAD.GT.FMIN) ETAD=FMIN
      IF(ETAD.LT.EPMIN) ETAD=EPMIN
      ETA(K)=ETAD
      IS=1
      IF(SUMD.LT.EPMIN) GOTO 2040
2060  CONTINUE
      GOTO 2170
C
C  BANDED JACOBIAN
C  ---------------
C
2070  DO 2080 I=1,MB
      DO 2080 K=1,N
2080  A(I,K)=ZERO
      M=ML+MU+1
      DO 2130 JJ=1,M
      IS=0
2090  NFINE=1
      DO 2100 K=JJ,N,M
      W2(K)=Y(K)
      W1(K)=SM(K)*ETA(K)
      IF(YM(K).GT.ZERO) W1(K)=-W1(K)
2100  Y(K)=W2(K)+W1(K)
      CALL RESLIM (N,NZV,T,Y,W3,DEL,BVK,IRV,ICV,YP,FCN,IJOB)
      NFCNJ=NFCNJ+1
      DO 2120 K=JJ,N,M
      Y(K)=W2(K)
      W1(K)=SM(K)/W1(K)
      SUMD=ZERO
      I1=MAX0(1,K-MU)
      I2=MIN0(N,K+ML)
      MH=MU+1-K
      IF(MH.LT.0)MH=0
      DO 2110 I=I1,I2
      WZ=YM(I)
      WY=DEL(I)
      W=DABS(WY)
      WY=WZ-WY
      WZ=DABS(WZ)
      IF(W.LT.WZ) W=WZ
      IF(W.EQ.ZERO) GOTO 2110
      W=WY/W
      SUMD=SUMD+W*W
2110  A(MH+I-I1+1,K)=WY*W1(K)/SM(I)
      SUMD=DSQRT(SUMD/FN)
      IF(SUMD.EQ.ZERO .OR. IS.GT.0) GOTO 2120
      ETAD=DSQRT(EPDIFF/SUMD)*ETA(K)
      IF(ETAD.GT.FMIN) ETAD=FMIN
      IF(ETAD.LT.EPMIN) ETAD=EPMIN
      ETA(K)=ETAD
      IF(SUMD.LT.EPMIN) NFINE=0
2120  CONTINUE
      IF(NFINE.EQ.1) GOTO 2130
      IS=1
      GOTO 2090
2130  CONTINUE
      GOTO 2170
C
C ----------------------------------------------------------------------
C                     ANALYTIC EXPRESSION OF JACOBIAN
C ----------------------------------------------------------------------
C
C  SUBROUTINE JAC SHOULD PROVIDE JACOBIAN MATRIX OF RESIDUAL A=DR/DY
C  LIMEX1 USES INTERNALLY THE MATRIX A=-DR/DY (SCALED)
C
2140  CALL JAC (N,MB,T,Y,YP,A)
      DO 2160 I=1,MB
      DO 2150 K=1,N
      KK=I+K-1-MU
      IF(LFULL) KK=I
      IF(KK.LT.1) GOTO 2150
      IF(KK.GT.N) GOTO 2160
      A(I,K)=-SM(K)*A(I,K)/SM(KK)
2150  CONTINUE
2160  CONTINUE
C
C
C ----------------------------------------------------------------------
C                     DISCRETIZATION
C ----------------------------------------------------------------------
C
2170  DO 2180 K=1,N
2180  DZ(K)=DZ(K)/SM(K)
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  INITIAL STEPSIZE GUESS, IF H=ZERO
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      IF(INIT.GT.0.OR.H.NE.ZERO) GOTO 2500
      ANORM1=ZERO
      DO 2200 I=1,N
      ROW=ZERO
      DO 2190 K=1,N
2190  ROW=DABS(A(I,K))+ROW
2200  IF(ROW.GT.ANORM1)ANORM1=ROW
      IF(ANORM1.EQ.ZERO)ANORM1=ONE
      H=SAFEIN/ANORM1
      IF(H.GT.H1)H=H1
      INIT=1
C
2500  TN=T+H
      LDIR=.FALSE.
      IF(COSTQ.LE.ZERO) LDIR=.TRUE.
      FCM=DABS(H)/HMAX
      IF(FCM.LT.FMIN) FCM=FMIN
      DM=DMH*TWO
      IF(IJOB(6).GE.4) WRITE(LOUT,9315)
C
      DO 3000 J=1,JMH
      IEST=0
      IF(J.EQ.2) IEST=1
      M=NJ(J)
      G=H/DFLOAT(M)
      DO 3020 I=1,MB
      DO 3010 K=1,N
      B(ML+I,K)=G*A(I,K)
3010  CONTINUE
3020  CONTINUE
      IF(IJOB(8).EQ.1) GOTO 3040
      DO 3030 I=1,NZV
      IR=IRV(I)
      IRH=IR
      IC=ICV(I)
      IF(LBAND) IRH=ML+MU+IR-IC+1
      B(IRH,IC)=B(IRH,IC)+SM(IC)*BV0(I)/SM(IR)
3030  CONTINUE
3040  IF(IJOB(8).EQ.2) GOTO 3060
      DO 3050 I=1,NZC
      IR=IRC(I)
      IRH=IR
      IC=ICC(I)
      IF(LBAND) IRH=ML+MU+IR-IC+1
      B(IRH,IC)=B(IRH,IC)+SM(IC)*BC(I)/SM(IR)
3050  CONTINUE
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  SEMI-IMPLICIT EULER STARTING STEP
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
3060  DO 3070 I=1,N
      YM(I)=Y(I)
3070  DEL(I)=G*DZ(I)
C
      IFAIL=0
      IF(LFULL) CALL LINGL(N,B,IPIVOT,DEL,IFAIL)
      IF(LBAND) CALL DGBFA(B,MBH,N,ML,MU,IPIVOT,IFAIL)
      IF(LBAND) CALL DGBSL(B,MBH,N,ML,MU,IPIVOT,DEL,JOB)
      NDEC=NDEC+1
      NSOL=NSOL+1
      IF(IFAIL.NE.0) GOTO 4100
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C       CHECK FOR SYSTEMS WITH NILPOTENCY GREATER THAN ONE
C       AND/OR INCONSISTENT INITIAL VALUES
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      IF(IJOB(1).EQ.1.OR.J.GT.2.OR.NSTEP.GT.2) GOTO 3140
      IF(J.GT.1) GOTO 3110
      DELM=ZERO
      DO 3100 I=1,N
      W3(I)=DABS(DEL(I))
3100  IF(W3(I).GT.DELM)DELM=W3(I)
      GOTO 3140
3110  DO 3120 I=1,N
      IF(DEL(I).EQ.ZERO) GOTO 3120
      IF(DABS(DEL(I)).LT.SMALL) GOTO 3120
      W3(I)=W3(I)/DABS(DEL(I))
      IF(DABS(W3(I)).GT.EX2) GOTO 3120
      IF(IJOB(6).GT.2.AND.NSTEP.EQ.0.AND.JRED.EQ.0) WRITE(LOUT,9140)I
      IF(W3(I)*DABS(DEL(I)).GT.DELM*THRESH.AND.JRED.GT.2) GOTO 3130
3120  CONTINUE
      GOTO 3140
3130  IF(W3(I).LT.EX1) GOTO 4750
      GOTO 4760
C
3140  CONTINUE
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  SEMI-IMPLICIT EULER DISCRETIZATION (ITERATIVE REALISATION)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      DO 3150  I=1,N
3150  YM(I)=YM(I)+DEL(I)*SM(I)
      IF(M.EQ.1) GOTO 3300
      M=M-1
C
C
      DO 3299 K=1,M
      TH=T+DFLOAT(K)*G
3155  CALL FCN (N,NZV,TH,YM,DEL,BVK,IRV,ICV)
      NFCN=NFCN+1
      IF(K.GT.1.OR.LDIR) GOTO 3170
      DIFFB=ZERO
      IF(IJOB(8).EQ.1) GOTO 3170
      DO 3160 I=1,NZV
      IR=IRV(I)
      IC=ICV(I)
      DIFF=BVK(I)-BV0(I)
      DIFFB=DIFFB+DIFF*DIFF*SM(IC)*SM(IC)/SM(IR)/SM(IR)
3160  CONTINUE
      DIFFB=DSQRT(DIFFB/DFLOAT(NZV))
      DIFFB=DFLOAT(M)*DIFFB
3170  DO 3180 I=1,N
3180  DEL(I)=G*DEL(I)/SM(I)
C
      IF(LDIR) GOTO 3200
      IF(LFULL) CALL SUBST (N,B,IPIVOT,DEL)
      IF(LBAND) CALL DGBSL (B,MBH,N,ML,MU,IPIVOT,DEL,JOB)
      NSOL=NSOL+1
      IF(IJOB(8).NE.1.AND.DIFFB.GT.RTOL*1.D-2) GOTO 3184
      GOTO 3290
3184  ITFAIL=0
      DO 3188 I=1,N
3188  W1(I)=DEL(I)
      CALL ITER2 (N,NZV,MBH,KOH,B,BV0,BVK,DEL,SM,W1,
     1             W2,IJOB,IPIVOT,IRV,ICV,RTOL,ITFAIL,
     2             THETA,DELTA,IEST,FNH,LFULL,LBAND,
     3             ITER,COSTQ)
C
      IEST=0
      IF(IJOB(6).GE.4) WRITE(LOUT,9321) K,ITER,ITFAIL,THETA,DELTA
C
      IF(ITFAIL.GE.1) LDIR=.TRUE.
      IF(ITFAIL.GT.1) GOTO 3155
      GOTO 3290
C
3200  CONTINUE
      DO 3220 I=1,MB
      DO 3210 KL=1,N
      B(ML+I,KL)=G*A(I,KL)
3210  CONTINUE
3220  CONTINUE
      IF(IJOB(8).EQ.1) GOTO 3240
      DO 3230 I=1,NZV
      IR=IRV(I)
      IRH=IR
      IC=ICV(I)
      IF(LBAND) IRH=ML+MU+IR-IC+1
      B(IRH,IC)=B(IRH,IC)+SM(IC)*BVK(I)/SM(IR)
3230  CONTINUE
3240  IF(IJOB(8).EQ.2) GOTO 3260
      DO 3250 I=1,NZC
      IR=IRC(I)
      IRH=IR
      IC=ICC(I)
      IF(LBAND) IRH=ML+MU+IR-IC+1
      B(IRH,IC)=B(IRH,IC)+SM(IC)*BC(I)/SM(IR)
3250  CONTINUE
3260  CONTINUE
C
      IFAIL=0
      IF(LFULL) CALL LINGL(N,B,IPIVOT,DEL,IFAIL)
      IF(LBAND) CALL DGBFA(B,MBH,N,ML,MU,IPIVOT,IFAIL)
      IF(LBAND) CALL DGBSL(B,MBH,N,ML,MU,IPIVOT,DEL,JOB)
      NDEC=NDEC+1
      NSOL=NSOL+1
C
      IF(IJOB(6).GE.4) WRITE(LOUT,9329) K,IFAIL
C
      IF(IFAIL.NE.0) GOTO 4100
C
3290  CONTINUE
      IEST=0
      DO 3295 I=1,N
3295  YM(I)=YM(I)+DEL(I)*SM(I)
3299  CONTINUE
C
C ----------------------------------------------------------------------
C                           EXTRAPOLATION
C ----------------------------------------------------------------------
C
3300  ERR=ZERO
      DO 33201 I=1,N
      C=DEL(I)*SM(I)/G
      V=DTP(I,1)
      DTP(I,1)=C
      IF(J.EQ.1) GOTO 33201
      TA=C
      DO 33101 K=2,J
      JK=J-K+1
      B1=D(J,JK)
      W=C-V
      U=W/(B1-ONE)
      C=B1*U
      V=DTP(I,K)
      DTP(I,K)=U
33101 TA=U+TA
      YP(I)=TA
33201 CONTINUE
C
3301  CONTINUE
      DO 3320 I=1,N
      C=YM(I)
      V=DT(I,1)
      DT(I,1)=C
      IF(J.EQ.1) GOTO 3320
      TA=C
      DO 3310 K=2,J
      JK=J-K+1
      B1=D(J,JK)
      W=C-V
      U=W/(B1-ONE)
      C=B1*U
      V=DT(I,K)
      DT(I,K)=U
3310  TA=U+TA
      YM(I)=TA
      TA=DABS(TA)
      IF(TA.LT.SM(I)) TA=SM(I)
      U=U/TA
      ERR=ERR+U*U
3320  CONTINUE
      IF(J.EQ.1) GOTO 3000
C
C ERROR (SCALED ROOT MEAN SQUARE)
C -------------------------------
C
      ERR=DSQRT(ERR/FN)
      KONV=0
      IF(ERR.LE.RTOL) KONV=1
      ERR=ERR/EPH
C
C ----------------------------------------------------------------------
C                            ORDER CONTROL
C ----------------------------------------------------------------------
C
      K=J-1
      ROOT=ONE/DFLOAT(J)
      FC=ERR**ROOT
      IF(FC.LT.FCM) FC=FCM
C
C  OPTIMAL ORDER DETERMINATION
C  ---------------------------
C
      OMJ=FC*AJ(J)
      IF(J.GT.2.AND.OMJ*ONE1.GT.OMJO.OR.K.GT.JOH) GOTO 3340
      KO=K
      JO=J
      OMJO=OMJ
      FCO=FC
3340  CONTINUE
      IF(J.LT.KOH.AND.NSTEP.GT.0) GOTO 3000
      IF(KONV.EQ.0) GOTO 3360
      IF(KO.LT.K.OR.INCR(J).LT.0) GOTO 4500
C
C  POSSIBLE INCREASE OF ORDER
C  --------------------------
C
      IF(NRED(KO).GT.0) NRED(KO)=NRED(KO)-1
      FC=FCO/AL(J,K)
      IF(FC.LT.FCM) FC=FCM
      J1=J+1
      IF(AJ(J1)*FC*ONE1.GT.OMJO) GOTO 4500
      FCO=FC
      KO=JO
      JO=JO+1
      GOTO 4500
C
C ----------------------------------------------------------------------
C                            CONVERGENCE MONITOR
C ----------------------------------------------------------------------
C
3360  RED=ONE/FCO
      JK=KM
      IF(JOH.LT.KM) JK=JOH
      IF(K.GE.JK) GOTO 4000
      IF(KO.LT.KOH) RED=AL(KOH,KO)*RED
      IF(AL(JK,KO).LT.FCO) GOTO 4000
3000  CONTINUE
C
C  STEPSIZE REDUCTION (DUE TO EXTRAPOLATION TABLEAU)
C --------------------------------------------------
C
4000  RED=RED*SAFE
      IF(RED.GE.RMIN) RED=RMIN
      H=H*RED
4010  CONTINUE
      IF(NSTEP.EQ.0) GOTO 4020
      NRED(KOH)=NRED(KOH)+1
      INCR(KOH)=-2
4020  JRED=JRED+1
      IF(IJOB(6).GT.2) WRITE(LOUT,9080) JRED,RED
      IF(JRED.GT.JRMAX) GOTO 4700
      GOTO 2500
C
C  STEPSIZE REDUCTION (EMPIRICAL DEVICE)
C  -------------------------------------
C
4100  IF(IFAIL.GT.0.AND.IJOB(1).EQ.0) ISING=ISING+1
      IF(ISING.GT.ISMAX) GOTO 4730
      IF(NSTEP.EQ.0.AND.JRED.GT.2.AND.NSTC.GT.2) GOTO 4760
      HMAX=G*FJ1*QUART
      IF(IFAIL.GT.0) HMAX=HMAX*SAFE
      RED=HMAX/DABS(H)
      H=HMAX
      IF(JRED.GT.0.OR.IT.GT.0)GOTO 4020
      GOTO 4010
C
C ----------------------------------------------------------------------
C              PREPARATIONS FOR NEXT BASIC INTEGRATION STEP
C ----------------------------------------------------------------------
C
4500  TOLD=T
      T=TN
      H1=TEND-T
      DO 4510 I=1,N
      TA=YM(I)
      Y(I)=TA
C
C  RESCALING
C  ---------
C
      TA=DABS(TA)
      IF(TA.LT.SM(I)) GOTO 4510
      SM(I)=TA
4510  CONTINUE
      NSTEP=NSTEP+1
      IF(NSTEP.GT.NSTMAX) GO TO 4710
C
C
C STEPSIZE PREDICTION
C -------------------
C
      H=H/FCO
      KOH=KO
      JOH=KOH+1
      IF(DABS(H).GT.DABS(T)*EPMACH*TEN) GO TO 2000
      GO TO 4720
C
C ----------------------------------------------------------------------
C                             SOLUTION EXIT
C ----------------------------------------------------------------------
C
4600  H=HR
      HMAX=HMAXU
      IJOB(13)=NSTEP
      IJOB(9)=NFCN
      IJOB(10)=NDEC
      IJOB(11)=NSOL
      IJOB(12)=NFCNJ
      IF(IJOB(6).GE.3) WRITE(LOUT,9100) NSTEP,NFCN,T,H,K,KO
      IF(IJOB(6).EQ.2) WRITE(LOUT,9110) NSTEP,T
      IF(IJOB(7).GT.0) WRITE(LOUT,9150) T,(Y(I),I=1,N)
      RETURN
C
C ----------------------------------------------------------------------
C                               FAIL EXIT
C ----------------------------------------------------------------------
C
4700  CONTINUE
      IF(IJOB(6).GT.0)WRITE(LOUT,9120)JRMAX
      IJOB(6)=-1
      GOTO 4800
4710  CONTINUE
      IF(IJOB(6).GT.0) WRITE(LOUT,9090) NSTMAX
      IJOB(6)=-2
      GOTO 4800
4720  CONTINUE
      IF(IJOB(6).GT.0) WRITE(LOUT,9060)
      IJOB(6)=-3
      GOTO 4800
4730  CONTINUE
      IF(IJOB(6).GT.0) WRITE(LOUT,9070)
      IJOB(6)=-4
      GOTO 4800
4750  CONTINUE
      IF(IJOB(6).GT.0)WRITE(LOUT,9050)
      IJOB(6)=-6
      GOTO 4800
4760  CONTINUE
      IF(IJOB(6).GT.0)WRITE(LOUT,9130)
      IJOB(6)=-7
4800  H=ZERO
      HMAX=HMAXU
      RETURN
C
C ----------------------------------------------------------------------
C                  FORMAT-STATEMENTS
C ----------------------------------------------------------------------
C
9000  FORMAT(/,1X,' --- CURRENT VALUES --- ',/(1X,4D18.9),/)
9010  FORMAT(1X,' ------------------------------------------------------
     1----------------',/,
     2       1X,' -LIMEX- :  REL.PREC. ',D10.3,'   THRESHOLD ',D10.3,'
     3 MAX. COL. ',I3,/,
     4'  ---------------------------------------------------------------
     5-------',/)
9020  FORMAT(/,3X,'STEP',3X,'  F-CALLS',10X,'T',14X,'H',10X,
     *'USED/AIMED COLUMN',/)
9030  FORMAT(/,5X,'STEP',8X,'T')
9050  FORMAT(1X,' PROBLEM NOT SOLVABLE WITH LIMEX, PROBABLE REASON:',/1X
     *,' NILPOTENCY OF THE SYSTEM GREATER THAN ONE',/)
9060  FORMAT(/1X,' STEPSIZE REDUCTION FAILED TO SUCCEED '//)
9070  FORMAT(/1X,' THE MATRIX-PENCIL B-H*A IS SINGULAR, THE SYSTEM IS NO
     *T SOLVABLE',/)
9080  FORMAT(/1X,I3,'.REDUCTION, STEPSIZE REDUCTION FACTOR ',D10.3)
9090  FORMAT(1X,' MORE THAN NSTMAX=',I3,' INTEGRATION STEPS'//)
9100  FORMAT(/1X,I5,2X,I9,3X,D15.5,2X,D15.5,I9,I9)
9110  FORMAT(/1X,I7,2X,D15.5)
9120  FORMAT(1X,' MORE THAN JRMAX=',I3,' STEPSIZE REDUCTIONS DUE TO EXTR
     *APOLATION TABLEAU')
9130  FORMAT(1X,' PROBLEM NOT SOLVABLE WITH LIMEX, PROBABLE REASON:',/1X
     *,' INITIAL DATA INCONSISTENT OR NILPOTENCY OF THE SYSTEM GREATER T
     *HAN ONE',/)
9140  FORMAT(1X,' *** WARNING *** '/1X,' COMPONENT',I5,'    DOES NOT HAV
     *E AN ASYMPTOTIC ',/1X,' EXPANSION IN THE INITIALIZATION PHASE '/)
9150  FORMAT(/1X,' *** SOLUTION AT T   =',D18.9,' ***',/(1X,4D18.9))
9160  FORMAT(1X,' *** INITIAL VALUES *** ',/(1X,4D18.9))
9315  FORMAT(/,2X,'     K  ITER  FAIL',8X,'THETA',7X,'DELTA0')
9321  FORMAT(2X,3I6,2D13.3)
9329  FORMAT(2X,I6,6X,I6)
C
C ----------------------------------------------------------------------
C                  END OF CORE-INTEGRATOR LIMEX1
C ----------------------------------------------------------------------
C
      END
      SUBROUTINE ITER2 (N,NZV,MBH,KO,B,BV0,BVK,DEL,SM,W1,W2,
     1                  IJOB,IPIVOT,IRV,ICV,RTOL,ITFAIL,
     2                  THETA,DELTA,IEST,FNH,LFULL,LBAND,
     3                  ITER,COSTQ)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C ----------------------------------------------------------------------
C   SUBROUTINE ITERAT PERFORMS THE ITERATIVE REALIZATION OF THE
C   DISCRETIZATION FOR VARIABLE LEFT-HAND-SIDE MATRIX B(T,Y)
C ----------------------------------------------------------------------
C
      DIMENSION B(MBH,N),BV0(NZV),BVK(NZV),DEL(N),SM(N),W1(N),
     1          W2(N),IJOB(13),IPIVOT(N),IRV(NZV),ICV(NZV)
C
      LOGICAL LFULL,LBAND
C
      COMMON/LIMX4/NSOL
      COMMON/LIMX1/LOUT
C
      DATA ZERO/0.D0/
      DATA THTMX1/.25D0/ , THTMX2/.50D0/ , DELMX1/.25D0/ , DELMX2/.5D0/
C
C  PREPARATIONS
C  ------------
C
      JOB=0
      ITOPT=IFIX(SNGL(COSTQ))
      ITMAX=2*ITOPT
      IF(LBAND) ML=IJOB(4)
      IF(LBAND) MU=IJOB(5)
      IF(LBAND) ML1=ML+1
      ITER=1
      THETA=ZERO
      DELTA=ZERO
      IF(IEST.EQ.1) DELMAX=DELMX1
      IF(IEST.EQ.1) THTMAX=THTMX1
      IF(IEST.EQ.0) DELMAX=DELMX2
      IF(IEST.EQ.0) THTMAX=THTMX2
C
C  DESCALE INITIAL VALUE OF ITERATION
C  ----------------------------------
C
      IF(IJOB(6).GT.4.AND.IEST.EQ.1) WRITE(LOUT,150)
      DO 10 I=1,N
10    W2(I)=W1(I)*SM(I)
C
C  COMPUTATION OF DELTA-B*X
C  ------------------------
C
20    DO 30 I=1,N
      W1(I)=ZERO
30    CONTINUE
      DO 40  I=1,NZV
      IC=ICV(I)
      IR=IRV(I)
      W1(IR)=W1(IR)+(BV0(I)-BVK(I))*W2(IC)
40    CONTINUE
      DO 50 I=1,N
50    W1(I)=W1(I)/SM(I)
C
C  SOLUTION OF THE LINEAR EQUATION
C  -------------------------------
C
      IF(LFULL) CALL SUBST(N,B,IPIVOT,W1)
      IF(LBAND) CALL DGBSL(B,MBH,N,ML,MU,IPIVOT,W1,JOB)
      NSOL=NSOL+1
C
C  ERROR ESTIMATION AND CALCULATION OF STEPSIZE CONTROL PARAMETERS
C  ---------------------------------------------------------------
C
      ERR=ZERO
      DO 80 I=1,N
80    ERR=ERR+W1(I)*W1(I)
      ERR=DSQRT(ERR/DFLOAT(N))
      IF(ITER.GT.2) GOTO 100
      IF(ITER.EQ.1 .AND. ERR.GT.DELMAX) GOTO 220
      IF(ITER.EQ.1) GOTO 90
      THETA=ERR/DELTA
      IF(THETA.GT.THTMAX) GOTO 230
      IF(IEST.EQ.0) GOTO 100
      ZZ=THETA**DFLOAT(ITOPT+2)*DELTA
      IF(ZZ.GT.RTOL*1.D-1) GOTO 240
      GOTO 100
90    DELTA=ERR
C
100   IF(IJOB(6).GT.4.AND.IEST.EQ.1) WRITE(LOUT,160) ITER,ERR
      IF(ERR.LE.RTOL*1.D-1) GOTO 130
      ITER=ITER+1
      DO 110 I=1,N
      DEL(I)=DEL(I)+W1(I)
110   W2(I)=W1(I)*SM(I)
      IF(ITER.LE.ITMAX) GOTO 20
      GOTO 250
C
C  SOLUTION EXIT
C  -------------
C
130   DO 140 I=1,N
140   DEL(I)=DEL(I)+W1(I)
      ITFAIL=0
      IF(IEST.EQ.1 .AND. ITER.GT.ITOPT) ITFAIL=1
      RETURN
C
C  FAIL EXITS
C------------
C
220   ITFAIL=2
      RETURN
C
230   ITFAIL=3
      RETURN
C
240   ITFAIL=4
      RETURN
C
250   ITFAIL=5
      RETURN
C
150   FORMAT(10X,' ####       ITER           ERROR      ####')
160   FORMAT(10X,' ####      ',I4,7X,D12.4,'    ####')
C
C ----------------------------------------------------------------------
C                    END OF SUBROUTINE ITERAT
C ----------------------------------------------------------------------
C
      END
      SUBROUTINE RESLIM (NEQ,NZV,T,U,URHS,URES,BV,IR,IC,UP,FCN,IJOB)
C
C*********************************************************************
C
C  COMPUTES RESIDUAL
C
C*********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C
      DIMENSION U(NEQ),URHS(NEQ),URES(NEQ),UP(NEQ)
      DIMENSION BV(NZV),IR(NZV),IC(NZV)
      DIMENSION IJOB(13)
C
      EXTERNAL FCN
C
      CALL FCN (NEQ,NZV,T,U,URHS,BV,IR,IC)
C
      DO 100 I=1,NEQ
      URES(I)=URHS(I)
100   CONTINUE
C
      IF(IJOB(8).EQ.1) RETURN
C
      DO 200 I=1,NZV
      ICH=IC(I)
      IRH=IR(I)
      URES(IRH)=URES(IRH)-BV(I)*UP(ICH)
200   CONTINUE
C
      RETURN
      END
      SUBROUTINE DGBFA(ABD,LDA,N,ML,MU,IPVT,INFO)
      INTEGER LDA,N,ML,MU,IPVT(1),INFO
      DOUBLE PRECISION ABD(LDA,1)
C
C     dgbfa factors a double precision band matrix by elimination.
C
C     dgbfa is usually called by dgbco, but it can be called
C     directly with a saving in time if  rcond  is not needed.
C
C     on entry
C
C        abd     double precision(lda, n)
C                contains the matrix in band storage.  the columns
C                of the matrix are stored in the columns of  abd  and
C                the diagonals of the matrix are stored in rows
C                ml+1 through 2*ml+mu+1 of  abd .
C                see the comments below for details.
C
C        lda     integer
C                the leading dimension of the array  abd .
C                lda must be .ge. 2*ml + mu + 1 .
C
C        n       integer
C                the order of the original matrix.
C
C        ml      integer
C                number of diagonals below the main diagonal.
C                0 .le. ml .lt. n .
C
C        mu      integer
C                number of diagonals above the main diagonal.
C                0 .le. mu .lt. n .
C                more efficient if  ml .le. mu .
C     on return
C
C        abd     an upper triangular matrix in band storage and
C                the multipliers which were used to obtain it.
C                the factorization can be written  a = l*u  where
C                l  is a product of permutation and unit lower
C                triangular matrices and  u  is upper triangular.
C
C        ipvt    integer(n)
C                an integer vector of pivot indices.
C
C        info    integer
C                = 0  normal value.
C                = k  if  u(k,k) .eq. 0.0 .  this is not an error
C                     condition for this subroutine, but it does
C                     indicate that dgbsl will divide by zero if
C                     called.  use  rcond  in dgbco for a reliable
C                     indication of singularity.
C
C     band storage
C
C           if  a  is a band matrix, the following program segment
C           will set up the input.
C
C                   ml = (band width below the diagonal)
C                   mu = (band width above the diagonal)
C                   m = ml + mu + 1
C                   do 20 j = 1, n
C                      i1 = max0(1, j-mu)
C                      i2 = min0(n, j+ml)
C                      do 10 i = i1, i2
C                         k = i - j + m
C                         abd(k,j) = a(i,j)
C                10    continue
C                20 continue
C
C           this uses rows  ml+1  through  2*ml+mu+1  of  abd .
C           in addition, the first  ml  rows in  abd  are used for
C           elements generated during the triangularization.
C           the total number of rows needed in  abd  is  2*ml+mu+1 .
C           the  ml+mu by ml+mu  upper left triangle and the
C           ml by ml  lower right triangle are not referenced.
C
C     linpack. this version dated 08/14/78 .
C     cleve moler, university of new mexico, argonne national lab.
C
C     subroutines and functions
C
C     blas daxpy,dscal,idamax
C     fortran max0,min0
C
C     internal variables
C
      DOUBLE PRECISION T
      INTEGER I,IDAMAX,I0,J,JU,JZ,J0,J1,K,KP1,L,LM,M,MM,NM1
C
C
      M = ML + MU + 1
      INFO = 0
C
C     zero initial fill-in columns
C
      J0 = MU + 2
      J1 = MIN0(N,M) - 1
      IF (J1 .LT. J0) GO TO 30
      DO 20 JZ = J0, J1
         I0 = M + 1 - JZ
         DO 10 I = I0, ML
            ABD(I,JZ) = 0.0D0
   10    CONTINUE
   20 CONTINUE
   30 CONTINUE
      JZ = J1
      JU = 0
C
C     gaussian elimination with partial pivoting
C
      NM1 = N - 1
      IF (NM1 .LT. 1) GO TO 130
      DO 120 K = 1, NM1
         KP1 = K + 1
C
C        zero next fill-in column
C
         JZ = JZ + 1
         IF (JZ .GT. N) GO TO 50
         IF (ML .LT. 1) GO TO 50
            DO 40 I = 1, ML
               ABD(I,JZ) = 0.0D0
   40       CONTINUE
   50    CONTINUE
C
C        find l = pivot index
C
         LM = MIN0(ML,N-K)
         L = IDAMAX(LM+1,ABD(M,K),1) + M - 1
         IPVT(K) = L + K - M
C
C        zero pivot implies this column already triangularized
C
         IF (ABD(L,K) .EQ. 0.0D0) GO TO 100
C
C           interchange if necessary
C
            IF (L .EQ. M) GO TO 60
               T = ABD(L,K)
               ABD(L,K) = ABD(M,K)
               ABD(M,K) = T
   60       CONTINUE
C
C           compute multipliers
C
            T = -1.0D0/ABD(M,K)
            CALL DSCAL(LM,T,ABD(M+1,K),1)
C
C           row elimination with column indexing
C
            JU = MIN0(MAX0(JU,MU+IPVT(K)),N)
            MM = M
            IF (JU .LT. KP1) GO TO 90
            DO 80 J = KP1, JU
               L = L - 1
               MM = MM - 1
               T = ABD(L,J)
               IF (L .EQ. MM) GO TO 70
                  ABD(L,J) = ABD(MM,J)
                  ABD(MM,J) = T
   70          CONTINUE
               CALL DAXPY(LM,T,ABD(M+1,K),1,ABD(MM+1,J),1)
   80       CONTINUE
   90       CONTINUE
         GO TO 110
  100    CONTINUE
            INFO = K
  110    CONTINUE
  120 CONTINUE
  130 CONTINUE
      IPVT(N) = N
      IF (ABD(M,N) .EQ. 0.0D0) INFO = N
      RETURN
      END
C
      SUBROUTINE DGBSL(ABD,LDA,N,ML,MU,IPVT,B,JOB)
      INTEGER LDA,N,ML,MU,IPVT(1),JOB
      DOUBLE PRECISION ABD(LDA,1),B(1)
C
C     dgbsl solves the double precision band system
C     a * x = b  or  trans(a) * x = b
C     using the factors computed by dgbco or dgbfa.
C
C     on entry
C
C        abd     double precision(lda, n)
C                the output from dgbco or dgbfa.
C
C        lda     integer
C                the leading dimension of the array  abd .
C
C        n       integer
C                the order of the original matrix.
C
C        ml      integer
C                number of diagonals below the main diagonal.
C
C        mu      integer
C                number of diagonals above the main diagonal.
C
C        ipvt    integer(n)
C                the pivot vector from dgbco or dgbfa.
C
C        b       double precision(n)
C                the right hand side vector.
C
C        job     integer
C                = 0         to solve  a*x = b ,
C                = nonzero   to solve  trans(a)*x = b , where
C                            trans(a)  is the transpose.
C
C     on return
C
C        b       the solution vector  x .
C
C     error condition
C
C        a division by zero will occur if the input factor contains a
C        zero on the diagonal.  technically this indicates singularity
C        but it is often caused by improper arguments or improper
C        setting of lda .  it will not occur if the subroutines are
C        called correctly and if dgbco has set rcond .gt. 0.0
C        or dgbfa has set info .eq. 0 .
C
C     to compute  inverse(a) * c  where  c  is a matrix
C     with  p  columns
C           call dgbco(abd,lda,n,ml,mu,ipvt,rcond,z)
C           if (rcond is too small) go to ...
C           do 10 j = 1, p
C              call dgbsl(abd,lda,n,ml,mu,ipvt,c(1,j),0)
C        10 continue
C
C     linpack. this version dated 08/14/78 .
C     cleve moler, university of new mexico, argonne national lab.
C
C     subroutines and functions
C
C     blas daxpy,ddot
C     fortran min0
C
C     internal variables
C
      DOUBLE PRECISION DDOT,T
      INTEGER K,KB,L,LA,LB,LM,M,NM1
C
      M = MU + ML + 1
      NM1 = N - 1
      IF (JOB .NE. 0) GO TO 50
C
C        job = 0 , solve  a * x = b
C        first solve l*y = b
C
         IF (ML .EQ. 0) GO TO 30
         IF (NM1 .LT. 1) GO TO 30
            DO 20 K = 1, NM1
               LM = MIN0(ML,N-K)
               L = IPVT(K)
               T = B(L)
               IF (L .EQ. K) GO TO 10
                  B(L) = B(K)
                  B(K) = T
   10          CONTINUE
               CALL DAXPY(LM,T,ABD(M+1,K),1,B(K+1),1)
   20       CONTINUE
   30    CONTINUE
C
C        now solve  u*x = y
C
         DO 40 KB = 1, N
            K = N + 1 - KB
            B(K) = B(K)/ABD(M,K)
            LM = MIN0(K,M) - 1
            LA = M - LM
            LB = K - LM
            T = -B(K)
            CALL DAXPY(LM,T,ABD(LA,K),1,B(LB),1)
   40    CONTINUE
      GO TO 100
   50 CONTINUE
C
C        job = nonzero, solve  trans(a) * x = b
C        first solve  trans(u)*y = b
C
         DO 60 K = 1, N
            LM = MIN0(K,M) - 1
            LA = M - LM
            LB = K - LM
            T = DDOT(LM,ABD(LA,K),1,B(LB),1)
            B(K) = (B(K) - T)/ABD(M,K)
   60    CONTINUE
C
C        now solve trans(l)*x = y
C
         IF (ML .EQ. 0) GO TO 90
         IF (NM1 .LT. 1) GO TO 90
            DO 80 KB = 1, NM1
               K = N - KB
               LM = MIN0(ML,N-K)
               B(K) = B(K) + DDOT(LM,ABD(M+1,K),1,B(K+1),1)
               L = IPVT(K)
               IF (L .EQ. K) GO TO 70
                  T = B(L)
                  B(L) = B(K)
                  B(K) = T
   70          CONTINUE
   80       CONTINUE
   90    CONTINUE
  100 CONTINUE
      RETURN
      END
      SUBROUTINE DAXPY(N,DA,DX,INCX,DY,INCY)
C
C     constant times a vector plus a vector.
C     uses unrolled loops for increments equal to one.
C     jack dongarra, linpack, 3/11/78.
C
      DOUBLE PRECISION DX(1),DY(1),DA
      INTEGER I,INCX,INCY,IX,IY,M,MP1,N
C
      IF(N.LE.0)RETURN
      IF (DA .EQ. 0.0D0) RETURN
      IF(INCX.EQ.1.AND.INCY.EQ.1)GO TO 20
C
C        code for unequal increments or equal increments
C          not equal to 1
C
      IX = 1
      IY = 1
      IF(INCX.LT.0)IX = (-N+1)*INCX + 1
      IF(INCY.LT.0)IY = (-N+1)*INCY + 1
      DO 10 I = 1,N
        DY(IY) = DY(IY) + DA*DX(IX)
        IX = IX + INCX
        IY = IY + INCY
   10 CONTINUE
      RETURN
C
C        code for both increments equal to 1
C
C
C        clean-up loop
C
   20 M = MOD(N,4)
      IF( M .EQ. 0 ) GO TO 40
      DO 30 I = 1,M
        DY(I) = DY(I) + DA*DX(I)
   30 CONTINUE
      IF( N .LT. 4 ) RETURN
   40 MP1 = M + 1
      DO 50 I = MP1,N,4
        DY(I) = DY(I) + DA*DX(I)
        DY(I + 1) = DY(I + 1) + DA*DX(I + 1)
        DY(I + 2) = DY(I + 2) + DA*DX(I + 2)
        DY(I + 3) = DY(I + 3) + DA*DX(I + 3)
   50 CONTINUE
      RETURN
      END
      SUBROUTINE DSCAL(N,DA,DX,INCX)
C
C     scales a vector by a constant.
C     uses unrolled loops for increment equal to one.
C     jack dongarra, linpack, 3/11/78.
C
      DOUBLE PRECISION DA,DX(1)
      INTEGER I,INCX,M,MP1,N,NINCX
C
      IF(N.LE.0)RETURN
      IF(INCX.EQ.1)GO TO 20
C
C        code for increment not equal to 1
C
      NINCX = N*INCX
      DO 10 I = 1,NINCX,INCX
        DX(I) = DA*DX(I)
   10 CONTINUE
      RETURN
C
C        code for increment equal to 1
C
C
C        clean-up loop
C
   20 M = MOD(N,5)
      IF( M .EQ. 0 ) GO TO 40
      DO 30 I = 1,M
        DX(I) = DA*DX(I)
   30 CONTINUE
      IF( N .LT. 5 ) RETURN
   40 MP1 = M + 1
      DO 50 I = MP1,N,5
        DX(I) = DA*DX(I)
        DX(I + 1) = DA*DX(I + 1)
        DX(I + 2) = DA*DX(I + 2)
        DX(I + 3) = DA*DX(I + 3)
        DX(I + 4) = DA*DX(I + 4)
   50 CONTINUE
      RETURN
      END
      DOUBLE PRECISION FUNCTION DDOT(N,DX,INCX,DY,INCY)
C
C     forms the dot product of two vectors.
C     uses unrolled loops for increments equal to one.
C     jack dongarra, linpack, 3/11/78.
C
      DOUBLE PRECISION DX(1),DY(1),DTEMP
      INTEGER I,INCX,INCY,IX,IY,M,MP1,N
C
      DDOT = 0.0D0
      DTEMP = 0.0D0
      IF(N.LE.0)RETURN
      IF(INCX.EQ.1.AND.INCY.EQ.1)GO TO 20
C
C        code for unequal increments or equal increments
C          not equal to 1
C
      IX = 1
      IY = 1
      IF(INCX.LT.0)IX = (-N+1)*INCX + 1
      IF(INCY.LT.0)IY = (-N+1)*INCY + 1
      DO 10 I = 1,N
        DTEMP = DTEMP + DX(IX)*DY(IY)
        IX = IX + INCX
        IY = IY + INCY
   10 CONTINUE
      DDOT = DTEMP
      RETURN
C
C        code for both increments equal to 1
C
C
C        clean-up loop
C
   20 M = MOD(N,5)
      IF( M .EQ. 0 ) GO TO 40
      DO 30 I = 1,M
        DTEMP = DTEMP + DX(I)*DY(I)
   30 CONTINUE
      IF( N .LT. 5 ) GO TO 60
   40 MP1 = M + 1
      DO 50 I = MP1,N,5
        DTEMP = DTEMP + DX(I)*DY(I) + DX(I + 1)*DY(I + 1) +
     *   DX(I + 2)*DY(I + 2) + DX(I + 3)*DY(I + 3) + DX(I + 4)*DY(I + 4)
   50 CONTINUE
   60 DDOT = DTEMP
      RETURN
      END
      INTEGER FUNCTION IDAMAX(N,DX,INCX)
C
C     finds the index of element having max. absolute value.
C     jack dongarra, linpack, 3/11/78.
C
      DOUBLE PRECISION DX(1),DMAX
      INTEGER I,INCX,IX,N
C
      IDAMAX = 0
      IF( N .LT. 1 ) RETURN
      IDAMAX = 1
      IF(N.EQ.1)RETURN
      IF(INCX.EQ.1)GO TO 20
C
C        code for increment not equal to 1
C
      IX = 1
      DMAX = DABS(DX(1))
      IX = IX + INCX
      DO 10 I = 2,N
         IF(DABS(DX(IX)).LE.DMAX) GO TO 5
         IDAMAX = I
         DMAX = DABS(DX(IX))
    5    IX = IX + INCX
   10 CONTINUE
      RETURN
C
C        code for increment equal to 1
C
   20 DMAX = DABS(DX(1))
      DO 30 I = 2,N
         IF(DABS(DX(I)).LE.DMAX) GO TO 30
         IDAMAX = I
         DMAX = DABS(DX(I))
   30 CONTINUE
      RETURN
      END
      SUBROUTINE LINGL(N,A,IPI,X,IFAIL)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C     SOLUTION OF A SYSTEM OF LINEAR EQUATIONS, A*X = B, BY GAUSSIAN
C     ELIMINATION WITH PARTIAL PIVOTING.
      DIMENSION A(N,N),X(N)
      INTEGER IPI(N)
C
      DATA  ZERO/0.D0/
C
C     TRIANGULAR DECOMPOSITION
      DO 30 K=1,N
      P=ZERO
      DO 40 J=K,N
      IF (DABS(A(J,K))-DABS(P)) 40,40,50
 50   P=A(J,K)
      I=J
 40   CONTINUE
C
      IF(DABS(P))60,60,70
C
C     FAILURE EXIT
 60   IFAIL=1
      RETURN
C
 70   R=X(I)
      IF (I-K) 80,90,80
 80   X(I)=X(K)
      DO 100 J=1,N
      Q=A(I,J)
      A(I,J)=A(K,J)
 100  A(K,J)=Q
 90   IPI(K)=I
      X(K)=R
      K1=K+1
      IF(K1-N) 105,105,30
 105  DO 110 I=K1,N
      Q=A(I,K)
      IF (Q.EQ.ZERO) GOTO 110
      Q=Q/P
      A(I,K)=Q
      X(I)=X(I)-Q*R
      IF(K1-N) 115,115,110
 115  DO 120 J=K1,N
 120  A(I,J)=A(I,J)-Q*A(K,J)
 110  CONTINUE
  30  CONTINUE
C
      K=N
 140  Q=X(K)
      IF (K.EQ.N) GOTO 125
      K1=K+1
      DO 130 I=K1,N
 130  Q=Q-A(K,I)*X(I)
 125  X(K)=Q/A(K,K)
      K=K-1
      IF (K) 150,150,140
 150  RETURN
      END
      SUBROUTINE SUBST (N,A,IPI,X)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C     SOLUTION OF A SYSTEM OF LINEAR EQUATIONS, A*X = B, BY GAUSSIAN
C     ELIMINATION WITH THE MATRIX IN DECOMPOSED FORM. THE LATTER,
C     E.G. IS PRODUCED BY A CALL OF PROCEDURE LINGL PROVIDED THE
C     EXIT IFAIL IS NOT USED
      DIMENSION A(N,N),X(N)
      INTEGER IPI(N)
      DO 1 K=1,N
      I=IPI(K)
      J=K-1
      Q=X(I)
      IF(I.EQ.K) GOTO 10
      X(I)=X(K)
      X(K)=Q
10    IF(J.EQ.0) GOTO 1
      DO 11 I=1,J
11    Q=Q-A(K,I)*X(I)
1     X(K)=Q
      N1=N+1
      DO 2 KK=1,N
      K=N1-KK
      Q=X(K)
      IF(KK.EQ.1) GOTO 2
      K1=K+1
      DO 21 I=K1,N
21    Q=Q-A(K,I)*X(I)
2     X(K)=Q/A(K,K)
      RETURN
      END
