(*
 * FileName:   wrtlib.pas
 * $Source: E:/usr/src/c-code/pascal/RCS/LIB/wrtlib.pas,v $
 * $Author: wjw $
 * $Date: 1993/11/03 15:55:06 $
 * $Locker: wjw $
 * $State: Exp $
 * $Revision: 1.1 $
 * Description:
D*      Part of the runtime library which comes with PASCAL for OS/2
D*      
 *
 * History:
 *      First created by Willem Jan Withagen ( wjw@eb.ele.tue.nl ),
 *                    on Mon July 26 23:30:03 MET 1993
 * Copyright:
 *      Copyright (c) 1993 by Willem Jan Withagen and 
 *                      Digital Information Systems group, TUE
 *      For copying and distribution information see the file COPYRIGHT.
 *
 *)

program wrtlib;
(* MODULE paslib; *)

(* Once this all will be transformed into the PASCAL runtime lib.
(* Currently it is included in every file being translated.
(* And it s being run through the preprocessor first, which does not know
(* about pascal comments. So be carefull with ''s.
(*
(* Notes/limitations:
(*   OS/2:
(*      Maybe I should know beter, but I''m using native OS/2 calls. (wjw)
(*
(*   File I/O:
(*      Although the compiler knows about files, currently the only files 
(*      known are output for writes, input for read. And these are hard coded
(*      into the routines
(*      The runtime lib itself can use file handle 2 as 'stderr'.
(*       
(*      Upon input we assume that input lines are less than 256 chars.
(*      Otherwise routines will break.
(*
(*   Standard routines:
(*      The standard routines are Currently generated by the backend with TWO
(*      leading $''s in the name. This means that here we should only use ONE,
(*      the second one gets added by the compiler.
(*
(*   Local Routines:
(*      Routines to be used only in this module have a '_' prepended to their
(*      name. 
(*
(*   Coding:
(*   1) I''m trying to code this a simple as possible. The reason for this is 
(*      that is library is also used to run the compiler testfiles. And if 
(*      things are hairy in the lib, then it is hard to figure out where the 
(*      real errors are. (And currently WITH-stat are not implemented, so 
(*      complex records do not serve any purpose.)
(*   2) Also is the alignment of local data done manually, since there is
(*      still a bug(read not implemented) in the local allocation.
(*   3) Sets are neither implemented
(*   4) So are CASE-statements.
 *)
const
    _in                 = 0;
    _out                = 1;
    _error              = 2;
    _Boolean_Write_Size = 5;
    _Max_buf            = 256;
type
    _str  = array [1..8] of char;  (* Make it bigger than the default non copy 
                                   (* REF value *)
    word = integer;
var 
    _WBuf : array [1.._Max_buf] of char;
    
(* Used parts of OS/2 *)    
FUNCTION  Dos32Write( fhdl: word;      (* Handle to write to *)
                      str: _str;       (* String to write *)
                      cnt: word;       (* Number of bytes to write *)
                      VAR  rcnt: word  (* Actual number written *)
                      ):word; external;
                      
FUNCTION  Dos32Read ( fhdl: word;      (* Handle to read from *)
                      str: _str;       (* String to read into *)
                      cnt: word;       (* Number of bytes to read *)
                      VAR  rcnt: word  (* Actual number read *)
                      ):word; external;
                      
(* And somethings coded in assembler *)
          (* Copy a piece of memory, but it should not overlap *)
procedure $memcopy(VAR source, dest :_str; size :word ); external;

(* The most simple part of the library.
(* Getting this to compile right allow testing of a large part of the 
(* test files 
(* They don''t need an extra '$', since they get called straight from the
(* pascal code.
 *)
procedure WrtWrong;
var
    _rc  :word;
    rcnt :word;
begin
     _WBuf := 'wrong'
    ;_WBuf[6] := chr(13)
    ;_WBuf[7] := chr(10)
    ;_rc := Dos32Write( _out, _WBuf, 7, rcnt)
end;

procedure WrtOke;
var
    _rc  :word;
    rcnt :word;
begin
     _WBuf := 'oke'
    ;_WBuf[4] := chr(13)
    ;_WBuf[5] := chr(10)
    ;_rc := Dos32Write( _out, _WBuf, 5, rcnt)
end;

begin
end.
(*
 * $Log: wrtlib.pas,v $
 * Revision 1.1  1993/11/03  15:55:06  wjw
 * Started adminstration for the RUNTIME LIB
 *
 *
 *      First created by Willem Jan Withagen ( wjw@eb.ele.tue.nl ),
 *                    on Mon July 26 23:30:03 MET 1993
 *)
