ARCHCFLAGS	=	-DSYSVSIGNAL -DSYSVSTR -DNOGETDTBLSIZ -DNOTMPNAM -DNOWAIT3 -DNOSOCKOPT -DNOWAITPID
ARCHDLIB	=  ../../implib/so32.a ../../implib/xdr.a ../../implib/tcp32.a
ARCHDOBJ	=
ARCHLIB 	=  ../../implib/so32.a ../../implib/xdr.a ../../implib/tcp32.a
HASRANLIB	=	f
PVM_ARCH	=	OS2

#
# Generic Makefile body to be concatenated to config header.
#
# Imports:
#  PVM_ARCH   = the official pvm-name of your processor
#  ARCHCFLAGS = special cc flags
#  ARCHLIB    = special libs needed for daemon
#
SHELL	=	cmd.exe
CC	=	gcc
SDIR	=	..
PVMIDIR	=	../../include
PVMLDIR	=	../../lib/$(PVM_ARCH)
PVMLIB	=	$(PVMLDIR)/libpvm3.a
CFLAGS	=	-O2 -DIMA_$(PVM_ARCH) -I$(PVMIDIR) -L$(PVMLDIR) $(ARCHCFLAGS)
LIBS	=	$(PVMLIB) $(ARCHLIB)
OBJ	=	cons.o cmds.o job.o

default:	pvm.exe

install:	pvm.exe $(PVMLDIR)
	mv pvm.exe $(PVMLDIR)

$(PVMLDIR):
	- mkdir $(PVMLDIR)

pvm.exe:	$(OBJ)
	$(CC) $(CFLAGS) -o pvm.exe $(OBJ) $(LIBS)
	emxbind -s pvm.exe

cons.o:	$(SDIR)/cons.c
	$(CC) $(CFLAGS) -c $(SDIR)/cons.c
cmds.o:	$(SDIR)/cmds.c
	$(CC) $(CFLAGS) -c $(SDIR)/cmds.c
job.o:	$(SDIR)/job.c
	$(CC) $(CFLAGS) -c $(SDIR)/job.c

clean:
	rm -f *.o pvm.exe

cmds.o: $(SDIR)/cmd.h
cmds.o: $(SDIR)/myalloc.h
cmds.o: $(SDIR)/../src/listmac.h
cmds.o: $(SDIR)/../src/bfunc.h
cmds.o: $(SDIR)/job.h
cons.o: $(SDIR)/cmd.h
cons.o: $(SDIR)/myalloc.h
cons.o: $(SDIR)/../src/listmac.h
cons.o: $(SDIR)/../src/bfunc.h
cons.o: $(SDIR)/job.h
job.o: $(SDIR)/myalloc.h
job.o: $(SDIR)/job.h
job.o: $(SDIR)/../src/listmac.h
job.o: $(SDIR)/../src/bfunc.h
