/* save.c
   make the file save dialog popup, and manage it. */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing Services Office                      */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#include <stdio.h>
#include <ctype.h>


#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Shell.h>

#include "gopher.h"
#include "resources.h"
#include "xglobals.h"
#include "gui.h"


static	char	 fileToSave[PATH_NAME_LEN];

static Widget	topLevel;
Widget		saveDialogShell,
		saveDialog;


/* saveOkProc
   accept file name and complete the save command */

void
saveOkProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	int	c;
	char	*oldFile = fileToSave;
	char	*newFile, *p;
	FILE	*inFP, *outFP;

	XtPopdown(saveDialogShell);
	newFile = XawDialogGetValueString(saveDialog);

	for (p=newFile; isgraph(*p); p++) ;
	if (*p != NULL) {
		/* truncated at first non-printable character */
		*p = NULL;
	} 
	if (*newFile == NULL) {
		showError(
"Warning:\nA legal file name was not provided, so text will NOT be saved");
		return;
	}

	if ((inFP = fopen(oldFile, "r")) == NULL) {
		showError(
"The text cannot be saved, gopher's temporary file cannot be opened");
		return;
	}

	if ((outFP = fopen(newFile, "w")) == NULL) {
		showError(
"The text cannot be saved, the file name you entered cannot be opened");
		return;
	}

	while ( (c = fgetc(inFP)) != EOF )
		fputc((char) c, outFP);

	fclose(inFP);
	fclose(outFP);

	return;
}


/* SaveOk
   accept the OK action from a keyboard <cr> instead of the OK button.
   The <cr> translation is defined elsewhere.
   Capitalized name is for X action proc convention. */

void
SaveOk(w, event, parms, nparms)
Widget		w;
XEvent		*event;
String		*parms;
Cardinal	*nparms;
{
	saveOkProc(w, NULL, NULL);
	return;
}


/* saveCancelProc
   reject file name and do not process the save command */

void
saveCancelProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	char	*oldFile = (char *) client_data;

	XtPopdown(saveDialogShell);
}


/* makeSaveDialog
   create popup dialog for saving files */

void
makeSaveDialog(top)
Widget	top;
{
	Widget		okButton, cancelButton;
	Arg		args[10];
	Cardinal	n = 0;
	static XtActionsRec	saveActionsTable[] = {
					{ "saveok", (XtActionProc) SaveOk }
					};

	topLevel = top;

	n = 0;
	XtSetArg(args[n], XtNtitle, "Save text to file...");  n++;
	saveDialogShell = XtCreatePopupShell("saveDialogShell", 
					transientShellWidgetClass,
					topLevel, args, n);

	n = 0;
	XtSetArg(args[n], XtNlabel, "Save text to file ...");  n++;
	XtSetArg(args[n], XtNvalue, "");  n++;
	saveDialog= XtCreateManagedWidget("saveDialog", 
					dialogWidgetClass,
					saveDialogShell, args, n);


	setTextWidgetSize(XtNameToWidget(saveDialog, "value"), 40, 1);

	okButton = XtCreateManagedWidget("ok", commandWidgetClass, 
					saveDialog, NULL, (Cardinal) 0);
		XtAddCallback(okButton, XtNcallback, saveOkProc, NULL);

	cancelButton = XtCreateManagedWidget("cancel", commandWidgetClass, 
					saveDialog, NULL, (Cardinal) 0);
		XtAddCallback(cancelButton, XtNcallback, saveCancelProc, NULL);

	XtAddActions(saveActionsTable, XtNumber(saveActionsTable));
	
}


/* saveRequest
   enable popup dialog for saving files */

void
saveRequest(textShell, gopherFileName)
Widget	textShell;
char	*gopherFileName;
{
	Arg		args[3];
	Cardinal	n = 0;
	Position	x, y;
	Dimension	w, h;

	strcpy (fileToSave, gopherFileName);

	/* should give name of subject that is being saved */
	n = 0;
	XtSetArg(args[n], XtNlabel, "Save text to file ...            ");  n++;
	XtSetArg(args[n], XtNvalue, "");  n++;
	XtSetValues(saveDialog, args, n);

	n = 0;
	XtSetArg(args[n], XtNtransientFor, textShell);  n++;
	XtSetValues(saveDialogShell, args, n);

	positionPopup(saveDialogShell, POS_appPanel,
			(textShell != NULL) ? textShell : topLevel,
			0, 10, 0, 0);

	XtPopup(saveDialogShell, XtGrabNonexclusive);

	return;
}
