// ---------------------------------------------------------------------------
//
// File             : peridic.cc
// Description      : Demo program for C++ motif widget classes
// Revision History : Created July 21 1990 by chunde shi 
//
// ---------------------------------------------------------------------------

// ---------------------------------------------------------------------------
// include files
// ---------------------------------------------------------------------------
#include <stdio.h>
#include "XMMainW.hh"
#include "XMAppShell.hh"
#include "XMLabel.hh"
#include "XMBulletinB.hh"
#include "XMFrame.hh"
#include "XMOptMenu.hh"
#include "XMPanedW.hh"
#include "XMSeparator.hh"
#include "XMArrowB.hh"
#include "XMDrawingA.hh"
#include "XMToggleB.hh"
#include "XMToggleBG.hh"
#include "XMPushB.hh"
#include "XMDrawnB.hh"
#include "XMScrollBar.hh"
#include "XMText.hh"
#include "XMScale.hh"
#include "XMRadioBox.hh"
#include "XMMessageB.hh"
#include "XMFileSB.hh"
#include "XMPullMenu.hh"
#include "XMScrolledL.hh"
#include "XMMenuBar.hh"
#include "XMCascadeB.hh"
#include "XMBulletinB.hh"
#include "XMPopupMenu.hh"
#include "XMList.hh"
#include "xlogo32"

// ---------------------------------------------------------------------------
// macros
// ---------------------------------------------------------------------------
#define ATOMIC_NUMBER_ARGS(label)  label.set_X(74); \
		label.set_fontList(newcenturyschlbk_roman14);\
		label.set_shadowThickness(1); \
		label.set() 

#define ELEMENT_NAME_ARGS(pushbutton) pushbutton.set_width(98); \
		pushbutton.set_fontList(newcenturyschlbk_roman14);\
		pushbutton.set_Y(77); \
		pushbutton.set_X(1); \
		pushbutton.set_width(98); \
                pushbutton.set_shadowThickness(1); \
                pushbutton.set_alignment(1); \
		pushbutton.set()

#define  DIALOG_ARGS(message) message.set_marginWidth(3); \
	message.set_marginHeight(3); \
	message.set_shadowThickness(1); \
        message.set_textFontList(newcenturyschlbk_roman12);\
        message.set_labelFontList(dialog_font)

#define K_scale_widget           1
#define K_drawbutton_widget      2
#define K_togglebutton_widget    3
#define K_vtext1_widget          4
#define K_vtext2_widget          5
#define K_popup_menu_widget      6

// ---------------------------------------------------------------------------
// forward declarations
// ---------------------------------------------------------------------------
int logo(XMDrawnButton*);
int draw_face(XMDrawingArea*);

DECLARE_ENTRY (quit_button_activate);
DECLARE_ENTRY (foo_activate);
DECLARE_EVENT (postmenu);
DECLARE_ENTRY (redisplay);
DECLARE_ENTRY (draw_face_redisplay);

static XMScale Scale_1();
static XMDrawnButton Drawbutton_1();
static XMToggleButton Togglebutton_1();
static XMText VText_1();
static XMText VText_2();
static XMPopupMenu PopMenu_1();


// ---------------------------------------------------------------------------
int main (unsigned int argc,  char **argv) {
// ---------------------------------------------------------------------------

  XMApplicationShell  shell  ("periodic", &argc, argv);
  XMMainWindow        periodic_table_main (&shell, "mainw", True);
  XMBulletinBoard my_work_area (&periodic_table_main, "", True);
  XMLabel     title_1(&my_work_area, "Motif Widgets in C PLUS PLUS Binding", True);
  XMLabel     title_2(&my_work_area, "Open Software Foundation, Inc. - July 1989", True);
  XMLabel     title_3(&my_work_area, "Dept. of CS Unversity of Lowell - July 1990", True);
  XMLabel     heading_0(&my_work_area, "*Dialog Boxes", True);
  XMLabel     heading_1(&my_work_area, "Ia", True);
  XMLabel     heading_2(&my_work_area, "IIa", True);
  XMLabel     heading_center(&my_work_area, "IIIb", True);
  XMLabel     heading_3(&my_work_area, "IVa", True);
  XMLabel     heading_4(&my_work_area, "Va", True);
  XMLabel     heading_legend(&my_work_area, "Key\nTo\nChart", True);
  XMLabel            legend_arrow_1(&my_work_area, "_", True);
  XMLabel            legend_arrow_2(&my_work_area, "_", True);
  XMLabel            legend_arrow_3(&my_work_area, "_", True);
  XMLabel         legend_text_1(&my_work_area, "Atomic Number", True);
  XMLabel         legend_text_2(&my_work_area, "Actual Widget", True);
  XMLabel         legend_text_3(&my_work_area, "Widget Name", True);

  XMFrame         frame_legend(&my_work_area, "", True);
  	XMBulletinBoard        	frame_legend_bb(&frame_legend, "", True);
		XMSeparator separator_1(&frame_legend_bb, "", True);
                XMLabel    frame_legend_bb_label(&frame_legend_bb, "1", True);
		XMPushButton   frame_legend_bb_pushbutton(&frame_legend_bb, "separator",
		True);
  XMFrame         frame_11(&my_work_area, "", True);
	XMBulletinBoard        	frame_11_bb(&frame_11, "", True);
                XMSeparator separator_2(&frame_11_bb,"", True);
		XMLabel	frame_11_bb_label(&frame_11_bb,"1", True);
		XMPushButton	frame_11_bb_pushbutton(&frame_11_bb,"separator", True);
  XMFrame         frame_12(&my_work_area, "", True);
	XMBulletinBoard         frame_12_bb(&frame_12,"", True);
		XMArrowButton       arrow_button_1(&frame_12_bb,"", True);
		XMLabel	frame_12_bb_label(&frame_12_bb,"2", True);
		XMPushButton	frame_12_bb_pushbutton(&frame_12_bb,"arrowbutton", True);
  XMFrame         frame_13(&my_work_area, "", True);
	XMBulletinBoard          frame_13_bb(&frame_13,"", True);
		XMPushButton        push_button_1(&frame_13_bb,"Explode \nBuilding",
		True);
		XMLabel frame_13_bb_label(&frame_13_bb,"3", True);
                XMPushButton    frame_13_bb_pushbutton(&frame_13_bb,"pushbutton", True);
  XMFrame         frame_14(&my_work_area, "", True);
	XMBulletinBoard          frame_14_bb(&frame_14,"", True);
		XMToggleButton      toggle_button_1(&frame_14_bb,"Lights", True);
                XMLabel frame_14_bb_label(&frame_14_bb,"4", True);
                XMPushButton    frame_14_bb_pushbutton(&frame_14_bb,"togglebutton", True);

  XMFrame         frame_15(&my_work_area, "", True);
        XMBulletinBoard          frame_15_bb(&frame_15,"", True);
                XMLabel frame_15_bb_label_1(&frame_15_bb,"DON'T\nPANIC", True);
		XMLabel frame_15_bb_label(&frame_15_bb, "5", True);
                XMPushButton    frame_15_bb_pushbutton(&frame_15_bb,"label", True);
  XMFrame         frame_22(&my_work_area, "", True);
	XMBulletinBoard          frame_22_bb(&frame_22,"", True);

		XMPulldownMenu options_pulldown(&frame_22_bb, "", True);
		XMOptionMenu        option_menu_1(&frame_22_bb,"color", &options_pulldown,
		True);
				XMPushButton option_button_1(&options_pulldown, "blue",
				True);
				XMPushButton option_button_2(&options_pulldown, "green",
				True);
				XMPushButton option_button_3(&options_pulldown, "red",
				True);
		XMLabel frame_22_bb_label(&frame_22_bb,"6", True);
                XMPushButton    frame_22_bb_pushbutton(&frame_22_bb,"option menu", True);
  XMFrame         frame_23(&my_work_area, "", True);
	XMBulletinBoard          frame_23_bb(&frame_23,"", True);
			XMScale     scale_1(&frame_23_bb,"", True);
                XMLabel frame_23_bb_label(&frame_23_bb,"7", True);
                XMPushButton    frame_23_bb_pushbutton(&frame_23_bb,"scale", True);
  XMFrame         frame_24(&my_work_area, "", True);
        XMBulletinBoard          frame_24_bb(&frame_24,"", True);
		XMRadioBox  radio_box_1(&frame_24_bb,"radio_box", True);
			XMToggleButtonGadget radio_button_1(&radio_box_1, "ABC", True);
                        XMToggleButtonGadget radio_button_2(&radio_box_1, "BBC", True);
                        XMToggleButtonGadget radio_button_3(&rad, Trueio_box_1, "CNN", True);
                XMLabel frame_24_bb_label(&frame_24_bb,"8", True);
                XMPushButton    frame_24_bb_pushbutton(&frame_24_bb,"radio box", True);
  XMFrame         frame_25(&my_work_area, "", True);
        XMBulletinBoard          frame_25_bb(&frame_25,"", True);
		XMText      text_1(&frame_25_bb,"", True);
                XMLabel frame_25_bb_label(&frame_25_bb,"9", True);
                XMPushButton    frame_25_bb_pushbutton(&frame_25_bb,"text edit", True);
  XMFrame         frame_file_selection(&my_work_area, "", True);
	XMBulletinBoard          frame_file_selection_bb(&frame_file_selection,"", True);
		XMFrame file_selection_box_1(&frame_file_selection_bb,"", True);
			XMFileSelectionBox file_selection_box_1_1(&file_selection_box_1, "", True);
		XMLabel frame_file_selection_bb_label(&frame_file_selection_bb,"10",
		True);
                XMPushButton frame_file_selection_bb_pushbutton(&frame_file_selection_bb,
								  "file selection*",
								  True);
  XMFrame         frame_33(&my_work_area, "", True);
	XMBulletinBoard          frame_33_bb(&frame_33,"", True);
		XMScrollBar scrollbar_1(&frame_33_bb,"", True);
		XMLabel frame_33_bb_label(&frame_33_bb,"11", True);
                XMPushButton    frame_33_bb_pushbutton(&frame_33_bb,"scrollbar", True);

  XMFrame         frame_34(&my_work_area, "", True);
	XMBulletinBoard          frame_34_bb(&frame_34,"", True);
		XMFrame		frame_34_bb_frame(&frame_34_bb, "", True);
			XMScrolledList list_box_1(&frame_34_bb_frame,"", True);
                XMLabel frame_34_bb_label(&frame_34_bb,"12", True);
                XMPushButton    frame_34_bb_pushbutton(&frame_34_bb,"scrolledlist", True);

  XMFrame         frame_35(&my_work_area, "", True);
	XMBulletinBoard          frame_35_bb(&frame_35,"", True);
		XMPanedWindow paned_window_1(&frame_35_bb,"", True);
                        XMText paned_text_1(&paned_window_1, "OPEN Software Foundation",
			True);
			XMText paned_text_2(&paned_window_1, "C++ Motif Version 1.0",
			True);
                XMLabel frame_35_bb_label(&frame_35_bb,"16", True);
                XMPushButton    frame_35_bb_pushbutton(&frame_35_bb,"panedwindow", True);
  XMFrame         frame_42(&my_work_area, "", True);
	XMBulletinBoard          frame_42_bb(&frame_42,"", True);
		XMFrame popup_menu_1(&frame_42_bb,"", True);
			 XMLabel popup_menu_1_label(&popup_menu_1, "Press MB3\nPopup Menu", True);
                XMLabel frame_42_bb_label(&frame_42_bb,"13", True);
                XMPushButton    frame_42_bb_pushbutton(&frame_42_bb,"popup menu", True);
  XMPopupMenu PMenu_1(&frame_42_bb, "POPUP MENU", False, True);
  XMLabel     PMenu_1_label (&PMenu_1, "POPUP MENU", True);
  XMSeparator Separator1(&PMenu_1, "", True);
  XMPushButton PushBtn1(&PMenu_1, "Boggle Button", True);
  XMPushButton PushBtn2(&PMenu_1, "Toggle Button", True);

  XMFrame         frame_43(&my_work_area, "", True);
	XMBulletinBoard          frame_43_bb(&frame_43,"", True);
                XMFrame	frame_43_bb_frame(&frame_43_bb, "", True);
			XMDrawingArea draw_area_1(&frame_43_bb_frame,"", True);
		XMLabel frame_43_bb_label(&frame_43_bb,"14", True);
		XMPushButton    frame_43_bb_pushbutton(&frame_43_bb,"drawing area", True);
  XMFrame         frame_44(&my_work_area, "", True);
	XMBulletinBoard          frame_44_bb(&frame_44,"", True);
		XMDrawnButton draw_button_1(&frame_44_bb,"", True);
		XMLabel frame_44_bb_label(&frame_44_bb,"15", True);
		XMPushButton    frame_44_bb_pushbutton(&frame_44_bb,"drawbutton", True);

  XMFrame         frame_dialog_1(&my_work_area, "", True);
	XMMessageBox    message_box_1(&frame_dialog_1,"", True);

  XMFrame         frame_dialog_2(&my_work_area, "", True);
	XMMessageBox    message_box_2(&frame_dialog_2,"", True);

  XMFrame         frame_dialog_3(&my_work_area, "", True);
	XMMessageBox    message_box_4(&frame_dialog_3,"", True);

  XMFrame         frame_dialog_4(&my_work_area, "" , True);
	XMMessageBox    message_box_5(&frame_dialog_4,"", True);

  XMFrame         frame_dialog_5(&my_work_area, "", True);
	XMMessageBox    message_box_6(&frame_dialog_5,"", True);
  
  XMMenuBar           menu_bar_1(&my_work_area, "", True);
  XMCascadeButton   File(&menu_bar_1, "File", True);
	XMPulldownMenu   sample_pulldown_1(&menu_bar_1, "", True);
		XMPushButton sample_push_button_1(&sample_pulldown_1, "New", True);
              	XMPushButton sample_push_button_2(&sample_pulldown_1, "Open Software ...",
		True);
              	XMCascadeButton     About(&sample_pulldown_1, "About", True);
			XMPulldownMenu About_1(&sample_pulldown_1, "", True);
				XMPushButton  About_1_pushbutton_1(&About_1, 
					"C++ Motif Periodic Table v1.0 ", True);
				XMPushButton  About_1_pushbutton_2(&About_1, 
					"converted by chunde shi", True);
				XMPushButton  About_1_pushbutton_3(&About_1,
				        "July 26 1990", True);
              	XMSeparator File_sample_pulldown_1_separator(&sample_pulldown_1, "",
		True);
              	XMPushButton Quit(&sample_pulldown_1, "Quit", True);
  XMCascadeButton   Edit(&menu_bar_1, "Edit", True);
	XMPulldownMenu   sample_pulldown_2(&menu_bar_1,"", True);
                XMPushButton s_push_button_1(&sample_pulldown_2, "Cut", True);
                XMPushButton s_push_button_2(&sample_pulldown_2, "Copy", True);
                XMPushButton s_push_button_3(&sample_pulldown_2, "Paste", True);
                XMCascadeButton     morestuff(&sample_pulldown_2, "morestuff", True);		
			XMPulldownMenu pulldown_2(&sample_pulldown_2, "", True);
			XMPushButton pulldown_2_pushbutton(&pulldown_2, 
							   "THANKS FOR\nYOUR FISH",
							   True);
 XMCascadeButton  Help(&menu_bar_1, "Help", True);
	XMPulldownMenu   sample_pulldown_3(&menu_bar_1, "", True);
				XMPushButton sample_pulldown_3_pushbutton_1
					(&sample_pulldown_3, "Overview...", True);
                                XMPushButton sample_pulldown_3_pushbutton_2
                                        (&sample_pulldown_3, "Bindings...", True);
                                XMPushButton sample_pulldown_3_pushbutton_3
                                        (&sample_pulldown_3, "Tutorial...", True);

  //XMScrollBar	scrollbar_2(&my_work_area, "");
  //XMScrollBar   scrollbar_3(&my_work_area, "");

  XmStringCharSet cs = "ISOLatin1";
  XFontStruct         *fntst;
  XmFontList          dialog_font;
  fntst  = XLoadQueryFont(XtDisplay(shell.get_widget ()), "fixed");
  dialog_font = XmFontListCreate(fntst, cs);

  XmFontList          subtitle_font;
  fntst  = XLoadQueryFont(XtDisplay(shell.get_widget ()), "vr-20");
  subtitle_font = XmFontListCreate(fntst, cs);

  XmFontList          heading_font;
  fntst  = XLoadQueryFont(XtDisplay(shell.get_widget ()), "vr-20");
  heading_font = XmFontListCreate(fntst, cs);

  XmFontList          var_font;
  fntst  = XLoadQueryFont(XtDisplay(shell.get_widget ()), "variable");
  var_font = XmFontListCreate(fntst, cs);

  XmFontList          hel_bold_font;
  fntst  = XLoadQueryFont(XtDisplay(shell.get_widget ()), "variable");
  hel_bold_font = XmFontListCreate(fntst, cs);

  XmFontList          hel_bold_font14;
  fntst  = XLoadQueryFont(XtDisplay(shell.get_widget ()), "variable");
  hel_bold_font14 = XmFontListCreate(fntst, cs);

  XmFontList          newcenturyschlbk_roman14;
  fntst  = XLoadQueryFont(XtDisplay(shell.get_widget ()), "variable");
  newcenturyschlbk_roman14 = XmFontListCreate(fntst, cs);

  XmFontList          newcenturyschlbk_roman12;
  fntst  = XLoadQueryFont(XtDisplay(shell.get_widget ()), "variable");
  newcenturyschlbk_roman12 = XmFontListCreate(fntst, cs);

  XmFontList          newcenturyschlbk_bold14;
  fntst  = XLoadQueryFont(XtDisplay(shell.get_widget ()), "variable");
  newcenturyschlbk_bold14 = XmFontListCreate(fntst, cs);

  XmFontList          newcenturyschlbk_bold24;
  fntst  = XLoadQueryFont(XtDisplay(shell.get_widget ()), "vbee-36");
  newcenturyschlbk_bold24 = XmFontListCreate(fntst, cs);

  XmFontList          times_bold_font;
  fntst  = XLoadQueryFont(XtDisplay(shell.get_widget ()), "vmic-25");
  times_bold_font = XmFontListCreate(fntst, cs);

  shell.set_allowShellResize(FALSE) ;
  shell.set();
 
  menu_bar_1.set_menuHelpWidget(&Help);
  menu_bar_1.set ();
  
  //scrollbar_2.set_orientation (XmHORIZONTAL);
  //scrollbar_2.set (); 

  periodic_table_main.set_X(10);
  periodic_table_main.set_Y(10);
  //periodic_table_main.set_scrollBarDisplayPolicy(0);
  //periodic_table_main.set_menuBar(&menu_bar_1);
 
  XmMainWindowSetAreas(periodic_table_main.get_widget(), menu_bar_1.get_widget(), 
			NULL,NULL, NULL, NULL);
  periodic_table_main.set_height(710);
  periodic_table_main.set_width(960);
  periodic_table_main.set_showSeparator (True);
//  periodic_table_main.set_horizontalScrollBar (&scrollbar_2);
//  periodic_table_main.set_verticalScrollBar (&scrollbar_3);
//periodic_table_main.set_scrollingPolicy (XmAUTOMATIC);
//periodic_table_main.set_scrollBarDisplayPolicy (XmSTATIC);
  periodic_table_main.set();

  my_work_area.set_width(584);
  my_work_area.set_height(512);
  my_work_area.set_borderWidth(2);
  my_work_area.set_labelFontList(hel_bold_font);
  my_work_area.set();

  int  title_x = 200;
  int  title_y = 40;
  title_1.set_X(title_x);
  title_1.set_Y(title_y);
  title_1.set_fontList(newcenturyschlbk_bold24);
  title_1.set ();

  int subtitle_x = title_x + 60;
  int subtitle_y = title_y + 30;
  int subtitle_2_y = subtitle_y+30;
  title_2.set_X(subtitle_x);
  title_2.set_Y(subtitle_2_y+10);
  title_3.set_fontList(subtitle_font);
  title_2.set ();
  
  int subtitle_3_x = subtitle_x-5;
  title_3.set_X(subtitle_3_x);
  title_3.set_Y(subtitle_y+20);
  title_3.set_fontList(subtitle_font);
  title_3.set ();
  
  int radioactive_x = 10;
  int radioactive_y = 635;
  int radioactive_title_x = radioactive_x; 
  int radioactive_title_y = radioactive_y-35; 
  shell.set_immediate_ON();
  heading_0.set_X(radioactive_title_x);
  heading_0.set_Y(radioactive_title_y);
  heading_0.set_width(50);
  heading_0.set_height(5);
  heading_0.set_alignment(2);
  heading_0.set_fontList(newcenturyschlbk_roman14);
  heading_0.set();
  shell.set_immediate_OFF();
  
  int table_origin_x = 100;
  int table_origin_y = 95;
  int heading_fudge_x = 40;
  int heading_fudge_y = 25;
  int element_height = 100;
  int element_width = 100;

  heading_1.set_X(table_origin_x + heading_fudge_x);
  heading_1.set_Y(table_origin_y - heading_fudge_y);
  heading_1.set_alignment(1);
  heading_1.set_fontList(newcenturyschlbk_roman14);
  heading_1.set();

  heading_2.set_X(table_origin_x + (element_width * 1) + heading_fudge_x);
  heading_2.set_Y(table_origin_y  + (element_height * 1) - heading_fudge_y);
  heading_2.set_alignment(1);
  heading_2.set_fontList(newcenturyschlbk_roman14);
  heading_2.set();
  
  int fudge = 2;
  int centre_box_x = table_origin_x + (element_width * 2) + fudge;
  int centre_box_y = table_origin_y + (element_height * 2);
  int centre_box_width = 380;
  int centre_box_height = 300 - fudge;
  int legend_x = centre_box_x + (centre_box_width/2) - 35;
  int legend_y = centre_box_y - 160;

  heading_center.set_X( centre_box_x + (centre_box_width/2));
  heading_center.set_Y(centre_box_y - heading_fudge_y);
  heading_center.set_marginWidth(0);
  heading_center.set_marginHeight(0);
  heading_center.set_fontList(newcenturyschlbk_roman14);
  heading_center.set();

  heading_3.set_X( centre_box_x + centre_box_width + heading_fudge_x - 5);
  heading_3.set_Y(table_origin_y + (element_height * 2) + fudge- heading_fudge_y);
  heading_3.set_alignment(1);
  heading_3.set_fontList(newcenturyschlbk_roman14);
  heading_3.set();

  heading_4.set_X( centre_box_x + centre_box_width + element_width + heading_fudge_x);
  heading_4.set_Y(table_origin_y + (element_height * 1) - heading_fudge_y);
  heading_4.set_alignment(1);
  heading_4.set_fontList(newcenturyschlbk_roman14);
  heading_4.set();

  heading_legend.set_X(legend_x - 55);
  heading_legend.set_Y(legend_y + 15);
  heading_legend.set_alignment(2);
  heading_legend.set_fontList(newcenturyschlbk_bold14);
  heading_legend.set();
  
  legend_arrow_1.set_X(legend_x + 105);
  legend_arrow_1.set_Y(legend_y + 5);
  legend_arrow_1.set_fontList(var_font);
  legend_arrow_1.set();

  legend_arrow_2.set_X(legend_x + 105);
  legend_arrow_2.set_Y(legend_y + 35);
  legend_arrow_2.set_fontList(var_font);
  legend_arrow_2.set();

  legend_arrow_3.set_X(legend_x + 105);
  legend_arrow_3.set_Y(legend_y + 75);
  legend_arrow_3.set_fontList(var_font);
  legend_arrow_3.set();

  legend_text_1.set_X(legend_x + 128);
  legend_text_1.set_Y(legend_y + 3);
  legend_text_1.set_alignment(1);
  legend_text_1.set_fontList(newcenturyschlbk_roman12);
  legend_text_1.set();

  legend_text_2.set_X(legend_x + 128);
  legend_text_2.set_Y(legend_y + 33);
  legend_text_2.set_alignment(1);
  legend_text_2.set_fontList(newcenturyschlbk_roman12);
  legend_text_2.set();
  
  legend_text_3.set_X(legend_x + 128);
  legend_text_3.set_Y(legend_y + 73);
  legend_text_3.set_alignment(1);
  legend_text_3.set_fontList(newcenturyschlbk_roman12);
  legend_text_3.set();

  frame_legend.set_X(legend_x);
  frame_legend.set_Y(legend_y);
  frame_legend.set();

	  frame_legend_bb.set_width(element_width);
	  frame_legend_bb.set_height(element_height - fudge);
	  frame_legend_bb.set_marginWidth(0);
          frame_legend_bb.set_marginHeight(0);
          frame_legend_bb.set();

		separator_1.set_width(78);
                separator_1.set_X(10);
		separator_1.set_Y(40);
		separator_1.set();

		ATOMIC_NUMBER_ARGS(frame_legend_bb_label);

		ELEMENT_NAME_ARGS(frame_legend_bb_pushbutton);

  frame_11.set_X(table_origin_x);
  frame_11.set_Y(table_origin_y);
  frame_11.set();

        frame_11_bb.set_width(element_width);
        frame_11_bb.set_height(element_height - fudge);
	frame_11_bb.set_marginWidth(0);
        frame_11_bb.set_marginHeight(0);
        frame_11_bb.set();

		separator_2.set_width(78);
		separator_2.set_X(10);
		separator_2.set_Y(40);
		separator_2.set();

                ATOMIC_NUMBER_ARGS(frame_11_bb_label);

                ELEMENT_NAME_ARGS(frame_11_bb_pushbutton);

  frame_12.set_X(table_origin_x);
  frame_12.set_Y(table_origin_y + (element_height * 1));
  frame_12.set();

        frame_12_bb.set_width(element_width);
        frame_12_bb.set_height(element_height);
        frame_12_bb.set_marginWidth(0);
        frame_12_bb.set_marginHeight(0);
        frame_12_bb.set();

                 arrow_button_1.set_X(25);
                 arrow_button_1.set_Y(15);
                 arrow_button_1.set_width(50);
                 arrow_button_1.set_height(50);
		 arrow_button_1.set_arrowDirection(0);
                 arrow_button_1.set();

                ATOMIC_NUMBER_ARGS(frame_12_bb_label);

                ELEMENT_NAME_ARGS(frame_12_bb_pushbutton);

  frame_13.set_X(table_origin_x);
  frame_13.set_Y(table_origin_y + (element_height * 2));
  frame_13.set();

        frame_13_bb.set_width(element_width);
        frame_13_bb.set_height(element_height);
        frame_13_bb.set_marginWidth(0);
        frame_13_bb.set_marginHeight(0);
        frame_13_bb.set();

                push_button_1.set_X(20);
                push_button_1.set_Y(25);
                push_button_1.set_fontList(hel_bold_font);
                push_button_1.set();

                ATOMIC_NUMBER_ARGS(frame_13_bb_label);

                ELEMENT_NAME_ARGS(frame_13_bb_pushbutton);

  frame_14.set_X(table_origin_x);
  frame_14.set_Y(table_origin_y + (element_height * 3));
  frame_14.set();

        frame_14_bb.set_width(element_width);
        frame_14_bb.set_height(element_height);
        frame_14_bb.set_marginWidth(0);
        frame_14_bb.set_marginHeight(0);
	frame_14_bb.set();

                toggle_button_1.set_X(20);
                toggle_button_1.set_Y(30);
		toggle_button_1.set_fontList(hel_bold_font);
		toggle_button_1.set();

                ATOMIC_NUMBER_ARGS(frame_14_bb_label);

                ELEMENT_NAME_ARGS(frame_14_bb_pushbutton);

   frame_15.set_X(table_origin_x);
   frame_15.set_Y(table_origin_y + (element_height * 4));
   frame_15.set();

        frame_15_bb.set_width(element_width);
        frame_15_bb.set_height(element_height);
        frame_15_bb.set_marginWidth(0);
        frame_15_bb.set_marginHeight(0);
	frame_15_bb.set();

		int dont_panic_x = 7;
                int dont_panic_y = 17;

                frame_15_bb_label_1.set_X(dont_panic_x);
                frame_15_bb_label_1.set_Y(dont_panic_y);
                frame_15_bb_label_1.set_fontList(times_bold_font);
                frame_15_bb_label_1.set();

                ATOMIC_NUMBER_ARGS(frame_15_bb_label);

                ELEMENT_NAME_ARGS(frame_15_bb_pushbutton);

  frame_22.set_X(table_origin_x + (element_width * 1));
  frame_22.set_Y(table_origin_y + (element_height * 1));
  frame_22.set();

        frame_22_bb.set_width(element_width);
        frame_22_bb.set_height(element_height);
        frame_22_bb.set_marginWidth(0);
        frame_22_bb.set_marginHeight(0);
	frame_22_bb.set();

                option_menu_1.set_X(10);
                option_menu_1.set_Y(30);
 		option_menu_1.set_menuHistory(&option_button_2);
		option_menu_1.set();

			options_pulldown.set();

                                option_button_1.set_fontList(hel_bold_font);
				option_button_1.set();

                                option_button_2.set_fontList(hel_bold_font);
				option_button_2.set();

                                option_button_3.set_fontList(hel_bold_font);
				option_button_3.set();

                ATOMIC_NUMBER_ARGS(frame_22_bb_label);

                ELEMENT_NAME_ARGS(frame_22_bb_pushbutton);

  frame_23.set_X(table_origin_x + (element_width * 1));
  frame_23.set_Y(table_origin_y + (element_height * 2));
  frame_23.set();

        frame_23_bb.set_width(element_width);
        frame_23_bb.set_height(element_height);
        frame_23_bb.set_marginWidth(0);
        frame_23_bb.set_marginHeight(0);
        frame_23_bb.set();

                shell.set_immediate_ON();
                scale_1.set_Y(23);
                scale_1.set_height(20);
		scale_1.set_fontList(hel_bold_font);
		scale_1.set_borderWidth(0);
		scale_1.set_value(10);
		scale_1.set_maximum(10);
                scale_1.set_minimum(0);
                scale_1.set_showValue(True);
                scale_1.set_processingDirection(1);
		scale_1.set_orientation(XmHORIZONTAL);
		scale_1.set();
		shell.set_immediate_OFF();

                ATOMIC_NUMBER_ARGS(frame_23_bb_label);

                ELEMENT_NAME_ARGS(frame_23_bb_pushbutton);

  frame_24.set_X(table_origin_x + (element_width * 1));
  frame_24.set_Y(table_origin_y + (element_height * 3));
  frame_24.set();

        frame_24_bb.set_width(element_width);
        frame_24_bb.set_height(element_height);
        frame_24_bb.set_marginWidth(0);
        frame_24_bb.set_marginHeight(0);
	frame_24_bb.set();

		 radio_box_1.set_isHomogeneous (True);
                 radio_box_1.set_X(20);
                 radio_box_1.set_Y(10);
                 radio_box_1.set_spacing(2);
                 radio_box_1.set_marginWidth(0);
                 radio_box_1.set_marginHeight(0);
		 radio_box_1.set();

			radio_button_1.set_marginWidth(0);
                        radio_button_1.set_marginHeight(0);
                        radio_button_1.set_set(True);
                        radio_button_1.set_fontList(hel_bold_font);
			radio_button_1.set();

                        radio_button_2.set_marginWidth(0);
                        radio_button_2.set_marginHeight(0);
                        radio_button_2.set_fontList(hel_bold_font);
			radio_button_2.set();

                        radio_button_3.set_marginWidth(0);
                        radio_button_3.set_marginHeight(0);
                        radio_button_3.set_fontList(hel_bold_font);
			radio_button_3.set();

		ATOMIC_NUMBER_ARGS(frame_24_bb_label);

                ELEMENT_NAME_ARGS(frame_24_bb_pushbutton);

  frame_25.set_X(table_origin_x + (element_width * 1));
  frame_25.set_Y(table_origin_y + (element_height * 4));
  frame_25.set();

        frame_25_bb.set_width(element_width);
        frame_25_bb.set_height(element_height);
        frame_25_bb.set_marginWidth(0);
        frame_25_bb.set_marginHeight(0);
	frame_25_bb.set();

                text_1.set_X(15);
                text_1.set_Y(25);
		text_1.set_columns(10);
		text_1.set_rows(2);
		text_1.set_resizeWidth(False);
		text_1.set_resizeHeight(False);
                text_1.set_editMode(0);
                text_1.set_value("helloworld");
	        text_1.set_scrollVertical(True);
		text_1.set();

		ATOMIC_NUMBER_ARGS(frame_25_bb_label);

		ELEMENT_NAME_ARGS(frame_25_bb_pushbutton);

  frame_file_selection.set_X(centre_box_x);
  frame_file_selection.set_Y(centre_box_y);
  frame_file_selection.set_marginWidth(0);
  frame_file_selection.set_marginHeight(0);
  frame_file_selection.set();

        frame_file_selection_bb.set_resizePolicy(0);
        frame_file_selection_bb.set_width(centre_box_width);
        frame_file_selection_bb.set_height( centre_box_height);
        frame_file_selection_bb.set_marginWidth(0);
        frame_file_selection_bb.set_marginHeight(0);
	frame_file_selection_bb.set();

                file_selection_box_1.set_X(15);
                file_selection_box_1.set_Y(15);
		file_selection_box_1.set();

			file_selection_box_1_1.set_resizePolicy(0);
			file_selection_box_1_1.set_listVisibleItemCount(2);
                        file_selection_box_1_1.set_defaultPosition(True);
                        file_selection_box_1_1.set_labelFontList ( hel_bold_font);
                        file_selection_box_1_1.set_textFontList ( hel_bold_font);
			file_selection_box_1_1.set();

                ATOMIC_NUMBER_ARGS(frame_file_selection_bb_label);
		frame_file_selection_bb_label.set_X(54+3*element_width);
		frame_file_selection_bb_label.set();

                ELEMENT_NAME_ARGS(frame_file_selection_bb_pushbutton);
		frame_file_selection_bb_pushbutton.set_width(98+3*element_width);
		frame_file_selection_bb_pushbutton.set_Y(77+2*element_height);
		frame_file_selection_bb_pushbutton.set();

  frame_33.set_X(centre_box_x + centre_box_width + fudge);
  frame_33.set_Y(table_origin_y + (element_height * 2));
  frame_33.set();

        frame_33_bb.set_width(element_width - fudge);
        frame_33_bb.set_height(element_height - fudge);
        frame_33_bb.set_marginWidth(0);
        frame_33_bb.set_marginHeight(0);
        frame_33_bb.set();

                scrollbar_1.set_X(10);
                scrollbar_1.set_Y(30);
                scrollbar_1.set_width(75);
		scrollbar_1.set_height(20);
                scrollbar_1.set_orientation(2);
                scrollbar_1.set_value(20);
		scrollbar_1.set();

                ATOMIC_NUMBER_ARGS(frame_33_bb_label);

                ELEMENT_NAME_ARGS(frame_33_bb_pushbutton);

  frame_34.set_X(centre_box_x + centre_box_width + fudge);
  frame_34.set_Y(table_origin_y + (element_height * 3));
  frame_34.set();

        frame_34_bb.set_width(element_width - fudge);
        frame_34_bb.set_height(element_height - fudge);
        frame_34_bb.set_marginWidth(0);
        frame_34_bb.set_marginHeight(0);
	frame_34_bb.set();

	    frame_34_bb_frame.set_X(20);
	    frame_34_bb_frame.set_Y(25);
            frame_34_bb_frame.set();
	        XMString list_item_1 ("Foobar");
	        XMString list_item_2 ("Mumble");
	        XMString list_item_3 ("Lambda");
	        XMString list_item_4 ("Coker");

                XMList *temp;

// *BIG KLUDGE*
                temp = (XMList*) &list_box_1;

                temp->AddItem (&list_item_1, 0);
                temp->AddItem (&list_item_2, 0);
                temp->AddItem (&list_item_3, 0);
                temp->AddItem (&list_item_4, 0);
                temp->set_visibleItemCount(2);
                temp->set ();
// *BIG KLUDGE*

                ATOMIC_NUMBER_ARGS(frame_34_bb_label);

                ELEMENT_NAME_ARGS(frame_34_bb_pushbutton);

  frame_35.set_X(centre_box_x + centre_box_width + fudge);
  frame_35.set_Y(table_origin_y + (element_height * 4));
  frame_35.set();

        frame_35_bb.set_width(element_width * 2);
        frame_35_bb.set_height(element_height);
        frame_35_bb.set_marginWidth(0);
        frame_35_bb.set_marginHeight(0);
	frame_35_bb.set();

                paned_window_1.set_X(10);
                paned_window_1.set_Y(5);
                paned_window_1.set_width(150);
		paned_window_1.set();

			paned_text_1.set_X(15);
                        paned_text_1.set_Y(25);
                        paned_text_1.set_width(70);
                        paned_text_1.set_height(40);
                        paned_text_1.set_columns(24);
                        paned_text_1.set_rows(1);
                        paned_text_1.set_value("CS Dept. U. of Lowell");
                        paned_text_1.set_resizeWidth(False);
                        paned_text_1.set_resizeHeight(False);
                        paned_text_1.set_editMode(0);
                        paned_text_1.set_scrollVertical(True);
                        paned_text_1.set_scrollHorizontal(False);
			paned_text_1.set();

			paned_text_2.set_X(15);
                        paned_text_2.set_Y(25);
                        paned_text_2.set_width(70);
                        paned_text_2.set_height(40);
                        paned_text_2.set_columns(24);
                        paned_text_2.set_rows(1);
                        paned_text_2.set_value("C++ Motif Version 1.0");
                        paned_text_2.set_resizeWidth(False);
                        paned_text_2.set_resizeHeight(False);
                        paned_text_2.set_editMode(0);
                        paned_text_2.set_scrollVertical(True);
                        paned_text_2.set_scrollHorizontal(False);
			paned_text_2.set();

                ATOMIC_NUMBER_ARGS(frame_35_bb_label);
		frame_35_bb_label.set_X(element_width+73);
		frame_35_bb_label.set();

                ELEMENT_NAME_ARGS(frame_35_bb_pushbutton);
		frame_35_bb_pushbutton.set_width(198);
		frame_35_bb_pushbutton.set();

  frame_42.set_X(centre_box_x + centre_box_width + element_width + fudge);
  frame_42.set_Y(table_origin_y + (element_height * 1));
  frame_42.set_width(50);
  frame_42.set_height(50);
  frame_42.set();

        frame_42_bb.set_width(element_width);
        frame_42_bb.set_height(element_height);
        frame_42_bb.set_marginWidth(0);
        frame_42_bb.set_marginHeight(0);
        frame_42_bb.AddEventHandler(ButtonPressMask, (Boolean)False, postmenu, 
					(caddr_t) &PMenu_1);
	frame_42_bb.set();

                popup_menu_1.set_X(10);
                popup_menu_1.set_Y(28);
                popup_menu_1.set_shadowThickness(2);
		popup_menu_1.set();

			popup_menu_1_label.set_width(74);
			popup_menu_1_label.set_height(34);
			popup_menu_1_label.set();

                ATOMIC_NUMBER_ARGS(frame_42_bb_label);

                ELEMENT_NAME_ARGS(frame_42_bb_pushbutton);

  frame_43.set_X(centre_box_x + centre_box_width + element_width + fudge);
  frame_43.set_Y(table_origin_y + (element_height * 2));
  frame_43.set();

        frame_43_bb.set_width(element_width);
        frame_43_bb.set_height(element_height);
        frame_43_bb.set_marginWidth(0);
        frame_43_bb.set_marginHeight(0);
	frame_43_bb.set();

                frame_43_bb_frame.set_X(31);
                frame_43_bb_frame.set_Y(28);
		frame_43_bb_frame.set();

                draw_area_1.set_width(32);
                draw_area_1.set_height(32);
                draw_area_1.set_shadowThickness(2);
		draw_area_1.set();

                ATOMIC_NUMBER_ARGS(frame_43_bb_label);

                ELEMENT_NAME_ARGS(frame_43_bb_pushbutton);

  frame_44.set_X(centre_box_x + centre_box_width + element_width + fudge);
  frame_44.set_Y(table_origin_y + (element_height * 3));
  frame_44.set();

        frame_44_bb.set_width(element_width);
        frame_44_bb.set_height(element_height);
        frame_44_bb.set_marginWidth(0);
        frame_44_bb.set_marginHeight(0);
	frame_44_bb.set();

                draw_button_1.set_X(29);
                draw_button_1.set_Y(26);
                draw_button_1.set_marginWidth(0);
                draw_button_1.set_marginHeight(0);
                draw_button_1.set_width(36);
                draw_button_1.set_height(36);
                draw_button_1.set_shadowThickness(2);
                draw_button_1.set_pushButtonEnabled(True);
		draw_button_1.set_entry_activateCallback(foo_activate, NULL);
		draw_button_1.set();

                ATOMIC_NUMBER_ARGS(frame_44_bb_label);

                ELEMENT_NAME_ARGS(frame_44_bb_pushbutton);
		frame_44_bb_pushbutton.set();

  shell.set_immediate_ON();
  frame_dialog_1.set_X(radioactive_x);
  frame_dialog_1.set_Y(radioactive_y);

        message_box_1.set_dialogType(1);
	DIALOG_ARGS(message_box_1);
	message_box_1.set_messageString(&XMString("  Swap Error...\nYou Lose Your Mind."));
	message_box_1.set();

  int radioactive_width = 200;
  int radioactive_height = 100;
  int dialog_fudge = 10;

  frame_dialog_2.set_X(radioactive_x + (radioactive_width * 1) - dialog_fudge);
  frame_dialog_2.set_Y(radioactive_y);

        message_box_2.set_dialogType(2);
        DIALOG_ARGS(message_box_2);	
	message_box_2.set_messageString(&XMString("  Information is Power.\nDo you have brains?"));
        message_box_2.set();

  frame_dialog_3.set_X(radioactive_x + (radioactive_width * 2) - (dialog_fudge * 2));
  frame_dialog_3.set_Y(radioactive_y);

        message_box_4.set_dialogType(4);
	DIALOG_ARGS(message_box_4);
	message_box_4.set_messageString(
			&XMString("  Question authority...\nBut raise your hand first."));
        message_box_4.set();

  frame_dialog_4.set_X(radioactive_x + (radioactive_width * 3) - (dialog_fudge * 1));
  frame_dialog_4.set_Y(radioactive_y);

        message_box_5.set_dialogType(5);
	DIALOG_ARGS(message_box_5);
	message_box_5.set_messageString(
			&XMString("Global warmming? if lucky,\nSiberia rain forest"));
        message_box_5.set();

  frame_dialog_5.set_X(radioactive_x + (radioactive_width * 4) - (dialog_fudge * 2));
  frame_dialog_5.set_Y(radioactive_y);

        message_box_6.set_dialogType(6);
	DIALOG_ARGS(message_box_6);
	message_box_6.set_messageString(
			&XMString("  Care about homeless?\nget yourself together!"));
        message_box_6.set();
	shell.set_immediate_OFF();

 File.set_fontList(newcenturyschlbk_roman14);
 File.set_subMenuId (&sample_pulldown_1);
 File.set();

                sample_push_button_1.set_fontList(hel_bold_font14);
		sample_push_button_1.set();

                sample_push_button_2.set_fontList(hel_bold_font14);
		sample_push_button_2.set();

                About.set_fontList(hel_bold_font14);
		About.set_subMenuId (&About_1);
                About.set();

                                About_1_pushbutton_1.set_fontList(hel_bold_font14);
				About_1_pushbutton_1.set();

                                About_1_pushbutton_2.set_fontList(hel_bold_font14);
                                About_1_pushbutton_3.set_fontList(hel_bold_font14);
				About_1_pushbutton_3.set();

		File_sample_pulldown_1_separator.set();
                Quit.set_fontList(hel_bold_font14);
		Quit.set_entry_activateCallback(quit_button_activate, NULL);
		Quit.set();

 Edit.set_fontList(newcenturyschlbk_roman14);
 Edit.set_subMenuId (&sample_pulldown_2);
 Edit.set();

                s_push_button_1.set_fontList(hel_bold_font14);
		s_push_button_1.set();

                s_push_button_2.set_fontList(hel_bold_font14);
		s_push_button_2.set();

                s_push_button_3.set_fontList(hel_bold_font14);
		s_push_button_3.set();

                morestuff.set_fontList(hel_bold_font14);
                morestuff.set_subMenuId (&pulldown_2);
		morestuff.set();

                                pulldown_2_pushbutton.set_fontList(hel_bold_font14);
				pulldown_2_pushbutton.set();

Help.set_fontList(newcenturyschlbk_roman14);
Help.set_subMenuId (&sample_pulldown_3);
Help.set();

		sample_pulldown_3_pushbutton_1.set_fontList(hel_bold_font14);
 		sample_pulldown_3_pushbutton_2.set_fontList(hel_bold_font14);
                sample_pulldown_3_pushbutton_3.set_fontList(hel_bold_font14);
		sample_pulldown_3_pushbutton_3.set();
 
 shell.Realize ();
 logo(&draw_button_1);
 draw_face(&draw_area_1);
 XtMainLoop ();
}
     
// ----------------------------------------------------------
ENTRY( quit_button_activate, XMPushButton, Quit, tag, callback_data)

 exit (1);
}
       
// --------------------------------------------------------
ENTRY( foo_activate, XMDrawnButton, draw_button_1, tag, callback_data)
    int scale_value;
    Boolean toggle_state;
 printf ("foo_activate ...\n");
}

// -------------------------------------------------------
EVENT(postmenu,XMBulletinBoard,bb,client_data, event)
// -------------------------------------------------------
printf ("postmenu 1\n");
    if (event->xbutton.button != Button3)
        return;
XMPopupMenu* popup;

printf ("postmenu 2\n");

popup = (XMPopupMenu*) client_data;

    popup->MenuPosition((XButtonPressedEvent*) event);
    popup->Manage ();
}


Pixmap pix;
GC     gc;

// -------------------------------------------------------
int logo(XMDrawnButton* drawn)
// -------------------------------------------------------
{
  Pixmap       bitmap;

  bitmap = XCreateBitmapFromData (XtDisplay(drawn->get_widget()),  
                                  RootWindowOfScreen(XtScreen(drawn->get_widget())),
                                  xlogo32_bits, xlogo32_width, xlogo32_height);

  pix = XCreatePixmap (XtDisplay (drawn->get_widget()), 
                       RootWindowOfScreen (XtScreen (drawn->get_widget())),
                       xlogo32_width, xlogo32_height,
                       DefaultDepthOfScreen (XtScreen (drawn->get_widget())));

  XGCValues    values;
  drawn->get_foreground(&values.foreground);
  drawn->get_background(&values.background);
  gc = XtGetGC (drawn->get_widget(), GCForeground | GCBackground, &values);
  XCopyPlane (XtDisplay (drawn->get_widget()), bitmap, pix, gc, 2, 2, 
              xlogo32_width, xlogo32_height, 2, 2, 1);

  XFreePixmap (XtDisplay (drawn->get_widget()), bitmap);

  drawn->set_entry_exposeCallback( redisplay,NULL);
}

// -------------------------------------------------------
ENTRY( redisplay, XMDrawnButton, drawn, client_data, call_data)
// -------------------------------------------------------
  XCopyArea (XtDisplay (drawn->get_widget()), pix, XtWindow (drawn->get_widget()), gc,
             2, 2, xlogo32_width, xlogo32_height, 2, 2);
}
GC     draw_face_gc;

int draw_face(XMDrawingArea* drawn)
{
  XGCValues    values;
  drawn->get_foreground(&values.foreground);
  drawn->get_background(&values.background);
  draw_face_gc = XtGetGC (drawn->get_widget(), GCForeground | GCBackground, &values);
  XFillArc(XtDisplay (drawn->get_widget()),XtWindow (drawn->get_widget()), draw_face_gc,
		1,1,30,30,64*0, 64*360); 
  drawn->set_entry_exposeCallback( draw_face_redisplay,NULL);
}

// -------------------------------------------------------
ENTRY( draw_face_redisplay, XMDrawingArea, drawn, client_data, call_data)
// -------------------------------------------------------
   XFillArc(XtDisplay (drawn->get_widget()),XtWindow (drawn->get_widget()), draw_face_gc,
		1,1,30,30,64*0, 64*360);
}

