/*
(C) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
*/

/*
	fasl_table.c
	DG-SPECIFIC
*/

#include "include.h"
#include "../h/fasl.h"
#include "../h/fasl_global.h"

PART_TABLE_P
fasl_new_table()
{
	PART_TABLE_P	table_p;

	if (((max_part_no + 1) % FAS_TABLES_IN_REC) == 0) {
		/* assign new record */
		fasl_write_temp();
		fas_temp_curr = ++fas_temp_last;
		zero(fas_temp_buff, FAS_BUFF_LEN);
		}
		else
		/* there is a room in last record */
		if (fas_temp_curr != fas_temp_last) {
			fasl_write_temp();
			fasl_read_temp(fas_temp_last);
			}

	max_part_no++;
	table_p = (PART_TABLE_P)fas_temp_buff +
		  max_part_no % FAS_TABLES_IN_REC;
	table_p->part_no = max_part_no;
	return(table_p);
}

PART_TABLE_P
fasl_get_table(base)
short	base;
{
	int		rec_no;
	PART_TABLE_P	table_p;

	rec_no = base / FAS_TABLES_IN_REC;
	table_p = (PART_TABLE_P)fas_temp_buff +
		  base % FAS_TABLES_IN_REC;
	if (rec_no == fas_temp_curr) return(table_p);

	/* we must flush current buffer ? */
	if (fas_temp_flush == TRUE) fasl_write_temp();
	fasl_read_temp(rec_no);

	return(table_p);
}

int
fasl_get_addr(base)
{
	int	recno, ind;

	if (base == vs_base_no) return(&vs_base);
	if (base == vs_top_no) return(&vs_top);

	recno = base / FAS_ADDRS_IN_REC;
	ind = base % FAS_ADDRS_IN_REC;

	if (recno != fas_addr_rec_curr)
		fasl_read_addr_rec(recno);

	return( ((int *)fas_addr_buff)[ind] );
}
