 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 *   Copyright, 1991, The Regents of the University of California.
 *   This software was produced under a U.S. Government contract
 *   (W-7405-ENG-36) by the Los Alamos National Laboratory, which is
 *   operated by the University of California for the U.S. Department
 *   of Energy.  The U.S. Government is licensed to use, reproduce,
 *   and distribute this software.  Neither the Government nor the
 *   University makes any warranty, express or implied, or assumes
 *   any liability responsibility for the use of this software.
 */

#include <stdio.h>

#include "lanlmisc.h"

#define COUNT_COL_PRESENT 1
#define CLASS_COL_PRESENT 2
#define COV_UPPER_PRESENT 4
#define COV_DIAG_PRESENT 8

#define FALSE 0
#define TRUE 1

/*
 *  putstats ()     Given the data statistics, this routine creates the 
 *                  storage area for a floating-point VIFF statistics
 *                  map.  If an entry is not present, then the pointer
 *                  passed in should be NULL.
 *
 *  Written by:  Patrick M. Kelly & James M. White
 *  Date:        6-26-91
 */

int putstats (ptr,ispare1,dim,num,means,count,class,cov_upper,cov_diag)

float **ptr;		/* Pointer to map data (OUTPUT) */
unsigned long *ispare1;	/* Determine what is present in the map data (OUTPUT) */
int dim;		/* Dimension of the data */
int num;		/* Number of table entries */
float **means;		/* (INPUT) Mean vector data */
int *count;		/* (INPUT) Number of members data */
int *class;		/* (INPUT) Class number data */
float ***cov_upper;	/* (INPUT) Upper triangular covariance matrix data */
float **cov_diag;	/* (INPUT) Variances of the data */

{
   int numcols,r,c,start;
   float **ptr2;

   /*
    *  (1)  Determine what is being stored and allocate memory.
    */

   (*ispare1) = 0;

   numcols = dim;           /* Mean vectors must be present */

   if ( count != NULL ) {
      numcols ++ ;
      (*ispare1) |= COUNT_COL_PRESENT;
   }

   if ( class != NULL ) {
      numcols ++ ;
      (*ispare1) |= CLASS_COL_PRESENT;
   }

   if ( cov_upper != NULL ) {
      numcols += ((dim * (dim+1))/2);
      if ( cov_diag != NULL ) {
        fprintf (stderr,"putstats: WARNING: Only writing out upper covariance");
        fprintf (stderr," matrix\n");
        cov_diag = NULL;
      }
      (*ispare1) |= COV_UPPER_PRESENT;
   } else if ( cov_diag != NULL ) {
      numcols += dim ;
      (*ispare1) |= COV_DIAG_PRESENT;
   }

   ptr2 = contig_matrix ( numcols, num );
   *ptr = *ptr2;

   /*
    *  (2)  GET MEAN VECTOR DATA:  ALWAYS PRESENT
    */

   start = 0;

   for ( r = 0 ; r < num ; r ++ ) {
   for ( c = 0 ; c < dim ; c ++ ) {
     ptr2 [c+start][r] = means [r][c];
   }
   }

   start += dim ;

   /*
    *  (3)  GET COUNT DATA
    */

   if ( (*ispare1) & COUNT_COL_PRESENT ) {
      for ( r = 0 ; r < num ; r ++ ) {
         ptr2 [start][r] = (float) count [r];
      }
      start ++ ;
   }

   /*
    *  (4)  GET CLASS DATA
    */

   if ( (*ispare1) & CLASS_COL_PRESENT ) {
      for ( r = 0 ; r < num ; r ++ ) {
         ptr2 [start][r] = (float) class [r];
      }
      start ++ ;
   }

   /*
    *  (5)  GET UPPER-TRIANGULAR COVARIANCE MATRIX.
    */

   if ( (*ispare1) & COV_UPPER_PRESENT ) {
      for ( r = 0 ; r < num ; r ++ ) {
      for ( c = 0 ; c < ((dim * (dim+1))/2) ; c ++ ) {
        ptr2 [c+start][r] = cov_upper [r][0][c];
      }
      }
      start += ((dim * (dim+1))/2) ;
   }

   /*
    *  (6)  GET UPPER-TRIANGULAR COVARIANCE MATRIX.
    */
   if ( (*ispare1) & COV_DIAG_PRESENT ) {
      for ( r = 0 ; r < num ; r ++ ) {
      for ( c = 0 ; c < dim ; c ++ ) {
        ptr2 [c+start][r] = cov_diag [r][c];
      }
      }
      start += dim ;
   }

   return (TRUE);
}
