# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.edgeactions import EdgeActionsMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEdgeActionsMgmtEdgeActionExecutionFiltersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EdgeActionsMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_edge_action_execution_filters_get(self, resource_group):
        response = self.client.edge_action_execution_filters.get(
            resource_group_name=resource_group.name,
            edge_action_name="str",
            execution_filter="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_edge_action_execution_filters_begin_create(self, resource_group):
        response = self.client.edge_action_execution_filters.begin_create(
            resource_group_name=resource_group.name,
            edge_action_name="str",
            execution_filter="str",
            resource={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "executionFilterIdentifierHeaderName": "str",
                    "executionFilterIdentifierHeaderValue": "str",
                    "versionId": "str",
                    "lastUpdateTime": "2020-02-20 00:00:00",
                    "provisioningState": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_edge_action_execution_filters_begin_update(self, resource_group):
        response = self.client.edge_action_execution_filters.begin_update(
            resource_group_name=resource_group.name,
            edge_action_name="str",
            execution_filter="str",
            properties={
                "properties": {
                    "executionFilterIdentifierHeaderName": "str",
                    "executionFilterIdentifierHeaderValue": "str",
                    "versionId": "str",
                },
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_edge_action_execution_filters_begin_delete(self, resource_group):
        response = self.client.edge_action_execution_filters.begin_delete(
            resource_group_name=resource_group.name,
            edge_action_name="str",
            execution_filter="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_edge_action_execution_filters_list_by_edge_action(self, resource_group):
        response = self.client.edge_action_execution_filters.list_by_edge_action(
            resource_group_name=resource_group.name,
            edge_action_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
