# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.managementgroups.aio import ManagementGroupsAPI

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestManagementGroupsAPIManagementGroupsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ManagementGroupsAPI, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_management_groups_list(self, resource_group):
        response = self.client.management_groups.list(
            api_version="2021-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_management_groups_get(self, resource_group):
        response = await self.client.management_groups.get(
            group_id="str",
            api_version="2021-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_management_groups_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.management_groups.begin_create_or_update(
                group_id="str",
                create_management_group_request={
                    "children": [{"children": [...], "displayName": "str", "id": "str", "name": "str", "type": "str"}],
                    "details": {
                        "parent": {"displayName": "str", "id": "str", "name": "str"},
                        "updatedBy": "str",
                        "updatedTime": "2020-02-20 00:00:00",
                        "version": 0,
                    },
                    "displayName": "str",
                    "id": "str",
                    "name": "str",
                    "tenantId": "str",
                    "type": "str",
                },
                api_version="2021-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_management_groups_update(self, resource_group):
        response = await self.client.management_groups.update(
            group_id="str",
            patch_group_request={"displayName": "str", "parentGroupId": "str"},
            api_version="2021-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_management_groups_begin_delete(self, resource_group):
        response = await (
            await self.client.management_groups.begin_delete(
                group_id="str",
                api_version="2021-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_management_groups_get_descendants(self, resource_group):
        response = self.client.management_groups.get_descendants(
            group_id="str",
            api_version="2021-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
