# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementPrivateDnsZoneGroupsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_dns_zone_groups_begin_delete(self, resource_group):
        response = self.client.private_dns_zone_groups.begin_delete(
            resource_group_name=resource_group.name,
            private_endpoint_name="str",
            private_dns_zone_group_name="str",
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_dns_zone_groups_get(self, resource_group):
        response = self.client.private_dns_zone_groups.get(
            resource_group_name=resource_group.name,
            private_endpoint_name="str",
            private_dns_zone_group_name="str",
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_dns_zone_groups_begin_create_or_update(self, resource_group):
        response = self.client.private_dns_zone_groups.begin_create_or_update(
            resource_group_name=resource_group.name,
            private_endpoint_name="str",
            private_dns_zone_group_name="str",
            parameters={
                "etag": "str",
                "id": "str",
                "name": "str",
                "privateDnsZoneConfigs": [
                    {
                        "name": "str",
                        "privateDnsZoneId": "str",
                        "recordSets": [
                            {
                                "fqdn": "str",
                                "ipAddresses": ["str"],
                                "provisioningState": "str",
                                "recordSetName": "str",
                                "recordType": "str",
                                "ttl": 0,
                            }
                        ],
                    }
                ],
                "provisioningState": "str",
            },
            api_version="2025-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_dns_zone_groups_list(self, resource_group):
        response = self.client.private_dns_zone_groups.list(
            private_endpoint_name="str",
            resource_group_name=resource_group.name,
            api_version="2025-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
