# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.postgresqlflexibleservers import PostgreSQLManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPostgreSQLManagementServersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PostgreSQLManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_servers_get(self, resource_group):
        response = self.client.servers.get(
            resource_group_name=resource_group.name,
            server_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_servers_begin_create_or_update(self, resource_group):
        response = self.client.servers.begin_create_or_update(
            resource_group_name=resource_group.name,
            server_name="str",
            parameters={
                "location": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "properties": {
                    "administratorLogin": "str",
                    "administratorLoginPassword": "str",
                    "authConfig": {"activeDirectoryAuth": "str", "passwordAuth": "str", "tenantId": "str"},
                    "availabilityZone": "str",
                    "backup": {
                        "backupRetentionDays": 0,
                        "earliestRestoreDate": "2020-02-20 00:00:00",
                        "geoRedundantBackup": "str",
                    },
                    "cluster": {"clusterSize": 0, "defaultDatabaseName": "str"},
                    "createMode": "str",
                    "dataEncryption": {
                        "geoBackupEncryptionKeyStatus": "str",
                        "geoBackupKeyURI": "str",
                        "geoBackupUserAssignedIdentityId": "str",
                        "primaryEncryptionKeyStatus": "str",
                        "primaryKeyURI": "str",
                        "primaryUserAssignedIdentityId": "str",
                        "type": "str",
                    },
                    "fullyQualifiedDomainName": "str",
                    "highAvailability": {"mode": "str", "standbyAvailabilityZone": "str", "state": "str"},
                    "maintenanceWindow": {"customWindow": "str", "dayOfWeek": 0, "startHour": 0, "startMinute": 0},
                    "minorVersion": "str",
                    "network": {
                        "delegatedSubnetResourceId": "str",
                        "privateDnsZoneArmResourceId": "str",
                        "publicNetworkAccess": "str",
                    },
                    "pointInTimeUTC": "2020-02-20 00:00:00",
                    "privateEndpointConnections": [
                        {
                            "id": "str",
                            "name": "str",
                            "properties": {
                                "privateLinkServiceConnectionState": {
                                    "actionsRequired": "str",
                                    "description": "str",
                                    "status": "str",
                                },
                                "groupIds": ["str"],
                                "privateEndpoint": {"id": "str"},
                                "provisioningState": "str",
                            },
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "replica": {
                        "capacity": 0,
                        "promoteMode": "str",
                        "promoteOption": "str",
                        "replicationState": "str",
                        "role": "str",
                    },
                    "replicaCapacity": 0,
                    "replicationRole": "str",
                    "sourceServerResourceId": "str",
                    "state": "str",
                    "storage": {
                        "autoGrow": "str",
                        "iops": 0,
                        "storageSizeGB": 0,
                        "throughput": 0,
                        "tier": "str",
                        "type": "str",
                    },
                    "version": "str",
                },
                "sku": {"name": "str", "tier": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_servers_begin_update(self, resource_group):
        response = self.client.servers.begin_update(
            resource_group_name=resource_group.name,
            server_name="str",
            parameters={
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "properties": {
                    "administratorLogin": "str",
                    "administratorLoginPassword": "str",
                    "authConfig": {"activeDirectoryAuth": "str", "passwordAuth": "str", "tenantId": "str"},
                    "availabilityZone": "str",
                    "backup": {
                        "backupRetentionDays": 0,
                        "earliestRestoreDate": "2020-02-20 00:00:00",
                        "geoRedundantBackup": "str",
                    },
                    "cluster": {"clusterSize": 0, "defaultDatabaseName": "str"},
                    "createMode": "str",
                    "dataEncryption": {
                        "geoBackupEncryptionKeyStatus": "str",
                        "geoBackupKeyURI": "str",
                        "geoBackupUserAssignedIdentityId": "str",
                        "primaryEncryptionKeyStatus": "str",
                        "primaryKeyURI": "str",
                        "primaryUserAssignedIdentityId": "str",
                        "type": "str",
                    },
                    "highAvailability": {"mode": "str", "standbyAvailabilityZone": "str", "state": "str"},
                    "maintenanceWindow": {"customWindow": "str", "dayOfWeek": 0, "startHour": 0, "startMinute": 0},
                    "network": {
                        "delegatedSubnetResourceId": "str",
                        "privateDnsZoneArmResourceId": "str",
                        "publicNetworkAccess": "str",
                    },
                    "replica": {
                        "capacity": 0,
                        "promoteMode": "str",
                        "promoteOption": "str",
                        "replicationState": "str",
                        "role": "str",
                    },
                    "replicationRole": "str",
                    "storage": {
                        "autoGrow": "str",
                        "iops": 0,
                        "storageSizeGB": 0,
                        "throughput": 0,
                        "tier": "str",
                        "type": "str",
                    },
                    "version": "str",
                },
                "sku": {"name": "str", "tier": "str"},
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_servers_begin_delete(self, resource_group):
        response = self.client.servers.begin_delete(
            resource_group_name=resource_group.name,
            server_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_servers_list_by_resource_group(self, resource_group):
        response = self.client.servers.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_servers_list_by_subscription(self, resource_group):
        response = self.client.servers.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_servers_begin_restart(self, resource_group):
        response = self.client.servers.begin_restart(
            resource_group_name=resource_group.name,
            server_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_servers_begin_start(self, resource_group):
        response = self.client.servers.begin_start(
            resource_group_name=resource_group.name,
            server_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_servers_begin_stop(self, resource_group):
        response = self.client.servers.begin_stop(
            resource_group_name=resource_group.name,
            server_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_servers_begin_migrate_network_mode(self, resource_group):
        response = self.client.servers.begin_migrate_network_mode(
            resource_group_name=resource_group.name,
            server_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
