# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.redhatopenshift import AzureRedHatOpenShiftClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-redhatopenshift
# USAGE
    python open_shift_clusters_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = AzureRedHatOpenShiftClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-0000-0000-0000-000000000000",
    )

    response = client.open_shift_clusters.begin_update(
        resource_group_name="resourceGroup",
        resource_name="resourceName",
        parameters={
            "identity": {"type": "UserAssigned", "userAssignedIdentities": {"": {}}},
            "properties": {
                "apiserverProfile": {"visibility": "Public"},
                "clusterProfile": {
                    "domain": "cluster.location.aroapp.io",
                    "fipsValidatedModules": "Enabled",
                    "pullSecret": '{"auths":{"registry.connect.redhat.com":{"auth":""},"registry.redhat.io":{"auth":""}}}',
                    "resourceGroupId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/clusterResourceGroup",
                },
                "consoleProfile": {},
                "ingressProfiles": [{"name": "default", "visibility": "Public"}],
                "masterProfile": {
                    "encryptionAtHost": "Enabled",
                    "subnetId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/vnetResourceGroup/providers/Microsoft.Network/virtualNetworks/vnet/subnets/master",
                    "vmSize": "Standard_D8s_v3",
                },
                "networkProfile": {
                    "loadBalancerProfile": {"managedOutboundIps": {"count": 1}},
                    "podCidr": "10.128.0.0/14",
                    "preconfiguredNSG": "Disabled",
                    "serviceCidr": "172.30.0.0/16",
                },
                "platformWorkloadIdentityProfile": {"platformWorkloadIdentities": {"": {}}},
                "servicePrincipalProfile": {"clientId": "clientId", "clientSecret": "clientSecret"},
                "workerProfiles": [
                    {
                        "count": 3,
                        "diskSizeGB": 128,
                        "name": "worker",
                        "subnetId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/vnetResourceGroup/providers/Microsoft.Network/virtualNetworks/vnet/subnets/worker",
                        "vmSize": "Standard_D2s_v3",
                    }
                ],
            },
            "tags": {"key": "value"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/redhatopenshift/resource-manager/Microsoft.RedHatOpenShift/OpenShiftClusters/stable/2025-07-25/examples/OpenShiftClusters_Update.json
if __name__ == "__main__":
    main()
