# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, Callable, IO, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models2
from .... import models as _models3
from ...._utils.model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from ...._utils.utils import ClientMixinABC
from ..._operations._operations import build_knowledge_base_retrieval_retrieve_request
from .._configuration import KnowledgeBaseRetrievalClientConfiguration

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]


class _KnowledgeBaseRetrievalClientOperationsMixin(
    ClientMixinABC[AsyncPipelineClient[HttpRequest, AsyncHttpResponse], KnowledgeBaseRetrievalClientConfiguration]
):

    @overload
    async def retrieve(
        self,
        knowledge_base_name: str,
        retrieval_request: _models2.KnowledgeBaseRetrievalRequest,
        *,
        query_source_authorization: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models2.KnowledgeBaseRetrievalResponse:
        """KnowledgeBase retrieves relevant data from backing stores.

        :param knowledge_base_name: The name of the knowledge base. Required.
        :type knowledge_base_name: str
        :param retrieval_request: The retrieval request to process. Required.
        :type retrieval_request:
         ~azure.search.documents.knowledgebases.models.KnowledgeBaseRetrievalRequest
        :keyword query_source_authorization: Token identifying the user for which the query is being
         executed. This token is used to enforce security restrictions on documents. Default value is
         None.
        :paramtype query_source_authorization: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: KnowledgeBaseRetrievalResponse. The KnowledgeBaseRetrievalResponse is compatible with
         MutableMapping
        :rtype: ~azure.search.documents.knowledgebases.models.KnowledgeBaseRetrievalResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def retrieve(
        self,
        knowledge_base_name: str,
        retrieval_request: JSON,
        *,
        query_source_authorization: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models2.KnowledgeBaseRetrievalResponse:
        """KnowledgeBase retrieves relevant data from backing stores.

        :param knowledge_base_name: The name of the knowledge base. Required.
        :type knowledge_base_name: str
        :param retrieval_request: The retrieval request to process. Required.
        :type retrieval_request: JSON
        :keyword query_source_authorization: Token identifying the user for which the query is being
         executed. This token is used to enforce security restrictions on documents. Default value is
         None.
        :paramtype query_source_authorization: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: KnowledgeBaseRetrievalResponse. The KnowledgeBaseRetrievalResponse is compatible with
         MutableMapping
        :rtype: ~azure.search.documents.knowledgebases.models.KnowledgeBaseRetrievalResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def retrieve(
        self,
        knowledge_base_name: str,
        retrieval_request: IO[bytes],
        *,
        query_source_authorization: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models2.KnowledgeBaseRetrievalResponse:
        """KnowledgeBase retrieves relevant data from backing stores.

        :param knowledge_base_name: The name of the knowledge base. Required.
        :type knowledge_base_name: str
        :param retrieval_request: The retrieval request to process. Required.
        :type retrieval_request: IO[bytes]
        :keyword query_source_authorization: Token identifying the user for which the query is being
         executed. This token is used to enforce security restrictions on documents. Default value is
         None.
        :paramtype query_source_authorization: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: KnowledgeBaseRetrievalResponse. The KnowledgeBaseRetrievalResponse is compatible with
         MutableMapping
        :rtype: ~azure.search.documents.knowledgebases.models.KnowledgeBaseRetrievalResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def retrieve(
        self,
        knowledge_base_name: str,
        retrieval_request: Union[_models2.KnowledgeBaseRetrievalRequest, JSON, IO[bytes]],
        *,
        query_source_authorization: Optional[str] = None,
        **kwargs: Any
    ) -> _models2.KnowledgeBaseRetrievalResponse:
        """KnowledgeBase retrieves relevant data from backing stores.

        :param knowledge_base_name: The name of the knowledge base. Required.
        :type knowledge_base_name: str
        :param retrieval_request: The retrieval request to process. Is one of the following types:
         KnowledgeBaseRetrievalRequest, JSON, IO[bytes] Required.
        :type retrieval_request:
         ~azure.search.documents.knowledgebases.models.KnowledgeBaseRetrievalRequest or JSON or
         IO[bytes]
        :keyword query_source_authorization: Token identifying the user for which the query is being
         executed. This token is used to enforce security restrictions on documents. Default value is
         None.
        :paramtype query_source_authorization: str
        :return: KnowledgeBaseRetrievalResponse. The KnowledgeBaseRetrievalResponse is compatible with
         MutableMapping
        :rtype: ~azure.search.documents.knowledgebases.models.KnowledgeBaseRetrievalResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models2.KnowledgeBaseRetrievalResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(retrieval_request, (IOBase, bytes)):
            _content = retrieval_request
        else:
            _content = json.dumps(retrieval_request, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_knowledge_base_retrieval_retrieve_request(
            knowledge_base_name=knowledge_base_name,
            query_source_authorization=query_source_authorization,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 206]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models3.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models2.KnowledgeBaseRetrievalResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
