# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.servicefabricmanagedclusters import ServiceFabricManagedClustersManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-servicefabricmanagedclusters
# USAGE
    python managed_cluster_put_operation_example_max.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ServiceFabricManagedClustersManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.managed_clusters.begin_create_or_update(
        resource_group_name="resRg",
        cluster_name="mycluster",
        parameters={
            "location": "eastus",
            "properties": {
                "addonFeatures": ["DnsService", "BackupRestoreService", "ResourceMonitorService"],
                "adminPassword": "{vm-password}",
                "adminUserName": "vmadmin",
                "allocatedOutboundPorts": 0,
                "allowRdpAccess": True,
                "applicationTypeVersionsCleanupPolicy": {"maxUnusedVersionsToKeep": 3},
                "autoGeneratedDomainNameLabelScope": "SubscriptionReuse",
                "auxiliarySubnets": [
                    {
                        "enableIpv6": True,
                        "name": "testSubnet1",
                        "networkSecurityGroupId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/networkSecurityGroups/sn1",
                        "privateEndpointNetworkPolicies": "enabled",
                        "privateLinkServiceNetworkPolicies": "enabled",
                    }
                ],
                "clientConnectionPort": 19000,
                "clusterCodeVersion": "7.1.168.9494",
                "clusterUpgradeMode": "Manual",
                "ddosProtectionPlanId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/ddosProtectionPlans/myDDoSProtectionPlan",
                "dnsName": "mycluster",
                "enableAutoOSUpgrade": True,
                "enableHttpGatewayExclusiveAuthMode": True,
                "enableIpv6": True,
                "enableOutboundOnlyNodeTypes": True,
                "fabricSettings": [
                    {"name": "ManagedIdentityTokenService", "parameters": [{"name": "IsEnabled", "value": "true"}]}
                ],
                "httpGatewayConnectionPort": 19080,
                "httpGatewayTokenAuthConnectionPort": 19081,
                "ipTags": [{"ipTagType": "FirstPartyUsage", "tag": "SQL"}],
                "loadBalancingRules": [
                    {
                        "backendPort": 80,
                        "frontendPort": 80,
                        "probePort": 80,
                        "probeProtocol": "http",
                        "protocol": "http",
                    },
                    {
                        "backendPort": 443,
                        "frontendPort": 443,
                        "probePort": 443,
                        "probeProtocol": "http",
                        "protocol": "http",
                    },
                    {
                        "backendPort": 10000,
                        "frontendPort": 10000,
                        "loadDistribution": "Default",
                        "probePort": 10000,
                        "probeProtocol": "http",
                        "protocol": "tcp",
                    },
                ],
                "networkSecurityRules": [
                    {
                        "access": "allow",
                        "description": "Test description",
                        "destinationAddressPrefixes": ["*"],
                        "destinationPortRanges": ["*"],
                        "direction": "inbound",
                        "name": "TestName",
                        "priority": 1010,
                        "protocol": "tcp",
                        "sourceAddressPrefixes": ["*"],
                        "sourcePortRanges": ["*"],
                    },
                    {
                        "access": "allow",
                        "destinationAddressPrefix": "*",
                        "destinationPortRange": "33500-33699",
                        "direction": "inbound",
                        "name": "AllowARM",
                        "priority": 2002,
                        "protocol": "*",
                        "sourceAddressPrefix": "AzureResourceManager",
                        "sourcePortRange": "*",
                    },
                ],
                "publicIPPrefixId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.Network/publicIPPrefixes/myPublicIPPrefix",
                "publicIPv6PrefixId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.Network/publicIPPrefixes/myPublicIPv6Prefix",
                "serviceEndpoints": [
                    {
                        "locations": ["eastus2", "usnorth"],
                        "networkIdentifier": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/publicIPAddresses/myPublicIP",
                        "service": "Microsoft.Storage",
                    }
                ],
                "skipManagedNsgAssignment": True,
                "upgradeDescription": {
                    "deltaHealthPolicy": {
                        "maxPercentDeltaUnhealthyApplications": 40,
                        "maxPercentDeltaUnhealthyNodes": 20,
                        "maxPercentUpgradeDomainDeltaUnhealthyNodes": 40,
                    },
                    "forceRestart": False,
                    "healthPolicy": {"maxPercentUnhealthyApplications": 30, "maxPercentUnhealthyNodes": 10},
                    "monitoringPolicy": {
                        "healthCheckRetryTimeout": "00:55:00",
                        "healthCheckStableDuration": "00:45:00",
                        "healthCheckWaitDuration": "00:05:00",
                        "upgradeDomainTimeout": "03:00:00",
                        "upgradeTimeout": "12:00:00",
                    },
                },
                "useCustomVnet": True,
                "zonalResiliency": True,
                "zonalUpdateMode": "Fast",
            },
            "sku": {"name": "Basic"},
            "tags": {},
        },
    ).result()
    print(response)


# x-ms-original-file: 2026-02-01/ManagedClusterPutOperation_example_max.json
if __name__ == "__main__":
    main()
