# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import Dict, List, Union, Optional
from typing_extensions import Literal, Annotated, TypeAlias

from ..._utils import PropertyInfo
from ..._models import BaseModel
from .easy_input_message import EasyInputMessage
from .response_output_message import ResponseOutputMessage
from .response_reasoning_item import ResponseReasoningItem
from .response_custom_tool_call import ResponseCustomToolCall
from .response_computer_tool_call import ResponseComputerToolCall
from .response_function_tool_call import ResponseFunctionToolCall
from .response_function_web_search import ResponseFunctionWebSearch
from .response_compaction_item_param import ResponseCompactionItemParam
from .response_file_search_tool_call import ResponseFileSearchToolCall
from .response_custom_tool_call_output import ResponseCustomToolCallOutput
from .response_code_interpreter_tool_call import ResponseCodeInterpreterToolCall
from .response_input_message_content_list import ResponseInputMessageContentList
from .response_function_call_output_item_list import ResponseFunctionCallOutputItemList
from .response_function_shell_call_output_content import ResponseFunctionShellCallOutputContent
from .response_computer_tool_call_output_screenshot import ResponseComputerToolCallOutputScreenshot

__all__ = [
    "ResponseInputItem",
    "Message",
    "ComputerCallOutput",
    "ComputerCallOutputAcknowledgedSafetyCheck",
    "FunctionCallOutput",
    "ImageGenerationCall",
    "LocalShellCall",
    "LocalShellCallAction",
    "LocalShellCallOutput",
    "ShellCall",
    "ShellCallAction",
    "ShellCallOutput",
    "ApplyPatchCall",
    "ApplyPatchCallOperation",
    "ApplyPatchCallOperationCreateFile",
    "ApplyPatchCallOperationDeleteFile",
    "ApplyPatchCallOperationUpdateFile",
    "ApplyPatchCallOutput",
    "McpListTools",
    "McpListToolsTool",
    "McpApprovalRequest",
    "McpApprovalResponse",
    "McpCall",
    "ItemReference",
]


class Message(BaseModel):
    """
    A message input to the model with a role indicating instruction following
    hierarchy. Instructions given with the `developer` or `system` role take
    precedence over instructions given with the `user` role.
    """

    content: ResponseInputMessageContentList
    """
    A list of one or many input items to the model, containing different content
    types.
    """

    role: Literal["user", "system", "developer"]
    """The role of the message input. One of `user`, `system`, or `developer`."""

    status: Optional[Literal["in_progress", "completed", "incomplete"]] = None
    """The status of item.

    One of `in_progress`, `completed`, or `incomplete`. Populated when items are
    returned via API.
    """

    type: Optional[Literal["message"]] = None
    """The type of the message input. Always set to `message`."""


class ComputerCallOutputAcknowledgedSafetyCheck(BaseModel):
    """A pending safety check for the computer call."""

    id: str
    """The ID of the pending safety check."""

    code: Optional[str] = None
    """The type of the pending safety check."""

    message: Optional[str] = None
    """Details about the pending safety check."""


class ComputerCallOutput(BaseModel):
    """The output of a computer tool call."""

    call_id: str
    """The ID of the computer tool call that produced the output."""

    output: ResponseComputerToolCallOutputScreenshot
    """A computer screenshot image used with the computer use tool."""

    type: Literal["computer_call_output"]
    """The type of the computer tool call output. Always `computer_call_output`."""

    id: Optional[str] = None
    """The ID of the computer tool call output."""

    acknowledged_safety_checks: Optional[List[ComputerCallOutputAcknowledgedSafetyCheck]] = None
    """
    The safety checks reported by the API that have been acknowledged by the
    developer.
    """

    status: Optional[Literal["in_progress", "completed", "incomplete"]] = None
    """The status of the message input.

    One of `in_progress`, `completed`, or `incomplete`. Populated when input items
    are returned via API.
    """


class FunctionCallOutput(BaseModel):
    """The output of a function tool call."""

    call_id: str
    """The unique ID of the function tool call generated by the model."""

    output: Union[str, ResponseFunctionCallOutputItemList]
    """Text, image, or file output of the function tool call."""

    type: Literal["function_call_output"]
    """The type of the function tool call output. Always `function_call_output`."""

    id: Optional[str] = None
    """The unique ID of the function tool call output.

    Populated when this item is returned via API.
    """

    status: Optional[Literal["in_progress", "completed", "incomplete"]] = None
    """The status of the item.

    One of `in_progress`, `completed`, or `incomplete`. Populated when items are
    returned via API.
    """


class ImageGenerationCall(BaseModel):
    """An image generation request made by the model."""

    id: str
    """The unique ID of the image generation call."""

    result: Optional[str] = None
    """The generated image encoded in base64."""

    status: Literal["in_progress", "completed", "generating", "failed"]
    """The status of the image generation call."""

    type: Literal["image_generation_call"]
    """The type of the image generation call. Always `image_generation_call`."""


class LocalShellCallAction(BaseModel):
    """Execute a shell command on the server."""

    command: List[str]
    """The command to run."""

    env: Dict[str, str]
    """Environment variables to set for the command."""

    type: Literal["exec"]
    """The type of the local shell action. Always `exec`."""

    timeout_ms: Optional[int] = None
    """Optional timeout in milliseconds for the command."""

    user: Optional[str] = None
    """Optional user to run the command as."""

    working_directory: Optional[str] = None
    """Optional working directory to run the command in."""


class LocalShellCall(BaseModel):
    """A tool call to run a command on the local shell."""

    id: str
    """The unique ID of the local shell call."""

    action: LocalShellCallAction
    """Execute a shell command on the server."""

    call_id: str
    """The unique ID of the local shell tool call generated by the model."""

    status: Literal["in_progress", "completed", "incomplete"]
    """The status of the local shell call."""

    type: Literal["local_shell_call"]
    """The type of the local shell call. Always `local_shell_call`."""


class LocalShellCallOutput(BaseModel):
    """The output of a local shell tool call."""

    id: str
    """The unique ID of the local shell tool call generated by the model."""

    output: str
    """A JSON string of the output of the local shell tool call."""

    type: Literal["local_shell_call_output"]
    """The type of the local shell tool call output. Always `local_shell_call_output`."""

    status: Optional[Literal["in_progress", "completed", "incomplete"]] = None
    """The status of the item. One of `in_progress`, `completed`, or `incomplete`."""


class ShellCallAction(BaseModel):
    """The shell commands and limits that describe how to run the tool call."""

    commands: List[str]
    """Ordered shell commands for the execution environment to run."""

    max_output_length: Optional[int] = None
    """
    Maximum number of UTF-8 characters to capture from combined stdout and stderr
    output.
    """

    timeout_ms: Optional[int] = None
    """Maximum wall-clock time in milliseconds to allow the shell commands to run."""


class ShellCall(BaseModel):
    """A tool representing a request to execute one or more shell commands."""

    action: ShellCallAction
    """The shell commands and limits that describe how to run the tool call."""

    call_id: str
    """The unique ID of the shell tool call generated by the model."""

    type: Literal["shell_call"]
    """The type of the item. Always `shell_call`."""

    id: Optional[str] = None
    """The unique ID of the shell tool call.

    Populated when this item is returned via API.
    """

    status: Optional[Literal["in_progress", "completed", "incomplete"]] = None
    """The status of the shell call.

    One of `in_progress`, `completed`, or `incomplete`.
    """


class ShellCallOutput(BaseModel):
    """The streamed output items emitted by a shell tool call."""

    call_id: str
    """The unique ID of the shell tool call generated by the model."""

    output: List[ResponseFunctionShellCallOutputContent]
    """
    Captured chunks of stdout and stderr output, along with their associated
    outcomes.
    """

    type: Literal["shell_call_output"]
    """The type of the item. Always `shell_call_output`."""

    id: Optional[str] = None
    """The unique ID of the shell tool call output.

    Populated when this item is returned via API.
    """

    max_output_length: Optional[int] = None
    """
    The maximum number of UTF-8 characters captured for this shell call's combined
    output.
    """


class ApplyPatchCallOperationCreateFile(BaseModel):
    """Instruction for creating a new file via the apply_patch tool."""

    diff: str
    """Unified diff content to apply when creating the file."""

    path: str
    """Path of the file to create relative to the workspace root."""

    type: Literal["create_file"]
    """The operation type. Always `create_file`."""


class ApplyPatchCallOperationDeleteFile(BaseModel):
    """Instruction for deleting an existing file via the apply_patch tool."""

    path: str
    """Path of the file to delete relative to the workspace root."""

    type: Literal["delete_file"]
    """The operation type. Always `delete_file`."""


class ApplyPatchCallOperationUpdateFile(BaseModel):
    """Instruction for updating an existing file via the apply_patch tool."""

    diff: str
    """Unified diff content to apply to the existing file."""

    path: str
    """Path of the file to update relative to the workspace root."""

    type: Literal["update_file"]
    """The operation type. Always `update_file`."""


ApplyPatchCallOperation: TypeAlias = Annotated[
    Union[ApplyPatchCallOperationCreateFile, ApplyPatchCallOperationDeleteFile, ApplyPatchCallOperationUpdateFile],
    PropertyInfo(discriminator="type"),
]


class ApplyPatchCall(BaseModel):
    """
    A tool call representing a request to create, delete, or update files using diff patches.
    """

    call_id: str
    """The unique ID of the apply patch tool call generated by the model."""

    operation: ApplyPatchCallOperation
    """
    The specific create, delete, or update instruction for the apply_patch tool
    call.
    """

    status: Literal["in_progress", "completed"]
    """The status of the apply patch tool call. One of `in_progress` or `completed`."""

    type: Literal["apply_patch_call"]
    """The type of the item. Always `apply_patch_call`."""

    id: Optional[str] = None
    """The unique ID of the apply patch tool call.

    Populated when this item is returned via API.
    """


class ApplyPatchCallOutput(BaseModel):
    """The streamed output emitted by an apply patch tool call."""

    call_id: str
    """The unique ID of the apply patch tool call generated by the model."""

    status: Literal["completed", "failed"]
    """The status of the apply patch tool call output. One of `completed` or `failed`."""

    type: Literal["apply_patch_call_output"]
    """The type of the item. Always `apply_patch_call_output`."""

    id: Optional[str] = None
    """The unique ID of the apply patch tool call output.

    Populated when this item is returned via API.
    """

    output: Optional[str] = None
    """
    Optional human-readable log text from the apply patch tool (e.g., patch results
    or errors).
    """


class McpListToolsTool(BaseModel):
    """A tool available on an MCP server."""

    input_schema: object
    """The JSON schema describing the tool's input."""

    name: str
    """The name of the tool."""

    annotations: Optional[object] = None
    """Additional annotations about the tool."""

    description: Optional[str] = None
    """The description of the tool."""


class McpListTools(BaseModel):
    """A list of tools available on an MCP server."""

    id: str
    """The unique ID of the list."""

    server_label: str
    """The label of the MCP server."""

    tools: List[McpListToolsTool]
    """The tools available on the server."""

    type: Literal["mcp_list_tools"]
    """The type of the item. Always `mcp_list_tools`."""

    error: Optional[str] = None
    """Error message if the server could not list tools."""


class McpApprovalRequest(BaseModel):
    """A request for human approval of a tool invocation."""

    id: str
    """The unique ID of the approval request."""

    arguments: str
    """A JSON string of arguments for the tool."""

    name: str
    """The name of the tool to run."""

    server_label: str
    """The label of the MCP server making the request."""

    type: Literal["mcp_approval_request"]
    """The type of the item. Always `mcp_approval_request`."""


class McpApprovalResponse(BaseModel):
    """A response to an MCP approval request."""

    approval_request_id: str
    """The ID of the approval request being answered."""

    approve: bool
    """Whether the request was approved."""

    type: Literal["mcp_approval_response"]
    """The type of the item. Always `mcp_approval_response`."""

    id: Optional[str] = None
    """The unique ID of the approval response"""

    reason: Optional[str] = None
    """Optional reason for the decision."""


class McpCall(BaseModel):
    """An invocation of a tool on an MCP server."""

    id: str
    """The unique ID of the tool call."""

    arguments: str
    """A JSON string of the arguments passed to the tool."""

    name: str
    """The name of the tool that was run."""

    server_label: str
    """The label of the MCP server running the tool."""

    type: Literal["mcp_call"]
    """The type of the item. Always `mcp_call`."""

    approval_request_id: Optional[str] = None
    """
    Unique identifier for the MCP tool call approval request. Include this value in
    a subsequent `mcp_approval_response` input to approve or reject the
    corresponding tool call.
    """

    error: Optional[str] = None
    """The error from the tool call, if any."""

    output: Optional[str] = None
    """The output from the tool call."""

    status: Optional[Literal["in_progress", "completed", "incomplete", "calling", "failed"]] = None
    """The status of the tool call.

    One of `in_progress`, `completed`, `incomplete`, `calling`, or `failed`.
    """


class ItemReference(BaseModel):
    """An internal identifier for an item to reference."""

    id: str
    """The ID of the item to reference."""

    type: Optional[Literal["item_reference"]] = None
    """The type of item to reference. Always `item_reference`."""


ResponseInputItem: TypeAlias = Annotated[
    Union[
        EasyInputMessage,
        Message,
        ResponseOutputMessage,
        ResponseFileSearchToolCall,
        ResponseComputerToolCall,
        ComputerCallOutput,
        ResponseFunctionWebSearch,
        ResponseFunctionToolCall,
        FunctionCallOutput,
        ResponseReasoningItem,
        ResponseCompactionItemParam,
        ImageGenerationCall,
        ResponseCodeInterpreterToolCall,
        LocalShellCall,
        LocalShellCallOutput,
        ShellCall,
        ShellCallOutput,
        ApplyPatchCall,
        ApplyPatchCallOutput,
        McpListTools,
        McpApprovalRequest,
        McpApprovalResponse,
        McpCall,
        ResponseCustomToolCallOutput,
        ResponseCustomToolCall,
        ItemReference,
    ],
    PropertyInfo(discriminator="type"),
]
