# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class CloudNativeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Cloud Native Type enum."""

    EC2 = "ec2"
    """ec2 enum."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class HostType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum of host cloud the public cloud connector is referencing."""

    AWS = "AWS"
    """AWS state"""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The resource provisioning state."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    UPDATING = "Updating"
    FAILED = "Failed"
    CANCELED = "Canceled"


class ResourceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of a resource type."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class ServiceName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of the service."""

    SSH = "SSH"
    WAC = "WAC"


class SolutionConfigurationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Solution Configuration Status."""

    NEW = "New"
    """New status"""
    IN_PROGRESS = "InProgress"
    """InProgress status"""
    COMPLETED = "Completed"
    """Canceled status"""
    FAILED = "Failed"
    """Failed status"""


class Type(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of endpoint."""

    DEFAULT = "default"
    CUSTOM = "custom"
