/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.BeanIntrospector;
import org.cojen.util.BeanProperty;
import org.cojen.util.ClassInjector;
import org.cojen.util.SoftValuedHashMap;

public class BeanComparator
implements Comparator,
Serializable {
    private static Map cGeneratedComparatorCache = new SoftValuedHashMap();
    private Class mBeanClass;
    private transient Map mProperties;
    private String mOrderByName;
    private Comparator mUsingComparator;
    private int mFlags;
    private Comparator mCollator;
    private BeanComparator mParent;
    private transient Comparator mComparator;
    private transient boolean mHasHashCode;
    private transient int mHashCode;
    static /* synthetic */ Class array$Ljava$util$Comparator;
    static /* synthetic */ Class class$org$cojen$util$BeanComparator;
    static /* synthetic */ Class class$java$util$Comparator;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Comparable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$ClassCastException;

    public static BeanComparator forClass(Class clazz) {
        return new BeanComparator(clazz);
    }

    private static boolean equalTest(Object obj1, Object obj2) {
        return obj1 == obj2 ? true : (obj1 == null || obj2 == null ? false : obj1.equals(obj2));
    }

    private BeanComparator(Class clazz) {
        this.mBeanClass = clazz;
        this.mCollator = String.CASE_INSENSITIVE_ORDER;
    }

    private BeanComparator(BeanComparator parent) {
        this.mParent = parent;
        this.mBeanClass = parent.mBeanClass;
        this.mProperties = parent.getProperties();
        this.mCollator = parent.mCollator;
    }

    public BeanComparator orderBy(String propertyName) throws IllegalArgumentException {
        BeanProperty prop;
        String subName;
        int dot = propertyName.indexOf(46);
        if (dot < 0) {
            subName = null;
        } else {
            subName = propertyName.substring(dot + 1);
            propertyName = propertyName.substring(0, dot);
        }
        boolean reverse = false;
        if (propertyName.length() > 0) {
            char prefix = propertyName.charAt(0);
            switch (prefix) {
                default: {
                    break;
                }
                case '-': {
                    reverse = true;
                }
                case '+': {
                    propertyName = propertyName.substring(1);
                }
            }
        }
        if ((prop = (BeanProperty)this.getProperties().get(propertyName)) == null) {
            throw new IllegalArgumentException("Property '" + propertyName + "' doesn't exist in '" + this.mBeanClass.getName() + '\'');
        }
        if (prop.getReadMethod() == null) {
            throw new IllegalArgumentException("Property '" + propertyName + "' cannot be read");
        }
        if (propertyName.equals(this.mOrderByName)) {
            propertyName = new String(propertyName);
        }
        BeanComparator bc = new BeanComparator(this);
        bc.mOrderByName = propertyName;
        if (subName != null) {
            BeanComparator subOrder = BeanComparator.forClass(prop.getType());
            subOrder.mCollator = this.mCollator;
            bc = bc.using(subOrder.orderBy(subName));
        }
        return reverse ? bc.reverse() : bc;
    }

    public BeanComparator using(Comparator c) {
        BeanComparator bc = new BeanComparator(this);
        bc.mOrderByName = this.mOrderByName;
        bc.mUsingComparator = c;
        bc.mFlags = this.mFlags;
        return bc;
    }

    public BeanComparator reverse() {
        BeanComparator bc = new BeanComparator(this);
        bc.mOrderByName = this.mOrderByName;
        bc.mUsingComparator = this.mUsingComparator;
        bc.mFlags = this.mFlags ^ 1;
        return bc;
    }

    public BeanComparator nullHigh() {
        BeanComparator bc = new BeanComparator(this);
        bc.mOrderByName = this.mOrderByName;
        bc.mUsingComparator = this.mUsingComparator;
        bc.mFlags = this.mFlags ^ (this.mFlags & 1) << 1;
        return bc;
    }

    public BeanComparator nullLow() {
        BeanComparator bc = new BeanComparator(this);
        bc.mOrderByName = this.mOrderByName;
        bc.mUsingComparator = this.mUsingComparator;
        bc.mFlags = this.mFlags ^ (~this.mFlags & 1) << 1;
        return bc;
    }

    public BeanComparator caseSensitive() {
        if ((this.mFlags & 4) != 0) {
            return this;
        }
        BeanComparator bc = new BeanComparator(this);
        bc.mOrderByName = this.mOrderByName;
        bc.mUsingComparator = this.mUsingComparator;
        bc.mFlags = this.mFlags | 4;
        return bc;
    }

    public BeanComparator collate(Comparator c) {
        BeanComparator bc = new BeanComparator(this);
        bc.mOrderByName = this.mOrderByName;
        bc.mUsingComparator = this.mUsingComparator;
        bc.mFlags = this.mFlags & 0xFFFFFFFB;
        bc.mCollator = c;
        return bc;
    }

    public int compare(Object obj1, Object obj2) throws ClassCastException {
        Comparator c = this.mComparator;
        if (c == null) {
            c = this.mComparator = this.generateComparator();
        }
        return c.compare(obj1, obj2);
    }

    public int hashCode() {
        if (!this.mHasHashCode) {
            this.setHashCode(new Rules(this));
        }
        return this.mHashCode;
    }

    private void setHashCode(Rules rules) {
        this.mHashCode = rules.hashCode();
        this.mHasHashCode = true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BeanComparator) {
            BeanComparator bc = (BeanComparator)obj;
            return this.mFlags == bc.mFlags && BeanComparator.equalTest(this.mBeanClass, bc.mBeanClass) && BeanComparator.equalTest(this.mOrderByName, bc.mOrderByName) && BeanComparator.equalTest(this.mUsingComparator, bc.mUsingComparator) && BeanComparator.equalTest(this.mCollator, bc.mCollator) && BeanComparator.equalTest(this.mParent, bc.mParent);
        }
        return false;
    }

    private Map getProperties() {
        if (this.mProperties == null) {
            this.mProperties = BeanIntrospector.getAllProperties(this.mBeanClass);
        }
        return this.mProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Comparator generateComparator() {
        Rules rules = new Rules(this);
        if (!this.mHasHashCode) {
            this.setHashCode(rules);
        }
        Map map = cGeneratedComparatorCache;
        synchronized (map) {
            Class clazz;
            Object c = cGeneratedComparatorCache.get(rules);
            if (c == null) {
                clazz = this.generateComparatorClass(rules);
                cGeneratedComparatorCache.put(rules, clazz);
            } else {
                if (c instanceof Comparator) {
                    return (Comparator)c;
                }
                clazz = (Class)c;
            }
            BeanComparator[] ruleParts = rules.getRuleParts();
            Comparator[] collators = new Comparator[ruleParts.length];
            Comparator[] usingComparators = new Comparator[ruleParts.length];
            boolean singleton = true;
            for (int i = 0; i < ruleParts.length; ++i) {
                BeanComparator rp = ruleParts[i];
                Comparator c2 = rp.mCollator;
                collators[i] = c2;
                if (collators[i] != null && c2 != String.CASE_INSENSITIVE_ORDER) {
                    singleton = false;
                }
                if ((usingComparators[i] = rp.mUsingComparator) == null) continue;
                singleton = false;
            }
            try {
                Constructor ctor = clazz.getDeclaredConstructor(array$Ljava$util$Comparator == null ? (array$Ljava$util$Comparator = BeanComparator.class$("[Ljava.util.Comparator;")) : array$Ljava$util$Comparator, array$Ljava$util$Comparator == null ? (array$Ljava$util$Comparator = BeanComparator.class$("[Ljava.util.Comparator;")) : array$Ljava$util$Comparator);
                c = (Comparator)ctor.newInstance(collators, usingComparators);
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e.toString());
            }
            catch (InstantiationException e) {
                throw new InternalError(e.toString());
            }
            catch (IllegalAccessException e) {
                throw new InternalError(e.toString());
            }
            catch (IllegalArgumentException e) {
                throw new InternalError(e.toString());
            }
            catch (InvocationTargetException e) {
                throw new InternalError(e.getTargetException().toString());
            }
            if (singleton) {
                cGeneratedComparatorCache.put(rules, c);
            }
            return (Comparator)c;
        }
    }

    private Class generateComparatorClass(Rules rules) {
        ClassInjector ci = ClassInjector.create(this.getClass().getName(), this.mBeanClass.getClassLoader());
        return ci.defineClass(BeanComparator.generateClassFile(ci.getClassName(), rules));
    }

    private static ClassFile generateClassFile(String className, Rules rules) {
        Method compareToMethod;
        Method compareMethod;
        ClassFile cf = new ClassFile(className);
        cf.markSynthetic();
        cf.setSourceFile((class$org$cojen$util$BeanComparator == null ? (class$org$cojen$util$BeanComparator = BeanComparator.class$("org.cojen.util.BeanComparator")) : class$org$cojen$util$BeanComparator).getName());
        try {
            cf.setTarget(System.getProperty("java.specification.version"));
        }
        catch (Exception e) {
            // empty catch block
        }
        cf.addInterface(class$java$util$Comparator == null ? (class$java$util$Comparator = BeanComparator.class$("java.util.Comparator")) : class$java$util$Comparator);
        cf.addInterface(class$java$io$Serializable == null ? (class$java$io$Serializable = BeanComparator.class$("java.io.Serializable")) : class$java$io$Serializable);
        TypeDesc comparatorType = TypeDesc.forClass(class$java$util$Comparator == null ? (class$java$util$Comparator = BeanComparator.class$("java.util.Comparator")) : class$java$util$Comparator);
        TypeDesc comparatorArrayType = comparatorType.toArrayType();
        cf.addField(Modifiers.PRIVATE, "mCollators", comparatorArrayType).markSynthetic();
        cf.addField(Modifiers.PRIVATE, "mUsingComparators", comparatorArrayType).markSynthetic();
        TypeDesc[] paramTypes = new TypeDesc[]{comparatorArrayType, comparatorArrayType};
        MethodInfo ctor = cf.addConstructor(Modifiers.PUBLIC, paramTypes);
        ctor.markSynthetic();
        CodeBuilder builder = new CodeBuilder(ctor);
        builder.loadThis();
        builder.invokeSuperConstructor(null);
        builder.loadThis();
        builder.loadLocal(builder.getParameter(0));
        builder.storeField("mCollators", comparatorArrayType);
        builder.loadThis();
        builder.loadLocal(builder.getParameter(1));
        builder.storeField("mUsingComparators", comparatorArrayType);
        builder.returnVoid();
        try {
            compareMethod = (class$java$util$Comparator == null ? (class$java$util$Comparator = BeanComparator.class$("java.util.Comparator")) : class$java$util$Comparator).getMethod("compare", class$java$lang$Object == null ? (class$java$lang$Object = BeanComparator.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = BeanComparator.class$("java.lang.Object")) : class$java$lang$Object);
            compareToMethod = (class$java$lang$Comparable == null ? (class$java$lang$Comparable = BeanComparator.class$("java.lang.Comparable")) : class$java$lang$Comparable).getMethod("compareTo", class$java$lang$Object == null ? (class$java$lang$Object = BeanComparator.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString());
        }
        MethodInfo mi = cf.addMethod(compareMethod);
        mi.markSynthetic();
        builder = new CodeBuilder(mi);
        Label endLabel = builder.createLabel();
        LocalVariable obj1 = builder.getParameter(0);
        LocalVariable obj2 = builder.getParameter(1);
        BeanComparator[] ruleParts = rules.getRuleParts();
        BeanComparator bc = ruleParts[0];
        if ((bc.mFlags & 1) != 0) {
            LocalVariable temp = obj1;
            obj1 = obj2;
            obj2 = temp;
        }
        builder.loadLocal(obj1);
        builder.loadLocal(obj2);
        builder.ifEqualBranch(endLabel, true);
        boolean nullHigh = (bc.mFlags & 2) == 0;
        Label label = builder.createLabel();
        builder.loadLocal(obj1);
        builder.ifNullBranch(label, false);
        builder.loadConstant(nullHigh ? 1 : -1);
        builder.returnValue(TypeDesc.INT);
        label.setLocation();
        label = builder.createLabel();
        builder.loadLocal(obj2);
        builder.ifNullBranch(label, false);
        builder.loadConstant(nullHigh ? -1 : 1);
        builder.returnValue(TypeDesc.INT);
        label.setLocation();
        LocalVariable result = builder.createLocalVariable("result", TypeDesc.INT);
        if (bc.mUsingComparator != null) {
            builder.loadThis();
            builder.loadField("mUsingComparators", comparatorArrayType);
            builder.loadConstant(0);
            builder.loadFromArray(TypeDesc.forClass(class$java$util$Comparator == null ? (class$java$util$Comparator = BeanComparator.class$("java.util.Comparator")) : class$java$util$Comparator));
            builder.loadLocal(obj1);
            builder.loadLocal(obj2);
            builder.invoke(compareMethod);
            builder.storeLocal(result);
            builder.loadLocal(result);
            label = builder.createLabel();
            builder.ifZeroComparisonBranch(label, "==");
            builder.loadLocal(result);
            builder.returnValue(TypeDesc.INT);
            label.setLocation();
        }
        TypeDesc type = TypeDesc.forClass(bc.mBeanClass);
        builder.loadLocal(obj1);
        builder.checkCast(type);
        builder.storeLocal(obj1);
        builder.loadLocal(obj2);
        builder.checkCast(type);
        builder.storeLocal(obj2);
        for (int i = 1; i < ruleParts.length; ++i) {
            bc = ruleParts[i];
            BeanProperty prop = (BeanProperty)bc.getProperties().get(bc.mOrderByName);
            Class propertyClass = prop.getType();
            TypeDesc propertyType = TypeDesc.forClass(propertyClass);
            LocalVariable p1 = builder.createLocalVariable("p1", propertyType);
            LocalVariable p2 = builder.createLocalVariable("p2", propertyType);
            builder.loadLocal(obj1);
            builder.invoke(prop.getReadMethod());
            builder.storeLocal(p1);
            builder.loadLocal(obj2);
            builder.invoke(prop.getReadMethod());
            builder.storeLocal(p2);
            if ((bc.mFlags & 1) != 0) {
                LocalVariable temp = p1;
                p1 = p2;
                p2 = temp;
            }
            Label nextLabel = builder.createLabel();
            if (!propertyClass.isPrimitive()) {
                builder.loadLocal(p1);
                builder.loadLocal(p2);
                builder.ifEqualBranch(nextLabel, true);
                nullHigh = (bc.mFlags & 2) == 0;
                label = builder.createLabel();
                builder.loadLocal(p1);
                builder.ifNullBranch(label, false);
                builder.loadConstant(nullHigh ? 1 : -1);
                builder.returnValue(TypeDesc.INT);
                label.setLocation();
                label = builder.createLabel();
                builder.loadLocal(p2);
                builder.ifNullBranch(label, false);
                builder.loadConstant(nullHigh ? -1 : 1);
                builder.returnValue(TypeDesc.INT);
                label.setLocation();
            }
            if (bc.mUsingComparator != null) {
                builder.loadThis();
                builder.loadField("mUsingComparators", comparatorArrayType);
                builder.loadConstant(i);
                builder.loadFromArray(TypeDesc.forClass(class$java$util$Comparator == null ? BeanComparator.class$("java.util.Comparator") : class$java$util$Comparator));
                builder.loadLocal(p1);
                builder.convert(propertyType, propertyType.toObjectType());
                builder.loadLocal(p2);
                builder.convert(propertyType, propertyType.toObjectType());
                builder.invoke(compareMethod);
            } else if ((bc.mFlags & 4) == 0 && bc.mCollator != null && propertyClass.isAssignableFrom(class$java$lang$String == null ? BeanComparator.class$("java.lang.String") : class$java$lang$String)) {
                Label resultLabel = builder.createLabel();
                if (!(class$java$lang$String == null ? BeanComparator.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(propertyClass)) {
                    TypeDesc stringType = TypeDesc.STRING;
                    builder.loadLocal(p1);
                    builder.instanceOf(stringType);
                    Label notString = builder.createLabel();
                    builder.ifZeroComparisonBranch(notString, "==");
                    builder.loadLocal(p2);
                    builder.instanceOf(stringType);
                    Label isString = builder.createLabel();
                    builder.ifZeroComparisonBranch(isString, "!=");
                    notString.setLocation();
                    BeanComparator.generateComparableCompareTo(builder, propertyClass, compareToMethod, resultLabel, nextLabel, p1, p2);
                    isString.setLocation();
                }
                builder.loadThis();
                builder.loadField("mCollators", comparatorArrayType);
                builder.loadConstant(i);
                builder.loadFromArray(TypeDesc.forClass(class$java$util$Comparator == null ? BeanComparator.class$("java.util.Comparator") : class$java$util$Comparator));
                builder.loadLocal(p1);
                builder.loadLocal(p2);
                builder.invoke(compareMethod);
                resultLabel.setLocation();
            } else if (propertyClass.isPrimitive()) {
                BeanComparator.generatePrimitiveComparison(builder, propertyClass, p1, p2);
            } else {
                BeanComparator.generateComparableCompareTo(builder, propertyClass, compareToMethod, null, nextLabel, p1, p2);
            }
            if (i < ruleParts.length - 1) {
                builder.storeLocal(result);
                builder.loadLocal(result);
                builder.ifZeroComparisonBranch(nextLabel, "==");
                builder.loadLocal(result);
            }
            builder.returnValue(TypeDesc.INT);
            nextLabel.setLocation();
        }
        endLabel.setLocation();
        builder.loadConstant(0);
        builder.returnValue(TypeDesc.INT);
        return cf;
    }

    private static void generatePrimitiveComparison(CodeBuilder builder, Class type, LocalVariable a, LocalVariable b) {
        if (type == Float.TYPE) {
            Method floatToIntBits;
            Label done = builder.createLabel();
            builder.loadLocal(a);
            builder.loadLocal(b);
            builder.math((byte)-106);
            Label label = builder.createLabel();
            builder.ifZeroComparisonBranch(label, ">=");
            builder.loadConstant(-1);
            builder.branch(done);
            label.setLocation();
            builder.loadLocal(a);
            builder.loadLocal(b);
            builder.math((byte)-107);
            label = builder.createLabel();
            builder.ifZeroComparisonBranch(label, "<=");
            builder.loadConstant(1);
            builder.branch(done);
            try {
                floatToIntBits = (class$java$lang$Float == null ? (class$java$lang$Float = BeanComparator.class$("java.lang.Float")) : class$java$lang$Float).getMethod("floatToIntBits", Float.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e.toString());
            }
            label.setLocation();
            builder.loadLocal(a);
            builder.invoke(floatToIntBits);
            builder.convert(TypeDesc.INT, TypeDesc.LONG);
            builder.loadLocal(b);
            builder.invoke(floatToIntBits);
            builder.convert(TypeDesc.INT, TypeDesc.LONG);
            builder.math((byte)-108);
            done.setLocation();
        } else if (type == Double.TYPE) {
            Method doubleToLongBits;
            Label done = builder.createLabel();
            builder.loadLocal(a);
            builder.loadLocal(b);
            done = builder.createLabel();
            builder.math((byte)-104);
            Label label = builder.createLabel();
            builder.ifZeroComparisonBranch(label, ">=");
            builder.loadConstant(-1);
            builder.branch(done);
            label.setLocation();
            builder.loadLocal(a);
            builder.loadLocal(b);
            builder.math((byte)-105);
            label = builder.createLabel();
            builder.ifZeroComparisonBranch(label, "<=");
            builder.loadConstant(1);
            builder.branch(done);
            try {
                doubleToLongBits = (class$java$lang$Double == null ? (class$java$lang$Double = BeanComparator.class$("java.lang.Double")) : class$java$lang$Double).getMethod("doubleToLongBits", Double.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e.toString());
            }
            label.setLocation();
            builder.loadLocal(a);
            builder.invoke(doubleToLongBits);
            builder.loadLocal(b);
            builder.invoke(doubleToLongBits);
            builder.math((byte)-108);
            done.setLocation();
        } else if (type == Long.TYPE) {
            builder.loadLocal(a);
            builder.loadLocal(b);
            builder.math((byte)-108);
        } else if (type == Integer.TYPE) {
            builder.loadLocal(a);
            builder.convert(TypeDesc.INT, TypeDesc.LONG);
            builder.loadLocal(b);
            builder.convert(TypeDesc.INT, TypeDesc.LONG);
            builder.math((byte)-108);
        } else {
            builder.loadLocal(a);
            builder.loadLocal(b);
            builder.math((byte)100);
        }
    }

    private static void generateComparableCompareTo(CodeBuilder builder, Class type, Method compareToMethod, Label goodLabel, Label nextLabel, LocalVariable a, LocalVariable b) {
        if ((class$java$lang$Comparable == null ? (class$java$lang$Comparable = BeanComparator.class$("java.lang.Comparable")) : class$java$lang$Comparable).isAssignableFrom(type)) {
            builder.loadLocal(a);
            builder.loadLocal(b);
            builder.invoke(compareToMethod);
            if (goodLabel != null) {
                builder.branch(goodLabel);
            }
        } else {
            TypeDesc comparableType = TypeDesc.forClass(class$java$lang$Comparable == null ? (class$java$lang$Comparable = BeanComparator.class$("java.lang.Comparable")) : class$java$lang$Comparable);
            boolean locateGoodLabel = false;
            if (goodLabel == null) {
                goodLabel = builder.createLabel();
                locateGoodLabel = true;
            }
            Label tryStart = builder.createLabel().setLocation();
            builder.loadLocal(a);
            builder.checkCast(comparableType);
            builder.loadLocal(b);
            builder.checkCast(comparableType);
            Label tryEnd = builder.createLabel().setLocation();
            builder.invoke(compareToMethod);
            builder.branch(goodLabel);
            builder.exceptionHandler(tryStart, tryEnd, (class$java$lang$ClassCastException == null ? (class$java$lang$ClassCastException = BeanComparator.class$("java.lang.ClassCastException")) : class$java$lang$ClassCastException).getName());
            builder.pop();
            if (nextLabel == null) {
                builder.loadConstant(0);
            } else {
                builder.branch(nextLabel);
            }
            if (locateGoodLabel) {
                goodLabel.setLocation();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Rules {
        private BeanComparator[] mRuleParts;
        private int mHashCode;

        public Rules(BeanComparator bc) {
            this.mRuleParts = this.reduceRules(bc);
            int hash = 0;
            for (int i = this.mRuleParts.length - 1; i >= 0; --i) {
                bc = this.mRuleParts[i];
                hash = 31 * hash;
                hash += bc.mFlags << 4;
                Object obj = bc.mBeanClass;
                if (obj != null) {
                    hash += obj.hashCode();
                }
                if ((obj = bc.mOrderByName) != null) {
                    hash += obj.hashCode();
                }
                if ((obj = bc.mUsingComparator) != null) {
                    hash += obj.getClass().hashCode();
                }
                if ((obj = bc.mCollator) == null) continue;
                hash += obj.getClass().hashCode();
            }
            this.mHashCode = hash;
        }

        public BeanComparator[] getRuleParts() {
            return this.mRuleParts;
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object obj) {
            BeanComparator[] ruleParts2;
            if (!(obj instanceof Rules)) {
                return false;
            }
            BeanComparator[] ruleParts1 = this.getRuleParts();
            if (ruleParts1.length != (ruleParts2 = ((Rules)obj).getRuleParts()).length) {
                return false;
            }
            for (int i = 0; i < ruleParts1.length; ++i) {
                BeanComparator bc1 = ruleParts1[i];
                BeanComparator bc2 = ruleParts2[i];
                if (bc1.mFlags != bc2.mFlags) {
                    return false;
                }
                if (!BeanComparator.equalTest(bc1.mBeanClass, bc2.mBeanClass)) {
                    return false;
                }
                if (!BeanComparator.equalTest(bc1.mOrderByName, bc2.mOrderByName)) {
                    return false;
                }
                if (bc1.mUsingComparator == null != (bc2.mUsingComparator == null)) {
                    return false;
                }
                if (bc1.mCollator == null == (bc2.mCollator == null)) continue;
                return false;
            }
            return true;
        }

        private BeanComparator[] reduceRules(BeanComparator bc) {
            ArrayList<BeanComparator> rules = new ArrayList<BeanComparator>();
            rules.add(bc);
            String name = bc.mOrderByName;
            while ((bc = bc.mParent) != null) {
                if (name == bc.mOrderByName) continue;
                rules.add(bc);
                name = bc.mOrderByName;
            }
            int size = rules.size();
            BeanComparator[] bcs = new BeanComparator[size];
            for (int i = 0; i < size; ++i) {
                bcs[size - i - 1] = (BeanComparator)rules.get(i);
            }
            return bcs;
        }
    }
}

