! move_npc.inc : Moves npcs from room to room depending on the time
!
! Version 1.0
! 
! This file is in the public domain.
!
! To use this file, place "#include move.npc" near the beginning
!   of your game, but after #include stdlib.inc"
!
! Make sure the version of stdlib.inc you have includes the  
! [creature Loop] subroutine.
!
! To conserve memory (and time) you may wish to eliminate some of the 
! time props.
!
! Basically, every creature has 48 different properties which are set to
! the location she or he is at at a given time. [000] is Midnight, [230]
! is 2:30 am, [1200] is noon, [1930] is 7:30 pm and so on. 
!
! When the time arrives, the creature will be move to that location.
!
! Works best when the time step is set to 2 minutes or so
!
! Creatures that are group members aren't moved, nor are they moved if
! you turn on the object flag [DontTimeMove]
! 
! 

subroutines
[npc time move]
end_subroutines

OBJFLAG CREATURE
[DontTimeMove]
END_OBJFLAG



PROP CREATURE
[000]
[030] 
[100]  
[130]
[200]
[230]
[300]
[330] 
[400]  
[430]
[500]
[530]
[600]
[630] 
[700]  
[730]
[800]
[830]
[900]
[930] 
[1000]  
[1030]
[1100]
[1130]
[1200]
[1230]
[1300]
[1330] 
[1400]  
[1430]
[1500]
[1530]
[1600]
[1630] 
[1700]  
[1730]
[1800]
[1830]
[1900]
[1930] 
[2000]
[2030]
[2100]
[2130]
[2200]
[2230]
[2300]
[2330]
END_PROP

! There's probably a shorter way of doing this, but...

COMMAND ANY
1 TimeGT 0
  TimeLT 3
  Set [arg2] [000]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 30
  TimeLT 33
  Set [arg2] [030]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 100
  TimeLT 103
  Set [arg2] [100]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 130
  TimeLT 133
  Set [arg2] [130]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 200
  TimeLT 203
  Set [arg2] [200]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 230
  TimeLT 233
  Set [arg2] [230]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 300
  TimeLT 303
  Set [arg2] [300]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 330
  TimeLT 333
  Set [arg2] [330]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 400
  TimeLT 403
  Set [arg2] [400]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 430
  TimeLT 433
  Set [arg2] [430]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 500
  TimeLT 503
  Set [arg2] [500]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 530
  TimeLT 533
  Set [arg2] [530]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 600
  TimeLT 603
  Set [arg2] [600]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 630
  TimeLT 633
  Set [arg2] [630]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 700
  TimeLT 703
  Set [arg2] [700]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 730
  TimeLT 733
  Set [arg2] [730]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 800
  TimeLT 803
  Set [arg2] [800]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 830
  TimeLT 833
  Set [arg2] [830]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 900
  TimeLT 903
  Set [arg2] [900]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 930
  TimeLT 933
  Set [arg2] [930]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1000
  TimeLT 1003
  Set [arg2] [1000]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1030
  TimeLT 1033
  Set [arg2] [1030]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 1100
  TimeLT 1103
  Set [arg2] [1100]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1130
  TimeLT 1133
  Set [arg2] [1130]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 1200
  TimeLT 1203
  Set [arg2] [1200]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 1230
  TimeLT 1233
  Set [arg2] [1230]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1300
  TimeLT 1303
  Set [arg2] [1300]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1330
  TimeLT 1333
  Set [arg2] [1330]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 1400
  TimeLT 1403
  Set [arg2] [1400]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 1430
  TimeLT 1433
  Set [arg2] [1430]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1500
  TimeLT 1503
  Set [arg2] [1500]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1530
  TimeLT 1533
  Set [arg2] [1530]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 1600
  TimeLT 1603
  Set [arg2] [1600]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 1630
  TimeLT 1633
  Set [arg2] [1630]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1700
  TimeLT 1703
  Set [arg2] [1700]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1730
  TimeLT 1733
  Set [arg2] [1730]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 1800
  TimeLT 1803
  Set [arg2] [1800]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 1830
  TimeLT 1833
  Set [arg2] [1830]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1900
  TimeLT 1903
  Set [arg2] [1900]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 1930
  TimeLT 1933
  Set [arg2] [1930]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 2000
  TimeLT 2003
  Set [arg2] [2000]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 2030
  TimeLT 2033
  Set [arg2] [2030]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 2100
  TimeLT 2103
  Set [arg2] [2100]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 2130
  TimeLT 2133
  Set [arg2] [2130]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 2200
  TimeLT 2203
  Set [arg2] [2200]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 2230
  TimeLT 2233
  Set [arg2] [2230]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 2300
  TimeLT 2303
  Set [arg2] [2300]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 2330
  TimeLT 2333
  Set [arg2] [2330]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


END_COMMAND



COMMAND SUBROUTINE[npc time move]
1 Equal [arg].[arg2] 0
Return

1 Present [arg] ' Is the critter here and leaving?
Printmessage "You catch a glance of someone leaving." 

1 NOT IsGroupmember [arg]
NOT Equal [arg].[arg2] 0
ObjFlagOff [arg].[DontTimeMove]
SendToRoom [arg] [arg].[arg2]

1 Present [arg] ' Did the critter just enter room
PrintMessage "Someone enters the room."

1 Return
END_COMMAND

