/*
** GndH.t contains new verbs, new classes, and other wide-spread
** changes.
**
** Copyright (c) 1999, Stephen Granade. All rights reserved.
*/

#pragma C+


// Use the new chairItem behavior defined in TADS adv.t 2.3.0
modify chairitem
    canReachContents = true
;

modify thing
    // Modified sdesc and ldesc handling
    j_sdesc = ""         // Jeanie's version of the sdesc
    f_sdesc = ""         // Frank's sdesc version
    d_sdesc = ""         // Deb's sdesc
    j_ldesc = ""         // Jeanie's ldesc version
    f_ldesc = ""         // Frank's ldesc version
    d_ldesc = ""         // Deb's ldesc
    sdesc = {
	self.(parserGetMe().sdesc_pointer);
    }
    ldesc = {
	self.(parserGetMe().ldesc_pointer);
    }
    exits = "There aren't any. "
    ioUnscrewWith(actor, dobj) = { dobj.doUnscrewWith(actor, self); }
    ioScrewWith(actor, dobj) = { dobj.screwWith(actor, self); }
    verDoTalkto(actor) = {
	if (actor == jeanieMe)
	    "You're not <i>that</i> bored. Yet. ";
	else if (actor == frankMe)
	    "Look, just because you sometimes mutter to yourself
	     doesn't mean you're going to talk to stuff. ";
	else "That wouldn't be seemly. ";
    }
    verDoKick(actor) = {
	if (actor == jeanieMe)
	    "You got over temper tantrums years ago. ";
	else if (actor == frankMe)
	    "Right, and break a toe like you did in that bar years ago. ";
	else "What would people think if you went around kicking things? ";
    }
    verDoUse(actor) = { "How're you going to do that? "; }
    verDoFlush(actor) = {
	"You can't flush <<self.isThem ? 'them' : 'that'>>. ";
    }
    verDoWash(actor) = { "%You% %do%n't need to. "; }
    verDoCount(actor) = { "%You% %do%n't need to. "; }
    verDoTurnup(actor) = { "How're you going to do that? "; }
    verDoTurndown(actor) = { "How're you going to do that? "; }
    verDoKiss(actor) = { "Why do that? "; }
    verDoWatch(actor) = { "Nothing exciting happens. "; }
    verDoChange(actor) = { "%You% can't change <<self.thatdesc>>. "; }
    verDoRub(actor) = {
	if (actor == self)
	    "You've never been good at giving yourself a massage. ";
	else "\^<<self.thatdesc>> <<self.doesdesc>>n't need to be
	      rubbed. ";
    }
    verDoApply(actor) = { "%You% can't apply <<self.thatdesc>>. "; }
    verDoMake(actor) = { "%You% can't make <<self.thatdesc>>. "; }
    verDoCrush(actor) = { "%You% can't crush <<self.thatdesc>>. "; }
    verDoTestWith(actor, io) = {
	"%You% %do%n't need to test <<self.thatdesc>>. ";
    }
    verIoTestWith(actor) = {
	"%You% can't test anything with <<self.thatdesc>>. ";
    }
    verDoHelp(actor) = {
	"<<self.isThem ? 'They' : 'That'>> <<self.doesdesc>>n't need
	 helping. ";
    }
    verDoFix(actor) = {
	"<<self.isThem ? 'They' : 'That'>> <<self.doesdesc>>n't need
	 fixing. ";
    }

    // If a player tries ASK ABOUT or TELL ABOUT, tell them that they can
    // only TALK TO
    verDoAskAbout(actor, dobj) = {}
    verIoAskAbout(actor) = {}
    ioAskAbout(actor, dobj) = {
	"If you want to talk to someone, use TALK TO. ";
	abort;
    }
    verDoTellAbout(actor, iobj) = {}
    verIoTellAbout(actor) = {}
    ioTellAbout(actor, dobj) = { self.ioAskAbout(actor, dobj); }
    verDoTalktoAbout(actor, iobj) = {}
    verIoTalktoAbout(actor) = {}
    ioTalktoAbout(actor, dobj) = {
	"You can't be that specific. Just use TALK TO [person]. ";
	abort;
    }
    verIoScrewTo(actor) = {
	"You can't screw anything to <<self.thedesc>>. ";
    }
    ioScrewTo(actor, dobj) = { dobj.doScrewTo(actor, self); }
    verIoUnscrewFrom(actor) = {
	"There's nothing screwed to <<self.thedesc>>. ";
    }
    ioUnscrewFrom(actor, dobj) = { dobj.doUnscrewFrom(actor, self); }
    verDoAttack(actor) = {
	if (actor == jeanieMe)
	    "You got over temper tantrums years ago. ";
	else if (actor == frankMe)
	    "You have a hard-enough time keeping your temper in check
	     without going around hitting things. ";
	else "You've never done something like that! ";
    }
    verDoPlug(actor) = {
	"You can't plug <<self.thedesc>> into anything. ";
    }
    doThrowAt(actor, io) = {
	if (actor == jeanieMe)
	    "You got into so much trouble for that when you were little,
	     you don't throw anything any more. ";
	else if (actor == frankMe)
	    "C'mon. Don't let your temper get the better of you. ";
	else "That's uncalled for! ";
    }
;

// basicMe, by default, will have its sdesc_pointer and ldesc_pointer
// set to Jeanie's pointers. Also put in the responseMethod handling
modify basicMe
    sdesc_pointer = &j_sdesc
    ldesc_pointer = &j_ldesc
    ldesc1_pointer = &j_ldesc1
    sdesc = {
	self.(parserGetMe().sdesc_pointer);
    }
    ldesc = {
	self.(parserGetMe().ldesc_pointer);
    }
    // The responseMethod can either be a single-quoted string or an
    // actual property pointer (which is assumed to exist inside this
    // character object). Any properties pointed to by responseMethod
    // must return true if something is printed, false otherwise.
    // responsePerson tells us who the response is to be directed to and is
    // responsible for calling clearResponse if necessary.
    responseMethod = nil
    responsePerson = nil
    setResponse(resp, person) = {
	unnotify(self, &clearResponse);
	self.responseMethod = resp;
	self.responsePerson = person;
	notify(self, &clearResponse, 3);
    }
    clearResponse = {
	self.responseMethod = nil;
	self.responsePerson = nil;
    }
    // makeResponse returns true if something is printed
    makeResponse(person) = {
	if (person != self.responsePerson)
	    return nil;
	switch (proptype(self, &responseMethod)) {
	  case 3:  // String
	    say(self.responseMethod);
	    self.clearResponse;
	    return true;

	  case 13:  // Property pointer
	    return self.(self.responseMethod);

	  default:
	    return nil;
	}
    }
;

// Add sdesc/ldesc pointers to objects in adv.t other than thing
modify surface
    ldesc = {
	self.(parserGetMe().ldesc_pointer);
    }
;

modify decoration
    ldesc = {
	self.(parserGetMe().ldesc_pointer);
    }
;

modify doorway
    ldesc = {
	self.(parserGetMe().ldesc_pointer);
    }
;


/*
** Some functions &c.
*/

// Get the actor object (either parserGetObj(PO_ACTOR) or, if that is
//  nil, parserGetMe())
// Usage: actorObject()
actorObject: function
{
    local ob;

    ob = parserGetObj(PO_ACTOR);
    if (ob == nil)
	ob = parserGetMe();
    return ob;
}

// Display an image. Call this function with the file name of the image.
// Usage: gprintf('image.jpg');
gprint: function(image)
{
    "<IMG SRC=\"<<image>>\">";
}

// Display an image with extra formatting.
// Usage: gprintf('image.jpg', 'ALT="An image"');
gprintf: function(image, options)
{
    "<IMG SRC=\"<<image>>\" <<options>> >";
}

// Create a link. Give this function the text to be linked and the command
//  to which the text should be linked.
// Usage: link('refrigerator', 'x refrigerator');
link: function(contents, command)
{
    if (global.isHTMLRuntime)
        "<A HREF=\"<<command>>\"><<contents>></a>";
    else say(contents);
}

// shuffle() randomly shuffles a list. The algorithm is from Knuth.
// Usage: shuffle(list);
shuffle: function(list)
{
    local i, retlist, tempitem, ndx;

    retlist = list;
    for (i = 1; i < length(list); i++) {
        ndx = _rand(length(list));
        tempitem = retlist[i];
        retlist[i] = retlist[ndx];
        retlist[ndx] = tempitem;
    }
    return retlist;
}

// moveList moves all items in a list to a destination. Note that this
//  function won't move an item which has the isfixed property set to true
// Usage: moveList(list_of_objects, destination);
moveList: function(list, dest)
{
    local i, len;

    len = length(list);
    for (i = 1; i <= len; i++)
        if (!list[i].isfixed)
            list[i].moveInto(dest);
}

// uberloc returns the outermost container an object is in, no matter how
//  deeply nested. If an object has isUber set to true, this function will
//  treat that object as if it is the outermost container
// Usage: uberloc(object)
uberloc: function(ob)
{
    local loc;

    loc = ob;
    while (loc && loc.location) {
        if (loc.isUber) return loc;
        loc = loc.location;
    }
    return loc;
}


/*
** New classes and some global objects
*/

// Whenever the player is inside, I want him/her to be able to look at the
// ceiling or the floor. This class doesn't do anything other than mark
// the room as one that is inside and thus should have a floor and a ceiling.
class insideRm: room
;

// I need a specific type of insideRm for the house. Hence, houseRm
class houseRm: insideRm
;

// And I need another one for the bus station
class busRm: insideRm
;

// Some rooms keep track of how many turns the main character has spent
// inside them. These turnCountRooms have a turnCounter which is
// updated via the postAction() function, defined in gndparse.t.
// postAction() calls the room's updateCounter function. If you want
// something special to happen at a certain time, have the room's
// updateCounter function perform the necessary checks.
class turnCountRoom: room
    turnCounter = 0
    updateCounter = { self.turnCounter++; }
;

// The ceiling is a floatingItem (which means that it's available in more
// than one room) and it's a decoration (which means that anything the player
// tries to do to it other than look at it will result in a "Don't worry about
// the ceiling" message).
ceiling: floatingItem, decoration
    noun = 'ceiling'
// Here's how the ceiling's location works: check to see if the room
// that the player (Me) is in is of class insideRm. If so, return the player's
// location so that the player can refer to the ceiling. Otherwise, pretend
// that the ceiling is nowhere.
    location = {
        if (isclass(parserGetMe().location, insideRm))
            return parserGetMe().location;
        else return nil;
    }
    sdesc = "ceiling"
    ldesc = "The ceiling is above you. "
;

// A twodescthing has two long descriptions: x_ldesc1 and x_ldesc. The
// first time the thing is looked at, x_ldesc1 is printed. Every time
// thereafter x_ldesc is printed
class twodescthing: thing
    firstLdesc = true
    ldesc = {
	if (self.firstLdesc == true) {
	    self.firstLdesc = nil;
	    self.(parserGetMe().ldesc1_pointer);
	}
	else self.(parserGetMe().ldesc_pointer);
    }
    j_ldesc1 = ""
    f_ldesc1 = ""
    d_ldesc1 = ""
;

// Droom, a room with two ldescs. See twodescthing for more details
class twodescroom : room
    ldesc = {
	if (!self.isseen)
	    self.(parserGetMe().ldesc1_pointer);
	else self.(parserGetMe().ldesc_pointer);
    }
    j_ldesc1 = ""
    f_ldesc1 = ""
    d_ldesc1 = ""
;

// A door through which you walk when you open it, and which you close
// afterwards
class autoDoor: fixeditem, obstacle
    noun = 'door'
    ldesc = "It's closed. "
    destination = {
	if (self.islocked) {
	    "It's locked. ";
	    return nil;
	}
	"You open the door and go through, closing it behind you.\b";
	return self.doordest;
    }
    verDoOpen(actor) = {
	if (self.islocked)
	    "It's locked. ";
    }
    doOpen(actor) = {
	actor.travelTo(self.destination);
    }
    doSynonym('Open') = 'Enter'
    verDoClose(actor) = { "It's already closed. "; }
    verDoKnock(actor) = { }
    doKnock(actor) = { "Nobody's in there. "; }
    verDoLock(actor) = {
	"It doesn't lock from this side. ";
    }
    doLock(actor) = {
	if (self.islocked)
	    "It's already locked. ";
	else {
	    "You lock the door. ";
	    self.islocked = true;
	}
    }
    verDoUnlock(actor) = {
	if (!self.islocked)
	    "It's not locked. ";
    }
    doUnlock(actor) = {
	"You unlock the door. ";
	self.islocked = nil;
    }
;

// For Jeanie's makeup
class makeupItem: item
    verDoApply(actor) = {
	if (actor.makeupDone)
	    "You're done with your makeup. ";
	else if (actor.(self.appliedProp))
	    "You've already put on <<self.makeupdesc>>. ";
    }
    doApply(actor) = {
	self.applyDesc;
	actor.(self.appliedProp) = true;
	if (actor.blushOn && actor.eyeshadowOn && actor.mascaraOn)
	    actor.makeupDone = true;
    }
    doSynonym('Apply') = 'Wear' 'Open'
;

// Intangible, for smells and sounds and whatnot.  It can't be felt,
// looked at, &c.
class intangible : fixeditem
    thatdesc2 = {
        if (self.isThem)
            "those";
        else
            "that";
    }
    takedesc = "\^<<self.thatdesc2>> can't be taken. "
    verDoMove(actor)={"\^<<self.thatdesc2>> can't be moved. ";}
    verDoTouch(actor)={"\^<<self.thatdesc2>>That can't be touched. ";}
    ldesc = {
	self.isThem ? "Those aren't" : "That's not";
	" visible. ";
    }
    verDoLookbehind(actor) = {
	self.isThem ? "Those aren't" : "That's not";
	" visible. ";
    }
    verDoAttack(actor)={"\^<<self.thatdesc2>> can't be attacked.";}
    verDoAttackWith(actor)={"\^<<self.thatdesc2>> can't be attacked.";}
    verIoPutOn(actor)={"%You% can't put anything on <<self.thatdesc2>>.";}
;

// For objects on Frank's desk
class deskItem: item
    verDoDrop(actor) = {
	if (!actor.isCarrying(self))
	    pass verDoDrop;
	else "Best you hang onto it if you're going to fix the
	      toaster. ";
    }
    verDoPutIn(actor, io) = {
	"Best you hang onto it if you're going to fix the toaster. ";
    }
    verDoPutOn(actor, io) = {
	if (io != little_desk)
	    "Best you hang onto it if you're going to fix the
	     toaster. ";
	else pass verDoPutOn;
    }
    verDoThrow(actor) = (self.verDoDrop(actor))
    verDoThrowAt(actor, io) = (self.verDoDrop(actor))
    // Use the xobjChecks to put Frank in the chair if he works
    // on me
    dobjCheck(actor, verb, iobj, prep) = {
	if (verb.touch && !actor.isIn(franks_chair)) {
	    "Before starting work on the toaster you lower yourself into
	     your chair.\b";
	    actor.moveInto(franks_chair);
	}
    }
    iobjCheck(a, v, d, p) = (self.dobjCheck(a, v, d, p))
;    

// For objects in Frank's toaster
class toasterContent: item
    screwedIn = true
    tested = nil
    screwdesc = "If you see this, alert an implementor. <i>{Error}</i> "
    unscrewdesc = "If you see this, alert an implementor. <i>{Error}</i> "
    // Use the xobjChecks to put Frank in the chair if he works
    // on me
    dobjCheck(actor, verb, iobj, prep) = {
	if (verb.touch && !actor.isIn(franks_chair)) {
	    "Before starting work on the toaster you lower yourself into
	     your chair.\b";
	    actor.moveInto(franks_chair);
	}
    }
    iobjCheck(a, v, d, p) = (self.dobjCheck(a, v, d, p))
    // Handle testing with the multimeter
    verDoTestWith(actor, iobj) = {}
    doTestWith(actor, iobj) = {
	if (self.tested)
	    self.secondTestDesc;
	else {
	    self.tested = true;
	    self.firstTestDesc;
	    toaster.checkFixedStatus;   // See if this fixes the toaster
	}
    }
    // If the player tries PUT METER ON us, map it to TEST us WITH METER
    verIoPutOn(actor) = {}
    ioPutOn(actor, dobj) = {
	if (dobj == multimeter)
	    self.doTestWith(actor, dobj);
	else inherited.verIoPutOn(actor);
    }
    // Handle unscrewing and screwing
    verDoUnscrew(actor) = {
	if (!self.isIn(toaster))
	    "It's not screwed into anything. ";
	else if (!screwdriver.atTheReady(actor))
	    "You'll need the screwdriver. ";
    }
    doUnscrew(actor) = {
	self.unscrewdesc;
	self.screwedIn = nil;
	self.moveInto(actor);
	if (itemcnt(toaster.contents) == 0)
	    screws.moveInto(nil);
    }
    doSynonym('Unscrew') = 'Detach'
    verDoUnscrewWith(actor, iobj) = {
	if (iobj != screwdriver)
	    "You can't unscrew <<self.thedesc>> with <<iobj.thatdesc>>. ";
	else self.verDoUnscrew(actor);
    }
    doUnscrewWith(actor, iobj) = { self.doUnscrew(actor); }
    verDoUnscrewFrom(actor, iobj) = {
	if (!(self.isIn(iobj) && self.screwedIn))
	    "\^<<self.thedesc>> isn't screwed into <<iobj.thedesc>>. ";
	else if (!screwdriver.atTheReady(actor))
	    "You'll need the screwdriver. ";
    }
    doUnscrewFrom(actor, iobj) = { self.doUnscrew(actor); }
    doSynonym('UnscrewFrom') = 'DetachFrom'
    verDoScrew(actor) = {
	if (self.screwedIn)
	    "It's already screwed into <<self.location.thedesc>>. ";
	else if (!screwdriver.atTheReady(actor))
	    "You'll need the screwdriver. ";
	else if (self.isAPowerCord && toaster.hasAPowerCord)
	    "The toaster's already got a power cord. ";
    }
    doScrew(actor) = {
	self.screwdesc;
	self.moveInto(toaster);
	self.screwedIn = true;
	if (screws.location == nil)
	    screws.moveInto(little_desk);
	toaster.checkFixedStatus;   // See if this fixes the toaster
    }
    verDoScrewWith(actor, iobj) = {
	if (iobj != screwdriver)
	    "You can't screw <<self.thedesc>> with <<iobj.thedesc>>. ";
	else self.verDoScrew(actor);
    }
    doScrewWith(actor, iobj) = { self.doScrew(actor); }
    verDoScrewTo(actor, iobj) = {
	if (iobj != toaster)
	    "You can't screw <<self.thedesc>> to <<iobj.thatdesc>>. ";
	else self.verDoScrew(actor);
    }
    doScrewTo(actor, iobj) = { self.doScrew(actor); }
    verDoAttachTo(actor, iobj) = {
	if (iobj != multimeter)
	    self.verDoScrewTo(actor, iobj);
    }
    verIoAttachTo(actor) = {}
    ioAttachTo(actor, dobj) = {
	if (dobj != multimeter)
	    "You can't attach <<dobj.thedesc>> to <<self.thedesc>>. ";
	else self.doTestWith(actor, dobj);
    }
    verDoPutIn(actor, iobj) = {
	if (iobj == toaster)
	    self.verDoScrewTo(actor, iobj);
	else pass verDoPutIn;
    }
;

// Our hands, which Lucian made me add.
hands: fixeditem, floatingItem
    isListed = nil    // Don't include us in contlist()
    noun = 'hand' 'fist'
    plural = 'hands' 'fists'
    adjective = 'left' 'right' 'my'
    location = (parserGetMe())
    sdesc = "hands"
    j_ldesc = "They're a little chapped. "
    f_ldesc = "Blunt and thick-fingered. "
    d_ldesc = "Looks like it's time to trim your nails. And when did
	       your hands get so veiny? "
    thedesc = "your hand"
    adesc = "your hand"
    isReachable(actor) = (self.location==parserGetMe())
    isVisible(actor) = (self.location==parserGetMe())
    replace verifyRemove(a) = {
        "How're you going to do that? ";
    }
    // Don't allow us to do unexpected things
    noCanDoMsg = "%You% %do%n't need to do that. "
    dobjGen(a,v,i,p) = { self.noCanDoMsg; exitobj; }
    iobjGen(a,v,o,p) = { self.noCanDoMsg; exitobj; }
    // Inspect isn't unexpected
    verDoInspect(a) = {}
    // Nor is wash. Any room which has a sinkObj will let you wash
    verDoWash(actor) = {
	if (actor.location.sinkObj != nil)
	    actor.location.sinkObj.verDoTurnon(actor);
	else "Not here. ";
    }
;


/*
** Modified adv.t objects
*/

// Use parseUnknownIobj in askVerb and tellVerb to let the player know
// that they need to use TALK TO instead of ASK ABOUT/TELL ABOUT
modify askVerb
    parseUnknownIobj(actor, prep, dobj, wordlist) = {
	if (prep == aboutPrep)
	    return jeanie;  // Return any object -- it won't be used
	else return nil;
    }
;

modify tellVerb
    parseUnknownIobj(actor, prep, dobj, wordlist) = {
	if (prep == aboutPrep)
	    return jeanie;  // Return any object -- it won't be used
	else return nil;
    }
;

// While I'm at it, have the helloVerb tell the player to use TALK TO
modify helloVerb
    action(actor) = {
	"If you want to talk to someone, use TALK TO. ";
	abort;
    }
;

// For old-skool players, "look <object>" should be the same as "look at
// <object>".
modify lookVerb
    doAction = 'Inspect'
    validDo(actor, obj, seqno) = {
        return obj.isVisible(actor);
    }
;

// Make 'grab' a synonym for 'take'
modify takeVerb
    verb = 'grab'
;

// Don't let the player yell
modify yellVerb
    verb = 'scream'
    action(actor) = {
	if (actor == jeanieMe)
	    "You gave up yelling years ago. ";
	else if (actor == frankMe)
	    "If you thought it'd do any good, you would. ";
	else "Ladies don't yell. ";
    }
;

// Let the player 'sit at'
modify sitVerb
    verb = 'sit at'
;

// I don't want the player to have to muck about with his or her inventory,
// so I side-step the entire problem by removing items' bulk and weight
modify item
    weight = 0
    bulk = 0
;

// Don't let the player sit on the floor
modify theFloor
    verDoSiton(actor) = {
	"That's not very comfortable. ";
    }
    doSynonym('Siton') = 'Lieon'
;

// I also want the responses an Actor makes to be enclosed in nice quotes, not
// plain old '\"' quotes, so I'm modifying movableActor. Yeah, I know it's
// being picky. So sue me.
// [N.B. This code is ripped from adv.t. Modify as necessary.]
// I'm also going to make some other changes to Actors.
modify movableActor
    doAskAbout(actor, iobj) = {
        local lst, i, tot;
        
        lst = objwords(2);       // get actual words asked about
        tot = length(lst);
        if ((tot == 1 && (find(['it' 'them' 'him' 'her'], lst[1]) != nil))
            || tot == 0)
        {
            self.specifyMore;   // I'm changing this so individual actors
                                // can override this message.
            return;
        }
        
        // try to find a response for each word
        for (i = 1 ; i <= tot ; ++i)
        {
            if (self.askWord(lst[i], lst))
                return;
        }
        
        // didn't find anything to talk about
        self.disavow;
    }
    specifyMore = "<q>Could you be more specific?<q>"
    disavow = "<q>I don't know much about that.</q>"
    sdesc = { self.(parserGetMe().sdesc_pointer); }
    ldesc = { self.(parserGetMe().ldesc_pointer); }
    verDoTalkto(actor) = {}
    doTalkto(actor) = { actor.talkTo(self); }
    actorAction(v, d, p, i) = {
	if (v == helloVerb || v == yesVerb || v == noVerb) {
	    "If you want to talk to someone, use TALK TO. ";
	    abort;
	}
	pass actorAction;
    }
    verDoSearch(actor) = {
	if (actor == frankMe && self == jeanie)
	    "You may not trust her much, but c'mon! ";
	else if (actor != self)
	    "Don't do that. ";
    }
    doSearch(actor) = {	iVerb.action(actor); }
    verDoTouch(actor) = {
	if (actor == self) {
	    if (actor == jeanieMe || actor == frankMe)
		"You're not that hard up for a good time. ";
	    else "Don't be crude. ";
	}
    }
    verDoKiss(actor) = { "Ew. "; }
;

// I'm going to change the status line of rooms. Why?  Because I
// don't want 'Score' in the status line. I'm also going to allow the
// player to click on the room title in the status bar to look around.
// [N.B. This code is (mostly) ripped from adv.t]
modify room
    statusLine = {
        if (systemInfo(__SYSINFO_SYSINFO) == true
            && systemInfo(__SYSINFO_HTML) == 1)
        {
            "<banner id=StatusLine height=previous border><body
            bgcolor=statusbg text=statustext>";
            "<b><a plain href=\"Look\"><<self.statusRoot>></a></b>";
	    "</banner>";
        }
        else
        {
            self.statusRoot; "\n\t";
        }
    }
;

// One problem: non-HTML-enabled runtimes still use scoreStatus, so I have
// to change that as well.
replace scoreStatus: function(points, turns)
{
    setscore('');
}

// Add a default exit handler to nested rooms like chairs
modify nestedroom
    exits = { return (self.location.exits); }
;

// Add wordDesc to doorways and openables, which prints "open" if the
// object is open and "closed" if it is closed, and aWordDesc, which
// prints "an open" or "a closed", depending on the state of the object.
// While I'm at it, I'm going to modify the "Opened." and "Closed."
// messages--they don't give enough information to my mind.
modify openable
    wordDesc = {
	if (self.isopen)
	    "open";
	else "closed";
    }
    aWordDesc = {
	if (self.isopen)
	    "an open";
	else "a closed";
    }
;

// N.B. doOpen/doClose code taken from adv.t
modify doorway
    wordDesc = {
	if (self.isopen)
	    "open";
	else "closed";
    }
    aWordDesc = {
	if (self.isopen)
	    "an open";
	else "a closed";
    }
    doOpen(actor) = {
	"%You% open%s% <<self.thedesc>>. ";
	self.setIsopen(true);
    }
    doClose(actor) = {
	"%You% close%s% <<self.thedesc>>. ";
	self.setIsopen(nil);
    }
;

// I think that you should not only be able to switch a switch, but that
// you should be able to "throw switch" and "flip switch".
modify switchItem
    doSynonym('Switch') = 'Throw' 'Flip'
;

// For atmospheric reasons, I often like to modify the boring "You can't have
// that" message that fixeditems print, so now each fixeditem has a takedesc.
modify fixeditem
    verDoTake(actor) = { self.takedesc; }
    takedesc = "%You% can't have <<self.thedesc>>. "
;

// Same for decorations
modify decoration
    verDoTake(actor) = { self.takedesc; }
    takedesc = "%You% can't have <<self.thedesc>>. "
;

// I want the player to be able to attack things w/o an indirect object
modify attackVerb
    doAction = 'Attack'
;

// 'Assemble' should be the same as 'close'
modify closeVerb
    verb = 'assemble'
;

// Let the player 'plug in' objects
modify plugVerb
    verb = 'plug in'
    doAction = 'Plug'
;


/*
** New verb/prep section
*/

// Tell me about your game....
aboutVerb: sysverb
    sdesc = "about"
    verb = 'about'
    action(actor) = {
"<B>Common Ground</B> is copyright &copy; 1999 by Stephen Granade. It
may be freely copied, distributed and played as long as it is not
modified in any way. You may not distribute copies of the game for a
fee exceeding the cost of distribution.

\b<B>Common Ground</B> has some special commands which you can find out
about by typing <strong><<link('COMMANDS',
'commands')>></strong>.  <strong><<link('HELP', 'help')>></strong>
will give you help with playing the game; the
<strong><<link('CREDITS', 'credits')>></strong> command will list all
applicable credits for <B>Common Ground</B>.

\bNote that the only way to talk to someone is to use the command
TALK TO [person]. The reason for this will, I suspect, quickly become
obvious.

\bIf you want to make sure you have the latest version of the game, visit
the <B>Common Ground</B> homepage at
http://www.phy.duke.edu/~sgranade/ground.html or the GMD archive at
either ftp://ftp.gmd.de/if-archive/games/tads or
http://ifarchive.org/indexes/if-archiveXgamesXtads.html. If you want to give
me your opinion of the game, or if you find a bug, please e-mail me at
sgranade@phy.duke.edu. ";

        abort;    // This way the player doesn't lose a turn
    }
;

// Print the special commands
commandsVerb: sysverb
    sdesc = "commands"
    verb = 'commands'
    describeMe = {
"ABOUT: Prints information about <B>Common Ground</B>.

\bCOMMANDS: Shows a list of these special commands.

\bCREDITS: Lists the credits for <B>Common Ground</B>.

\bDEDICATION: Prints the dedication for <B>Common Ground</B>.

\bEXITS: Lists the possible exits from your location.";

"\bHELP: Gives some help for playing this game.

\bINVENTORY or I: Shows the list of items you are carrying. Your inventory
can be printed in two versions, INVENTORY TALL and INVENTORY WIDE.

\bOOPS: Allows you to correct the spelling of a word in the last
command. You can use OOPS when the game displays this complaint: <q>I
don\'t know the word &lt;word&gt;.</q> Immediately after this
message, you can type OOPS followed by the corrected spelling of the
misspelled word. You can only type one word after OOPS, so this
command doesn\'t allow you to correct certain types of errors,
such as when you run two words together without a space.

\bQUIT or Q: Ends the game.

\bQUOTES: Toggles whether single quotes are printed as \\' or as ";

if (global.isHTMLRuntime)
"&rsquo;";
else "curly quotes";
". Only works under HTML-enabled interpreters. You should
only turn this feature off if the game runs slowly for you.

\bRESTART: Starts the game over from the beginning.

\bRESTORE: Restores a position previously saved with the SAVE command.

\bSAVE: Stores the current state of the game in a disk file, so that you can
come back to the same place later with the RESTORE command.

\bSCRIPT: Starts writing everything you see on the screen (both your
commands and the game\'s responses) to a disk file. The game will
ask you for a filename to be used for the transcript; you should
select a filename that does not yet exist on your disk, because if you
use an existing filename, data in that file will be destroyed. Use the
UNSCRIPT command to stop making the transcript.

\bTALK TO [character]: This is the only way you can communicate with
other characters.

\bTERSE: For impatient users, this tells the game that you wish to see
only short descriptions of locations you have already seen when you
reenter them.  See also the VERBOSE command.

\bUNDO: Tells the game you want to take back your last command. The
game state will be restored to the way it was before the previous
command, as though the command were never issued at all. You can do
this more than once in a row.

\bUNSCRIPT: Turns off the transcript that was begun with the SCRIPT
command.

\bVERBOSE: For amnesiac players, this tells the game to show you the
full description of every location you enter, whether or not you have
seen the description before. This is the default mode. See also the
TERSE command.

\bVERSION: Shows the current version number of the game. ";
    }
    action(actor) = {
        self.describeMe;
        abort;
    }
;

// I want to make sure I give credit where credit is due
creditsVerb: sysverb
    sdesc = "credits"
    verb = 'credits'
    describeMe = {
        version.sdesc;
	"\b";
        if (global.isHTMLRuntime)
            "<center><h3>Credits</h3></center>";
        else "\b\(Credits\)\b";
	"This game would not be half of what it is without the help
	 and guidance of my crack team of beta-testers: Mike Kinyon,
	 Dan Shiovitz, Lucian Smith, and Adam Thornton. They kindly
	 agreed to test the game, even though Thanksgiving,
	 Hanukkah, and Christmas were looming. It's thanks to them
	 that I was able to finish <B>Common Ground</B> by the end
	 of 1999.
	 \bA tip o' the hat to those who made suggestions and reported
         bugs: David Glasser, Neil deMause, Sam Barlow, Magnus
         Olsson, Gunther Schmidl, Brendan Milburn, Vincent Lynch,
	 Torbj&ouml;rn Andersson, Mark Musante, Eric Mayer, Tim
	 Woerner, and Peter Berman.
	 \bSpecial thanks go to Misty Granade, who, as always, put up
	 with me while I struggled with writing this game; and to
	 everyone who took part in the ifMUD Implementors' Lunch and
	 gave me invaluable advice. I bet you didn't expect that this
	 game would be the result. ";
    }
    action(actor) = {
        self.describeMe;
        abort;
    }
;

exitsVerb: sysverb
    sdesc = "exits"
    verb = 'exits'
    action(actor) = {
        "You can go <<actor.location.exits>>. ";
        abort;
    }
;

quotesVerb: sysverb
    sdesc = "quotes"
    verb = 'quotes'
    action(actor) = {
	if (!global.isHTMLRuntime)
	    "This interpreter can't display curly single quotes. ";
	else if (global.curlyQuotesOn) {
	    "Single quotes will no longer be displayed as ', but as
	     \\'. ";
	    setOutputFilter(nil);
	}
	else {
	    setOutputFilter(changeQuotes);
	    "Single quotes will now be displayed as ' rather than
	     as \\'. ";
	}
	global.curlyQuotesOn = !global.curlyQuotesOn;
	abort;
    }
;

// Allow the player to get help
helpVerb: deepverb
    sdesc = "help"
    verb = 'hint' 'help' 'hints'
    action(actor) = {
        top_menu.display;
        abort;
    }
    doAction = 'Help'
;

// Just as you can help people, you can fix things
fixVerb: deepverb
    sdesc = "fix"
    verb = 'fix'
    doAction = 'Fix'
;

// The game's dedication
dedicationVerb: deepverb
    sdesc = "dedication"
    verb = 'dedication'
    action(actor) = {
        "For Misty, who didn't laugh when I said, <q>I want to
	 write.</q>";
    }
;

// For talking to NPCs
talkVerb: deepverb
    // Assume that we can talk to someone if they're visible
    validDo(actor, obj, seqno) = {
	return (obj.isVisible(actor));
    }
    validIo(actor, obj, seqno) = { return (seqno == 1); }
    validIoList(actor, prep, dobj) = (nil)
    sdesc = "talk to"
    verb = 'talk to'
    doAction = 'Talkto'
    ioAction(aboutPrep) = 'TalktoAbout'
;

// In case the player wants to say "yes" or "no"
yesVerb: deepverb
    sdesc = "yes"
    verb = 'yes'
    action(actor) = {
	"If you want to talk to someone, use TALK TO. ";
	abort;
    }
;

noVerb: deepverb
    sdesc = "no"
    verb = 'no'
    action(actor) = {
	"If you want to talk to someone, use TALK TO. ";
	abort;
    }
;

nodVerb: deepverb
    sdesc = "nod"
    verb = 'nod'
    action(actor) = {
	"If you want to talk to someone, use TALK TO. ";
	abort;
    }
;

// After _Grip_, people are going to try this in every game I write
kickVerb: deepverb
    touch = true
    sdesc = "kick"
    verb = 'kick'
    action(actor) = {
	if (actor == jeanieMe)
	    "Like you're one of those bitches on the cheerleading
	     squad or something. ";
	else if (actor == frankMe)
	    "No sense in going around kicking stuff. ";
	else "You haven't done high kicks since you were a cheerleader. ";
    }
    doAction = 'Kick'
;

// For using the bathroom
useVerb: deepverb
    sdesc = "use"
    verb = 'use'
    doAction = 'Use'
;

// Again, for using the bathroom
peeVerb: deepverb
    sdesc = "pee"
    verb = 'pee' 'piss' 'whiz'
    action(actor) = {
	if (actor.location.isBathroom)
	    "You don't need to go right now. ";
	else "Not here! ";
    }
;

// And again, another bathroom verb
crapVerb: deepverb
    sdesc = "crap"
    verb = 'crap' 'shit' 'poop'
    action(actor) = {
	if (actor.location.isBathroom)
	    "You don't need to go right now. ";
	else "Not here! ";
    }
;

// And, hey, while we're at it...
flushVerb: deepverb
    sdesc = "flush"
    verb = 'flush'
    doAction = 'Flush'
;

// For washing your hands
washVerb: deepverb
    touch = true
    sdesc = "wash"
    verb = 'wash'
    doAction = 'Wash'
;

// For counting the money
countVerb: deepverb
    touch = true
    sdesc = "count"
    verb = 'count'
    doAction = 'Count'
;

// For kissing people
kissVerb: deepverb
    touch = true
    sdesc = "kiss"
    verb = 'kiss' 'hug'
    doAction = 'Kiss'
;

// For watching TV
watchVerb: deepverb
    sdesc = "watch"
    verb = 'watch'
    doAction = 'Watch'
    validDo(actor, obj, seqno) = {
        return obj.isVisible(actor);
    }
;

// For turning up the TV volume
turnupVerb: deepverb
    touch = true
    sdesc = "turn up"
    verb = 'turn up'
    doAction = 'Turnup'
;

// And for turning it down
turndownVerb: deepverb
    touch = true
    sdesc = "turn down"
    verb = 'turn down'
    doAction = 'Turndown'
;

// Shake-a your rump-a
danceVerb: deepverb
    sdesc = "dance"
    verb = 'dance'
    action(actor) = {
	if (actor == frankMe)
	    "You weren't any good at dancing when you were young.
	     What makes you think you could do it now? ";
	else if (actor == debMe)
	    "Goodness, it's been ages since you danced! Wonder if
	     Frank would take you next weekend. ";
	else {
	    if (!actor.isIn(living_room) || !tv.isActive ||
		tv.commercialShowing)
		"There's no music. ";
	    else "Not with Frank watching your every shimmy. ";
	}
    }
;

// Because Mike Kinyon tried this
stripVerb: deepverb
    sdesc = "strip"
    verb = 'strip'
    action(actor) = {
	if (actor == jeanieMe)
	    "You'd get in real trouble if you did that. ";
	else if (actor == frankMe)
	    "Like everybody needs to see your flabby body. ";
	else "Don't be silly. ";
    }
;

// For changing channels
changeVerb: deepverb
    touch = true
    sdesc = "change"
    verb = 'change'
    doAction = 'Change'
;

// For slathering on makeup
applyVerb: deepverb
    touch = true
    sdesc = "apply"
    verb = 'apply'
    doAction = 'Apply'
;

// For giving Frank a massage
rubVerb: deepverb
    touch = true
    sdesc = "rub"
    verb = 'rub' 'massage'
    doAction = 'Rub'
;

// For making the bed
makeVerb: deepverb
    touch = true
    sdesc = "make"
    verb = 'make'
    doAction = 'Make'
;

// Allow Jeanie to put groceries away and put groceries up
awayPrep: Prep
    preposition = 'away'
    sdesc = "away"
;

modify moveVerb
    verb = 'put away' 'put up'
;

// Crush the can
crushVerb: deepverb
    touch = true
    sdesc = "crush"
    verb = 'crush' 'crumple'
    doAction = 'Crush'
;

// Test broken bits of the toaster
testVerb: deepverb
    touch = true
    sdesc = "test"
    verb = 'test'
    prepDefault = withPrep
    ioAction(withPrep) = 'TestWith'
    ioDefault(actor, prep) = {
	local list;

	list = actor.contents + actor.location.contents;
	if (actor.isIn(franks_chair))
	    list += little_desk.contents;
	return list;
    }
;


/*
** Modified adv.t verbs
*/

// I only want you to be able to use certain verbs with the word 'all'.
// This requires some fiddling with the rejectMultiDobj function in deepverb
modify deepverb
    rejectMultiDobj(prep) = {
        if (self.allowall || find(objwords(1), 'all') == nil)
            return nil;
        "You can't use <q>all</q> with this verb. ";
        abort;
    }
;

modify takeVerb
    allowall=true
;

// Besides allowing "all" to work with drop, allow "drop xxx in yyy" ==
//  "put xxx in yyy" and "drop xxx on yyy" == "put xxx on yyy".
modify dropVerb
    allowall=true
    ioAction(inPrep) = 'PutIn'
    ioAction(onPrep) = 'PutOn'
;

modify putVerb
    allowall=true
;

// I want the 'sleep' command to print a snappy response.
modify sleepVerb
    action(actor) = { "You're not that sleepy. "; }
;

// Let 'flop' be the same as 'sit'
modify sitVerb
    verb = 'flop on' 'flop downon' 'flop in' 'flop downin'
;

modify lookThruVerb
    verb = 'look out'    // So the player can 'look out window'
;

modify cleanVerb
    verb = 'dust'        // So Deb can dust things
;

// Let "sip" be a synonym for "drink"
modify drinkVerb
    verb = 'sip'
;

// Allow "screw to/into/onto" and "unscrew from"
modify screwVerb
    verb = 'screw' 'screw in'
    prepDefault = toPrep
    ioAction(toPrep) = 'ScrewTo'
    ioAction(onPrep) = 'ScrewTo'
    ioAction(inPrep) = 'ScrewTo'
;

modify unscrewVerb
    prepDefault = fromPrep
    ioAction(fromPrep) = 'UnscrewFrom'
;

// Let the player "get out" if they're in the bus
modify getOutVerb
    action(actor) = {
	if (actor.isIn(bus))
	    actor.travelTo(bus.north);
    }
;

// Put a flag in verbs which require you to touch the item. That way, if I
// want something special to happen if/when a player touches an item, I don't
// have to check for *every* verb. Instead, I just see if the verb has the
// touch flag set.
modify digVerb
    touch = true;
modify pushVerb
    touch = true;
modify attachVerb
    touch = true;
modify wearVerb
    touch = true;
modify dropVerb
    touch = true;
modify removeVerb
    touch = true;
modify openVerb
    touch = true;
modify closeVerb
    touch = true;
modify putVerb
    touch = true;
modify takeVerb
    touch = true;
modify plugVerb
    touch = true;
modify screwVerb
    touch = true;
modify unscrewVerb
    touch = true;
modify turnVerb
    touch = true;
modify switchVerb
    touch = true;
modify flipVerb
    touch = true;
modify turnOnVerb
    touch = true;
modify turnOffVerb
    touch = true;
modify sitVerb
    touch = true;
modify lieVerb
    touch = true;
modify boardVerb
    touch = true;
modify breakVerb
    touch = true;
modify attackVerb
    touch = true;
modify climbVerb
    touch = true;
modify eatVerb
    touch = true;
modify drinkVerb
    touch = true;
modify giveVerb
    touch = true;
modify pullVerb
    touch = true;
modify throwVerb
    touch = true;
modify standOnVerb
    touch = true;
modify showVerb
    touch = true;
modify cleanVerb
    touch = true;
modify moveVerb
    touch = true;
modify fastenVerb
    touch = true;
modify unfastenVerb
    touch = true;
modify unplugVerb
    touch = true;
modify typeVerb
    touch = true;
modify lockVerb
    touch = true;
modify unlockVerb
    touch = true;
modify detachVerb
    touch = true;
modify pokeVerb
    touch = true;
modify touchVerb
    touch = true;
modify moveNVerb
    touch = true;
modify moveSVerb
    touch = true;
modify moveEVerb
    touch = true;
modify moveWVerb
    touch = true;
modify moveNEVerb
    touch = true;
modify moveNWVerb
    touch = true;
modify moveSEVerb
    touch = true;
modify moveSWVerb
    touch = true;
modify centerVerb
    touch = true;
modify searchVerb
    touch = true;
modify knockVerb
    touch = true;
