/* FIRST THINGS FIRST - Locations - present.t - Version Beta 3.00
/*  Copyright (c) 1996, 1997, 1999, 2000 by J. Robinson Wheeler. All Rights Reserved. */

/*
 *					********				*********
 *					********	THE GAME CODE	*********
 *					********				*********
 */

/**************************************************************************
 *						The rooms of the PRESENT.						  *
 **************************************************************************/ 

	/************************************************************
 	 *					Rooms outside the House		*
	 ************************************************************/

frontOfHouse: room
	sdesc = "Front of house"
	ldesc = "This is the front of your house. A couple of stones lying about make 
			up your half-hearted attempt at landscaping. "
	xdesc = "Your driveway is to the northeast. A small path leads northwest and
			southwest. The front door stands invitingly to the west. "
	ne = driveway
	west = frontDoor	 							// the locked front door
	in = frontDoor
	nw = northOfHouse
	sw = southOfHouse
;

frontOfHousePath: block
	sdesc = "small path"
	ldesc = "The small path leads northwest and southwest. "
	noun = 'path'
	adjective = 'small'
	location = frontOfHouse
;

frontOfHouseWindows: houseWindow
	ldesc = "The windows here face out from your downstairs bathroom
			to the south and the kitchen to the north, as well as smaller
			windows on the upper floor. All of them are closed and locked
			from the inside, with the blinds closed. "
	location = frontOfHouse
;

house: fixeditem, floatingItem
	sdesc = "house"
	ldesc = "Your house is a pleasant two-story structure, with stained wood 
			instead of paint on the exterior, allowing it to blend in with
			the landscape. " 
	noun = 'house'
	location = 
	{
		switch( Me.location )
		{
			case frontOfHouse:
			case northOfHouse:
			case behindHouse:
			case driveway:
				return( Me.location );
			default: return( nil );
		}
	}
	
	verDoBuy( actor ) = { "You already own it. "; }
	verDoEnter( actor ) = { "You'll have to go in through a door. "; }
	doSynonym( 'Enter' ) = 'Board'
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
		 case Fred:
		 	"Fred says, \"Locked out, eh? Don't you have a spare key?\" ";
		 	Fred.askedAboutKey := true;
			return( true );
		 case Laura:
		 	"Laura says, \"You should always keep a spare key outside in
		 	case of emergencies.\" ";
		 	Laura.askedAboutKey := true;
			return( true );
		 case Architect:
			if ( blueprint.secretpassage ) 
				"He says, \"This will be a marvellous little house,
				full of secrets.\" He taps a finger to the side of
				his nose winks at you. ";
			else
				"He fidgets with the blueprint for a moment and says, 
				\"It's a nice enough house. I kind of wish -- but no,
				this is what you asked for, and I can only deliver
				what you ask for.\" ";
			return( true );
		default: 
			return( nil );
		}
	}
;

/*	The ultimate goal of the game is to unlock this door and go inside.
 *	The frustration is that it's right in front of your nose as you start the
 *	game. The lockableDoorway construct handles all the business with
 *	using keys.
 */
frontDoor: lockableDoorway
	isfixed = nil
	sdesc = "front door"
	ldesc = "It's solid wood, a real beauty, with the best lock money can buy. 
			 You always considered it to be nicely inviting. Until now. "
	adesc = "your front door"
	noun = 'door'
	plural = 'hinges'
	adjective = 'solid' 'wood' 'front' 'locked' 'hinge'
	location = frontOfHouse
	triedOnce = nil
	mykey = duplicateKey
	doordest = finalroom
	noAutoOpen = true
	
	doKnockOn( actor ) =
	{
		if ( endOfGameDoormat.knockOnWoodMessagePrinted )
			"Now, now. There's no need to be superstitious. ";
		else
			pass doKnockOn;
	}
	verDoOpen( actor ) =
	{
		if ( self.isopen )
			"It's already open. ";
	}
	doOpen( actor ) =
	{
		if ( self.islocked )
		{
			"It's locked. ";
			
			if ( not self.triedOnce )
			{
				"Drat the luck, you've forgotten your house key tonight.
				There must be a spare around here somewhere. ";
				
				self.triedOnce := true;
			}
		}
		else pass doOpen;
	}
	spareKeyTried = nil
	doUnlockWith( actor, io ) =
	{
		if ( io = self.mykey )
		{
			"Unlocked! You can barely believe it. ";
			self.setIslocked( nil );
		}
		else if ( io = carKey ) 
		{
			if ( littleCar.hasOpened )
				"This key opens your car, not the front door. ";
			else
				"This key doesn't fit the front door lock. It must open 
				something else. ";
			
			if ( not self.spareKeyTried )
			{
				"\bAs you move the key away from the lock, you are hit 
				with a strong sense that it is going to be a long and 
				complicated night before you'll be able to unlock and 
				open this door. \b
				
				At the same moment, something causes your spine to 
				shiver. Something is definitely in the air this evening, 
				but you don't know what. ";
				
				self.spareKeyTried := true;
			}
		}
		else if ( io = frontDoorKey ) 
		{
			"You can't use that! ";
		}
		else
			"It doesn't fit the lock. ";
	}
	verDoTake( actor ) = { "You can't take the front door. "; }

	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Have you tried prying it open or busting in? I guess
				you wouldn't want to do that, though.\" ";
				Fred.askedAboutKey := true;
				return( true );
			case Laura:
				"Laura says, \"I'm not sure what to tell you. Don't you have a back
				door or a side door or something?\" She twiddles her hair as she
				thinks. ";
				Laura.askedAboutKey := true;
				return( true );
			case Architect:
				"He says, \"Oh, I'm going to give you a fine front door. Solid and
				strong!\" ";
				return( true );
			case squirrel:
				"The squirrel doesn't know what you're talking about. Or if he does,
				he isn't interested. ";
				return( true);
			default: 
				return( nil );
		}
	}
;

doorLock: fixedBlock
	sdesc = "lock"
	ldesc = "It's a standard door lock of good quality. Without the key,
			you won't be able to open this door. "
	noun = 'lock' 'bolt' 'deadbolt'
	adjective = 'keyhole'
	location = frontOfHouse
	doOpen -> frontDoor
	doUnlockWith -> frontDoor

	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Locked out of your own house, eh? You might ask
				a locksmith about that, I guess.\" He drums his fingers on the
				countertop. \"Yeah, I dunno,\" he says. ";
				Fred.askedAboutKey := true;
				return( true );
			case Laura:
				"Laura says, \"I bet there's somewhere you could go to get a 
				spare key. A locksmith, maybe?\" ";
				Laura.askedAboutKey := true;
				return( true );
			case Architect:
				"He says, \"I'm planning on a good quality deadbolt lock. You
				don't want anyone getting in, after all.\" ";
				return( true );
			case squirrel:
				"The squirrel runs in a tiny circle and wags his tail, but that's
				pretty much what he would have done anyway. ";
				return( true);
			default: 
				return( nil );
		}
	}
;

doormat: staticItem, surface, readable, underHider
	isListed = true
	bulk = 2
	sdesc = "doormat"
	ldesc = 
	{
		"It's a bulky rectangular mat made out of thatched brown fibers. ";
		self.readdesc;
	}
	readdesc = 
	{
		"It reads, \"Welcome.\" ";
		
		if ( frontDoor.triedOnce )
		{
			if ( not self.ironyMessagePrintedOnce )
			{
				"The irony of it leaves a bad taste in your mouth. ";
				self.ironyMessagePrintedOnce := true;
			}
		}
	}
	noun = 'doormat' 'mat'
	plural = 'fibers'
	adjective = 'welcome' 'bulky' 'rectangular' 'thatched' 'thatch' 'brown' 
		'fiber' 
	location = frontOfHouse
	autoTake = true
	
	verDoStandon( actor ) = 
	{
		"You stand on the doormat for a moment or two. ";
	}
	
	verIoPutUnder( actor ) = {}
	ioPutUnder( actor, dobj ) =
	{
		if ( dobj = carKey || dobj = duplicateCarKey )
		{	
			if ( frontDoor.spareKeyTried || littleCar.hasOpened ) 
			{
				"You need to put your spare house key under the doormat, 
				not this one. ";
			}
			else
			{
				"You put <<dobj.thedesc>> under the doormat. A good idea,
				because that's where it was supposed to be in the first 
				place. Something doesn't feel right about it, though. ";
				self.underCont := [ dobj ];
				dobj.moveInto( nil );
				dobj.underLoc := self;
			}
		}
		else if ( dobj = duplicateKey )
		{
				"You put <<dobj.thedesc>> under the doormat. A sudden sense of
				satisfaction comes over you, as if you had taken care of the
				last bit of unfinished business. ";
				
				self.moveInto( nil );
				duplicateKey.moveInto( nil );
				endOfGameDoormat.moveInto( frontOfHouse );
				endOfGameKey.moveInto( frontOfHouse );
				incscore ( 1 );
				global.scoreCard[26] := 1;
		}
		else
		{
			"There is no reason to put that under the doormat. ";
		}
	}
	
	verDoLift( actor ) = { self.verDoLookunder( actor ); }
	doLift( actor ) = { self.doLookunder( actor ); }
	
	verDoMove( actor ) = { self.verDoLookunder( actor ); }
	doMove( actor ) = { self.doLookunder( actor ); }
	
	doLookunder(actor) =
	{
		if ( self.underCont = nil || length( self.underCont ) = 0 )
		{
			"There's nothing under <<self.thedesc>>. It would be a good 
			place to put your spare house key, if only you knew where it was. ";
			
			if ( not self.lookedUnderOnce )
				self.lookedUnderOnce := true;
		}
		else
		{
			if ( self.underCont = nil ) 
				self.underCont := self.searchObj( actor, [] );
			else
				self.underCont := self.searchObj( actor, self.underCont );
		}
	}
	verDoTake( actor ) = 
	{
		"You really ought to leave the doormat where it is. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"It's always good to put out the welcome mat.\" ";
				return( true );
			case Laura:
				"Laura says, \"I like a welcome mat.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;


libraryBook: libraryBookItem
	sdesc = "library book"
	ldesc = "Tonight, like every night, you brought home a book on time-travel 
		 theories. This one talks about the paradoxes involved in changing the 
		 future from the past, or some such. "
	location = Me							// Starts in the player's contents
	noun = 'book'
	adjective = 'library' 'time-travel' 'nice' 'cover' 'gold' 'lettering'

	readdesc =
	{
		self.doConsultAbout( Me, timeTravel );
	}
	
	validTopicList = [ timeTravel paradoxes freeWill past future ]
	doConsultAbout( actor, iobj ) =
	{
		switch( iobj )
		{
			case timeTravel: 
				"There are two main theories about the potential
				for time travel. The first is that time is linear and immutable.
				Even if one were able to travel back and forth, there would be
				no way to alter the course of events. This does not rule out
				free will; rather, it is stipulated that free action is accounted
				for -- the time traveller's comings and goings have, in a sense,
				already taken place. You could not go back in time and prevent
				your own birth, for circumstances would intervene to make this
				action impossible. \b

				The second theory is that the timeline branches when a time
				traveller moves back and forth. A traveller from the future 
				may disrupt the possibility of returning to the same world
				he or she left behind. Some say that time is an infinitely
				branching tree, with each moment containing a universe of
				all probable or possible choices, and the time traveller slips
				around from one to the next, with free will being a crucial
				factor in the consequent events. \b

				A third theory has been recently posited, and is the core of
				this particular book. It delves into the possibility of a
				merger between the two theories (previously determined to be 
				mutually exclusive). This theory is expanded upon under the
				heading of paradoxes. ";
				break;
			case paradoxes: 
				"This book centers on a new kind of paradox. It posits a 
				theory in which the two main theories of time travel (previously
				determined to be mutually exclusive) are merged, allowing both
				for a universe in which time travel cannot change the course
				of events; and yet at the same time depicts a branching time
				stream where a time traveller may redirect events to change
				the future. \b
				
				This new paradox goes something as follows: A time traveller
				from the future travels back to the past. The mere act of 
				traveling backwards disrupts the future course of events from 
				that moment, making it impossible for the traveller to return 
				to his or her own time and find it to be as he or she left it. 
				However, through further manipulation of objects and events, 
				the time traveller will be able to alter the time stream such 
				that the future he or she left will be restored. \b

				Once the future is restored, the time traveller will have 
				discovered that all of these events -- including the
				initial time trip which disrupted the time stream -- needed to
				happen, or else the time traveller would never have existed in
				the world he or she initially came from, and thus would not have
				been able to make the trip in the first place. The existence
				of the future he or she came from was contingent on the very 
				disruption and manipulation of the time stream that nearly 
				caused their future never to have existed at all! ";
				break;
			case freeWill:
				"Depending on which theory one subscribes to (either of the
				two main theories, or the third), free will is either 
				absolutely necessary or absolutely forbidden. ";
				break;
			case past:
				"Depending on which theory one subscribes to (either of the
				two main theories, or the third), the past is either 
				absolutely immutable, absolutely open to manipulation,
				or open to manipulation only to the extent that it restores
				a predicated timeline. ";
				break;
			case future:
				"Depending on which theory one subscribes to (either of the
				two main theories, or the third), the future is either 
				absolutely immutable, absolutely open to manipulation, or
				open to manipulation from the past only to the extent that
				it restores a predicated future state. ";
				break;
			default:
				"\^<<self.thedesc>> contains no information about that subject. ";
				break;
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Time travel, eh? I used to watch a lot of Doctor
				Who. I'm not really into science fiction stuff any more, though.\" ";
				return( true );
			case Laura:
				"Laura looks at you with a mixture of fascination and 
				cluelessness. \"Time travel, huh! Wow.\" She fiddles with her
				hair. \"Do you think that's possible? I guess maybe someday
				they could figure that out. It's over my head, though!\" ";
				Laura.askedAboutKey := true;
				return( true );
			case Architect:
				"He barely looks up. \"Sorry, what? Time travel? That's a bit
				beyond me. I like to deal with the real world.\" ";
				return( true );
			case squirrel:
				"The squirrel stares at you sagely, and then scratches his
				belly. ";
				return( true);
			default: 
				return( nil );
		}
	}
;

/*  These stones are an underHider, which means they conceal something that
* 	the player can find underneath. In this case, a car key.
*/
stones: underHider, staticItem
	sdesc = "landscaping stones"
	ldesc = "Just a couple of cold grey stones sitting in the soft dirt. "
	noun = 'stone' 'rock' 'dirt'
	plural = 'stones' 'rocks'
	isThem = true
	adjective = 'grey' 'soft' 'rock' 'landscaping' 'attempt' 'gray'
	location = frontOfHouse
	autoTake = nil
	
	doLookunder( actor ) =
	{
		if ( self.underCont = nil )
			"There's nothing else under <<self.thedesc>>. ";
		else
		{
			self.underCont := self.searchObj( actor, self.underCont );
			if ( self.autoTake = nil )
			{
				carKey.moveInto( actor );
				if ( not carKey.hasScored )	   	// have we scored yet?
				{
					incscore( carKey.takevalue ); 	// add our "takevalue" to the score
					carKey.hasScored := true;	 	// note that we have scored
					global.scoreCard[27] += carKey.takevalue;
				}
			}
		}
	}
	
	verIoPutUnder( actor ) = {}
	ioPutUnder( actor, dobj ) =
	{
		if ( dobj = carKey || dobj = duplicateCarKey )
		{
			"You put <<dobj.thedesc>> ";
			
			if ( dobj = carKey )
				"back";
			
			" under the stones. A good idea, because you'll always know 
			where to find it. ";
			
			if ( self.underCont )
				self.underCont += dobj;
			else
				self.underCont := [ dobj ];
			
			dobj.moveInto( nil );
			dobj.underLoc := self;
			self.autoTake := true;
		}
		else if ( dobj = duplicateKey )
			"You ought to put that under the doormat, not under the 
			landsaping stones. ";
		else
			"There is no reason to put that under <<self.thedesc>>. ";
	}
	
	verDoLift( actor ) = { self.verDoLookunder( actor ); }
	doLift( actor ) = { self.doLookunder( actor ); }
	
	verDoMove( actor ) = { self.verDoLookunder( actor ); }
	doMove( actor ) = { self.doLookunder( actor ); }
	
	verDoTake( actor ) = { "They're too heavy to carry. "; }
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"";
				if ( Fred.askedAboutKey = true )
				{
					if ( carKey.location )
						"I'd tell you to look under them for a spare key, 
						but maybe you thought of that already.\" ";
					else
						"Tell you what. Maybe you hid a spare key under 
						there. Seems kind of obvious.\" ";
				}
				else
					"Fred says, \"The only rocks I know about are the rocks in my
					head.\" He chuckles to himself. ";
				return( true );
			case Laura:
				if ( Laura.askedAboutKey = true )
				{
					if ( carKey.location )
						"So you found a spare key? Oh, but it wasn't for the door.
						Darn.\" ";
					else
						"You know what? That's where I'd hide a spare key if it
						were my house. Under the stones by the front door. I guess
						maybe that's not a great idea, because burglars know to
						look there, but it's an obvious place to look.\" ";
				}
				else
					"Laura says, \"Landscaping stones? Oh, I thought you were asking
					about the Rolling Stones.\" ";
				return( true );
			case Architect:
				"He says, \"I think some landscaping stones would work well. We
				pulled up a number of good pieces when we dug the foundation.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;


/*  This is the key to your car, which is useful in its own way, but frustrating for
 *  being an immediate red herring. Once you actually unlock the car (see the 
 *	littleCar code) the sdesc for this key changes to say "car key. "
*/
carKey: keyItem, treasure, hiddenItem
	isCarKey = true
	sdesc = "<<littleCar.hasOpened ? "car key" : "spare key">>"		// change once you find out
													// what this key does
	ldesc = 
	{
		"This is a <<littleCar.hasOpened ? "spare car" : "spare">> key that 
		you left yourself in case of emergency. ";
	}
	noun = 'key'
	adjective = 'car' 'spare'
	underLoc = stones
	takevalue = 3
	bulk = 0
	
	doTurn( actor ) = 
	{
		if ( self.isIn( littleCar ) )
		{
			if ( self.location != ignition )
			{
				"(putting <<self.thedesc>> in the ignition) \b";
				self.moveInto( ignition );
			}
			ignition.doStartWith( actor, self );
		}
		else 
			"You don't have the car key. The car doesn't run any more
			and there's nowhere you want to drive to, anyway. ";
	}
	
	ioStartWith( actor, dobj ) = 
	{
		if ( dobj = littleCar || dobj = ignition )
			dobj.doStartWith( actor, self );
		else
			"I don't know how to start that with <<self.thedesc>>. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				if ( not self.hasScored ) // haven't found it yet
					"Fred says, \"Locked out, eh? Me, I always hide a spare
					key outside my place, just in case of emergencies.\" ";
				else if ( littleCar.hasOpened ) 
					"Fred says, \"Car key, eh? I wish I could afford a car.\" ";
				else
					"Fred says, \"Spare key, eh? Good for you.\" ";
				return( true );
			case Laura:
				if ( not self.hasScored ) 
					"Laura says, \"Oh dear. Hard for me to know how to
					help you find a key since I don't know you!\" She 
					taps her desk idly. \"You know what some people do?
					They hide a spare key near their front door in case
					of emergencies. You might look around there.\" ";
				if ( littleCar.hasOpened ) 
					"Laura says, \"I guess it's good to keep a spare car 
					key around also.\" ";
				else 
					"Laura says, \"One moment, please,\" and answers the phone. 
					After a short conversation, she says to you, \"Is that a 
					spare key? I guess you don't need me to help you think of
					places to look for one, then!\" ";
				return( true );
			default:
				return( nil );
		}
	}
;

driveway: room
	sdesc = "Driveway"
	ldesc = "This is your front driveway, which leads west to the north side of your 
			house. "
	xdesc = "A small path leads southwest to the front door. To the east is 
			the road into town. "
	sw = frontOfHouse
	east = sidewalk
	ne = sidewalk
	west = northOfHouse
	in = "You'll have to specify the car if that's what you mean. "
;

drivewayDummy: fixedBlock, readable, floatingItem
	sdesc = "driveway"
	ldesc =
	{
		if ( wetDriveway.writtenOn )
			"\^<<wetDriveway.writtenOnDesc>> is written into <<self.thedesc>>	cement. ";
		else if ( wetDriveway.drawnOn )
			"\^<<wetDriveway.drawnOnDesc>> is drawn into <<self.thedesc>> cement. ";
		else pass ldesc;
	}
	noun = 'driveway' 'cement' 'concrete' 'paving' 'paved'
	location = 
	{
		switch( Me.location )
		{
			case driveway:
			case frontOfHouse:
			case northOfHouse:
			case inGarage:
				return( Me.location );
			default:
				return( nil );
		}
	}
;

townDummy: distantItem
	sdesc = "town"
	noun = 'town'
	location = driveway
;

pathDriveway: fixedBlock
	sdesc = "path"
	noun = 'path'
	location = driveway
;

roadDriveway: fixedBlock
	sdesc = "road"
	noun = 'road'
	location = driveway
;

littleCar: vehicle, doubleKeyedLockable
	isfixed = nil
	sdesc = "little car"
	xdesc = ""
	noun = 'car' 'Mazda' 'door'
	adjective = 'little' 'interior' 'baby' 'blue' 'baby-blue'
	location = driveway
	mykey1 = carKey
	mykey2 = duplicateCarKey
	islockable = true
	islocked = true
	isopen = nil
	hasOpened = nil
	firstTime = true
	autoTake = nil
	isdroploc = true
	indoors = true
	reachable = ( [ carHood carTrunk ] + self )
	out = { self.doUnboard( Me ); return nil; }
	noexit = { self.doUnboard( Me ); return nil; }
	
	ldesc = 
	{
		if ( Me.location = self )
		{
			"The interior of the car has gotten a little dusty with disuse, but the seats 
			are still comfy. The only obvious things to see are the glove compartment, 
			an armrest compartment, and the steering wheel. ";
		}
		else
		{
			"It's your baby-blue Mazda. You decided some time ago that you would take 
			a personal step to helping the environment by walking everywhere, and you 
			haven't driven it since. ";
		}
		"\^<<self.thedesc>> is <<self.isopen ? "open" : "closed">>. ";
	}
	
	lookAround( verbosity ) =
	{
		self.dispBeginSdesc;
		self.statusRoot;
		self.dispEndSdesc;
		" (<<self.statusPrep>> <<self.thedesc>>)";
		
		self.nrmLkAround( verbosity );
	}
	contentsReachable = { return( Me.location = self ); }
	contentsVisible = { return( Me.location = self ); }
	
	verDoStartWith( actor, io ) = {}
	doStartWith -> ignition
	
	verDoTurnon( actor ) = 
	{
		"The car hasn't worked in years, and there's nowhere
		you need to drive to, anyway. ";
	}
	
	verDoTake( actor ) =
	{
		"%You% can't take the car. ";
	}
	
	verDoBuy( actor ) = { "You already own it. "; }
	
	doBoard( actor ) =
	{
		if ( self.islocked )
			"You'll have to open the car first. ";
		else
		{
			if ( not self.isopen )
			{
				"(opening <<self.thedesc>>)\n ";
				self.isopen := true;
			}
			"Okay, %you're% now in <<self.thedesc>>. \n";
			actor.travelTo( self );
			
			if ( not self.alreadyBoarded )
			{
				local l, i;
				l := self.contents;
				for ( i := 1; i <= length(l); ++i )
				{
					l[i].isSeen := true;
				}
				self.alreadyBoarded := true;
			}
		}
	}
	
	doUnboard( actor ) =
	{
		if ( seatbelts.isFastened )
		{
			"You'll have to unfasten the seatbelt first. ";
			setit( seatbelts );
		}
		else if ( self.islocked )
		{
			"You'll have to unlock the car first. ";
		}
		else
		{
			if ( not self.isopen )
			{
				"(opening <<self.thedesc>>)\n ";
				self.isopen := true;
			}
			
			"Okay, %you're% no longer <<self.statusPrep>> <<self.thedesc>>. \n";
			
			self.leaveRoom( actor );
			actor.travelTo( self.location );
		}
	}
	
	doLock( actor ) =
	{
		if ( Me.location = self )
		{
			"Locked. ";
			self.islocked := true;
		}
		else askio( withPrep );
	}
	
	doOpen( actor ) =
	{
		if ( Me.location = self && !self.isopen )
		{
			if ( self.islocked ) 
			{
				"Unlocked. ";
				self.islocked := nil;
			}
			"Opened. ";
			self.isopen := true;
		}
		else 
			pass doOpen;
	}
	
	doUnlock( actor ) =
	{
		if ( Me.location = self )
		{
			"Unlocked. ";
			self.islocked := nil;
		}
		else askio( withPrep );
	}
	
	doUnlockWith( actor, io ) =			// You get an extra message the first time
	{									// you use the key.
		if ( Me.location = self )
		{
			"You can just unlock it from inside. Unlocked. ";
			self.islocked := nil;
		}
		else if ( self.mykey( io ) )
		{
			if ( not self.hasOpened )
			{
				"Unlocked. So that's what this key is for. ";
				self.hasOpened := true;			// Using the key changes its sdesc
			}
			else
			{
				"Unlocked. ";
			}
			self.islocked := nil;
		}
		else "It doesn't fit the lock. ";
	}
	verDoOpenWith( actor, io ) = {}
	
	verDoSearch( actor ) = 
	{
		if ( Me.location != self )
			"You'll have to get in the car first. ";
	}
/*
	doSearch( actor ) =
	{
		if ( Me.location = self )
		{
			if ( self.searchCont = nil )
				"There's nothing else in <<self.thedesc>>. ";
			else
			{
				incscore( 5 );					// Five points for finding the armrest
				global.scoreCard[1] := 1;
				armrestFound := true;
				armrest.isSeen := true;
				self.searchCont := self.searchObj( actor, self.searchCont );
			}
		}
		else
	}
*/
	
	verDoLookin( actor ) =
	{
		if ( Me.location = driveway )
			"Why not climb in and look around? ";
	}
	
	verDoDrive( actor ) = {}
	doDrive( actor ) = 
	{
		"The little car doesn't run any more. Besides, there's nowhere you
		need to drive to. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"You have a car you don't even drive? Man. If I 
				had enough money, I'd buy me a Jaguar. Vrrrrrm! Vrrrm!\" He
				chuckles to himself. With a twinkle in his eye, he says, \"Ah,
				maybe, someday.\" ";
				return( true );
			case Laura:
				"Laura says, \"Hey! I've got a Mazda, too! They're good little
				cars.\" ";
				return( true );
			case Architect:
				"He says, \"I'm sorry, I'm a little too busy to talk about 
				cars right now.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

seatbelts: fixedBlock
	sdesc = "seatbelts"
	noun = 'belt'
	plural = 'belts'
	isThem = true
	adjective = 'seat' 'safety'
	location = littleCar
	
	verDoWear( actor ) = { self.verDoFasten( actor ); }
	doWear( actor ) = { self.doFasten( actor ); }
	
	verDoUnwear( actor ) = { self.verDoUnfasten( actor ); }
	doUnwear( actor ) = { self.doUnfasten( actor ); }
	
	verDoFasten( actor ) = 
	{
		if ( self.isFastened )
			"You're already wearing your seat belt. ";
	}
	doFasten( actor ) =
	{
		"Fastened. ";
		self.isFastened := true;
	}
	
	verDoUnfasten( actor ) = 
	{
		if ( not self.isFastened )
			"You're not wearing the seat belt. ";
	}
	doUnfasten( actor ) =
	{
		"Unfastened. ";
		self.isFastened := nil;
	}
;

carHood: openable, fixedBlock
	sdesc = "hood"
	noun = 'hood'
	maxbulk = 0
	isopen = nil
	location = driveway
	
	verDoOpen( actor ) =
	{
		if ( Me.location = driveway )
			"You'll have to get into the little car to do that. ";
	}
	
	verDoClose( actor ) =
	{
		if ( Me.location = littleCar )
			"You'll have to get out of the little car to do that. ";
	}
	
	verDoLookunder( actor ) = { self.verDoLookin( actor ); }
	doLookunder( actor ) = { self.doLookin( actor ); }
	
	verDoTake( actor ) = { "You can't take the hood. "; }
;

carEngine: item
	sdesc = "engine"
	adesc = "an engine"
	noun = 'engine'
	location = carHood
	verDoTake( actor ) = { "You can't take that from the car. "; }
;

engineBits: unimportantItem
	sdesc = "engine parts"
	noun = 'transmission'
	adjective = 'carburetor' 'radiator' 'fluids' 'fluid' 'spark'
			'plugs' 'plug' 'gasket' 'horn' 'piston' 'pistons'
			'fuel' 'injector' 'injectors' 'injection' 'fuse' 'fuses'
	location = carHood
;

carBattery: fixedBlock
	sdesc = "battery"
	ldesc = "The battery is dried up and dead. "
	isListed = nil
	noun = 'battery'
	location = carHood
;

carOil: fixedBlock
	sdesc = "oil"
	adesc = "oil"
	ldesc = "There is no oil in the car. "
	isListed = nil
	noun = 'oil'
	location = carHood
	verDoTake( actor ) = { self.ldesc; }
;

dipstick: fixedBlock
	sdesc = "dipstick"
	isListed = nil
	noun = 'dipstick'
	adjective = 'dip' 'stick'
	location = carHood
	
	verDoPull( actor ) = {}
	doPull( actor ) = { carOil.ldesc; }
	
	verDoTake( actor ) = { "There's no reason to take that with you. "; }
;

carTrunk: doubleKeyedLockable, fixedBlock
	sdesc = "trunk"
	noun = 'trunk' 'trnk' 
	adjective = 'boot'
	maxbulk = 100
	location = driveway
	mykey1 = carKey
	mykey2= duplicateCarKey
	isopen = nil
	islocked = true
	isListed = nil
	
	doUnlock( actor ) =
	{
		if ( Me.location = littleCar )
			"You'll have to get out of the little car to do that. ";
		else pass doUnlock;
	}
	verDoLock( actor ) = 
	{
		"It automatically locks when it is closed. ";
	}
	
	verDoLockWith( actor, io ) = {}
	doLockWith( actor, io ) =
	{
		if ( self.isopen )
		{
			self.doClose( actor ) ;
		}
		else
		{
			"It automatically locks when it is closed. ";
		}
	}
	verDoUnlockWith( actor, io ) =
	{
		if ( self.isopen )
			"\^<<self.itisdesc>> is already open. ";
	}
	doUnlockWith( actor, io ) =
	{
		if ( self.mykey( io ) )
		{
			"Unlocked. The trunk pops open. ";
			self.isopen := true;
		}
		else
			"\^<<io.itnomdesc>> <<io.doesdesc>>n't fit the lock. ";
	}
	
	verDoClose( actor ) =
	{
		if ( Me.location = littleCar )
			"You'll have to get out of the little car to do that. ";
	}
	doClose( actor ) =
	{
		"You shut the trunk. It locks automatically. ";
		self.isopen := nil;
	}
;

spareTire: unimportantItem
	isListed = true
	isfixed = nil
	sdesc = "spare tire"
	noun = 'tire' 'tyre'
	adjective = 'spare'
	location = carTrunk
;

carJack: unimportantItem
	isListed = true
	isfixed = nil
	sdesc = "jack"
	adjective = 'jack'
	location = carTrunk
;

exteriorCarPart: unimportantItem
	sdesc = "car"
	noun = 'part'
	adjective = 'tire' 'tyre' 'gas' 'tank' 'headlight' 'taillight' 'head' 'tail'
			'tailight' 'tail-light' 'brake' 'braking' 'reverse' 'hi-beam'
			'beam' 'bumper' 'windshield' 'window' 'passenger'  
			'handle' 'wiper' 'paint' 'license' 'plate'
	location = driveway
;	

exteriorCarParts: unimportantItem
	sdesc = "car"
	noun = 'parts'
	isThem = true
	adjective = 'tires' 'tyres' 'wipers' 'plates' 'headlights' 'taillights'
			'tailights' 'tail-lights' 'hi-beams' 'beams' 'lights' 'bumpers'
	location = driveway
;

exteriorCarWindows: seeThruItem, fixedBlock
	sdesc = "windows"
	noun = 'windows'
	isThem = true
	thrudesc = "You see the interior of the car. "
	location = driveway
;

interiorCarWindows: seeThruItem, fixedBlock
	sdesc = "windows"
	noun = 'windows'
	isThem = true
	adjective = 'windshield'
	thrudesc = "You see the driveway. "
	location = littleCar
;

interiorCarParts: unimportantItem
	sdesc = "interior"
	noun = 'parts'
	adjective = 'brakes' 'brake' 'gear' 'shift' 'stick' 'parking' 'emergency'
			'speedometer' 'fuel' 'gauge' 'oil' 'cigarette' 'lighter' 'socket'
			'accelerator' 'gas' 'pedal' 'pedals' 'carpet' 'mat' 'rearview'
			'rear-view' 'rear' 'view' 'mirror' 'sunshade' 'shade' 'sunshades'
			'sun' 'shades' 'battery' 'power'
	location = driveway
;

carRadio: unimportantItem
	sdesc = "radio"
	ldesc = "The radio is a cheap old thing that never worked even when 
			the car did. "
	noun = 'radio'
	adjective = 'cheap' 'old'
	location = littleCar
;

steeringwheel: fixedBlock
	sdesc = "steering wheel"
	noun = 'wheel'
	adjective = 'steering'
	location = littleCar

	verDoTurn( actor ) = {}
	doTurn( actor ) = { "It's fixed in place. "; }
	
	doDrive( actor ) = { "It's fixed in place. "; }
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Every car comes with one.\" ";
				return( true );
			case Laura:
				"Laura says, \"I don't think anyone's ever asked me for my
				opinion about steering wheels before!\" She laughs politely,
				hoping to change the subject. ";
				return( true );
			case Architect:
				"He says, \"I'm sorry, but I don't have anything to say
				on the subject of steering wheels. I'm an architect, not
				an automobile engineer.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

ignition: fixeditem, container
	sdesc = "ignition"
	noun = 'ignition' 'starter'
	location = littleCar
	maxbulk = 0
	
	verIoTurnIn( actor ) = {}
	ioTurnIn( actor, dobj ) = 
	{
		if ( dobj = carKey )
			self.doStartWith( actor, dobj );
		else
			"Turning <<dobj.thedesc>> has no effect. ";
	}
	
	verDoStartWith( actor, io ) = {}
	doStartWith( actor, io ) = 
	{
		if ( self.contents = io )
		{
			"You turn the key, but nothing happens. The battery is
			long dead, and there's probably no gas in the car, either. ";
		}
		else if ( carKey.isIn( Me ) || carKey.isIn( littleCar ) )
		{
			"You put the key into the ignition and give it a turn, but
			nothing happens. The battery is long dead, and there's 
			probably no gas in the car, either. ";
		}
		
		"There's nowhere you want to drive to, anyway. ";
	}
	
	doTurnon -> littleCar
;

seats: staticItem
	sdesc = "seats"
	ldesc = "The seats are worn but comfy. "
	noun = 'seat' 
	plural = 'seats'
	isThem = true
	adjective = 'driver\'s' 'passenger\'s'
	location = littleCar
	doSearch -> littleCar
	
	verDoSiton( actor ) =
	{
		"You are already sitting in the car seat. ";
	}
	doBoard -> littleCar
	doUnboard -> littleCar
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Car seats. Yeah. Um.\" ";
				return( true );
			case Laura:
				"Laura says, \"What I don't like are leather seats. They get all
				old and cracked and stinky.\" ";
				return( true );
			case Architect:
				"He says, \"Please! So much to do!\" and struggles to remember 
				what he was working on. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

dashboard: fixedBlock
	sdesc = "dashboard"
	ldesc = "The dashboard is covered by a layer of dust. "
	noun = 'dust'
	adjective = 'dash' 'dashboard'
	location = littleCar
	verDoBlow( actor ) = {}
	doBlow( actor ) = { self.doBlowOn( actor ); }
	verDoBlowOn( actor ) = {}
	doBlowOn( actor ) =
	{
		"You blow on the layer of dust. A bit of it swirls in the air, then
		settles. ";
	}
;

armrest: staticItem, openable
	sdesc = "armrest compartment"
	ldesc = 
	{
		"The armrest compartment is in between the two front seats, and 
		is big enough to hold a couple of soda cans and a bunch of maps. ";
		pass ldesc;
	}
	adesc =
	{
		"an "; self.sdesc;   // default is "a <name>"; "self" is current object
	}
	isopen = nil
	noun = 'compartment'
	adjective = 'armrest'
	location = littleCar
	maxbulk = 3
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I don't know what kind of garage doors you
				have, but people with automatic ones usually keep an opener
				in their car somewhere. So I'd search around just to see.\" ";
				return( true );
			case Laura:
				"Laura says, \"I keep my spare change in an armrest 
				compartment in my car.\" ";
				return( true );
			case Architect:
				"He says, \"Armrest compartments? Are you talking about furniture?
				I don't understand. Anyway, it's not something I know about.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

carHorn: fixedBlock
	sdesc = "horn"
	noun = 'horn'
	location = littleCar
	verDoPush( actor ) = {}
	doPush( actor ) = { self.verDoHonk( actor ); }
	verDoHonk( actor ) = {}
	doHonk( actor ) = 
	{
		"You honk the horn. \"BEEP! BEEP!\" ";
	}
;

gloveCompartment: staticItem, keyedLockable
	isopen = nil
	islocked = true
	sdesc = "glove compartment"
	ldesc =
	{
		if ( self.isopen )
			isListed := true;
		else
			isListed := nil;
		pass ldesc;
	}
	noun = 'compartment'
	adjective = 'glove' 'box' 'glovebox'
	location = littleCar
	mykey = carKey
	maxbulk = 2
	doOpen( actor ) =
	{
		if ( not garageOpener.isSeen )
		{
			incscore( 5 );					// Five points for finding the armrest
			global.scoreCard[1] := 1;
			garageOpener.isSeen := true;
			setit( garageOpener );
		}
		pass doOpen;
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I bet there's something good about having a
				glove compartment. Someplace you can just keep stuff. Yeah.\" ";
				return( true );
			case Laura:
				"Laura says, \"That reminds me. I need to clean out my glove
				compartment. I always try to keep too many things in there, 
				and then I forget what they are!\" ";
				return( true );
			case Architect:
				"He says, \"Um. Sure.\" He then goes back to work. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

touristMap: readable
	sdesc = "tourist map"
	ldesc = "It's a tourist map of Paris. Must be left over from some other adventure. "
	noun = 'map'
	adjective = 'tourist' 'paris'
	location = armrest
	herring = true

	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Ah, Paris! Man, I wonder if I'll ever go there.
				Heck, I'm not sure I'll ever get out of this town. Or this 
				job.\" He sighs. ";
				return( true );
			case Laura:
				"Laura says, \"Ooh, Paris! I went to France when I was in college.
				It was a total blast! I'm saving up to go to Europe right now,
				in fact. Gotta love it.\" ";
				return( true );
			case Architect:
				"He suddenly breaks his pencil point and shouts, \"Curses!\" 
				As he sharpens it again, he says, \"Oh, those tourist maps
				are never any help. If you really want to see Paris you just
				have to get lost wandering around.\" ";
				return( true );
			case squirrel:
				"The squirrel emits a funny French sound. No, wait, it was
				just your imagination. ";
				return( true);
			default: 
				return( nil );
		}
	}
;

pencil: pencilItem
	sdesc = "school pencil"
	ldesc = 
	{
		"It's a standard school pencil. It's got some teeth marks, the lead
		is blunt, and the eraser has worn off. ";
	}
	noun = 'pencil'
	adjective = 'lead' 'graphite' 'school' 'standard'
	location = gloveCompartment
	chewedOn = true
	herring = true

	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Yep. That's a pencil, all right.\" ";
				return( true );
			case Laura:
				"Laura says, \"No thank you, I have one.\" ";
				return( true );
			case Architect:
				"He says, \"I'm sorry, but I only use blue pencils when I'm
				working on my blueprints.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

/*	The button on the garageOpener is a separate item attached to it. */
garageOpener: item
	sdesc = "garage door opener"
	ldesc = "There's one big button on it. "
	noun = 'opener'
	adjective = 'garage' 'door'
	location = gloveCompartment
	
	doPush -> openerButton
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Seems to me that if you push the button, the 
				garage door will open. But hey! I'm not a rocket scientist or
				anything!\" He chuckles. ";
				return( true );
			case Laura:
				"Laura says, \"Yeah. Automatic garage door openers. They're
				kind of fun, even if you've had them a long time.\" ";
				return( true );
			case Architect:
				"He says, \"Absolutely, the garage doors will be automatic.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

openerButton: garageOpenerItem
	location = garageOpener
;

northOfHouse: room
	sdesc = "North of house"
	ldesc = 
	{
		"The north side of your house is dominated by your garage door. ";
		
		if ( garageDoor1.isopen )
			"The garage door is open. ";
		else
			"The garage door is closed. ";

		if ( not self.wallClimbed )
			"A scaled stone wall runs up the side of the house. ";
	}
	xdesc = 
	{
		if ( self.wallClimbed )
			"A scaled stone wall runs up the side of the house. ";
		
		"The driveway extends east, and a small path leads southeast to the 
		front of the house and southwest to the back. ";
	}
	wallClimbed = nil
	
	in = garageDoor1
	south = garageDoor1
	east = driveway
	sw = behindHouse
	se = frontOfHouse
	up = 
	{
		"You climb gingerly up the stone wall. \n";
		return( northRoof );
	}
;

NHouseSmallPath: fixedBlock
	sdesc = "small path"
	noun = 'path'
	adjective = 'small'
	location = northOfHouse
;

stoneWall1: fixedBlock
	sdesc = "stone wall"
	ldesc = "The wall tapers in a stairstep fashion as it climbs up to and 
		beyond the edge of the roof. "
	noun = 'wall'
	adjective = 'stone'
	location = northOfHouse
	verDoClimb( actor ) = {}
	doClimb( actor ) = 
	{
		Me.travelTo( self.location.up );
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred scratches his head. \"Not sure what you expect me to say
				about stone walls. They go up. Or they go sideways.\" ";
				return( true );
			case Laura:
				"Laura says, \"When I was a little girl, we used to have this
				stone wall that ran up alongside our house. My sister and I used
				to climb up it to get on the roof! Until our Mom found out, that
				is.\" ";
				return( true );
			case Architect:
				"He says, \"Yes, on the north side of the house there will be
				a study stone wall. Mostly decorative, of course, but it will 
				match with the sides of the chimney.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

garageDoor1: garageDoorItem
	isfixed = nil
	doordest = inGarage
	otherside = garageDoor2
	sdesc = "garage door"
	noun = 'door'
	adjective = 'garage'
	noAutoOpen = true
	location = northOfHouse
	
	verDoUnlock( actor ) = 
	{
		"The locking mechanism is on the inside. ";
	}
	verDoLock( actor ) = 
	{
		"The locking mechanism is on the inside. ";
	}
	verDoOpen( actor ) =
	{
		if ( self.isopen )
			"\^<<self.itisdesc>> already open. ";
		else if ( self.islocked )
			"It seems to be locked from the inside. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Garage doors? All I know is that you open them
				with an automatic opener or you haul them open by hand.\" ";
				return( true );
			case Laura:
				"Laura says, \"My garage doors are automatic. I just push the
				opener button from my car when I drive up. That's the only
				place I can think of that you'd keep a garage door opener.\" ";
				return( true );
			case Architect:
				"He says, \"Yes, yes. Automatic garage doors come with remote
				openers. Of course.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

northRoof: room
	sdesc = "North roof"
	ldesc = 
	{
		if ( global.newRoof = nil )
		{
			"This is the north end of the roof. Shingle tiles, already looking the worse 
			for wear, make for slippery traction. ";
		}
		else
		{
			"This is the north end of the roof. Beautiful, brown metal shingle tiles,
			the ultimate in roof shingling -- durable, weatherproof, and fancy! -- are 
			laid out in row after glistening row. Someone obviously took the time and 
			care to do this roof job right. ";
		}
		
		"A gutter trap, clogged with leaves, runs along the length of the west side 
		of the house. ";
	}
	xdesc = 
	{
		"The roof itself continues south. The stone wall, which turns out to 
		be the outside of your chimney, leads back down. ";
	}
	
	south = southRoof
	down = 
	{
		"You climb gingerly down the stone wall. \n";
		return( northOfHouse );
	}
	noexit = "You will fall off the roof if you go in that direction. "
	
	firstseen =
	{
		northOfHouse.wallClimbed := true;			// Yes, we've found this out
		incscore ( 4 );
		global.scoreCard[2] := 1;
	}
;

stoneWall2: fixedBlock
	sdesc = "stone wall"
	noun = 'wall'
	adjective = 'stone'
	location = northRoof

	verDoClimb( actor ) = 
	{
		"You can't climb the stone wall any higher. ";
	}
	
	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) = 
	{
		Me.travelTo( self.location.down );
	}
;

chimney: block
	sdesc = "chimney"
	noun = 'chimney'
	location = northRoof
	
	verDoEnter( actor ) = 
	{
		"The chimney isn't a way into the house, if that's what you mean. You can 
		climb down the stone wall to get back to the ground. ";
	}
	doSynonym( 'Enter' ) = 'Board'
	
	verDoClimbDown( actor ) = 
	{
		"The chimney isn't a way into the house, if that's what you mean. You can 
		climb down the stone wall to get back to the ground. ";
	}
	
	verIoPutIn( actor ) = { "The chimney isn't a good place to put things. "; }
	
	doClimb -> stoneWall2
;

shingles1: block
	sdesc = "shingles"
	ldesc = 
	{
		if ( global.newRoof = nil )
			"The shingles are in bad shape. What cheapskate ordered these?";
		else
			"The ultimate in roof shingling -- durable, weatherproof, and fancy! ";
	}
	noun = 'shingle' 'single' 'tile' 'roof'
	isThem = true
	plural = 'shingles' 'singles' 'tiles'
	location = northRoof
	
	verDoLeapTo( actor ) = 
	{
		"You are too high up to risk doing that. You'll break your ankle if
		you jump off the roof. ";
	}
	
	verDoLetGo( actor ) =
	{
		"Falling off the roof is an inherently dangerous idea. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Gee, it's a shame to have a nice house and then
				keep a cruddy roof on top of it.\" ";
				return( true );
			case Laura:
				"Laura says, \"Be careful. Old shingle roofs like that can be
				a fire hazard. They can leak, too. If I were you I'd get a 
				better roof put on that house as early as possible.\" ";
				return( true );
			case Architect:
				if ( global.newRoof = nil )
					"He says, \"Bad shingles? You'll have to show me what you 
					mean.\" ";
				else
					"He says, \"Oh, don't worry. I'll make sure to putin the
					request for much higher quality shingles. The roofing
					will be quite superb.\" ";
				return( true );
			case squirrel:
				"The squirrel gnaws on one of the rotten shingles, makes a 
				face, and spits out the splinters.\" ";
				return( true);
			default: 
				return( nil );
		}
	}
;

gutter1: qcontainer, staticItem
	sdesc = "gutter"
	ldesc = "It's clogged full of leaves. "
	noun = 'gutter' 'trap'
	location = northRoof
	
	doSearch -> leaves1
	doLookin -> leaves1
	verDoClean( actor ) = 
	{
		"You pull some leaves out of the gutter and toss them aside.
		The gutter looks a little cleaner now, but not by much. ";
	}
;

leaves1: fixeditem, searchHider
	sdesc = "leaves"
	adesc = "some leaves"
	ldesc = 
	{
		if ( tennisBall.location = nil )
		{
			"It looks like there's something in the leaves. ";
		}
		else
			"I see nothing special about the leaves. ";
	}
	
	noun = 'leaf'
	plural = 'leaves'
	isThem = true
	location = gutter1
	bulk = 10
	
	verDoLookin( actor ) = { self.verDoSearch( actor ); }
	doLookin( actor ) = { self.doSearch( actor ); }
	
	verDoClean( actor ) = { self.verDoTake( actor ); }
	verDoTake( actor ) = 
	{
		"You pull a few stray leaves from the gutter and toss them aside. ";
	}
;

tennisBall: throwable, hiddenItem
	sdesc = "old tennis ball"
	ldesc = 
	{
		"It's faded to a pale whitish green over the years, and it's sticky with 
		mud and rotten leaves. You must have lost it during an exuberant game of 
		catch some years ago. ";
		
		if ( self.slobbery )
			" It's currently a bit slobbery. ";
	}
	adesc = { "an "; sdesc; }
	noun = 'ball'
	adjective = 'old' 'tennis'
	searchLoc = leaves1
	slobbery = nil
	hasBlackiesInterest = nil
	
	doDrop( actor ) =
	{
		local foo;
		
		switch( Me.location )
		{
			case insideShed: 
				if ( Blackie.location = insideShed )
				{
					if ( rand( 2 ) = 1 )
						"You drop <<self.thedesc>>. \^<<Blackie.thedesc>> eyes it
						with interest. He sniffs at it, then puts his big slobbery
						jaw all over it. He gnaws at it for a moment, then pushes
						it back to you. As you pick the saliva-coated <<self.sdesc>> up, <<
						Blackie.thedesc>> wags his tail aggressively, his eyes 
						locked on <<self.itobjdesc>>. ";
					else
						"\^<<Blackie.thedesc>> chews at <<self.thedesc>> happily for
						a few moments, then nudges the slobbery thing back to you. ";
								
					self.getSlobbery;
					self.hasBlackiesInterest := true;
				}
				return;
			case northRoof:
				"You drop the tennis ball, and it rolls off the roof ";
				foo := _rand( 2 );
				switch( foo )
				{
					case 1:
						"into the front of the house, where it bounces
						to a stop. ";
						self.moveInto( frontOfHouse );
						return( nil );
					case 2:
						"into the back yard, where it bounces to a
						stop. ";
						self.moveInto( behindHouse );
						return( nil );
				}
			case southRoof:
				"You drop the tennis ball, and it rolls ";
				foo := _rand( 2 );
				switch( foo )
				{
					case 1:
						"off into the south of the house, where it hits
						the sloping ground and rolls into the woods. ";
						self.moveInto( woods );
						return( nil );
					case 2:
						"into into the gutter and vanishes down the
						drainpipe. ";
						
						if ( drainpipe.cleaned )
						{
							"A few seconds later, you see it roll
							out of the spout into the back yard. ";
							self.moveInto( behindHouse );
						}
						else
							self.moveInto( stuckLimbo );
						
						return( nil );
				}
			case FnorthRoof:
				"You drop the tennis ball, and it rolls off the roof ";
				foo := _rand( 2 );
				switch( foo )
				{
					case 1:
						"into the front of the house, where it bounces
						to a stop. ";
						self.moveInto( FfrontOfHouse );
						return( nil );
					case 2:
						"into the back yard, where it bounces to a
						stop. ";
						self.moveInto( FbehindHouse );
						return( nil );
				}
			case FsouthRoof:
				"You drop the tennis ball, and it rolls ";
				foo := _rand( 2 );
				switch( foo )
				{
					case 1:
						"off into the south of the house, where it hits
						the sloping ground and rolls into the woods. ";
						self.moveInto( Fwoods );
						return( nil );
					case 2:
						if ( Fdrainpipe.cleaned )
						{
							"into into the gutter and vanishes down the
							drainpipe. A few seconds later, you see it roll
							out of the spout into the back yard. ";
							self.moveInto( FbehindHouse );
						}
						else
						{
							if ( drainpipe.cleaned )
							{
								"into into the gutter and vanishes 
								down the drainpipe. ";
								self.moveInto( stuckLimbo );
							}
							else
							{
								"off into the south of the house, where it hits
								the sloping ground and rolls into the woods. ";
								self.moveInto( Fwoods );
								break;
							}
						}
						return( nil );
				}
		}
		pass doDrop;
	}
	
	verDoClean( actor ) = {}
	doClean( actor ) =
	{
		if ( !self.slobbery )
			"\^<<self.thedesc>> is cleaner now. ";
		else
		{
			"You take a moment and clean the slobber off of <<self.thedesc>>. ";
			self.slobbery := nil;
		}
	}
	
	verDoRoll( actor ) = {}
	doRoll( actor ) =
	{
		if ( Me.location = platform || Me.location = platform2 )
		{
			"You roll the tennis ball onto the platform. ";
			self.moveInto( Me.location.location );
		}
		else if ( Me.location = insideShed || Me.location = northRoof || 
			Me.location = southRoof || Me.location = FnorthRoof || 
			Me.location = FsouthRoof ) 
		{
			self.doDrop( actor );
		}
		else if ( Me.location = southOfHouse )
		{
			"You roll the tennis ball. It follows the sloping ground
			and disappears into the woods. ";
			self.moveInto( woods );
		}
		else if ( Me.location = PsouthOfHouse )
		{
			"You roll the tennis ball. It follows the sloping ground
			and disappears into the woods. ";
			self.moveInto( Pwoods );
		}
		else if ( Me.location = FsouthOfHouse )
		{
			"You roll the tennis ball. It follows the sloping ground
			and disappears into the woods. ";
			self.moveInto( Fwoods );
		}
		else
		{
			"You roll the tennis ball. It goes a short distance and
			then stops. ";
			self.moveInto( Me.location );
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Heh, there's always some old tennis ball or a
				frisbee stuck on a roof.\" ";
				return( true );
			case Laura:
				"Laura says, \"I suppose more tennis balls get lost than get
				played with.\" ";
				return( true );
			case Architect:
				"He says, \"I don't have time for tennis!\" ";
				return( true );
			case Blackie:
				"\^<<who.thedesc>> regards <<self.thedesc>> with a keen
				canine interest. He wags his tail aggressively, his eyes
				locked on <<self.thedesc>>. ";
				self.hasBlackiesInterest := true;
				return( true );
			default: 
				return( nil );
		}
	}
;

southRoof: room
	sdesc = "South roof"
	ldesc = 
	{
		"The shingles are in even ";
		
		if ( global.newRoof = nil )
			"worse shape on this end of the house, which makes you 
			very nervous as the ";
		else
			"better shape on this end of the house. The ";
		
		"ground is a long way down from the peak here, at least 30 feet. The gutter 
		trap is to the west and continues up to the north end of the house. You can see
		the top opening of the drainpipe in the clogged leaves. ";
	}
	xdesc = "The only exit is north. " 
	north = northRoof
	up = 
	{
		"You can't go that way. And yet, you find yourself lifted high into the
		air, rising into the clouds. Vapor obscures your vision for a moment,
		and when the mists clear, you find yourself in... \b";
		
		Me.travelTo( easterEggRoom );
	}
	noexit = "You will fall off the roof if you go in that direction. "
	firstseen = 
	{
		notify( squirrel, &actorDaemon, 0 );
	}
;

roofPeak: fixedBlock
	sdesc = "peak of the roof"
	asdec = "the peak"
	ldesc = "The roof here slants up to a high peak here, with the ground 
			dizzyingly far below. "		
	noun = 'peak'
	location = southRoof
	verIoAttachTo( actor ) = {}
;

shingles2: staticItem
	sdesc = "roof shingles"
	ldesc = 
	{
		if ( global.newRoof = nil )
			"The shingles are in really bad shape on this end of the house.
			Some of them are really loose. ";
		else
			"The ultimate in roof shingling -- durable, weatherproof, 
			and fancy! ";
	}
	noun = 'shingle' 'single' 
	adjective = 'tile' 'roof'
	plural = 'shingles' 'singles' 'tiles'
	isThem = true
	location = southRoof
		
	verDoTake( actor ) =
	{
		if ( badShingle.location )
		{
			"There aren't any ";
			
			if ( not global.newRoof )
				"other ";
				
			"shingles loose enough to take. ";
		}
	}
	doTake( actor ) =
	{
		"You pry loose one of the bad shingles. ";
		badShingle.moveInto( Me );
	}
	
	verDoLeapTo( actor ) = 
	{
		"You are too high up to risk doing that. You'll break your ankle if
		you jump off the roof. ";
	}
	
	verDoLetGo( actor ) =
	{
		"Falling off the roof is an inherently dangerous idea. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Gee, it's a shame to have a nice house and then
				keep a cruddy roof on top of it.\" ";
				return( true );
			case Laura:
				"Laura says, \"Be careful. Old shingle roofs like that can be
				a fire hazard. They can leak, too. If I were you I'd get a 
				better roof put on that house as early as possible.\" ";
				return( true );
			case Architect:
				if ( global.newRoof = nil )
					"He says, \"Bad shingles? You'll have to show me what you 
					mean.\" ";
				else
					"He says, \"Oh, don't worry. I'll make sure to put in the
					request for much higher quality shingles. The roofing
					will be quite superb.\" ";
				return( true );
			case squirrel:
				"The squirrel gnaws on one of the rotten shingles, makes a 
				face, and spits out the splinters.\" ";
				return( true);
			default: 
				return( nil );
		}
	}
;

badShingle: item
	sdesc = "bad shingle"
	ldesc = "This is a prime example of what not to make a roof out of. It shouldn't 
			be in such bad shape after only, what, ten years?"
	noun = 'shingle' 'single'
	adjective = 'bad'
	location = nil
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Gee, it's a shame to have a nice house and then
				keep a cruddy roof on top of it.\" ";
				return( true );
			case Laura:
				"Laura says, \"Be careful. Old shingle roofs like that can be
				a fire hazard. They can leak, too. If I were you I'd get a 
				better roof put on that house as early as possible.\" ";
				return( true );
			case Architect:
				if ( global.newRoof = nil )
					"He says, \"Bad shingles? You'll have to show me what you 
					mean.\" ";
				else
					"He says, \"Oh, don't worry. I'll make sure to put in the
					request for much higher quality shingles. The roofing
					will be quite superb.\" ";
				return( true );
			case squirrel:
				"The squirrel gnaws on one of the rotten shingles, makes a 
				face, and spits out the splinters.\" ";
				return( true);
			default: 
				return( nil );
		}
	}
;

gutter2: staticItem
	sdesc = "gutter"
	ldesc = "It's clogged full of leaves, but you can still make out the top opening of 
			the drainpipe that leads down to the back of the house. "
	noun = 'gutter' 'trap'
	location = southRoof
	
	ioPutIn -> drainpipe
	ioThrowIn -> drainpipe
	doClean -> drainpipe
	doCleanWith -> drainpipe
	doLookin -> drainpipe
	doSearch -> drainpipe
;

leaves2: block
	sdesc = "leaves"
	adesc = "some leaves"
	noun = 'leaf'
	plural = 'leaves'
	isThem = true
	location = nil
	bulk = 10
	
	verDoLookin( actor ) = { self.verDoSearch( actor ); }
	doLookin( actor ) = { self.doSearch( actor ); }
	
	verDoClean( actor ) = { self.verDoTake( actor ); }
	verDoTake( actor ) = 
	{
		"You pull a few stray leaves from the gutter and toss them aside. ";
	}
;

squirrel: NPC
	isfixed = nil
	isHim = true
	sdesc = "squirrel"
	adesc = { "a <<self.sdesc>>"; }
	thedesc = { "the <<self.sdesc>>"; }
	ldesc = "Definitely male, all right. He's got a tuft of white hair on his head that 
			almost gives him an Einstein-like appearance. In his little paws is a big, 
			juicy acorn. "
	noun = 'squirrel'
	adjective = 'male' 'rodent' 'mating' 'habits'
	plural = 'squirrels' 'rodents'
	location = southRoof
	MAX_actions = 33
	action = 0
	actorDaemon = 
	{
		if ( Me.location = self.location )
		{
			if ( self.wasTalkedTo = nil )
			{
				local temp;
				if ( ( self.action > self.MAX_actions ) or ( self.action < 0 ) )
					self.action := 0;
				doSquirrelAction( self.action );
				self.action++;
			}
		}
		self.wasTalkedTo := nil;
	}
	disavow( it ) =
	{
		self.actorDaemon;
	}
	sayHello = "The squirrel doesn't seem to understand. "
	talkAboutMyself = 
	{
		"\nThe squirrel doesn't seem to understand. ";
	}
	sayMyJob = { "The squirrel doesn't seem to understand. "; }
	sayWhoAmI = { "The squirrel doesn't seem to understand. "; }
	responseToThanks = 
	{
		"\^<<self.thedesc>> twitches its tail happily. ";
	}

	actorAction( v, d, p, i ) =
	{
		if ( Me.isIn( self.location ) )
		{
			if ( v = helloVerb )
				self.sayHello;
			if ( v = followVerb )
			{
					"\n\^<<self.thedesc>> doesn't appear interested in 
					following <<d.fmtYoum>>. ";
			}
			else if ( v = waitVerb || v = singVerb || v = danceVerb || 
				v = smileVerb )
			{
				"\n\^<<self.thedesc>> looks at you quizzically. ";
			}
			else if ( v = giveVerb )
			{
				if ( d.isIn( self ) )
					"The squirrel doesn't want to give you <<d.thatdesc>>. ";
				else
					"The squirrel doesn't have <<d.thedesc>>. ";
			}
			else
				self.disavow( nil );
		}
		else 
			"\n\^<<self.thedesc>> isn't here. ";
		exit;
	}
	doHello( actor ) = { self.disavow( nil ); }
	verIoGiveTo( actor ) = {}
	ioGiveTo( actor, dobj ) =
	{
		if ( ( dobj = hotSandwich ) or ( dobj = coldSandwich ) )
		{
			"The squirrel isn't hungry. Besides, squirrels don't eat 
			sandwiches. ";
		}
		else if ( dobj = rareBook )
		{
			"%You% give the rare book to the squirrel. ";
			
			"\bThe squirrel is so excited by the numerous color depictions of female 
			squirrels in heat that he drops the acorn, which unfortunately rolls down 
			the slope of the roof into the gutter. You hear the acorn rattle into the 
			drainpipe";
			
			rareBook.moveInto( nil );
			self.moveInto( nil );
			
			if ( drainpipe.cleaned = nil )
			{
				" and get stuck in the muck halfway down. ";
				acorn.moveInto( stuckLimbo );
			}
			else
			{
				". ";
				acorn.moveInto( behindHouse );
			}

			"\bThe squirrel runs off with the rare book. ";

		}
		else
		{
			"That isn't what the squirrel is interested in. ";
		}
	}
	verDoBuy( actor ) = { "The squirrel is free and is not for sale. "; }
	verDoLaughAt( actor ) = 
	{
		"You laugh at the squirrel. Your derisiveness falls on deaf ears,
		as it were. ";
	}
	
	verDoLookin( actor ) = 
	{
		"Looking inside squirrels is hardly possible. ";
	}
	verDoPoint( actor ) = 
	{
		"You point at the squirrel. The squirrel doesn't seem to 
		care. ";
	}
	verDoSearch( actor ) =
	{
		"You'd better keep your hands to yourself. The squirrel 
		isn't a housepet. Besides, it's plain to see that the only
		thing he's holding is the acorn. ";
	}
	
	verDoTake( actor ) = { self.verDoTouch( actor ); }
	verDoTouch( actor ) = 
	{
		"\n\^<<self.thedesc>> isn't a housepet. You shouldn't touch it. ";
	}
	
	verDoFollow( actor ) = {}
	doFollow( actor ) = { self.doCatch( actor ); }
	
	verDoCatch( actor ) = {}
	doCatch( actor ) =
	{
		"The squirrel darts around too quickly for you to catch it. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Careful. Squirrels are in heat this time of year.\" ";
				return( true );
			case Laura:
				"Laura says, \"Sounds like a cute little critter.\" ";
				return( true );
			case Architect:
				"He says, \"Oh, harumph. Squirrels. Pests, that's what they are.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

paws: fixeditem
	sdesc = "squirrel's paws"
	adesc = { self.thedesc; }
	ldesc = "The squirrel's little paws are holding a big, juicy acorn. "
	noun = 'paw'
	plural = 'paws'
	isThem = true
	adjective = 'little'
	location = squirrel
;

acorn: treasure
	sdesc = "big juicy acorn"
	ldesc = "Ripe for planting. "
	noun = 'acorn'
	adjective = 'big' 'juicy' 'ripe' 'nut'
	location = squirrel
	takevalue = 8
	
	doPutIn( actor, io ) =
	{
		if ( io = acornHole )
		{
			self.moveInto( io );
			"You plant the acorn in the little hole. ";
		}
		else pass doPutIn;
	}
	
	verDoActLike( actor ) = {}
	doActLike( actor ) = 
	{
		if ( Me.location.isTreeRoom )
		{
			"Har har har. ";
		}
		else if ( squirrel.location = Me.location )
		{
			"You're not fooling the squirrel for a moment. ";
		}
		else
		{
			"Don't be silly. ";
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Dig a hole and plant that sucker. I bet it makes
				a big, beautiful tree.\" ";
				return( true );
			case Laura:
				"Laura says, \"You'd better plant that in the ground as early as
				you can.\" ";
				return( true );
			case Architect:
				"He says, \"If you want to plant an acorn, go ahead. It's your
				yard. You probably shouldn't plant it too close to the house,
				though. Trees can fall over during bad storms and damage the
				property.\" ";
				return( true );
			case squirrel:
				"The squirrel sighs. You didn't know squirrels could do that. ";
				return( true);
			default: 
				return( nil );
		}
	}
;

drainpipe: fixeditem, qcontainer
	sdesc = "drainpipe"
	ldesc = "It runs from here down to a spout at the back of the house. "
	noun = 'pipe' 'drainpipe' 
	adjective = 'drain' 'spout'
	location = southRoof
	cleaned = nil

	verDoSearch( actor ) = {}
	doSearch( actor ) =
	{
		if ( !self.cleaned )
			"You feel nothing but muck and wet leaves in the drainpipe. ";
		else
			"The drainpipe is empty. ";
	}

	verIoPutIn( actor ) = {}
	ioPutIn( actor, dobj ) =
	{
		"%You% drop "; dobj.thedesc; " into the drainpipe. ";
		
		if ( self.cleaned )
		{
			"It rattles through and comes out the spout below. ";
			dobj.moveInto( behindHouse );
		}
		else
		{
			if ( dobj != cannonball)
			{
				"It vanishes, leaving you with a sinking feeling in your gut 
				that you won't see it again. ";
		
				dobj.moveInto( stuckLimbo );
			}
			else
			{
				local i, lst, len;

				"It barely fits, so you give it a shove. There is a disgusting vomiting 
				noise below, as the cannonball bursts out the bottom of the spout, 
				pushing all the muck out with it. ";
				
				incscore( 3 );
				global.scoreCard[9] := 1;
				self.cleaned := true;
				cannonball.moveInto( behindHouse );
				drainpipeCloggingLeaves.moveInto( nil );
				leaves2.moveInto( gutter2 );
				
				lst := stuckLimbo.contents;		// empty the pipe by moving all 
				len := length(lst);				// items in stuckLimbo into behindHouse
				for (i := 1 ; i <= len ; ++i)
					lst[i].moveInto( behindHouse );
			}
		}
	}
	
	verDoLookin( actor ) = {}
	doLookin( actor ) =
	{
		if ( !self.cleaned )
			"%You% see nothing but muck and darkness in the drainpipe. ";
		else
			"Clean as a whistle! ";
	}
	
	verDoAttack( actor ) = { self.doKick( actor ); }
	verDoAttackWith( actor, io ) =
	{
		if ( io = shovel || io = crowbar )
			self.doKick( actor );
		else pass doAttackWith;
	}
	
	verDoClean( actor ) = 
	{
		if ( !self.cleaned )
			drainpipeCloggingLeaves.verDoTake( actor );
		else
			"The drainpipe is already cleaned out. ";
	}
	verDoCleanWith( actor, io ) = 
	{
		"That isn't going to work. ";
	}
	
	doKick -> drainspout
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sounds like you need to clean out that sucker.
				Maybe shove something really heavy down it, and it'll blow
				out all the muck.\" ";
				return( true );
			case Laura:
				"Laura says, \"Eewww, clogged drainpipes.\" ";
				return( true );
			case Architect:
				"He says, \"It's important to keep drainpipes clean, otherwise
				they will just clog up. It would take a lot of force to clean 
				out a clogged drainpipe.\" ";
				return( true );
			case squirrel:
				"The squirrel scrambles over to the clogged drainpipe and 
				peers in, then races back to where he was. ";
				return( true);
			default: 
				return( nil );
		}
	}
;

stuckLimbo: container
	location = nil
;

drainpipeCloggingLeaves: fixeditem, floatingItem
	sdesc = "leaves"
	ldesc = "The muck is made of wet leaves that are clogging the flow 
			down the drainpipe. "
	adesc = "some leaves"
	noun = 'clog' 'leaf'
	plural = 'leaves'
	isThem = true
	adjective = 'muck' 'wet' 'darkness'
	location = 
	{
		if ( not drainpipe.cleaned )
		{
			if ( Me.location = southRoof )
				return( drainpipe );
			if ( Me.location = behindHouse )
				return( drainspout );
		}
		return( nil );
	}
	
	verDoSearch( actor ) = { self.verDoLookin( actor ); }
	verDoLookin( actor ) = 
	{
		"You see nothing but muck and wet leaves in the drainpipe. ";
	}
	
	verDoClean( actor ) = { self.verDoTake( actor ); }
	verDoCleanWith( actor, io ) = 
	{
		"That isn't going to work. ";
	}
	
	verDoPull( actor ) = { self.verDoTake( actor ); }
	verDoTake( actor ) =
	{
		"You pull out a few stray leaves, but it does nothing to unclog
		the drainpipe. ";
	}
	
	verDoPryWith( actor, io ) =
	{
		"That isn't going to work. ";
	}
;

behindHouse: room
	sdesc = "Behind house"
	ldesc = "The back of your house is pretty non-descript, except for some really 
			nice trees that make up for the lack of landscaping in the front. The 
			spout of your drainpipe comes down here from the roof. "
	xdesc = "A gravel path extends northeast and southeast. "
	se = southOfHouse
	ne = northOfHouse
	east = "You can't enter the house from here. "
;

behindHouseWindows: houseWindow
	ldesc = "The windows here face out from your living roof to the south and the 
			dining room (now a converted study) to the north, as well as smaller
			windows on the upper floor. All of them are closed and locked
			from the inside, with the blinds closed. "
	location = behindHouse
;

niceTrees: fixedBlock
	sdesc = "nice trees"
	noun = 'tree'
	plural = 'trees'
	isThem = true
	adjective = 'nice'
	location = behindHouse
;

drainspout: block, qcontainer
	sdesc = "drainpipe"
	noun = 'spout' 
	adjective = 'drainpipe' 'pipe' 'drain'
	location = behindHouse
	maxbulk = 0
	
	verDoSearch( actor ) = { self.verDoLookin( actor ); }
	verDoLookin( actor ) = 
	{
		if ( drainpipe.cleaned )
			"You find nothing of interest. ";
		else
			"The drainpipe is clogged with leaves. ";
	}
	
	verDoAttack( actor ) = { self.doKick( actor ); }
	verDoAttackWith( actor, io ) =
	{
		if ( io = shovel || io = crowbar )
			self.doKick( actor );
		else pass doAttackWith;
	}
	
	doClean -> drainpipeCloggingLeaves
	verDoCleanWith( actor, io ) = 
	{
		"That isn't going to work. ";
	}
	
	verDoKick( actor ) = {}
	doKick( actor ) =
	{
		if ( drainpipe.cleaned ) 
			"You strike the drainpipe. It makes a hollow metallic noise. ";
		else if ( length( stuckLimbo.contents ) = 0 )
			"You strike the drainpipe. It makes a dull noise, padded by all 
			the leaves clogging it up. ";
		else
		{
			if ( self.kickedOnce )
				"Repeatedly striking the drainpipe is not going to unclog
				it. If anything, it will cause whatever is inside it to settle 
				into an even more tightly clogged state. ";
			else
			{
				"It makes a dull noise, and you hear its clogged contents 
				shift slightly. ";
				self.kickedOnce := true;
			}
		}
	}
	
	verIoPutIn( actor ) = {}
	ioPutIn( actor, dobj ) = 
	{
		if ( dobj.bulk > 2 ) 
			"You can't fit that into the drainpipe. ";
		else 
		{
			if ( dobj = cannonball || dobj = tennisBall )
				"You put <<dobj.thedesc>> into <<self.thedesc>>, and it
				rolls out onto the ground. ";
			else
				"You put <<dobj.thedesc>> into <<self.thedesc>>, and it
				falls out onto the ground. ";
			dobj.moveInto( behindHouse );
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"If you've got a drainspout, you probably have a 
				drainpipe up on the roof gutter. That's probably where you need
				to look.\" ";
				return( true );
			case Laura:
				"Laura says, \"If nothing's coming out the spout, maybe you should
				look at the drainpipe opening on the roof gutter.\" ";
				return( true );
			case Architect:
				"He says, \"Harumph!\" and shoos you away. \"I'm not here to solve
				your problems for you.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

gravelPath: fixedBlock
	sdesc = "gravel path"
	noun = 'path'
	adjective = 'gravel'
	location = behindHouse
;

garageDoor2: garageDoorItem, lockableDoorway
	isfixed = nil
	doordest = northOfHouse
	otherside = garageDoor1
	sdesc = "garage door"
	noun = 'door' 
	adjective = 'garage'
	noAutoOpen = true
	location = inGarage
	isopen = nil
	islocked = nil
	
	verDoLock( actor ) =
	{
		if ( self.isopen ) 
			"You can't lock the garage door while it is open. ";
		else
			pass verDoLock;
	}
;

inGarage: room
	indoors = true
	foo = 0
	sdesc = "In the garage"
	ldesc = 
	{
		"This room is a total mess. No wonder you keep your car in the driveway. ";
		
		switch( foo )
		{
			case 14:
			case 15:
			case 16:
			case 17:
				"It is taking a long time to sort through the junk in here, and you 
				have found everything but the kitchen sink, and there still doesn't 
				seem to be much point to it. ";
				break;
			case 18:
			case 19:
				"Sure enough, it took a long time to sort through the junk in here, and 
				you have found everything including the kitchen sink, and there still 
				doesn't seem to have been much point to it. ";
				break;
			default:
				"It would take a long time to sort through the junk in here, 
				and even then it seems unlikely there would be much point to it. ";
				break;
		}
		
		"There is a garage door button on the wall. ";
	}
	xdesc = 
	{
		"A closed door to the south leads into your house through the 
		kitchen. The only other exit is the way you came in, which 
		is <<garageDoor2.isopen ? "open" : "closed">>. ";
	}
	lightDesc = 
	{
		if ( garageDoor2.isopen )
			theSky.ldesc;
		else
			"It's a bit dark in here with the garage door closed. ";
	}
	north = garageDoor2
	out = garageDoor2
	south = garageBackDoor
	in = garageBackDoor
	
	firstseen =
	{
		junk.searchCont := 					// hack to force-organize serialSearch
			[ crowbar wd40 pillowCase cobwebs soccerball tirePump waspnest
				twobyfour canOpener mooseHead shovel mattress diviningRod 
				machete wheelbarrow frisbee cannonball kitchenSink nothingElse ];
		junk.isSeen := true;
		setit( junk );
	}
;

garageBackDoor: lockableDoorway
	sdesc = "back door"
	noun = 'door'
	adjective = 'back'
	location = inGarage
	doordest = finalroom
	isopen = nil
	islocked = true
	mykey = duplicateKey
;

wallOpener: garageOpenerItem
	isfixed = nil
	sdesc = "wall opener button"
	adjective = 'wall'
	isListed = true
	location = inGarage

	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Clever gadgets, aren't they?\" ";
				return( true );
			case Laura:
				"Laura says, \"Hard to get locked in when you've got an opener
				in the garage like that. Then again, your trouble is being 
				locked out, not locked in.\" ";
				return( true );
			case Architect:
				"He says, \"Naturally, there will be a garage door opener 
				button inside the garage.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

/******************************* LIST OF JUNK ***********************************
 *																				*
 * The junk in the garage contains a huge number of search-findable items, 		*
 * which come out one at a time, in sequence, provided you keep entering the 	*
 * search command (serialSearch = true). Most of the items are red herrings,	*
 * useless to the game, but a few of them come in handy.						*
 *																				*
 ********************************************************************************/

junk: block, searchHider
	sdesc = "junk in the garage"
	adesc = "the junk"
	thedesc = "the junk"
	noun = 'junk' 'garage'
	location = inGarage
	autoTake = nil
	serialSearch = true
	
	doSearch(actor) =
	{
		if (self.searchCont = nil)
			"There's nothing else in <<self.thedesc>>. ";
		else
		{
			inGarage.foo++;
	   		self.searchCont := self.searchObj(actor, self.searchCont);
			
			if ( inGarage.foo = 19 )
			{
				incscore( 10 );
				global.scoreCard[3] := 1;
			}
		}
	}
	doLookin(actor) =
	{
		if (self.searchCont = nil)
			"There's nothing else in <<self.thedesc>>. ";
		else
		{
			inGarage.foo++;
	   		self.searchCont := self.searchObj(actor, self.searchCont);
			
			if ( inGarage.foo = 19 )
			{
				incscore( 10 );
				global.scoreCard[3] := 1;
			}
		}
	}

	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"You ought to look through all that and see 
				if there's anything good <<crowbar.location ? "still hidden " : 
				"hidden ">>in there. You never know.\" ";
				return( true );
			case Laura:
				"Laura says, \"Sounds like you need to have a garage sale! You
				should sort through it thoroughly first to see if there's 
				anything valuable hidden in all that stuff.\" ";
				return( true );
			case Architect:
				"He says, \"We haven't even finished pouring the cement in
				the garage and you're asking me about all the junk you're
				going to keep in it? I'm sorry, but this is very distracting
				to me.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

crowbar: priseItem, diggingItem, hackItem, hiddenItem
	sdesc = "crowbar"
	bulk = 2
	ldesc = "It's an ordinary crowbar, about 2 feet long. "
	noun = 'crowbar' 'bar'
	adjective = 'crow'
	searchLoc = junk
	
	ioPryWith( actor, dobj ) = 
	{
		if ( dobj = grating )
		{
			if ( grating.isopen )
				"The grating is already open. ";
			else 
			{
				"You pry up the sewer grating. The sewer hole is now wide open. ";
				grating.isopen := true;
				sewerHole.moveInto( grating.location );
				dummyBill.moveInto( nil );
			}
		}
		else if ( dobj = frontDoor )
		{
			"You wedge the end of the crowbar into the door frame and steady 
			yourself. However, you simply can't bring yourself to ruin your 
			expensive front door just because you can't yet find your house 
			key. ";
		}
		else if ( dobj.isHouseWindow )
		{
			"You wedge the end of the crowbar into the window frame and steady 
			yourself. However, you simply can't bring yourself to ruin your 
			window just because you can't yet find your house key. ";
		}
		else if ( dobj = FfrontDoor )
		{
			if ( nailedBoards.pried )
			{
				"It seems to be swollen shut, and you can't find any place
				on this side of the door to insert the crowbar. ";
			}
			else
			{
				"The boards that are nailing it shut are still in the way.
				You'll have to remove them first if you want to pry the
				door. ";
			}
		}
		else if ( dobj = FfrontDoorInside )
		{
			if ( nailedBoards.pried )
			{
				"It takes some work just to wedge the end of the crowbar 
				in between the door and its frame. You steady yourself, and
				throwing your weight into it, force the crowbar as hard as
				you can. You hear a terrific, splitting crack, and the door
				swings open. ";
				FfrontDoorInside.pried := true;
				FfrontDoorInside.setIsopen( true );
			}
			else
			{
				"It seems to be nailed shut on the outside. You'll have to 
				remove those nails first if you want to pry open the door. ";
			}
		}
		else if ( dobj = nailedBoards )
		{
			"It's tough work, fighting against long-rusted nails and 
			tough, wet wood, but you succeed in removing all of the
			nailed boards from the front door. ";
			nailedBoards.moveInto( nil );
			FfrontDoorInsideNails.moveInto( nil );
			pileOfBoards.moveInto( FfrontOfHouse );
			nailedBoards.pried := true;
		}
		else if ( dobj = carTrunk )
		{
			"You'll damage the trunk if you do that. ";
		}
		else if ( dobj = wedgedBooks || ( dobj = depositSlot && wedgedBooks.location ) )
		{
			"That is more force than necessary to get the books loose. You'll
			damage both the books and the depository slot. ";
		}
		else if ( ( dobj = garageDoor1 ) or ( dobj = garageDoor2 ) )
		{
			"The garage door refuses to budge. ";
		}
		else if ( dobj = shingles1 || dobj = shingles2 )
		{
			"You don't need <<self.adesc>> to take one of the shingles. ";
		}
		else if ( dobj = stones )
		{
			dobj.doLookunder( actor );
		}
		else if ( dobj = dresserObstacle )
		{
			"The dresser is too large and heavy for even <<self.thedesc>> 
			to move. ";
		}
		else if ( dobj = FatticWindow || dobj = atticWindowNailedBoards )
		{
			if ( FatticWindow.boardedUp )
			{
				"You force the crowbar as hard as you can. You hear a grinding
				squeak as the nails loose themselves from the window jamb. After
				a few minutes, you succeed in removing all of the boards from
				the attic window. ";
				
				FatticWindow.boardedUp := nil;
				atticWindowNailedBoards.moveInto( nil );
				atticWindowPileOfBoards.moveInto( Fattic );
			}
			else
				"You have already pried off the boards. ";
		}
		else
		{
			"\^<<self.thedesc>> can't help you with that. ";
		}
	}
	
	ioDigWith( actor, dobj ) = 			// Player might try using the machete as
	{ 							// a digging tool
		"\^<<self.thedesc>> isn't a good tool for digging. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Crowbars always come in handy. Well, I guess.
				I've never used one. But I bet if you were in the right place
				in the right situation, a crowbar would be just the thing.\" ";
				return( true );
			case Laura:
				"Laura says, \"What's a crowbar? Oh, one of those. I don't know
				anything about crowbars.\" ";
				return( true );
			case Architect:
				"He says, \"No, I don't have a crowbar. Oh, you have a crowbar.
				Well, that's nice.\" He goes back to work. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

wd40: item, hiddenItem
	sdesc = "can of WD-40"
	ldesc = "It's an ordinary can of WD-40, the all-purpose lubricant. "
	noun = 'can' 'wd-40' 'wd40'
	adjective = 'wd' '40'
	searchLoc = junk
	
	verDoSprayOn( actor, io ) = {}
	verIoSprayWith( actor ) = {}
	ioSprayWith( actor, dobj ) = 
	{
		switch( dobj )
		{
			case wheelbarrow:
			case frontWheel: 
				"You give the front wheel a spritz of the old WD-40.
				<<frontWheel.broken ? "It still isn't fixed, but it " :
				"It ">> probably won't squeak any more. ";
				frontWheel.greased := true;
				break;
			case waspnest:
				"WD-40 is a lubricant, not a bug spray. ";
				break;
			case doorLock:
			case FdoorLock:
				"You give <<dobj.thedesc>> a good spray of WD-40.
				Its key will now probably turn with greater 
				ease<<duplicateKey.isIn( Me ) ? "." : 
				", assuming you had one, of course.">> ";
				dobj.greased := true;
				break;
			case garageDoor1:
			case garageDoor2:
			case FgarageDoor1:
			case FgarageDoor2:
			case grating:
				if ( not self.isopen )
				{
					"Spraying <<dobj.thedesc>> with <<self.thedesc>> won't 
					help you open it any easier. ";
					break;
				}
			default:
				"Spraying <<dobj.thatdesc>> with <<self.thedesc>> won't 
				accomplish anything. ";
				break;

			
		}
	}
		
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"If something squeaks, sticks, or freezes up,
				that'll fix 'er up, all right.\" ";
				return( true );
			case Laura:
				"Laura says, \"Ohhh, I wouldn't know anything about that
				stuff. Sorry.\" ";
				return( true );
			case Architect:
				"He says, \"I'm sure we could find you a can if you really
				needed some.\" ";
			return( true );
			default: 
				return( nil );
		}
	}
;

pillowCase: openable, hiddenItem								// red herring
	sdesc = "old pillowcase"
	adesc = "an old pillowcase"
	ldesc = 
	{
		"It's got a 70's flower pattern, but the colors have faded. ";
		inherited.ldesc;
	}
	noun = 'pillowcase'
	adjective = 'pillow' 'case'
	searchLoc = junk
	maxbulk = 12
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"My mother used to have pillowcases like
				that.\" ";
				return( true );
			case Laura:
				"Laura says, \"I don't think there's much you can do with
				an old pillowcase.\" ";
				return( true );
			case Architect:
				"He says, \"I don't think I have anything to say about old
				pillowcases, sorry.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

cobwebs: fixeditem, hiddenItem								// red herring
	herring = true
	sdesc = "handful of cobwebs. Bleah"
	ldesc = "You wiped them off on your pantleg. "
	noun = 'cobweb' 'web'
	plural = 'cobwebs' 'webs'
	adjective = 'handful' 'of' 'spider' 'cob'
	isThem = true
	searchLoc = junk
	
	verDoTake( actor ) = {}
	doTake( actor ) =
	{
		"You wiped them off on your pantleg. ";
		self.moveInto( nil );
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Um. Yeah.\" ";
				return( true );
			case Laura:
				"Laura says, \"Oooh, ick! I hate spiders.\" ";
				return( true );
			case Architect:
				"He says, \"If there's a nook or a cranny in a house, there
				will be spiderwebs. Hard to do anything about it.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;
	
soccerball: item, hiddenItem									// red herring
	herring = true
	sdesc = "deflated soccer ball"
	ldesc = "A World Cup fan you aren't. This thing is in sorry shape. "
	noun = 'ball'
	adjective = 'deflated' 'soccer' 'football'
	searchLoc = junk
	
	verDoHead( actor ) =
	{
		if ( not self.isIn( Me ) )
			"You have to be holding the deflated soccer ball before you 
			can head it. The result is likely to be unsatisfactory at
			best, anyway. ";
	}
	doHead( actor ) = 
	{
		"You toss the deflated ball up and bounce it off your forehead.
		It falls straight down in a pathetic manner. ";
		
		self.moveInto( Me.location );
	}
	
	verDoKick( actor ) =
	{
		if ( not self.isIn( Me ) )
			"You kick the deflated ball. It moves a pathetic distance and
			then rests like a sad lump. ";
	}
	doKick( actor ) =
	{
		"You give the deflated ball a kick. It lumps to the ground in
		a pathetic manner. ";
		
		if ( Me.location = platform )
			self.moveInto( Me.location.location );
		else
			self.moveInto( Me.location );
	}
	
	verDoCatch( actor ) =
	{
		"Someone would have to throw you <<self.thedesc>> for you to catch it. ";
	}
	
	verDoRoll( actor ) = {}
	doRoll( actor ) =
	{
		"You attempt to roll the deflated ball. It lumps over, quite 
		pathetically, and then just lies there. ";
		self.moveInto( Me.location );
	}
	
	doThrow( actor ) = 
	{
		"You throw the deflated soccerball. It goes a negligible distance
		and then plops down like a sad lump. ";
		
		if ( Me.location = platform )
			self.moveInto( Me.location.location );
		else
			self.moveInto( Me.location );
	}
	verDoBlowUp( actor, io ) = {}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Deflated soccerball. Sounds like something you should
				just throw away.\" ";
				return( true );
			case Laura:
				"Laura says, \"What good is a deflated soccerball? Also, why are
				you asking me about it? Never mind, don't answer that.\" ";
				return( true );
			case Architect:
				"He says, \"I don't have time for sports chit-chat!\" ";
				return( true );
			case squirrel:
				"The squirrel makes some sort of kicking movement. Perhaps
				he's mocking you. Or perhaps you're a little nutty for asking
				a squirrel questions. ";
				return( true);
			default: 
				return( nil );
		}
	}
;

tirePump: item, hiddenItem										// red herring
	herring = true
	sdesc = "broken tire pump"
	ldesc = "I know what you're thinking -- you can pump up the soccer ball with 
			this baby. Nope. It's just a piece of junk. "
	noun = 'pump'
	adjective = 'tire'
	searchLoc = junk
	
	verIoBlowUp( actor ) = {}
	ioBlowUp( actor, dobj ) = 
	{
		if ( dobj = soccerball )
		{
			"The tire pump is a broken piece of junk. You can't inflate the
			deflated piece of junk soccer ball with it. ";
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sounds like a broken piece of junk to me.\" ";
				return( true );
			case Laura:
				"Laura says, \"You really need to throw things away if they're
				no good for anything.\" ";
				return( true );
			case Architect:
				"He says, \"Pump? What pump? Oh, please. I have so much work
				to do still.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

waspnest: staticItem, hiddenItem						// red herring
	herring = true
	isListed = true
	sdesc = "wasp nest"
	ldesc = "Dratted mud-daubers!  It looks dead, but you'd better leave it alone. "
	noun = 'nest'
	adjective = 'wasp'
	searchLoc = junk
	
	verDoTake( actor ) = { "It looks dead, but you'd better leave it alone. "; }
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Hey, you need to be careful around those.\" ";
				return( true );
			case Laura:
				"Laura says, \"Oh, goodness. Wasps are bad news. Be careful
				picking up their nests.\" ";
				return( true );
			case Architect:
				"He says, \"Wasps are a bother in this part of the country,
				yes. Just be sure not to stir up their nests.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

twobyfour: item, hiddenItem								// red herring
	herring = true
	sdesc = "2x4 plank"
	ldesc = "This plank must be a leftover from some spring project. 
			It's about a yard long. "
	noun = '2x4' 'plank'
	searchLoc = junk
	
	verDoWalk( actor ) = {}
	doWalk( actor ) =
	{
		"Aye, aye, ye scurvy knave! Arrrr! ";
		
		if ( not self.didPirateJoke )
			self.didPirateJoke := true;
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Unless you're building something, a plank of wood
				isn't much use. In my opinion.\" ";
				return( true );
			case Laura:
				"Laura says, \"Are you building something? I'm not sure what good
				a plank is.\" ";
				return( true );
			case Architect:
				"He says, \"You can't make an omelet without breaking a few 
				eggs, and you can't build a house without sawing a few planks.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

canOpener: item, hiddenItem										// red herring
	herring = true
	sdesc = "can-opener"
	ldesc = "One of the hand-operated kind. Junk!"
	noun = 'can-opener'
	searchLoc = junk
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"We use an automatic one here in the shop.\" ";
				return( true );
			case Laura:
				"Laura says, \"Most of those cheap hand-operated ones don't
				even open cans very well. Even if you had a can you needed
				to open, I bet that wouldn't help.\" ";
				return( true );
			case Architect:
				"He says, \"Opener? I just met her!\" Then he laughs, but you
				don't. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

mooseHead: item, hiddenItem										// red herring
	herring = true
	sdesc = "moose head trophy"
	ldesc = "What a piece of junk!  Perhaps the ultimate. Be proud. "
	bulk = 8
	noun = 'moose' 'head' 'trophy'
	searchLoc = junk
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Whoo-boy! I didn't know anyone actually owned
				one of those. You're a real collector all right.\" He mumbles
				something about \"taste\" but you can't quite hear it. Fred
				says, \"Huh? Oh, nothing. I was just saying, I bet these 
				sandwiches have better taste. Er, taste better. Oh, never
				mind.\" ";
				return( true );
			case Laura:
				"Laura says, \"You're very silly, you know that? A moose
				head -- of all things! I hope it's not from a real moose,
				poor creature.\" ";
				return( true );
			case Architect:
				"He says, \"Oh sure, I have one of those. Would you like it?
				I was planning on giving it to you.\" He leans over and in 
				a conspiratorial voice says, \"Really, I can't get rid of
				it. Very tacky.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

shovel: diggingItem, priseItem, hackItem, hiddenItem
	firstDesc = nil
	sdesc = "shovel"
	ldesc = 
	{
		if ( not self.firstDesc ) 
		{
			"Okay, I admit this might come in handy. ";
			self.firstDesc := true;
		}
		"It's a quality shovel. ";
	}
	noun = 'shovel'
	searchLoc = junk
	
	ioDigWith( actor, dobj ) = 
	{
		if ( dobj = softSpot )
		{
			if ( acornHole.location )
				"One hole is enough. ";
			else if ( acornMound.location )
				"One hole is enough. ";
			else
			{
				"The shovel bites a nice hole in the earth. ";
//				softSpot.moveInto( nil );
				acornHole.moveInto( diggingSpot );
			}
		}
		else if ( dobj = acornHole )
		{
			"The hole is big enough already. ";
		}
		else if ( dobj = bareSpot )
		{
			"The ground in the bare spot is too hard for digging. ";
		}
		else pass ioDigWith;
	}
	
	ioPryWith( actor, dobj ) = 			// Player might try using the shovel as
	{ 							// a prying tool
		if ( dobj = grating )
		{
			if ( grating.isopen )
				"The grating is already open. ";
			else 
			{
				"You work the blade of the shovel into the grating and start to 
				apply some leverage. The grating moves a bit, but it doesn't open.
				The shovel just isn't the right tool for the job. ";
			}
		}
		else if ( dobj = wedgedBooks || ( dobj = depositSlot && wedgedBooks.location ) )
		{
			"That is more force than necessary to get the books loose. You'll
			damage both the books and the depository slot. ";
		}
		else if ( ( dobj = garageDoor1 ) or ( dobj = garageDoor2 ) )
		{
			"The garage door refuses to budge. ";
		}
		else if ( dobj = shingles1 || dobj = shingles2 )
		{
			"You don't need <<self.adesc>> to take one of the shingles. ";
		}
		else if ( dobj = stones )
		{
			dobj.doLookunder( actor );
		}
		else if ( dobj = dresserObstacle )
		{
			"The dresser is too large and heavy for even <<self.thedesc>> 
			to move. ";
		}
		else
		{
			"The shovel can't help you with that. ";
		}
	}
	
	ioHackWith( actor, dobj ) = 
	{
		if ( dobj.foliage )
		{
			"Hacking through thick foliage with <<self.adesc>> is 
			as useless as trying to dig holes with a machete. ";
		}
		else
			"\^<<self.thedesc>> isn't any good for that. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
			"Fred says, \"Good for digging, if the ground's soft enough.\" ";
				return( true );
			case Laura:
				"Laura says, \"Digging for treasure? Or are you planning on 
				planting a tree?\" ";
				return( true );
			case Architect:
				"He says, \"Shovels,\" as if that said it all. It doesn't, 
				but you don't bother him about it further. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

mattress: beditem, hiddenItem							// red herring
	herring = true
	sdesc = "beat-up mattress"
	ldesc = "Geez!  Don't you ever throw anything away?"
	pluraldesc = "mattresses"
	noun = 'mattress'
	adjective = 'beat-up'
	searchLoc = junk
	outOfPrep = "off of"
	isListed = true
	
	doLieon( actor ) =
	{
		"Okay, %you're% now lying on <<self.thedesc>>. It's lumpy and 
		uncomfortable. Somewhat filthy, too. ";
		actor.travelTo( self );
	}
	
	askingAboutMe( who ) =
	{				
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Geez! Don't you ever throw anything away?\" ";
				return( true );
			case Laura:
				"Laura says, \"You should give that to the Salvation Army or
				something.\" ";
				return( true );
			case Architect:
				"He says, \"Oh, the bedroom will have plenty of room for a
				mattress.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

diviningRod: item, hiddenItem
	sdesc = "divining wand"
	ldesc = 
	{
		if ( Me.location.rodRoom )
		{
			Me.location.rodDesc;
		}
		else
		{
			"Superstition has it divining wands can find water. To you, it looks 
			like an ordinary stick, with a kind of forked end. ";
		}
	}
	
	noun = 'wand'
	adjective = 'divining' 'vibrating' 'div' 'dowsing'
	searchLoc = junk

	validRoomLoc = 
	{
		if ( self.isIn( Me ) )
			return( Me.location );
		else
		{
			if ( self.location && self.location.location )
				return( self.location.location );
			else
				return( self.location );
		}
	}

	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Hey, those things really work. That's what I 
				saw on this show about things that really worked. They point
				you to water every time.\" ";
				return( true );
			case Laura:
				"Laura says, \"Do those really work? I guess if you went 
				near water it'd vibrate or shake or pull you or something.
			 	Then you'd know.\" ";
				return( true );
			case Architect:
				"He says, \"I don't believe in such superstitious magic
				claptrap, personally.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

machete: hackItem, priseItem, diggingItem, hiddenItem
	sdesc = "machete"
	ldesc = "Oh, yeah. A souvenir from a trip to South America. The blade
			is old and dull, but with some muscle behind it, it could 
			probably be used to hack through a jungle as good as ever. "
	noun = 'machete'
	searchLoc = junk

	ioHackWith( actor, dobj ) = 
	{
		if ( dobj = softSpot )
		{
			if ( acornHole.location )
				"One hole is enough. ";
			else if ( acornMound.location )
				"One hole is enough. ";
			else
			{
				"The machete slashes an angular hole in the earth. ";
				acornHole.moveInto( diggingSpot );
			}
		}
		else if ( dobj = acornHole )
		{
			"The hole is big enough already. ";
		}
		else if ( dobj = mazeFoliage )
		{
			dobj.doHackWith( actor, self );
		}
		else if ( dobj = dresserObstacle )
		{
			"The dresser is not going to move out of the way just because
			you mar it with <<self.thedesc>>. ";
		}
		else
		{
			"Hacking at <<dobj.thedesc>> with the machete is unprofitable. ";
		}
	}
	
	ioDigWith( actor, dobj ) = 
	{
		if ( dobj = softSpot )
		{
			if ( acornHole.location )
				"The hole is big enough already. ";
			else if ( acornMound.location )
				"I can't let you hack at the tender acorn. ";
			else
			{
				"The machete bites a nice hole in the earth. ";
				acornHole.moveInto( diggingSpot );
			}
		}
		else if ( dobj = acornHole )
		{
			"The hole is big enough already. ";
		}
		else if ( ( dobj != acornHole ) and ( dobj != softSpot ) )
		{
			"Digging with a machete is as useless as trying to 
			hack through thick foliage with a shovel. ";
		}
	}
	
	ioPryWith( actor, dobj ) = 			// Player might try using the machete as
	{ 							// a prying tool
		if ( dobj = grating )
		{
			if ( grating.isopen )
				"The grating is already open. ";
			else if ( grating.isopen = nil )
			{
				"You work the blade of the machete into the grating and start to 
				apply some leverage. The grating moves a bit, but the blade starts
				to feel like it's going to snap, so you stop trying to force it. 
				The machete just isn't the right tool for the job. ";
			}
		}
		else if ( dobj = wedgedBooks || ( dobj = depositSlot && wedgedBooks.location ) )
		{
			"That is the wrong way to get the books loose. You'll
			damage both the books and the depository slot. ";
		}
		else if ( ( dobj = garageDoor1 ) or ( dobj = garageDoor2 ) )
		{
			"The garage door refuses to budge. ";
		}
		else if ( dobj = shingles1 || dobj = shingles2 )
		{
			"You don't need <<self.adesc>> to take one of the shingles. ";
		}
		else if ( dobj = stones )
		{
			dobj.doLookunder( actor );
		}
		else if ( dobj = dresserObstacle )
		{
			"The dresser is too large and heavy for the machete to 
			be of any use. ";
		}
		else
		{
			"The machete can't help you with that. ";
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Oh, hey, cool. You could pretend you're 
				in a dense jungle, hacking your way through the foliage
				to find civilization.\" ";
				return( true );
			case Laura:
				"Laura says, \"My uncle used to have one of those. He
				got it in South America, where they use them to hack
				through the jungle foliage.\" ";
				return( true );
			case Architect:
				"He says, \"Mmhmm.\" He's not really listening to you. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

wheelbarrow: cartItem, sellable, hiddenItem
	rodRoom = true										// kludge
	sdesc = 
	{
		if ( frontWheel.broken ) 
			"busted ";
		"wheelbarrow";
	}
	ldesc = 
	{
		"This filthy beast from, apparently, the last century, has a busted 
		front wheel. ";
		
		if ( not frontWheel.broken )
		{
			"It's still a little wobbly, but the bolt is holding it tight. ";
		}
		if ( self.contentsVisible and itemcnt( self.contents ) != 0 )
		{
			"In "; self.thedesc; " %you% see%s%:\n "; 
			nestlistcont( self, 1 ); "\n";
		}
		else
		{
			"There's nothing in "; self.thedesc; ". ";
		}

	}
	noun = 'wheelbarrow' 'wheelb' 'wheelba' 'wheelbar' 'wheelbarr' 'wheelbarro'
			'barrow' 'barro' 'barr' 'wb' 'cart'
	adjective = 'filthy' 'beast'
	searchLoc = junk
	maxbulk = 150
	
	doMoveSW( actor ) = 
	{
		if ( ( actor.location = Pwoods ) && 
			( jug1.location = self || jug2.location = self || 
			jug3.location = self || jug4.location = self ) && 
			( frontWheel.broken ) )
		{
			"As you turn the heavily-laden wheelbarrow to swerve around
			the rock, the busted front wheel twists horribly, then 
			completely snaps off. ";
			
			self.broken := true;
			frontWheel.isListed := true;
			frontWheel.isfixed := nil;
			frontWheel.moveInto( self.location );
		}
		else pass doMoveSW;
	}
	verDoTake( actor ) =
	{
		if ( not global.wizard )
			"%You% can't pick up the wheelbarrow. It must weigh 100 pounds. ";
	}
	verDoPutOn( actor, io ) =
	{
		if ( io != platform && io != timeMachine )
			"%You% can't put <<self.thedesc>> on that. ";
	}
	verDoPull( actor ) = 
	{
		if ( self.location != platform )
			"You pull the wheelbarrow and it moves back a foot or two. Otherwise, 
			it has no useful effect. ";
	}
	doPull( actor ) =
	{
		"You pull the wheelbarrow off the platform. ";
		self.moveInto( platform.location );
	}
	
	verDoPush( actor ) = 
	{
		if ( self.broken )
			"The front wheel has snapped off, and you can no longer push
			<<self.thedesc>> around with you. ";
		else if ( Me.location = platform && self.location = platform )
		{
			"You push the wheelbarrow off the platform. ";
			self.moveInto( platform.location );
		}
		else
			"%You% seem able to push <<self.thedesc>> around with %you%. ";
	}
	
	verDoMove( actor ) =
	{
		if ( self.broken )
			"The front wheel has snapped off, and you can no longer move
			<<self.thedesc>> around with you. ";
		else
			"%You% seem able to move <<self.thedesc>> around with %you%. ";	
	}

	verDoMoveN( actor ) = 
	{
		if ( self.broken )
			"The front wheel has snapped off, and you can no longer move
			<<self.thedesc>> around with you. ";
	}
	verDoMoveS( actor ) =
	{
		if ( self.broken )
			"The front wheel has snapped off, and you can no longer move
			<<self.thedesc>> around with you. ";
	}
	verDoMoveE( actor ) =
	{
		if ( self.broken )
			"The front wheel has snapped off, and you can no longer move
			<<self.thedesc>> around with you. ";
	}
	verDoMoveW( actor ) =
	{
		if ( self.broken )
			"The front wheel has snapped off, and you can no longer move
			<<self.thedesc>> around with you. ";
	}
	verDoMoveNE( actor ) =
	{
		if ( self.broken )
			"The front wheel has snapped off, and you can no longer move
			<<self.thedesc>> around with you. ";
	}
	verDoMoveNW( actor ) =
	{
		if ( self.broken )
			"The front wheel has snapped off, and you can no longer move
			<<self.thedesc>> around with you. ";
	}
	verDoMoveSE( actor ) =
	{
		if ( self.broken )
			"The front wheel has snapped off, and you can no longer move
			<<self.thedesc>> around with you. ";
	}
	verDoMoveSW( actor ) =
	{
		if ( self.broken )
			"The front wheel has snapped off, and you can no longer move
			<<self.thedesc>> around with you. ";
	}
	
	sellToComment = 
	{
		"Say, this wheelbarrow is as ancient as Methuselah. ";
		if ( frontWheel.broken ) 
			"But the front wheel's shot. It'd be worth more if it were
			fixed. ";
	}
	sellValue = 
	{
		if ( frontWheel.broken )
			return( 35 );
		else
			return( 60 );
	}
	doSellTo( actor, io ) =
	{
		if ( itemcnt( self.contents ) != 0 )
		{
			"The merchant takes a glance at <<self.thedesc>> and says,
			\"Could I ask you to please take everything out of it? I 
			can't appraise it when it's carrying things.\" ";
			
			return( true );
		}
		else 
		{
			local yesno;
			
			"The merchant says, \""; self.sellToComment;
			
			"I'll give you $<<self.sellValue>> for it. Deal?\" \b>>";
			
			yesno := yorn();
		
			if ( yesno = 1 )
			{
				self.sold := true;
				self.moveInto( nil );
				wheelbarrow2.moveInto( antiqueStore );
				"The merchant pulls the wheelbarrow over to one side of the
				shop and says, \"All righty. Here you are. Thank you.\" ";
				handleMoneyTrade( playerCash, self.sellValue );
			}
			else
			{
				"The merchant says, \"Well, all right then. Have a nice day.\" ";
			}
			return( true );
		}
	}
		
	doFixWith -> frontWheel
	doSprayWith -> frontWheel
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Wheelbarrows can hold a lot of stuff. That's
				sort of what they're designed to do, after all.\" ";
				return( true );
			case Laura:
				"Laura says, \"If you need to move a lot of heavy stuff, 
				sure. Use a wheelbarrow if you have one.\" ";
				return( true );
			case Architect:
				"He says, \"Yes, wheelbarrows. Carting stuff around. Very
				fascinating.\" ";
				return( true );
			case antiqueMerchant:
				if ( self.sold )
					"She says, \"You can buy it back again if you want to.\" ";
				self.doSellTo( Me, who );
				return( true );
			default: 
				return( nil );
		}
	}
;

frontWheel: item
	isListed = nil
	isfixed = true
	sdesc = 
	{
		if ( self.broken ) 
			"busted ";
		"front wheel";
	}
	ldesc = 
	{
		if ( self.broken )
		{
			"It looks like you hit it on a rock and loosened the 
			bolt, as well as twisted the axle out of shape. ";
		}
		else
		{
			"It's still a little wobbly, but the bolt is holding it tight. ";
		}
	}
	noun = 'wheel' 'bolt'
	adjective = 'busted' 'front' 'axle' 'twisted' 'bolt' 'wobbly'
	location = wheelbarrow
	broken = true
	
	verDoTake( actor ) =
	{
		if ( not wheelbarrow.broken )
			"It's attached<<self.broken ? ", somewhat dodgily, to" : "to">>
			the wheelbarrow. ";
	}
	
	verDoFixWith( actor, io ) = 
	{
		if ( wheelbarrow.broken )
			"The front wheel of the wheelbarrow is completely beyond 
			repair now. ";
	}
	
	doBuy -> wheelbarrow
	doBuyFrom -> wheelbarrow
	doSell -> wheelbarrow
	doSellTo -> wheelbarrow
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sounds like you should fix the wheel before you
				try hauling something heavy in the wheelbarrow. Don't you have
				a screwdriver?\" ";
				return( true );
			case Laura:
				"Laura says, \"I don't really know much about fixing busted
				wheels, I'm afraid, but if you had the right tool you could
				probably do it.\" ";
				return( true );
			case Architect:
				"He says, \"If it isn't broken, don't fix it. Then again, if 
				it is broken, then do fix it.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

frisbee: throwable, hiddenItem
	sdesc = "frisbee"
	ldesc = 
	{
		"One of those little ones, for playing frisbee golf. ";
		if ( self.slobbery )
			" It's currently a bit slobbery. ";
	}
	noun = 'frisbee'
	searchLoc = junk
	slobbery = nil
	hasBlackiesInterest = nil
	
	doDrop( actor ) =
	{
		if ( Blackie.location = Me.location )
		{
			if ( rand( 2 ) = 1 )
				"You drop <<self.thedesc>>. \^<<Blackie.thedesc>> eyes it
				with interest. He sniffs at it, then puts his big slobbery
				jaw all over it. He gnaws at it for a moment, then pushes
				it back to you. As you pick the saliva-coated <<self.sdesc>> up, <<
				Blackie.thedesc>> wags his tail aggressively, his eyes 
				locked on <<self.itobjdesc>>. ";
			else
				"\^<<Blackie.thedesc>> chews at <<self.thedesc>> happily for
				a few moments, then nudges the slobbery thing back to you. ";
			
			self.getSlobbery;
			self.hasBlackiesInterest := true;
		}
		else pass doDrop;
	}
	
	verDoClean( actor ) = {}
	doClean( actor ) =
	{
		if ( !self.slobbery )
			"\^<<self.thedesc>> is cleaner now. ";
		else
		{
			"You take a moment and clean the slobber off of <<self.thedesc>>. ";
			self.slobbery := nil;
		}
	}
	
	verDoRoll( actor ) = {}
	doRoll( actor ) =
	{
		if ( Me.location = platform || Me.location = platform2 )
		{
			"You roll the frisbee. ";
			self.moveInto( Me.location.location );
		}
		else if ( Me.location = southOfHouse )
		{
			"You roll the frisbee. It follows the sloping ground
			and wobbles off into the woods. ";
			self.moveInto( woods );
		}
		else if ( Me.location = PsouthOfHouse )
		{
			"You roll the frisbee. It follows the sloping ground
			and wobbles off into the woods. ";
			self.moveInto( Pwoods );
		}
		else if ( Me.location = FsouthOfHouse )
		{
			"You roll the frisbee. It follows the sloping ground
			and wobbles off into the woods. ";
			self.moveInto( Fwoods );
		}
		else
		{
			"You roll the frisbee. It goes a short distance and then 
			wobbles flat. ";
			self.moveInto( Me.location );
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Hey, if you had a dog, you could play catch.\" ";
				return( true );
			case Laura:
				"Laura says, \"I used to love to play frisbee golf! Maybe we
				could play sometime. Wait, forget I said that. I'm not supposed
				to socialize with bank customers.\" ";
				return( true );
			case Architect:
				"He says, \"I don't have time for frisbees! Well, not during
				the work week, anyway.\" ";
				return( true );
			case Blackie:
				"\^<<who.thedesc>> regards <<self.thedesc>> with a keen
				canine interest. He wags his tail aggressively, his eyes
				locked on <<self.thedesc>>. ";
				self.hasBlackiesInterest := true;
				return( true );
			default: 
				return( nil );
		}
	}
;

cannonball: item, readable, sellable, hiddenItem
	sdesc = "cannonball"
	ldesc = "Who knows where you found this sucker, or why you kept it. It's a solid
			metal sphere, about 7 inches in diameter, with lettering stamped on the 
			side. "
	noun = 'cannonball' 
	adjective = 'cannon' 'ball' 'lettering' 'letter' 'solid' 'metal' 'sphere' 'orb'
	plural = 'letters'
	readdesc =
	{
		"154th comp. Div. -- US Steel --   TM 1880. ";
	}
	searchLoc = junk
	sellToComment = "Say, this cannonball is in good shape. "
	sellValue = 35
	
	verDoKick( actor ) =
	{
		"That would be a good way to break one of your toes. ";
	}
	
	doThrow( actor ) = 
	{
		"You throw the cannonball as hard as you can. It goes a negligible 
		distance and then lands with a heavy thump. ";
		
		if ( Me.location = platform )
			self.moveInto( Me.location.location );
		else
			self.moveInto( Me.location );
	}
	
	doDrop( actor ) =
	{
		local foo;
		
		switch( Me.location )
		{
			case northRoof:
				"You drop the cannonball, and it rolls off the roof ";
				foo := _rand( 2 );
				switch( foo )
				{
					case 1:
						"into the front of the house, where it thuds
						heavily to the ground. ";
						self.moveInto( frontOfHouse );
						return( nil );
					case 2:
						"into the back yard, where it thuds heavily to
						the ground. ";
						self.moveInto( behindHouse );
						return( nil );
				}
			case southRoof:
				"You drop the cannonball, and it rolls ";
				foo := _rand( 2 );
				switch( foo )
				{
					case 1:
						"off into the south of the house, where it hits
						the sloping ground and rolls into the woods. ";
						self.moveInto( woods );
						return( nil );
					case 2:
						"into into the gutter and stops with a clunk
						at the top of the drainpipe. ";
						self.moveInto( gutter2 );
						return( nil );
				}
			case FnorthRoof:
				"You drop the cannonball, and it rolls off the roof ";
				foo := _rand( 2 );
				switch( foo )
				{
					case 1:
						"into the front of the house, where it thuds
						heavily to the ground. ";
						self.moveInto( FfrontOfHouse );
						return( nil );
					case 2:
						"into the back yard, where it thuds heavily to
						the ground. ";
						self.moveInto( FbehindHouse );
						return( nil );
				}
			case southRoof:
				"You drop the cannonball, and it rolls ";
				foo := _rand( 2 );
				switch( foo )
				{
					case 1:
						"off into the south of the house, where it hits
						the sloping ground and rolls into the woods. ";
						self.moveInto( Fwoods );
						return( nil );
					case 2:
						"into into the gutter and stops with a clunk
						at the top of the drainpipe. ";
						self.moveInto( Fgutter2 );
						return( nil );
				}
		}
		pass doDrop;
	}
	
	verDoRoll( actor ) = {}
	doRoll( actor ) =
	{
		if ( Me.location = platform || Me.location = platform2 )
		{
			"You roll the cannonball onto the platform. ";
			self.moveInto( Me.location.location );
		}
		else if ( Me.location = northRoof || Me.location = southRoof || 
			Me.location = FnorthRoof || Me.location = FsouthRoof ) 
		{
			self.doDrop( actor );
		}
		else if ( Me.location = southOfHouse )
		{
			"You roll the cannonball. It follows the sloping ground
			and disappears into the woods. ";
			self.moveInto( woods );
		}
		else if ( Me.location = PsouthOfHouse )
		{
			"You roll the cannonball. It follows the sloping ground
			and disappears into the woods. ";
			self.moveInto( Pwoods );
		}
		else if ( Me.location = FsouthOfHouse )
		{
			"You roll the cannonball. It follows the sloping ground
			and disappears into the woods. ";
			self.moveInto( Fwoods );
		}
		else
		{
			"You roll the cannonball. It goes a negligible distance and then 
			stops. ";
			self.moveInto( Me.location );
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"All I know about cannonballs is that it's my
				favorite way to dive into a swimming pool.\" ";
				return( true );
			case Laura:
				"Laura says, \"Cannonballs are a bit out of my range of
				experience! Do people even use cannons any more? I thought
				they were only in old military museums.\" ";
				return( true );
			case Architect:
				"He says, \"Depending on when it was stamped, it could be
				a valuable collector's item.\" ";
				return( true );
			case squirrel:
				"The squirrel paces up the gutter and stands on the drainpipe
				spout, then comes back again. ";
				return( true );
			case antiqueMerchant:
				if ( self.boughtOnce )
					"She says, \"It's really a very nice piece.\" ";
				self.doSellTo( Me, who );
				return( true );
			default: 
				return( nil );
		}
	}
;

kitchenSink: staticItem, hiddenItem					// red herring
	herring = true
	isListed = true
	sdesc = "the kitchen sink"
	thedesc = "the kitchen sink"
	adesc = "the kitchen sink"
	ldesc = "Obviously, you must have found everything there is to find if you've 
			found this relic. "
	noun = 'sink'
	adjective = 'kitchen'
	searchLoc = junk
	
	verDoTake( actor ) = 
	{
		"%You% must be kidding. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"You know, I'm starting to think you're kind of 
				weird. No offense or anything.\" ";
				return( true );
			case Laura:
				"Laura laughs. ";
				return( true );
			case Architect:
				"He says, \"We're going for a high-necked faucet and a deep,
				squared off porcelain base.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

nothingElse: fixeditem, hiddenItem
	sdesc = "absolutely nothing else!  At last!!"
	adesc = "absolutely nothing else!  At last!!"
	searchLoc = junk
;
/******************************* END OF JUNK *******************************/	


southOfHouse: room
	ankle = nil
	sdesc = "South of house"
	ldesc = 
	{
		if ( bareSpot.location = self )
		{
			"You always thought this would be a nice place to plant a tree, but 
			a bare spot reminds you of your lack of foresight. ";
		}
		
		"The ground slopes down slightly here, and the wall of the house looms an extra 
		story high because of it. There is a tiny window high in the wall, about 
		30 feet up. "; 
		
		if ( tautRopeOutWindow.location = attic || looseRopeOutWindow.location = attic )
		{
			"There is a rope dangling from the window";
			if ( tautRopeOutWindow.location )
				", and a tire is tied to its bottom end";
			". ";
		}
	}
	xdesc = 
	{
		"A little path made by you on your many daily walks leads 
		southwest into the woods. You can walk around your house to the 
		northwest and northeast. ";
		
		if ( secretDoor.location && secretDoor.isopen )
			"A secret door is open to the north. ";
	}
	dispEndLdesc = 
	{	
		self.xdesc;
		
		if ( tree.location = self)
		{
			"\bA beautiful, leafy tree is growing here next to the house, right where 
			you always thought it should. ";
		}
		else if ( tinyTree.location = self )
		{
			"\bA scrawny, undernourished tree is growing here next to the house, right 
			where you always thought one should. The sad sight of this particular 
			specimen makes you think maybe you were wrong. ";
		}
	}
	noexit = 
	{
		if ( self.ankle )
		{
			"%You're% not going anywhere on a broken ankle. ";
			return( nil );
		}
		else
		{
			"%You% can't go that way. ";
			return( nil );
		}
	}
	nw =
	{
		if ( self.ankle )
			return( self.noexit );
		else
			return( behindHouse );
	}
	ne =
	{
		if ( self.ankle )
			return( self.noexit );
		else
			return( frontOfHouse );
	}
	sw = 
	{
		if ( self.ankle )
			return( self.noexit );
		else
			return( woods );
	}
	up =
	{
		if ( self.ankle )
			return( self.noexit );
		else
		{
			if ( tree.location )
				return( midTree );
			else if ( tinyTree.location )
			{
				tinyTree.verDoClimb( actor );
				return;
			}
			else
				"%You% can't go that way. ";
		}
	}
	north = 
	{
		if ( secretDoor.location )
			return( secretDoor );
		else
			return( self.noexit );
	}
	in = 
	{
		if ( secretDoor.location )
			return( secretDoor );
		else
			return( self.noexit );
	}
;

southOfHouseWindow: distantItem
	isfixed = nil
	sdesc = "tiny window"
	ldesc = 
	{
		if ( tautRopeOutWindow.location = attic || looseRopeOutWindow.location = attic )
		{
			"The little window is the one that leads into your attic. 
			There is a rope dangling from the window";
			if ( tautRopeOutWindow.location )
				", and a tire is tied to its bottom end";
			". ";
		}
		else
		{
			if ( self.describedOnce )
			{
				"The little window is the one that leads into your attic. 
				It's hard to judge from here, but it looks like you could 
				just fit through it. Getting all the way up to it is the 
				real problem. ";
			}
			else
			{
				"The little window is probably the one that leads into 
				your attic. It's hard to judge from here, but it looks 
				like you could just fit through it. Getting all the way 
				up to it is going to be the real problem. ";
				
				self.describedOnce := true;
			}
		}
	}
	
	noun = 'window'
	adjective = 'tiny' 'little'
	location = southOfHouse
	
	dobjGen( a, v, i, p ) =
	{
		if ( v != askVerb and v != tellVerb and v != inspectVerb and v != jumpVerb )
		{
			"\^<<self.itisdesc>> too far away.";
			exit;
		}
	}
	
	verDoLeapTo( actor ) = {}
	doLeapTo( actor ) =
	{
		"The little window is 30 feet up. You cannot reach it
		by jumping. ";
	}
	
	verIoThrowAt( actor ) = { self.verIoThrowIn( actor ); }
	ioThrowAt( actor, dobj ) = { self.ioThrowIn( actor, dobj ); }
	
	verIoThrowTo( actor ) = { self.verIoThrowIn( actor ); }
	ioThrowTo( actor, dobj ) = { self.ioThrowIn( actor, dobj ); }
	
	verIoThrowIn( actor ) = {}
	ioThrowIn( actor, dobj ) = 
	{
		"You take and and heave <<dobj.thedesc>> at the window. It 
		misses by a mile and falls to the ground. ";
		dobj.moveInto( southOfHouse );
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Hey, if you got up high enough you could jump
				to the window and climb in. That'd be really stupid and 
				dangerous, of course.\" He laughs. \"So, yeah, just kidding.\" ";
				return( true );
			case Laura:
				"Laura says, \"It's probably an attic window. You know, like
				just a vent for stuffy air.\" ";
				return( true );
			case Architect:
				"He says, \"Yes, yes, a little window in the attic on the 
				south side of the house. It's right here on the blueprint. 
				I don't miss a single detail.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

wall: secretDoorWall
	adjective = 'bare'
	myDoor = secretDoor
	mySwitch = secretSwitch
	location = southOfHouse
;

secretDoor: secretDoorItem
	mySwitch = secretSwitch
	myWall = wall
	otherside = interiorSecretPassageDoor
	doordest = secretPassage
;

secretSwitch: secretSwitchItem
	myWall = wall
	myDoor = secretDoor
;

decorationPath: fixedBlock
	sdesc = "path"
	noun = 'path'
	adjective = 'little'
	location = southOfHouse
;

bareSpot: fixedBlock
	sdesc = "bare spot"
	ldesc = "The bare spot reminds you that you always wished you'd planted a tree 
			here. Standing in the spot, your attention drifts to the equally bare 
			wall on this side of the house. "
	noun = 'spot'
	adjective = 'bare'
	location = southOfHouse
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"If you've always wanted a tree there, maybe you
				should plant one.\" ";
				return( true );
			case Laura:
				"Laura says, \"It's always sad to realize you should have done
				something a long time ago and didn't get around to it. I mean,
				what can you do? It's too late.\" ";
				return( true );
			case Architect:
				"He says, \"I don't know about planting a tree right there,
				frankly. During the kind of summer storms we get in this 
				area, you'd be in danger of having the tree fall onto the
				house, possibly causing a great deal of damage.\" ";
				return( true );
			case squirrel:
				"The squirrel clutches the acorn protectively. ";
				return( true);
			default: 
				return( nil );
		}
	}
;

tinyTree: staticItem
	sdesc = "scrawny tree"
	ldesc = "It's an embarassment. Scrawny, undernourished -- you name it. It is hardly 
			is the fine specimen you imagined would grow from that big fat acorn. "
	noun = 'tree' 'specimen'
	adjective = 'tiny' 'scrawny' 'puny' 'anemic' 'undernourished' 'undern' 'under' 'undernour'
	location = nil
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I bet some fertilizer would pump that baby
				right up.\" ";
				return( true );
			case Laura:
				"Laura says, \"Freshly-planted trees need tons of 
				nourishment. I mean, the more the better.\" ";
				return( true );
			case Architect:
				"He says, \"I don't know about planting a tree right there,
				frankly. During the kind of summer storms we get in this 
				area, you'd be in danger of having the tree fall onto the
				house, possibly causing a great deal of damage.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

tireSwing: item
	bulk = 2
	sdesc = "tire swing"
	ldesc = "It's a black rubber tire tied to a rope that's attached to a branch 
			mid-way up the tree, and suitable for swinging. "
	noun = 'swing'
	adjective = 'black' 'rubber' 'tire'
	location = nil
	
	verDoTake( actor ) = 
	{
		"(first untying the rope from the tire)\b

		It's too difficult to untie when it's dangling in the air. ";	   
	}
	
	verDoUntie( actor ) = 
	{
	   "It's too difficult to untie when it's dangling in the air. ";	   
	}
	
	verDoSwing( actor ) = {}
	doSwing( actor ) = 
	{
		"Wheee! ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Hey, tire swings. Cool. Well, if you're eight
				years old or something. Or if you're climbing down a rope
				and need to break your fall.\" ";
				return( true );
			case Laura:
				"Laura says, \"My grandmother had a swing like that in her
				yard. It was great. I used to climb up to the tree branch
				and then slide down, and the tire would catch me so that
				I wouldn't break an ankle.\" ";
				return( true );
			case Architect:
				"He snorts and continues working. \"Tire swings,\" he mutters. ";
				return( true);
			default: 
				return( nil );
		}
	}
;

distantBranch: distantItem
	sdesc = "branch"
	noun = 'branch'
	location = nil

;

swingRope: fixedBlock
	sdesc = "thick rope"
	ldesc = "It's a thick rope, about 22 feet long. It's tied to a tire and a
			branch. "
	noun = 'rope'
	adjective = 'thick'
	location = nil
	
	verDoClimb( actor ) =
	{
		"You struggle partway up the rope and then slip down again, giving your 
		hands a slight friction burn. ";
	}
	
	verDoUntie( actor ) = 
	{
	   "You can't untie the rope from down here on the ground. ";	   
	}

	verDoTake( actor ) = 
	{
	   "It's too difficult to untie when it's dangling in the air. ";	   
	}
	
	doSwing -> tireSwing
;

tree: staticItem
	sdesc = "beautiful tree"
	ldesc = "It's a whopper!"
	noun = 'tree'
	adjective = 'beautiful'
	location = nil
	
	verDoClimb( actor ) = 
	{
		if ( not southOfHouse.ankle )
			actor.travelTo( midTree );
		else
			return( southOfHouse.noexit );
	}
	
	verDoSwing( actor ) = 
	{
		if ( tireSwing.location = nil || tireSwing.location != self.location )
			"You can't do that without a tire swing. ";
	}
	doSwing( actor ) =
	{
		"Wheee! ";
	}
	
	askingAboutMe( who ) =
	{
		if ( self.location = nil )
			return( nil );
		
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I thought you said you forgot to plant a tree
				there. What are you, an amnesiac or a magician? No wait, don't
				answer that. I don't want to know.\" ";
				return( true );
			case Laura:
				"Laura says, \"Whoa. A big beautiful tree from nowhere. Well,
				great. Climb it!\" ";
				return( true );
			case Architect:
				"He says, \"It's a hazard, planting that tree so close to the
				house like that. If I were you, I wouldn't do it, but, hey, it's
				your future.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

midTree: treeRoom
	sdesc = 
	{
		if ( acornMound.groCount > 3 )
			"Mid-way up tree";
		else
			"Top of tree";
	}
	ldesc = 
	{
		if ( acornMound.groCount > 3 )
			"You are mid-way up the tree, which extends up another 15 feet. A strong 
			branch here extends horizontally from the trunk. ";
		else
		{
			"You are in the top of the tree. It is currently about ";
			say( ( acornMound.groCount * 5 ) + 10 );
			" feet tall. ";
		}

//		if ( ( brassPipe = rope.tieItem1 ) or ( brassPipe = rope.tieItem2 ) ) {}
	}
	xdesc = 
	{
		if ( acornMound.groCount > 3 )
			"You can climb even farther up from here, or back down to the ground. ";
		else
		{
			"There is nowhere to climb except back down to the ground. ";
		}
	}
	
	up = 
	{
		if ( acornMound.groCount > 3 )
			Me.travelTo( topOfTree );
		else
			"You can't climb any higher. ";
	}
	down = southOfHouse
;

branch: block
	sdesc = "strong branch"
	noun = 'branch'
	adjective = 'strong'
	location = midTree

	verIoTieTo( actor ) = {}
	ioTieTo( actor, dobj ) =
	{
		rope.ioTieTo( actor, self );
	}
;

rope: ropeItem
	sdesc = 
	{
		"thick rope";
		if ( self.tieItem1 )
		{
			" (tied to "; self.tieItem1.adesc;
			if ( self.tieItem2 )
			{
				" and to "; self.tieItem2.adesc;
			}
			")";
		}
	}
	ldesc = 
	{
		"It's a heavy-duty rope, about 22 feet long. ";
		if ( self.tieItem1 )
		{
			"It's tied to "; self.tieItem1.adesc;
			if ( self.tieItem2 )
			{
				" and to "; self.tieItem2.adesc;
			}
			". ";
		}
	}
	thedesc = "the thick rope"
	noun = 'rope'
	adjective = 'thick' 'heavy' 'duty' 'heavy-duty'
	location = nil
	tieItem1 = tireSwing
	tieItem2 = branch
		
	ioTieTo( actor, dobj ) = 
	{
		if ( dobj = Me )
		{
//			self.moveInto( Me );					// code originally allowed for this
//			pass ioTieTo;

			"There's no good way of tying yourself to the rope. ";
		}
		else if ( dobj = brassPipe or dobj = tire )
		{
	  		pass ioTieTo;
		}
		else if ( dobj = branch )
		{
	  		"There's no good way of retying the rope to the branch. ";
		}
		else
		{
	  		"There's no good way of tying that to the rope. ";
		}
	}

  	verDoUntie( actor ) = 
  	{
  		if ( ( self.tieItem1 = nil ) and ( self.tieItem2 = nil ) )
  			"The rope isn't tied to anything. ";
  	}
  	
  	disEngage( tied_obj ) =
  	{
  		if ( self.tieItem2 = branch )
  		{
  			"You untie the branch from the rope, and the rope and tire fall to
  			the ground with a thunk. ";
  			
  			distantTire.moveInto( nil );
  			tireSwing.moveInto( nil );
  			swingRope.moveInto( nil );

  			self.moveInto( southOfHouse );
  			tire.moveInto( southOfHouse );
  			self.tieItem1 := tire;
  			self.tieItem2 := nil;
  		}
  		else pass disEngage;
	}
	
	verDoThrowAt( actor, io ) = {}
	verDoThrowIn( actor, io ) = {}
	verDoThrowTo( actor, io ) = {}
	verDoSwing( actor ) = {}
	doSwing( actor ) =
	{
		if ( tieItem1 = tireSwing && tieItem2 = branch )
			"You can't swing on it from up here. ";
		else
			"You can't swing on it now that you've untied it. ";
	}
;

distantTire: distantItem
	bulk = 2
	sdesc = "tire"
	ldesc = "It's a black rubber tire, suitable for swinging. "
	noun = 'tire'
	adjective = 'black' 'rubber'
	location = nil
;

tire: item
	bulk = 2
	sdesc = "tire"
	ldesc = "It's a black rubber tire, suitable for swinging. "
	noun = 'tire'
	adjective = 'black' 'rubber'
	location = nil
	
	doTake( actor ) =
	{
		if ( ( rope.tieItem1 = self ) or ( rope.tieItem2 = self ) )
		{
			"(first untying the rope from the tire)\b";
			rope.disEngage( self );
		}
		pass doTake;
	}
	
	doDrop( actor ) =
	{
		if ( ( rope.tieItem1 = self ) or ( rope.tieItem2 = self ) )
		{
			"(first untying the rope from the tire)\b";
			rope.disEngage( self );
		}
		pass doDrop;
	}

	verDoThrowAt( actor, io ) = {}
	verDoThrowIn( actor, io ) = {}
	verDoThrowTo( actor, io ) = {}
	
	verIoTieTo( actor ) = {}
	ioTieTo( actor, dobj ) =
	{
		if ( dobj = rope )
		{
			rope.ioTieTo( actor, self );
		}
		else
			"I'm not sure how to tie that to <<self.thedesc>>. ";
	}
	
	verDoSwing( actor ) = 
	{
		"You can't swing on it now that you've untied it. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Tire, tire, burning bright, in the junkheap
				late at night... Oh, sorry.\" ";
				return( true );
			case Laura:
				"Laura says, \"Nice tire. Rubber and stuff.\" ";
				return( true );
			case Architect:
				"He sneezes. \"Excuse me,\" he says. \"I'm allergic to
				rubber.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

window2: distantItem
	isfixed = nil
	sdesc = "tiny window"
	ldesc = 
	{
		"It's still a little far away from here, but you could definitely fit 
		through it. ";

		if ( tautRopeOutWindow.location = attic || looseRopeOutWindow.location = attic )
		{
			"There is a rope dangling from the window";
			if ( tautRopeOutWindow.location )
				", and a tire is tied to its bottom end";
			". ";
		}
	}
	noun = 'window'
	adjective = 'tiny' 'little'
	location = midTree

	verDoLeapTo( actor ) = {}
	doLeapTo( actor ) =
	{
		"You leap out of the tree and don't even come close to reaching the window. 
		Fortunately, you land on your feet, none the worse for wear.\b";
				
		actor.travelTo( southOfHouse );
	}
	
	verIoThrowAt( actor ) = { self.verIoThrowIn( actor ); }
	ioThrowAt( actor, dobj ) = { self.ioThrowIn( actor, dobj ); }
	
	verIoThrowTo( actor ) = { self.verIoThrowIn( actor ); }
	ioThrowTo( actor, dobj ) = { self.ioThrowIn( actor, dobj ); }
	
	verIoThrowIn( actor ) = {}
	ioThrowIn( actor, dobj ) = 
	{
		"You take and and heave <<dobj.thedesc>> at the window. It 
		misses by a mile and falls to the ground. ";
		dobj.moveInto( southOfHouse );
	}
;

dummyTreeItem: fixedBlock
	sdesc = "tree"
	noun = 'tree'
	location = midTree
	
	verDoClimb( actor ) = {}
	doClimb( actor ) = 
	{
		if ( acornMound.groCount > 3 )
			Me.travelTo( topOfTree );
		else
			"You can't climb any higher. ";
	}

	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) = { actor.travelTo( southOfHouse ); }
;

topOfTree: treeRoom
	sdesc = "Treetop"
	ldesc = 
	{
		"You're as high in the tree as your weight will let you climb. The view from 
		here is incredible. The window in the side of the house is right in front of 
		you to the north. ";
		
//		if ( brassPipe = ( rope.tieItem1 or rope.tieItem2 ) ) {}
	}
	
	down = midTree
	up = "You can't climb any higher. "
	north = "The window seems to be a little farther away than you thought. If you leap  
			to it, you might just make it. "
	firstseen =
	{
		"\bYou are surprised and somewhat amused to see the rare book
		nestled within the branches of the tree. The squirrel must have 
		been here recently. ";
		
		rareBook.moveInto( self );
	}
	roomAction(a, v, d, p, i) =
	{
		if ( v = throwVerb && d )
		{
			if ( i = nil )
			{
				"(in <<window3.thedesc>>)\n";
				window3.ioThrowIn( a, d );
			}
			else
			{
				if ( i = window3 )
				{
					i.ioThrowIn( a, d );
				}
				else if ( i = Me )
				{
					"You can't throw things <<p.sdesc>> yourself";
					if ( p = inPrep || p = outPrep )
						", whatever that means";
					". ";
				}
				else
				{
					"You miss your target, and <<d.thedesc>> clatters 
					from branch to branch down to the ground. ";
					d.moveInto( southOfHouse );
				}
			}
			exit;
		}
		else pass roomAction;
	}
;

incredibleView: fixedBlock, distantItem
	sdesc = "view"
	ldesc = "From here you can see far and wide over the other trees. In the distance
			the shopping village is just visible. "
	noun = 'view'
	adjective = 'incredible' 'shopping' 'village'
;

dummyTree2: fixedBlock
	sdesc = "branches"
	ldesc = 
	{
		if ( rareBook.location = topOfTree ) 
			"Nestled within the branches is the rare book you gave to
			the squirrel. ";
		else
			pass ldesc; 
	}
	noun = 'branch' 
	plural = 'branches'
	isThem = true
	location = topOfTree

	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) = { actor.travelTo( midTree ); }
	
	verDoClimb( actor ) = 
	{
		"You can't climb any higher. ";
	}
	
	verIoPutIn( actor ) = {}
	ioPutIn( actor, dobj ) =
	{
		if ( dobj = rareBook )
		{
			"You attempt to put the rare book back into the branches but,
			because you lack a squirrel's skill at such things, it slips out 
			and falls all the way down to the ground. ";
		}
		else
		{
			"You attempt to put <<dobj.thedesc>>";
			
			if ( dobj = rareBook ) " back";
			
			" into the branches, but <<dobj.itnomdesc>> slip";
			
			if ( not dobj.isThem ) "s"; 
			
			" out and fall";
			
			if ( not dobj.isThem ) "s";
			
			" all the way down to the ground. ";
		}
			
		dobj.moveInto( southOfHouse );
	}
;

window3: distantItem
	isfixed = nil
	sdesc = "tiny window"
	ldesc = 
	{
		"It's tantalizingly out of reach, but if you leap for it, you might 
		just make it. ";

		if ( tautRopeOutWindow.location = attic || looseRopeOutWindow.location = attic )
		{
			"There is a rope dangling from the window";
			if ( tautRopeOutWindow.location )
				", and a tire is tied to its bottom end";
			". ";
		}
	}
	noun = 'window'
	adjective = 'tiny' 'little'
	location = topOfTree
	leaptOnce = nil
	
	verDoTake( actor ) =
	{
		"It's just out of reach. ";
	}
	
	doSynonym('LeapTo') = 'Board' 'Enter'
	
	verDoLeapTo( actor ) = {}
	doLeapTo( actor ) = 
	{
		local i, lst, len;
		
		if ( self.leaptOnce )
		{
			"Not a chance. You're lucky you made it the first time. ";
		}
		else if ( acornMound.groCount = 4 )
		{
			"The window is still a little too far away, I'm afraid. I bet one 
			more jug of miracle-grow would do the trick. Maybe it's worth 
			checking the work shed again. ";
		}
		else if ( acornMound.groCount = 5 )
		{
			"You make your leap of faith. Your hands find a firm grip on the sill 
			and you pull yourself in. Unfortunately, you drop all of your 
			possessions in the process.\b";
			
			actor.travelTo( attic );
			incscore( 10 );
			global.scoreCard[15] := 1;
			self.leaptOnce := true;
			
			lst := actor.contents;
			len := length(lst);
			for (i := 1 ; i <= len ; ++i)
				lst[i].moveInto( southOfHouse );
		}
	}
	
	verIoThrowAt( actor ) = { self.verIoThrowIn( actor ); }
	ioThrowAt( actor, dobj ) = { self.ioThrowIn( actor, dobj ); }
	
	verIoThrowTo( actor ) = { self.verIoThrowIn( actor ); }
	ioThrowTo( actor, dobj ) = { self.ioThrowIn( actor, dobj ); }
	
	verIoThrowIn( actor ) = {}
	ioThrowIn( actor, dobj ) = 
	{
		if ( ( dobj = tire ) or ( dobj = rope ) )
		{
			if ( tire = rope.tieItem1 || tire = rope.tieItem2 )
			{
				"You take aim and heave. The rope and tire disappear
				inside the window. ";
				tire.moveInto( attic );
				rope.moveInto( attic );
			}
			else
			{
				"You take aim and heave <<dobj.thedesc>> into the window. It 
				disappears inside. ";
				dobj.moveInto( attic );
			}
		}
		else if ( isclass( dobj, throwable) )
		{
			"You take aim and throw <<dobj.thedesc>> into the window. It 
			disappears inside. ";
			dobj.moveInto( attic );
		}
		else
		{
			"You take and and heave <<dobj.thedesc>> at the window. It 
			misses by a mile and falls to the ground. ";
			dobj.moveInto( southOfHouse );
		}
	}
	
	askingAboutMe( who ) =
	{
		if ( global.scoreCard[14] = 0 )
			return( nil );
		
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I've got a suggestion, but it depends how
				much of a risk-taker you are. If it were me, and I'm glad
				it isn't, I'd climb up as high as I could in the tree, and
				I'd make a jump for the window. At least maybe you'd get in
				your house that way.\" ";
				return( true );
			case Laura:
				"Laura says, \"Oh, you wouldn't want my suggestion. You'd
				have to be crazy to try leaping to the window from up high
				in the tree.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

attic: room
	sdesc = "Attic"
	ldesc = "This is a little attic space, barely tall enough for you to stand in. Thick 
			boards run in parallel lines along the floor, with pink insulation
			laid out in between. A thick brass pipe passes up from the floor next 
			to the window and continues up through the ceiling. Cardboard packing 
			boxes of various sizes are stacked along the walls. A folded-up ladder 
			attached to a hatch would lead down if it were open, but it's closed. "
	xdesc = "The only exit is the little window you came in. "
	smellDesc = "The attic smells of must and dust. "	
	
	south = "The tree is too far away to risk jumping back to. "
	down = 
	{
		if ( rope.tieItem1 = brassPipe || rope.tieItem2 = brassPipe )
		{
			"(down the rope)\n";
			if ( tautRopeOutWindow.location = nil && 
				looseRopeOutWindow.location = nil )
			{
				"(first dropping the rope out the window)\n";
				atticWindow.ioThrowOut( actor, rope );
				"\b";
			}
			"You shimmy down the rope. After a few feet, your hands lose 
			their grip and you plummet. ";
			
			if ( tautRopeOutWindow.location = self )
			{
				"Fortunately, the tire breaks your fall.\b";
				return( dangling );
			}
//			else if ( ( rope.tieItem1 = Me ) or ( rope.tieItem2 = Me ) )
//			{
//				"The rope cinches tight around your middle, squeezing the 
//				breath out of you. With a snap, your entire weight is 
//				stopped from falling by the rope, and the knot doesn't 
//				hold under the strain. It slips open and you fall to 
//				the ground at an awkward angle. In trying to land on 
//				your feet, you end up breaking your ankle. \b";
//				
//				southOfHouse.ankle := true;
//				return( southOfHouse );
//			}
			else
			{
				"The ground breaks your fall, and quite nearly your ankle.\b";
				return( southOfHouse );
			}
		}
		else
			"You're too high up to jump down from here. You'll have to
			find safe way to climb down to the ground. ";
	}
;

floorboards: unimportantItem
	sdesc = "floorboards"
	ldesc = "Thick floorboards run in parallel lines, with pink insulation
			laid out in between. "
	noun = 'floorboard'
	plural = 'floorboards'
	isThem = true
	location = attic
;

pinkInsulation: unimportantItem
	sdesc = "pink insulation"
	ldesc = "The insulation is made of pink fiberglass. "
	noun = 'insulation'
	adjective = 'pink' 'fiber' 'fiberglass' 'fibre' 'fibreglass'
	location = attic
;

hatchLadder: staticItem
	sdesc = "hatch ladder"
	ldesc = "I see nothing special about the closed hatch ladder. "
	
	noun = 'ladder'
	adjective = 'hatch'
	location = attic
	
	verDoOpen( actor ) = 
	{
		"You can't open the hatch ladder from inside the attic. You have
		to pull it open from below. ";
	}
	verDoStandon( actor ) = 
	{
		"You carefully shift your weight onto the hatch ladder. Nothing
		happens, and you step off again, thanking yourself that your
		stupidity wasn't rewarded by having the hatch spring open, 
		sending you tumbling down, most likely breaking your neck in
		the process. ";
	}
	verDoSiton( actor ) = 
	{
		"You carefully shift your weight onto the hatch ladder. It 
		remains fixed in place. ";
	}
	verDoJumpOn( actor ) = 
	{
		"You throw all common sense to the winds and jump forcefully
		onto the hatch ladder. Fortunately, it barely moves. You 
		could have twisted your ankle or possibly broken your
		neck. ";
	}
	verDoPush( actor ) =
	{
		"You can't push open the hatch ladder from inside the attic. You have
		to pull it open from below. ";
	}
	verDoClose( actor ) = 
	{
		"The hatch ladder is already closed. ";
	}
	verDoPull( actor ) = 
	{
		"The hatch ladder is already closed. ";
	}
;

atticWindow: block, seeThruItem
	sdesc = "little window"
	ldesc = "Out the window you see the tree and the ground far below. "
	thrudesc = { self.ldesc; }
	noun = 'window'
	adjective = 'little' 'attic'
	location = attic
	
	doLeapTo -> treeView
	
	ioSynonym('ThrowOut') = 'PutIn'
	
	verIoThrowOut( actor ) = {}
	ioThrowOut( actor, dobj ) = 
	{
		switch( dobj )
		{
			case tennisBall:
				"The tennis ball hits the ground with a satisfying
				thwocking noise and then bounces away into the backyard. ";
				tennisBall.moveInto( behindHouse );
				break;
			case bluePencil:
				"The blue pencil falls to the hard ground below. ";
//	There might be something about breaking the point on it and having
//	to sharpen it.
				bluePencil.moveInto( southOfHouse );
				break;
			case unbrokenLamp:
				"The lamp falls to the hard ground below with a loud
				cracking noise, yet remains miraculously intact. It's 
				definitely a broken lamp now, though. ";
				unbrokenLamp.moveInto( nil );
				brokenLamp.moveInto( southOfHouse );
				break;
			case tire:
				if ( ( rope.tieItem1 = tire ) or ( rope.tieItem2 = tire ) )
				{
					if ( ( rope.tieItem1 = brassPipe ) or ( rope.tieItem2 = brassPipe ) )
					{
						"You throw tire out the window. It comes to a yanking
						halt, the brass pipe holding the rope taut. Going down 
						now might be safe. ";
						tire.moveInto( nil );
						rope.moveInto( nil );
						rope.tieItem1 := nil;
						rope.tieItem2 := nil;
						tautRopeOutWindow.moveInto( attic );
					}
					else
					{
						"You throw the tire out the window. It yanks the
						rope out with it. They both plop onto the ground, 
						the tire bouncing a bit before the rope makes it 
						settle down. ";
						tire.moveInto( southOfHouse );
						rope.moveInto( southOfHouse );
						rope.tieItem1 := tire;
						rope.tieItem2 := nil;
					}
				}
				else
				{
					"You throw the tire out the window. It bounces and
					rolls, disappearing through the woods. ";
					tire.moveInto( clearing );
				}
				break;
			case rope:
				if ( ( rope.tieItem1 = brassPipe ) or ( rope.tieItem2 = brassPipe ) )
				{
					if ( ( rope.tieItem1 = tire ) or ( rope.tieItem2 = tire ) )
					{
						"You throw the rope and tire out the window. It comes 
						to a yanking halt, the brass pipe holding the rope taut.
						Going down now might be safe. ";
						tire.moveInto( nil );
						rope.moveInto( nil );
//						rope.tieItem1 := nil;
//						rope.tieItem2 := nil;
						tautRopeOutWindow.moveInto( attic );
					}
					else
					{
						"You throw the free end of the rope out the window. It
						doesn't reach all the way down to the ground. ";
						rope.moveInto( nil );
//						rope.tieItem1 := nil;
//						rope.tieItem2 := nil;
						looseRopeOutWindow.moveInto( attic );
					}
				}
				else
				{
					if ( ( rope.tieItem1 = tire ) or ( rope.tieItem2 = tire ) )
					{
						"You throw the rope and tire out the window. They 
						plop onto the ground, the tire bouncing and rolling. ";
						tire.moveInto( southOfHouse );
						rope.moveInto( southOfHouse );
						rope.tieItem1 := tire;
						rope.tieItem2 := nil;
					}
					else
					{
						"You throw the rope out the window. It
						plops onto the ground below. ";
						rope.tieItem1 := nil;
						rope.tieItem2 := nil;
					}
				}
				break;
			default: 
				"Throwing things out of windows will get you
				nowhere. ";
				break;
		}
	}
	verDoUnboard( actor ) =
	{
		if ( looseRopeOutWindow.location = nil && 
			tautRopeOutWindow.location = nil )
			"You're too high up. If you jump down you'll break your ankle. ";

	}
	doUnboard( actor ) =
	{
		Me.travelTo( self.location.down );
	}
;

looseRopeOutWindow: item
	sdesc = "rope (tied to the brass pipe)"
	ldesc = "The rope is tied to the brass pipe, the other end dangling out
			the attic window. "
	noun = 'rope'
	location = nil
	
	verDoTieTo( actor, io ) = 
	{
		if ( io = self )
			"There's no point in tying the rope to itself. ";
		else
			"You can't tie anything else to the rope unless you either untie
			it from the brass pipe or pull the loose end back in. ";
	}

	verIoTieTo( actor ) = 
	{
		"You can't tie anything else to the rope unless you either untie
		it from the brass pipe or pull the loose end back in. ";
	}
	
  	verDoUntie( actor ) = {}
	doUntie( actor ) = 
  	{
		"You untie the rope from the brass pipe. It immediately slides
		out the window, and lands with a plop. ";
		self.moveInto( nil );
		rope.moveInto( southOfHouse ); 
  	}
  		
	verDoPull( actor ) = {}
	doPull( actor ) =
	{
		self.doTake( actor );
	}
	
	verDoTake( actor ) = {}
	doTake( actor ) =
	{
		"You pull the loose end of the rope back in. ";
		self.moveInto( nil );
		rope.moveInto( Me );
		rope.tieItem1 := brassPipe;
		rope.tieItem2 := nil;
	}
	
	verDoClimb( actor ) = {}
	doClimb( actor ) = { self.doClimbDown( actor ); }
	
	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) =
	{
		"You shimmy down the rope. After a few feet, your hands lose their grip and 
		you plummet. The ground breaks your fall, and quite nearly your ankle.\b";
		
		Me.travelTo( southOfHouse );
	}
;

tautRopeOutWindow: item
	sdesc = "rope (tied to the brass pipe)"
	ldesc = "The rope is tied to the brass pipe, the other end dangling out
			the attic window. "
	noun = 'rope'
	location = nil
	
	verDoTieTo( actor, io ) = 
	{
		if ( io = self )
			"There's no point in tying the rope to itself. ";
		else
			"You can't tie anything else to the rope unless you either untie
			it from the brass pipe or pull the loose end back in. ";
	}

	verIoTieTo( actor ) = 
	{
		"You can't tie anything else to the rope unless you either untie
		it from the brass pipe or pull the loose end back in. ";
	}
	
  	verDoUntie( actor ) = {}
	doUntie( actor ) = 
  	{
		"You untie the rope from the brass pipe. It immediately slides
		out the window, and lands with a plop. ";
		self.moveInto( nil );
		rope.moveInto( southOfHouse ); 
  	}
  		
	verDoPull( actor ) = {}
	doPull( actor ) =
	{
		self.doTake( actor );
	}
	
	verDoTake( actor ) = {}
	doTake( actor ) =
	{
		"You pull the tire back up. ";
		self.moveInto( nil );
		rope.moveInto( Me );
		tire.moveInto( Me );
		rope.tieItem1 := brassPipe;
		rope.tieItem2 := tire;
	}
	
	verDoClimb( actor ) = {}
	doClimb( actor ) = { self.doClimbDown( actor ); }
	
	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) =
	{
		"You shimmy down the rope. After a few feet, your hands lose their grip and 
		you plummet. Fortunately, the tire breaks your fall.\b";
		Me.travelTo( dangling );
	}
;

treeView: distantItem
	sdesc = "tree"
	noun = 'tree'
	location = attic
	
	verDoLeapTo( actor ) = 
	{
		"The tree is too far away to risk leaping back to. If you jump 
		you'll break your ankle. ";
	}
;

cardboardBoxes: qcontainer, block
	noun = 'box'
	plural = 'boxes'
	isThem = true
	adjective = 'cardboard'
	sdesc = "cardboard boxes"
	adesc = { self.sdesc; }
	location = attic
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Buncha boxes. Looked in 'em? Might be something
				useful in there.\" ";
				return( true );
			case Laura:
				"Laura says, \"You never know what you'll find in an old box
				in the attic.\" ";
				return( true );
			case Architect:
				"He ignores you and keeps working. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

unbrokenLamp: item
	herring = true											// red herring
	sdesc = "desk lamp"
	ldesc = "This old desk lamp seems to be missing its power
			cord. It would fit right in with the other junk in the 
			garage. "
	noun = 'lamp'
	adjective = 'old' 'desk'
	location = cardboardBoxes
	
	verDoRub( actor ) =
	{
		"You rub the lamp. Nothing happens. It is just an ordinary
		desk lamp. ";
	}
;

brokenLamp: item
	herring = true											// red herring
	sdesc = "broken lamp"
	ldesc = "The base is savagely cracked and the power cord is missing. "
	noun = 'lamp'
	adjective = 'broken'
	location = nil
	verDoRub( actor ) =
	{
		"You rub the lamp. Nothing happens. It is just an ordinary,
		broken desk lamp. ";
	}
;

bluePencil: pencilItem
	sdesc = "blue pencil"
	ldesc = 
	{
		"It's a moderately sharp pencil, made for drawing blue lines. ";
		inherited.ldesc;
	}
	noun = 'pencil'
	adjective = 'blue'
	location = cardboardBoxes
	
	ioDrawOnWith( actor, dobj ) =
	{
		if ( dobj = blueprint ) 
		{
			if ( not self.saidOnce ) 
			{
				self.saidOnce := true;
				"You poise the blue pencil over the blueprint, ready to draw
				something new on it. [Try: DRAW (SOMETHING) ON BLUEPRINT.] ";
			}
			else 
				"You'll have to specify what you want to draw on the blueprint. ";
		}
		else 
			"The blue pencil isn't very good for drawing on <<dobj.thatdesc>>. ";
	}
	saidOnce = nil
	
	askingAboutMe( who ) =
	{
	  switch( who )	 // matches with NPC class objects
	  {
		 case Fred:
		 	"Fred says, \"Blue pencil. Hey, isn't that what architects
		 	use? For drawing on blueprints? Yeah.\" ";
			return( true );
		 case Laura:
		 	"Laura says, \"Those are good for sketching.\" ";
			return( true );
		 case Architect:
		 	"He says, \"Blue pencils, yes. For drawing on blueprints,
		 	yes. I already have my own, thank you.\" ";
			return( true );
		default: 
			return( nil );
	  }
   }
;

brassPipe: staticItem
	sdesc = "pipe"
	ldesc = "It's sturdy, all right. "
	noun = 'pipe'
	adjective = 'brass'
	location = attic

	verIoTieTo( actor ) = {}
	ioTieTo( actor, dobj ) =
	{
		if ( dobj = rope )
		{
			rope.ioTieTo( actor, self );
		}
		else
			"I'm not sure how to tie that to <<self.thedesc>>. ";
	}
;

dangling: room
	sdesc = "Dangling in the air"
	ldesc = "You are dangling on the tire swing about eight feet off the ground. The 
			window is about 20 feet above you. Apart from feeling a little foolish, 
			you're doing all right. "
	xdesc = "You can safely jump down from here, or climb up to the attic. "
	up = 
	{
		if ( not self.climbedOnce )
		{
			"You shimmy up the rope a few feet, but lose your grip and plummet 
			back down to the relative safety of the tire swing. Apart from a rope 
			burn, you're still okay. Trying again, you successfully clamber into
			the attic. \b";
			
			self.climbedOnce := true;
		}
		else
			"You clamber up the rope into the attic. ";
		
		return( attic );
	}
	down =
	{
		"You leap from the tire swing and land with cat-like grace. A clumsy, 
		two-legged cat, but there you go. \b";
		
		Me.travelTo( southOfHouse );
		dummyRope2.moveInto( southOfHouse );
		dummyTire2.moveInto( southOfHouse );
	}
	firstseen = 
	{
		incscore( 1 );
		global.scoreCard[16] := 1;
	}
;

window4: distantItem
	sdesc = "tiny window"
	ldesc = "It's a little over 20 feet above you. The rope stretches up into it. "
	noun = 'window'
	adjective = 'tiny' 'little'
	location = dangling
	
	verDoClimb( actor ) = {}
	doClimb( actor ) = { Me.travelTo( dangling.up ); }
	doSynonym('Climb') = 'Board' 'Enter'
;

danglingRope: fixedBlock
	sdesc = "thick rope"
	ldesc = "It's a heavy-duty rope, about 25 feet long. The bottom is tied to a tire, 
			and the top vanishes into the little window. "
	noun = 'rope'
	adjective = 'thick' 'heavy' 'duty' 'heavy-duty'
	location = dangling
	
	verDoClimb( actor ) = {}
	doClimb( actor ) = { Me.travelTo( dangling.up ); }
	
	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) = 
	{
		"You leap from the tire swing and land with cat-like grace. A clumsy, 
		two-legged cat, but there you go. \b";
		
		Me.travelTo( southOfHouse );
		dummyRope2.moveInto( southOfHouse );
		dummyTire2.moveInto( southOfHouse );
	}
	
	verDoUntie( actor ) =
	{
		"I wouldn't do that if I were you. ";
	}
	
	verDoUnboard( actor ) = {}
	doUnboard( actor ) = { self.doClimbDown( actor ); }
;

danglingTire: fixedBlock
	sdesc = "tire"
	ldesc = "It's a black rubber tire, suitable for swinging. "
	noun = 'tire'
	adjective = 'black' 'rubber'
	location = dangling
	
	doUntie -> danglingRope
	doClimbDown -> danglingRope
	doUnboard -> danglingRope
;

dummyRope2: fixedBlock
	sdesc = "thick rope"
	ldesc = "It's a heavy-duty rope, about 25 feet long. The bottom is tied to a tire, 
			and the top vanishes into the little window. "
	noun = 'rope'
	adjective = 'thick' 'heavy' 'duty' 'heavy-duty'
	
	dobjGen( a, v, i, p ) =
	{
		if ( v != askVerb and v != tellVerb and v != inspectVerb and v != jumpVerb )
		{
			"\^<<self.itisdesc>> too high up.";
			exit;
		}
	}
	
	doLeapTo -> dummyTire2
;

dummyTire2: fixedBlock
	sdesc = "tire"
	ldesc = "It's a black rubber tire, tied to the bottom of the rope. "
	noun = 'tire'
	adjective = 'black' 'rubber'
	
	doUntie -> danglingRope
	
	verDoClimb( actor ) = { self.verDoLeapTo( actor ); }
	doClimb( actor ) = { self.doLeapTo( actor ); }
	
	verDoLeapTo( actor ) = 
	{
		if ( southOfHouse.ankle )
			return( southOfHouse.noexit );
	}
	doLeapTo( actor ) =
	{
		"You jump up, snag the bottom of the tire, and scramble up. \b";
		Me.travelTo( dangling );
	}
;

/*	The special thing about this room is that it's the only other one from which
 *	you are able to hear the time machine appear. The rock is also a permanent
 *  landmark on the various maps, and a good place to think.
*/
woods: room
	sdesc = "Path in the woods"
	ldesc = "This little spot is one of your favorite places to sit and think.  
			A well-trod path winds through a natural grove of cedar and live oak trees. 
			A large rock juts up out of the ground right in your way, so the path 
			does an abrupt curve around it. "
	xdesc = "The path leads northeast to your house, and a clearing is visible to 
			the southwest. "
	ne = southOfHouse
	sw = clearing
;

grove: block, floatingItem
	sdesc = "grove of cedar and live oak trees"
	noun = 'grove' 'tree' 
	plural = 'trees'
	adjective = 'cedar' 'oak' 'live' 'natural'
	location = 
	{
		switch( Me.location )
		{
			case woods:
			case Pwoods:
			case FPwoods:
			case FPclearing:
				return( Me.location );
			default:
				return( nil );
		}
	}
;

woodpath: staticItem
	sdesc = "well-trod path"
	ldesc = "The path does an abrupt curve around the large rock. "
	noun = 'path'
	adjective = 'well-trod' 'well' 'trod'
	location = woods
;

/*	The rock serves as a familiar landmark as the player jumps through time.
*/	
rock: chairitem
	sdesc = "large rock"
	ldesc = "The rock is a five foot grey boulder, almost egg-shaped, 
		a single piece of heavy, textured granite. Polished smooth over
		time, a wedge shape sheared from the top ages ago provides a
		comfortable place to sit. "
	noun = 'rock' 'boulder' 'stone'
	adjective = 'large' 'wedge' 'shape' 'chipped' 'chip' 'top' 'granite'
				'heavy' 'textured'
	
	location = woods
	ne = { self.getOff; return( self.location.ne ); }
	sw = { self.getOff; return( self.location.sw ); }
	noexit = { self.getOff; return( self.location.noexit ); }
	isdroploc = true
	statusPrep = "on"
	outOfPrep = "off of"
	
	getOff = 
	{
		if ( Me.location = self )
		{
			"You get off the rock.\n ";
			Me.moveInto( self.location );
		}
	}
	verDoStandon( actor ) = { self.verDoSiton( actor ); }
	doStandon( actor ) =
	{
		"You stand up on top of the rock. The view isn't much better, but
		it is very serene and peaceful. ";
		actor.moveInto( self );
	}
	verDoSiton( actor ) = 
	{
		if ( actor.location = self )
			"You are already on the rock. ";
	}
	doSiton( actor ) =
	{
		"You sit down on top of the rock. It is very serene and peaceful. ";
		Me.moveInto( self );
	}
	
	verDoTake( actor ) =
	{
		"The rock is made of solid granite and conservatively weighs
		one and a half tons. You are unable to move it. ";
	}
	verDoMove( actor ) = { self.verDoTake( actor ); }
	verDoPush( actor ) = { self.verDoTake( actor ); }
	verDoPull( actor ) = { self.verDoTake( actor ); }
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sometimes it's nice to have a big ol' rock to
				sit on when you need to think.\" ";
				return( true );
			case Laura:
				"Laura says, \"That sounds like a great spot to sit and 
				meditate.\" ";
				return( true );
			case Architect:
				"He says, \"Ah yes, that old rock just down in the woods. I made
				a special point of preserving it. It would have been such a 
				shame to blast it. I've made something of a habit of taking 
				walks down there to clear my head and think.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

/*  The clearing: present-day.
 *
 *	This is the room where the time machine appears, and since it moves only in time,
 *	not space, a similar clearing is seen as the player uses it to travel.
 *
 *  Just to be exciting, it takes a few turns for it to materialize, but only after
 *	the player has visited the clearing twice. A counter is started on the second 
 *	visit, which is a daemon counter that displays a different message each turn.
 *	The player has to stay in the room to see the messages.
 */
clearing: room
	sdesc = "Clearing"
	ldesc = "The woods part in a marvelous natural clearing here. Moonlight streams prettily 
			through the canopy of leaves above. The ground is hard and flat and clean. "
	xdesc = "Your footpath leaves the clearing to the northeast, heading back to the
			house. "
	ne = woods
	secondTime = 0
	ozone = nil
	firstseen = 
	{
		"\bThere is a warmth to the air you don't recognize. ";
	}
	
	enterRoom( actor ) =				// sent to room as actor is entering it
	{
		self.lookAround(( not self.isseen ) or global.verbose );
		secondTime++;
		if ( self.islit )
		{
			if ( not self.isseen )						// if this is the first visit
				self.firstseen;
	  		self.isseen := true;
	  	}
		if ( secondTime = 2 )							// if this is the 2nd visit
			setdaemon( timemachineDaemon, nil );		//  start the counter
	}
	
	doSmell -> air
;

dummyClearingItem: locationDesc
	sdesc = "clearing"
	adjective = 'clearing'
	location = clearing
;

prettyLight: fixedBlock
	sdesc = "light"
	ldesc = 
	{
		switch( self.isWeird )
		{
			case 0:
				"Moonlight streams prettily through the canopy of leaves above. ";
				break;
			case 1:
				"The light is blindingly bright, and seems to be coming from a 
				disturbance of the air in the middle of the clearing. ";
				break;
			case 2:
				"The light filters down from above through the haze and 
				ripple of ozone. ";
				break;
		}
	}
	noun = 'light' 'flare' 'flash' 'eruption'
	adjective = 'blinding' 'blindingly' 'bright' 'yellow' 'prettily' 'pretty' 'streams'
			'stream' 'haze' 'ripple' 'center' 'middle'
	location = clearing
	isWeird = 0
	
	isWeirdNoLonger = 
	{
		"\bThe haze and ozone dissipate from the air. ";
		self.isWeird := 0;
		clearing.ozone := nil;
		unnotify( self, &isWeirdNoLonger );
	}

	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Whoa. A weird light? You should check it out. Maybe
				it's a UFO or something.\" ";
				return( true );
			case Laura:
				"Laura says, \"Okay, now you're starting to weird me out.\" ";
				return( true );
			case Architect:
				"He says, \"Light? What light? The light's fine, thanks.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

/*	More dummy items, perhaps to give the player something to look at while waiting 
 *	for the time machine to show up.
*/
woodpath2: block
	sdesc = "footpath"
	noun = 'path' 'footpath'
	location = clearing
;

canopy: block
	sdesc = "canopy of leaves"
	noun = 'canopy' 'leaves'
	location = clearing
;

woodsInClearing: fixedBlock
	sdesc = "woods"
	noun = 'woods' 'trees'
	location = clearing
	isThem = true
;

/********************************* Time Machine objects **************************/

/*	This is the machine that makes the game the game it is. All of the fancy code
 *	to make it move is actually below, in the timeButton object. The heat setting
 *	is used to add both a detail and the solution to a puzzle:  the machine heats
 *	up during a jump, and takes a number of turns to cool off. Items placed on top
 *	of the machine or in the compartment are heated as well.
 *
 *	(7-21-00) Changed main definitions to classes (see classes.t) in order to 
 *	accomodate shortcut-coding for the second time machine, which has only just
 *	been invented.
*/
timeMachine: timeMachineItem
	adjective = 'original' 'first' '004'
	ioPutIn -> platform
	ioPutOn -> platform
	doSiton -> platform
	doJumpOn -> platform
	doEnter -> platform
	doStandon -> platform
	verDoBoard( actor ) = 
	{
		"You need to get on the platform, not the machine itself. ";
	}
//	doBoard -> platform
	doUnboard -> platform
;

alertLight: alertLightItem
;

platform: platformItem
	ne = { self.getOff( true ); return( self.location.ne ); }
	south = { self.getOff( true ); return( self.location.south ); }
	noexit = { return( self.location.noexit ); }
	getOff( val ) =
	{
		if ( Me.location = self )
		{
			if ( val )
				"(first getting off the platform) \n";
			self.doUnboard( Me );
		}
	}
	out = { self.getOff( nil ); return( nil ); }
	reachable = ([timeMachine timeKnob timeButton dialLabel compartment alertLight ] 
			+ self + self.contents + compartment.contents + timeTravel +
			self.location + self.location.contents )
;

timeKnob: timeKnobItem
;

dialLabel: dialLabelItem
;

timeButton: timeButtonItem
	verDoPush( actor ) =
	{
		if ( frontDoorKey.deepIsIn( platform ) )
		{
			"You aren't allowed to take the original front door key back in
			time with you. ";
			if ( !frontDoorKey.isIn( platform ) ) 
				"Hiding it isn't going to change that. ";
		}
		else if ( frontDoorKey.deepIsIn( compartment ) )
		{
			"You aren't allowed to take the original front door key back in
			time with you. ";
			if ( !frontDoorKey.isIn( compartment ) ) 
				"Hiding it isn't going to change that. ";
		}
	}
;

compartment: compartmentItem
;

timeManual: bookItem
	sdesc = "time machine manual"
	ldesc = "It's a professionally-printed manuscript with a spiral binding. On the cover 
			it lists the author's name, which, curiously, is the same as yours. However,
			you can't recall having yet written anything like it. "
	adesc = { self.thedesc; }
	noun = 'manual' 'manuscript'
	adjective = 'index'
	location = compartment
	readOnce = nil
	
	readdesc =
	{
		"There are ten chapters and a full index. Chapters 1 through 3 go into
		excruciating theoretical detail about time travel, and how it was discovered 
		to be possible. Chapters 4 through 6 go over the operation of this 
		particular machine, with historical description of early prototypes, 
		which apparently were invented years from now, if that makes any sense. 
		Chapters 7 through 10 are really a detailed appendix featuring technical 
		schematics of how to build one of these from scratch. ";

		if ( self.readOnce = nil )
		{
			"\bMaybe one of these days you'll build one just to see if it works, which is 
			apparently what the author did. ";

			self.readOnce := true;
		}
	}
	
	validTopicList = [ timeTravel timeMachine manualChapters manualAppendix 
		timeKnob timeKnob2 timeButton timeButton2 dialLabel dialLabel2 
		compartment compartment2 alertLight alertLight2 platform platform2 carEngine ]
	doConsultAbout( actor, iobj ) =
	{
		switch( iobj )
		{
			case timeTravel:
			case timeMachine:
				"This time machine is the result of decades of development, 
				offering significant improvements in power efficiency, size,
				stability, and safety. The earliest prototype occupied a 
				refrigerated room thirty feet long and fifteen feet
				high, and was capable of safely transmitting only a few 
				grams of inorganic matter. This current model is equipped
				to move an adult human being and a maximum of 800 pounds of 
				other material up to a maximum range of 130 years from time
				of origin (your model may vary). ";
				break;
			case manualChapters:
				"The manual is technical to the point of being over your head,
				involving seven-dimensional calculus and other intimidating 
				mathematics. Maybe if you had a few years to get up to speed,
				you might be able to understand its explanation of how time travel 
				works, and how this machine accomplishes it, but not before then.
				Your best bet is probably to look up specific subjects, such as 
				the knob or the buttons, in the index. ";
				break;
			case manualAppendix:
				"The manual is technical to the point of being over your head,
				involving seven-dimensional calculus and other intimidating 
				mathematics. Maybe if you had a few years to get up to speed,
				you might be able to understand its explanation of how to build 
				a time machine, but not before then. Your best bet is probably 
				to look up specific subjects: the red button, the alert bulb,
				the knob, the label, the platform, and the compartment. ";
				break;
			case timeKnob:
			case timeKnob2:
				"The knob can be turned to one of five settings, indicating
				the desired jump in time relative to the machine's current
				time location. See also: label, red button, alert bulb. ";
				break;
			case timeButton:
			case timeButton2:
				"After years of refinement, the operation of the time machine
				has been reduced to the simple push of a button. Once the 
				knob has been set, pushing the button will activate the
				machine. However, if the machine attempts to make a jump beyond
				its imposed safety limit, the alert bulb will flash and no 
				jump will occur. \b
				
				In addition, a safety feature is built into the machine which 
				deactivates the button for a period of time after each time
				jump. Due to the heat generated in the engine of the time
				machine, immediate successive jumps will cause its parts
				to fuse and become useless, a rather dangerous occurrence for
				a time traveller to face. Therefore, the time machine must 
				cool off before the button may be successfully pushed. 
				Fortunately, this only takes a few minutes (depending on the 
				climate). See also: alert bulb, knob, platform. ";
				break;
			case dialLabel:
			case dialLabel2:
				"The label describes the five settings of the knob. A 
				setting of 1 indicates a jump twenty years into the past from
				the current position. A setting of 2 indicates a jump ten 
				years into the past. A setting of 3 is a safety position, or
				\"Off\" setting, understood to mean a jump of zero time, 
				neither forward nor backward. A setting of 4 indicates a 
				jump ten years into the future. A setting of five indicates
				a jump twenty years into the future. See also: knob. ";
				break;
			case compartment:
			case compartment2:
				"The time machine's front compartment is capable of holding
				a few small items during a jump. However, it is recommended
				that large objects or objects sensitive to heat be placed on
				the time machine's platform and not in the compartment, as
				burning or melting may occur. Note: in newer models, better
				insulation has been developed, but the compartment still
				remains a source of intense heat during a jump. See also: 
				platform, red button. ";
				break;
			case alertLight:
			case alertLight2:
				"For safety reasons, the time machine can be set to limit 
				the maximum jumping distance. The alert bulb will flash if 
				the red button is pressed while the knob is set to jump 
				beyond the imposed safety limit, and no jump will occur. 
				This safety limit cannot be changed except by dismantling 
				the machine, which is forbidden due to the use of hazardous 
				isotopes in the machine's engine. See also: red button, knob, 
				label. ";
				break;
			case platform:
			case platform2:
				"Years of development have resulted in the successful 
				manufacture of time machine units designed for small,
				short trips. This engineering compaction has resulted
				in the proportionally scaled-down emission fields which
				allow the transportation of the machine and its contents
				intact through time. If the machine is activated, anything
				that is not on the platform will not be transported. It is
				vital that the person who activates the time machine be
				also standing on the platform, or he or she will have the
				unfortunate experience of seeing the unit disappear without
				them. This is why solo travel is generally considered very
				dangerous. See also: red button. ";
				break;
			case carEngine:
				"The workings of the engine are too technical for you to
				understand. Maybe one day, with sufficient time, you will
				be able to comprehend it fully. ";
				break;
			default:
				"\^<<self.thedesc>> contains no information about that subject. ";
				break;
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Um. Geez. You have a time machine, and a manual
				to go with it? I guess I'd ask to go for a ride on it, but I'm
				needed back on planet Earth, where I just sell sandwiches.\" ";
				return( true );
			case Laura:
				"Laura says, \"You must be a writer or something, because I 
				don't know where you're coming up with all of this stuff!\" ";
				return( true );
			case Architect:
				"He says, \"I don't suppose I could ask you to leave me in 
				peace to work, could I? I didn't think so. I mean, really.
				Time machines with how-to manuals? Please.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

manualChapters: fixedBlock, bookItem, numberedObject
	sdesc = "chapters"
	adesc = { self.thedesc; }
	noun = 'chapter'
	plural = 'chapters'
	isThem = true
	num_is_valid( n ) = 
	{
		if ( n < 1 || n > 10 )
		{
			"There are only ten chapters. ";
			return( nil );
		}
		return( true );
	}
	location = timeManual
	readdesc = 
	{
		"The manual is technical to the point of being over your head,
		involving seven-dimensional calculus and other intimidating 
		mathematics. Maybe if you had a few years to get up to speed,
		you might be able to understand its explanation of ";
		
		switch( self.value )
		{
			case 1:
			case 2:
			case 3: "how time travel works"; break;
			case 4:
			case 5: "how this particular machine works"; break;
			case 6: "the technical development of the prototypes"; break;
			case 7:
			case 8:
			case 9:
			case 10: "how to build a time machine"; break;
			default: "how time machines work"; break;
		}
		
		", but not before then. Your best bet is probably to look up specific 
		subjects, like the knob or the button, in the index. ";
	} 
	askingAboutMe -> timeManual
;

manualAppendix: fixedBlock, bookItem
	sdesc = "appendix"
	noun = 'appendix'
	adjective = 'detailed' 'schematics' 'schematic'
	location = timeManual
	readdesc = 
	{
		"The manual is technical to the point of being over your head,
		involving five-dimensional calculus and other intimidating 
		mathematics. Maybe if you had a few years to get up to speed,
		you might be able to understand its explanation of how to build 
		a time machine, but not before then. Your best bet is probably 
		to look up specific subjects, such as the knob or the button, 
		in the index. ";
	}
	askingAboutMe -> timeManual
;

binding: block
	sdesc = "spiral binding"
	noun = 'binding'
	adjective = 'spiral'
	location = timeManual
;

package: openable, readable
	isopen = nil
	sdesc = "package"
	ldesc = "It's a little package, addressed to you. Written in a spindly hand, it 
			says: <<self.readdesc>> "
	readdesc = "\"We hope you find this item of use in finding what is useful.\" "
	noun = 'pack' 'package'
	adjective = 'little'
//	location = compartment
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				if ( not self.isopen ) 
					"Fred says, \"A package? Open it.\" ";
				else
					"Fred says, \"Hey, nice package. Er, no innuendo
					intended. Heh.\" ";
				return( true );
			case Laura:
				if ( not self.isopen )
					"Laura says, \"If it's addressed to you, open it.\" ";
				else
					"Laura says, \"I'm glad that you got a gift package,
					but I don't know what else to say about it.\" ";
				return( true );
			case Architect:
				if ( not self.deepIsIn( Me ) )
					"He says, \"No, sorry, I haven't seen any packages here 
					addressed to you. I'll let you know if I find one.\" ";
				else
					"He says, \"I'm not sure what you expect me to
					tell you about that package. I really am very busy
					here, as you know.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
; 

detector: item
	sdesc = "odd gadget"
	ldesc = "The gadget is comfortably held in the hand, and the front end of it 
		seems designed to be pointed at things. There are no moving parts or
		ways to open it that you can discern. "
	noun = 'detector' 'device' 'gadget'
	adjective = 'herring' 'odd' 'strange' 'pointing' 'pointer'
	location = package
	bulk = 0
	
	verIoCheckWith( actor ) = {}
	ioCheckWith( actor, dobj ) =
	{
		if ( dobj.herring )
			"The gadget bleeps unhappily, and the tip glows red.  ";
		else
			"The gadget makes a happy \"poing!\"\ noise. ";
	}
	
	verDoUseOn( actor, io ) = {}
	verDoUseWith( actor, io ) = {}
	verDoUseIn( actor, io ) = {}
	
	doUseOn( actor, io ) = { self.ioCheckWith( actor, io ); }
	doUseWith( actor, io ) = { self.ioCheckWith( actor, io ); }
	doUseIn( actor, io ) = { self.ioCheckWith( actor, io ); }
	
	verDoPoint( actor ) = {}
	doPoint( actor ) = 
	{
		askio( atPrep );
	}
	verDoPointAt( actor, io ) = 
	{
		self.ioCheckWith( actor, io );
	}
	ioPointAt( actor, dobj ) =
	{
		self.ioCheckWith( actor, dobj );
	}
	
	verDoPoint_atWith( actor, io ) =
	{
		self.ioCheckWith( actor, io );
	}
	ioPoint_atWith( actor, dobj ) =
	{
		self.ioCheckWith( actor, dobj );
	}
	verIoShowTo( actor ) = {}
	ioShowTo( actor, dobj ) =
	{
		self.ioCheckWith( actor, dobj );
	}
		
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Cool gadget. I don't quite get what it does,
				though.\" ";
				return( true );
			case Laura:
				"Laura says, \"A what detector? Now you've lost me.\" ";
				return( true );
			case Architect:
				"He says, \"I don't have time for toys.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

/************************** end of time machine objects *****************************/


/************************************************************
 *					Rooms of the Village					*
 ************************************************************/

sidewalk: room
	sdesc = "Sidewalk"
	ldesc = "The concrete sidewalk that leads away from your house is starting to
			show the wear and tear of the hot summers and cool winters. The 
			sections are uneven and tufts of grass poke up through the cracks. "
	xdesc = "The sidewalk wanders east alongside the road away from your house and
			toward the nearby shopping village. Your driveway is back to the west."
	west = driveway
	sw = driveway
	east = bend
;

decorativeSidewalk: fixedBlock
	noun = 'sidewalk'
	sdesc = "sidewalk"
	ldesc = "The concrete sidewalk that leads away from your house is starting to
			show the wear and tear of the hot summers and cool winters. The 
			sections are uneven and tufts of grass poke up through the cracks. "
	location = sidewalk
;

mailbox: openable, container, staticItem
	isListed = true
	isopen = nil
	sdesc = "mailbox"
	noun = 'mailbox' 'box'
	location = sidewalk
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Mailbox, eh? Was there anything in it? Are you
				expecting anything? Mail usually comes in the morning around
				here, of course.\" ";
				return( true );
			case Laura:
				"Laura says, \"I'm really compulsive about checking my mailbox.
				Eventually something shows up even if it's been empty the
				first million times I check it.\" ";
				return( true );
			case Architect:
				"He says, \"My advice is to put the mailbox out by the curb
				instead of having one right by your front door.\" ";
			return( true );
			default: 
				return( nil );
		}
	}
;

mailboxFlag: fixedBlock
	sdesc = "flag"
	ldesc = "The mailbox flag is <<self.isup ? "up" : "down">>. "
	noun = 'flag'
	location = sidewalk
	isup = nil
	
	verDoLift( actor ) = 
	{
		if ( self.isup ) 
			"The mailbox flag is already raised. ";
	}
	doLift( actor ) = 
	{
		"You raise the mailbox flag. ";
		self.isup := true;	
	}
	
	verDoLower( actor ) = 
	{
		if ( not self.isup )
			"The mailbox flag is already down. ";
	}
	doLower( actor ) =
	{
		"You lower the mailbox flag. ";
		self.isup := nil;
	}
;

seasons: fixeditem
	sdesc = "seasons"
	noun = 'spring' 'summer' 'autumn' 'winter' 'season'
	plural = 'springs' 'summers' 'autumns' 'winters' 'seasons'
	location = nil
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"You gotta love the changing of the seasons.\" ";
				return( true );
			case Laura:
				"Laura says, \"You know what my favorite season is? Winter. I
				guess not many people say that, but I love the snow. I miss 
				seeing it here.\" ";
				return( true );
			case Architect:
				"He says, \"Oh, we'll make sure your house is going to last 
				for years, through all kinds of weather and all seasons.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

tufts: fixedBlock
	sdesc = "cracks in the sidewalk"
	noun = 'tuft' 'crack' 'section' 'grass' 
	plural = 'tufts' 'cracks' 'sections'
	adjective = 'uneven'
	isThem = true
	location = sidewalk
;

road1: fixedBlock
	sdesc = "road"
	noun = 'road'
	location = sidewalk
;

dummyVillage: distantItem
	sdesc = "village"
	noun = 'village'
	adjective = 'shopping' 'nearby'
	location = sidewalk
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Yeah, this shopping village has never been very
				busy, but if you live near here, where else is there to go? I
				kind of like going to the library. There used to be some other
				stores near here that are gone now, but I guess that's progress.\" ";
				return( true );
			case Laura:
				"Laura says, \"You know what I wish they had around here? A 
				place to get sandwiches. I have to drive all the way into the
				city to get lunch.\" ";
				return( true );
			case Architect:
				"He says, \"You are quite near the shopping village. Walking
				distance. You may not even need to own a car.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

bend: rodroom						// the divining wand works here
	sdesc = "Bend in path"
	ldesc = "As you approach the local nub of suburban civilization, you again 
			are reminded that community expansion has a price. A small shrubbery 
			here serves, apparently, as an excuse for people to litter, as it 
			is full of bits of trash. "
	xdesc = "The footpath bends here from west to north, leading into the 
			shopping village. "
	west = sidewalk
	north = village
	down = 
	{	
		if ( grating.location = self )
		{
			grating.doEnter( Me );
			return( nil );
		}
		else return( self.noexit );
	}
	
	rodPoint = 
	{
		if ( grating.location = self )
		{
			if ( sewerHole.location )
				"sewer hole";
			else 
				"grating";
		}
		else
		{
			"shrubbery";
		}
	}
;

dummyfootpath: fixedBlock
	sdesc = "footpath"
	ldesc = { self.location.xdesc; }
	noun = 'path' 'footpath'
	location = bend
;

dummyVillage2: distantItem
	sdesc = "village"
	noun = 'village'
	adjective = 'shopping' 'nearby'
	location = bend
;

shrubbery: staticItem, searchHider
	sdesc = "shrubbery"
	ldesc = "It's a full, healthy, dense little bush. "
	noun = 'shrubbery' 
	adjective = 'bush' 'shrub' 'hedge' 'plant' 'full' 'healthy' 'dense' 'shurb'
			'small' 'little'
	plural = 'shrubs' 'bushes' 'shurbs'
	location = bend
	autoTake = nil
	
	doSearch (actor ) =
	{
		if ( self.searchCont = nil )
	   		"There's nothing else in <<self.thedesc>>. ";
		else
		{
			dummyBill.moveInto( bend );
			self.searchCont := self.searchObj( actor, self.searchCont );
			dummyBill.moveInto( bend );
		}
	}
;

litter: fixedBlock
	sdesc = "litter"
	noun = 'litter' 'trash'
	location = bend
	
	verDoTake( actor ) = {}
	
	doTake( actor ) = 
	{
		"You don't need to take the litter. ";
	}
	
   	doLookin -> shrubbery
	doSearch -> shrubbery
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Man, I hate litterbugs.\" ";
				return( true );
			case Laura:
				"Laura says, \"Oh, that really kills me, the way people will
				just throw trash on the side of the road, or into a bush,
				thinking someone else will clean it up. Because who wants to
				clean up someone else's mess? I mean, can't people put trash
				in its place? I guess then you get into the idea of recycling.
				But people don't do that, either. Oh well.\" ";
				return( true );
			case Architect:
				"He says, \"I don't have any patience for those who litter.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

grating: staticItem, hiddenItem
	isListed = true
	sdesc = "sewer grating"
	ldesc = 
	{
		"The grating is made of iron that has long since rusted. ";
		
		if ( not self.isopen )
		{
			"A trickle of water is visible underneath it. ";
		}
		
		if ( dummyBill.location )
		{
			"Sitting in the muck about a foot and a half down is a 
			five-dollar bill. ";
		}
	}
	noun = 'grating' 'grate'
	adjective = 'sewer' 'iron' 'rusted' 'rust' 'water' 'trickle' 'muck'
	isopen = nil
	searchLoc = shrubbery
	
	verDoBoard( actor ) = {}
	doBoard( actor ) = { self.doEnter( actor ); }
	
	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) = { self.doEnter( actor ); }
	
	verDoEnter( actor ) = {}
	doEnter( actor ) = 
	{
		if ( self.isopen )
			sewerHole.doEnter( actor );
		else
			"You can't go down through the closed grating. ";
	}
	
	verDoLift( actor ) = { self.verDoOpen( actor ); }
	doLift( actor ) = { self.doOpen( actor ); } 
	
	verDoOpenWith( actor, iobj ) = {}
	verDoOpen( actor ) =
	{
		if ( self.isopen )
		{
			caps(); self.thedesc; " is already open! ";
		}
	}
	doOpen( actor ) =
	{
		if ( crowbar.isIn( actor ) )
		{
			"(with the crowbar)\b";
			"You pry up the sewer grating. The sewer hole is now wide open. ";
			
			self.isopen := true;
			delword( self, &adjective, 'water' );
			delword( self, &adjective, 'trickle' );
			trickle.moveInto( self.location );
			sewerHole.moveInto( self.location );
			dummyBill.moveInto( nil );
		}
		else
		{
			"It's too heavy to open. ";
		}
	}
	
	verDoClose( actor ) =
	{
		if ( not self.isopen )
			"It is already closed. ";
	}
	doClose( actor ) =
	{
		"That isn't important. ";
	}
	
	verDoLookin( actor ) = 
	{
		if ( self.isopen )
		{
			"Under the sewer grating is an open sewer hole. ";
			sewerHole.ldesc;
		}
	}

	doLookin( actor ) = 
	{
		"Sitting in the muck about a foot and a half down is a five-dollar bill. ";
	}
	
	verDoLookunder( actor ) =  
	{
		if ( self.isopen )
			"There is nothing under the open sewer grating. ";
	}
	doLookunder( actor ) =
	{
		"A trickle of water is visible underneath it. ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sometimes you find lost things down those 
				sewer gratings. If you can reach them, that is.\" ";
				return( true );
			case Laura:
				"Laura says, \"Eww, who'd want to go poking around a 
				sewer grate? Not me, that's for sure.\" ";
				return( true );
			case Architect:
				"He says, \"I'm awfully busy. If you want to talk about
				plumbing, the plumber will be here next week.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

trickle: waterItem
	sdesc = "trickle of water"
	noun = 'water'
	adjective = 'trickle'
	location = bend
	
	verDoDrink( actor ) =
	{
		"There's no reason to take an unnecessary risk to your health. ";
	}
	
	verDoEnter( actor ) = {}
	doEnter( actor ) = { self.doWadeIn( actor ); }
	
	doWadeIn( actor ) = 
	{
		"That would be somewhat unsanitary. ";
	}
	
	doSmell -> sewerHole
;

sewerHole: container, staticItem
	sdesc = "sewer hole"
	ldesc = 
	{
		"The sewer hole is dark and stinky. ";
		
		if ( fiveDollar.isIn( self ) )
			"Sitting in the muck is a five-dollar bill. ";
	}
	noun = 'hole'
	adjective = 'sewer'
	location = nil
	
	verDoSmell( actor ) = {}
	doSmell( actor ) =
	{
		"P.U.! ";
	}
	
	verDoTake( actor ) = 
	{
		"It's fixed in place. ";
	}
	
	verDoBoard( actor ) = {}
	doBoard( actor ) = { self.doEnter( actor ); }
	
	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) = { self.doEnter( actor ); }
	
	verDoEnter( actor ) = {}
	doEnter( actor ) =
	{
		"You don't fit in the sewer hole. Besides, that would be a
		somewhat sullying endeavor. ";
	}
	
	verIoPutIn( actor ) = {}
	ioPutIn( actor, dobj ) =
	{
		if ( dobj.isSandwich ) 
			"Gross! Why would you want to put <<dobj.adesc>> into a
			smelly sewer hole? Someone might want to eat that, even
			if you don't. ";
		else
			"There's no need to put <<dobj.adesc>> into the sewer hole. ";
	}
	verIoThrowIn( actor ) = {}
	ioThrowIn( actor, dobj ) = 
	{
		if ( dobj.isSandwich ) 
			"Gross! Why would you want to throw <<dobj.adesc>> into a
			smelly sewer hole? Someone might want to eat that, even
			if you don't. ";
		else
			"There's no need to throw anything into the sewer hole. ";
	}
	verIoPourIn( actor ) =
	{
		"There's no need to pour that into the sewer hole. ";
	}
;

dummyBill: staticItem
	sdesc = "five-dollar bill"
	ldesc = "It's hard to see it with the grating blocking the light. "
	noun = 'bill' 'money'
	adjective = 'five-dollar' 'five' 'dollar' 'cash'
	location = nil
	value = 5
	
	verDoTake( actor ) =
	{
		"%You% can't reach the five-dollar bill through the grating. ";
	}
	
	askingAboutMe( who ) = 
	{
		switch( who )
		{
			case Fred:
				"Fred says, \"What do I look like, an economics professor?
				I just sell sandwiches.\" ";
				return( true );
			case Laura:
				return( account.askingAboutMe( Laura ) );
			case Architect:
				"He says, \"You've already paid me to work on this project,
				thank you. I wouldn't be here if you hadn't.\" ";
				return( true );
			default:
				return( nil );
		}
	}
;

fiveDollar: treasure, moneyItem
	sdesc = "five-dollar bill"
	adesc = "a five-dollar bill"
	ldesc = 
	{
		if ( self.examinedOnce )
			pass ldesc;
		else
		{
			"Easy money. ";
			self.examinedOnce := true;
		}
	}
	adjective = 'five' 'five-dollar' 'easy'
	isThem = nil
	location = sewerHole
	takevalue = 4
	value = 5
	doTake( actor ) =
	{
		if ( not self.hasScored )	   	// have we scored yet?
		{
			incscore( self.takevalue ); 	// add our "takevalue" to the score
			self.hasScored := true;	 	// note that we have scored
			global.scoreCard[27] += self.takevalue;
		}
		handleMoneyTrade( self, self.value );
		setit( playerCash );
		"Taken. ";
	}
;


/********************************** in the Village *******************************/

village: room
	sdesc = "In the village"
	ldesc = "This little shopping village is attractively decorated with colored 
			signs pointing you to this merchant and that. To the west 
			is the bank, and to the east is the public library. "
	xdesc = "Because it is late, the only thing open is the sandwich shop, which 
			is to the north. The road leading back home is south. "
	north = dummyShop
	in = dummyShop
	west = bank
	east = library
	south = bend
;

signs: fixedBlock, readable
	sdesc = "colorful signs"
	ldesc = "The colorful signs say \"Bank <-- to your left\", \"Library --> to your 
			right\", \"Sandwiches straight ahead.\" "
	noun = 'sign'
	plural = 'signs'
	isThem = true
	adjective = 'colorful' 'colourful' 'colored' 'color' 'colour' 'coloured'
	location = village
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"The signs out in the village there? Yeah, what about
				them? I barely pay attention to them any more, I've seen them so
				many times.\" ";
				return( true );
			case Laura:
				"Laura says, \"The what? What signs? I haven't seen any signs.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

bank: lockableDoorway
	herring = true
	sdesc = "bank"
	ldesc = "This bank has been here as long as you can remember. You haven't had 
			enough money to open a valid account here for as long as you can 
			remember. "
	noun = 'bank'
	location = village
	mykey = villageKey
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I keep my money there. I can't wait for them to 
				build a teller machine so that I can get money whenever I want,
				even when it's closed.\" ";
				return( true );
			case Laura:
				"Laura says, \"This really is a good bank. The interest rates are
				really good, if you keep your money stored for a long term.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

library: lockableDoorway
	sdesc = "public library"
	ldesc = "This is the library you left just a few minutes ago. It is closed for 
			the night. A depository slot is the only thing of note. "
	noun = 'library'
	adjective = 'public'
	location = village
	mykey = villageKey
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I love going to that library. Me and my friends -- 
				well, maybe I shouldn't say this. But for laughs, sometimes we
				used to swipe books out of the deposit slot, because if you 
				look in there, you can reach in and take them out again. It's
				kind of a silly thing to do, since borrowing books properly is
				free. But anyway, forget I said anything.\" ";
				return( true );
			case Laura:
				"Laura says, \"What library? Is there a library here? I haven't
				seen one. If they put a library here in the shopping village I'd
				support it, certainly.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

dummyShop: lockableDoorway
	isopen = true
	islocked = nil
	sdesc = "sandwich shop"
	ldesc = 
	{
		"This sandwich shop is the only one in the area, so it is 
		heavily frequented by a few dedicated regulars. In fact, you 
		ate here only this morning. The shop is ";
		
		if ( self.isopen )
			"open for business. ";
		else
			"closed for the night. ";
		
		if ( Fred.lockingUpTheShop )
		{
			"\b";
			if ( self.lightsOut )
				"Fred has turned the lights out, so you can't see 
				anything inside the sandwich shop. You don't see Fred, 
				either. He must be about to come from around back. ";
			else
				"Inside the shop you see Fred giving the place the once-over
				before leaving for the night. He looks solemn. ";
		}
	}
	destination =
	{
		if (self.isopen)
			return self.doordest;
		else if (not self.islocked and not self.noAutoOpen)
		{
			self.setIsopen(true);
			"(Opening << self.thedesc >>)\n";
			return self.doordest;
		}
		else
		{
			"%You%'ll have to open << self.thedesc >> first. ";
			setit(self);
			
			if ( Fred.followingPlayer )
			{
				if ( Fred.location = Me.location )
					"\bFred says, \"Um, I hope you didn't leave anything in there that
					you need, because I closed up and set the alarm and stuff.\" ";
				else
					"\b[BUG! Where's Fred?] ";
			}
			return nil;
		}				
	}
	noun = 'shop'
	adjective = 'subway' 'sub' 'sandwich' 'hoagie'
	location = village
	mykey = villageKey
	doordest = sandwichShop
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Yep. I've worked here for about six years now.
				It's not too bad a place, if you can stand to go home covered
				in mustard and bread crumbs every day. We use the best all-natural
				ingredients, by the way, and bake our bread fresh in the morning.\" ";
				return( true );
			case Laura:
				"Laura says, \"Oh, I wish there were a sandwich shop near here.\" ";
				return( true );
			case Architect:
				if ( global.scoreCard[17] = 1 )
					"He says, \"That sandwich really hit the spot, all right. 
					Thanks again.\" ";
				else
					"He says, \"I really wish I didn't have to work through 
					lunch today. I could really go for a nice big sandwich.\" ";
				return( true );
			case FFred:
				"\^<<FFred.thedesc>> says, \"Eh? What do you know about it, that damn
				sandwich shop! Twenty years of my life I gave that place. I was gonna be
				manager. I knew that place like nobody. Then they tell me -- they 
				tell me that I'm drinking too much. I says to them, I says, 'Hah! My
				problem is I don't drink enough, to put up with what I gotta deal 
				with!\" \b
				
				He goes silent for a minute, lost in thought, or perhaps just simply
				lost. \b
				
				\"They can tear it down for all I care,\" he says finally. \"In fact, 
				I hear that's what's gonna happen.\" \b
				
				\^<<FFred.thedesc>> throws his arm in a wide circle, stifling a
				bout of coughing. \"All this. All this is going to become -- get this,
				this is what I hear -- a parking lot. And a big building. It's all
				going to hell.\" \b
				
				He looks up at you, looking for a reaction. \"Ah, what am I telling
				you for? You can't do nothin' about it.\" ";
				
				return( true );
			default: 
				return( nil );
	  	}
	}
;

villageKey: keyItem								// no such key exists in the game
	sdesc = "village key"
	location = nil
;

depositSlot: block, qcontainer
	sdesc = "depository slot"
	ldesc = 
	{
		"The library depository slot is for returning books after hours. ";
		
		if ( wedgedBooks.location = self )
		{
			"Wedged just inside the slot are two books. Someone must have
			tried to cram them both in at the same time, because they
			should have slid down and out of reach. ";
		}
	}
	noun = 'slot'
	adjective = 'deposit' 'depository' 'empty' 'chute'
	location = library
	maxbulk = 1
	
	verDoSearch( actor ) = {}
	doSearch( actor ) = { self.doLookin( actor ); }
	
	verDoLookin( actor ) = {}
	doLookin( actor ) =
	{
		"You contort your neck to peer into the deposit slot. ";
		{
			if ( wedgedBooks.location = self )
			{
				"Wedged just inside the slot are two books. Someone must have
				tried to cram them both in at the same time, because they
				should have slid down and out of reach. ";
			}
			else
			{
				"You don't see anything there but an empty chute. ";
			}
		}
	}
	
	verIoPutIn( actor ) = 
	{
		if ( wedgedBooks.location = self )
			"You try, but there seems to be something blocking the 
			opening of the depository slot. ";
	}
	ioPutIn( actor, dobj ) =
	{
		if ( dobj.isBook )
		{
			"You return <<dobj.thedesc>> to the library. It slides down 
			the slot and out of view. ";
			
			if ( dobj = libraryBook )
			{
				if ( librarySlip.isIn( Me ) )
				{
					"You feel something vanish from among your 
					possessions. ";
				}
				if ( librarySlip.location )
					librarySlip.moveInto( nil );
			}
			dobj.moveInto( nil );
		}
		else if ( addbulk( self.contents ) + dobj.bulk > self.maxbulk )
		{
			"%You% can't fit <<dobj.thatdesc>> in <<self.thedesc>>. ";
		}
		else
		{
			"That doesn't belong in the library deposit slot. ";
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I love going to that library. Me and my friends -- 
				well, maybe I shouldn't say this. But for laughs, sometimes we
				used to swipe books out of the deposit slot, because if you 
				look in there, you can reach in and take them out again. It's
				kind of a silly thing to do, since borrowing books properly is
				free. But anyway, forget I said anything.\" ";
				return( true );
			case Laura:
				"Laura says, \"What library? Is there a library here? I haven't
				seen one. If they put a library here in the shopping village I'd
				support it, certainly.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

wedgedBooks: fixedBlock
	sdesc = "wedged books"
	ldesc = "It's hard to tell what either of the books are with them stiil
			wedged into the depository slot, because their bindings are
			facing downward. "
	adesc = { self.thedesc; }
	noun = 'book'
	plural = 'books'
	isThem = true
	adjective = 'two' 'wedged' 'crammed' 'stuck' 'jammed'
	location = depositSlot

	verDoPush( actor ) = {}
	doPush( actor ) = 
	{
		"You give the jammed books a shove, and they slide down the
		chute and out of view. ";
		self.moveInto( nil );
	}
	verDoPull( actor ) = {}
	doPull( actor ) = { self.doTake( actor ); }
	
	verDoTake( actor ) = {}
	doTake( actor ) =
	{
		"You grab ahold of the books and give them a few solid yanks.
		They pop free and tumble onto the ground. ";
		self.moveInto( nil );
		rareBook.moveInto( village );
		fernBook.moveInto( village );
	}
;

rareBook: libraryBookItem
	sdesc = "rare book"
	ldesc = 
	{
		if ( self.location = topOfTree )
			"The rare book you gave to the squirrel is nestled within the 
			branches of the tree. ";
		else
		{
			"A rare scientific volume, detailing the mating habits of small 
			rodents. ";
			
			if ( self.retrieved )
				"It looks a bit -- how shall we say? -- sullied, but is
				otherwise in fine condition. ";
		}
	}
	noun = 'book'
	adjective = 'rare'
	location = nil
	
	readdesc =
	{
		if ( self.location = topOfTree )
			"You can't read the book until you retrieve it. ";
		else if ( self.retrieved )
			"You still don't have much interest in the subject, but 
			it sure did the trick for the squirrel. ";
		else
			"You haven't the slightest interest in the subject. Who would? ";
	}
	
	verDoPull( actor ) = {}
	doPull( actor ) = 
	{
		if ( self.location = topOfTree )
			self.doTake( actor );
		else
			"Pulling <<self.thedesc>> doesn't have any effect. ";
	}
	
	doTake( actor ) =
	{
		if ( self.location = topOfTree )
		{
			"You retrieve the book from the branches. ";
			self.retrieved := true;
			self.moveInto( Me );
		}
		else
			pass doTake;
	}
	
	validTopicList = [ squirrel sex ]
	doConsultAbout( actor, iobj ) =
	{
		if ( self.location = topOfTree )
			"You can't look up anything in the book until you retrieve it. ";
		else
		{
			switch( iobj )
			{
				case squirrel:
				case sex:
					"The book goes into somewhat lurid detail about the mating
					habits of squirrels, including a ream of bawdy, full-color
					photographs of female squirrels in heat. It's really rather
					lascivious for a scientific volume. ";
					break;
				default:
					"\^<<self.thedesc>> contains no information about that 
					subject. ";
					break;
			}
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred laughs. \"It's squirrel porn!\" he shouts. ";
				return( true );
			case Laura:
				"Laura says, \"It takes all kinds, I guess. I mean, I don't know
				anyone who'd be interested in pictures of squirrels doing the 
				nasty.\" ";
				return( true );
			case squirrel:
				"The squirrel leaps up and down in a state of excitement! ";
				return( true );
			default: 
				return( nil );
		}
	}
;

fernBook: libraryBookItem
	sdesc = "biology book"
	ldesc = "The title of this book is \"Fun With Ferns\" by Prof.\ Roy Hinkley. "
	noun = 'book'
	adjective = 'biology'
	location = nil
	herring = true
	
	readdesc = 
	{
		"The only thing interesting about this book is that the author was apparently 
		stranded on a small island in the Pacific for fifteen years while researching 
		the material. ";
	}
	
	validTopicList = [ freshGrowth freshGreenery ]
	doConsultAbout( actor, iobj ) =
	{
		switch( iobj )
		{
			case freshGrowth:
			case freshGreenery:
				"The book contains a few dry facts about <<self.thedesc>>,
				but nothing very important. ";
				break;
			default:
				"\^<<self.thedesc>> contains no information about that subject. ";
				break;
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Nice book. Professor who?\" ";
				return( true );
			case Laura:
				"Laura says, \"Fun with Ferns. Mmm-hmm.\" ";
				return( true );
			case Architect:
				"He says, \"I have no time for Gilligan's Island in-jokes, 
				I'm busy right now.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

sandwichShop: room
	indoors = true
	sdesc = "In the sandwich shop"
	ldesc = "The room is painted a gaudy yellow color. On closer inspection, it is 
			merely spattered with mustard stains. That's the kind of shop this is, 
			I guess -- heavily frequented because it's the only one nearby. There's 
			a counter, a menu, a big advertisement, and a row of tables and chairs. "
	xdesc = "The door is to the south. "
	south = village
	out = village
	
	firstseen = 
	{
		"\b"; Fred.sayHello;
		notify( Fred, &actorDaemon, 0 );
	}
	
	enterRoom( actor ) =
	{
		inherited.enterRoom( actor );

		if ( Fred.met )
		{
			if ( Me.boughtSandwich && not ( hotSandwich.isIn( Me ) 
				|| coldSandwich.isIn( Me ) ) )
			{
				"\bFred says, \"So how was the sandwich? Pretty good, huh?\" ";
			}
			else
			{
				local num;
				num := _rand( 12 );
				
				if ( num > 4 )
				{
					"\b";
					
					switch( num )
					{
						case 5:
						case 6:
							"Fred says, \"Well, if it isn't my favorite 
							repeat customer.";
							break;
						case 7:
						case 8:
							"Fred says, \"Back again, eh?";
							break;
						case 9:
						case 10:
							"Fred says, \"Hey there.";
							break;
						case 11:
						case 12:
							"Fred smiles and says, \"Back for more, I see.";
							break;
						default: break;
					}
					
					if ( timeMachine.toldFredAbout )
						" How goes the time travel business? Keepin' you busy?\" 
						He winks and flashes a broad grin. ";
					else
						"\" ";
				}
			}
		}
		else
		{
			Fred.met := true;				// Okay, we've met Fred once
		}
	}
;

Fred: NPC
	isHim = true
	noun = 'guy' 'Fred' 'ferd' 'frde'
	sdesc = "Fred"
	adesc = "Fred, the sandwich guy"
	thedesc = "Fred"
	ldesc = 
	{
		if ( self.state != 3 )
		{
			"Fred, the sandwich guy, always smiles at you even though you must have 
			bought a thousand sandwiches from him. He's got a pudgy frame, dark
			eyebrows, and a tiny mustache, but there is always a happy twinkle 
			behind his eyes. ";
			
			if ( FFred.met )
			{
				"\b";
				
				if ( self.lookedAtOnce )
				{
					"As you look at him, you can't help but think about the
					boozy wino you saw in your house in the future, and how 
					miserable he is compared to the Fred of today. ";
				}
				else
				{
					"As you look closely at him, you are shocked to recognize 
					Fred as the old wino you met in your house in the future. 
					You can't help but think about how miserable he was 
					compared to the Fred of today. ";
				}
			}
			if ( not self.lookedAtOnce )
				self.lookedAtOnce := true;
		}
		else
		{
			"Fred is looking rather pensive and solemn. ";
		}
	}
	location = sandwichShop
	sayHello = 
	{
		if ( self.saidHelloOnce )
		{
			"Fred smiles. \"Hello once again. Can I get you something?\" ";
		}
		else
		{
			"Fred says, \"Hey there. How can I help you?\" ";
			self.saidHelloOnce := true;
		}
	}
	responseToThanks = 
	{
		if ( rand(2) = 1 )
			"\^<<self.thedesc>> says, \"Hey, no problem, buddy.\" ";
		else
			"\^<<self.thedesc>> smiles and says, \"Back atcha.\" ";
	}
	notImpressedMsg( it ) = {
		"Fred pretends to be interested. \"Aha. Nice <<it.sdesc>>,\" he says. ";
	}
	listenDesc = 
	{
		switch( self.action )
		{
			case 4:
			case 14:
			case 24:
			case 34:
				return( 'Fred is whistling a half-remembered melody. ');
			default:
				return( 'Fred isn\'t saying anything at the moment. ');
		}
	}
	actorDesc =
	{
		say( self.currentActorDesc );
	}
	currentActorDesc =
	{
		switch( self.state )
		{
			case 0: 		// at work
				return( 'Fred, the sandwich guy, is standing at the counter. ');
			case 1:		// waitingForPlayer
				return( 'Fred is standing here, pacing and staring at his watch. ');
			case 2:
				return( 'Fred is here. ' );
		}
	}
	state = 0
	
	verIoGiveTo( actor ) = {}
	ioGiveTo( actor, dobj ) =
	{
		if ( dobj = playerCash )
		{
			"Fred will take your money when buy a sandwich. ";
		}
		else if ( isclass( dobj, throwable ) )
		{
			dobj.doThrowTo( actor, self );
		}
		else
		{
			"Fred doesn't want "; dobj.thedesc; ". ";
		}
	}
	disavow( it ) = 
	{
		"Fred says, \"Heh. I don't know anything about that. I just sell 
		sandwiches.\" ";
	}
	verDoPay( actor ) = {}
	doPay( actor ) = 
	{
		"Fred will take your money if you buy a sandwich. ";		
	}
	yesOrNoAnswer( verb ) = { "Fred says, \"Okay...\" "; }
	actorAction( v, d, p, i ) =
	{
		if ( self.state = 3 )
		{
			if ( Me.isIn( self.location ) )
				"\n\^<<self.thedesc>> says, \"Could you just take me home,
				please?\" ";
			else 
				"\n\^<<self.thedesc>> isn't here. ";
			exit;
		}
		else pass actorAction;
	}
	dobjGen( a, v, i, p ) =
	{
		if ( self.state = 3 )
		{
			if ( v != askVerb && v != tellVerb && v != inspectVerb )
			{
				"I think Fred needs you to just take him directly home 
				right now. ";
				exit;
			}
		}
		else pass dobjGen;
	}
	iobjGen( a, v, d, p ) = 
	{
		if ( self.state = 3 )
			self.dobjGen( a, v, d, p );
		else pass iobjGen;
	}
	verDoTellAbout( actor, iobj ) = 
	{
		if ( self.state = 3 )
			"\n\^<<self.thedesc>> says, \"Sorry, but I'm not in the mood for
			conversation right now. Could you just take me home, please?\" ";
	}
	verDoAskAbout( actor, iobj ) = 
	{
		if ( self.state = 3 )
			"\n\^<<self.thedesc>> says, \"Sorry, but I'm not in the mood for
			conversation right now. Could you just take me home, please?\" ";
	}
	doWaitFor( actor ) =
	{
		if ( !self.lockingUpTheShop )
		{
			"Time passes... ";
		}
		else
		{
			if ( Me.location != village )
			{
				self.action := 8;
				"Maybe you should go back to the sandwich shop to wait 
				for Fred. ";
			}
			else
			{
				"You patiently wait for a few minutes. ";
				self.action := 9;
			}
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Laura:
				"Laura says, \"I don't know who that is, sorry.\" ";
				return( true );
			case Architect:
				"He says, \"Eh? Who? Don't know him, sorry.\" ";
				return( true );
			case FFred:
				"\^<<FFred.thedesc>> says, \"So you 'knew me when', eh? Bought
				my sandwiches, gave me a smile and a wave. Well, that guy's
				gone. I'll never see him again.\" \b
				
				He goes quiet for a minute, then says, \"Don't talk to me about 
				the past. You can't change the past! You can't change anything. 
				Ah, just leave me be, willya? Go on, get out.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
	tellAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Laura:
				"Laura says, \"Well, he sounds like a nice guy. I don't 
				remember seeing a sandwich shop here, but I guess if they
				build one I'd go there. And if that happens, and I meet a
				guy named Fred working there, I'll be sure to say 'Hi.'\" ";
				return( true );
			case Architect:
			{
				if ( global.scoreCard[17] = 1 )
		 			"He says, \"Well, Fred sounds like a nice guy, and
					he definitely makes a good sandwich.\" ";
			 	else
			 		"He says, \"Say, if you know someone who works at a 
					sandwich shop, maybe you could get him to make me one.
					I have to work through lunch today, and I could really 
					go for a nice big sandwich.\" ";
				return( true );
			}
			default: 
				return( nil );
		}
	}
	MAX_actions = 30
	action = 0
	actorDaemon = 					// Fred at work in the shop cycle
	{
		if ( Me.location = self.location )
		{
			if ( self.wasTalkedTo = nil )
			{
				local temp;
				if ( ( self.action > self.MAX_actions ) or ( self.action < 0 ) )
					self.action := 0;
				doFredAction( self.action );
				self.action++;
			}
		}
		self.wasTalkedTo := nil;
	}
	actorDaemon2 = 					// When Fred comes to follow you
	{
		self.action++;
		switch( self.action )
		{
			case 1:
				dummyShop.isopen := nil;
				dummyShop.islocked := true;
				self.lockingUpTheShop := true;
				Me.travelTo( village );
				break;
			case 2:
			case 3: break;
			case 4:
				if ( Me.location = village )
					"\bYou see Fred turn out the lights in the sandwich shop. ";
					dummyShop.lightsOut := true;
				break;
			case 5:
			case 6:
			case 7: break;
			case 8:
				if ( Me.location = village )
					"\bYou start to wonder what's keeping Fred. ";
				else
					"\bYou wonder if maybe you should go back to the
					sandwich shop to wait for Fred. ";
				break;
			case 9: break;
			case 10:
				self.moveInto( village );
				self.lockingUpTheShop := nil;
				unnotify( self, &actorDaemon2 );
				
				if ( Me.location = village )
				{
					"\bFred comes wandering around from behind the sandwich shop. 
					\"Hey, there you are,\" he says. Either he's decided to take
					this less seriously or he's just trying to hide what he's
					feeling. \b
					
					After a slight pause during which neither of you take the 
					initiative, Fred claps his hands and rubs them together. \"Well, 
					where to?\"\ he asks. \"Lead on, MacDuff.\" ";
					
					self.followingPlayer := true;
					self.state := 2;
					notify( self, &actorDaemon3, 0 );
				}
				else
				{
					self.state := 1;
					notify( self, &waitForPlayer, 0 );
				}
				break;
			default: return( nil );
		}
	}
	waitForPlayer =
	{
		if ( Me.location = self.location )
		{
			"\bFred sees you coming and gives you a friendly, stern look.
			\"There you are,\" he says, meeting you halfway. \"Where'd you
			go? I was starting to think you were yanking my chain. Well, I
			mean, I already think you're yanking my chain about this whole
			time travel thing, but you know.\" He grins. \b
			
			After a slight pause during which neither of you take the 
			initiative, Fred claps his hands and rubs them together. \"Well, 
			where to?\" he asks. \"Lead on, MacDuff.\" ";

			self.followingPlayer := true;
			self.state := 2;
			unnotify( self, &waitForPlayer );
			notify( self, &actorDaemon3, 0 );
		}
	}
	actorDaemon3 =
	{
		if ( self.location != Me.location )
		{
			self.moveInto( Me.location );
			
			"\b";
			
			if ( self.location.FredWasHere )
			{
				if ( location = platform || location = platform2 )
				{
					if ( location.location = storageRoom && 
						Fred.blockedYouOnce ) 
					{
						if ( !Fred.alreadySaidThisParticularThing ) 
						{
							Fred.alreadySaidThisParticularThing := true;
							
							"Fred says, \"Come on, let's zoop out of
							here. You said you were going to show me
							proof about my future. This is crazy, it's
							totally wild, but it's not what I came to
							see and it's spooking me out. Let's go where we're 
							going and stop goofing around where we --\" 
							He lowers his voice again. \"Where I obviously
							have no business being.\" ";
						}
						else
							"Fred says, \"Stop with the hopping on and
							off already.\" ";
					}
					else
						"Fred says, \"Woo, where to this time?\" ";
				}
				else if ( location = newAccounts )
					"Laura says, \"You two again?\" ";
				else if ( location = PLaurasOffice )
					"Laura glances up at the two of you, then 
					somberly returns to her work. \b
					Fred whispers, \"Let's leave her alone, huh?\" ";
				else if ( location = P2ndFloor )
					"Fred follows you, but he looks a little grumpy about
					it. \"This is kind of cool, but I'm a little too tired
					to be walking around all over creation.\"\b
					The architect says, \"Shhh, please.\" ";
				else 
				{
					switch( _rand( 20 ) )
					{
						case 1:
							"Fred says, \"Say, haven't we already been here?\" ";
							break;
						case 2:
							"Fred looks around and says, \"Are you sure you know
							which way you're going?\" ";
							break;	
						case 3:
							"Fred gives you a look. \"I know walking is good 
							exercise and all, but I could do with less backtracking.
							I'm not wearing the right shoes.\" ";
							break;
						case 4:
							"Fred says, \"I think we're going in circles.\" ";
							break;
						case 5:
							"Fred says, \"I hope we get back in time for me to
							watch ";
							switch( _rand( 7 ) )
							{
								case 1: "Gilligan's Island"; break;
								case 2: "Letterman"; break;
								case 3: "Ren and Stimpy"; break;
								case 4: "Baywatch"; break;
								case 5: "that movie on Cinemax"; break;
								case 6: "Deep Space Nine"; break;
								case 7: "Daktari"; break;
							}
							".\" ";
							break;
						default:
							"Fred follows you. ";
							break;
					}
				}
			}
			else
			{
				switch( self.location )
				{
					case bend:
						"Fred says, \"It's not very far, is it? I'm not 
						wearing my best pair of walking shoes.\" ";
						break;
					case driveway:
						"Fred says, \"Hey, this is your house? Huh. Must be
						nice not having any neighbors.\" ";
						break;
					case woods:
						"Fred looks around. \"Hey! I know this place,\" he says.
						\"There used to be a little creek running along here. I
						remember playing in it when I was a kid.\" ";
						break;
					case clearing: 
						if ( timeMachine.isIn( clearing ) )
						{
							if ( not self.alreadySeenTimeMachine )
							{
								"Fred gapes at the time machine. \"Whoo-aaoo,\" he says,
								stumbling closer to it. \"Does this really work? I mean,
								it looks real, you know? Or are you just putting me 
								on?\" He stares at it for a few moments, and runs his
								hand across it. \"It feels ";
								
								timeMachine.sayTemperature;
								
								",\" he says. ";
								
								self.alreadySeenTimeMachine := true;
							}
							else
							{
								"Fred follows you. ";
							}
						}
						else
						{
							"Fred says, \"Huh. I thought you said it was going 
							to be here. Where is it?\" ";
						}
						break;
					case platform: 
						"Fred clambers onto the platform, looking awestruck and 
						excited. \"Well, here we go, huh?\" he says bravely. ";
// Fred wants to push the button code
						break;
					case FinGarage:
						"As Fred enters the garage, he holds his nose and says,
						\"Whoo-ee, what crawled in here and died?\" Then he sees
						future Fred sitting on the mattress, swigging from his
						bottle of cheap liquor, and is struck dumb. \b
						
						Fred turns a blotchy shade of white, and his lower lip
						quivers a bit. \"That's me,\" he says. \"That's me.\"\b
						
						Future Fred belches and squints at his former self. 
						\"This is what I get for mixin' my drinks,\" he mutters.
						\"Good thing I decided to quit drinkin' the cheap stuff.\"
						He goes to take another swig, but Fred snatches the 
						bottle out of his hand.\b
						
						\"This is what Dad used to drink,\" Fred says, staring
						numbly at the label. \"This is exactly the --\" Future 
						Fred grabs the bottle back, letting out a wheeze. \"Get
						yer own bottle,\" he says. \b
						
						\"No,\" Fred says, the color returning to his face. He
						seems to have become very still and quiet, but you can
						see the muscles in his cheeks twitching. He opens a 
						white paper sack and withdraws a sandwich. \"Here,\" he
						says. \"Eat this.\" \b
						
						\"Lemme guess,\" says future Fred, taking it. \"Roast
						beef on wheat, with mustard and tomatoes. Bingo.\" He
						sets it aside. \"My stomach don't take food so good no
						more,\" he says, taking another drink. \"Makes me
						sick.\" \b
						
						Fred's head falls, his chin resting on his chest. 
						Everything is quiet. ";
						
						unnotify( self, &actorDaemon3 );
						self.followingPlayer := nil;
						self.state := 3;
						self.action := 99;
						notify( self, &actorDaemon4, 0 );
						return;
					case secretPassage:
						"Fred says, \"Wow, cool.\" ";
						break;
					case secretChamber:
					case FsecretChamber:
						if ( timeMachine2.location = secretChamber )
							"Fred says, \"Whoa. This is getting weird.\" ";
						else
							"Fred follows you. ";
						break;
					case FFclearing: 
						"Fred says, \"Where the hell is this?\" ";
						break;
					case newAccounts:
						"Laura says, \"Oh, hello. You brought a friend.\"\b
						Fred says, \"Hi. Actually we're not that close. But
						boy, what a tour guide.\" ";
						break;
					case PLaurasOffice:
						if ( !newAccounts.FredWasHere )
							"Laura says, \"I'm sorry, I'm a little busy
							right now. Maybe you and your friend can come
							by for a social visit some other time.\"\b
							Fred looks sheepish. \"Sorry we bothered
							you, Ma'am.\" ";
						else
							"Laura says, \"I'm sorry, I'm a little busy
							right now. Maybe you and your friend can...\"
							She pauses and does a double-take. \"I'm having
							some sort of deja vu right now.\"\b
							Fred says, \"Tell me about it!\"\b
							Laura says, \"Anyway, I'm afraid that I really
							am too busy for a social visit right now.\"\b
							Fred says, \"Sorry we bothered you, Ma'am.\" ";
						break;
					case P2ndFloor:
						"The architect rolls his eyes when he sees Fred huff
						up the ladder. \"I know it doesn't look like much, but
						this is my office for the moment, and I'd prefer it if
						you didn't bring your friends trooping in and out.\" He
						glares at you for a moment and then goes back to work. \b
						Fred whispers, \"Sheesh, what a hothead. They say it 
						goes along with genius.\"\b
						The architect says, \"Now that I agree with.\" He flashes
						a quick grin but otherwise goes back to ignoring the 
						two of you.\b
						Fred says, \"Hey, are we ever going to get to where you
						were going to take me in the first place?\" ";
						break;
					default: 
						"Fred follows you. ";
						break;
				}
				self.location.FredWasHere := true;
			}
		}
	}
	actorDaemon4 = 
	{
		if ( self.action = 99 )
		{
			"\bFred looks at you and says, \"I'd like to go back now, please. I
			have a lot of thinking to do.\" ";
			self.action := 0;
			return;
		}
		else if ( self.location != Me.location )
		{
			"\bFred follows you. ";
			self.moveInto( Me.location );
		}
		else if ( global.timeLoc = 3 )
		{
			incscore( 7 );
			global.scoreCard[20] := 1;
			self.state := 100;
			unnotify( self, &actorDaemon4 );
		}
	}
;

VincentLynchShopItem: locationDesc
	sdesc = "sandwich shop"
	adjective = 'shop'
	location = sandwichShop
;

peskyFly: unimportantItem
	sdesc = "pesky fly"
	noun = 'fly'
	adjective = 'pesky' 'insect' 'bug' 'pest'
	location = sandwichShop
;

utensils: block
	sdesc = "utensils"
	noun = 'utensil'
	plural = 'utensils'
	isThem = true
	adjective = 'spoon' 'spoons' 'fork' 'forks' 'knife' 'knives'
	location = Fred
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred smiles. \"Gotta keep 'em clean!\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

counter: block, surface
	sdesc = "counter"
	ldesc = "Flat. Long. Counter-shaped. "
	noun = 'counter'
	location = sandwichShop
	
	verDoLookbehind(actor) =
	{
		"Fred is behind the counter. \b
		
		Fred notices you peering around. He gives you a friendly look and 
		asks, \"Can I help you with something?\" ";
		
		Fred.justAskedYesOrNoQuestion := true;
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I try and keep it clean. Really.\" He rubs a 
				cloth over it. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

rowOfTables: fixedBlock
	sdesc = "row of tables and chairs"
	ldesc = "They're so you can sit down and eat, should you be so inclined. "
	noun = 'row'
	location = sandwichShop
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Feel free to sit down and eat if you want.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

mustardStains: fixedBlock
	sdesc = "mustard stains"
	ldesc = "The mustard stains are just for decoration. "
	noun = 'stain'
	plural = 'stains'
	adjective = 'mustard'
	isThem = true
	adjective = 'gaudy' 'yellow' 'color' 'colour'
	location = sandwichShop
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"The funny thing is, those aren't real mustard
				stains. We color them that way so that real stains don't show
				up as well.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

tables: surface, block
	sdesc = "tables"
	adesc = "tables"
	noun = 'table' 
	plural = 'tables'
	isThem = true
	location = sandwichShop
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sit anywhere you like.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

chairs: chairitem, fixedBlock
	sdesc = "chairs"
	adesc = "chairs"
	noun = 'chair'
	plural = 'chairs'
	isThem = true
	location = sandwichShop
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Take a seat, have a bite. Enjoy yourself.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

menu: staticItem, readable
	sdesc = "menu"
	ldesc = "The menu lists two items:  a hot meatball sandwich, and a cold cut 
			combo sandwich. Both are 5 dollars with tax. "
	noun = 'menu' 
	plural = 'items' 'sandwiches'
	location = sandwichShop
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"So, we got the hot sandwich, or the cold cut combo
				special today. The hot sandwich is meatball, the cold cut combo
				has bologna, turkey, and sliced ham.\" ";
				return( true );
			case Architect:
				"He says, \"Well, if I had a choice, I'd prefer a hot meatball
				sandwich to a cold cut combo.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

advertisement: staticItem, readable
	sdesc = "advertisement"
	ldesc = "The advertisement is a big photo of the cold cut sandwich, with a 
			big star-shaped balloon that contains the phrase: \"BUY THE SPECIAL!  
			Now only 99 cents!\" "
	noun = 'ad' 'advert' 'advertisement'
	location = sandwichShop
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"It's a pretty good deal. We have a different 
				promotion every couple of months.\" ";
				return( true );
			case Architect:
				"He says, \"I'm in the mood for a hot sandwich.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;


/*	The cold sandwich is the wrong one to buy, but it's tempting.
 *	Revision (1.2.1) - You can give the cold cut sandwich to future Fred,
 *	making it no longer a red herring.
 */
coldSandwich: sandwichItem
	sdesc = "cold cut special"
	ldesc = "It's a bunch of meat on bread. Not bad for 99 cents, though. "
	noun = 'sandwich' 'sandiwch'
	adjective = 'cold' 'cut' 'combo' 'special' 
	cost = 5
	
	doBuy( actor ) =
	{
		if ( inherited.doBuy( actor ) )
		{
			napkin1.moveInto( Me );
			penny.moveInto( actor );					// Give the player 
			handleMoneyTrade( fourDollars, 4 );				// $4.01 in change.
			
			"You hand Fred five dollars, and he hands you the sandwich and 
			your change.\b
			
			Fred says, \"Thank you. Come again.\" ";
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"It's a good deal. On special.\" ";
				return( true );
			case Architect:
				"He says, \"Really, I don't like to eat ham, and I'm more
				fond of hot sandwiches.\" ";
				return( true );
			case workers:
				"They've already got their own lunches. ";
			case Laura:
				"Laura says, \"It's not lunchtime yet. Thank you, though.\" ";
			case PLaura:
				"Laura says, \"Lunch would be nice, but I guess I can't
				make the time for it today. As usual. One thing about this
				ridiculous career, it keeps me trim.\" ";
			case Blackie:
				"Blackie barks loudly. Slobber flies everywhere. ";
			default: 
				return( nil );
		}
	}
;

/*	The hot sandwich is the right one to buy. It uses all your money, and doesn't
 *	give you any points, but if you successfully give it to the architect (having
 *	successfully heated it up), you get 10 points.
 */
hotSandwich: sandwichItem
	sdesc = "hot meatball sandwich"
	ldesc = "It's a bunch of meatballs in sauce on bread. "
	noun = 'sandwich' 'sandiwch' 
	adjective = 'hot' 'meatball'
	cost = 5
	heat = 12
	
	doBuy( actor ) = 
	{
		if ( inherited.doBuy( actor ) )
		{
			napkin2.moveInto( Me );
			setdaemon( coolOffDaemon, hotSandwich );
			
			"You hand Fred five dollars, and he hands you the sandwich.\b
			
			Fred says, \"Thank you. Come again.\" ";
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Hot meatball sandwich. One of my favorites. 
				Fills you right up.\" ";
				return( true );
			case Architect:
				if ( global.scoreCard[17] = 1 )
					"He says, \"That sandwich really hit the spot, all right. 
					Thanks again.\" ";
				else
					"He says, \"Mmmm, a hot meatball sandwich would really hit
					the spot right now. I have to work straight through lunch,
					but I could really go for a nice big sandwich.\" He sighs
					and goes back to work. ";
				return( true );
			case Laura:
				"Laura says, \"It's not lunchtime yet. Thank you, though.\" ";
			case PLaura:
				"Laura says, \"Lunch would be nice, but I guess I can't
				make the time for it today. As usual. One thing about this
				ridiculous career, it keeps me trim.\" ";
			case Blackie:
				"Blackie barks loudly. Slobber flies everywhere. ";
			default: 
				return( nil );
		}
	}
;

napkin_dispenser: unimportantItem
	sdesc = "napkin dispenser"
	noun = 'dispenser'
	adjective = 'napkin' 'paper'
	location = sandwichShop
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred laughs and says, \"Free napkin with every sandwich 
				purchase! Can't beat that.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

napkin1: napkinItem
;

napkin2: napkinItem
;

/*	The penny and the four dollars are dummy items, useless to the game, but necessary
	for the illusion that the player has bought the correct sandwich.				*/
penny: item
	bulk = 0
	sdesc = "penny"
	ldesc = "Minted in Denver in 1975, this penny is worth one cent. "
	noun = 'penny'
	location = nil
	herring = true
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"One penny. Yep.\" ";
				return( true );
			case Laura:
				"Laura says, \"If you're making a deposit into your account,
				you might want to use whole dollars instead of pennies.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

fourDollars: moneyItem
	adjective = 'four'
	location = nil
	value = 4
	
	askingAboutMe( who ) =
	{
		if ( who = Fred )
		{
			"Fred says, \"Did I count it wrong? It's your change, four
			dollars.\" ";
			return( true );
		}
		pass askingAboutMe;
	}
;

/*********************************** end of Village ***************************/


secretPassage: room
	indoors = true
	sdesc = "Secret passage"
	ldesc = 
	{
		"The secret passage is a narrow hallway of sorts, only about twelve feet
		long and three and a half feet wide. The walls are bare plaster and 
		sheet rock. Various springs and tumblers are connected together in an 
		elegant set of mechanisms to open the doors. ";
		
		self.lightDesc;
	}
	xdesc = "The short hallway dead-ends at a crudely-carved staircase leading 
			down. There is another door to the west, and you can go out the 
			way you came in. "
	lightDesc =
	{
		if ( !secretPassageLightBulb.islit )
		{
			"A small light bulb hangs from the ceiling, but it is currently 
			turned off. ";
			
			if ( interiorSecretPassageDoor.isopen )
				"The only light in the passage is from the open door. ";
			else
				"There is barely enough light seeping in through the 
				closed door to see by. ";
		}
		else
		{
			"A small light bulb hangs from the ceiling, giving the room 
			some gentle illumnation. ";
		}
	}
	firstseen = 
	{
		incscore( 5 );
		global.scoreCard[18] := 1;
	}
	
	north =
	{
		switch( global.timeLoc )
		{
			case 3:
				return( secretChamber );
			case 4:
				return( FsecretChamber );
			case 5:
				return( laboratory );
			default: return( self.noexit );
		}
	}
	down =
	{
		switch( global.timeLoc )
		{
			case 3:
				return( secretChamber );
			case 4:
				return( FsecretChamber );
			case 5:
				return( laboratory );
			default: return( self.noexit );
		}
	}
	out = interiorSecretPassageDoor
	south = interiorSecretPassageDoor
	west = westSecretPassageDoor
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sweet. You could hide stuff there and no one
				would ever find it.\" ";
				return( true );
			case Laura:
				"Laura says, \"Cool. But does it lead anywhere? Maybe it's 
				just a good place to keep stuff.\" ";
				return( true );
			case Architect:
				"He says, \"There's not much room in the floor plan to have
				this connect throughout the house, but it will be a way in,
				and it will be a good storage area that no one else will 
				ever know about.\" He winks at you. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

secretPassageLightBulb: lightsource, switchItem
	sdesc = "light bulb"
	noun = 'fixture'
	adjective = 'light' 'bulb'
	location = secretPassage
;

/*
secretPassageWallSocket: socketItem
	adjective = 'electricity' 'wiring' 'electric' 'electrical'
	hasJuice = true
	location = secretPassage
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Architect:
				if ( blueprint.secretpassage )
					"He says, \"When the house is finished, the secret 
					passage will be all wired up.\" ";
				else
					"He says, \"Everything should be fine with the 
					house's electricity. ";
				return( true );
			default: 
				return( nil );
		}
	}
;
*/

interiorSecretPassageDoor: doorway
	sdesc = "main door"
	noun = 'door'
	adjective = 'south' 'main'
	location = secretPassage
	otherside = secretDoor
	doordest = southOfHouse
;

westSecretPassageDoor: doorway
	sdesc = "west door"
	noun = 'door'
	adjective = 'west' 'w'
	location = secretPassage
	otherside = nil
	doordest =
	{
		"The passageway seems to be blocked off by a large piece of 
		furniture, probably your dresser, because that's right where 
		you used to keep it. Perhaps the architect never told the 
		other-you (of the past) about the secret passage once the 
		house was finished. Thus, you never knew not to block it off, 
		if that makes any sense. ";
		return( nil );
	}
;

dresserObstacle: fixedBlock, floatingItem
	sdesc = "large obstacle"
	ldesc = "The passageway is blocked by your dresser. "
	noun = 'dresser'
	adjective = 'obstacle' 'large' 'furniture' 'piece' 'piece of'
	location = 
	{
		if ( westSecretPassageDoor.isopen )
			return( secretPassage );
		else return( nil );
	}
	
	verDoMove( actor ) = {}
	doMove( actor ) = { self.doPush( actor ); }
	
	verDoKick( actor ) = {}
	doKick( actor ) = { self.doPush( actor ); }
	
	verDoAttack( actor ) = {}
	doAttack( actor ) = { self.doPush( actor ); }
	
	verDoPush( actor ) = {}
	doPush( actor ) =
	{
		if ( self.pushedOnce )
			"You don't seem to be strong enough to push it out of the way. ";
		else
		{
			"You don't really want to push your dresser over. However, 
			you give it a try. After a bit of struggling and shoving, you
			discover that you really aren't strong enough to push the
			heavy dresser out of the way. ";
			
			self.pushedOnce := true;
		}
	}
;

springsAndTumblers: unimportantItem
	sdesc = "springs and tumblers"
	ldesc = "Various springs and tumblers are connected together in an elegant set 
			of mechanisms to open the doors. "
	noun = 'spring' 'tumbler'
	plural = 'springs' 'tumblers'
	isThem = true
	adjective = 'elegant' 'set' 'mechanism' 'mechanisms' 'various'
	location = secretPassage
;

crudelyCarvedStaircase: fixedBlock
	sdesc = "crudely carved staircase"
	ldesc = "The staircase doesn't seem to have been part of the architect's
			imaginings. You saw this spot when the house was being 
			constructed, and all that was here was a concrete foundation.
			An opening has been carved into the foundation, and a sloping
			tunnel has been constructed, with crude stair steps hewn out
			of the natural limestone. It is entirely unclear to you when
			this excavation took place, making its existence quite 
			mysterious. "
	noun = 'staircase'
	adjective = 'crudely' 'carved' 'concrete' 'cement' 'foundation' 'opening'
			'sloping' 'tunnel' 'crude' 'stair' 'stairs' 'step' 'steps' 
	location = secretPassage
	
	verDoClimb( actor ) = {}
	doClimb( actor ) = { self.doClimbDown( actor ); }
	verDoClimbDown( actor ) = {}
	doClimbDown( actor ) = 
	{
		switch( global.timeLoc )
		{
			case 3:
				Me.travelTo( secretChamber );
				return( true );
			case 4:
				Me.travelTo( FsecretChamber );
				return( true );
			case 5:
				Me.travelTo( laboratory );
				return( true );
			default: return( nil );
		}
	}
;

naturalLimestone: unimportantItem
	sdesc = "natural limestone"
	ldesc = "The natural limestone is what makes up most of the earth in 
			this area. "
	noun = 'limestone'
	adjective = 'natural'
	location = secretPassage
;

secretChamber: room
	indoors = true
	sdesc = "Secret chamber"
	ldesc = "Whether this nondescript room existed before the secret passage
			was made is unclear to you, but here it is now. It is made of
			concrete, about thirty feet square, with a fifteen foot ceiling. 
			The floor of room must be at least twenty feet below the ground. 
			The dim amber light, just enough to see by, seems to be coming
			from the ceiling itself, rather than any kind of recognizable
			fixture. "
	xdesc = "The only exit that you can see is back up. "
	lightDesc = "The dim amber light, just enough to see by, seems to be coming
			from the ceiling itself, rather than any kind of recognizable
			fixture. Perhaps it is a subtle technology, one you have never 
			seen before. "
	up = secretPassage
	south = secretPassage
	
	enterRoom( actor ) =
	{
		if ( !self.isseen && !FsecretChamber.isseen && Me.location != platform2 )
		{
			"You descend the stairs slowly, unsure of what you might
			find. The stairs go down deeper under the ground than you
			expected. It becomes dark and hard to see your footing, but
			as you keep going, your eyes once again find a dim source
			of light, which you follow. Finally, you reach the bottom,
			and find yourself in a ... \b";
		}
		pass enterRoom;
	}
;

chamberCeiling: fixedBlock
	sdesc = "ceiling"
	ldesc = "The dim amber light, just enough to see by, seems to be coming
			from the ceiling itself, rather than any kind of recognizable
			fixture. Perhaps it is a subtle technology, one you have never 
			seen before. "
	noun = 'ceiling'
	location = secretChamber
;



/********************************* 2nd Time Machine objects **************************/

timeMachine2: timeMachineItem
	adesc = 
	{
		"<<self.usedOnce ? "a" : "another">> <<self.sdesc>>";
		if ( not self.usedOnce )
			self.usedOnce := true;
	}
	ldesc =
	{
	 	"It's a large contraption that's about the size and shape of an engine block, 
		and made of solid metal. It sits on a platform that is welded firmly to the 
		machine itself. On the front is a knob and a large red button. On the back 
		side of it is a hinged compartment. There is a label on the knob. ";
		
		if ( self.heat > 0 )
		{
			"You feel heat radiating from the machine. ";
		}

		
		if ( self.isDusty )
			"The machine is covered by a layer of dust, as if it had been
			sitting here for some time. ";
		
		if ( itemcnt( platform2.contents ) )
		{
			"On "; platform2.thedesc; " %you% see%s% ";
			listcont( platform2 ); ". ";
		}
	}
	adjective = 'other' 'second'
	location = secretChamber
	isDusty = true
	
	ioPutIn -> platform2
	ioPutOn -> platform2
	doSiton -> platform2
	doJumpOn -> platform2
	doEnter -> platform2
	doStandon -> platform2
	doBoard -> platform2
	doUnboard -> platform2
	doBlow -> machineDust
	doBlowOn -> machineDust
	
	verDoClean( actor ) = 
	{
		if ( not self.isDusty )
			pass verDoClean;
	}
	doClean( actor ) =
	{
		"The machine looks a little cleaner now. ";
		self.isDusty := nil;	
	}
	
	doCleanWith( actor, io ) =
	{
		"The machine looks a little cleaner now. ";
		self.isDusty := nil;	
	}
	
	moveTimeMachine2( newLocation ) =
	{
		self.moveInto( newLocation );
		timeKnob2.moveInto( newLocation );
		platform2.moveInto( newLocation );
		
		self.heat := 8;								// heat up the time machine
		setdaemon( coolOffDaemon, self );					// start it cooling off
		addword( self, &adjective, 'heat' );
		
		compartment2.heat := 15;							// the compartment gets extremely hot
		setdaemon( coolOffDaemon, compartment2 );
		addword( compartment2, &adjective, 'heat' );
		
		if ( length( compartment2.contents ) > 0 )				// if there's something inside
		{
			local i, l;
			l := compartment2.contents;
			
			for( i:=1; i <= length(l); i++ )
			{
				l[i].heat := 12;
				setdaemon( coolOffDaemon, l[i] );
				addword( l[i], &adjective, 'heat' );
			}
		}
	}
;

machineDust: fixedBlock
	sdesc = "layer of dust"
	ldesc = "The machine is covered by a layer of dust, as if it had been
			sitting here for some time. "
	noun = 'dust'
	adjective = 'layer' 'layer of'
	location = timeMachine2
	
	verDoTake( actor ) = { timeMachine2.doClean( actor ); }
	
	verDoBlow( actor ) = {}
	doBlow( actor ) = { self.doBlowOn( actor ); }
	verDoBlowOn( actor ) = {}
	doBlowOn( actor ) =
	{
		"You blow on the layer of dust. It swirls away, and the machine looks 
		a little cleaner now. ";
		timeMachine2.isDusty := nil;
	}
	doClean -> timeMachine2
	doCleanWith -> timeMachine2
	dobjGen(a, v, i, p) =
	{
		if ( not timeMachine2.isDusty )
		{
			"You already cleaned away the dust. ";
			self.moveInto( nil );
			exit;
		}
	}
	iobjGen(a, v, d, p) = { self.dobjGen(a, v, d, p); }
;

alertLight2: alertLightItem
	location = timeMachine2
;

platform2: platformItem
	location = secretChamber
	up = { self.getOff( true ); return( self.location.up ); }
	south = { self.getOff( true ); return( self.location.south ); }
	west = { self.getOff( true ); return( self.location.west ); }
	noexit = { return( self.location.noexit ); }
	getOff( val ) =
	{
		if ( Me.location = self )
		{
			if ( val )
				"(first getting off the platform) \n";
			self.doUnboard( Me );
		}
	}
	out = { self.getOff( nil ); return( nil ); }
	reachable = ([timeMachine2 timeKnob2 timeButton2 dialLabel2 compartment2 alertLight2 ] 
			+ self + self.contents + compartment2.contents + timeTravel +
			self.location + self.location.contents )
	doStandon( actor ) =
	{
		"Okay, %you're% now standing on "; self.thedesc; ". ";
		actor.travelTo( self );
		timeButton2.onPlatform := true;
	}
	doUnboard( actor ) =
	{
		"Okay, %you're% no longer on "; self.thedesc; ". ";
		self.leaveRoom( actor );
		actor.moveInto( self.location );
		timeButton2.onPlatform := nil;					// reset platform flag
	}
;

timeKnob2: timeKnobItem
	location = secretChamber
	setting = 3
;

dialLabel2: dialLabelItem
	location = timeMachine2
;

timeButton2: timeButtonItem
	location = timeMachine2
	onPlatform = nil
	
	verDoPush( actor ) =
	{
		if ( frontDoorKey.deepIsIn( platform2 ) )
		{
			"You aren't allowed to take the original front door key back in
			time with you. ";
			if ( !frontDoorKey.isIn( platform2 ) ) 
				"Hiding it isn't going to change that. ";
		}
		else if ( frontDoorKey.deepIsIn( compartment2 ) )
		{
			"You aren't allowed to take the original front door key back in
			time with you. ";
			if ( !frontDoorKey.isIn( compartment2 ) ) 
				"Hiding it isn't going to change that. ";
		}
	}
	doPush ( actor ) =
	{
		local newTimeLoc, newJumpLoc;
		
		if ( not self.pushedOnce )
			self.pushedOnce := true;
		
		"You push the big red button. Click!\b";
		
		if ( timeMachine2.heat = 0 ) 			// if the machine is cooled off
		{
			newTimeLoc := self.newTime2( timeKnob2.setting );
			switch ( newTimeLoc )
			{
				case 1:
					newJumpLoc := crystalCavern;			// Far Past
					break;
				case 2:
					newJumpLoc := brokenCavern;			// Past
					break;
				case 3:
					newJumpLoc := secretChamber;			// Present
					break;
				case 4:
					newJumpLoc := FsecretChamber;			// Future
					break;
				case 5:
					if ( newFuture.isHere )
						newJumpLoc := laboratory;		// New Future
					else
						newJumpLoc := storageRoom;		// Far Future
					break;
			}						// end switch()
			if ( self.onPlatform )			// if we're standing on the platform
	  		{
				global.timeLoc := newTimeLoc;
				self.timeJump2( actor, newJumpLoc );
			}
	   		else					// if we're not on the platform
	   		{
				if ( timeKnob2.setting = 3 )
				{
					"Nothing happens. ";
				}
				else
				{
					"The machine vibrates and heats up like a toaster oven. A 
					blinding light envelops the machine, and it vanishes in a 
					fancy puff of smoke, leaving only the smell of ozone behind. ";
					
					if ( Fred.location = Me.location )
					{
						"\bFred blinks. \"Shouldn't we have gotten on that first?
						Not that it wasn't neat looking to watch it disappear.\" ";
					}
					
					timeMachine2.moveTimeMachine2( newJumpLoc );	// we might be able to find it again
				}
			}
		}														
		else												// if machine is still hot
		{
			if ( timeManual.readOnce )			// have we read the manual yet?
			{
		  		"Nothing seems to happen. You recall that the time machine manual 
				specified that the machine has a fail-safe to keep its parts from 
				fusing. You have to let it cool off before it will let you make 
				another jump. ";
			}
			else
			{
		  		"Nothing seems to happen. I wonder why. ";
			}
		}
	}									// end doPush
	timeJump2( actor, newLoc ) =
	{
		local goodJump;
		
		goodJump := self.printTimeMessage2( global.timeLoc, timeKnob2.setting );
		
		if ( goodJump )									// valid jump?
		{
			timeMachine2.moveTimeMachine2( newLoc );
			actor.travelTo( newLoc );
			actor.moveInto( platform2 );
			if ( global.moneyLostDuringJump )
			{
				"\bUnfortunately, you lost all of your money during the time jump. 
				You should probably take steps to prevent that from happening next 
				time. ";
				global.moneyLostDuringJump := nil;
			}
		}
	}
	newTime2( setting ) =
	{
		local oldTime, newTime;
		
		oldTime := global.timeLoc;
		
		switch ( setting )
		{
			case 1:
				newTime := ( oldTime - 2 );
				break;
			case 2:
				newTime := ( oldTime - 1 );
				break;
			case 3:
				newTime := oldTime;
				break;
			case 4:
				newTime := ( oldTime + 1 );
				break;
			case 5:
				newTime := ( oldTime + 2 );
				break;
		}
		
		if ( ( newTime < 1 ) or ( newTime > 5 ) )	// Restrict ourselves to legal values
		{
			newTime := oldTime;
			alertLight2.flash := true;
		}
		
		return ( newTime );
	}
	printTimeMessage2( newTimeLoc, setting ) =
	{
		if ( setting = 3 )
		{
			"Nothing seems to happen. ";
			return ( nil );
		}
		else
		{
			if ( alertLight2.flash )
			{
				"A little alert bulb on the time machine flashes briefly. Perhaps the 
				machine has a limited range, because nothing seems to happen. ";
	
				alertLight2.flash := nil;
				return ( nil );
			}
			else
			{
				"The time machine vibrates and heats up like a toaster oven. A ";
		
				if ( setting = 1 )	"deep red ";
				else if ( setting = 2 ) "dull orange ";
				else if ( setting = 4 ) "bright blue ";
				else if ( setting = 5 ) "blinding purple ";
				"light envelops you, spinning into a wild vortex 
				that suddenly vanishes, leaving you to find yourself 
				in a ... \b";
				
				return ( true );
			}
		}
	}
;

compartment2: compartmentItem
	location = timeMachine2
;


/*************************** end of 2nd time machine objects **********************/


easterEggRoom: rodroom
	sdesc = "Easter Egg Room"
	ldesc = "You find yourself in a lovely little sitting room, something 
			akin to the waiting area in an especially avuncular 
			general practicioner's office. "
	xdesc = "The only exit is out. "
	down = { return( self.out ); }
	out = 
	{
		if ( CYOA_book.deepIsIn( Me ) ) {
			"Alas, you can't take the CYOA book with you! It returns
			to its proper place. ";
			CYOA_book.moveInto( coffee_table );
		}
		"You descend from this dream back to the south roof. \b";
		return( southRoof );
	}
;

comfy_seating: staticItem, chairitem
	sdesc = "comfy seating"
	adesc = "the comfy seating"
	ldesc = "The comfy seating is for your enjoyment. "
	noun = 'seating' 'chair' 'seat' 'bench' 
	plural = 'seats' 'chairs' 'benches'
	adjective = 'comfy' 'comfortable' 'plush' 'cushioned' 'cushions' 'pillow' 'pillows'
	location = easterEggRoom
	outOfPrep = "up from"
	reachable = ([ coffee_table ] + coffee_table.contents + self + self.contents )
;

coffee_table: surface
	sdesc = "coffee table"
	ldesc = 
	{
		"The coffee table is for reading material. ";
		inherited.ldesc;
	}
	contentsVisible = true
	isqsurface = nil
	isqcontainer = nil
	noun = 'table'
	adjective = 'coffee'
	location = easterEggRoom
	contents = [CYOA_book]
	verDoTake( actor ) = 
	{
		"You can't take the coffee table. ";
	}
;

CYOA_book: readable
	sdesc = "Choose Your Own Adventure book"
	ldesc = "This is one of those paperback Choose Your Own Adventure books
			from days of yore. The copyright date says 1981, although
			you don't remember ever seeing this one before. "
	noun = 'book'
	adjective = 'choose' 'your' 'own' 'adventure' 'cyoa'
	location = coffee_table
	contentsVisible = true
	readdesc = 
	{
		"As you pick up the CYOA book and begin reading, you find yourself
		pulled quite immersively right into the story! \b\b";
		morePrompt();
		CYOA_Me.moveInto( startplace );
		parserSetMe( CYOA_Me );
		CYOA_init();
	}
;

/********************************* End of game *******************************/

finalroom: room
	sdesc = "You have won!"
	ldesc = "You step into your house at long last, head straight for your
			bedroom, and dream your dreamy dreams of one day inventing
			a time travel machine... but they're no longer just dreams,
			are they? \b\b"
	xdesc = "\n"
	firstseen = 
	{
		die();
		abort;
	}
;

endOfGameDoormat: staticItem, surface, readable, underHider
	isListed = true
	bulk = 2
	sdesc = "doormat"
	ldesc = 
	{
		"It's a bulky rectangular mat made out of thatched brown fibers. ";
		self.readdesc;
	}
	readdesc = 
	{
		"It reads, \"Welcome.\" ";
		
		if ( frontDoor.triedOnce )
		{
			if ( not self.ironyMessagePrintedOnce )
			{
				"The irony of it leaves a bad taste in your mouth. ";
				self.ironyMessagePrintedOnce := true;
			}
		}
	}
	noun = 'doormat' 'mat'
	adjective = 'welcome' 'bulky' 'rectangular' 'thatched' 'thatch' 'brown' 
		'fiber' 'fibers'
	location = nil
	autoTake = nil
	
	verIoPutUnder( actor ) = 
	{
		"There is no need to put anything else under the doormat. ";
	}
	doLookunder(actor) =
	{
		"The duplicate house key is stashed under the doormat. You'll know
		where to find it the next time this happens -- knock on wood. ";
		
		self.knockOnWoodMessagePrinted := true;
	}
	verDoTake( actor ) = 
	{
		"You really ought to leave the doormat where it is. ";
	}
	verDoCheckWith( actor, io ) = {}				// deactivate inherited response
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Always good to put out the welcome mat. It's
				usually not a good place to hide a key to the house, though.
				It's the first place burglars look.\" ";
				return( true );
			case Laura:
				"Laura says, \"I like a welcome mat.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

endOfGameKey: block
	sdesc = "key"
	ldesc = "The duplicate house key is now safely stashed under the doormat. "
	noun = 'null'
	adjective = 'duplicate' 'house' 'key'
	location = nil
	verDoTake( actor ) = 
	{
		"After everything it took to get this key and bring it here to
		put under the doormat, you ought to leave it where it is. ";
	}
;



/* eof */
