#charset "us-ascii"
/* 
 *  Copyright (c) 2006 by Kevin Forchione. All rights reserved.
 *   
 *  This file is part of the TADS 3 Relation Library Extension
 *
 *  relation_base.t
 *
 *--------------------------------------------------------------------
 *  THE TADS 3 RELATION BASE DEFINITION
 *--------------------------------------------------------------------
 */

#include "relation.h"

/*
 *  A base class for common Relation services.
 */
class RelationBase: object
{
    buildName(mask)
    {
        local str;
        
        str     = name;
        if (mask.length())
            str += '(';
        for (local i = 1; i <= mask.length(); ++i)
        {
            switch(dataType(mask[i]))
            {
                case TypeNil:
                    str += 'nil';
                    break;

                case TypeTrue:
                    str += 'true';
                    break;

                case TypeObject:
                case TypeProp:
                case TypeFuncPtr:
                case TypeNativeCode:
                case TypeEnum:
                    str += RelationPreinit.strTab[mask[i]];
                    break;

                case TypeInt:
                    str += toString(mask[i]);
                    break;

                case TypeSString:
                    str += mask[i];
                    break;

                default:
                    str += 'unknown';
            }
            if (i < mask.length())
                str += ', ';
        }
        if (mask.length())
            str += ')';

        return str;
    }
}