#ifndef __GRIDTEXT_H
//	Avoid include redundancy
#define __GRIDTEXT_H

//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Include File:	gridtext.h
//	Purpose:	implement WWW gridtext functions.
//	Remarks/Portability/Dependencies/Restrictions:
//		Callable by "C" but works through "C++" objects.
//	Revision History:
//		B.C.		Originally copied from CERN's linemode
//					browser.
//				1st rewrite to work on dos.
//				2nd rewrite to display with a turbovision
//					TScroller class in C++.
//				3rd rewrite to optimize memory usage.
//		02-01-94	created
//				4th complete rewrite to fully support a
//					binary stream design to use minimal
//					memory, disk storage for data, and
//					no display or formatting capability.
//		02-25-94	Modifications began to no longer keep
//					paragraphs, styles, and anchors in
//					memory but to actually write them
//					and their pointer values to file.

//	Constant defines
#define Uses_TNSCollection

//	Required includes
#include"textattr.h"
#include"ttempnam.h"
#include"tform.h"
#include<tv.h>
#include<fstream.h>
#include<dir.h>

extern "C"	{
#include"htext.h"
}; // externt "C"

//	Class declarations
extern "C"	{

//	The _HText "C" structure.
//	Consider the functions declared below public member functions
//	of _HText.
struct _HText	{
	//	The anchor to this HText.
	HTParentAnchor *HTPAp_node_anchor;
	//	The number of views currently looking at this HText.
	unsigned short int usi_Views;
	//	The following are just flags to determine if the HText
	//	has the specified attribute.
	Boolean B_hasParagraph;
	Boolean B_hasStyle;
	//	The stream associated with this HText where all static data
	//	will be written.
	fstream *fsp_image;
	//	The name of the above stream.
	TTempName *TTNp_fspname;
	//	Wether or not the HText is currently being loaded.
	Boolean B_isLoading;
	//	Wether or not the HText is currently inside of a Form while
	//		rendering....
	BOOLEAN B_inForm;
};

//	Create a new HText object.
extern HText *HText_new(HTParentAnchor *HTPAp_anchor);
//	Create a new HText object with redirection, not supported.
extern HText *HText_new2(HTParentAnchor *HTPAp_anchor, HTStream *HTSp_stream);
//	Free up a HText object.
extern void HText_free(HText *HTp_text);
//	Prepare a HText object for appending of data.
extern void HText_beginAppend(HText *HTp_text);
//	End the apppending of data to a HText object.
extern void HText_endAppend(HText *HTp_text);
//	Prepare a HText object for a new paragraph.
#define HText_beginParagraph HText_appendParagraph
extern void HText_appendParagraph(HText *HTp_text);
//	End the appending of a paragraph to a HText object.
extern void HText_endParagraph(HText *HTp_text);
//	Prepare a HText object for a new style.
#define HText_beginStyle HText_setStyle
extern void HText_setStyle(HText *HTp_text, HTStyle *HTSp_style);
//	End the current style of a HText object.
extern void HText_endStyle(HText *HTp_text);
//	Prepare a HText object for a new anchor.
extern void HText_beginAnchor(HText *HTp_text, HTChildAnchor *HTCAp_anchor);
//	End the current anchor of a HText object.
extern void HText_endAnchor(HText *HTp_text);
//	Append a character to a HText object.
extern void HText_appendCharacter(HText *HTp_text, char c_append);
//	Append a image to a HText object.
extern void HText_appendImage(HText *text, HTChildAnchor *anc,
	CONST char *alternative_text, int alignment, BOOL isMap);
//	Append a string to a HText object.
extern void HText_appendText(HText *HTp_text, const char *cp_append);
//	Select an anchor in a HText object.
extern BOOL HText_selectAnchor(HText *HTp_text, HTChildAnchor *HTCAp_anchor);
//	Select a HText object for display NOW.
extern BOOL HText_select(HText *HTp_text);
//	Begin a Form
extern void HText_beginForm(HText *HTp_text, char *cp_action, char
	*cp_enctype, char *cp_method);
//	End a form.
extern void HText_endForm(HText *HTp_text);

}; // extern "C"

//	Global variable declarations

//	Macros

#endif // __GRIDTEXT_H
