#ifndef __TURLVIEW_H
//	Avoid include redundancy
#define __TURLVIEW_H

//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Include File:	turlview.h
//	Purpose:	Class declaration of TURLView
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created

//	Constant defines
#define Uses_TScroller
#define Uses_TRect
#define Uses_TEvent

//	Required includes
#include<tv.h>
#ifdef __STDARG_H	//	This to avoid an include error directive
#undef __STDARG_H	//	That is not needed in turlvie9.cpp
#endif // __STDARG_H
#include"gridtext.h"
#include"textattr.h"
#include"ttempnam.h"

//	Class declarations
extern "C"	{
//	Ensure struct is a "C" structure.  No extras.
struct Line	{
	signed short int ssi_indent;
	signed short int ssi_length;
};
};

class TURLView : public TScroller	{
public:
	TURLView(const TRect& TR_bounds, TScrollBar *TSB_x, TScrollBar *TSB_y,
		const char *cp_URL, const char *cp_Index = NULL);
	~TURLView();
	Boolean valid(unsigned short int usi_command);
	void draw();
	void scrollDraw();
	void handleEvent(TEvent& TE_event);
	const char *getTitle();
	char *getURL();
	char *getChild();
	void registerText(HText *HTp_doc);
	Boolean selectAnchor(HTChildAnchor *HTCAp_anchor);
	virtual void shutDown();
	Boolean isIndex();
	void DoNotDisplay();
	void isImage(const char *cp_imagefile);
	Boolean isDownload();
private:
	Boolean B_download;
	Boolean B_valid;
	Boolean loadURL(const char *cp_URL, const char *cp_Index = NULL);
	void LoadChild();
	void LoadParent();
	unsigned short int HTMLColor(signed long int sli_chars, unsigned
		short int usi_colorindex);
	void AnchorInView();
	Boolean AnchorSelectXYView(signed short int ssi_x, signed short int
		ssi_y);
	void AnchorSelectNext();
	void AnchorSelectPrevious();
	HText *HTp_HyperDoc;
	TextAttribute *TAp_selected;
	TTempName *TTNp_temp;
	fstream *fsp_temp;
	void FormatHTML();
	void blank_lines(signed short int ssi_blanks);
	void beginAnchor(const HTChildAnchor *HTCAp_anchor);
	void endAnchor();
	void appendCharacter(char c_append);
	void adjustSelected();
	void split_line(signed short int ssi_cutoff);
	Line *L_last, *L_new;
	Boolean B_line_1;
	signed short int ssi_splitAt;
	HTStyle *HTSp_style;
	TNSCollection *TNSCp_lines;
	TNSCollection *TNSCp_anchors;
	fstream *fsp_image;
	Boolean B_avoidinfinite;
	HTChildAnchor *HTCAp_2BSelected;
	Boolean B_lastSpace;
	Boolean B_collapseSpaces;
	void save(const char *cp_filename = NULL, const Boolean B_appendff =
		False);
	void print();
	void search(const char *cp_searchFor = NULL);
	unsigned short int usi_lastSearchLine;
	unsigned short int usi_lastSearchOffset;
	TextAttribute *TAp_search;
	signed short int ssi_fasterpussycat;
	char *cp_imagename;
	void addToHotList();
};

//	Global variable declarations

//	Macros
#include"globals.h"

#define TextColor (::usia_TextColor[usi_colorindex])
#define AnchorColor (::usia_AnchorColor[usi_colorindex])
#define SelectedColor (::usia_SelectedColor[usi_colorindex])
#define SearchColor (::usia_SearchColor[usi_colorindex])
#define SearchSelectedColor (::usia_SearchSelectedColor[usi_colorindex])

#endif // __TURLVIEW_H
