//	Copyright (c) 1993, University of Kansas, All Rights Reserved
#include"tdoslynx.h"
#include"globals.h"
#include"memstrat.h"
#include<stdlib.h>

extern int main(int i_argc, char **cpp_argv)	{
//	Purpose:	Program entry, execution, exit
//	Arguments:	argc	number of command line arguments
//			argv	the command line arguments
//	Return Value:	int	errorlevel returned to dos
//	Remarks/Portability/Dependencies/Restrictions:
//		Options can be specified on the command line.
//	Revision History:
//		12-09-93	created

	//	Here, override the default DOS memory allocation routine to
	//	do what we want.  Save the value and restore it upon return
	//	to DOS.
	StrategyType ST_old = getMemoryAllocationStrategy();
	setMemoryAllocationStrategy(firstFit);

	//	Fill up the really safe pool with memory.
	for(register signed short int ssi_counter = 0; ssi_counter < RSP_NUM;
		ssi_counter++)
	{
		really_safe_pool[ssi_counter] = (char *)malloc(RSP_SIZE);
	}

	//	Create our one and only application object.
	TDosLynx TDL(i_argc, cpp_argv);

	//	Execute the body of the program then retrun to dos.
	TDL.run();

	//	Free up any parts of our really safe pool not already
	//	deallocated.
	for(ssi_counter = 0; ssi_counter < RSP_NUM; ssi_counter++)	{
		if(really_safe_pool[ssi_counter] != NULL)	{
			free(really_safe_pool[ssi_counter]);
		}
	}

	//	Back to dos.
	setMemoryAllocationStrategy(ST_old);
	return(0);
}